package jp.sourceforge.glad.collection;

import junit.framework.TestCase;

public class SetAdapterTest extends TestCase {

    public void testAddAll() {
        SetAdapter<String> set = new SetAdapter<String>()
            .addAll("1", "4", "3", "2", "4");
        assertAdapterEquals("[1, 4, 3, 2]", set);
        assertSame(set, set.addAll("b", "a"));
        assertAdapterEquals("[1, 4, 3, 2, b, a]", set);
    }

    static void assertAdapterEquals(String expected, SetAdapter<?> actual) {
        assertEquals(expected, actual.toString());
    }

}
