package jp.sourceforge.glad.collection;

import junit.framework.TestCase;

public class SortedMapAdapterTest extends TestCase {

    public void testPut() {
        SortedMapAdapter<Integer, String> ma =
                new SortedMapAdapter<Integer, String>()
            .put(1, "a")
            .put(4, "b")
            .put(3, "c")
            .put(2, "d")
            .put(4, "e");
        assertAdapterEquals("{1=a, 2=d, 3=c, 4=e}", ma);
        assertSame(ma, ma.put(6, "f").put(5, "g"));
        assertAdapterEquals("{1=a, 2=d, 3=c, 4=e, 5=g, 6=f}", ma);
    }

    static void assertAdapterEquals(String expected, MapAdapter<?, ?> actual) {
        assertEquals(expected, actual.toString());
    }

}
