package jp.sourceforge.glad.collection.iteration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import jp.sourceforge.glad.collection.closure.ClosureSupport;
import jp.sourceforge.glad.collection.function.Function;
import junit.framework.TestCase;

public class MapKeysIterationHandlerTest extends TestCase {

    MapKeysIterationHandler<String> handler;

    protected void setUp() throws Exception {
        Map<String, Long> source = new TreeMap<String, Long>();
        source.put("a", 1L);
        source.put("c", 2L);
        source.put("b", 3L);
        handler = new MapKeysIterationHandler<String>(source);
    }

    protected void tearDown() throws Exception {
        handler = null;
    }

    public void testIterate() {
        final List<String> target = new ArrayList<String>();
        handler.iterate(new ClosureSupport<String>() {
            public void execute(String each) {
                target.add(each);
            }
        });
        assertEquals(3, target.size());
        assertEquals("[a, b, c]", target.toString());
    }

    public void testConvert() {
        Map<String, Long> source = new TreeMap<String, Long>();
        source.put("1", 1L);
        source.put("3", 2L);
        source.put("2", 3L);
        handler = new MapKeysIterationHandler<String>(source);
        IterationHandler<Double> adapter =
                new IterationHandlerAdapter<String, Double>(
                        new MapKeysIterationHandler<String>(source),
        new Function<String, Double>() {
            public Double apply(String source) {
                return Double.parseDouble(source);
            }
        });
        final List<Double> target = new ArrayList<Double>();
        adapter.iterate(new ClosureSupport<Double>() {
            public void execute(Double each) {
                target.add(each);
            }
        });
        assertEquals(3, target.size());
        assertEquals("[1.0, 2.0, 3.0]", target.toString());
    }

}
