package jp.sourceforge.glad.util;

import junit.framework.TestCase;

/**
 * {@link Range} の単体テスト。
 * 
 * @author GLAD!!
 */
public class RangeTest extends TestCase {

    /**
     * (-∞, +∞) のテスト。
     */
    public void testUniversal() {
        Range<Double> range = new Range<Double>(null, null);
        assertFalse(range.contains(null));
        assertTrue(range.contains(-1.1));
        assertTrue(range.contains(-1.0));
        assertTrue(range.contains(-0.9));
        assertTrue(range.contains(1.9));
        assertTrue(range.contains(2.0));
        assertTrue(range.contains(2.1));
        
        assertFalse(range.includes(null));
        assertTrue(range.includes(new Range<Double>(-1.0, 2.0)));
        assertTrue(range.includes(new Range<Double>(null, null)));
        
        assertFalse(range.overlaps(null));
        assertTrue(range.overlaps(new Range<Double>(-1.0, 2.0)));
        assertTrue(range.overlaps(new Range<Double>(null, null)));
        
        assertEquals("(null, null)", range.toString());
    }

    /**
     * (-∞, b) のテスト。
     */
    public void testLT() {
        Range<Double> range = new Range<Double>(null, 2.0);
        assertFalse(range.contains(null));
        assertTrue(range.contains(-1.1));
        assertTrue(range.contains(-1.0));
        assertTrue(range.contains(-0.9));
        assertTrue(range.contains(1.9));
        assertFalse(range.contains(2.0));
        assertFalse(range.contains(2.1));
        
        assertFalse(range.includes(null));
        assertTrue(range.includes(new Range<Double>(1.0, 1.9, true)));
        assertTrue(range.includes(new Range<Double>(1.0, 2.0, false)));
        assertFalse(range.includes(new Range<Double>(1.0, 2.0, true)));
        assertFalse(range.includes(new Range<Double>(1.0, 2.1, false)));
        assertFalse(range.includes(new Range<Double>(null, null)));
        
        assertFalse(range.overlaps(null));
        assertTrue(range.overlaps(new Range<Double>(1.9, false, 3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.0, true,  3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.0, false, 3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.1, true,  3.0, false)));
        assertTrue(range.overlaps(new Range<Double>(null, null)));
        
        assertEquals("(null, 2.0)", range.toString());
    }

    /**
     * (-∞, b] のテスト。
     */
    public void testLE() {
        Range<Double> range = new Range<Double>(null, 2.0, true);
        assertFalse(range.contains(null));
        assertTrue(range.contains(-1.1));
        assertTrue(range.contains(-1.0));
        assertTrue(range.contains(-0.9));
        assertTrue(range.contains(1.9));
        assertTrue(range.contains(2.0));
        assertFalse(range.contains(2.1));
        
        assertFalse(range.includes(null));
        assertTrue(range.includes(new Range<Double>(1.0, 1.9, true)));
        assertTrue(range.includes(new Range<Double>(1.0, 2.0, false)));
        assertTrue(range.includes(new Range<Double>(1.0, 2.0, true)));
        assertFalse(range.includes(new Range<Double>(1.0, 2.1, false)));
        assertFalse(range.includes(new Range<Double>(null, null)));
        
        assertFalse(range.overlaps(null));
        assertTrue(range.overlaps(new Range<Double>(1.9, false, 3.0, false)));
        assertTrue(range.overlaps(new Range<Double>(2.0, true,  3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.0, false, 3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.1, true,  3.0, false)));
        assertTrue(range.overlaps(new Range<Double>(null, null)));
        
        assertEquals("(null, 2.0]", range.toString());
    }

    /**
     * (a, +∞) のテスト。
     */
    public void testGT() {
        Range<Double> range = new Range<Double>(-1.0, false, null, false);
        assertFalse(range.contains(null));
        assertFalse(range.contains(-1.1));
        assertFalse(range.contains(-1.0));
        assertTrue(range.contains(-0.9));
        assertTrue(range.contains(1.9));
        assertTrue(range.contains(2.0));
        assertTrue(range.contains(2.1));
        
        assertFalse(range.includes(null));
        assertFalse(range.includes(new Range<Double>(-1.1, false, 0.0, false)));
        assertFalse(range.includes(new Range<Double>(-1.0, true,  0.0, false)));
        assertTrue(range.includes(new Range<Double>(-1.0, false, 0.0, false)));
        assertTrue(range.includes(new Range<Double>(-0.9, true,  0.0, false)));
        assertFalse(range.includes(new Range<Double>(null, null)));
        
        assertFalse(range.overlaps(null));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.1, true)));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.0, false)));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.0, true)));
        assertTrue(range.overlaps(new Range<Double>(-2.0, -0.9, false)));
        assertTrue(range.overlaps(new Range<Double>(null, null)));
        
        assertEquals("(-1.0, null)", range.toString());
    }

    /**
     * [a, +∞) のテスト。
     */
    public void testGE() {
        Range<Double> range = new Range<Double>(-1.0, null);
        assertFalse(range.contains(null));
        assertFalse(range.contains(-1.1));
        assertTrue(range.contains(-1.0));
        assertTrue(range.contains(-0.9));
        assertTrue(range.contains(1.9));
        assertTrue(range.contains(2.0));
        assertTrue(range.contains(2.1));
        
        assertFalse(range.includes(null));
        assertFalse(range.includes(new Range<Double>(-1.1, false, 0.0, false)));
        assertTrue(range.includes(new Range<Double>(-1.0, true,  0.0, false)));
        assertTrue(range.includes(new Range<Double>(-1.0, false, 0.0, false)));
        assertTrue(range.includes(new Range<Double>(-0.9, true,  0.0, false)));
        assertFalse(range.includes(new Range<Double>(null, null)));
        
        assertFalse(range.overlaps(null));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.1, true)));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.0, false)));
        assertTrue(range.overlaps(new Range<Double>(-2.0, -1.0, true)));
        assertTrue(range.overlaps(new Range<Double>(-2.0, -0.9, false)));
        assertTrue(range.overlaps(new Range<Double>(null, null)));
        
        assertEquals("[-1.0, null)", range.toString());
    }

    /**
     * (a, b) のテスト。
     */
    public void testOpen() {
        Range<Double> range = new Range<Double>(-1.0, false, 2.0, false);
        assertFalse(range.contains(null));
        assertFalse(range.contains(-1.1));
        assertFalse(range.contains(-1.0));
        assertTrue(range.contains(-0.9));
        assertTrue(range.contains(1.9));
        assertFalse(range.contains(2.0));
        assertFalse(range.contains(2.1));
        
        assertFalse(range.includes(null));
        assertFalse(range.includes(new Range<Double>(-1.1, false, 0.0, false)));
        assertFalse(range.includes(new Range<Double>(-1.0, true,  0.0, false)));
        assertTrue(range.includes(new Range<Double>(-1.0, false, 0.0, false)));
        assertTrue(range.includes(new Range<Double>(-0.9, true,  0.0, false)));
        assertTrue(range.includes(new Range<Double>(1.0, 1.9, true)));
        assertTrue(range.includes(new Range<Double>(1.0, 2.0, false)));
        assertFalse(range.includes(new Range<Double>(1.0, 2.0, true)));
        assertFalse(range.includes(new Range<Double>(1.0, 2.1, false)));
        assertFalse(range.includes(new Range<Double>(null, null)));
        
        assertFalse(range.overlaps(null));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.1, true)));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.0, false)));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.0, true)));
        assertTrue(range.overlaps(new Range<Double>(-2.0, -0.9, false)));
        assertTrue(range.overlaps(new Range<Double>(1.9, false, 3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.0, true,  3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.0, false, 3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.1, true,  3.0, false)));
        assertTrue(range.overlaps(new Range<Double>(null, null)));
        
        assertEquals("(-1.0, 2.0)", range.toString());
    }

    /**
     * (a, b] のテスト。
     */
    public void testLeftOpen() {
        Range<Double> range = new Range<Double>(-1.0, false, 2.0, true);
        assertFalse(range.contains(null));
        assertFalse(range.contains(-1.1));
        assertFalse(range.contains(-1.0));
        assertTrue(range.contains(-0.9));
        assertTrue(range.contains(1.9));
        assertTrue(range.contains(2.0));
        assertFalse(range.contains(2.1));
        
        assertFalse(range.includes(null));
        assertFalse(range.includes(new Range<Double>(-1.1, false, 0.0, false)));
        assertFalse(range.includes(new Range<Double>(-1.0, true,  0.0, false)));
        assertTrue(range.includes(new Range<Double>(-1.0, false, 0.0, false)));
        assertTrue(range.includes(new Range<Double>(-0.9, true,  0.0, false)));
        assertTrue(range.includes(new Range<Double>(1.0, 1.9, true)));
        assertTrue(range.includes(new Range<Double>(1.0, 2.0, false)));
        assertTrue(range.includes(new Range<Double>(1.0, 2.0, true)));
        assertFalse(range.includes(new Range<Double>(1.0, 2.1, false)));
        assertFalse(range.includes(new Range<Double>(null, null)));
        
        assertFalse(range.overlaps(null));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.1, true)));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.0, false)));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.0, true)));
        assertTrue(range.overlaps(new Range<Double>(-2.0, -0.9, false)));
        assertTrue(range.overlaps(new Range<Double>(1.9, false, 3.0, false)));
        assertTrue(range.overlaps(new Range<Double>(2.0, true,  3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.0, false, 3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.1, true,  3.0, false)));
        assertTrue(range.overlaps(new Range<Double>(null, null)));
        
        assertEquals("(-1.0, 2.0]", range.toString());
    }

    /**
     * [a, b) のテスト。
     */
    public void testRightOpen() {
        Range<Double> range = new Range<Double>(-1.0, 2.0);
        assertFalse(range.contains(null));
        assertFalse(range.contains(-1.1));
        assertTrue(range.contains(-1.0));
        assertTrue(range.contains(-0.9));
        assertTrue(range.contains(1.9));
        assertFalse(range.contains(2.0));
        assertFalse(range.contains(2.1));
        
        assertFalse(range.includes(null));
        assertFalse(range.includes(new Range<Double>(-1.1, false, 0.0, false)));
        assertTrue(range.includes(new Range<Double>(-1.0, true,  0.0, false)));
        assertTrue(range.includes(new Range<Double>(-1.0, false, 0.0, false)));
        assertTrue(range.includes(new Range<Double>(-0.9, true,  0.0, false)));
        assertTrue(range.includes(new Range<Double>(1.0, 1.9, true)));
        assertTrue(range.includes(new Range<Double>(1.0, 2.0, false)));
        assertFalse(range.includes(new Range<Double>(1.0, 2.0, true)));
        assertFalse(range.includes(new Range<Double>(1.0, 2.1, false)));
        assertFalse(range.includes(new Range<Double>(null, null)));
        
        assertFalse(range.overlaps(null));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.1, true)));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.0, false)));
        assertTrue(range.overlaps(new Range<Double>(-2.0, -1.0, true)));
        assertTrue(range.overlaps(new Range<Double>(-2.0, -0.9, false)));
        assertTrue(range.overlaps(new Range<Double>(1.9, false, 3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.0, true,  3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.0, false, 3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.1, true,  3.0, false)));
        assertTrue(range.overlaps(new Range<Double>(null, null)));
        
        assertEquals("[-1.0, 2.0)", range.toString());
    }

    /**
     * [a, b] のテスト。
     */
    public void testRightClosed() {
        Range<Double> range = new Range<Double>(-1.0, 2.0, true);
        assertFalse(range.contains(null));
        assertFalse(range.contains(-1.1));
        assertTrue(range.contains(-1.0));
        assertTrue(range.contains(-0.9));
        assertTrue(range.contains(1.9));
        assertTrue(range.contains(2.0));
        assertFalse(range.contains(2.1));
        
        assertFalse(range.includes(null));
        assertFalse(range.includes(new Range<Double>(-1.1, false, 0.0, false)));
        assertTrue(range.includes(new Range<Double>(-1.0, true,  0.0, false)));
        assertTrue(range.includes(new Range<Double>(-1.0, false, 0.0, false)));
        assertTrue(range.includes(new Range<Double>(-0.9, true,  0.0, false)));
        assertTrue(range.includes(new Range<Double>(1.0, 1.9, true)));
        assertTrue(range.includes(new Range<Double>(1.0, 2.0, false)));
        assertTrue(range.includes(new Range<Double>(1.0, 2.0, true)));
        assertFalse(range.includes(new Range<Double>(1.0, 2.1, false)));
        assertFalse(range.includes(new Range<Double>(null, null)));
        
        assertFalse(range.overlaps(null));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.1, true)));
        assertFalse(range.overlaps(new Range<Double>(-2.0, -1.0, false)));
        assertTrue(range.overlaps(new Range<Double>(-2.0, -1.0, true)));
        assertTrue(range.overlaps(new Range<Double>(-2.0, -0.9, false)));
        assertTrue(range.overlaps(new Range<Double>(1.9, false, 3.0, false)));
        assertTrue(range.overlaps(new Range<Double>(2.0, true,  3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.0, false, 3.0, false)));
        assertFalse(range.overlaps(new Range<Double>(2.1, true,  3.0, false)));
        assertTrue(range.overlaps(new Range<Double>(null, null)));
        
        assertEquals("[-1.0, 2.0]", range.toString());
    }

}
