package com.example.bookstore.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

import com.example.bookstore.CatalogService;
import com.example.bookstore.model.Book;

public class CatalogServiceImpl implements CatalogService, InitializingBean {

    static final Log log = LogFactory.getLog(CatalogServiceImpl.class);

    Map<Long, Book> catalog = new LinkedHashMap<Long, Book>();

    long lastBookId = 1000;

    public void afterPropertiesSet() throws Exception {
        
        // TODO Auto-generated method stub
        
    }

    public Collection<Book> getBooks() {
        return new ArrayList<Book>(catalog.values());
    }

    public Book getBook(long bookId) {
        return catalog.get(bookId);
    }

    public Book addBook(Book book) {
        book.setId(nextBookId());
        catalog.put(book.getId(), book);
        if (log.isInfoEnabled()) {
            log.info("Add book: " + book);
        }
        return book;
    }

    long nextBookId() {
        return ++lastBookId;
    }

}
