package com.example.bookstore.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import com.example.bookstore.util.BookStoreUtils;

public class Order {

    long id;

    Customer customer;

    Date date;

    List<OrderDetail> details;

    public Order() {
    }

    public Order(Customer customer, Date date) {
        this.customer = customer;
        this.date = date;
    }

    public Order(Customer customer, Date date, OrderDetail... details) {
        this(customer, date, Arrays.asList(details));
    }

    public Order(Customer customer, Date date, List<OrderDetail> details) {
        this(customer, date);
        setDetails(details);
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public List<OrderDetail> getDetails() {
        if (details == null) {
            details = new ArrayList<OrderDetail>();
        }
        return details;
    }

    public void setDetails(List<OrderDetail> details) {
        for (OrderDetail detail : details) {
            detail.setOrder(this);
        }
        this.details = new ArrayList<OrderDetail>(details);
    }

    public void addDetail(OrderDetail detail) {
        detail.setOrder(this);
        getDetails().add(detail);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" {id=").append(id);
        sb.append(", customer=").append(customer);
        sb.append(", date=").append(BookStoreUtils.toDateString(date));
        sb.append(", details=").append(details);
        sb.append("}");
        return sb.toString();
    }

}
