package com.example.mule.transformer;

import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;

import com.example.mule.util.MuleExampleUtils;

public class LoggingTransformer extends AbstractMessageAwareTransformer {

    public Object transform(MuleMessage message, String outputEncoding)
            throws TransformerException {
        if (logger.isInfoEnabled()) {
            MuleExampleUtils.logMessage(logger, "Transform: ", message);
        }
        return message;
    }

}
