#
# LinearGraph.rb
#
# Copyright (C) 2010 GLAD!! (ITO Yoshiichi)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. See the License for the specific language
# governing permissions and limitations under the License.
#

class LinearGraph

  attr_reader :values, :points, :lines, :level

  def initialize(points, base = nil)
    @values = make_values(base, points)
    @points = make_points(base, points)
    @lines = @values - @points
    @level = 2 ** @points.size
  end

  def make_values(base, points)
    values = base ? base.values : []
    points.each {|p|
      values += [p] + values.map{|x| x ^ p }
    }
    values
  end

  def make_points(base, points)
    base ? base.points + points : points
  end

  def ==(other)
    self.points == other.points
  end

  def include?(x)
    values.include?(x)
  end

  def to_s
    "[#{ points.join(', ') }#{ lines.empty? ? '' : '; ' + lines.join(', ') }]"
  end

  def inspect
    to_s
  end

end
