package jp.sourceforge.glad.org.seasar.dao.tiger.entity;

import java.io.Serializable;

import org.seasar.dao.annotation.tiger.Bean;
import org.seasar.dao.annotation.tiger.Column;

@Bean(table = "DEPT")
public class Department implements Serializable {

    private static final long serialVersionUID = 2542970871181060658L;

    protected int deptNo;

    protected String dname;

    @Column("LOC")
    protected String location;

    @Column("VERSIONNO")
    protected int version;

    protected boolean active;

    public Department() {
    }

    public Department(
            int deptNo,
            String dname,
            String location,
            boolean active) {
        this.deptNo = deptNo;
        this.dname = dname;
        this.location = location;
        this.active = active;
    }

    public int getDeptNo() {
        return deptNo;
    }

    public void setDeptNo(int deptNo) {
        this.deptNo = deptNo;
    }

    public String getDname() {
        return dname;
    }

    public void setDname(String dname) {
        this.dname = dname;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int versionNo) {
        this.version = versionNo;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public int hashCode() {
        return deptNo;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Department)) {
            return false;
        }
        Department castOther = (Department) other;
        return deptNo == castOther.deptNo;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" {deptNo=").append(deptNo);
        sb.append(", dname=").append(dname);
        sb.append(", location=").append(location);
        sb.append(", version=").append(version);
        sb.append(" ,active=").append(active);
        sb.append('}');
        return sb.toString();
    }

}
