/*
* common.h	--glent main header file
* 
* Copyright(C) 2013(Heisei 25) ttwilb All rights reserved.
* 
* This source code is released on the BSD licensing.
* 
*/

#include <stdio.h>
#include <string.h>

#define FILENAME_MAX	256

/*** toplev.c ***/

int toplev_main(int argc, const char** argv);


/*** expression.c ***/

struct Expression
{
	int aa;
};

struct Expression* alloc_expression();


/*** stream.c ***/

#define STREAM_FILE	1

struct StreamInfo
{
	int type;
	union
	{
		struct
		{
			char filename[FILENAME_MAX];
			FILE *fp;
		}file;
	};
};

struct StreamInfo open_stream_file(char fname[FILENAME_MAX]);
void close_stream(struct StreamInfo info);
char stream_nextchar(struct StreamInfo info);

/*** token.c ***/

#define NULL_TOKEN	(struct Token *)0

struct LexInfo
{
	struct StreamInfo *stream;
	char n;
};

struct Token
{

};



/* disable object mangling */
/* using this when calling C++ functions */
/*
#ifdef __cplusplus
extern "C" int toplev_main_cpp(int argc, const char** argv);
#else
extern int toplev_main_cpp(int argc, const char** argv);
#endif
*/

