#include "common.h"

/*
* stream.c	--manage stream
* 
* Copyright(C) 2013(Heisei 25) ttwilb All rights reserved.
* 
* This source code is released on the BSD licensing.
* 
*/

struct StreamInfo open_stream_file(char fname[FILENAME_MAX])
{
	struct StreamInfo res;
	strcpy(res.file.filename, fname);
	res.file.fp = fopen(fname, "r");
	res.type = STREAM_FILE;
	return res;
}

void close_stream(struct StreamInfo info)
{
	if(info.type == STREAM_FILE)
		fclose(info.file.fp);
}

char stream_nextchar(struct StreamInfo info)
{
	if(info.type == STREAM_FILE)
		return (getc(info.file.fp));
}
