#include "common.h"

/*
* token.c	--glent tokenizer
* 
* Copyright(C) 2013(Heisei 25) ttwilb All rights reserved.
* 
* This source code is released on the BSD licensing.
* 
*/

#define BLANK_CH	" \n\r\t\f\v"
#define NEWLINE_CH	"\n"

struct LexInfo open_lex(struct StreamInfo *st)
{
	struct LexInfo res;
	res.stream = st;
	res.n = stream_nextchar(*st);
}

void close_lex(struct StreamInfo *st)
{
	close_stream(*st);
}

bool pass_blank(struct LexInfo *le)
{
	bool is_in_onelinecomment = false;
	for(;;)
	{
		if(le->n == (char)0) return true;
		if(is_in_onelinecomment)
		{
			if(strstr(NEWLINE_CH, &le->n) != NULL)
			{
				is_in_onelinecomment = false;
			}
		}
		else if(strstr(BLANK_CH, &le->n) != NULL)
		{
			if(le->n == '#') is_in_onelinecomment = true;
		}
		else
		{
			break;
		}
		le->n = stream_nextchar(*le->stream);
	}
	return false;
}

struct Token* next_token(struct LexInfo *le)
{

}







