/*
 * Decompiled with CFR 0.152.
 */
package jp.co.olympus.camerakit;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import jp.co.olympus.camerakit.OLYCamera;
import jp.co.olympus.camerakit.OLYCameraKitException;
import jp.co.olympus.camerakit.OLYCameraLog;
import jp.co.olympus.camerakit.h;
import jp.co.olympus.camerakit.internal.c;
import jp.co.olympus.camerakit.internal.d;
import jp.co.olympus.camerakit.internal.e;

public class OLYCameraMaintenanceTrait {
    private OLYCamera.b a;

    protected OLYCameraMaintenanceTrait(OLYCamera.b adapter) {
        if (adapter == null) {
            throw new NullPointerException();
        }
        if (!(adapter instanceof OLYCamera.b)) {
            throw new IllegalAccessError();
        }
        this.a = adapter;
    }

    public String resetWiFiPassword(final boolean randomly) throws OLYCameraKitException {
        String newPassword;
        OLYCameraLog.i("randomly=%s", String.valueOf(randomly));
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Maintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            newPassword = this.a.a(new OLYCamera.c<String, h>(){

                @Override
                public String a(h value) throws Exception {
                    if (randomly) {
                        return value.U(10.0);
                    }
                    return value.T(10.0);
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (newPassword == null) {
            throw new AssertionError();
        }
        return newPassword;
    }

    public void resetBluetoothSettings() throws OLYCameraKitException {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Bluetooth LE.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Maintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.Y(100.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void resetLevelGauge(boolean calibration) throws OLYCameraKitException {
        OLYCameraLog.i("calibration=%s", String.valueOf(calibration));
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Maintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        final String cgiCom = calibration ? "calib" : "reset";
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.j(cgiCom, 5.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void performPixelMapping(final OLYCamera.ProgressCallback callback) {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Maintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                String result;
                e eventQueue = OLYCameraMaintenanceTrait.this.a.f();
                eventQueue.a();
                try {
                    result = OLYCameraMaintenanceTrait.this.a.a(new OLYCamera.c<String, h>(){

                        @Override
                        public String a(h value) throws Exception {
                            return value.C(10.0);
                        }
                    });
                }
                catch (Exception e2) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (!"OK".equals(result)) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera has rejected the operation.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                long timeoutInMillis = 180000L;
                c event = null;
                try {
                    event = eventQueue.a(timeoutInMillis);
                    while (event != null && event.a() != c.a.E) {
                        if (event != null && event.a() == c.a.m) {
                            float progress = ((d.f)event.c()).a();
                            if (callback != null) {
                                callback.onProgress(new OLYCamera.ProgressEvent(progress, false));
                            }
                        }
                        event = eventQueue.a(timeoutInMillis);
                    }
                }
                catch (TimeoutException e3) {
                    event = null;
                }
                if (event == null) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (event.c() != null) {
                    String pixelMappingResult = ((d.e)event.c()).a();
                    if (!"ok".equals(pixelMappingResult)) {
                        eventQueue.b();
                        OLYCameraKitException theException = new OLYCameraKitException("Executing pixel-mapping failed.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                } else {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                eventQueue.b();
                if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }

    public void restoreFactorySettings() throws OLYCameraKitException {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Maintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.u(10.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        this.a.e().clearCacheAll();
    }

    public Map<String, Object> inquireFirmwareInformation() throws OLYCameraKitException {
        String updatemode;
        Map<String, Object> fwversion;
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Maintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            fwversion = this.a.a(new OLYCamera.c<Map<String, Object>, h>(){

                @Override
                public Map<String, Object> a(h value) throws Exception {
                    return value.y(10.0);
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            updatemode = this.a.a(new OLYCamera.c<String, h>(){

                @Override
                public String a(h value) throws Exception {
                    return value.x(10.0);
                }
            });
        }
        catch (Exception e3) {
            OLYCameraKitException theException = new OLYCameraKitException(e3);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!(fwversion.containsKey("Body") && fwversion.containsKey("Body") && fwversion.containsKey("Body"))) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("Body", fwversion.get("Body"));
        result.put("Lens", fwversion.get("Lens"));
        result.put("Flash", fwversion.get("Flash"));
        result.put("mode", updatemode);
        return result;
    }

    public void updateFirmware(final byte[] firmware, final OLYCamera.ProgressCallback callback) {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Maintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        if (firmware == null || firmware.length == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'firmware' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    callback.onProgress(new OLYCamera.ProgressEvent(0.0f, false));
                }
                try {
                    OLYCameraMaintenanceTrait.this.a.a(new OLYCamera.c<Void, h>(){

                        @Override
                        public Void a(h value) throws Exception {
                            value.d(firmware.length, 10.0);
                            return null;
                        }
                    });
                }
                catch (Exception e2) {
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onProgress(new OLYCamera.ProgressEvent(0.05f, false));
                }
                int transferUnitSize = 0x100000;
                int tlen = (firmware.length + 1048575) / 0x100000;
                int triedCount = 0;
                int ti = 0;
                while (ti < tlen) {
                    final int offset = ti * 0x100000;
                    int length = 0x100000;
                    if (offset + length > firmware.length) {
                        length = firmware.length - offset;
                    }
                    final byte[] cropedData = Arrays.copyOfRange(firmware, offset, offset + length);
                    try {
                        OLYCameraMaintenanceTrait.this.a.a(new OLYCamera.c<Void, h>(){

                            @Override
                            public Void a(h value) throws Exception {
                                value.a(offset, cropedData, 10.0);
                                return null;
                            }
                        });
                    }
                    catch (Exception e3) {
                        if (++triedCount < 10) continue;
                        OLYCameraKitException theException = new OLYCameraKitException(e3);
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                    triedCount = 0;
                    ++ti;
                    if (callback == null) continue;
                    float progress = (float)ti / (float)tlen * 0.84999996f + 0.05f;
                    callback.onProgress(new OLYCamera.ProgressEvent(progress, false));
                }
                try {
                    OLYCameraMaintenanceTrait.this.a.a(new OLYCamera.c<Void, h>(){

                        @Override
                        public Void a(h value) throws Exception {
                            value.z(10.0);
                            return null;
                        }
                    });
                }
                catch (Exception e4) {
                    OLYCameraKitException theException = new OLYCameraKitException(e4);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                boolean succeeded = false;
                Date startDate = new Date();
                long timeout = 180000L;
                while (new Date().getTime() - startDate.getTime() <= timeout) {
                    String firmStatus = null;
                    try {
                        firmStatus = OLYCameraMaintenanceTrait.this.a.a(new OLYCamera.c<String, h>(){

                            @Override
                            public String a(h value) throws Exception {
                                return value.A(10.0);
                            }
                        });
                    }
                    catch (Exception e5) {
                        OLYCameraKitException theException = new OLYCameraKitException(e5);
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                    if (firmStatus.equals("Success")) {
                        succeeded = true;
                        break;
                    }
                    if (!firmStatus.equals("Busy")) break;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e6) {
                        OLYCameraKitException theException = new OLYCameraKitException(e6);
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                }
                if (!succeeded) {
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond 'Success' in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onProgress(new OLYCamera.ProgressEvent(0.95f, false));
                }
                try {
                    OLYCameraMaintenanceTrait.this.a.a(new OLYCamera.c<Void, h>(){

                        @Override
                        public Void a(h value) throws Exception {
                            value.B(10.0);
                            return null;
                        }
                    });
                }
                catch (Exception e7) {
                    OLYCameraKitException theException = new OLYCameraKitException(e7);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onProgress(new OLYCamera.ProgressEvent(1.0f, false));
                }
                if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }
}

