/*
 * Decompiled with CFR 0.152.
 */
package jp.co.olympus.camerakit;

import android.annotation.SuppressLint;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.TimeZone;
import jp.co.olympus.camerakit.OLYPublicAPI;

@OLYPublicAPI
public class OLYCameraFileInfo {
    private String a = null;
    private String b = null;
    private int c = 0;
    private Filetype d = Filetype.Unknown;
    private EnumSet<Attribute> e = EnumSet.noneOf(Attribute.class);
    private long f = 0L;
    private int g = 0;
    private int h = 0;
    private Date i = null;
    private List<String> j = null;

    @OLYPublicAPI
    public String getDirectoryPath() {
        return this.a;
    }

    @OLYPublicAPI
    public String getFilename() {
        return this.b;
    }

    @OLYPublicAPI
    public Filetype getFiletype() {
        return this.d;
    }

    @OLYPublicAPI
    public EnumSet<Attribute> getAttributes() {
        return this.e;
    }

    @OLYPublicAPI
    public long getFilesize() {
        return this.f;
    }

    @OLYPublicAPI
    public Date getDatetime() {
        return this.i;
    }

    @OLYPublicAPI
    public List<String> getExtension() {
        return this.j;
    }

    private OLYCameraFileInfo() {
    }

    public static OLYCameraFileInfo parse(String string) {
        if (string == null) {
            return null;
        }
        OLYCameraFileInfo file = new OLYCameraFileInfo();
        String[] fields = string.split(",");
        if (fields.length < 6) {
            return null;
        }
        String directory = fields[0];
        String filename = fields[1];
        long filesize = Long.parseLong(fields[2]);
        int attribute = Integer.parseInt(fields[3]);
        int fat32Date = Integer.parseInt(fields[4]);
        int fat32Time = Integer.parseInt(fields[5]);
        file.c = attribute;
        file.h = fat32Date;
        file.g = fat32Time;
        file.a = directory;
        file.b = filename;
        file.f = filesize;
        if (fields.length > 6) {
            file.j = new ArrayList<String>();
            for (int ei = 6; ei < fields.length; ++ei) {
                file.j.add(fields[ei]);
            }
        }
        if ((attribute & 0x10) != 0) {
            file.d = Filetype.Directory;
        } else {
            if ((attribute & 8) != 0) {
                return null;
            }
            file.d = Filetype.File;
        }
        if ((attribute & 1) != 0) {
            file.e.add(Attribute.Protected);
        }
        if ((attribute & 2) != 0 || filename.startsWith(".")) {
            file.e.add(Attribute.Hidden);
        }
        if (fat32Date > 0 && fat32Time >= 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(TimeZone.getDefault());
            calendar.set((fat32Date >> 9 & 0x7F) + 1980, (fat32Date >> 5 & 0xF) - 1, fat32Date & 0x1F, fat32Time >> 11 & 0x1F, fat32Time >> 5 & 0x3F, (fat32Time & 0x1F) * 2);
            file.i = calendar.getTime();
        }
        return file;
    }

    @SuppressLint(value={"DefaultLocale"})
    public String toString() {
        return String.format("%s,%s,%d,%d,%d,%d", this.a, this.b, this.f, this.c, this.h, this.g);
    }

    @OLYPublicAPI
    public static enum Attribute {
        Protected,
        Hidden;

    }

    @OLYPublicAPI
    public static enum Filetype {
        Unknown,
        Directory,
        File;

    }
}

