// unicode.c

#include <stdio.h>
#include <string.h>
#include <sys/unistd.h>
#include <psptypes.h>
#include "unicode.h"

#define ERR (0)

static const u16 S00[0x100] =
{
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
    0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
    0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
    0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xff61, 0xff62, 0xff63, 0xff64, 0xff65, 0xff66, 0xff67,
    0xff68, 0xff69, 0xff6a, 0xff6b, 0xff6c, 0xff6d, 0xff6e, 0xff6f,
    0xff70, 0xff71, 0xff72, 0xff73, 0xff74, 0xff75, 0xff76, 0xff77,
    0xff78, 0xff79, 0xff7a, 0xff7b, 0xff7c, 0xff7d, 0xff7e, 0xff7f,
    0xff80, 0xff81, 0xff82, 0xff83, 0xff84, 0xff85, 0xff86, 0xff87,
    0xff88, 0xff89, 0xff8a, 0xff8b, 0xff8c, 0xff8d, 0xff8e, 0xff8f,
    0xff90, 0xff91, 0xff92, 0xff93, 0xff94, 0xff95, 0xff96, 0xff97,
    0xff98, 0xff99, 0xff9a, 0xff9b, 0xff9c, 0xff9d, 0xff9e, 0xff9f,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

static const u16 S81[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x3000, 0x3001, 0x3002, 0xff0c, 0xff0e, 0x30fb, 0xff1a, 0xff1b,
    0xff1f, 0xff01, 0x309b, 0x309c, 0x00b4, 0xff40, 0x00a8, 0xff3e,
    0xffe3, 0xff3f, 0x30fd, 0x30fe, 0x309d, 0x309e, 0x3003, 0x4edd,
    0x3005, 0x3006, 0x3007, 0x30fc, 0x2015, 0x2010, 0xff0f, 0xff3c,
    0xff5e, 0x2225, 0xff5c, 0x2026, 0x2025, 0x2018, 0x2019, 0x201c,
    0x201d, 0xff08, 0xff09, 0x3014, 0x3015, 0xff3b, 0xff3d, 0xff5b,
    0xff5d, 0x3008, 0x3009, 0x300a, 0x300b, 0x300c, 0x300d, 0x300e,
    0x300f, 0x3010, 0x3011, 0xff0b, 0xff0d, 0x00b1, 0x00d7, 0x0000,
    0x00f7, 0xff1d, 0x2260, 0xff1c, 0xff1e, 0x2266, 0x2267, 0x221e,
    0x2234, 0x2642, 0x2640, 0x00b0, 0x2032, 0x2033, 0x2103, 0xffe5,
    0xff04, 0xffe0, 0xffe1, 0xff05, 0xff03, 0xff06, 0xff0a, 0xff20,
    0x00a7, 0x2606, 0x2605, 0x25cb, 0x25cf, 0x25ce, 0x25c7, 0x25c6,
    0x25a1, 0x25a0, 0x25b3, 0x25b2, 0x25bd, 0x25bc, 0x203b, 0x3012,
    0x2192, 0x2190, 0x2191, 0x2193, 0x3013, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x2208, 0x220b, 0x2286, 0x2287, 0x2282, 0x2283, 0x222a, 0x2229,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x2227, 0x2228, 0xffe2, 0x21d2, 0x21d4, 0x2200, 0x2203, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x2220, 0x22a5, 0x2312, 0x2202, 0x2207, 0x2261,
    0x2252, 0x226a, 0x226b, 0x221a, 0x223d, 0x221d, 0x2235, 0x222b,
    0x222c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x212b, 0x2030, 0x266f, 0x266d, 0x266a, 0x2020, 0x2021, 0x00b6,
    0x0000, 0x0000, 0x0000, 0x0000, 0x25ef, 0x0000, 0x0000, 0x0000
};

static const u16 S82[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xff10,
    0xff11, 0xff12, 0xff13, 0xff14, 0xff15, 0xff16, 0xff17, 0xff18,
    0xff19, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xff21, 0xff22, 0xff23, 0xff24, 0xff25, 0xff26, 0xff27, 0xff28,
    0xff29, 0xff2a, 0xff2b, 0xff2c, 0xff2d, 0xff2e, 0xff2f, 0xff30,
    0xff31, 0xff32, 0xff33, 0xff34, 0xff35, 0xff36, 0xff37, 0xff38,
    0xff39, 0xff3a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xff41, 0xff42, 0xff43, 0xff44, 0xff45, 0xff46, 0xff47,
    0xff48, 0xff49, 0xff4a, 0xff4b, 0xff4c, 0xff4d, 0xff4e, 0xff4f,
    0xff50, 0xff51, 0xff52, 0xff53, 0xff54, 0xff55, 0xff56, 0xff57,
    0xff58, 0xff59, 0xff5a, 0x0000, 0x0000, 0x0000, 0x0000, 0x3041,
    0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049,
    0x304a, 0x304b, 0x304c, 0x304d, 0x304e, 0x304f, 0x3050, 0x3051,
    0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059,
    0x305a, 0x305b, 0x305c, 0x305d, 0x305e, 0x305f, 0x3060, 0x3061,
    0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 0x3069,
    0x306a, 0x306b, 0x306c, 0x306d, 0x306e, 0x306f, 0x3070, 0x3071,
    0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 0x3078, 0x3079,
    0x307a, 0x307b, 0x307c, 0x307d, 0x307e, 0x307f, 0x3080, 0x3081,
    0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 0x3089,
    0x308a, 0x308b, 0x308c, 0x308d, 0x308e, 0x308f, 0x3090, 0x3091,
    0x3092, 0x3093, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

static const u16 S83[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x30a1, 0x30a2, 0x30a3, 0x30a4, 0x30a5, 0x30a6, 0x30a7, 0x30a8,
    0x30a9, 0x30aa, 0x30ab, 0x30ac, 0x30ad, 0x30ae, 0x30af, 0x30b0,
    0x30b1, 0x30b2, 0x30b3, 0x30b4, 0x30b5, 0x30b6, 0x30b7, 0x30b8,
    0x30b9, 0x30ba, 0x30bb, 0x30bc, 0x30bd, 0x30be, 0x30bf, 0x30c0,
    0x30c1, 0x30c2, 0x30c3, 0x30c4, 0x30c5, 0x30c6, 0x30c7, 0x30c8,
    0x30c9, 0x30ca, 0x30cb, 0x30cc, 0x30cd, 0x30ce, 0x30cf, 0x30d0,
    0x30d1, 0x30d2, 0x30d3, 0x30d4, 0x30d5, 0x30d6, 0x30d7, 0x30d8,
    0x30d9, 0x30da, 0x30db, 0x30dc, 0x30dd, 0x30de, 0x30df, 0x0000,
    0x30e0, 0x30e1, 0x30e2, 0x30e3, 0x30e4, 0x30e5, 0x30e6, 0x30e7,
    0x30e8, 0x30e9, 0x30ea, 0x30eb, 0x30ec, 0x30ed, 0x30ee, 0x30ef,
    0x30f0, 0x30f1, 0x30f2, 0x30f3, 0x30f4, 0x30f5, 0x30f6, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0391,
    0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399,
    0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 0x03a0, 0x03a1,
    0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03b1,
    0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8, 0x03b9,
    0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 0x03c0, 0x03c1,
    0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

static const u16 S84[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401, 0x0416,
    0x0417, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e,
    0x041f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426,
    0x0427, 0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e,
    0x042f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451, 0x0436,
    0x0437, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x0000,
    0x043e, 0x043f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445,
    0x0446, 0x0447, 0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d,
    0x044e, 0x044f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2500,
    0x2502, 0x250c, 0x2510, 0x2518, 0x2514, 0x251c, 0x252c, 0x2524,
    0x2534, 0x253c, 0x2501, 0x2503, 0x250f, 0x2513, 0x251b, 0x2517,
    0x2523, 0x2533, 0x252b, 0x253b, 0x254b, 0x2520, 0x252f, 0x2528,
    0x2537, 0x253f, 0x251d, 0x2530, 0x2525, 0x2538, 0x2542, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

static const u16 S87[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467,
    0x2468, 0x2469, 0x246a, 0x246b, 0x246c, 0x246d, 0x246e, 0x246f,
    0x2470, 0x2471, 0x2472, 0x2473, 0x2160, 0x2161, 0x2162, 0x2163,
    0x2164, 0x2165, 0x2166, 0x2167, 0x2168, 0x2169, 0x0000, 0x3349,
    0x3314, 0x3322, 0x334d, 0x3318, 0x3327, 0x3303, 0x3336, 0x3351,
    0x3357, 0x330d, 0x3326, 0x3323, 0x332b, 0x334a, 0x333b, 0x339c,
    0x339d, 0x339e, 0x338e, 0x338f, 0x33c4, 0x33a1, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x337b, 0x0000,
    0x301d, 0x301f, 0x2116, 0x33cd, 0x2121, 0x32a4, 0x32a5, 0x32a6,
    0x32a7, 0x32a8, 0x3231, 0x3232, 0x3239, 0x337e, 0x337d, 0x337c,
    0x2252, 0x2261, 0x222b, 0x222e, 0x2211, 0x221a, 0x22a5, 0x2220,
    0x221f, 0x22bf, 0x2235, 0x2229, 0x222a, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

static const u16 S88[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e9c,
    0x5516, 0x5a03, 0x963f, 0x54c0, 0x611b, 0x6328, 0x59f6, 0x9022,
    0x8475, 0x831c, 0x7a50, 0x60aa, 0x63e1, 0x6e25, 0x65ed, 0x8466,
    0x82a6, 0x9bf5, 0x6893, 0x5727, 0x65a1, 0x6271, 0x5b9b, 0x59d0,
    0x867b, 0x98f4, 0x7d62, 0x7dbe, 0x9b8e, 0x6216, 0x7c9f, 0x88b7,
    0x5b89, 0x5eb5, 0x6309, 0x6697, 0x6848, 0x95c7, 0x978d, 0x674f,
    0x4ee5, 0x4f0a, 0x4f4d, 0x4f9d, 0x5049, 0x56f2, 0x5937, 0x59d4,
    0x5a01, 0x5c09, 0x60df, 0x610f, 0x6170, 0x6613, 0x6905, 0x70ba,
    0x754f, 0x7570, 0x79fb, 0x7dad, 0x7def, 0x80c3, 0x840e, 0x8863,
    0x8b02, 0x9055, 0x907a, 0x533b, 0x4e95, 0x4ea5, 0x57df, 0x80b2,
    0x90c1, 0x78ef, 0x4e00, 0x58f1, 0x6ea2, 0x9038, 0x7a32, 0x8328,
    0x828b, 0x9c2f, 0x5141, 0x5370, 0x54bd, 0x54e1, 0x56e0, 0x59fb,
    0x5f15, 0x98f2, 0x6deb, 0x80e4, 0x852d, 0x0000, 0x0000, 0x0000
};

static const u16 S89[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9662, 0x9670, 0x96a0, 0x97fb, 0x540b, 0x53f3, 0x5b87, 0x70cf,
    0x7fbd, 0x8fc2, 0x96e8, 0x536f, 0x9d5c, 0x7aba, 0x4e11, 0x7893,
    0x81fc, 0x6e26, 0x5618, 0x5504, 0x6b1d, 0x851a, 0x9c3b, 0x59e5,
    0x53a9, 0x6d66, 0x74dc, 0x958f, 0x5642, 0x4e91, 0x904b, 0x96f2,
    0x834f, 0x990c, 0x53e1, 0x55b6, 0x5b30, 0x5f71, 0x6620, 0x66f3,
    0x6804, 0x6c38, 0x6cf3, 0x6d29, 0x745b, 0x76c8, 0x7a4e, 0x9834,
    0x82f1, 0x885b, 0x8a60, 0x92ed, 0x6db2, 0x75ab, 0x76ca, 0x99c5,
    0x60a6, 0x8b01, 0x8d8a, 0x95b2, 0x698e, 0x53ad, 0x5186, 0x0000,
    0x5712, 0x5830, 0x5944, 0x5bb4, 0x5ef6, 0x6028, 0x63a9, 0x63f4,
    0x6cbf, 0x6f14, 0x708e, 0x7114, 0x7159, 0x71d5, 0x733f, 0x7e01,
    0x8276, 0x82d1, 0x8597, 0x9060, 0x925b, 0x9d1b, 0x5869, 0x65bc,
    0x6c5a, 0x7525, 0x51f9, 0x592e, 0x5965, 0x5f80, 0x5fdc, 0x62bc,
    0x65fa, 0x6a2a, 0x6b27, 0x6bb4, 0x738b, 0x7fc1, 0x8956, 0x9d2c,
    0x9d0e, 0x9ec4, 0x5ca1, 0x6c96, 0x837b, 0x5104, 0x5c4b, 0x61b6,
    0x81c6, 0x6876, 0x7261, 0x4e59, 0x4ffa, 0x5378, 0x6069, 0x6e29,
    0x7a4f, 0x97f3, 0x4e0b, 0x5316, 0x4eee, 0x4f55, 0x4f3d, 0x4fa1,
    0x4f73, 0x52a0, 0x53ef, 0x5609, 0x590f, 0x5ac1, 0x5bb6, 0x5be1,
    0x79d1, 0x6687, 0x679c, 0x67b6, 0x6b4c, 0x6cb3, 0x706b, 0x73c2,
    0x798d, 0x79be, 0x7a3c, 0x7b87, 0x82b1, 0x82db, 0x8304, 0x8377,
    0x83ef, 0x83d3, 0x8766, 0x8ab2, 0x5629, 0x8ca8, 0x8fe6, 0x904e,
    0x971e, 0x868a, 0x4fc4, 0x5ce8, 0x6211, 0x7259, 0x753b, 0x81e5,
    0x82bd, 0x86fe, 0x8cc0, 0x96c5, 0x9913, 0x99d5, 0x4ecb, 0x4f1a,
    0x89e3, 0x56de, 0x584a, 0x58ca, 0x5efb, 0x5feb, 0x602a, 0x6094,
    0x6062, 0x61d0, 0x6212, 0x62d0, 0x6539, 0x0000, 0x0000, 0x0000
};

static const u16 S8a[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9b41, 0x6666, 0x68b0, 0x6d77, 0x7070, 0x754c, 0x7686, 0x7d75,
    0x82a5, 0x87f9, 0x958b, 0x968e, 0x8c9d, 0x51f1, 0x52be, 0x5916,
    0x54b3, 0x5bb3, 0x5d16, 0x6168, 0x6982, 0x6daf, 0x788d, 0x84cb,
    0x8857, 0x8a72, 0x93a7, 0x9ab8, 0x6d6c, 0x99a8, 0x86d9, 0x57a3,
    0x67ff, 0x86ce, 0x920e, 0x5283, 0x5687, 0x5404, 0x5ed3, 0x62e1,
    0x64b9, 0x683c, 0x6838, 0x6bbb, 0x7372, 0x78ba, 0x7a6b, 0x899a,
    0x89d2, 0x8d6b, 0x8f03, 0x90ed, 0x95a3, 0x9694, 0x9769, 0x5b66,
    0x5cb3, 0x697d, 0x984d, 0x984e, 0x639b, 0x7b20, 0x6a2b, 0x0000,
    0x6a7f, 0x68b6, 0x9c0d, 0x6f5f, 0x5272, 0x559d, 0x6070, 0x62ec,
    0x6d3b, 0x6e07, 0x6ed1, 0x845b, 0x8910, 0x8f44, 0x4e14, 0x9c39,
    0x53f6, 0x691b, 0x6a3a, 0x9784, 0x682a, 0x515c, 0x7ac3, 0x84b2,
    0x91dc, 0x938c, 0x565b, 0x9d28, 0x6822, 0x8305, 0x8431, 0x7ca5,
    0x5208, 0x82c5, 0x74e6, 0x4e7e, 0x4f83, 0x51a0, 0x5bd2, 0x520a,
    0x52d8, 0x52e7, 0x5dfb, 0x559a, 0x582a, 0x59e6, 0x5b8c, 0x5b98,
    0x5bdb, 0x5e72, 0x5e79, 0x60a3, 0x611f, 0x6163, 0x61be, 0x63db,
    0x6562, 0x67d1, 0x6853, 0x68fa, 0x6b3e, 0x6b53, 0x6c57, 0x6f22,
    0x6f97, 0x6f45, 0x74b0, 0x7518, 0x76e3, 0x770b, 0x7aff, 0x7ba1,
    0x7c21, 0x7de9, 0x7f36, 0x7ff0, 0x809d, 0x8266, 0x839e, 0x89b3,
    0x8acc, 0x8cab, 0x9084, 0x9451, 0x9593, 0x9591, 0x95a2, 0x9665,
    0x97d3, 0x9928, 0x8218, 0x4e38, 0x542b, 0x5cb8, 0x5dcc, 0x73a9,
    0x764c, 0x773c, 0x5ca9, 0x7feb, 0x8d0b, 0x96c1, 0x9811, 0x9854,
    0x9858, 0x4f01, 0x4f0e, 0x5371, 0x559c, 0x5668, 0x57fa, 0x5947,
    0x5b09, 0x5bc4, 0x5c90, 0x5e0c, 0x5e7e, 0x5fcc, 0x63ee, 0x673a,
    0x65d7, 0x65e2, 0x671f, 0x68cb, 0x68c4, 0x0000, 0x0000, 0x0000
};

static const u16 S8b[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x6a5f, 0x5e30, 0x6bc5, 0x6c17, 0x6c7d, 0x757f, 0x7948, 0x5b63,
    0x7a00, 0x7d00, 0x5fbd, 0x898f, 0x8a18, 0x8cb4, 0x8d77, 0x8ecc,
    0x8f1d, 0x98e2, 0x9a0e, 0x9b3c, 0x4e80, 0x507d, 0x5100, 0x5993,
    0x5b9c, 0x622f, 0x6280, 0x64ec, 0x6b3a, 0x72a0, 0x7591, 0x7947,
    0x7fa9, 0x87fb, 0x8abc, 0x8b70, 0x63ac, 0x83ca, 0x97a0, 0x5409,
    0x5403, 0x55ab, 0x6854, 0x6a58, 0x8a70, 0x7827, 0x6775, 0x9ecd,
    0x5374, 0x5ba2, 0x811a, 0x8650, 0x9006, 0x4e18, 0x4e45, 0x4ec7,
    0x4f11, 0x53ca, 0x5438, 0x5bae, 0x5f13, 0x6025, 0x6551, 0x0000,
    0x673d, 0x6c42, 0x6c72, 0x6ce3, 0x7078, 0x7403, 0x7a76, 0x7aae,
    0x7b08, 0x7d1a, 0x7cfe, 0x7d66, 0x65e7, 0x725b, 0x53bb, 0x5c45,
    0x5de8, 0x62d2, 0x62e0, 0x6319, 0x6e20, 0x865a, 0x8a31, 0x8ddd,
    0x92f8, 0x6f01, 0x79a6, 0x9b5a, 0x4ea8, 0x4eab, 0x4eac, 0x4f9b,
    0x4fa0, 0x50d1, 0x5147, 0x7af6, 0x5171, 0x51f6, 0x5354, 0x5321,
    0x537f, 0x53eb, 0x55ac, 0x5883, 0x5ce1, 0x5f37, 0x5f4a, 0x602f,
    0x6050, 0x606d, 0x631f, 0x6559, 0x6a4b, 0x6cc1, 0x72c2, 0x72ed,
    0x77ef, 0x80f8, 0x8105, 0x8208, 0x854e, 0x90f7, 0x93e1, 0x97ff,
    0x9957, 0x9a5a, 0x4ef0, 0x51dd, 0x5c2d, 0x6681, 0x696d, 0x5c40,
    0x66f2, 0x6975, 0x7389, 0x6850, 0x7c81, 0x50c5, 0x52e4, 0x5747,
    0x5dfe, 0x9326, 0x65a4, 0x6b23, 0x6b3d, 0x7434, 0x7981, 0x79bd,
    0x7b4b, 0x7dca, 0x82b9, 0x83cc, 0x887f, 0x895f, 0x8b39, 0x8fd1,
    0x91d1, 0x541f, 0x9280, 0x4e5d, 0x5036, 0x53e5, 0x533a, 0x72d7,
    0x7396, 0x77e9, 0x82e6, 0x8eaf, 0x99c6, 0x99c8, 0x99d2, 0x5177,
    0x611a, 0x865e, 0x55b0, 0x7a7a, 0x5076, 0x5bd3, 0x9047, 0x9685,
    0x4e32, 0x6adb, 0x91e7, 0x5c51, 0x5c48, 0x0000, 0x0000, 0x0000
};

static const u16 S8c[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x6398, 0x7a9f, 0x6c93, 0x9774, 0x8f61, 0x7aaa, 0x718a, 0x9688,
    0x7c82, 0x6817, 0x7e70, 0x6851, 0x936c, 0x52f2, 0x541b, 0x85ab,
    0x8a13, 0x7fa4, 0x8ecd, 0x90e1, 0x5366, 0x8888, 0x7941, 0x4fc2,
    0x50be, 0x5211, 0x5144, 0x5553, 0x572d, 0x73ea, 0x578b, 0x5951,
    0x5f62, 0x5f84, 0x6075, 0x6176, 0x6167, 0x61a9, 0x63b2, 0x643a,
    0x656c, 0x666f, 0x6842, 0x6e13, 0x7566, 0x7a3d, 0x7cfb, 0x7d4c,
    0x7d99, 0x7e4b, 0x7f6b, 0x830e, 0x834a, 0x86cd, 0x8a08, 0x8a63,
    0x8b66, 0x8efd, 0x981a, 0x9d8f, 0x82b8, 0x8fce, 0x9be8, 0x0000,
    0x5287, 0x621f, 0x6483, 0x6fc0, 0x9699, 0x6841, 0x5091, 0x6b20,
    0x6c7a, 0x6f54, 0x7a74, 0x7d50, 0x8840, 0x8a23, 0x6708, 0x4ef6,
    0x5039, 0x5026, 0x5065, 0x517c, 0x5238, 0x5263, 0x55a7, 0x570f,
    0x5805, 0x5acc, 0x5efa, 0x61b2, 0x61f8, 0x62f3, 0x6372, 0x691c,
    0x6a29, 0x727d, 0x72ac, 0x732e, 0x7814, 0x786f, 0x7d79, 0x770c,
    0x80a9, 0x898b, 0x8b19, 0x8ce2, 0x8ed2, 0x9063, 0x9375, 0x967a,
    0x9855, 0x9a13, 0x9e78, 0x5143, 0x539f, 0x53b3, 0x5e7b, 0x5f26,
    0x6e1b, 0x6e90, 0x7384, 0x73fe, 0x7d43, 0x8237, 0x8a00, 0x8afa,
    0x9650, 0x4e4e, 0x500b, 0x53e4, 0x547c, 0x56fa, 0x59d1, 0x5b64,
    0x5df1, 0x5eab, 0x5f27, 0x6238, 0x6545, 0x67af, 0x6e56, 0x72d0,
    0x7cca, 0x88b4, 0x80a1, 0x80e1, 0x83f0, 0x864e, 0x8a87, 0x8de8,
    0x9237, 0x96c7, 0x9867, 0x9f13, 0x4e94, 0x4e92, 0x4f0d, 0x5348,
    0x5449, 0x543e, 0x5a2f, 0x5f8c, 0x5fa1, 0x609f, 0x68a7, 0x6a8e,
    0x745a, 0x7881, 0x8a9e, 0x8aa4, 0x8b77, 0x9190, 0x4e5e, 0x9bc9,
    0x4ea4, 0x4f7c, 0x4faf, 0x5019, 0x5016, 0x5149, 0x516c, 0x529f,
    0x52b9, 0x52fe, 0x539a, 0x53e3, 0x5411, 0x0000, 0x0000, 0x0000
};

static const u16 S8d[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x540e, 0x5589, 0x5751, 0x57a2, 0x597d, 0x5b54, 0x5b5d, 0x5b8f,
    0x5de5, 0x5de7, 0x5df7, 0x5e78, 0x5e83, 0x5e9a, 0x5eb7, 0x5f18,
    0x6052, 0x614c, 0x6297, 0x62d8, 0x63a7, 0x653b, 0x6602, 0x6643,
    0x66f4, 0x676d, 0x6821, 0x6897, 0x69cb, 0x6c5f, 0x6d2a, 0x6d69,
    0x6e2f, 0x6e9d, 0x7532, 0x7687, 0x786c, 0x7a3f, 0x7ce0, 0x7d05,
    0x7d18, 0x7d5e, 0x7db1, 0x8015, 0x8003, 0x80af, 0x80b1, 0x8154,
    0x818f, 0x822a, 0x8352, 0x884c, 0x8861, 0x8b1b, 0x8ca2, 0x8cfc,
    0x90ca, 0x9175, 0x9271, 0x783f, 0x92fc, 0x95a4, 0x964d, 0x0000,
    0x9805, 0x9999, 0x9ad8, 0x9d3b, 0x525b, 0x52ab, 0x53f7, 0x5408,
    0x58d5, 0x62f7, 0x6fe0, 0x8c6a, 0x8f5f, 0x9eb9, 0x514b, 0x523b,
    0x544a, 0x56fd, 0x7a40, 0x9177, 0x9d60, 0x9ed2, 0x7344, 0x6f09,
    0x8170, 0x7511, 0x5ffd, 0x60da, 0x9aa8, 0x72db, 0x8fbc, 0x6b64,
    0x9803, 0x4eca, 0x56f0, 0x5764, 0x58be, 0x5a5a, 0x6068, 0x61c7,
    0x660f, 0x6606, 0x6839, 0x68b1, 0x6df7, 0x75d5, 0x7d3a, 0x826e,
    0x9b42, 0x4e9b, 0x4f50, 0x53c9, 0x5506, 0x5d6f, 0x5de6, 0x5dee,
    0x67fb, 0x6c99, 0x7473, 0x7802, 0x8a50, 0x9396, 0x88df, 0x5750,
    0x5ea7, 0x632b, 0x50b5, 0x50ac, 0x518d, 0x6700, 0x54c9, 0x585e,
    0x59bb, 0x5bb0, 0x5f69, 0x624d, 0x63a1, 0x683d, 0x6b73, 0x6e08,
    0x707d, 0x91c7, 0x7280, 0x7815, 0x7826, 0x796d, 0x658e, 0x7d30,
    0x83dc, 0x88c1, 0x8f09, 0x969b, 0x5264, 0x5728, 0x6750, 0x7f6a,
    0x8ca1, 0x51b4, 0x5742, 0x962a, 0x583a, 0x698a, 0x80b4, 0x54b2,
    0x5d0e, 0x57fc, 0x7895, 0x9dfa, 0x4f5c, 0x524a, 0x548b, 0x643e,
    0x6628, 0x6714, 0x67f5, 0x7a84, 0x7b56, 0x7d22, 0x932f, 0x685c,
    0x9bad, 0x7b39, 0x5319, 0x518a, 0x5237, 0x0000, 0x0000, 0x0000
};

static const u16 S8e[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x5bdf, 0x62f6, 0x64ae, 0x64e6, 0x672d, 0x6bba, 0x85a9, 0x96d1,
    0x7690, 0x9bd6, 0x634c, 0x9306, 0x9bab, 0x76bf, 0x6652, 0x4e09,
    0x5098, 0x53c2, 0x5c71, 0x60e8, 0x6492, 0x6563, 0x685f, 0x71e6,
    0x73ca, 0x7523, 0x7b97, 0x7e82, 0x8695, 0x8b83, 0x8cdb, 0x9178,
    0x9910, 0x65ac, 0x66ab, 0x6b8b, 0x4ed5, 0x4ed4, 0x4f3a, 0x4f7f,
    0x523a, 0x53f8, 0x53f2, 0x55e3, 0x56db, 0x58eb, 0x59cb, 0x59c9,
    0x59ff, 0x5b50, 0x5c4d, 0x5e02, 0x5e2b, 0x5fd7, 0x601d, 0x6307,
    0x652f, 0x5b5c, 0x65af, 0x65bd, 0x65e8, 0x679d, 0x6b62, 0x0000,
    0x6b7b, 0x6c0f, 0x7345, 0x7949, 0x79c1, 0x7cf8, 0x7d19, 0x7d2b,
    0x80a2, 0x8102, 0x81f3, 0x8996, 0x8a5e, 0x8a69, 0x8a66, 0x8a8c,
    0x8aee, 0x8cc7, 0x8cdc, 0x96cc, 0x98fc, 0x6b6f, 0x4e8b, 0x4f3c,
    0x4f8d, 0x5150, 0x5b57, 0x5bfa, 0x6148, 0x6301, 0x6642, 0x6b21,
    0x6ecb, 0x6cbb, 0x723e, 0x74bd, 0x75d4, 0x78c1, 0x793a, 0x800c,
    0x8033, 0x81ea, 0x8494, 0x8f9e, 0x6c50, 0x9e7f, 0x5f0f, 0x8b58,
    0x9d2b, 0x7afa, 0x8ef8, 0x5b8d, 0x96eb, 0x4e03, 0x53f1, 0x57f7,
    0x5931, 0x5ac9, 0x5ba4, 0x6089, 0x6e7f, 0x6f06, 0x75be, 0x8cea,
    0x5b9f, 0x8500, 0x7be0, 0x5072, 0x67f4, 0x829d, 0x5c61, 0x854a,
    0x7e1e, 0x820e, 0x5199, 0x5c04, 0x6368, 0x8d66, 0x659c, 0x716e,
    0x793e, 0x7d17, 0x8005, 0x8b1d, 0x8eca, 0x906e, 0x86c7, 0x90aa,
    0x501f, 0x52fa, 0x5c3a, 0x6753, 0x707c, 0x7235, 0x914c, 0x91c8,
    0x932b, 0x82e5, 0x5bc2, 0x5f31, 0x60f9, 0x4e3b, 0x53d6, 0x5b88,
    0x624b, 0x6731, 0x6b8a, 0x72e9, 0x73e0, 0x7a2e, 0x816b, 0x8da3,
    0x9152, 0x9996, 0x5112, 0x53d7, 0x546a, 0x5bff, 0x6388, 0x6a39,
    0x7dac, 0x9700, 0x56da, 0x53ce, 0x5468, 0x0000, 0x0000, 0x0000
};

static const u16 S8f[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x5b97, 0x5c31, 0x5dde, 0x4fee, 0x6101, 0x62fe, 0x6d32, 0x79c0,
    0x79cb, 0x7d42, 0x7e4d, 0x7fd2, 0x81ed, 0x821f, 0x8490, 0x8846,
    0x8972, 0x8b90, 0x8e74, 0x8f2f, 0x9031, 0x914b, 0x916c, 0x96c6,
    0x919c, 0x4ec0, 0x4f4f, 0x5145, 0x5341, 0x5f93, 0x620e, 0x67d4,
    0x6c41, 0x6e0b, 0x7363, 0x7e26, 0x91cd, 0x9283, 0x53d4, 0x5919,
    0x5bbf, 0x6dd1, 0x795d, 0x7e2e, 0x7c9b, 0x587e, 0x719f, 0x51fa,
    0x8853, 0x8ff0, 0x4fca, 0x5cfb, 0x6625, 0x77ac, 0x7ae3, 0x821c,
    0x99ff, 0x51c6, 0x5faa, 0x65ec, 0x696f, 0x6b89, 0x6df3, 0x0000,
    0x6e96, 0x6f64, 0x76fe, 0x7d14, 0x5de1, 0x9075, 0x9187, 0x9806,
    0x51e6, 0x521d, 0x6240, 0x6691, 0x66d9, 0x6e1a, 0x5eb6, 0x7dd2,
    0x7f72, 0x66f8, 0x85af, 0x85f7, 0x8af8, 0x52a9, 0x53d9, 0x5973,
    0x5e8f, 0x5f90, 0x6055, 0x92e4, 0x9664, 0x50b7, 0x511f, 0x52dd,
    0x5320, 0x5347, 0x53ec, 0x54e8, 0x5546, 0x5531, 0x5617, 0x5968,
    0x59be, 0x5a3c, 0x5bb5, 0x5c06, 0x5c0f, 0x5c11, 0x5c1a, 0x5e84,
    0x5e8a, 0x5ee0, 0x5f70, 0x627f, 0x6284, 0x62db, 0x638c, 0x6377,
    0x6607, 0x660c, 0x662d, 0x6676, 0x677e, 0x68a2, 0x6a1f, 0x6a35,
    0x6cbc, 0x6d88, 0x6e09, 0x6e58, 0x713c, 0x7126, 0x7167, 0x75c7,
    0x7701, 0x785d, 0x7901, 0x7965, 0x79f0, 0x7ae0, 0x7b11, 0x7ca7,
    0x7d39, 0x8096, 0x83d6, 0x848b, 0x8549, 0x885d, 0x88f3, 0x8a1f,
    0x8a3c, 0x8a54, 0x8a73, 0x8c61, 0x8cde, 0x91a4, 0x9266, 0x937e,
    0x9418, 0x969c, 0x9798, 0x4e0a, 0x4e08, 0x4e1e, 0x4e57, 0x5197,
    0x5270, 0x57ce, 0x5834, 0x58cc, 0x5b22, 0x5e38, 0x60c5, 0x64fe,
    0x6761, 0x6756, 0x6d44, 0x72b6, 0x7573, 0x7a63, 0x84b8, 0x8b72,
    0x91b8, 0x9320, 0x5631, 0x57f4, 0x98fe, 0x0000, 0x0000, 0x0000
};

static const u16 S90[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x62ed, 0x690d, 0x6b96, 0x71ed, 0x7e54, 0x8077, 0x8272, 0x89e6,
    0x98df, 0x8755, 0x8fb1, 0x5c3b, 0x4f38, 0x4fe1, 0x4fb5, 0x5507,
    0x5a20, 0x5bdd, 0x5be9, 0x5fc3, 0x614e, 0x632f, 0x65b0, 0x664b,
    0x68ee, 0x699b, 0x6d78, 0x6df1, 0x7533, 0x75b9, 0x771f, 0x795e,
    0x79e6, 0x7d33, 0x81e3, 0x82af, 0x85aa, 0x89aa, 0x8a3a, 0x8eab,
    0x8f9b, 0x9032, 0x91dd, 0x9707, 0x4eba, 0x4ec1, 0x5203, 0x5875,
    0x58ec, 0x5c0b, 0x751a, 0x5c3d, 0x814e, 0x8a0a, 0x8fc5, 0x9663,
    0x976d, 0x7b25, 0x8acf, 0x9808, 0x9162, 0x56f3, 0x53a8, 0x0000,
    0x9017, 0x5439, 0x5782, 0x5e25, 0x63a8, 0x6c34, 0x708a, 0x7761,
    0x7c8b, 0x7fe0, 0x8870, 0x9042, 0x9154, 0x9310, 0x9318, 0x968f,
    0x745e, 0x9ac4, 0x5d07, 0x5d69, 0x6570, 0x67a2, 0x8da8, 0x96db,
    0x636e, 0x6749, 0x6919, 0x83c5, 0x9817, 0x96c0, 0x88fe, 0x6f84,
    0x647a, 0x5bf8, 0x4e16, 0x702c, 0x755d, 0x662f, 0x51c4, 0x5236,
    0x52e2, 0x59d3, 0x5f81, 0x6027, 0x6210, 0x653f, 0x6574, 0x661f,
    0x6674, 0x68f2, 0x6816, 0x6b63, 0x6e05, 0x7272, 0x751f, 0x76db,
    0x7cbe, 0x8056, 0x58f0, 0x88fd, 0x897f, 0x8aa0, 0x8a93, 0x8acb,
    0x901d, 0x9192, 0x9752, 0x9759, 0x6589, 0x7a0e, 0x8106, 0x96bb,
    0x5e2d, 0x60dc, 0x621a, 0x65a5, 0x6614, 0x6790, 0x77f3, 0x7a4d,
    0x7c4d, 0x7e3e, 0x810a, 0x8cac, 0x8d64, 0x8de1, 0x8e5f, 0x78a9,
    0x5207, 0x62d9, 0x63a5, 0x6442, 0x6298, 0x8a2d, 0x7a83, 0x7bc0,
    0x8aac, 0x96ea, 0x7d76, 0x820c, 0x8749, 0x4ed9, 0x5148, 0x5343,
    0x5360, 0x5ba3, 0x5c02, 0x5c16, 0x5ddd, 0x6226, 0x6247, 0x64b0,
    0x6813, 0x6834, 0x6cc9, 0x6d45, 0x6d17, 0x67d3, 0x6f5c, 0x714e,
    0x717d, 0x65cb, 0x7a7f, 0x7bad, 0x7dda, 0x0000, 0x0000, 0x0000
};

static const u16 S91[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7e4a, 0x7fa8, 0x817a, 0x821b, 0x8239, 0x85a6, 0x8a6e, 0x8cce,
    0x8df5, 0x9078, 0x9077, 0x92ad, 0x9291, 0x9583, 0x9bae, 0x524d,
    0x5584, 0x6f38, 0x7136, 0x5168, 0x7985, 0x7e55, 0x81b3, 0x7cce,
    0x564c, 0x5851, 0x5ca8, 0x63aa, 0x66fe, 0x66fd, 0x695a, 0x72d9,
    0x758f, 0x758e, 0x790e, 0x7956, 0x79df, 0x7c97, 0x7d20, 0x7d44,
    0x8607, 0x8a34, 0x963b, 0x9061, 0x9f20, 0x50e7, 0x5275, 0x53cc,
    0x53e2, 0x5009, 0x55aa, 0x58ee, 0x594f, 0x723d, 0x5b8b, 0x5c64,
    0x531d, 0x60e3, 0x60f3, 0x635c, 0x6383, 0x633f, 0x63bb, 0x0000,
    0x64cd, 0x65e9, 0x66f9, 0x5de3, 0x69cd, 0x69fd, 0x6f15, 0x71e5,
    0x4e89, 0x75e9, 0x76f8, 0x7a93, 0x7cdf, 0x7dcf, 0x7d9c, 0x8061,
    0x8349, 0x8358, 0x846c, 0x84bc, 0x85fb, 0x88c5, 0x8d70, 0x9001,
    0x906d, 0x9397, 0x971c, 0x9a12, 0x50cf, 0x5897, 0x618e, 0x81d3,
    0x8535, 0x8d08, 0x9020, 0x4fc3, 0x5074, 0x5247, 0x5373, 0x606f,
    0x6349, 0x675f, 0x6e2c, 0x8db3, 0x901f, 0x4fd7, 0x5c5e, 0x8cca,
    0x65cf, 0x7d9a, 0x5352, 0x8896, 0x5176, 0x63c3, 0x5b58, 0x5b6b,
    0x5c0a, 0x640d, 0x6751, 0x905c, 0x4ed6, 0x591a, 0x592a, 0x6c70,
    0x8a51, 0x553e, 0x5815, 0x59a5, 0x60f0, 0x6253, 0x67c1, 0x8235,
    0x6955, 0x9640, 0x99c4, 0x9a28, 0x4f53, 0x5806, 0x5bfe, 0x8010,
    0x5cb1, 0x5e2f, 0x5f85, 0x6020, 0x614b, 0x6234, 0x66ff, 0x6cf0,
    0x6ede, 0x80ce, 0x817f, 0x82d4, 0x888b, 0x8cb8, 0x9000, 0x902e,
    0x968a, 0x9edb, 0x9bdb, 0x4ee3, 0x53f0, 0x5927, 0x7b2c, 0x918d,
    0x984c, 0x9df9, 0x6edd, 0x7027, 0x5353, 0x5544, 0x5b85, 0x6258,
    0x629e, 0x62d3, 0x6ca2, 0x6fef, 0x7422, 0x8a17, 0x9438, 0x6fc1,
    0x8afe, 0x8338, 0x51e7, 0x86f8, 0x53ea, 0x0000, 0x0000, 0x0000
};

static const u16 S92[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x53e9, 0x4f46, 0x9054, 0x8fb0, 0x596a, 0x8131, 0x5dfd, 0x7aea,
    0x8fbf, 0x68da, 0x8c37, 0x72f8, 0x9c48, 0x6a3d, 0x8ab0, 0x4e39,
    0x5358, 0x5606, 0x5766, 0x62c5, 0x63a2, 0x65e6, 0x6b4e, 0x6de1,
    0x6e5b, 0x70ad, 0x77ed, 0x7aef, 0x7baa, 0x7dbb, 0x803d, 0x80c6,
    0x86cb, 0x8a95, 0x935b, 0x56e3, 0x58c7, 0x5f3e, 0x65ad, 0x6696,
    0x6a80, 0x6bb5, 0x7537, 0x8ac7, 0x5024, 0x77e5, 0x5730, 0x5f1b,
    0x6065, 0x667a, 0x6c60, 0x75f4, 0x7a1a, 0x7f6e, 0x81f4, 0x8718,
    0x9045, 0x99b3, 0x7bc9, 0x755c, 0x7af9, 0x7b51, 0x84c4, 0x0000,
    0x9010, 0x79e9, 0x7a92, 0x8336, 0x5ae1, 0x7740, 0x4e2d, 0x4ef2,
    0x5b99, 0x5fe0, 0x62bd, 0x663c, 0x67f1, 0x6ce8, 0x866b, 0x8877,
    0x8a3b, 0x914e, 0x92f3, 0x99d0, 0x6a17, 0x7026, 0x732a, 0x82e7,
    0x8457, 0x8caf, 0x4e01, 0x5146, 0x51cb, 0x558b, 0x5bf5, 0x5e16,
    0x5e33, 0x5e81, 0x5f14, 0x5f35, 0x5f6b, 0x5fb4, 0x61f2, 0x6311,
    0x66a2, 0x671d, 0x6f6e, 0x7252, 0x753a, 0x773a, 0x8074, 0x8139,
    0x8178, 0x8776, 0x8abf, 0x8adc, 0x8d85, 0x8df3, 0x929a, 0x9577,
    0x9802, 0x9ce5, 0x52c5, 0x6357, 0x76f4, 0x6715, 0x6c88, 0x73cd,
    0x8cc3, 0x93ae, 0x9673, 0x6d25, 0x589c, 0x690e, 0x69cc, 0x8ffd,
    0x939a, 0x75db, 0x901a, 0x585a, 0x6802, 0x63b4, 0x69fb, 0x4f43,
    0x6f2c, 0x67d8, 0x8fbb, 0x8526, 0x7db4, 0x9354, 0x693f, 0x6f70,
    0x576a, 0x58f7, 0x5b2c, 0x7d2c, 0x722a, 0x540a, 0x91e3, 0x9db4,
    0x4ead, 0x4f4e, 0x505c, 0x5075, 0x5243, 0x8c9e, 0x5448, 0x5824,
    0x5b9a, 0x5e1d, 0x5e95, 0x5ead, 0x5ef7, 0x5f1f, 0x608c, 0x62b5,
    0x633a, 0x63d0, 0x68af, 0x6c40, 0x7887, 0x798e, 0x7a0b, 0x7de0,
    0x8247, 0x8a02, 0x8ae6, 0x8e44, 0x9013, 0x0000, 0x0000, 0x0000
};

static const u16 S93[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x90b8, 0x912d, 0x91d8, 0x9f0e, 0x6ce5, 0x6458, 0x64e2, 0x6575,
    0x6ef4, 0x7684, 0x7b1b, 0x9069, 0x93d1, 0x6eba, 0x54f2, 0x5fb9,
    0x64a4, 0x8f4d, 0x8fed, 0x9244, 0x5178, 0x586b, 0x5929, 0x5c55,
    0x5e97, 0x6dfb, 0x7e8f, 0x751c, 0x8cbc, 0x8ee2, 0x985b, 0x70b9,
    0x4f1d, 0x6bbf, 0x6fb1, 0x7530, 0x96fb, 0x514e, 0x5410, 0x5835,
    0x5857, 0x59ac, 0x5c60, 0x5f92, 0x6597, 0x675c, 0x6e21, 0x767b,
    0x83df, 0x8ced, 0x9014, 0x90fd, 0x934d, 0x7825, 0x783a, 0x52aa,
    0x5ea6, 0x571f, 0x5974, 0x6012, 0x5012, 0x515a, 0x51ac, 0x0000,
    0x51cd, 0x5200, 0x5510, 0x5854, 0x5858, 0x5957, 0x5b95, 0x5cf6,
    0x5d8b, 0x60bc, 0x6295, 0x642d, 0x6771, 0x6843, 0x68bc, 0x68df,
    0x76d7, 0x6dd8, 0x6e6f, 0x6d9b, 0x706f, 0x71c8, 0x5f53, 0x75d8,
    0x7977, 0x7b49, 0x7b54, 0x7b52, 0x7cd6, 0x7d71, 0x5230, 0x8463,
    0x8569, 0x85e4, 0x8a0e, 0x8b04, 0x8c46, 0x8e0f, 0x9003, 0x900f,
    0x9419, 0x9676, 0x982d, 0x9a30, 0x95d8, 0x50cd, 0x52d5, 0x540c,
    0x5802, 0x5c0e, 0x61a7, 0x649e, 0x6d1e, 0x77b3, 0x7ae5, 0x80f4,
    0x8404, 0x9053, 0x9285, 0x5ce0, 0x9d07, 0x533f, 0x5f97, 0x5fb3,
    0x6d9c, 0x7279, 0x7763, 0x79bf, 0x7be4, 0x6bd2, 0x72ec, 0x8aad,
    0x6803, 0x6a61, 0x51f8, 0x7a81, 0x6934, 0x5c4a, 0x9cf6, 0x82eb,
    0x5bc5, 0x9149, 0x701e, 0x5678, 0x5c6f, 0x60c7, 0x6566, 0x6c8c,
    0x8c5a, 0x9041, 0x9813, 0x5451, 0x66c7, 0x920d, 0x5948, 0x90a3,
    0x5185, 0x4e4d, 0x51ea, 0x8599, 0x8b0e, 0x7058, 0x637a, 0x934b,
    0x6962, 0x99b4, 0x7e04, 0x7577, 0x5357, 0x6960, 0x8edf, 0x96e3,
    0x6c5d, 0x4e8c, 0x5c3c, 0x5f10, 0x8fe9, 0x5302, 0x8cd1, 0x8089,
    0x8679, 0x5eff, 0x65e5, 0x4e73, 0x5165, 0x0000, 0x0000, 0x0000
};

static const u16 S94[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x5982, 0x5c3f, 0x97ee, 0x4efb, 0x598a, 0x5fcd, 0x8a8d, 0x6fe1,
    0x79b0, 0x7962, 0x5be7, 0x8471, 0x732b, 0x71b1, 0x5e74, 0x5ff5,
    0x637b, 0x649a, 0x71c3, 0x7c98, 0x4e43, 0x5efc, 0x4e4b, 0x57dc,
    0x56a2, 0x60a9, 0x6fc3, 0x7d0d, 0x80fd, 0x8133, 0x81bf, 0x8fb2,
    0x8997, 0x86a4, 0x5df4, 0x628a, 0x64ad, 0x8987, 0x6777, 0x6ce2,
    0x6d3e, 0x7436, 0x7834, 0x5a46, 0x7f75, 0x82ad, 0x99ac, 0x4ff3,
    0x5ec3, 0x62dd, 0x6392, 0x6557, 0x676f, 0x76c3, 0x724c, 0x80cc,
    0x80ba, 0x8f29, 0x914d, 0x500d, 0x57f9, 0x5a92, 0x6885, 0x0000,
    0x6973, 0x7164, 0x72fd, 0x8cb7, 0x58f2, 0x8ce0, 0x966a, 0x9019,
    0x877f, 0x79e4, 0x77e7, 0x8429, 0x4f2f, 0x5265, 0x535a, 0x62cd,
    0x67cf, 0x6cca, 0x767d, 0x7b94, 0x7c95, 0x8236, 0x8584, 0x8feb,
    0x66dd, 0x6f20, 0x7206, 0x7e1b, 0x83ab, 0x99c1, 0x9ea6, 0x51fd,
    0x7bb1, 0x7872, 0x7bb8, 0x8087, 0x7b48, 0x6ae8, 0x5e61, 0x808c,
    0x7551, 0x7560, 0x516b, 0x9262, 0x6e8c, 0x767a, 0x9197, 0x9aea,
    0x4f10, 0x7f70, 0x629c, 0x7b4f, 0x95a5, 0x9ce9, 0x567a, 0x5859,
    0x86e4, 0x96bc, 0x4f34, 0x5224, 0x534a, 0x53cd, 0x53db, 0x5e06,
    0x642c, 0x6591, 0x677f, 0x6c3e, 0x6c4e, 0x7248, 0x72af, 0x73ed,
    0x7554, 0x7e41, 0x822c, 0x85e9, 0x8ca9, 0x7bc4, 0x91c6, 0x7169,
    0x9812, 0x98ef, 0x633d, 0x6669, 0x756a, 0x76e4, 0x78d0, 0x8543,
    0x86ee, 0x532a, 0x5351, 0x5426, 0x5983, 0x5e87, 0x5f7c, 0x60b2,
    0x6249, 0x6279, 0x62ab, 0x6590, 0x6bd4, 0x6ccc, 0x75b2, 0x76ae,
    0x7891, 0x79d8, 0x7dcb, 0x7f77, 0x80a5, 0x88ab, 0x8ab9, 0x8cbb,
    0x907f, 0x975e, 0x98db, 0x6a0b, 0x7c38, 0x5099, 0x5c3e, 0x5fae,
    0x6787, 0x6bd8, 0x7435, 0x7709, 0x7f8e, 0x0000, 0x0000, 0x0000
};

static const u16 S95[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9f3b, 0x67ca, 0x7a17, 0x5339, 0x758b, 0x9aed, 0x5f66, 0x819d,
    0x83f1, 0x8098, 0x5f3c, 0x5fc5, 0x7562, 0x7b46, 0x903c, 0x6867,
    0x59eb, 0x5a9b, 0x7d10, 0x767e, 0x8b2c, 0x4ff5, 0x5f6a, 0x6a19,
    0x6c37, 0x6f02, 0x74e2, 0x7968, 0x8868, 0x8a55, 0x8c79, 0x5edf,
    0x63cf, 0x75c5, 0x79d2, 0x82d7, 0x9328, 0x92f2, 0x849c, 0x86ed,
    0x9c2d, 0x54c1, 0x5f6c, 0x658c, 0x6d5c, 0x7015, 0x8ca7, 0x8cd3,
    0x983b, 0x654f, 0x74f6, 0x4e0d, 0x4ed8, 0x57e0, 0x592b, 0x5a66,
    0x5bcc, 0x51a8, 0x5e03, 0x5e9c, 0x6016, 0x6276, 0x6577, 0x0000,
    0x65a7, 0x666e, 0x6d6e, 0x7236, 0x7b26, 0x8150, 0x819a, 0x8299,
    0x8b5c, 0x8ca0, 0x8ce6, 0x8d74, 0x961c, 0x9644, 0x4fae, 0x64ab,
    0x6b66, 0x821e, 0x8461, 0x856a, 0x90e8, 0x5c01, 0x6953, 0x98a8,
    0x847a, 0x8557, 0x4f0f, 0x526f, 0x5fa9, 0x5e45, 0x670d, 0x798f,
    0x8179, 0x8907, 0x8986, 0x6df5, 0x5f17, 0x6255, 0x6cb8, 0x4ecf,
    0x7269, 0x9b92, 0x5206, 0x543b, 0x5674, 0x58b3, 0x61a4, 0x626e,
    0x711a, 0x596e, 0x7c89, 0x7cde, 0x7d1b, 0x96f0, 0x6587, 0x805e,
    0x4e19, 0x4f75, 0x5175, 0x5840, 0x5e63, 0x5e73, 0x5f0a, 0x67c4,
    0x4e26, 0x853d, 0x9589, 0x965b, 0x7c73, 0x9801, 0x50fb, 0x58c1,
    0x7656, 0x78a7, 0x5225, 0x77a5, 0x8511, 0x7b86, 0x504f, 0x5909,
    0x7247, 0x7bc7, 0x7de8, 0x8fba, 0x8fd4, 0x904d, 0x4fbf, 0x52c9,
    0x5a29, 0x5f01, 0x97ad, 0x4fdd, 0x8217, 0x92ea, 0x5703, 0x6355,
    0x6b69, 0x752b, 0x88dc, 0x8f14, 0x7a42, 0x52df, 0x5893, 0x6155,
    0x620a, 0x66ae, 0x6bcd, 0x7c3f, 0x83e9, 0x5023, 0x4ff8, 0x5305,
    0x5446, 0x5831, 0x5949, 0x5b9d, 0x5cf0, 0x5cef, 0x5d29, 0x5e96,
    0x62b1, 0x6367, 0x653e, 0x65b9, 0x670b, 0x0000, 0x0000, 0x0000
};

static const u16 S96[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x6cd5, 0x6ce1, 0x70f9, 0x7832, 0x7e2b, 0x80de, 0x82b3, 0x840c,
    0x84ec, 0x8702, 0x8912, 0x8a2a, 0x8c4a, 0x90a6, 0x92d2, 0x98fd,
    0x9cf3, 0x9d6c, 0x4e4f, 0x4ea1, 0x508d, 0x5256, 0x574a, 0x59a8,
    0x5e3d, 0x5fd8, 0x5fd9, 0x623f, 0x66b4, 0x671b, 0x67d0, 0x68d2,
    0x5192, 0x7d21, 0x80aa, 0x81a8, 0x8b00, 0x8c8c, 0x8cbf, 0x927e,
    0x9632, 0x5420, 0x982c, 0x5317, 0x50d5, 0x535c, 0x58a8, 0x64b2,
    0x6734, 0x7267, 0x7766, 0x7a46, 0x91e6, 0x52c3, 0x6ca1, 0x6b86,
    0x5800, 0x5e4c, 0x5954, 0x672c, 0x7ffb, 0x51e1, 0x76c6, 0x0000,
    0x6469, 0x78e8, 0x9b54, 0x9ebb, 0x57cb, 0x59b9, 0x6627, 0x679a,
    0x6bce, 0x54e9, 0x69d9, 0x5e55, 0x819c, 0x6795, 0x9baa, 0x67fe,
    0x9c52, 0x685d, 0x4ea6, 0x4fe3, 0x53c8, 0x62b9, 0x672b, 0x6cab,
    0x8fc4, 0x4fad, 0x7e6d, 0x9ebf, 0x4e07, 0x6162, 0x6e80, 0x6f2b,
    0x8513, 0x5473, 0x672a, 0x9b45, 0x5df3, 0x7b95, 0x5cac, 0x5bc6,
    0x871c, 0x6e4a, 0x84d1, 0x7a14, 0x8108, 0x5999, 0x7c8d, 0x6c11,
    0x7720, 0x52d9, 0x5922, 0x7121, 0x725f, 0x77db, 0x9727, 0x9d61,
    0x690b, 0x5a7f, 0x5a18, 0x51a5, 0x540d, 0x547d, 0x660e, 0x76df,
    0x8ff7, 0x9298, 0x9cf4, 0x59ea, 0x725d, 0x6ec5, 0x514d, 0x68c9,
    0x7dbf, 0x7dec, 0x9762, 0x9eba, 0x6478, 0x6a21, 0x8302, 0x5984,
    0x5b5f, 0x6bdb, 0x731b, 0x76f2, 0x7db2, 0x8017, 0x8499, 0x5132,
    0x6728, 0x9ed9, 0x76ee, 0x6762, 0x52ff, 0x9905, 0x5c24, 0x623b,
    0x7c7e, 0x8cb0, 0x554f, 0x60b6, 0x7d0b, 0x9580, 0x5301, 0x4e5f,
    0x51b6, 0x591c, 0x723a, 0x8036, 0x91ce, 0x5f25, 0x77e2, 0x5384,
    0x5f79, 0x7d04, 0x85ac, 0x8a33, 0x8e8d, 0x9756, 0x67f3, 0x85ae,
    0x9453, 0x6109, 0x6108, 0x6cb9, 0x7652, 0x0000, 0x0000, 0x0000
};

static const u16 S97[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8aed, 0x8f38, 0x552f, 0x4f51, 0x512a, 0x52c7, 0x53cb, 0x5ba5,
    0x5e7d, 0x60a0, 0x6182, 0x63d6, 0x6709, 0x67da, 0x6e67, 0x6d8c,
    0x7336, 0x7337, 0x7531, 0x7950, 0x88d5, 0x8a98, 0x904a, 0x9091,
    0x90f5, 0x96c4, 0x878d, 0x5915, 0x4e88, 0x4f59, 0x4e0e, 0x8a89,
    0x8f3f, 0x9810, 0x50ad, 0x5e7c, 0x5996, 0x5bb9, 0x5eb8, 0x63da,
    0x63fa, 0x64c1, 0x66dc, 0x694a, 0x69d8, 0x6d0b, 0x6eb6, 0x7194,
    0x7528, 0x7aaf, 0x7f8a, 0x8000, 0x8449, 0x84c9, 0x8981, 0x8b21,
    0x8e0a, 0x9065, 0x967d, 0x990a, 0x617e, 0x6291, 0x6b32, 0x0000,
    0x6c83, 0x6d74, 0x7fcc, 0x7ffc, 0x6dc0, 0x7f85, 0x87ba, 0x88f8,
    0x6765, 0x83b1, 0x983c, 0x96f7, 0x6d1b, 0x7d61, 0x843d, 0x916a,
    0x4e71, 0x5375, 0x5d50, 0x6b04, 0x6feb, 0x85cd, 0x862d, 0x89a7,
    0x5229, 0x540f, 0x5c65, 0x674e, 0x68a8, 0x7406, 0x7483, 0x75e2,
    0x88cf, 0x88e1, 0x91cc, 0x96e2, 0x9678, 0x5f8b, 0x7387, 0x7acb,
    0x844e, 0x63a0, 0x7565, 0x5289, 0x6d41, 0x6e9c, 0x7409, 0x7559,
    0x786b, 0x7c92, 0x9686, 0x7adc, 0x9f8d, 0x4fb6, 0x616e, 0x65c5,
    0x865c, 0x4e86, 0x4eae, 0x50da, 0x4e21, 0x51cc, 0x5bee, 0x6599,
    0x6881, 0x6dbc, 0x731f, 0x7642, 0x77ad, 0x7a1c, 0x7ce7, 0x826f,
    0x8ad2, 0x907c, 0x91cf, 0x9675, 0x9818, 0x529b, 0x7dd1, 0x502b,
    0x5398, 0x6797, 0x6dcb, 0x71d0, 0x7433, 0x81e8, 0x8f2a, 0x96a3,
    0x9c57, 0x9e9f, 0x7460, 0x5841, 0x6d99, 0x7d2f, 0x985e, 0x4ee4,
    0x4f36, 0x4f8b, 0x51b7, 0x52b1, 0x5dba, 0x601c, 0x73b2, 0x793c,
    0x82d3, 0x9234, 0x96b7, 0x96f6, 0x970a, 0x9e97, 0x9f62, 0x66a6,
    0x6b74, 0x5217, 0x52a3, 0x70c8, 0x88c2, 0x5ec9, 0x604b, 0x6190,
    0x6f23, 0x7149, 0x7c3e, 0x7df4, 0x806f, 0x0000, 0x0000, 0x0000
};

static const u16 S98[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x84ee, 0x9023, 0x932c, 0x5442, 0x9b6f, 0x6ad3, 0x7089, 0x8cc2,
    0x8def, 0x9732, 0x52b4, 0x5a41, 0x5eca, 0x5f04, 0x6717, 0x697c,
    0x6994, 0x6d6a, 0x6f0f, 0x7262, 0x72fc, 0x7bed, 0x8001, 0x807e,
    0x874b, 0x90ce, 0x516d, 0x9e93, 0x7984, 0x808b, 0x9332, 0x8ad6,
    0x502d, 0x548c, 0x8a71, 0x6b6a, 0x8cc4, 0x8107, 0x60d1, 0x67a0,
    0x9df2, 0x4e99, 0x4e98, 0x9c10, 0x8a6b, 0x85c1, 0x8568, 0x6900,
    0x6e7e, 0x7897, 0x8155, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5f0c,
    0x4e10, 0x4e15, 0x4e2a, 0x4e31, 0x4e36, 0x4e3c, 0x4e3f, 0x4e42,
    0x4e56, 0x4e58, 0x4e82, 0x4e85, 0x8c6b, 0x4e8a, 0x8212, 0x5f0d,
    0x4e8e, 0x4e9e, 0x4e9f, 0x4ea0, 0x4ea2, 0x4eb0, 0x4eb3, 0x4eb6,
    0x4ece, 0x4ecd, 0x4ec4, 0x4ec6, 0x4ec2, 0x4ed7, 0x4ede, 0x4eed,
    0x4edf, 0x4ef7, 0x4f09, 0x4f5a, 0x4f30, 0x4f5b, 0x4f5d, 0x4f57,
    0x4f47, 0x4f76, 0x4f88, 0x4f8f, 0x4f98, 0x4f7b, 0x4f69, 0x4f70,
    0x4f91, 0x4f6f, 0x4f86, 0x4f96, 0x5118, 0x4fd4, 0x4fdf, 0x4fce,
    0x4fd8, 0x4fdb, 0x4fd1, 0x4fda, 0x4fd0, 0x4fe4, 0x4fe5, 0x501a,
    0x5028, 0x5014, 0x502a, 0x5025, 0x5005, 0x4f1c, 0x4ff6, 0x5021,
    0x5029, 0x502c, 0x4ffe, 0x4fef, 0x5011, 0x5006, 0x5043, 0x5047,
    0x6703, 0x5055, 0x5050, 0x5048, 0x505a, 0x5056, 0x506c, 0x5078,
    0x5080, 0x509a, 0x5085, 0x50b4, 0x50b2, 0x0000, 0x0000, 0x0000
};

static const u16 S99[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x50c9, 0x50ca, 0x50b3, 0x50c2, 0x50d6, 0x50de, 0x50e5, 0x50ed,
    0x50e3, 0x50ee, 0x50f9, 0x50f5, 0x5109, 0x5101, 0x5102, 0x5116,
    0x5115, 0x5114, 0x511a, 0x5121, 0x513a, 0x5137, 0x513c, 0x513b,
    0x513f, 0x5140, 0x5152, 0x514c, 0x5154, 0x5162, 0x7af8, 0x5169,
    0x516a, 0x516e, 0x5180, 0x5182, 0x56d8, 0x518c, 0x5189, 0x518f,
    0x5191, 0x5193, 0x5195, 0x5196, 0x51a4, 0x51a6, 0x51a2, 0x51a9,
    0x51aa, 0x51ab, 0x51b3, 0x51b1, 0x51b2, 0x51b0, 0x51b5, 0x51bd,
    0x51c5, 0x51c9, 0x51db, 0x51e0, 0x8655, 0x51e9, 0x51ed, 0x0000,
    0x51f0, 0x51f5, 0x51fe, 0x5204, 0x520b, 0x5214, 0x520e, 0x5227,
    0x522a, 0x522e, 0x5233, 0x5239, 0x524f, 0x5244, 0x524b, 0x524c,
    0x525e, 0x5254, 0x526a, 0x5274, 0x5269, 0x5273, 0x527f, 0x527d,
    0x528d, 0x5294, 0x5292, 0x5271, 0x5288, 0x5291, 0x8fa8, 0x8fa7,
    0x52ac, 0x52ad, 0x52bc, 0x52b5, 0x52c1, 0x52cd, 0x52d7, 0x52de,
    0x52e3, 0x52e6, 0x98ed, 0x52e0, 0x52f3, 0x52f5, 0x52f8, 0x52f9,
    0x5306, 0x5308, 0x7538, 0x530d, 0x5310, 0x530f, 0x5315, 0x531a,
    0x5323, 0x532f, 0x5331, 0x5333, 0x5338, 0x5340, 0x5346, 0x5345,
    0x4e17, 0x5349, 0x534d, 0x51d6, 0x535e, 0x5369, 0x536e, 0x5918,
    0x537b, 0x5377, 0x5382, 0x5396, 0x53a0, 0x53a6, 0x53a5, 0x53ae,
    0x53b0, 0x53b6, 0x53c3, 0x7c12, 0x96d9, 0x53df, 0x66fc, 0x71ee,
    0x53ee, 0x53e8, 0x53ed, 0x53fa, 0x5401, 0x543d, 0x5440, 0x542c,
    0x542d, 0x543c, 0x542e, 0x5436, 0x5429, 0x541d, 0x544e, 0x548f,
    0x5475, 0x548e, 0x545f, 0x5471, 0x5477, 0x5470, 0x5492, 0x547b,
    0x5480, 0x5476, 0x5484, 0x5490, 0x5486, 0x54c7, 0x54a2, 0x54b8,
    0x54a5, 0x54ac, 0x54c4, 0x54c8, 0x54a8, 0x0000, 0x0000, 0x0000
};

static const u16 S9a[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x54ab, 0x54c2, 0x54a4, 0x54be, 0x54bc, 0x54d8, 0x54e5, 0x54e6,
    0x550f, 0x5514, 0x54fd, 0x54ee, 0x54ed, 0x54fa, 0x54e2, 0x5539,
    0x5540, 0x5563, 0x554c, 0x552e, 0x555c, 0x5545, 0x5556, 0x5557,
    0x5538, 0x5533, 0x555d, 0x5599, 0x5580, 0x54af, 0x558a, 0x559f,
    0x557b, 0x557e, 0x5598, 0x559e, 0x55ae, 0x557c, 0x5583, 0x55a9,
    0x5587, 0x55a8, 0x55da, 0x55c5, 0x55df, 0x55c4, 0x55dc, 0x55e4,
    0x55d4, 0x5614, 0x55f7, 0x5616, 0x55fe, 0x55fd, 0x561b, 0x55f9,
    0x564e, 0x5650, 0x71df, 0x5634, 0x5636, 0x5632, 0x5638, 0x0000,
    0x566b, 0x5664, 0x562f, 0x566c, 0x566a, 0x5686, 0x5680, 0x568a,
    0x56a0, 0x5694, 0x568f, 0x56a5, 0x56ae, 0x56b6, 0x56b4, 0x56c2,
    0x56bc, 0x56c1, 0x56c3, 0x56c0, 0x56c8, 0x56ce, 0x56d1, 0x56d3,
    0x56d7, 0x56ee, 0x56f9, 0x5700, 0x56ff, 0x5704, 0x5709, 0x5708,
    0x570b, 0x570d, 0x5713, 0x5718, 0x5716, 0x55c7, 0x571c, 0x5726,
    0x5737, 0x5738, 0x574e, 0x573b, 0x5740, 0x574f, 0x5769, 0x57c0,
    0x5788, 0x5761, 0x577f, 0x5789, 0x5793, 0x57a0, 0x57b3, 0x57a4,
    0x57aa, 0x57b0, 0x57c3, 0x57c6, 0x57d4, 0x57d2, 0x57d3, 0x580a,
    0x57d6, 0x57e3, 0x580b, 0x5819, 0x581d, 0x5872, 0x5821, 0x5862,
    0x584b, 0x5870, 0x6bc0, 0x5852, 0x583d, 0x5879, 0x5885, 0x58b9,
    0x589f, 0x58ab, 0x58ba, 0x58de, 0x58bb, 0x58b8, 0x58ae, 0x58c5,
    0x58d3, 0x58d1, 0x58d7, 0x58d9, 0x58d8, 0x58e5, 0x58dc, 0x58e4,
    0x58df, 0x58ef, 0x58fa, 0x58f9, 0x58fb, 0x58fc, 0x58fd, 0x5902,
    0x590a, 0x5910, 0x591b, 0x68a6, 0x5925, 0x592c, 0x592d, 0x5932,
    0x5938, 0x593e, 0x7ad2, 0x5955, 0x5950, 0x594e, 0x595a, 0x5958,
    0x5962, 0x5960, 0x5967, 0x596c, 0x5969, 0x0000, 0x0000, 0x0000
};

static const u16 S9b[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x5978, 0x5981, 0x599d, 0x4f5e, 0x4fab, 0x59a3, 0x59b2, 0x59c6,
    0x59e8, 0x59dc, 0x598d, 0x59d9, 0x59da, 0x5a25, 0x5a1f, 0x5a11,
    0x5a1c, 0x5a09, 0x5a1a, 0x5a40, 0x5a6c, 0x5a49, 0x5a35, 0x5a36,
    0x5a62, 0x5a6a, 0x5a9a, 0x5abc, 0x5abe, 0x5acb, 0x5ac2, 0x5abd,
    0x5ae3, 0x5ad7, 0x5ae6, 0x5ae9, 0x5ad6, 0x5afa, 0x5afb, 0x5b0c,
    0x5b0b, 0x5b16, 0x5b32, 0x5ad0, 0x5b2a, 0x5b36, 0x5b3e, 0x5b43,
    0x5b45, 0x5b40, 0x5b51, 0x5b55, 0x5b5a, 0x5b5b, 0x5b65, 0x5b69,
    0x5b70, 0x5b73, 0x5b75, 0x5b78, 0x6588, 0x5b7a, 0x5b80, 0x0000,
    0x5b83, 0x5ba6, 0x5bb8, 0x5bc3, 0x5bc7, 0x5bc9, 0x5bd4, 0x5bd0,
    0x5be4, 0x5be6, 0x5be2, 0x5bde, 0x5be5, 0x5beb, 0x5bf0, 0x5bf6,
    0x5bf3, 0x5c05, 0x5c07, 0x5c08, 0x5c0d, 0x5c13, 0x5c20, 0x5c22,
    0x5c28, 0x5c38, 0x5c39, 0x5c41, 0x5c46, 0x5c4e, 0x5c53, 0x5c50,
    0x5c4f, 0x5b71, 0x5c6c, 0x5c6e, 0x4e62, 0x5c76, 0x5c79, 0x5c8c,
    0x5c91, 0x5c94, 0x599b, 0x5cab, 0x5cbb, 0x5cb6, 0x5cbc, 0x5cb7,
    0x5cc5, 0x5cbe, 0x5cc7, 0x5cd9, 0x5ce9, 0x5cfd, 0x5cfa, 0x5ced,
    0x5d8c, 0x5cea, 0x5d0b, 0x5d15, 0x5d17, 0x5d5c, 0x5d1f, 0x5d1b,
    0x5d11, 0x5d14, 0x5d22, 0x5d1a, 0x5d19, 0x5d18, 0x5d4c, 0x5d52,
    0x5d4e, 0x5d4b, 0x5d6c, 0x5d73, 0x5d76, 0x5d87, 0x5d84, 0x5d82,
    0x5da2, 0x5d9d, 0x5dac, 0x5dae, 0x5dbd, 0x5d90, 0x5db7, 0x5dbc,
    0x5dc9, 0x5dcd, 0x5dd3, 0x5dd2, 0x5dd6, 0x5ddb, 0x5deb, 0x5df2,
    0x5df5, 0x5e0b, 0x5e1a, 0x5e19, 0x5e11, 0x5e1b, 0x5e36, 0x5e37,
    0x5e44, 0x5e43, 0x5e40, 0x5e4e, 0x5e57, 0x5e54, 0x5e5f, 0x5e62,
    0x5e64, 0x5e47, 0x5e75, 0x5e76, 0x5e7a, 0x9ebc, 0x5e7f, 0x5ea0,
    0x5ec1, 0x5ec2, 0x5ec8, 0x5ed0, 0x5ecf, 0x0000, 0x0000, 0x0000
};

static const u16 S9c[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x5ed6, 0x5ee3, 0x5edd, 0x5eda, 0x5edb, 0x5ee2, 0x5ee1, 0x5ee8,
    0x5ee9, 0x5eec, 0x5ef1, 0x5ef3, 0x5ef0, 0x5ef4, 0x5ef8, 0x5efe,
    0x5f03, 0x5f09, 0x5f5d, 0x5f5c, 0x5f0b, 0x5f11, 0x5f16, 0x5f29,
    0x5f2d, 0x5f38, 0x5f41, 0x5f48, 0x5f4c, 0x5f4e, 0x5f2f, 0x5f51,
    0x5f56, 0x5f57, 0x5f59, 0x5f61, 0x5f6d, 0x5f73, 0x5f77, 0x5f83,
    0x5f82, 0x5f7f, 0x5f8a, 0x5f88, 0x5f91, 0x5f87, 0x5f9e, 0x5f99,
    0x5f98, 0x5fa0, 0x5fa8, 0x5fad, 0x5fbc, 0x5fd6, 0x5ffb, 0x5fe4,
    0x5ff8, 0x5ff1, 0x5fdd, 0x60b3, 0x5fff, 0x6021, 0x6060, 0x0000,
    0x6019, 0x6010, 0x6029, 0x600e, 0x6031, 0x601b, 0x6015, 0x602b,
    0x6026, 0x600f, 0x603a, 0x605a, 0x6041, 0x606a, 0x6077, 0x605f,
    0x604a, 0x6046, 0x604d, 0x6063, 0x6043, 0x6064, 0x6042, 0x606c,
    0x606b, 0x6059, 0x6081, 0x608d, 0x60e7, 0x6083, 0x609a, 0x6084,
    0x609b, 0x6096, 0x6097, 0x6092, 0x60a7, 0x608b, 0x60e1, 0x60b8,
    0x60e0, 0x60d3, 0x60b4, 0x5ff0, 0x60bd, 0x60c6, 0x60b5, 0x60d8,
    0x614d, 0x6115, 0x6106, 0x60f6, 0x60f7, 0x6100, 0x60f4, 0x60fa,
    0x6103, 0x6121, 0x60fb, 0x60f1, 0x610d, 0x610e, 0x6147, 0x613e,
    0x6128, 0x6127, 0x614a, 0x613f, 0x613c, 0x612c, 0x6134, 0x613d,
    0x6142, 0x6144, 0x6173, 0x6177, 0x6158, 0x6159, 0x615a, 0x616b,
    0x6174, 0x616f, 0x6165, 0x6171, 0x615f, 0x615d, 0x6153, 0x6175,
    0x6199, 0x6196, 0x6187, 0x61ac, 0x6194, 0x619a, 0x618a, 0x6191,
    0x61ab, 0x61ae, 0x61cc, 0x61ca, 0x61c9, 0x61f7, 0x61c8, 0x61c3,
    0x61c6, 0x61ba, 0x61cb, 0x7f79, 0x61cd, 0x61e6, 0x61e3, 0x61f6,
    0x61fa, 0x61f4, 0x61ff, 0x61fd, 0x61fc, 0x61fe, 0x6200, 0x6208,
    0x6209, 0x620d, 0x620c, 0x6214, 0x621b, 0x0000, 0x0000, 0x0000
};

static const u16 S9d[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x621e, 0x6221, 0x622a, 0x622e, 0x6230, 0x6232, 0x6233, 0x6241,
    0x624e, 0x625e, 0x6263, 0x625b, 0x6260, 0x6268, 0x627c, 0x6282,
    0x6289, 0x627e, 0x6292, 0x6293, 0x6296, 0x62d4, 0x6283, 0x6294,
    0x62d7, 0x62d1, 0x62bb, 0x62cf, 0x62ff, 0x62c6, 0x64d4, 0x62c8,
    0x62dc, 0x62cc, 0x62ca, 0x62c2, 0x62c7, 0x629b, 0x62c9, 0x630c,
    0x62ee, 0x62f1, 0x6327, 0x6302, 0x6308, 0x62ef, 0x62f5, 0x6350,
    0x633e, 0x634d, 0x641c, 0x634f, 0x6396, 0x638e, 0x6380, 0x63ab,
    0x6376, 0x63a3, 0x638f, 0x6389, 0x639f, 0x63b5, 0x636b, 0x0000,
    0x6369, 0x63be, 0x63e9, 0x63c0, 0x63c6, 0x63e3, 0x63c9, 0x63d2,
    0x63f6, 0x63c4, 0x6416, 0x6434, 0x6406, 0x6413, 0x6426, 0x6436,
    0x651d, 0x6417, 0x6428, 0x640f, 0x6467, 0x646f, 0x6476, 0x644e,
    0x652a, 0x6495, 0x6493, 0x64a5, 0x64a9, 0x6488, 0x64bc, 0x64da,
    0x64d2, 0x64c5, 0x64c7, 0x64bb, 0x64d8, 0x64c2, 0x64f1, 0x64e7,
    0x8209, 0x64e0, 0x64e1, 0x62ac, 0x64e3, 0x64ef, 0x652c, 0x64f6,
    0x64f4, 0x64f2, 0x64fa, 0x6500, 0x64fd, 0x6518, 0x651c, 0x6505,
    0x6524, 0x6523, 0x652b, 0x6534, 0x6535, 0x6537, 0x6536, 0x6538,
    0x754b, 0x6548, 0x6556, 0x6555, 0x654d, 0x6558, 0x655e, 0x655d,
    0x6572, 0x6578, 0x6582, 0x6583, 0x8b8a, 0x659b, 0x659f, 0x65ab,
    0x65b7, 0x65c3, 0x65c6, 0x65c1, 0x65c4, 0x65cc, 0x65d2, 0x65db,
    0x65d9, 0x65e0, 0x65e1, 0x65f1, 0x6772, 0x660a, 0x6603, 0x65fb,
    0x6773, 0x6635, 0x6636, 0x6634, 0x661c, 0x664f, 0x6644, 0x6649,
    0x6641, 0x665e, 0x665d, 0x6664, 0x6667, 0x6668, 0x665f, 0x6662,
    0x6670, 0x6683, 0x6688, 0x668e, 0x6689, 0x6684, 0x6698, 0x669d,
    0x66c1, 0x66b9, 0x66c9, 0x66be, 0x66bc, 0x0000, 0x0000, 0x0000
};

static const u16 S9e[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x66c4, 0x66b8, 0x66d6, 0x66da, 0x66e0, 0x663f, 0x66e6, 0x66e9,
    0x66f0, 0x66f5, 0x66f7, 0x670f, 0x6716, 0x671e, 0x6726, 0x6727,
    0x9738, 0x672e, 0x673f, 0x6736, 0x6741, 0x6738, 0x6737, 0x6746,
    0x675e, 0x6760, 0x6759, 0x6763, 0x6764, 0x6789, 0x6770, 0x67a9,
    0x677c, 0x676a, 0x678c, 0x678b, 0x67a6, 0x67a1, 0x6785, 0x67b7,
    0x67ef, 0x67b4, 0x67ec, 0x67b3, 0x67e9, 0x67b8, 0x67e4, 0x67de,
    0x67dd, 0x67e2, 0x67ee, 0x67b9, 0x67ce, 0x67c6, 0x67e7, 0x6a9c,
    0x681e, 0x6846, 0x6829, 0x6840, 0x684d, 0x6832, 0x684e, 0x0000,
    0x68b3, 0x682b, 0x6859, 0x6863, 0x6877, 0x687f, 0x689f, 0x688f,
    0x68ad, 0x6894, 0x689d, 0x689b, 0x6883, 0x6aae, 0x68b9, 0x6874,
    0x68b5, 0x68a0, 0x68ba, 0x690f, 0x688d, 0x687e, 0x6901, 0x68ca,
    0x6908, 0x68d8, 0x6922, 0x6926, 0x68e1, 0x690c, 0x68cd, 0x68d4,
    0x68e7, 0x68d5, 0x6936, 0x6912, 0x6904, 0x68d7, 0x68e3, 0x6925,
    0x68f9, 0x68e0, 0x68ef, 0x6928, 0x692a, 0x691a, 0x6923, 0x6921,
    0x68c6, 0x6979, 0x6977, 0x695c, 0x6978, 0x696b, 0x6954, 0x697e,
    0x696e, 0x6939, 0x6974, 0x693d, 0x6959, 0x6930, 0x6961, 0x695e,
    0x695d, 0x6981, 0x696a, 0x69b2, 0x69ae, 0x69d0, 0x69bf, 0x69c1,
    0x69d3, 0x69be, 0x69ce, 0x5be8, 0x69ca, 0x69dd, 0x69bb, 0x69c3,
    0x69a7, 0x6a2e, 0x6991, 0x69a0, 0x699c, 0x6995, 0x69b4, 0x69de,
    0x69e8, 0x6a02, 0x6a1b, 0x69ff, 0x6b0a, 0x69f9, 0x69f2, 0x69e7,
    0x6a05, 0x69b1, 0x6a1e, 0x69ed, 0x6a14, 0x69eb, 0x6a0a, 0x6a12,
    0x6ac1, 0x6a23, 0x6a13, 0x6a44, 0x6a0c, 0x6a72, 0x6a36, 0x6a78,
    0x6a47, 0x6a62, 0x6a59, 0x6a66, 0x6a48, 0x6a38, 0x6a22, 0x6a90,
    0x6a8d, 0x6aa0, 0x6a84, 0x6aa2, 0x6aa3, 0x0000, 0x0000, 0x0000
};

static const u16 S9f[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x6a97, 0x8617, 0x6abb, 0x6ac3, 0x6ac2, 0x6ab8, 0x6ab3, 0x6aac,
    0x6ade, 0x6ad1, 0x6adf, 0x6aaa, 0x6ada, 0x6aea, 0x6afb, 0x6b05,
    0x8616, 0x6afa, 0x6b12, 0x6b16, 0x9b31, 0x6b1f, 0x6b38, 0x6b37,
    0x76dc, 0x6b39, 0x98ee, 0x6b47, 0x6b43, 0x6b49, 0x6b50, 0x6b59,
    0x6b54, 0x6b5b, 0x6b5f, 0x6b61, 0x6b78, 0x6b79, 0x6b7f, 0x6b80,
    0x6b84, 0x6b83, 0x6b8d, 0x6b98, 0x6b95, 0x6b9e, 0x6ba4, 0x6baa,
    0x6bab, 0x6baf, 0x6bb2, 0x6bb1, 0x6bb3, 0x6bb7, 0x6bbc, 0x6bc6,
    0x6bcb, 0x6bd3, 0x6bdf, 0x6bec, 0x6beb, 0x6bf3, 0x6bef, 0x0000,
    0x9ebe, 0x6c08, 0x6c13, 0x6c14, 0x6c1b, 0x6c24, 0x6c23, 0x6c5e,
    0x6c55, 0x6c62, 0x6c6a, 0x6c82, 0x6c8d, 0x6c9a, 0x6c81, 0x6c9b,
    0x6c7e, 0x6c68, 0x6c73, 0x6c92, 0x6c90, 0x6cc4, 0x6cf1, 0x6cd3,
    0x6cbd, 0x6cd7, 0x6cc5, 0x6cdd, 0x6cae, 0x6cb1, 0x6cbe, 0x6cba,
    0x6cdb, 0x6cef, 0x6cd9, 0x6cea, 0x6d1f, 0x884d, 0x6d36, 0x6d2b,
    0x6d3d, 0x6d38, 0x6d19, 0x6d35, 0x6d33, 0x6d12, 0x6d0c, 0x6d63,
    0x6d93, 0x6d64, 0x6d5a, 0x6d79, 0x6d59, 0x6d8e, 0x6d95, 0x6fe4,
    0x6d85, 0x6df9, 0x6e15, 0x6e0a, 0x6db5, 0x6dc7, 0x6de6, 0x6db8,
    0x6dc6, 0x6dec, 0x6dde, 0x6dcc, 0x6de8, 0x6dd2, 0x6dc5, 0x6dfa,
    0x6dd9, 0x6de4, 0x6dd5, 0x6dea, 0x6dee, 0x6e2d, 0x6e6e, 0x6e2e,
    0x6e19, 0x6e72, 0x6e5f, 0x6e3e, 0x6e23, 0x6e6b, 0x6e2b, 0x6e76,
    0x6e4d, 0x6e1f, 0x6e43, 0x6e3a, 0x6e4e, 0x6e24, 0x6eff, 0x6e1d,
    0x6e38, 0x6e82, 0x6eaa, 0x6e98, 0x6ec9, 0x6eb7, 0x6ed3, 0x6ebd,
    0x6eaf, 0x6ec4, 0x6eb2, 0x6ed4, 0x6ed5, 0x6e8f, 0x6ea5, 0x6ec2,
    0x6e9f, 0x6f41, 0x6f11, 0x704c, 0x6eec, 0x6ef8, 0x6efe, 0x6f3f,
    0x6ef2, 0x6f31, 0x6eef, 0x6f32, 0x6ecc, 0x0000, 0x0000, 0x0000
};

static const u16 Se0[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x6f3e, 0x6f13, 0x6ef7, 0x6f86, 0x6f7a, 0x6f78, 0x6f81, 0x6f80,
    0x6f6f, 0x6f5b, 0x6ff3, 0x6f6d, 0x6f82, 0x6f7c, 0x6f58, 0x6f8e,
    0x6f91, 0x6fc2, 0x6f66, 0x6fb3, 0x6fa3, 0x6fa1, 0x6fa4, 0x6fb9,
    0x6fc6, 0x6faa, 0x6fdf, 0x6fd5, 0x6fec, 0x6fd4, 0x6fd8, 0x6ff1,
    0x6fee, 0x6fdb, 0x7009, 0x700b, 0x6ffa, 0x7011, 0x7001, 0x700f,
    0x6ffe, 0x701b, 0x701a, 0x6f74, 0x701d, 0x7018, 0x701f, 0x7030,
    0x703e, 0x7032, 0x7051, 0x7063, 0x7099, 0x7092, 0x70af, 0x70f1,
    0x70ac, 0x70b8, 0x70b3, 0x70ae, 0x70df, 0x70cb, 0x70dd, 0x0000,
    0x70d9, 0x7109, 0x70fd, 0x711c, 0x7119, 0x7165, 0x7155, 0x7188,
    0x7166, 0x7162, 0x714c, 0x7156, 0x716c, 0x718f, 0x71fb, 0x7184,
    0x7195, 0x71a8, 0x71ac, 0x71d7, 0x71b9, 0x71be, 0x71d2, 0x71c9,
    0x71d4, 0x71ce, 0x71e0, 0x71ec, 0x71e7, 0x71f5, 0x71fc, 0x71f9,
    0x71ff, 0x720d, 0x7210, 0x721b, 0x7228, 0x722d, 0x722c, 0x7230,
    0x7232, 0x723b, 0x723c, 0x723f, 0x7240, 0x7246, 0x724b, 0x7258,
    0x7274, 0x727e, 0x7282, 0x7281, 0x7287, 0x7292, 0x7296, 0x72a2,
    0x72a7, 0x72b9, 0x72b2, 0x72c3, 0x72c6, 0x72c4, 0x72ce, 0x72d2,
    0x72e2, 0x72e0, 0x72e1, 0x72f9, 0x72f7, 0x500f, 0x7317, 0x730a,
    0x731c, 0x7316, 0x731d, 0x7334, 0x732f, 0x7329, 0x7325, 0x733e,
    0x734e, 0x734f, 0x9ed8, 0x7357, 0x736a, 0x7368, 0x7370, 0x7378,
    0x7375, 0x737b, 0x737a, 0x73c8, 0x73b3, 0x73ce, 0x73bb, 0x73c0,
    0x73e5, 0x73ee, 0x73de, 0x74a2, 0x7405, 0x746f, 0x7425, 0x73f8,
    0x7432, 0x743a, 0x7455, 0x743f, 0x745f, 0x7459, 0x7441, 0x745c,
    0x7469, 0x7470, 0x7463, 0x746a, 0x7476, 0x747e, 0x748b, 0x749e,
    0x74a7, 0x74ca, 0x74cf, 0x74d4, 0x73f1, 0x0000, 0x0000, 0x0000
};

static const u16 Se1[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x74e0, 0x74e3, 0x74e7, 0x74e9, 0x74ee, 0x74f2, 0x74f0, 0x74f1,
    0x74f8, 0x74f7, 0x7504, 0x7503, 0x7505, 0x750c, 0x750e, 0x750d,
    0x7515, 0x7513, 0x751e, 0x7526, 0x752c, 0x753c, 0x7544, 0x754d,
    0x754a, 0x7549, 0x755b, 0x7546, 0x755a, 0x7569, 0x7564, 0x7567,
    0x756b, 0x756d, 0x7578, 0x7576, 0x7586, 0x7587, 0x7574, 0x758a,
    0x7589, 0x7582, 0x7594, 0x759a, 0x759d, 0x75a5, 0x75a3, 0x75c2,
    0x75b3, 0x75c3, 0x75b5, 0x75bd, 0x75b8, 0x75bc, 0x75b1, 0x75cd,
    0x75ca, 0x75d2, 0x75d9, 0x75e3, 0x75de, 0x75fe, 0x75ff, 0x0000,
    0x75fc, 0x7601, 0x75f0, 0x75fa, 0x75f2, 0x75f3, 0x760b, 0x760d,
    0x7609, 0x761f, 0x7627, 0x7620, 0x7621, 0x7622, 0x7624, 0x7634,
    0x7630, 0x763b, 0x7647, 0x7648, 0x7646, 0x765c, 0x7658, 0x7661,
    0x7662, 0x7668, 0x7669, 0x766a, 0x7667, 0x766c, 0x7670, 0x7672,
    0x7676, 0x7678, 0x767c, 0x7680, 0x7683, 0x7688, 0x768b, 0x768e,
    0x7696, 0x7693, 0x7699, 0x769a, 0x76b0, 0x76b4, 0x76b8, 0x76b9,
    0x76ba, 0x76c2, 0x76cd, 0x76d6, 0x76d2, 0x76de, 0x76e1, 0x76e5,
    0x76e7, 0x76ea, 0x862f, 0x76fb, 0x7708, 0x7707, 0x7704, 0x7729,
    0x7724, 0x771e, 0x7725, 0x7726, 0x771b, 0x7737, 0x7738, 0x7747,
    0x775a, 0x7768, 0x776b, 0x775b, 0x7765, 0x777f, 0x777e, 0x7779,
    0x778e, 0x778b, 0x7791, 0x77a0, 0x779e, 0x77b0, 0x77b6, 0x77b9,
    0x77bf, 0x77bc, 0x77bd, 0x77bb, 0x77c7, 0x77cd, 0x77d7, 0x77da,
    0x77dc, 0x77e3, 0x77ee, 0x77fc, 0x780c, 0x7812, 0x7926, 0x7820,
    0x792a, 0x7845, 0x788e, 0x7874, 0x7886, 0x787c, 0x789a, 0x788c,
    0x78a3, 0x78b5, 0x78aa, 0x78af, 0x78d1, 0x78c6, 0x78cb, 0x78d4,
    0x78be, 0x78bc, 0x78c5, 0x78ca, 0x78ec, 0x0000, 0x0000, 0x0000
};

static const u16 Se2[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x78e7, 0x78da, 0x78fd, 0x78f4, 0x7907, 0x7912, 0x7911, 0x7919,
    0x792c, 0x792b, 0x7940, 0x7960, 0x7957, 0x795f, 0x795a, 0x7955,
    0x7953, 0x797a, 0x797f, 0x798a, 0x799d, 0x79a7, 0x9f4b, 0x79aa,
    0x79ae, 0x79b3, 0x79b9, 0x79ba, 0x79c9, 0x79d5, 0x79e7, 0x79ec,
    0x79e1, 0x79e3, 0x7a08, 0x7a0d, 0x7a18, 0x7a19, 0x7a20, 0x7a1f,
    0x7980, 0x7a31, 0x7a3b, 0x7a3e, 0x7a37, 0x7a43, 0x7a57, 0x7a49,
    0x7a61, 0x7a62, 0x7a69, 0x9f9d, 0x7a70, 0x7a79, 0x7a7d, 0x7a88,
    0x7a97, 0x7a95, 0x7a98, 0x7a96, 0x7aa9, 0x7ac8, 0x7ab0, 0x0000,
    0x7ab6, 0x7ac5, 0x7ac4, 0x7abf, 0x9083, 0x7ac7, 0x7aca, 0x7acd,
    0x7acf, 0x7ad5, 0x7ad3, 0x7ad9, 0x7ada, 0x7add, 0x7ae1, 0x7ae2,
    0x7ae6, 0x7aed, 0x7af0, 0x7b02, 0x7b0f, 0x7b0a, 0x7b06, 0x7b33,
    0x7b18, 0x7b19, 0x7b1e, 0x7b35, 0x7b28, 0x7b36, 0x7b50, 0x7b7a,
    0x7b04, 0x7b4d, 0x7b0b, 0x7b4c, 0x7b45, 0x7b75, 0x7b65, 0x7b74,
    0x7b67, 0x7b70, 0x7b71, 0x7b6c, 0x7b6e, 0x7b9d, 0x7b98, 0x7b9f,
    0x7b8d, 0x7b9c, 0x7b9a, 0x7b8b, 0x7b92, 0x7b8f, 0x7b5d, 0x7b99,
    0x7bcb, 0x7bc1, 0x7bcc, 0x7bcf, 0x7bb4, 0x7bc6, 0x7bdd, 0x7be9,
    0x7c11, 0x7c14, 0x7be6, 0x7be5, 0x7c60, 0x7c00, 0x7c07, 0x7c13,
    0x7bf3, 0x7bf7, 0x7c17, 0x7c0d, 0x7bf6, 0x7c23, 0x7c27, 0x7c2a,
    0x7c1f, 0x7c37, 0x7c2b, 0x7c3d, 0x7c4c, 0x7c43, 0x7c54, 0x7c4f,
    0x7c40, 0x7c50, 0x7c58, 0x7c5f, 0x7c64, 0x7c56, 0x7c65, 0x7c6c,
    0x7c75, 0x7c83, 0x7c90, 0x7ca4, 0x7cad, 0x7ca2, 0x7cab, 0x7ca1,
    0x7ca8, 0x7cb3, 0x7cb2, 0x7cb1, 0x7cae, 0x7cb9, 0x7cbd, 0x7cc0,
    0x7cc5, 0x7cc2, 0x7cd8, 0x7cd2, 0x7cdc, 0x7ce2, 0x9b3b, 0x7cef,
    0x7cf2, 0x7cf4, 0x7cf6, 0x7cfa, 0x7d06, 0x0000, 0x0000, 0x0000
};

static const u16 Se3[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7d02, 0x7d1c, 0x7d15, 0x7d0a, 0x7d45, 0x7d4b, 0x7d2e, 0x7d32,
    0x7d3f, 0x7d35, 0x7d46, 0x7d73, 0x7d56, 0x7d4e, 0x7d72, 0x7d68,
    0x7d6e, 0x7d4f, 0x7d63, 0x7d93, 0x7d89, 0x7d5b, 0x7d8f, 0x7d7d,
    0x7d9b, 0x7dba, 0x7dae, 0x7da3, 0x7db5, 0x7dc7, 0x7dbd, 0x7dab,
    0x7e3d, 0x7da2, 0x7daf, 0x7ddc, 0x7db8, 0x7d9f, 0x7db0, 0x7dd8,
    0x7ddd, 0x7de4, 0x7dde, 0x7dfb, 0x7df2, 0x7de1, 0x7e05, 0x7e0a,
    0x7e23, 0x7e21, 0x7e12, 0x7e31, 0x7e1f, 0x7e09, 0x7e0b, 0x7e22,
    0x7e46, 0x7e66, 0x7e3b, 0x7e35, 0x7e39, 0x7e43, 0x7e37, 0x0000,
    0x7e32, 0x7e3a, 0x7e67, 0x7e5d, 0x7e56, 0x7e5e, 0x7e59, 0x7e5a,
    0x7e79, 0x7e6a, 0x7e69, 0x7e7c, 0x7e7b, 0x7e83, 0x7dd5, 0x7e7d,
    0x8fae, 0x7e7f, 0x7e88, 0x7e89, 0x7e8c, 0x7e92, 0x7e90, 0x7e93,
    0x7e94, 0x7e96, 0x7e8e, 0x7e9b, 0x7e9c, 0x7f38, 0x7f3a, 0x7f45,
    0x7f4c, 0x7f4d, 0x7f4e, 0x7f50, 0x7f51, 0x7f55, 0x7f54, 0x7f58,
    0x7f5f, 0x7f60, 0x7f68, 0x7f69, 0x7f67, 0x7f78, 0x7f82, 0x7f86,
    0x7f83, 0x7f88, 0x7f87, 0x7f8c, 0x7f94, 0x7f9e, 0x7f9d, 0x7f9a,
    0x7fa3, 0x7faf, 0x7fb2, 0x7fb9, 0x7fae, 0x7fb6, 0x7fb8, 0x8b71,
    0x7fc5, 0x7fc6, 0x7fca, 0x7fd5, 0x7fd4, 0x7fe1, 0x7fe6, 0x7fe9,
    0x7ff3, 0x7ff9, 0x98dc, 0x8006, 0x8004, 0x800b, 0x8012, 0x8018,
    0x8019, 0x801c, 0x8021, 0x8028, 0x803f, 0x803b, 0x804a, 0x8046,
    0x8052, 0x8058, 0x805a, 0x805f, 0x8062, 0x8068, 0x8073, 0x8072,
    0x8070, 0x8076, 0x8079, 0x807d, 0x807f, 0x8084, 0x8086, 0x8085,
    0x809b, 0x8093, 0x809a, 0x80ad, 0x5190, 0x80ac, 0x80db, 0x80e5,
    0x80d9, 0x80dd, 0x80c4, 0x80da, 0x80d6, 0x8109, 0x80ef, 0x80f1,
    0x811b, 0x8129, 0x8123, 0x812f, 0x814b, 0x0000, 0x0000, 0x0000
};

static const u16 Se4[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x968b, 0x8146, 0x813e, 0x8153, 0x8151, 0x80fc, 0x8171, 0x816e,
    0x8165, 0x8166, 0x8174, 0x8183, 0x8188, 0x818a, 0x8180, 0x8182,
    0x81a0, 0x8195, 0x81a4, 0x81a3, 0x815f, 0x8193, 0x81a9, 0x81b0,
    0x81b5, 0x81be, 0x81b8, 0x81bd, 0x81c0, 0x81c2, 0x81ba, 0x81c9,
    0x81cd, 0x81d1, 0x81d9, 0x81d8, 0x81c8, 0x81da, 0x81df, 0x81e0,
    0x81e7, 0x81fa, 0x81fb, 0x81fe, 0x8201, 0x8202, 0x8205, 0x8207,
    0x820a, 0x820d, 0x8210, 0x8216, 0x8229, 0x822b, 0x8238, 0x8233,
    0x8240, 0x8259, 0x8258, 0x825d, 0x825a, 0x825f, 0x8264, 0x0000,
    0x8262, 0x8268, 0x826a, 0x826b, 0x822e, 0x8271, 0x8277, 0x8278,
    0x827e, 0x828d, 0x8292, 0x82ab, 0x829f, 0x82bb, 0x82ac, 0x82e1,
    0x82e3, 0x82df, 0x82d2, 0x82f4, 0x82f3, 0x82fa, 0x8393, 0x8303,
    0x82fb, 0x82f9, 0x82de, 0x8306, 0x82dc, 0x8309, 0x82d9, 0x8335,
    0x8334, 0x8316, 0x8332, 0x8331, 0x8340, 0x8339, 0x8350, 0x8345,
    0x832f, 0x832b, 0x8317, 0x8318, 0x8385, 0x839a, 0x83aa, 0x839f,
    0x83a2, 0x8396, 0x8323, 0x838e, 0x8387, 0x838a, 0x837c, 0x83b5,
    0x8373, 0x8375, 0x83a0, 0x8389, 0x83a8, 0x83f4, 0x8413, 0x83eb,
    0x83ce, 0x83fd, 0x8403, 0x83d8, 0x840b, 0x83c1, 0x83f7, 0x8407,
    0x83e0, 0x83f2, 0x840d, 0x8422, 0x8420, 0x83bd, 0x8438, 0x8506,
    0x83fb, 0x846d, 0x842a, 0x843c, 0x855a, 0x8484, 0x8477, 0x846b,
    0x84ad, 0x846e, 0x8482, 0x8469, 0x8446, 0x842c, 0x846f, 0x8479,
    0x8435, 0x84ca, 0x8462, 0x84b9, 0x84bf, 0x849f, 0x84d9, 0x84cd,
    0x84bb, 0x84da, 0x84d0, 0x84c1, 0x84c6, 0x84d6, 0x84a1, 0x8521,
    0x84ff, 0x84f4, 0x8517, 0x8518, 0x852c, 0x851f, 0x8515, 0x8514,
    0x84fc, 0x8540, 0x8563, 0x8558, 0x8548, 0x0000, 0x0000, 0x0000
};

static const u16 Se5[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8541, 0x8602, 0x854b, 0x8555, 0x8580, 0x85a4, 0x8588, 0x8591,
    0x858a, 0x85a8, 0x856d, 0x8594, 0x859b, 0x85ea, 0x8587, 0x859c,
    0x8577, 0x857e, 0x8590, 0x85c9, 0x85ba, 0x85cf, 0x85b9, 0x85d0,
    0x85d5, 0x85dd, 0x85e5, 0x85dc, 0x85f9, 0x860a, 0x8613, 0x860b,
    0x85fe, 0x85fa, 0x8606, 0x8622, 0x861a, 0x8630, 0x863f, 0x864d,
    0x4e55, 0x8654, 0x865f, 0x8667, 0x8671, 0x8693, 0x86a3, 0x86a9,
    0x86aa, 0x868b, 0x868c, 0x86b6, 0x86af, 0x86c4, 0x86c6, 0x86b0,
    0x86c9, 0x8823, 0x86ab, 0x86d4, 0x86de, 0x86e9, 0x86ec, 0x0000,
    0x86df, 0x86db, 0x86ef, 0x8712, 0x8706, 0x8708, 0x8700, 0x8703,
    0x86fb, 0x8711, 0x8709, 0x870d, 0x86f9, 0x870a, 0x8734, 0x873f,
    0x8737, 0x873b, 0x8725, 0x8729, 0x871a, 0x8760, 0x875f, 0x8778,
    0x874c, 0x874e, 0x8774, 0x8757, 0x8768, 0x876e, 0x8759, 0x8753,
    0x8763, 0x876a, 0x8805, 0x87a2, 0x879f, 0x8782, 0x87af, 0x87cb,
    0x87bd, 0x87c0, 0x87d0, 0x96d6, 0x87ab, 0x87c4, 0x87b3, 0x87c7,
    0x87c6, 0x87bb, 0x87ef, 0x87f2, 0x87e0, 0x880f, 0x880d, 0x87fe,
    0x87f6, 0x87f7, 0x880e, 0x87d2, 0x8811, 0x8816, 0x8815, 0x8822,
    0x8821, 0x8831, 0x8836, 0x8839, 0x8827, 0x883b, 0x8844, 0x8842,
    0x8852, 0x8859, 0x885e, 0x8862, 0x886b, 0x8881, 0x887e, 0x889e,
    0x8875, 0x887d, 0x88b5, 0x8872, 0x8882, 0x8897, 0x8892, 0x88ae,
    0x8899, 0x88a2, 0x888d, 0x88a4, 0x88b0, 0x88bf, 0x88b1, 0x88c3,
    0x88c4, 0x88d4, 0x88d8, 0x88d9, 0x88dd, 0x88f9, 0x8902, 0x88fc,
    0x88f4, 0x88e8, 0x88f2, 0x8904, 0x890c, 0x890a, 0x8913, 0x8943,
    0x891e, 0x8925, 0x892a, 0x892b, 0x8941, 0x8944, 0x893b, 0x8936,
    0x8938, 0x894c, 0x891d, 0x8960, 0x895e, 0x0000, 0x0000, 0x0000
};

static const u16 Se6[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8966, 0x8964, 0x896d, 0x896a, 0x896f, 0x8974, 0x8977, 0x897e,
    0x8983, 0x8988, 0x898a, 0x8993, 0x8998, 0x89a1, 0x89a9, 0x89a6,
    0x89ac, 0x89af, 0x89b2, 0x89ba, 0x89bd, 0x89bf, 0x89c0, 0x89da,
    0x89dc, 0x89dd, 0x89e7, 0x89f4, 0x89f8, 0x8a03, 0x8a16, 0x8a10,
    0x8a0c, 0x8a1b, 0x8a1d, 0x8a25, 0x8a36, 0x8a41, 0x8a5b, 0x8a52,
    0x8a46, 0x8a48, 0x8a7c, 0x8a6d, 0x8a6c, 0x8a62, 0x8a85, 0x8a82,
    0x8a84, 0x8aa8, 0x8aa1, 0x8a91, 0x8aa5, 0x8aa6, 0x8a9a, 0x8aa3,
    0x8ac4, 0x8acd, 0x8ac2, 0x8ada, 0x8aeb, 0x8af3, 0x8ae7, 0x0000,
    0x8ae4, 0x8af1, 0x8b14, 0x8ae0, 0x8ae2, 0x8af7, 0x8ade, 0x8adb,
    0x8b0c, 0x8b07, 0x8b1a, 0x8ae1, 0x8b16, 0x8b10, 0x8b17, 0x8b20,
    0x8b33, 0x97ab, 0x8b26, 0x8b2b, 0x8b3e, 0x8b28, 0x8b41, 0x8b4c,
    0x8b4f, 0x8b4e, 0x8b49, 0x8b56, 0x8b5b, 0x8b5a, 0x8b6b, 0x8b5f,
    0x8b6c, 0x8b6f, 0x8b74, 0x8b7d, 0x8b80, 0x8b8c, 0x8b8e, 0x8b92,
    0x8b93, 0x8b96, 0x8b99, 0x8b9a, 0x8c3a, 0x8c41, 0x8c3f, 0x8c48,
    0x8c4c, 0x8c4e, 0x8c50, 0x8c55, 0x8c62, 0x8c6c, 0x8c78, 0x8c7a,
    0x8c82, 0x8c89, 0x8c85, 0x8c8a, 0x8c8d, 0x8c8e, 0x8c94, 0x8c7c,
    0x8c98, 0x621d, 0x8cad, 0x8caa, 0x8cbd, 0x8cb2, 0x8cb3, 0x8cae,
    0x8cb6, 0x8cc8, 0x8cc1, 0x8ce4, 0x8ce3, 0x8cda, 0x8cfd, 0x8cfa,
    0x8cfb, 0x8d04, 0x8d05, 0x8d0a, 0x8d07, 0x8d0f, 0x8d0d, 0x8d10,
    0x9f4e, 0x8d13, 0x8ccd, 0x8d14, 0x8d16, 0x8d67, 0x8d6d, 0x8d71,
    0x8d73, 0x8d81, 0x8d99, 0x8dc2, 0x8dbe, 0x8dba, 0x8dcf, 0x8dda,
    0x8dd6, 0x8dcc, 0x8ddb, 0x8dcb, 0x8dea, 0x8deb, 0x8ddf, 0x8de3,
    0x8dfc, 0x8e08, 0x8e09, 0x8dff, 0x8e1d, 0x8e1e, 0x8e10, 0x8e1f,
    0x8e42, 0x8e35, 0x8e30, 0x8e34, 0x8e4a, 0x0000, 0x0000, 0x0000
};

static const u16 Se7[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8e47, 0x8e49, 0x8e4c, 0x8e50, 0x8e48, 0x8e59, 0x8e64, 0x8e60,
    0x8e2a, 0x8e63, 0x8e55, 0x8e76, 0x8e72, 0x8e7c, 0x8e81, 0x8e87,
    0x8e85, 0x8e84, 0x8e8b, 0x8e8a, 0x8e93, 0x8e91, 0x8e94, 0x8e99,
    0x8eaa, 0x8ea1, 0x8eac, 0x8eb0, 0x8ec6, 0x8eb1, 0x8ebe, 0x8ec5,
    0x8ec8, 0x8ecb, 0x8edb, 0x8ee3, 0x8efc, 0x8efb, 0x8eeb, 0x8efe,
    0x8f0a, 0x8f05, 0x8f15, 0x8f12, 0x8f19, 0x8f13, 0x8f1c, 0x8f1f,
    0x8f1b, 0x8f0c, 0x8f26, 0x8f33, 0x8f3b, 0x8f39, 0x8f45, 0x8f42,
    0x8f3e, 0x8f4c, 0x8f49, 0x8f46, 0x8f4e, 0x8f57, 0x8f5c, 0x0000,
    0x8f62, 0x8f63, 0x8f64, 0x8f9c, 0x8f9f, 0x8fa3, 0x8fad, 0x8faf,
    0x8fb7, 0x8fda, 0x8fe5, 0x8fe2, 0x8fea, 0x8fef, 0x9087, 0x8ff4,
    0x9005, 0x8ff9, 0x8ffa, 0x9011, 0x9015, 0x9021, 0x900d, 0x901e,
    0x9016, 0x900b, 0x9027, 0x9036, 0x9035, 0x9039, 0x8ff8, 0x904f,
    0x9050, 0x9051, 0x9052, 0x900e, 0x9049, 0x903e, 0x9056, 0x9058,
    0x905e, 0x9068, 0x906f, 0x9076, 0x96a8, 0x9072, 0x9082, 0x907d,
    0x9081, 0x9080, 0x908a, 0x9089, 0x908f, 0x90a8, 0x90af, 0x90b1,
    0x90b5, 0x90e2, 0x90e4, 0x6248, 0x90db, 0x9102, 0x9112, 0x9119,
    0x9132, 0x9130, 0x914a, 0x9156, 0x9158, 0x9163, 0x9165, 0x9169,
    0x9173, 0x9172, 0x918b, 0x9189, 0x9182, 0x91a2, 0x91ab, 0x91af,
    0x91aa, 0x91b5, 0x91b4, 0x91ba, 0x91c0, 0x91c1, 0x91c9, 0x91cb,
    0x91d0, 0x91d6, 0x91df, 0x91e1, 0x91db, 0x91fc, 0x91f5, 0x91f6,
    0x921e, 0x91ff, 0x9214, 0x922c, 0x9215, 0x9211, 0x925e, 0x9257,
    0x9245, 0x9249, 0x9264, 0x9248, 0x9295, 0x923f, 0x924b, 0x9250,
    0x929c, 0x9296, 0x9293, 0x929b, 0x925a, 0x92cf, 0x92b9, 0x92b7,
    0x92e9, 0x930f, 0x92fa, 0x9344, 0x932e, 0x0000, 0x0000, 0x0000
};

static const u16 Se8[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9319, 0x9322, 0x931a, 0x9323, 0x933a, 0x9335, 0x933b, 0x935c,
    0x9360, 0x937c, 0x936e, 0x9356, 0x93b0, 0x93ac, 0x93ad, 0x9394,
    0x93b9, 0x93d6, 0x93d7, 0x93e8, 0x93e5, 0x93d8, 0x93c3, 0x93dd,
    0x93d0, 0x93c8, 0x93e4, 0x941a, 0x9414, 0x9413, 0x9403, 0x9407,
    0x9410, 0x9436, 0x942b, 0x9435, 0x9421, 0x943a, 0x9441, 0x9452,
    0x9444, 0x945b, 0x9460, 0x9462, 0x945e, 0x946a, 0x9229, 0x9470,
    0x9475, 0x9477, 0x947d, 0x945a, 0x947c, 0x947e, 0x9481, 0x947f,
    0x9582, 0x9587, 0x958a, 0x9594, 0x9596, 0x9598, 0x9599, 0x0000,
    0x95a0, 0x95a8, 0x95a7, 0x95ad, 0x95bc, 0x95bb, 0x95b9, 0x95be,
    0x95ca, 0x6ff6, 0x95c3, 0x95cd, 0x95cc, 0x95d5, 0x95d4, 0x95d6,
    0x95dc, 0x95e1, 0x95e5, 0x95e2, 0x9621, 0x9628, 0x962e, 0x962f,
    0x9642, 0x964c, 0x964f, 0x964b, 0x9677, 0x965c, 0x965e, 0x965d,
    0x965f, 0x9666, 0x9672, 0x966c, 0x968d, 0x9698, 0x9695, 0x9697,
    0x96aa, 0x96a7, 0x96b1, 0x96b2, 0x96b0, 0x96b4, 0x96b6, 0x96b8,
    0x96b9, 0x96ce, 0x96cb, 0x96c9, 0x96cd, 0x894d, 0x96dc, 0x970d,
    0x96d5, 0x96f9, 0x9704, 0x9706, 0x9708, 0x9713, 0x970e, 0x9711,
    0x970f, 0x9716, 0x9719, 0x9724, 0x972a, 0x9730, 0x9739, 0x973d,
    0x973e, 0x9744, 0x9746, 0x9748, 0x9742, 0x9749, 0x975c, 0x9760,
    0x9764, 0x9766, 0x9768, 0x52d2, 0x976b, 0x9771, 0x9779, 0x9785,
    0x977c, 0x9781, 0x977a, 0x9786, 0x978b, 0x978f, 0x9790, 0x979c,
    0x97a8, 0x97a6, 0x97a3, 0x97b3, 0x97b4, 0x97c3, 0x97c6, 0x97c8,
    0x97cb, 0x97dc, 0x97ed, 0x9f4f, 0x97f2, 0x7adf, 0x97f6, 0x97f5,
    0x980f, 0x980c, 0x9838, 0x9824, 0x9821, 0x9837, 0x983d, 0x9846,
    0x984f, 0x984b, 0x986b, 0x986f, 0x9870, 0x0000, 0x0000, 0x0000
};

static const u16 Se9[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9871, 0x9874, 0x9873, 0x98aa, 0x98af, 0x98b1, 0x98b6, 0x98c4,
    0x98c3, 0x98c6, 0x98e9, 0x98eb, 0x9903, 0x9909, 0x9912, 0x9914,
    0x9918, 0x9921, 0x991d, 0x991e, 0x9924, 0x9920, 0x992c, 0x992e,
    0x993d, 0x993e, 0x9942, 0x9949, 0x9945, 0x9950, 0x994b, 0x9951,
    0x9952, 0x994c, 0x9955, 0x9997, 0x9998, 0x99a5, 0x99ad, 0x99ae,
    0x99bc, 0x99df, 0x99db, 0x99dd, 0x99d8, 0x99d1, 0x99ed, 0x99ee,
    0x99f1, 0x99f2, 0x99fb, 0x99f8, 0x9a01, 0x9a0f, 0x9a05, 0x99e2,
    0x9a19, 0x9a2b, 0x9a37, 0x9a45, 0x9a42, 0x9a40, 0x9a43, 0x0000,
    0x9a3e, 0x9a55, 0x9a4d, 0x9a5b, 0x9a57, 0x9a5f, 0x9a62, 0x9a65,
    0x9a64, 0x9a69, 0x9a6b, 0x9a6a, 0x9aad, 0x9ab0, 0x9abc, 0x9ac0,
    0x9acf, 0x9ad1, 0x9ad3, 0x9ad4, 0x9ade, 0x9adf, 0x9ae2, 0x9ae3,
    0x9ae6, 0x9aef, 0x9aeb, 0x9aee, 0x9af4, 0x9af1, 0x9af7, 0x9afb,
    0x9b06, 0x9b18, 0x9b1a, 0x9b1f, 0x9b22, 0x9b23, 0x9b25, 0x9b27,
    0x9b28, 0x9b29, 0x9b2a, 0x9b2e, 0x9b2f, 0x9b32, 0x9b44, 0x9b43,
    0x9b4f, 0x9b4d, 0x9b4e, 0x9b51, 0x9b58, 0x9b74, 0x9b93, 0x9b83,
    0x9b91, 0x9b96, 0x9b97, 0x9b9f, 0x9ba0, 0x9ba8, 0x9bb4, 0x9bc0,
    0x9bca, 0x9bb9, 0x9bc6, 0x9bcf, 0x9bd1, 0x9bd2, 0x9be3, 0x9be2,
    0x9be4, 0x9bd4, 0x9be1, 0x9c3a, 0x9bf2, 0x9bf1, 0x9bf0, 0x9c15,
    0x9c14, 0x9c09, 0x9c13, 0x9c0c, 0x9c06, 0x9c08, 0x9c12, 0x9c0a,
    0x9c04, 0x9c2e, 0x9c1b, 0x9c25, 0x9c24, 0x9c21, 0x9c30, 0x9c47,
    0x9c32, 0x9c46, 0x9c3e, 0x9c5a, 0x9c60, 0x9c67, 0x9c76, 0x9c78,
    0x9ce7, 0x9cec, 0x9cf0, 0x9d09, 0x9d08, 0x9ceb, 0x9d03, 0x9d06,
    0x9d2a, 0x9d26, 0x9daf, 0x9d23, 0x9d1f, 0x9d44, 0x9d15, 0x9d12,
    0x9d41, 0x9d3f, 0x9d3e, 0x9d46, 0x9d48, 0x0000, 0x0000, 0x0000
};

static const u16 Sea[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9d5d, 0x9d5e, 0x9d64, 0x9d51, 0x9d50, 0x9d59, 0x9d72, 0x9d89,
    0x9d87, 0x9dab, 0x9d6f, 0x9d7a, 0x9d9a, 0x9da4, 0x9da9, 0x9db2,
    0x9dc4, 0x9dc1, 0x9dbb, 0x9db8, 0x9dba, 0x9dc6, 0x9dcf, 0x9dc2,
    0x9dd9, 0x9dd3, 0x9df8, 0x9de6, 0x9ded, 0x9def, 0x9dfd, 0x9e1a,
    0x9e1b, 0x9e1e, 0x9e75, 0x9e79, 0x9e7d, 0x9e81, 0x9e88, 0x9e8b,
    0x9e8c, 0x9e92, 0x9e95, 0x9e91, 0x9e9d, 0x9ea5, 0x9ea9, 0x9eb8,
    0x9eaa, 0x9ead, 0x9761, 0x9ecc, 0x9ece, 0x9ecf, 0x9ed0, 0x9ed4,
    0x9edc, 0x9ede, 0x9edd, 0x9ee0, 0x9ee5, 0x9ee8, 0x9eef, 0x0000,
    0x9ef4, 0x9ef6, 0x9ef7, 0x9ef9, 0x9efb, 0x9efc, 0x9efd, 0x9f07,
    0x9f08, 0x76b7, 0x9f15, 0x9f21, 0x9f2c, 0x9f3e, 0x9f4a, 0x9f52,
    0x9f54, 0x9f63, 0x9f5f, 0x9f60, 0x9f61, 0x9f66, 0x9f67, 0x9f6c,
    0x9f6a, 0x9f77, 0x9f72, 0x9f76, 0x9f95, 0x9f9c, 0x9fa0, 0x582f,
    0x69c7, 0x9059, 0x7464, 0x51dc, 0x7199, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

static const u16 Sed[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7e8a, 0x891c, 0x9348, 0x9288, 0x84dc, 0x4fc9, 0x70bb, 0x6631,
    0x68c8, 0x92f9, 0x66fb, 0x5f45, 0x4e28, 0x4ee1, 0x4efc, 0x4f00,
    0x4f03, 0x4f39, 0x4f56, 0x4f92, 0x4f8a, 0x4f9a, 0x4f94, 0x4fcd,
    0x5040, 0x5022, 0x4fff, 0x501e, 0x5046, 0x5070, 0x5042, 0x5094,
    0x50f4, 0x50d8, 0x514a, 0x5164, 0x519d, 0x51be, 0x51ec, 0x5215,
    0x529c, 0x52a6, 0x52c0, 0x52db, 0x5300, 0x5307, 0x5324, 0x5372,
    0x5393, 0x53b2, 0x53dd, 0xfa0e, 0x549c, 0x548a, 0x54a9, 0x54ff,
    0x5586, 0x5759, 0x5765, 0x57ac, 0x57c8, 0x57c7, 0xfa0f, 0x0000,
    0xfa10, 0x589e, 0x58b2, 0x590b, 0x5953, 0x595b, 0x595d, 0x5963,
    0x59a4, 0x59ba, 0x5b56, 0x5bc0, 0x752f, 0x5bd8, 0x5bec, 0x5c1e,
    0x5ca6, 0x5cba, 0x5cf5, 0x5d27, 0x5d53, 0xfa11, 0x5d42, 0x5d6d,
    0x5db8, 0x5db9, 0x5dd0, 0x5f21, 0x5f34, 0x5f67, 0x5fb7, 0x5fde,
    0x605d, 0x6085, 0x608a, 0x60de, 0x60d5, 0x6120, 0x60f2, 0x6111,
    0x6137, 0x6130, 0x6198, 0x6213, 0x62a6, 0x63f5, 0x6460, 0x649d,
    0x64ce, 0x654e, 0x6600, 0x6615, 0x663b, 0x6609, 0x662e, 0x661e,
    0x6624, 0x6665, 0x6657, 0x6659, 0xfa12, 0x6673, 0x6699, 0x66a0,
    0x66b2, 0x66bf, 0x66fa, 0x670e, 0xf929, 0x6766, 0x67bb, 0x6852,
    0x67c0, 0x6801, 0x6844, 0x68cf, 0xfa13, 0x6968, 0xfa14, 0x6998,
    0x69e2, 0x6a30, 0x6a6b, 0x6a46, 0x6a73, 0x6a7e, 0x6ae2, 0x6ae4,
    0x6bd6, 0x6c3f, 0x6c5c, 0x6c86, 0x6c6f, 0x6cda, 0x6d04, 0x6d87,
    0x6d6f, 0x6d96, 0x6dac, 0x6dcf, 0x6df8, 0x6df2, 0x6dfc, 0x6e39,
    0x6e5c, 0x6e27, 0x6e3c, 0x6ebf, 0x6f88, 0x6fb5, 0x6ff5, 0x7005,
    0x7007, 0x7028, 0x7085, 0x70ab, 0x710f, 0x7104, 0x715c, 0x7146,
    0x7147, 0xfa15, 0x71c1, 0x71fe, 0x72b1, 0x0000, 0x0000, 0x0000
};

static const u16 See[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x72be, 0x7324, 0xfa16, 0x7377, 0x73bd, 0x73c9, 0x73d6, 0x73e3,
    0x73d2, 0x7407, 0x73f5, 0x7426, 0x742a, 0x7429, 0x742e, 0x7462,
    0x7489, 0x749f, 0x7501, 0x756f, 0x7682, 0x769c, 0x769e, 0x769b,
    0x76a6, 0xfa17, 0x7746, 0x52af, 0x7821, 0x784e, 0x7864, 0x787a,
    0x7930, 0xfa18, 0xfa19, 0xfa1a, 0x7994, 0xfa1b, 0x799b, 0x7ad1,
    0x7ae7, 0xfa1c, 0x7aeb, 0x7b9e, 0xfa1d, 0x7d48, 0x7d5c, 0x7db7,
    0x7da0, 0x7dd6, 0x7e52, 0x7f47, 0x7fa1, 0xfa1e, 0x8301, 0x8362,
    0x837f, 0x83c7, 0x83f6, 0x8448, 0x84b4, 0x8553, 0x8559, 0x0000,
    0x856b, 0xfa1f, 0x85b0, 0xfa20, 0xfa21, 0x8807, 0x88f5, 0x8a12,
    0x8a37, 0x8a79, 0x8aa7, 0x8abe, 0x8adf, 0xfa22, 0x8af6, 0x8b53,
    0x8b7f, 0x8cf0, 0x8cf4, 0x8d12, 0x8d76, 0xfa23, 0x8ecf, 0xfa24,
    0xfa25, 0x9067, 0x90de, 0xfa26, 0x9115, 0x9127, 0x91da, 0x91d7,
    0x91de, 0x91ed, 0x91ee, 0x91e4, 0x91e5, 0x9206, 0x9210, 0x920a,
    0x923a, 0x9240, 0x923c, 0x924e, 0x9259, 0x9251, 0x9239, 0x9267,
    0x92a7, 0x9277, 0x9278, 0x92e7, 0x92d7, 0x92d9, 0x92d0, 0xfa27,
    0x92d5, 0x92e0, 0x92d3, 0x9325, 0x9321, 0x92fb, 0xfa28, 0x931e,
    0x92ff, 0x931d, 0x9302, 0x9370, 0x9357, 0x93a4, 0x93c6, 0x93de,
    0x93f8, 0x9431, 0x9445, 0x9448, 0x9592, 0xf9dc, 0xfa29, 0x969d,
    0x96af, 0x9733, 0x973b, 0x9743, 0x974d, 0x974f, 0x9751, 0x9755,
    0x9857, 0x9865, 0xfa2a, 0xfa2b, 0x9927, 0xfa2c, 0x999e, 0x9a4e,
    0x9ad9, 0x9adc, 0x9b75, 0x9b72, 0x9b8f, 0x9bb1, 0x9bbb, 0x9c00,
    0x9d70, 0x9d6b, 0xfa2d, 0x9e19, 0x9ed1, 0x0000, 0x0000, 0x2170,
    0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178,
    0x2179, 0xffe2, 0xffe4, 0xff07, 0xff02, 0x0000, 0x0000, 0x0000
};

static const u16 Sfa[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177,
    0x2178, 0x2179, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165,
    0x2166, 0x2167, 0x2168, 0x2169, 0xffe2, 0xffe4, 0xff07, 0xff02,
    0x3231, 0x2116, 0x2121, 0x2235, 0x7e8a, 0x891c, 0x9348, 0x9288,
    0x84dc, 0x4fc9, 0x70bb, 0x6631, 0x68c8, 0x92f9, 0x66fb, 0x5f45,
    0x4e28, 0x4ee1, 0x4efc, 0x4f00, 0x4f03, 0x4f39, 0x4f56, 0x4f92,
    0x4f8a, 0x4f9a, 0x4f94, 0x4fcd, 0x5040, 0x5022, 0x4fff, 0x501e,
    0x5046, 0x5070, 0x5042, 0x5094, 0x50f4, 0x50d8, 0x514a, 0x0000,
    0x5164, 0x519d, 0x51be, 0x51ec, 0x5215, 0x529c, 0x52a6, 0x52c0,
    0x52db, 0x5300, 0x5307, 0x5324, 0x5372, 0x5393, 0x53b2, 0x53dd,
    0xfa0e, 0x549c, 0x548a, 0x54a9, 0x54ff, 0x5586, 0x5759, 0x5765,
    0x57ac, 0x57c8, 0x57c7, 0xfa0f, 0xfa10, 0x589e, 0x58b2, 0x590b,
    0x5953, 0x595b, 0x595d, 0x5963, 0x59a4, 0x59ba, 0x5b56, 0x5bc0,
    0x752f, 0x5bd8, 0x5bec, 0x5c1e, 0x5ca6, 0x5cba, 0x5cf5, 0x5d27,
    0x5d53, 0xfa11, 0x5d42, 0x5d6d, 0x5db8, 0x5db9, 0x5dd0, 0x5f21,
    0x5f34, 0x5f67, 0x5fb7, 0x5fde, 0x605d, 0x6085, 0x608a, 0x60de,
    0x60d5, 0x6120, 0x60f2, 0x6111, 0x6137, 0x6130, 0x6198, 0x6218,
    0x62a6, 0x63f5, 0x6460, 0x649d, 0x64ce, 0x654e, 0x6600, 0x6615,
    0x663b, 0x6609, 0x662e, 0x661e, 0x6624, 0x6665, 0x6657, 0x6659,
    0xfa12, 0x6673, 0x6699, 0x66a0, 0x66b2, 0x66bf, 0x66fa, 0x670e,
    0xf929, 0x6766, 0x67bb, 0x6852, 0x67c0, 0x6801, 0x6844, 0x68cf,
    0xfa13, 0x6968, 0xfa14, 0x6998, 0x69e2, 0x6a30, 0x6a6b, 0x6a46,
    0x6a73, 0x6a7e, 0x6ae2, 0x6ae4, 0x6bd6, 0x6c3f, 0x6c5c, 0x6c86,
    0x6c6f, 0x6cda, 0x6d04, 0x6d87, 0x6d6f, 0x0000, 0x0000, 0x0000
};

static const u16 Sfb[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x6d96, 0x6dac, 0x6dcf, 0x6df8, 0x6df2, 0x6dfc, 0x6e39, 0x6e5c,
    0x6e27, 0x6e3c, 0x6ebf, 0x6f88, 0x6fb5, 0x6ff5, 0x7005, 0x7007,
    0x7028, 0x7085, 0x70ab, 0x710f, 0x7104, 0x715c, 0x7146, 0x7147,
    0xfa15, 0x71c1, 0x71fe, 0x72b1, 0x72be, 0x7324, 0xfa16, 0x7377,
    0x73bd, 0x73c9, 0x73d6, 0x73e3, 0x73d2, 0x7407, 0x73f5, 0x7426,
    0x742a, 0x7429, 0x742e, 0x7462, 0x7489, 0x749f, 0x7501, 0x756f,
    0x7682, 0x769c, 0x769e, 0x769b, 0x76a6, 0xfa17, 0x7746, 0x52af,
    0x7821, 0x784e, 0x7864, 0x787a, 0x7930, 0xfa18, 0xfa19, 0x0000,
    0xfa1a, 0x7994, 0xfa1b, 0x799b, 0x7ad1, 0x7ae7, 0xfa1c, 0x7aeb,
    0x7b9e, 0xfa1d, 0x7d48, 0x7d5c, 0x7db7, 0x7da0, 0x7dd6, 0x7e52,
    0x7f47, 0x7fa1, 0xfa1e, 0x8301, 0x8362, 0x837f, 0x83c7, 0x83f6,
    0x8448, 0x84b4, 0x8553, 0x8559, 0x856b, 0xfa1f, 0x85b0, 0xfa20,
    0xfa21, 0x8807, 0x88f5, 0x8a12, 0x8a37, 0x8a79, 0x8aa7, 0x8abe,
    0x8adf, 0xfa22, 0x8af6, 0x8b53, 0x8b7f, 0x8cf0, 0x8cf4, 0x8d12,
    0x8d76, 0xfa23, 0x8ecf, 0xfa24, 0xfa25, 0x9067, 0x90de, 0xfa26,
    0x9115, 0x9127, 0x91da, 0x91d7, 0x91de, 0x91ed, 0x91ee, 0x91e4,
    0x91e5, 0x9206, 0x9210, 0x920a, 0x923a, 0x9240, 0x923c, 0x924e,
    0x9259, 0x9251, 0x9239, 0x9267, 0x92a7, 0x9277, 0x9278, 0x92e7,
    0x92d7, 0x92d9, 0x92d0, 0xfa27, 0x92d5, 0x92e0, 0x92d3, 0x9325,
    0x9321, 0x92fb, 0xfa28, 0x931e, 0x92ff, 0x931d, 0x9302, 0x9370,
    0x9357, 0x93a4, 0x93c6, 0x93de, 0x93f8, 0x9431, 0x9445, 0x9448,
    0x9592, 0xf9dc, 0xfa29, 0x969d, 0x96af, 0x9733, 0x973b, 0x9743,
    0x974d, 0x974f, 0x9751, 0x9755, 0x9857, 0x9865, 0xfa2a, 0xfa2b,
    0x9927, 0xfa2c, 0x999e, 0x9a4e, 0x9ad9, 0x0000, 0x0000, 0x0000
};

static const u16 Sfc[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9adc, 0x9b75, 0x9b72, 0x9b8f, 0x9bb1, 0x9bbb, 0x9c00, 0x9d70,
    0x9d6b, 0xfa2d, 0x9e19, 0x9ed1, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

static const u16 *StoU_convert_table[0x100] =
{
    S00, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, S81, S82, S83, S84, ERR, ERR, S87, S88, S89, S8a, S8b, S8c, S8d, S8e, S8f,
    S90, S91, S92, S93, S94, S95, S96, S97, S98, S99, S9a, S9b, S9c, S9d, S9e, S9f,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    Se0, Se1, Se2, Se3, Se4, Se5, Se6, Se7, Se8, Se9, Sea, ERR, ERR, Sed, See, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, Sfa, Sfb, Sfc, ERR, ERR, ERR
};

static const u16 U00[0x100] =
{
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
    0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
    0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
    0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005A, 0x005B, 0x815F, 0x005D, 0x005E, 0x005F,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8191, 0x8192, 0x0000, 0x005C, 0x0000, 0x8198,
    0x814E, 0x0000, 0x0000, 0x0000, 0x81CA, 0x0000, 0x0000, 0x0000,
    0x818B, 0x817D, 0x0000, 0x0000, 0x814C, 0x0000, 0x81F7, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x817E,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8180,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U03[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x839F, 0x83A0, 0x83A1, 0x83A2, 0x83A3, 0x83A4, 0x83A5,
    0x83A6, 0x83A7, 0x83A8, 0x83A9, 0x83AA, 0x83AB, 0x83AC, 0x83AD,
    0x83AE, 0x83AF, 0x0000, 0x83B0, 0x83B1, 0x83B2, 0x83B3, 0x83B4,
    0x83B5, 0x83B6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x83BF, 0x83C0, 0x83C1, 0x83C2, 0x83C3, 0x83C4, 0x83C5,
    0x83C6, 0x83C7, 0x83C8, 0x83C9, 0x83CA, 0x83CB, 0x83CC, 0x83CD,
    0x83CE, 0x83CF, 0x0000, 0x83D0, 0x83D1, 0x83D2, 0x83D3, 0x83D4,
    0x83D5, 0x83D6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U04[0x100] =
{
    0x0000, 0x8446, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8440, 0x8441, 0x8442, 0x8443, 0x8444, 0x8445, 0x8447, 0x8448,
    0x8449, 0x844A, 0x844B, 0x844C, 0x844D, 0x844E, 0x844F, 0x8450,
    0x8451, 0x8452, 0x8453, 0x8454, 0x8455, 0x8456, 0x8457, 0x8458,
    0x8459, 0x845A, 0x845B, 0x845C, 0x845D, 0x845E, 0x845F, 0x8460,
    0x8470, 0x8471, 0x8472, 0x8473, 0x8474, 0x8475, 0x8477, 0x8478,
    0x8479, 0x847A, 0x847B, 0x847C, 0x847D, 0x847E, 0x8480, 0x8481,
    0x8482, 0x8483, 0x8484, 0x8485, 0x8486, 0x8487, 0x8488, 0x8489,
    0x848A, 0x848B, 0x848C, 0x848D, 0x848E, 0x848F, 0x8490, 0x8491,
    0x0000, 0x8476, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U20[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x815D, 0x0000, 0x0000, 0x0000, 0x0000, 0x815C, 0x8161, 0x0000,
    0x8165, 0x8166, 0x0000, 0x0000, 0x8167, 0x8168, 0x0000, 0x0000,
    0x81F5, 0x81F6, 0x0000, 0x0000, 0x0000, 0x8164, 0x8163, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x81F1, 0x0000, 0x818C, 0x818D, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x81A6, 0x0000, 0x0000, 0x007E, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U21[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x818E, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x81F0, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x81A9, 0x81AA, 0x81A8, 0x81AB, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x81CB, 0x0000, 0x81CC, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U22[0x100] =
{
    0x81CD, 0x0000, 0x81DD, 0x81CE, 0x0000, 0x0000, 0x0000, 0x81DE,
    0x81B8, 0x0000, 0x0000, 0x81B9, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x817C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x81E3, 0x0000, 0x0000, 0x81E5, 0x8187, 0x0000,
    0x81DA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x81C8,
    0x81C9, 0x81BF, 0x81BE, 0x81E7, 0x81E8, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8188, 0x81E6, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x81E4, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x81E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8182, 0x81DF, 0x0000, 0x0000, 0x0000, 0x0000, 0x8185, 0x8186,
    0x0000, 0x0000, 0x81E1, 0x81E2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x81BC, 0x81BD, 0x0000, 0x0000, 0x81BA, 0x81BB,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x81DB, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U23[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x81DC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U25[0x100] =
{
    0x849F, 0x84AA, 0x84A0, 0x84AB, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x84A1, 0x0000, 0x0000, 0x84AC,
    0x84A2, 0x0000, 0x0000, 0x84AD, 0x84A4, 0x0000, 0x0000, 0x84AF,
    0x84A3, 0x0000, 0x0000, 0x84AE, 0x84A5, 0x84BA, 0x0000, 0x0000,
    0x84B5, 0x0000, 0x0000, 0x84B0, 0x84A7, 0x84BC, 0x0000, 0x0000,
    0x84B7, 0x0000, 0x0000, 0x84B2, 0x84A6, 0x0000, 0x0000, 0x84B6,
    0x84BB, 0x0000, 0x0000, 0x84B1, 0x84A8, 0x0000, 0x0000, 0x84B8,
    0x84BD, 0x0000, 0x0000, 0x84B3, 0x84A9, 0x0000, 0x0000, 0x84B9,
    0x0000, 0x0000, 0x84BE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x84B4, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x81A1, 0x81A0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x81A3, 0x81A2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x81A5, 0x81A4, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x819F, 0x819E,
    0x0000, 0x0000, 0x0000, 0x819B, 0x0000, 0x0000, 0x819D, 0x819C,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x81FC,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U26[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x819A, 0x8199, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x818A, 0x0000, 0x8189, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x81F4, 0x0000, 0x0000, 0x81F3, 0x0000, 0x81F2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U30[0x100] =
{
    0x8140, 0x8141, 0x8142, 0x8156, 0x0000, 0x8158, 0x8159, 0x815A,
    0x8171, 0x8172, 0x8173, 0x8174, 0x8175, 0x8176, 0x8177, 0x8178,
    0x8179, 0x817A, 0x81A7, 0x81AC, 0x816B, 0x816C, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8160, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x829F, 0x82A0, 0x82A1, 0x82A2, 0x82A3, 0x82A4, 0x82A5,
    0x82A6, 0x82A7, 0x82A8, 0x82A9, 0x82AA, 0x82AB, 0x82AC, 0x82AD,
    0x82AE, 0x82AF, 0x82B0, 0x82B1, 0x82B2, 0x82B3, 0x82B4, 0x82B5,
    0x82B6, 0x82B7, 0x82B8, 0x82B9, 0x82BA, 0x82BB, 0x82BC, 0x82BD,
    0x82BE, 0x82BF, 0x82C0, 0x82C1, 0x82C2, 0x82C3, 0x82C4, 0x82C5,
    0x82C6, 0x82C7, 0x82C8, 0x82C9, 0x82CA, 0x82CB, 0x82CC, 0x82CD,
    0x82CE, 0x82CF, 0x82D0, 0x82D1, 0x82D2, 0x82D3, 0x82D4, 0x82D5,
    0x82D6, 0x82D7, 0x82D8, 0x82D9, 0x82DA, 0x82DB, 0x82DC, 0x82DD,
    0x82DE, 0x82DF, 0x82E0, 0x82E1, 0x82E2, 0x82E3, 0x82E4, 0x82E5,
    0x82E6, 0x82E7, 0x82E8, 0x82E9, 0x82EA, 0x82EB, 0x82EC, 0x82ED,
    0x82EE, 0x82EF, 0x82F0, 0x82F1, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x814A, 0x814B, 0x8154, 0x8155, 0x0000,
    0x0000, 0x8340, 0x8341, 0x8342, 0x8343, 0x8344, 0x8345, 0x8346,
    0x8347, 0x8348, 0x8349, 0x834A, 0x834B, 0x834C, 0x834D, 0x834E,
    0x834F, 0x8350, 0x8351, 0x8352, 0x8353, 0x8354, 0x8355, 0x8356,
    0x8357, 0x8358, 0x8359, 0x835A, 0x835B, 0x835C, 0x835D, 0x835E,
    0x835F, 0x8360, 0x8361, 0x8362, 0x8363, 0x8364, 0x8365, 0x8366,
    0x8367, 0x8368, 0x8369, 0x836A, 0x836B, 0x836C, 0x836D, 0x836E,
    0x836F, 0x8370, 0x8371, 0x8372, 0x8373, 0x8374, 0x8375, 0x8376,
    0x8377, 0x8378, 0x8379, 0x837A, 0x837B, 0x837C, 0x837D, 0x837E,
    0x8380, 0x8381, 0x8382, 0x8383, 0x8384, 0x8385, 0x8386, 0x8387,
    0x8388, 0x8389, 0x838A, 0x838B, 0x838C, 0x838D, 0x838E, 0x838F,
    0x8390, 0x8391, 0x8392, 0x8393, 0x8394, 0x8395, 0x8396, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8145, 0x815B, 0x8152, 0x8153, 0x0000,
};

static const u16 U4e[0x100] =
{
    0x88EA, 0x929A, 0x0000, 0x8EB5, 0x0000, 0x0000, 0x0000, 0x969C,
    0x8FE4, 0x8E4F, 0x8FE3, 0x89BA, 0x0000, 0x9573, 0x975E, 0x0000,
    0x98A0, 0x894E, 0x0000, 0x0000, 0x8A8E, 0x98A1, 0x90A2, 0x99C0,
    0x8B75, 0x95B8, 0x0000, 0x0000, 0x0000, 0x0000, 0x8FE5, 0x0000,
    0x0000, 0x97BC, 0x0000, 0x0000, 0x0000, 0x0000, 0x95C0, 0x0000,
    0x0000, 0x0000, 0x98A2, 0x0000, 0x0000, 0x9286, 0x0000, 0x0000,
    0x0000, 0x98A3, 0x8BF8, 0x0000, 0x0000, 0x0000, 0x98A4, 0x0000,
    0x8ADB, 0x924F, 0x0000, 0x8EE5, 0x98A5, 0x0000, 0x0000, 0x98A6,
    0x0000, 0x0000, 0x98A7, 0x9454, 0x0000, 0x8B76, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9456, 0x0000, 0x93E1, 0x8CC1, 0x9652,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE568, 0x98A8, 0x8FE6,
    0x98A9, 0x89B3, 0x0000, 0x0000, 0x0000, 0x8BE3, 0x8CEE, 0x96E7,
    0x0000, 0x0000, 0x9BA4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9790, 0x0000, 0x93FB, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8AA3, 0x0000,
    0x8B54, 0x0000, 0x98AA, 0x0000, 0x0000, 0x98AB, 0x97B9, 0x0000,
    0x975C, 0x9188, 0x98AD, 0x8E96, 0x93F1, 0x0000, 0x98B0, 0x0000,
    0x0000, 0x895D, 0x8CDD, 0x0000, 0x8CDC, 0x88E4, 0x0000, 0x0000,
    0x986A, 0x9869, 0x0000, 0x8DB1, 0x889F, 0x0000, 0x98B1, 0x98B2,
    0x98B3, 0x9653, 0x98B4, 0x0000, 0x8CF0, 0x88E5, 0x9692, 0x0000,
    0x8B9C, 0x0000, 0x0000, 0x8B9D, 0x8B9E, 0x92E0, 0x97BA, 0x0000,
    0x98B5, 0x0000, 0x0000, 0x98B6, 0x0000, 0x0000, 0x98B7, 0x0000,
    0x0000, 0x0000, 0x906C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8F59, 0x906D, 0x98BC, 0x0000, 0x98BA, 0x0000, 0x98BB, 0x8B77,
    0x0000, 0x0000, 0x8DA1, 0x89EE, 0x0000, 0x98B9, 0x98B8, 0x95A7,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8E65, 0x8E64, 0x91BC, 0x98BD,
    0x9574, 0x90E5, 0x0000, 0x0000, 0x0000, 0x8157, 0x98BE, 0x98C0,
    0x0000, 0x0000, 0x0000, 0x91E3, 0x97DF, 0x88C8, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x98BF, 0x89BC, 0x0000,
    0x8BC2, 0x0000, 0x9287, 0x0000, 0x0000, 0x0000, 0x8C8F, 0x98C1,
    0x0000, 0x0000, 0x0000, 0x9443, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U4f[0x100] =
{
    0x0000, 0x8AE9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x98C2, 0x88C9, 0x0000, 0x0000, 0x8CDE, 0x8AEA, 0x959A,
    0x94B0, 0x8B78, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x89EF, 0x0000, 0x98E5, 0x9360, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x948C,
    0x98C4, 0x0000, 0x0000, 0x0000, 0x94BA, 0x0000, 0x97E0, 0x0000,
    0x904C, 0x0000, 0x8E66, 0x0000, 0x8E97, 0x89BE, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x92CF, 0x0000, 0x0000, 0x9241, 0x98C8,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x88CA, 0x92E1, 0x8F5A,
    0x8DB2, 0x9743, 0x0000, 0x91CC, 0x0000, 0x89BD, 0x0000, 0x98C7,
    0x0000, 0x975D, 0x98C3, 0x98C5, 0x8DEC, 0x98C6, 0x9B43, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x98CE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x98D1,
    0x98CF, 0x0000, 0x0000, 0x89C0, 0x0000, 0x95B9, 0x98C9, 0x0000,
    0x0000, 0x0000, 0x0000, 0x98CD, 0x8CF1, 0x0000, 0x0000, 0x8E67,
    0x0000, 0x0000, 0x0000, 0x8AA4, 0x0000, 0x0000, 0x98D2, 0x0000,
    0x98CA, 0x0000, 0x0000, 0x97E1, 0x0000, 0x8E98, 0x0000, 0x98CB,
    0x0000, 0x98D0, 0x0000, 0x0000, 0x0000, 0x0000, 0x98D3, 0x0000,
    0x98CC, 0x0000, 0x0000, 0x8B9F, 0x0000, 0x88CB, 0x0000, 0x0000,
    0x8BA0, 0x89BF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9B44, 0x0000, 0x9699, 0x958E, 0x8CF2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x904E, 0x97B5, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x95D6,
    0x0000, 0x0000, 0x8C57, 0x91A3, 0x89E2, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8F72, 0x0000, 0x0000, 0x0000, 0x98D7, 0x0000,
    0x98DC, 0x98DA, 0x0000, 0x0000, 0x98D5, 0x0000, 0x0000, 0x91AD,
    0x98D8, 0x0000, 0x98DB, 0x98D9, 0x0000, 0x95DB, 0x0000, 0x98D6,
    0x0000, 0x904D, 0x0000, 0x9693, 0x98DD, 0x98DE, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F43, 0x98EB,
    0x0000, 0x0000, 0x0000, 0x946F, 0x0000, 0x9555, 0x98E6, 0x0000,
    0x95EE, 0x0000, 0x89B4, 0x0000, 0x0000, 0x0000, 0x98EA, 0x0000,
};

static const u16 U50[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x98E4, 0x98ED, 0x0000,
    0x0000, 0x9171, 0x0000, 0x8CC2, 0x0000, 0x947B, 0x0000, 0xE0C5,
    0x0000, 0x98EC, 0x937C, 0x0000, 0x98E1, 0x0000, 0x8CF4, 0x0000,
    0x0000, 0x8CF3, 0x98DF, 0x0000, 0x0000, 0x0000, 0x0000, 0x8ED8,
    0x0000, 0x98E7, 0x0000, 0x95ED, 0x926C, 0x98E3, 0x8C91, 0x0000,
    0x98E0, 0x98E8, 0x98E2, 0x97CF, 0x98E9, 0x9860, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8BE4, 0x0000,
    0x0000, 0x8C90, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x98EE, 0x0000, 0x0000, 0x0000, 0x98EF,
    0x98F3, 0x88CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x95CE,
    0x98F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x98F1, 0x98F5, 0x0000,
    0x0000, 0x0000, 0x98F4, 0x0000, 0x92E2, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8C92, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x98F6, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8EC3, 0x0000, 0x91A4, 0x92E3, 0x8BF4, 0x0000,
    0x98F7, 0x0000, 0x0000, 0x0000, 0x0000, 0x8B55, 0x0000, 0x0000,
    0x98F8, 0x0000, 0x0000, 0x0000, 0x0000, 0x98FA, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9654, 0x0000, 0x0000,
    0x0000, 0x8C86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8E50, 0x94F5, 0x98F9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8DC3, 0x9762, 0x0000, 0x0000,
    0x0000, 0x0000, 0x98FC, 0x9942, 0x98FB, 0x8DC2, 0x0000, 0x8F9D,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8C58, 0x0000,
    0x0000, 0x0000, 0x9943, 0x0000, 0x0000, 0x8BCD, 0x0000, 0x0000,
    0x0000, 0x9940, 0x9941, 0x0000, 0x0000, 0x93AD, 0x0000, 0x919C,
    0x0000, 0x8BA1, 0x0000, 0x0000, 0x0000, 0x966C, 0x9944, 0x0000,
    0x0000, 0x0000, 0x97BB, 0x0000, 0x0000, 0x0000, 0x9945, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9948, 0x0000, 0x9946, 0x0000, 0x916D,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9947, 0x9949, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x994B, 0x0000, 0x0000,
    0x0000, 0x994A, 0x0000, 0x95C6, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U51[0x100] =
{
    0x8B56, 0x994D, 0x994E, 0x0000, 0x89AD, 0x0000, 0x0000, 0x0000,
    0x0000, 0x994C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8EF2, 0x0000, 0x9951, 0x9950, 0x994F, 0x0000,
    0x98D4, 0x0000, 0x9952, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F9E,
    0x0000, 0x9953, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9744, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x96D7, 0x0000, 0x0000, 0x0000, 0x0000, 0x9955,
    0x0000, 0x0000, 0x9954, 0x9957, 0x9956, 0x0000, 0x0000, 0x9958,
    0x9959, 0x88F2, 0x0000, 0x8CB3, 0x8C5A, 0x8F5B, 0x929B, 0x8BA2,
    0x90E6, 0x8CF5, 0x0000, 0x8D8E, 0x995B, 0x96C6, 0x9365, 0x0000,
    0x8E99, 0x0000, 0x995A, 0x0000, 0x995C, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x937D, 0x0000, 0x8A95, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x995D, 0x0000, 0x0000, 0x93FC, 0x0000, 0x0000,
    0x9153, 0x995F, 0x9960, 0x94AA, 0x8CF6, 0x985A, 0x9961, 0x0000,
    0x0000, 0x8BA4, 0x0000, 0x0000, 0x0000, 0x95BA, 0x91B4, 0x8BEF,
    0x9354, 0x0000, 0x0000, 0x0000, 0x8C93, 0x0000, 0x0000, 0x0000,
    0x9962, 0x0000, 0x9963, 0x0000, 0x0000, 0x93E0, 0x897E, 0x0000,
    0x0000, 0x9966, 0x8DFB, 0x0000, 0x9965, 0x8DC4, 0x0000, 0x9967,
    0xE3EC, 0x9968, 0x9660, 0x9969, 0x0000, 0x996A, 0x996B, 0x8FE7,
    0x0000, 0x8ECA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8AA5, 0x0000, 0x996E, 0x0000, 0x996C, 0x96BB, 0x996D, 0x0000,
    0x9579, 0x996F, 0x9970, 0x9971, 0x937E, 0x0000, 0x0000, 0x0000,
    0x9975, 0x9973, 0x9974, 0x9972, 0x8DE1, 0x9976, 0x96E8, 0x97E2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9977, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x90A6, 0x9978, 0x8F79, 0x0000,
    0x0000, 0x9979, 0x0000, 0x929C, 0x97BD, 0x9380, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x99C3, 0x0000,
    0x0000, 0x0000, 0x0000, 0x997A, 0xEAA3, 0x8BC3, 0x0000, 0x0000,
    0x997B, 0x967D, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F88, 0x91FA,
    0x0000, 0x997D, 0x93E2, 0x0000, 0x0000, 0x997E, 0x0000, 0x0000,
    0x9980, 0x8A4D, 0x0000, 0x0000, 0x0000, 0x9981, 0x8BA5, 0x0000,
    0x93CA, 0x899A, 0x8F6F, 0x0000, 0x0000, 0x949F, 0x9982, 0x0000,
};

static const u16 U52[0x100] =
{
    0x9381, 0x0000, 0x0000, 0x906E, 0x9983, 0x0000, 0x95AA, 0x90D8,
    0x8AA0, 0x0000, 0x8AA7, 0x9984, 0x0000, 0x0000, 0x9986, 0x0000,
    0x0000, 0x8C59, 0x0000, 0x0000, 0x9985, 0x0000, 0x0000, 0x97F1,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F89, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x94BB, 0x95CA, 0x0000, 0x9987,
    0x0000, 0x9798, 0x9988, 0x0000, 0x0000, 0x0000, 0x9989, 0x0000,
    0x939E, 0x0000, 0x0000, 0x998A, 0x0000, 0x0000, 0x90A7, 0x8DFC,
    0x8C94, 0x998B, 0x8E68, 0x8D8F, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x92E4, 0x998D, 0x0000, 0x0000, 0x91A5,
    0x0000, 0x0000, 0x8DED, 0x998E, 0x998F, 0x914F, 0x0000, 0x998C,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9991, 0x0000, 0x9655, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8D84, 0x0000, 0x0000, 0x9990, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8C95, 0x8DDC, 0x948D, 0x0000, 0x0000,
    0x0000, 0x9994, 0x9992, 0x0000, 0x0000, 0x0000, 0x0000, 0x959B,
    0x8FE8, 0x999B, 0x8A84, 0x9995, 0x9993, 0x916E, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9997, 0x0000, 0x9996,
    0x0000, 0x0000, 0x0000, 0x8A63, 0x0000, 0x0000, 0x0000, 0x8C80,
    0x999C, 0x97AB, 0x0000, 0x0000, 0x0000, 0x9998, 0x0000, 0x0000,
    0x0000, 0x999D, 0x999A, 0x0000, 0x9999, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x97CD, 0x0000, 0x0000, 0x0000, 0x8CF7,
    0x89C1, 0x0000, 0x0000, 0x97F2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8F95, 0x9377, 0x8D85, 0x99A0, 0x99A1, 0x0000, 0x0000,
    0x0000, 0x97E3, 0x0000, 0x0000, 0x984A, 0x99A3, 0x0000, 0x0000,
    0x0000, 0x8CF8, 0x0000, 0x0000, 0x99A2, 0x0000, 0x8A4E, 0x0000,
    0x0000, 0x99A4, 0x0000, 0x9675, 0x0000, 0x92BA, 0x0000, 0x9745,
    0x0000, 0x95D7, 0x0000, 0x0000, 0x0000, 0x99A5, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE8D3, 0x0000, 0x0000, 0x93AE, 0x0000, 0x99A6,
    0x8AA8, 0x96B1, 0x0000, 0x0000, 0x0000, 0x8F9F, 0x99A7, 0x95E5,
    0x99AB, 0x0000, 0x90A8, 0x99A8, 0x8BCE, 0x0000, 0x99A9, 0x8AA9,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8C4D, 0x99AC, 0x0000, 0x99AD, 0x0000, 0x0000,
    0x99AE, 0x99AF, 0x8ED9, 0x0000, 0x0000, 0x0000, 0x8CF9, 0x96DC,
};

static const u16 U53[0x100] =
{
    0x0000, 0x96E6, 0x93F5, 0x0000, 0x0000, 0x95EF, 0x99B0, 0x0000,
    0x99B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x99B3, 0x0000, 0x99B5,
    0x99B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x99B6, 0x89BB, 0x966B,
    0x0000, 0x8DFA, 0x99B7, 0x0000, 0x0000, 0x9178, 0x0000, 0x0000,
    0x8FA0, 0x8BA7, 0x0000, 0x99B8, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x94D9, 0x0000, 0x0000, 0x0000, 0x0000, 0x99B9,
    0x0000, 0x99BA, 0x0000, 0x99BB, 0x0000, 0x0000, 0x0000, 0x0000,
    0x99BC, 0x9543, 0x8BE6, 0x88E3, 0x0000, 0x0000, 0x0000, 0x93BD,
    0x99BD, 0x8F5C, 0x0000, 0x90E7, 0x0000, 0x99BF, 0x99BE, 0x8FA1,
    0x8CDF, 0x99C1, 0x94BC, 0x0000, 0x0000, 0x99C2, 0x0000, 0x0000,
    0x0000, 0x94DA, 0x91B2, 0x91EC, 0x8BA6, 0x0000, 0x0000, 0x93EC,
    0x9250, 0x0000, 0x948E, 0x0000, 0x966D, 0x0000, 0x99C4, 0x0000,
    0x90E8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8C54, 0x0000,
    0x0000, 0x99C5, 0x0000, 0x0000, 0x0000, 0x0000, 0x99C6, 0x894B,
    0x88F3, 0x8AEB, 0x0000, 0x91A6, 0x8B70, 0x9791, 0x0000, 0x99C9,
    0x89B5, 0x0000, 0x0000, 0x99C8, 0x0000, 0x0000, 0x0000, 0x8BA8,
    0x0000, 0x0000, 0x99CA, 0x0000, 0x96EF, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x99CB, 0x0000,
    0x97D0, 0x0000, 0x8CFA, 0x0000, 0x0000, 0x0000, 0x0000, 0x8CB4,
    0x99CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x99CE, 0x99CD, 0x0000,
    0x907E, 0x8958, 0x0000, 0x0000, 0x0000, 0x897D, 0x99CF, 0x0000,
    0x99D0, 0x0000, 0x0000, 0x8CB5, 0x0000, 0x0000, 0x99D1, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8B8E, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8E51, 0x99D2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9694, 0x8DB3, 0x8B79, 0x9746, 0x916F, 0x94BD, 0x8EFB, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8F66, 0x0000, 0x8EE6, 0x8EF3,
    0x0000, 0x8F96, 0x0000, 0x94BE, 0x0000, 0x0000, 0x0000, 0x99D5,
    0x0000, 0x8962, 0x9170, 0x8CFB, 0x8CC3, 0x8BE5, 0x0000, 0x0000,
    0x99D9, 0x9240, 0x91FC, 0x8BA9, 0x8FA2, 0x99DA, 0x99D8, 0x89C2,
    0x91E4, 0x8EB6, 0x8E6A, 0x8945, 0x0000, 0x0000, 0x8A90, 0x8D86,
    0x8E69, 0x0000, 0x99DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U54[0x100] =
{
    0x0000, 0x99DC, 0x0000, 0x8B68, 0x8A65, 0x0000, 0x0000, 0x0000,
    0x8D87, 0x8B67, 0x92DD, 0x8944, 0x93AF, 0x96BC, 0x8D40, 0x9799,
    0x9366, 0x8CFC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8C4E, 0x0000, 0x99E5, 0x0000, 0x8BE1,
    0x9669, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x94DB, 0x0000,
    0x0000, 0x99E4, 0x0000, 0x8ADC, 0x99DF, 0x99E0, 0x99E2, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x99E3, 0x0000,
    0x8B7A, 0x9081, 0x0000, 0x95AB, 0x99E1, 0x99DD, 0x8CE1, 0x0000,
    0x99DE, 0x0000, 0x9843, 0x0000, 0x0000, 0x0000, 0x95F0, 0x0000,
    0x92E6, 0x8CE0, 0x8D90, 0x0000, 0x0000, 0x0000, 0x99E6, 0x0000,
    0x0000, 0x93DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x99EA,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8EFC, 0x0000, 0x8EF4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x99ED, 0x99EB, 0x0000, 0x96A1, 0x0000, 0x99E8, 0x99F1, 0x99EC,
    0x0000, 0x0000, 0x0000, 0x99EF, 0x8CC4, 0x96BD, 0x0000, 0x0000,
    0x99F0, 0x0000, 0x0000, 0x0000, 0x99F2, 0x0000, 0x99F4, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8DEE, 0x9861, 0x0000, 0x99E9, 0x99E7,
    0x99F3, 0x0000, 0x99EE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x99F6, 0x0000, 0x9A42, 0x99F8, 0x0000, 0x0000,
    0x99FC, 0x0000, 0x0000, 0x9A40, 0x99F9, 0x0000, 0x0000, 0x9A5D,
    0x0000, 0x0000, 0x8DE7, 0x8A50, 0x0000, 0x0000, 0x0000, 0x0000,
    0x99F7, 0x0000, 0x0000, 0x0000, 0x9A44, 0x88F4, 0x9A43, 0x0000,
    0x88A3, 0x9569, 0x9A41, 0x0000, 0x99FA, 0x0000, 0x0000, 0x99F5,
    0x99FB, 0x8DC6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9A45, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x88F5, 0x9A4E, 0x0000, 0x0000, 0x9A46, 0x9A47, 0x0000,
    0x8FA3, 0x9689, 0x0000, 0x0000, 0x0000, 0x9A4C, 0x9A4B, 0x0000,
    0x0000, 0x0000, 0x934E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9A4D, 0x0000, 0x0000, 0x9A4A, 0x0000, 0x0000,
};

static const u16 U55[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x8953, 0x0000, 0x8DB4, 0x904F,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9A48,
    0x9382, 0x0000, 0x0000, 0x0000, 0x9A49, 0x0000, 0x88A0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9A53, 0x9742,
    0x0000, 0x8FA5, 0x0000, 0x9A59, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9A58, 0x9A4F, 0x0000, 0x0000, 0x0000, 0x0000, 0x91C1, 0x0000,
    0x9A50, 0x0000, 0x0000, 0x0000, 0x91ED, 0x9A55, 0x8FA4, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9A52, 0x0000, 0x0000, 0x96E2,
    0x0000, 0x0000, 0x0000, 0x8C5B, 0x0000, 0x0000, 0x9A56, 0x9A57,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9A54, 0x9A5A, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9A51, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9A60, 0x9A65, 0x0000, 0x9A61, 0x0000,
    0x9A5C, 0x0000, 0x0000, 0x9A66, 0x9150, 0x0000, 0x0000, 0x9A68,
    0x0000, 0x8D41, 0x9A5E, 0x929D, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9A62, 0x9A5B, 0x8AAB, 0x0000, 0x8AEC, 0x8A85, 0x9A63, 0x9A5F,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8C96,
    0x9A69, 0x9A67, 0x9172, 0x8B69, 0x8BAA, 0x0000, 0x9A64, 0x0000,
    0x8BF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8963, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9A6D, 0x9A6B, 0x0000, 0x9AA5,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9A70, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9A6A, 0x0000, 0x9A6E, 0x0000, 0x0000, 0x9A6C,
    0x0000, 0x0000, 0x0000, 0x8E6B, 0x9A6F, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9A72,
    0x0000, 0x9A77, 0x0000, 0x0000, 0x0000, 0x9A75, 0x9A74, 0x0000,
};

static const u16 U56[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9251, 0x0000,
    0x0000, 0x89C3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9A71, 0x0000, 0x9A73, 0x8FA6,
    0x8952, 0x0000, 0x0000, 0x9A76, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x89DC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9A82,
    0x0000, 0x8FFA, 0x9A7D, 0x0000, 0x9A7B, 0x0000, 0x9A7C, 0x0000,
    0x9A7E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x895C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9158, 0x0000, 0x9A78, 0x0000,
    0x9A79, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8A9A, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9A81, 0x0000, 0x0000, 0x0000,
    0x8AED, 0x0000, 0x9A84, 0x9A80, 0x9A83, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x95AC, 0x0000, 0x0000, 0x0000,
    0x93D3, 0x0000, 0x94B6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9A86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9A85, 0x8A64,
    0x0000, 0x0000, 0x9A87, 0x0000, 0x0000, 0x0000, 0x0000, 0x9A8A,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9A89, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9A88, 0x0000, 0x9458, 0x0000, 0x0000, 0x9A8B, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9A8C, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9A8E, 0x0000, 0x9A8D, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9A90, 0x0000, 0x0000, 0x0000,
    0x9A93, 0x9A91, 0x9A8F, 0x9A92, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9A94, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9A95, 0x0000,
    0x0000, 0x9A96, 0x0000, 0x9A97, 0x0000, 0x0000, 0x0000, 0x9A98,
    0x9964, 0x0000, 0x8EFA, 0x8E6C, 0x0000, 0x0000, 0x89F1, 0x0000,
    0x88F6, 0x0000, 0x0000, 0x9263, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9A99, 0x0000,
    0x8DA2, 0x0000, 0x88CD, 0x907D, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9A9A, 0x8CC5, 0x0000, 0x0000, 0x8D91, 0x0000, 0x9A9C,
};

static const u16 U57[0x100] =
{
    0x9A9B, 0x0000, 0x0000, 0x95DE, 0x9A9D, 0x0000, 0x0000, 0x0000,
    0x9A9F, 0x9A9E, 0x0000, 0x9AA0, 0x0000, 0x9AA1, 0x0000, 0x8C97,
    0x0000, 0x0000, 0x8980, 0x9AA2, 0x0000, 0x0000, 0x9AA4, 0x0000,
    0x9AA3, 0x0000, 0x0000, 0x0000, 0x9AA6, 0x0000, 0x0000, 0x9379,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9AA7, 0x88B3,
    0x8DDD, 0x0000, 0x0000, 0x0000, 0x0000, 0x8C5C, 0x0000, 0x0000,
    0x926E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9AA8,
    0x9AA9, 0x0000, 0x0000, 0x9AAB, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9AAC, 0x0000, 0x8DE2, 0x0000, 0x0000, 0x0000, 0x0000, 0x8BCF,
    0x0000, 0x0000, 0x9656, 0x0000, 0x0000, 0x0000, 0x9AAA, 0x9AAD,
    0x8DBF, 0x8D42, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9AB1, 0x0000, 0x0000, 0x8DA3, 0x0000, 0x9252, 0x0000,
    0x0000, 0x9AAE, 0x92D8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9AB2,
    0x0000, 0x0000, 0x9082, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9AB0, 0x9AB3, 0x0000, 0x8C5E, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9AB4, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9AB5, 0x0000, 0x8D43, 0x8A5F, 0x9AB7, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9AB8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9AB9, 0x0000, 0x0000, 0x9AB6, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9AAF, 0x0000, 0x0000, 0x9ABA, 0x0000, 0x0000, 0x9ABB, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9684, 0x0000, 0x0000, 0x8FE9, 0x0000,
    0x0000, 0x0000, 0x9ABD, 0x9ABE, 0x9ABC, 0x0000, 0x9AC0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9457, 0x0000, 0x0000, 0x88E6,
    0x9575, 0x0000, 0x0000, 0x9AC1, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8FFB, 0x0000, 0x0000, 0x8EB7,
    0x0000, 0x947C, 0x8AEE, 0x0000, 0x8DE9, 0x0000, 0x0000, 0x0000,
};

static const u16 U58[0x100] =
{
    0x9678, 0x0000, 0x93B0, 0x0000, 0x0000, 0x8C98, 0x91CD, 0x0000,
    0x0000, 0x0000, 0x9ABF, 0x9AC2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x91C2, 0x0000, 0x0000,
    0x0000, 0x9AC3, 0x0000, 0x0000, 0x0000, 0x9AC4, 0x0000, 0x0000,
    0x0000, 0x9AC6, 0x0000, 0x0000, 0x92E7, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8AAC, 0x0000, 0x0000, 0x0000, 0x0000, 0xEA9F,
    0x8981, 0x95F1, 0x0000, 0x0000, 0x8FEA, 0x9367, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8DE4, 0x0000, 0x0000, 0x9ACC, 0x0000, 0x0000,
    0x95BB, 0x97DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x89F2, 0x9AC8, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9159, 0x9ACB, 0x0000, 0x9383, 0x0000, 0x0000, 0x9368,
    0x9384, 0x94B7, 0x92CB, 0x0000, 0x0000, 0x0000, 0x8DC7, 0x0000,
    0x0000, 0x0000, 0x9AC7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8996, 0x0000, 0x9355, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9AC9, 0x0000, 0x9AC5, 0x0000, 0x0000, 0x906F, 0x0000, 0x0000,
    0x0000, 0x9ACD, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F6D, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8BAB, 0x0000, 0x9ACE, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x95E6, 0x0000, 0x0000, 0x0000, 0x919D,
    0x0000, 0x0000, 0x0000, 0x0000, 0x92C4, 0x0000, 0x0000, 0x9AD0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x966E, 0x0000, 0x0000, 0x9AD1, 0x0000, 0x0000, 0x9AD6, 0x0000,
    0x0000, 0x0000, 0x0000, 0x95AD, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9AD5, 0x9ACF, 0x9AD2, 0x9AD4, 0x0000, 0x0000, 0x8DA4, 0x0000,
    0x0000, 0x95C7, 0x0000, 0x0000, 0x0000, 0x9AD7, 0x0000, 0x9264,
    0x0000, 0x0000, 0x89F3, 0x0000, 0x8FEB, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9AD9, 0x0000, 0x9AD8, 0x0000, 0x8D88, 0x0000, 0x9ADA,
    0x9ADC, 0x9ADB, 0x0000, 0x0000, 0x9ADE, 0x0000, 0x9AD3, 0x9AE0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9ADF, 0x9ADD, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8E6D, 0x9070, 0x0000, 0x9173, 0x9AE1,
    0x90BA, 0x88EB, 0x9484, 0x0000, 0x0000, 0x0000, 0x0000, 0x92D9,
    0x0000, 0x9AE3, 0x9AE2, 0x9AE4, 0x9AE5, 0x9AE6, 0x0000, 0x0000,
};

static const u16 U59[0x100] =
{
    0x0000, 0x0000, 0x9AE7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x95CF, 0x9AE8, 0x0000, 0x0000, 0x0000, 0x0000, 0x89C4,
    0x9AE9, 0x0000, 0x0000, 0x0000, 0x0000, 0x975B, 0x8A4F, 0x0000,
    0x99C7, 0x8F67, 0x91BD, 0x9AEA, 0x96E9, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x96B2, 0x0000, 0x0000, 0x9AEC, 0x0000, 0x91E5,
    0x0000, 0x9356, 0x91BE, 0x9576, 0x9AED, 0x9AEE, 0x899B, 0x0000,
    0x0000, 0x8EB8, 0x9AEF, 0x0000, 0x0000, 0x0000, 0x0000, 0x88CE,
    0x9AF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9AF1, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8982, 0x0000, 0x0000, 0x8AEF,
    0x93DE, 0x95F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x9AF5, 0x9174,
    0x9AF4, 0x8C5F, 0x0000, 0x0000, 0x967A, 0x9AF3, 0x0000, 0x9385,
    0x9AF7, 0x0000, 0x9AF6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9AF9, 0x0000, 0x9AF8, 0x0000, 0x0000, 0x899C, 0x0000, 0x9AFA,
    0x8FA7, 0x9AFC, 0x9244, 0x0000, 0x9AFB, 0x0000, 0x95B1, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8F97, 0x937A, 0x0000, 0x0000, 0x0000,
    0x9B40, 0x0000, 0x0000, 0x0000, 0x0000, 0x8D44, 0x0000, 0x0000,
    0x0000, 0x9B41, 0x9440, 0x94DC, 0x96CF, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9444, 0x0000, 0x0000, 0x9B4A, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8B57, 0x0000, 0x0000, 0x9764, 0x0000,
    0x0000, 0x96AD, 0x0000, 0x9BAA, 0x0000, 0x9B42, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9B45, 0x0000, 0x91C3, 0x0000, 0x0000,
    0x9657, 0x0000, 0x0000, 0x0000, 0x9369, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9B46, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9685, 0x0000, 0x8DC8, 0x0000, 0x0000, 0x8FA8, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9B47, 0x0000,
    0x0000, 0x8E6F, 0x0000, 0x8E6E, 0x0000, 0x0000, 0x0000, 0x0000,
    0x88B7, 0x8CC6, 0x0000, 0x90A9, 0x88CF, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9B4B, 0x9B4C, 0x0000, 0x9B49, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8957, 0x8AAD, 0x0000,
    0x9B48, 0x0000, 0x96C3, 0x9550, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x88A6, 0x0000,
    0x0000, 0x0000, 0x0000, 0x88F7, 0x0000, 0x0000, 0x0000, 0x8E70,
};

static const u16 U5a[0x100] =
{
    0x0000, 0x88D0, 0x0000, 0x88A1, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9B51, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9B4F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x96BA, 0x0000, 0x9B52, 0x0000, 0x9B50, 0x0000, 0x0000, 0x9B4E,
    0x9050, 0x0000, 0x0000, 0x0000, 0x0000, 0x9B4D, 0x0000, 0x0000,
    0x0000, 0x95D8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8CE2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9B56, 0x9B57, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8FA9, 0x0000, 0x0000, 0x0000,
    0x9B53, 0x984B, 0x0000, 0x0000, 0x0000, 0x0000, 0x946B, 0x0000,
    0x0000, 0x9B55, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8DA5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9B58, 0x0000, 0x0000, 0x0000, 0x9577, 0x0000,
    0x0000, 0x0000, 0x9B59, 0x0000, 0x9B54, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x96B9,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x947D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9B5A, 0x9551, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9B5B, 0x9B5F, 0x9B5C, 0x0000,
    0x0000, 0x89C5, 0x9B5E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8EB9, 0x0000, 0x9B5D, 0x8C99, 0x0000, 0x0000, 0x0000,
    0x9B6B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9B64, 0x9B61,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9284, 0x0000, 0x9B60, 0x0000, 0x0000, 0x9B62, 0x0000,
    0x0000, 0x9B63, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9B65, 0x9B66, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U5b[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8AF0, 0x0000, 0x9B68, 0x9B67, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9B69, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8FEC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9B6C, 0x0000, 0x92DA, 0x0000, 0x0000, 0x0000,
    0x8964, 0x0000, 0x9B6A, 0x0000, 0x0000, 0x0000, 0x9B6D, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9B6E, 0x0000,
    0x9B71, 0x0000, 0x0000, 0x9B6F, 0x0000, 0x9B70, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8E71, 0x9B72, 0x0000, 0x0000, 0x8D45, 0x9B73, 0x0000, 0x8E9A,
    0x91B6, 0x0000, 0x9B74, 0x9B75, 0x8E79, 0x8D46, 0x0000, 0x96D0,
    0x0000, 0x0000, 0x0000, 0x8B47, 0x8CC7, 0x9B76, 0x8A77, 0x0000,
    0x0000, 0x9B77, 0x0000, 0x91B7, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9B78, 0x9BA1, 0x0000, 0x9B79, 0x0000, 0x9B7A, 0x0000, 0x0000,
    0x9B7B, 0x0000, 0x9B7D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9B7E, 0x0000, 0x0000, 0x9B80, 0x0000, 0x91EE, 0x0000, 0x8946,
    0x8EE7, 0x88C0, 0x0000, 0x9176, 0x8AAE, 0x8EB3, 0x0000, 0x8D47,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9386, 0x0000, 0x8F40,
    0x8AAF, 0x9288, 0x92E8, 0x88B6, 0x8B58, 0x95F3, 0x0000, 0x8EC0,
    0x0000, 0x0000, 0x8B71, 0x90E9, 0x8EBA, 0x9747, 0x9B81, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8B7B, 0x0000,
    0x8DC9, 0x0000, 0x0000, 0x8A51, 0x8983, 0x8FAA, 0x89C6, 0x0000,
    0x9B82, 0x9765, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F68,
    0x0000, 0x0000, 0x8EE2, 0x9B83, 0x8AF1, 0x93D0, 0x96A7, 0x9B84,
    0x0000, 0x9B85, 0x0000, 0x0000, 0x9578, 0x0000, 0x0000, 0x0000,
    0x9B87, 0x0000, 0x8AA6, 0x8BF5, 0x9B86, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8AB0, 0x0000, 0x9051, 0x9B8B, 0x8E40,
    0x0000, 0x89C7, 0x9B8A, 0x0000, 0x9B88, 0x9B8C, 0x9B89, 0x944A,
    0x9ECB, 0x9052, 0x0000, 0x9B8D, 0x0000, 0x0000, 0x97BE, 0x0000,
    0x9B8E, 0x0000, 0x0000, 0x9B90, 0x0000, 0x929E, 0x9B8F, 0x0000,
    0x90A1, 0x0000, 0x8E9B, 0x0000, 0x0000, 0x0000, 0x91CE, 0x8EF5,
};

static const u16 U5c[0x100] =
{
    0x0000, 0x9595, 0x90EA, 0x0000, 0x8ECB, 0x9B91, 0x8FAB, 0x9B92,
    0x9B93, 0x88D1, 0x91B8, 0x9071, 0x0000, 0x9B94, 0x93B1, 0x8FAC,
    0x0000, 0x8FAD, 0x0000, 0x9B95, 0x0000, 0x0000, 0x90EB, 0x0000,
    0x0000, 0x0000, 0x8FAE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9B96, 0x0000, 0x9B97, 0x0000, 0x96DE, 0x0000, 0x0000, 0x0000,
    0x9B98, 0x0000, 0x0000, 0x0000, 0x0000, 0x8BC4, 0x0000, 0x0000,
    0x0000, 0x8F41, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9B99, 0x9B9A, 0x8EDA, 0x904B, 0x93F2, 0x9073, 0x94F6, 0x9441,
    0x8BC7, 0x9B9B, 0x0000, 0x0000, 0x0000, 0x8B8F, 0x9B9C, 0x0000,
    0x8BFC, 0x0000, 0x93CD, 0x89AE, 0x0000, 0x8E72, 0x9B9D, 0x9BA0,
    0x9B9F, 0x8BFB, 0x0000, 0x9B9E, 0x0000, 0x9357, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x91AE, 0x0000,
    0x936A, 0x8EC6, 0x0000, 0x0000, 0x9177, 0x979A, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9BA2, 0x0000, 0x9BA3, 0x93D4,
    0x0000, 0x8E52, 0x0000, 0x0000, 0x0000, 0x0000, 0x9BA5, 0x0000,
    0x0000, 0x9BA6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9BA7, 0x0000, 0x0000, 0x0000,
    0x8AF2, 0x9BA8, 0x0000, 0x0000, 0x9BA9, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x89AA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x915A, 0x8AE2, 0x0000, 0x9BAB, 0x96A6, 0x0000, 0x0000, 0x0000,
    0x0000, 0x91D0, 0x0000, 0x8A78, 0x0000, 0x0000, 0x9BAD, 0x9BAF,
    0x8ADD, 0x0000, 0x0000, 0x9BAC, 0x9BAE, 0x0000, 0x9BB1, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9BB0, 0x0000, 0x9BB2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9BB3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x93BB, 0x8BAC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x89E3, 0x9BB4, 0x9BB9, 0x0000, 0x0000, 0x9BB7, 0x0000, 0x95F5,
    0x95F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9387, 0x0000,
    0x0000, 0x0000, 0x9BB6, 0x8F73, 0x0000, 0x9BB5, 0x0000, 0x0000,
};

static const u16 U5d[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9092,
    0x0000, 0x0000, 0x0000, 0x9BBA, 0x0000, 0x0000, 0x8DE8, 0x0000,
    0x0000, 0x9BC0, 0x0000, 0x0000, 0x9BC1, 0x9BBB, 0x8A52, 0x9BBC,
    0x9BC5, 0x9BC4, 0x9BC3, 0x9BBF, 0x0000, 0x0000, 0x0000, 0x9BBE,
    0x0000, 0x0000, 0x9BC2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x95F6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9BC9, 0x9BC6, 0x0000, 0x9BC8, 0x0000,
    0x9792, 0x0000, 0x9BC7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9BBD, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9093, 0x0000, 0x0000, 0x9BCA, 0x0000, 0x0000, 0x8DB5,
    0x0000, 0x0000, 0x0000, 0x9BCB, 0x0000, 0x0000, 0x9BCC, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9BCF, 0x0000, 0x9BCE, 0x0000, 0x0000, 0x9BCD,
    0x0000, 0x0000, 0x0000, 0x9388, 0x9BB8, 0x0000, 0x0000, 0x0000,
    0x9BD5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9BD1, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9BD0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9BD2, 0x0000, 0x9BD3, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9BD6,
    0x0000, 0x0000, 0x97E4, 0x0000, 0x9BD7, 0x9BD4, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9BD8, 0x0000, 0x0000, 0x8ADE, 0x9BD9, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9BDB, 0x9BDA, 0x0000, 0x0000, 0x9BDC, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9BDD, 0x0000, 0x90EC, 0x8F42, 0x0000,
    0x0000, 0x8F84, 0x0000, 0x9183, 0x0000, 0x8D48, 0x8DB6, 0x8D49,
    0x8B90, 0x0000, 0x0000, 0x9BDE, 0x0000, 0x0000, 0x8DB7, 0x0000,
    0x0000, 0x8CC8, 0x9BDF, 0x96A4, 0x9462, 0x9BE0, 0x0000, 0x8D4A,
    0x0000, 0x0000, 0x0000, 0x8AAA, 0x0000, 0x9246, 0x8BD0, 0x0000,
};

static const u16 U5e[0x100] =
{
    0x0000, 0x0000, 0x8E73, 0x957A, 0x0000, 0x0000, 0x94BF, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9BE1, 0x8AF3, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9BE4, 0x0000, 0x0000, 0x0000, 0x0000, 0x929F, 0x0000,
    0x0000, 0x9BE3, 0x9BE2, 0x9BE5, 0x0000, 0x92E9, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9083, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8E74, 0x0000, 0x90C8, 0x0000, 0x91D1,
    0x8B41, 0x0000, 0x0000, 0x92A0, 0x0000, 0x0000, 0x9BE6, 0x9BE7,
    0x8FED, 0x0000, 0x0000, 0x0000, 0x0000, 0x9658, 0x0000, 0x0000,
    0x9BEA, 0x0000, 0x0000, 0x9BE9, 0x9BE8, 0x959D, 0x0000, 0x9BF1,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9679, 0x0000, 0x9BEB, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9BED, 0x968B, 0x0000, 0x9BEC,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9BEE,
    0x0000, 0x94A6, 0x9BEF, 0x95BC, 0x9BF0, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8AB1, 0x95BD, 0x944E, 0x9BF2, 0x9BF3, 0x0000,
    0x8D4B, 0x8AB2, 0x9BF4, 0x8CB6, 0x9763, 0x9748, 0x8AF4, 0x9BF6,
    0x0000, 0x92A1, 0x0000, 0x8D4C, 0x8FAF, 0x0000, 0x0000, 0x94DD,
    0x0000, 0x0000, 0x8FB0, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F98,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x92EA, 0x95F7, 0x9358,
    0x0000, 0x0000, 0x8D4D, 0x0000, 0x957B, 0x0000, 0x0000, 0x0000,
    0x9BF7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9378, 0x8DC0,
    0x0000, 0x0000, 0x0000, 0x8CC9, 0x0000, 0x92EB, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x88C1, 0x8F8E, 0x8D4E,
    0x9766, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9BF8, 0x9BF9, 0x9470, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9BFA, 0x97F5, 0x984C, 0x0000, 0x0000, 0x0000, 0x0000, 0x9BFC,
    0x9BFB, 0x0000, 0x0000, 0x8A66, 0x0000, 0x0000, 0x9C40, 0x0000,
    0x0000, 0x0000, 0x9C43, 0x9C44, 0x0000, 0x9C42, 0x0000, 0x955F,
    0x8FB1, 0x9C46, 0x9C45, 0x9C41, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9C47, 0x9C48, 0x0000, 0x0000, 0x9C49, 0x0000, 0x0000, 0x0000,
    0x9C4C, 0x9C4A, 0x0000, 0x9C4B, 0x9C4D, 0x0000, 0x8984, 0x92EC,
    0x9C4E, 0x0000, 0x8C9A, 0x89F4, 0x9455, 0x0000, 0x9C4F, 0x93F9,
};

static const u16 U5f[0x100] =
{
    0x0000, 0x95D9, 0x0000, 0x9C50, 0x984D, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9C51, 0x95BE, 0x9C54, 0x989F, 0x98AF, 0x0000, 0x8EAE,
    0x93F3, 0x9C55, 0x0000, 0x8B7C, 0x92A2, 0x88F8, 0x9C56, 0x95A4,
    0x8D4F, 0x0000, 0x0000, 0x926F, 0x0000, 0x0000, 0x0000, 0x92ED,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x96ED, 0x8CB7, 0x8CCA,
    0x0000, 0x9C57, 0x0000, 0x0000, 0x0000, 0x9C58, 0x0000, 0x9C5E,
    0x0000, 0x8EE3, 0x0000, 0x0000, 0x0000, 0x92A3, 0x0000, 0x8BAD,
    0x9C59, 0x0000, 0x0000, 0x0000, 0x954A, 0x0000, 0x9265, 0x0000,
    0x0000, 0x9C5A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9C5B, 0x0000, 0x8BAE, 0x0000, 0x9C5C, 0x0000, 0x9C5D, 0x0000,
    0x0000, 0x9C5F, 0x0000, 0x9396, 0x0000, 0x0000, 0x9C60, 0x9C61,
    0x0000, 0x9C62, 0x0000, 0x0000, 0x9C53, 0x9C52, 0x0000, 0x0000,
    0x0000, 0x9C63, 0x8C60, 0x0000, 0x0000, 0x0000, 0x9546, 0x0000,
    0x0000, 0x8DCA, 0x9556, 0x92A4, 0x956A, 0x9C64, 0x0000, 0x0000,
    0x8FB2, 0x8965, 0x0000, 0x9C65, 0x0000, 0x0000, 0x0000, 0x9C66,
    0x0000, 0x96F0, 0x0000, 0x0000, 0x94DE, 0x0000, 0x0000, 0x9C69,
    0x899D, 0x90AA, 0x9C68, 0x9C67, 0x8C61, 0x91D2, 0x0000, 0x9C6D,
    0x9C6B, 0x0000, 0x9C6A, 0x97A5, 0x8CE3, 0x0000, 0x0000, 0x0000,
    0x8F99, 0x9C6C, 0x936B, 0x8F5D, 0x0000, 0x0000, 0x0000, 0x93BE,
    0x9C70, 0x9C6F, 0x0000, 0x0000, 0x0000, 0x0000, 0x9C6E, 0x0000,
    0x9C71, 0x8CE4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9C72, 0x959C, 0x8F7A, 0x0000, 0x0000, 0x9C73, 0x94F7, 0x0000,
    0x0000, 0x0000, 0x0000, 0x93BF, 0x92A5, 0x0000, 0x0000, 0x0000,
    0x0000, 0x934F, 0x0000, 0x0000, 0x9C74, 0x8B4A, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9053, 0x0000, 0x954B, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8AF5, 0x9445, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9C75, 0x8E75,
    0x9659, 0x965A, 0x0000, 0x0000, 0x899E, 0x9C7A, 0x0000, 0x0000,
    0x9289, 0x0000, 0x0000, 0x0000, 0x9C77, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x89F5, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9CAB, 0x9C79, 0x0000, 0x0000, 0x0000, 0x944F, 0x0000, 0x0000,
    0x9C78, 0x0000, 0x0000, 0x9C76, 0x0000, 0x8D9A, 0x0000, 0x9C7C,
};

static const u16 U60[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9C83, 0x9C89,
    0x9C81, 0x0000, 0x937B, 0x0000, 0x0000, 0x9C86, 0x957C, 0x0000,
    0x0000, 0x9C80, 0x0000, 0x9C85, 0x97E5, 0x8E76, 0x0000, 0x0000,
    0x91D3, 0x9C7D, 0x0000, 0x0000, 0x0000, 0x8B7D, 0x9C88, 0x90AB,
    0x8985, 0x9C82, 0x89F6, 0x9C87, 0x0000, 0x0000, 0x0000, 0x8BAF,
    0x0000, 0x9C84, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9C8A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9C8C, 0x9C96, 0x9C94, 0x0000, 0x0000, 0x9C91, 0x0000,
    0x0000, 0x0000, 0x9C90, 0x97F6, 0x0000, 0x9C92, 0x0000, 0x0000,
    0x8BB0, 0x0000, 0x8D50, 0x0000, 0x0000, 0x8F9A, 0x0000, 0x0000,
    0x0000, 0x9C99, 0x9C8B, 0x0000, 0x0000, 0x0000, 0x0000, 0x9C8F,
    0x9C7E, 0x0000, 0x89F8, 0x9C93, 0x9C95, 0x9270, 0x0000, 0x0000,
    0x8DA6, 0x89B6, 0x9C8D, 0x9C98, 0x9C97, 0x8BB1, 0x0000, 0x91A7,
    0x8A86, 0x0000, 0x0000, 0x0000, 0x0000, 0x8C62, 0x0000, 0x9C8E,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9C9A, 0x0000, 0x9C9D, 0x9C9F, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8EBB, 0x0000, 0x9CA5, 0x92EE, 0x9C9B, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9CA3, 0x0000, 0x89F7, 0x0000, 0x9CA1, 0x9CA2,
    0x0000, 0x0000, 0x9C9E, 0x9CA0, 0x0000, 0x0000, 0x0000, 0x8CE5,
    0x9749, 0x0000, 0x0000, 0x8AB3, 0x0000, 0x0000, 0x8978, 0x9CA4,
    0x0000, 0x9459, 0x88AB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x94DF, 0x9C7B, 0x9CAA, 0x9CAE, 0x96E3, 0x0000,
    0x9CA7, 0x0000, 0x0000, 0x0000, 0x9389, 0x9CAC, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8FEE, 0x9CAD, 0x93D5,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9866, 0x0000, 0x9CA9, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9CAF, 0x0000, 0x8D9B, 0x0000, 0x90C9, 0x0000, 0x0000, 0x88D2,
    0x9CA8, 0x9CA6, 0x0000, 0x9179, 0x0000, 0x0000, 0x0000, 0x9C9C,
    0x8E53, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x91C4, 0x9CBB, 0x0000, 0x917A, 0x9CB6, 0x0000, 0x9CB3, 0x9CB4,
    0x0000, 0x8EE4, 0x9CB7, 0x9CBA, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U61[0x100] =
{
    0x9CB5, 0x8F44, 0x0000, 0x9CB8, 0x0000, 0x0000, 0x9CB2, 0x0000,
    0x96FA, 0x96F9, 0x0000, 0x0000, 0x0000, 0x9CBC, 0x9CBD, 0x88D3,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9CB1, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8BF0, 0x88A4, 0x0000, 0x0000, 0x0000, 0x8AB4,
    0x0000, 0x9CB9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9CC1,
    0x9CC0, 0x0000, 0x0000, 0x0000, 0x9CC5, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9CC6, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9CC4, 0x9CC7, 0x9CBF, 0x9CC3,
    0x0000, 0x0000, 0x9CC8, 0x0000, 0x9CC9, 0x0000, 0x0000, 0x9CBE,
    0x8E9C, 0x0000, 0x9CC2, 0x91D4, 0x8D51, 0x9CB0, 0x9054, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9CD6, 0x0000, 0x95E7, 0x0000, 0x0000,
    0x9CCC, 0x9CCD, 0x9CCE, 0x0000, 0x0000, 0x9CD5, 0x0000, 0x9CD4,
    0x0000, 0x0000, 0x969D, 0x8AB5, 0x0000, 0x9CD2, 0x0000, 0x8C64,
    0x8A53, 0x0000, 0x0000, 0x9CCF, 0x0000, 0x0000, 0x97B6, 0x9CD1,
    0x88D4, 0x9CD3, 0x0000, 0x9CCA, 0x9CD0, 0x9CD7, 0x8C63, 0x9CCB,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x977C, 0x0000,
    0x0000, 0x0000, 0x974A, 0x0000, 0x0000, 0x0000, 0x0000, 0x9CDA,
    0x0000, 0x0000, 0x9CDE, 0x0000, 0x0000, 0x0000, 0x919E, 0x0000,
    0x97F7, 0x9CDF, 0x0000, 0x0000, 0x9CDC, 0x0000, 0x9CD9, 0x0000,
    0x0000, 0x9CD8, 0x9CDD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x95AE, 0x0000, 0x0000, 0x93B2,
    0x0000, 0x8C65, 0x0000, 0x9CE0, 0x9CDB, 0x0000, 0x9CE1, 0x0000,
    0x0000, 0x0000, 0x8C9B, 0x0000, 0x0000, 0x0000, 0x89AF, 0x0000,
    0x0000, 0x0000, 0x9CE9, 0x0000, 0x0000, 0x0000, 0x8AB6, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9CE7, 0x0000, 0x0000, 0x9CE8, 0x8DA7,
    0x9CE6, 0x9CE4, 0x9CE3, 0x9CEA, 0x9CE2, 0x9CEC, 0x0000, 0x0000,
    0x89F9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9CEE, 0x0000, 0x0000, 0x9CED, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x92A6, 0x0000, 0x9CF1, 0x0000, 0x9CEF, 0x9CE5,
    0x8C9C, 0x0000, 0x9CF0, 0x0000, 0x9CF4, 0x9CF3, 0x9CF5, 0x9CF2,
};

static const u16 U62[0x100] =
{
    0x9CF6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9CF7, 0x9CF8, 0x95E8, 0x0000, 0x9CFA, 0x9CF9, 0x8F5E, 0x0000,
    0x90AC, 0x89E4, 0x89FA, 0x0000, 0x9CFB, 0x0000, 0x88BD, 0x0000,
    0x0000, 0x0000, 0x90CA, 0x9CFC, 0x0000, 0xE6C1, 0x9D40, 0x8C81,
    0x0000, 0x9D41, 0x0000, 0x0000, 0x0000, 0x0000, 0x90ED, 0x0000,
    0x0000, 0x0000, 0x9D42, 0x0000, 0x0000, 0x0000, 0x9D43, 0x8B59,
    0x9D44, 0x0000, 0x9D45, 0x9D46, 0x91D5, 0x0000, 0x0000, 0x0000,
    0x8CCB, 0x0000, 0x0000, 0x96DF, 0x0000, 0x0000, 0x0000, 0x965B,
    0x8F8A, 0x9D47, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x90EE,
    0xE7BB, 0x94E0, 0x0000, 0x8EE8, 0x0000, 0x8DCB, 0x9D48, 0x0000,
    0x0000, 0x0000, 0x0000, 0x91C5, 0x0000, 0x95A5, 0x0000, 0x0000,
    0x91EF, 0x0000, 0x0000, 0x9D4B, 0x0000, 0x0000, 0x9D49, 0x0000,
    0x9D4C, 0x0000, 0x0000, 0x9D4A, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9D4D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x95AF, 0x0000,
    0x0000, 0x88B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x957D, 0x0000,
    0x0000, 0x94E1, 0x0000, 0x0000, 0x9D4E, 0x0000, 0x9D51, 0x8FB3,
    0x8B5A, 0x0000, 0x9D4F, 0x9D56, 0x8FB4, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9D50, 0x9463, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x977D, 0x9D52, 0x9D53, 0x9D57, 0x938A, 0x9D54, 0x8D52,
    0x90DC, 0x0000, 0x0000, 0x9D65, 0x94B2, 0x0000, 0x91F0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x94E2, 0x9DAB, 0x0000, 0x0000, 0x0000,
    0x0000, 0x95F8, 0x0000, 0x0000, 0x0000, 0x92EF, 0x0000, 0x0000,
    0x0000, 0x9695, 0x0000, 0x9D5A, 0x899F, 0x928A, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9D63, 0x0000, 0x0000, 0x9253, 0x9D5D, 0x9D64,
    0x9D5F, 0x9D66, 0x9D62, 0x0000, 0x9D61, 0x948F, 0x0000, 0x9D5B,
    0x89FB, 0x9D59, 0x8B91, 0x91F1, 0x9D55, 0x0000, 0x0000, 0x9D58,
    0x8D53, 0x90D9, 0x0000, 0x8FB5, 0x9D60, 0x9471, 0x0000, 0x0000,
    0x8B92, 0x8A67, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8A87, 0x9040, 0x9D68, 0x9D6D,
    0x0000, 0x9D69, 0x0000, 0x8C9D, 0x0000, 0x9D6E, 0x8E41, 0x8D89,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F45, 0x9D5C,
};

static const u16 U63[0x100] =
{
    0x0000, 0x8E9D, 0x9D6B, 0x0000, 0x0000, 0x0000, 0x0000, 0x8E77,
    0x9D6C, 0x88C2, 0x0000, 0x0000, 0x9D67, 0x0000, 0x0000, 0x0000,
    0x0000, 0x92A7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8B93, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8BB2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9D6A,
    0x88A5, 0x0000, 0x0000, 0x8DC1, 0x0000, 0x0000, 0x0000, 0x9055,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x92F0, 0x0000, 0x0000, 0x94D2, 0x9D70, 0x917D,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x91A8, 0x0000, 0x0000, 0x8E4A, 0x9D71, 0x0000, 0x9D73,
    0x9D6F, 0x0000, 0x0000, 0x0000, 0x0000, 0x95DF, 0x0000, 0x92BB,
    0x0000, 0x0000, 0x0000, 0x0000, 0x917B, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x95F9,
    0x8ECC, 0x9D80, 0x0000, 0x9D7E, 0x0000, 0x0000, 0x9098, 0x0000,
    0x0000, 0x0000, 0x8C9E, 0x0000, 0x0000, 0x0000, 0x9D78, 0x8FB7,
    0x0000, 0x0000, 0x93E6, 0x9450, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9D76, 0x0000, 0x0000, 0x917C, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8EF6, 0x9D7B, 0x0000, 0x0000, 0x8FB6, 0x0000, 0x9D75, 0x9D7A,
    0x0000, 0x0000, 0x9472, 0x0000, 0x0000, 0x0000, 0x9D74, 0x0000,
    0x8C40, 0x0000, 0x0000, 0x8A7C, 0x0000, 0x0000, 0x0000, 0x9D7C,
    0x97A9, 0x8DCC, 0x9254, 0x9D79, 0x0000, 0x90DA, 0x0000, 0x8D54,
    0x9084, 0x8986, 0x915B, 0x9D77, 0x8B64, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8C66, 0x0000, 0x92CD, 0x9D7D, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x917E, 0x0000, 0x0000, 0x9D81, 0x0000,
    0x9D83, 0x0000, 0x0000, 0x91B5, 0x9D89, 0x0000, 0x9D84, 0x0000,
    0x0000, 0x9D86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9560,
    0x92F1, 0x0000, 0x9D87, 0x0000, 0x0000, 0x0000, 0x974B, 0x0000,
    0x0000, 0x0000, 0x9767, 0x8AB7, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x88AC, 0x0000, 0x9D85, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9D82, 0x0000, 0x0000, 0x0000, 0x0000, 0x8AF6, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8987, 0x0000, 0x9D88, 0x0000,
    0x0000, 0x0000, 0x9768, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U64[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9D8C, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x91B9, 0x0000, 0x9D93,
    0x0000, 0x0000, 0x0000, 0x9D8D, 0x0000, 0x0000, 0x9D8A, 0x9D91,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9D72, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9D8E, 0x0000,
    0x9D92, 0x0000, 0x0000, 0x0000, 0x94C0, 0x938B, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9D8B, 0x0000, 0x9D8F, 0x0000,
    0x0000, 0x0000, 0x8C67, 0x0000, 0x0000, 0x0000, 0x8DEF, 0x0000,
    0x0000, 0x0000, 0x90DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9D97, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9345, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9D94,
    0x0000, 0x9680, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9D95,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9D96, 0x0000,
    0x96CC, 0x0000, 0x90A0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8C82, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9D9D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8E54, 0x9D9A, 0x0000, 0x9D99, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9451, 0x0000, 0x0000, 0x0000, 0x93B3, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9350, 0x9D9B, 0x0000, 0x0000,
    0x0000, 0x9D9C, 0x0000, 0x958F, 0x0000, 0x9464, 0x8E42, 0x0000,
    0x90EF, 0x0000, 0x966F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8A68, 0x0000, 0x9DA3, 0x9D9E, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9769, 0x9DA5, 0x0000, 0x0000, 0x9DA1, 0x0000, 0x9DA2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9180, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9DA0, 0x0000, 0x9D5E, 0x0000, 0x0000, 0x0000,
    0x9DA4, 0x0000, 0x9D9F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9DA9, 0x9DAA, 0x9346, 0x9DAC, 0x0000, 0x0000, 0x8E43, 0x9DA7,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8B5B, 0x0000, 0x0000, 0x9DAD,
    0x0000, 0x9DA6, 0x9DB1, 0x0000, 0x9DB0, 0x0000, 0x9DAF, 0x0000,
    0x0000, 0x0000, 0x9DB2, 0x0000, 0x0000, 0x9DB4, 0x8FEF, 0x0000,
};

static const u16 U65[0x100] =
{
    0x9DB3, 0x0000, 0x0000, 0x0000, 0x0000, 0x9DB7, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9DB5, 0x0000, 0x0000, 0x0000, 0x9DB6, 0x9D90, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9DB9, 0x9DB8, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9D98, 0x9DBA, 0x9DAE, 0x0000, 0x0000, 0x8E78,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9DBB, 0x9DBC, 0x9DBE, 0x9DBD,
    0x9DBF, 0x89FC, 0x0000, 0x8D55, 0x0000, 0x0000, 0x95FA, 0x90AD,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8CCC, 0x0000, 0x0000,
    0x9DC1, 0x0000, 0x0000, 0x0000, 0x0000, 0x9DC4, 0x0000, 0x9571,
    0x0000, 0x8B7E, 0x0000, 0x0000, 0x0000, 0x9DC3, 0x9DC2, 0x9473,
    0x9DC5, 0x8BB3, 0x0000, 0x0000, 0x0000, 0x9DC7, 0x9DC6, 0x0000,
    0x0000, 0x0000, 0x8AB8, 0x8E55, 0x0000, 0x0000, 0x93D6, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8C68, 0x0000, 0x0000, 0x0000,
    0x9094, 0x0000, 0x9DC8, 0x0000, 0x90AE, 0x9347, 0x0000, 0x957E,
    0x9DC9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9DCA, 0x9DCB, 0x0000, 0x0000, 0x0000, 0x95B6,
    0x9B7C, 0x90C4, 0x0000, 0x0000, 0x956B, 0x0000, 0x8DD6, 0x0000,
    0x94E3, 0x94C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x936C,
    0x0000, 0x97BF, 0x0000, 0x9DCD, 0x8ECE, 0x0000, 0x0000, 0x9DCE,
    0x0000, 0x88B4, 0x0000, 0x0000, 0x8BD2, 0x90CB, 0x0000, 0x9580,
    0x0000, 0x0000, 0x0000, 0x9DCF, 0x8E61, 0x9266, 0x0000, 0x8E7A,
    0x9056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9DD0,
    0x0000, 0x95FB, 0x0000, 0x0000, 0x8997, 0x8E7B, 0x0000, 0x0000,
    0x0000, 0x9DD3, 0x0000, 0x9DD1, 0x9DD4, 0x97B7, 0x9DD2, 0x0000,
    0x0000, 0x0000, 0x0000, 0x90F9, 0x9DD5, 0x0000, 0x0000, 0x91B0,
    0x0000, 0x0000, 0x9DD6, 0x0000, 0x0000, 0x0000, 0x0000, 0x8AF8,
    0x0000, 0x9DD8, 0x0000, 0x9DD7, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9DD9, 0x9DDA, 0x8AF9, 0x0000, 0x0000, 0x93FA, 0x9255, 0x8B8C,
    0x8E7C, 0x9181, 0x0000, 0x0000, 0x8F7B, 0x88AE, 0x0000, 0x0000,
    0x0000, 0x9DDB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x89A0, 0x9DDF, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U66[0x100] =
{
    0x0000, 0x0000, 0x8D56, 0x9DDE, 0x0000, 0x0000, 0x8DA9, 0x8FB8,
    0x0000, 0x0000, 0x9DDD, 0x0000, 0x8FB9, 0x0000, 0x96BE, 0x8DA8,
    0x0000, 0x0000, 0x0000, 0x88D5, 0x90CC, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9DE4, 0x0000, 0x0000, 0x90AF,
    0x8966, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F74, 0x0000, 0x9686,
    0x8DF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x8FBA, 0x0000, 0x90A5,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9DE3, 0x9DE1, 0x9DE2, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x928B, 0x0000, 0x0000, 0x9E45,
    0x0000, 0x9DE8, 0x8E9E, 0x8D57, 0x9DE6, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9DE7, 0x0000, 0x9057, 0x0000, 0x0000, 0x0000, 0x9DE5,
    0x0000, 0x0000, 0x8E4E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9DEA, 0x9DE9, 0x9DEE,
    0x0000, 0x0000, 0x9DEF, 0x0000, 0x9DEB, 0x0000, 0x8A41, 0x9DEC,
    0x9DED, 0x94D3, 0x0000, 0x0000, 0x0000, 0x0000, 0x9581, 0x8C69,
    0x9DF0, 0x0000, 0x0000, 0x0000, 0x90B0, 0x0000, 0x8FBB, 0x0000,
    0x0000, 0x0000, 0x9271, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8BC5, 0x0000, 0x9DF1, 0x9DF5, 0x0000, 0x0000, 0x89C9,
    0x9DF2, 0x9DF4, 0x0000, 0x0000, 0x0000, 0x0000, 0x9DF3, 0x0000,
    0x0000, 0x8F8B, 0x0000, 0x0000, 0x0000, 0x0000, 0x9267, 0x88C3,
    0x9DF6, 0x0000, 0x0000, 0x0000, 0x0000, 0x9DF7, 0x0000, 0x0000,
    0x0000, 0x0000, 0x92A8, 0x0000, 0x0000, 0x0000, 0x97EF, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8E62, 0x0000, 0x0000, 0x95E9, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x965C, 0x0000, 0x0000, 0x0000,
    0x9E41, 0x9DF9, 0x0000, 0x0000, 0x9DFC, 0x0000, 0x9DFB, 0x0000,
    0x0000, 0x9DF8, 0x0000, 0x0000, 0x9E40, 0x0000, 0x0000, 0x93DC,
    0x0000, 0x9DFA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9E42, 0x0000,
    0x0000, 0x8F8C, 0x9E43, 0x0000, 0x976A, 0x9498, 0x0000, 0x0000,
    0x9E44, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9E46, 0x0000,
    0x0000, 0x9E47, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9E48, 0x0000, 0x8BC8, 0x8967, 0x8D58, 0x9E49, 0x0000, 0x9E4A,
    0x8F91, 0x9182, 0x0000, 0x0000, 0x99D6, 0x915D, 0x915C, 0x91D6,
};

static const u16 U67[0x100] =
{
    0x8DC5, 0x0000, 0x0000, 0x98F0, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8C8E, 0x974C, 0x0000, 0x95FC, 0x0000, 0x959E, 0x0000, 0x9E4B,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8DF1, 0x92BD, 0x9E4C, 0x984E,
    0x0000, 0x0000, 0x0000, 0x965D, 0x0000, 0x92A9, 0x9E4D, 0x8AFA,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9E4E, 0x9E4F,
    0x96D8, 0x0000, 0x96A2, 0x9696, 0x967B, 0x8E44, 0x9E51, 0x0000,
    0x0000, 0x8EE9, 0x0000, 0x0000, 0x9670, 0x0000, 0x9E53, 0x9E56,
    0x9E55, 0x0000, 0x8AF7, 0x0000, 0x0000, 0x8B80, 0x0000, 0x9E52,
    0x0000, 0x9E54, 0x0000, 0x0000, 0x0000, 0x0000, 0x9E57, 0x0000,
    0x0000, 0x9099, 0x0000, 0x0000, 0x0000, 0x0000, 0x979B, 0x88C7,
    0x8DDE, 0x91BA, 0x0000, 0x8EDB, 0x0000, 0x0000, 0x8FF1, 0x0000,
    0x0000, 0x9E5A, 0x0000, 0x0000, 0x936D, 0x0000, 0x9E58, 0x91A9,
    0x9E59, 0x8FF0, 0x96DB, 0x9E5B, 0x9E5C, 0x9788, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9E61, 0x0000, 0x0000, 0x8D59, 0x0000, 0x9474,
    0x9E5E, 0x938C, 0x9DDC, 0x9DE0, 0x0000, 0x8B6E, 0x0000, 0x9466,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9E60, 0x0000, 0x8FBC, 0x94C2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9E66, 0x0000, 0x94F8,
    0x0000, 0x9E5D, 0x0000, 0x9E63, 0x9E62, 0x0000, 0x0000, 0x0000,
    0x90CD, 0x0000, 0x0000, 0x0000, 0x0000, 0x968D, 0x0000, 0x97D1,
    0x0000, 0x0000, 0x9687, 0x0000, 0x89CA, 0x8E7D, 0x0000, 0x0000,
    0x9867, 0x9E65, 0x9095, 0x0000, 0x0000, 0x0000, 0x9E64, 0x0000,
    0x0000, 0x9E5F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8CCD,
    0x0000, 0x0000, 0x0000, 0x9E6B, 0x9E69, 0x0000, 0x89CB, 0x9E67,
    0x9E6D, 0x9E73, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x91C6, 0x0000, 0x0000, 0x95BF, 0x0000, 0x9E75, 0x0000,
    0x0000, 0x0000, 0x9541, 0x0000, 0x0000, 0x0000, 0x9E74, 0x9490,
    0x965E, 0x8AB9, 0x0000, 0x90F5, 0x8F5F, 0x0000, 0x0000, 0x0000,
    0x92D1, 0x0000, 0x974D, 0x0000, 0x0000, 0x9E70, 0x9E6F, 0x0000,
    0x0000, 0x0000, 0x9E71, 0x0000, 0x9E6E, 0x0000, 0x0000, 0x9E76,
    0x0000, 0x9E6C, 0x0000, 0x0000, 0x9E6A, 0x0000, 0x9E72, 0x9E68,
    0x0000, 0x928C, 0x0000, 0x96F6, 0x8EC4, 0x8DF2, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8DB8, 0x0000, 0x0000, 0x968F, 0x8A60,
};

static const u16 U68[0x100] =
{
    0x0000, 0x0000, 0x92CC, 0x93C8, 0x8968, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x90F0, 0x0000, 0x0000, 0x90B2, 0x8C49,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9E78, 0x0000,
    0x0000, 0x8D5A, 0x8A9C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9E7A, 0x8A94, 0x9E81, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9E7D, 0x0000, 0x90F1, 0x0000, 0x0000, 0x0000,
    0x8A6A, 0x8DAA, 0x0000, 0x0000, 0x8A69, 0x8DCD, 0x0000, 0x0000,
    0x9E7B, 0x8C85, 0x8C6A, 0x938D, 0x0000, 0x0000, 0x9E79, 0x0000,
    0x88C4, 0x0000, 0x0000, 0x0000, 0x0000, 0x9E7C, 0x9E7E, 0x0000,
    0x8BCB, 0x8C4B, 0x0000, 0x8ABA, 0x8B6A, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9E82, 0x0000, 0x0000, 0x8DF7, 0x9691, 0x0000, 0x8E56,
    0x0000, 0x0000, 0x0000, 0x9E83, 0x0000, 0x0000, 0x0000, 0x954F,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9E8F, 0x0000, 0x89B1, 0x9E84,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9E95, 0x9E85,
    0x0000, 0x97C0, 0x0000, 0x9E8C, 0x0000, 0x947E, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9E94, 0x0000, 0x9E87,
    0x0000, 0x0000, 0x0000, 0x88B2, 0x9E89, 0x0000, 0x0000, 0x8D5B,
    0x0000, 0x0000, 0x0000, 0x9E8B, 0x0000, 0x9E8A, 0x0000, 0x9E86,
    0x9E91, 0x0000, 0x8FBD, 0x0000, 0x0000, 0x0000, 0x9AEB, 0x8CE6,
    0x979C, 0x0000, 0x0000, 0x0000, 0x0000, 0x9E88, 0x0000, 0x92F2,
    0x8A42, 0x8DAB, 0x0000, 0x9E80, 0x0000, 0x9E90, 0x8A81, 0x0000,
    0x0000, 0x9E8E, 0x9E92, 0x0000, 0x938E, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8AFC, 0x0000, 0x9EB0, 0x0000,
    0x0000, 0x96C7, 0x9E97, 0x8AFB, 0x0000, 0x9E9E, 0x0000, 0x0000,
    0x0000, 0x0000, 0x965F, 0x0000, 0x9E9F, 0x9EA1, 0x0000, 0x9EA5,
    0x9E99, 0x0000, 0x9249, 0x0000, 0x0000, 0x0000, 0x0000, 0x938F,
    0x9EA9, 0x9E9C, 0x0000, 0x9EA6, 0x0000, 0x0000, 0x0000, 0x9EA0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9058, 0x9EAA,
    0x0000, 0x0000, 0x90B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9EA8, 0x8ABB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U69[0x100] =
{
    0x986F, 0x9E96, 0x0000, 0x0000, 0x9EA4, 0x88D6, 0x0000, 0x0000,
    0x9E98, 0x0000, 0x0000, 0x96B8, 0x9E9D, 0x9041, 0x92C5, 0x9E93,
    0x0000, 0x0000, 0x9EA3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x909A, 0x9EAD, 0x8A91, 0x8C9F, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9EAF, 0x9E9A, 0x9EAE, 0x0000, 0x9EA7, 0x9E9B, 0x0000,
    0x9EAB, 0x0000, 0x9EAC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9EBD, 0x0000, 0x0000, 0x0000, 0x93CC, 0x0000, 0x9EA2, 0x0000,
    0x0000, 0x9EB9, 0x0000, 0x0000, 0x0000, 0x9EBB, 0x0000, 0x92D6,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x976B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9596, 0x9EB6, 0x91C8, 0x0000, 0x0000,
    0x0000, 0x9EBC, 0x915E, 0x0000, 0x9EB3, 0x9EC0, 0x9EBF, 0x0000,
    0x93ED, 0x9EBE, 0x93E8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9EC2, 0x9EB5, 0x0000, 0x8BC6, 0x9EB8, 0x8F7C,
    0x0000, 0x0000, 0x0000, 0x9480, 0x9EBA, 0x8BC9, 0x0000, 0x9EB2,
    0x9EB4, 0x9EB1, 0x0000, 0x0000, 0x984F, 0x8A79, 0x9EB7, 0x0000,
    0x0000, 0x9EC1, 0x8A54, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8DE5, 0x0000, 0x0000, 0x0000, 0x897C, 0x0000,
    0x0000, 0x9ED2, 0x0000, 0x0000, 0x9850, 0x9ED5, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9059, 0x9ED4, 0x0000, 0x0000, 0x0000,
    0x9ED3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9ED0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9EC4, 0x0000,
    0x0000, 0x9EE1, 0x9EC3, 0x0000, 0x9ED6, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9ECE, 0x0000, 0x0000, 0x9EC9, 0x9EC6,
    0x0000, 0x9EC7, 0x0000, 0x9ECF, 0x0000, 0x0000, 0x0000, 0xEAA0,
    0x0000, 0x0000, 0x9ECC, 0x8D5C, 0x92C6, 0x9184, 0x9ECA, 0x0000,
    0x9EC5, 0x0000, 0x0000, 0x9EC8, 0x0000, 0x0000, 0x0000, 0x0000,
    0x976C, 0x968A, 0x0000, 0x0000, 0x0000, 0x9ECD, 0x9ED7, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9EDF,
    0x9ED8, 0x0000, 0x0000, 0x9EE5, 0x0000, 0x9EE3, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9EDE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9EDD, 0x0000, 0x92CE, 0x0000, 0x9185, 0x0000, 0x9EDB,
};

static const u16 U6a[0x100] =
{
    0x0000, 0x0000, 0x9ED9, 0x0000, 0x0000, 0x9EE0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9EE6, 0x94F3, 0x9EEC, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9EE7, 0x9EEA, 0x9EE4, 0x0000, 0x0000, 0x9294,
    0x0000, 0x9557, 0x0000, 0x9EDA, 0x0000, 0x0000, 0x9EE2, 0x8FBE,
    0x0000, 0x96CD, 0x9EF6, 0x9EE9, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8CA0, 0x89A1, 0x8A7E, 0x0000, 0x0000, 0x9ED1, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8FBF, 0x9EEE, 0x0000,
    0x9EF5, 0x8EF7, 0x8A92, 0x0000, 0x0000, 0x924D, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9EEB, 0x0000, 0x0000, 0x9EF0,
    0x9EF4, 0x0000, 0x0000, 0x8BB4, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8B6B, 0x9EF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8B40,
    0x0000, 0x93C9, 0x9EF1, 0x0000, 0x0000, 0x0000, 0x9EF3, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9EED, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9EEF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8A80,
    0x9268, 0x0000, 0x0000, 0x0000, 0x9EFA, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9EF8, 0x8CE7, 0x0000,
    0x9EF7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9F40,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9E77, 0x0000, 0x0000, 0x0000,
    0x9EF9, 0x0000, 0x9EFB, 0x9EFC, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9F4B, 0x0000, 0x9F47, 0x0000, 0x9E8D, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9F46, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9F45, 0x0000, 0x0000, 0x9F42, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9EE8, 0x9F44, 0x9F43, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9F49, 0x0000, 0x9845, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9F4C, 0x8BF9, 0x0000, 0x0000, 0x9F48, 0x9F4A,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x94A5, 0x0000, 0x9F4D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9F51, 0x9F4E, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U6b[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x9793, 0x9F4F, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9EDC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9F52, 0x0000, 0x0000, 0x0000, 0x9F53, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8954, 0x0000, 0x9F55,
    0x8C87, 0x8E9F, 0x0000, 0x8BD3, 0x0000, 0x0000, 0x0000, 0x89A2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x977E, 0x0000, 0x0000, 0x0000, 0x0000, 0x9F57,
    0x9F56, 0x9F59, 0x8B5C, 0x0000, 0x0000, 0x8BD4, 0x8ABC, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9F5C, 0x0000, 0x0000, 0x0000, 0x9F5B,
    0x0000, 0x9F5D, 0x0000, 0x0000, 0x89CC, 0x0000, 0x9256, 0x0000,
    0x9F5E, 0x0000, 0x0000, 0x8ABD, 0x9F60, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9F5F, 0x0000, 0x9F61, 0x0000, 0x0000, 0x0000, 0x9F62,
    0x0000, 0x9F63, 0x8E7E, 0x90B3, 0x8D9F, 0x0000, 0x9590, 0x0000,
    0x0000, 0x95E0, 0x9863, 0x0000, 0x0000, 0x0000, 0x0000, 0x8E95,
    0x0000, 0x0000, 0x0000, 0x8DCE, 0x97F0, 0x0000, 0x0000, 0x0000,
    0x9F64, 0x9F65, 0x0000, 0x8E80, 0x0000, 0x0000, 0x0000, 0x9F66,
    0x9F67, 0x0000, 0x0000, 0x9F69, 0x9F68, 0x0000, 0x9677, 0x0000,
    0x0000, 0x8F7D, 0x8EEA, 0x8E63, 0x0000, 0x9F6A, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9F6C, 0x9042, 0x0000,
    0x9F6B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9F6D, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9F6E, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9F6F, 0x9F70, 0x0000, 0x0000, 0x0000, 0x9F71,
    0x0000, 0x9F73, 0x9F72, 0x9F74, 0x89A3, 0x9269, 0x0000, 0x9F75,
    0x0000, 0x0000, 0x8E45, 0x8A6B, 0x9F76, 0x0000, 0x0000, 0x9361,
    0x9ACA, 0x0000, 0x0000, 0x0000, 0x0000, 0x8B42, 0x9F77, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9F78, 0x0000, 0x95EA, 0x9688, 0x0000,
    0x0000, 0x0000, 0x93C5, 0x9F79, 0x94E4, 0x0000, 0x0000, 0x0000,
    0x94F9, 0x0000, 0x0000, 0x96D1, 0x0000, 0x0000, 0x0000, 0x9F7A,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9F7C, 0x9F7B, 0x0000, 0x0000, 0x9F7E,
    0x0000, 0x0000, 0x0000, 0x9F7D, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U6c[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9F81, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8E81,
    0x0000, 0x96AF, 0x0000, 0x9F82, 0x9F83, 0x0000, 0x0000, 0x8B43,
    0x0000, 0x0000, 0x0000, 0x9F84, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9F86, 0x9F85, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9085, 0x0000, 0x0000, 0x9558,
    0x8969, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x94C3, 0x0000,
    0x92F3, 0x8F60, 0x8B81, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x94C4, 0x0000,
    0x8EAC, 0x0000, 0x0000, 0x0000, 0x0000, 0x9F88, 0x0000, 0x8ABE,
    0x0000, 0x0000, 0x8998, 0x0000, 0x0000, 0x93F0, 0x9F87, 0x8D5D,
    0x9272, 0x0000, 0x9F89, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9F91, 0x0000, 0x9F8A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x91BF, 0x0000, 0x8B82, 0x9F92, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8C88, 0x0000, 0x0000, 0x8B44, 0x9F90, 0x0000,
    0x0000, 0x9F8E, 0x9F8B, 0x9780, 0x0000, 0x0000, 0x0000, 0x0000,
    0x92BE, 0x0000, 0x0000, 0x0000, 0x93D7, 0x9F8C, 0x0000, 0x0000,
    0x9F94, 0x0000, 0x9F93, 0x8C42, 0x0000, 0x0000, 0x89AB, 0x0000,
    0x0000, 0x8DB9, 0x9F8D, 0x9F8F, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9676, 0x91F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9697, 0x0000, 0x0000, 0x9F9C, 0x0000,
    0x0000, 0x9F9D, 0x0000, 0x89CD, 0x0000, 0x0000, 0x0000, 0x0000,
    0x95A6, 0x96FB, 0x9F9F, 0x8EA1, 0x8FC0, 0x9F98, 0x9F9E, 0x8988,
    0x0000, 0x8BB5, 0x0000, 0x0000, 0x9F95, 0x9F9A, 0x0000, 0x0000,
    0x0000, 0x90F2, 0x9491, 0x0000, 0x94E5, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9F97, 0x0000, 0x9640, 0x0000, 0x9F99,
    0x0000, 0x9FA2, 0x0000, 0x9FA0, 0x0000, 0x9F9B, 0x0000, 0x0000,
    0x0000, 0x9641, 0x9467, 0x8B83, 0x0000, 0x9344, 0x0000, 0x0000,
    0x928D, 0x0000, 0x9FA3, 0x0000, 0x0000, 0x0000, 0x0000, 0x9FA1,
    0x91D7, 0x9F96, 0x0000, 0x896A, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U6d[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x976D, 0x9FAE, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9FAD, 0x0000, 0x0000, 0x0000, 0x0000, 0x90F4,
    0x0000, 0x9FAA, 0x0000, 0x978C, 0x0000, 0x0000, 0x93B4, 0x9FA4,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x92C3, 0x0000, 0x0000,
    0x0000, 0x896B, 0x8D5E, 0x9FA7, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8F46, 0x9FAC, 0x0000, 0x9FAB, 0x9FA6, 0x0000,
    0x9FA9, 0x0000, 0x0000, 0x8A88, 0x0000, 0x9FA8, 0x9468, 0x0000,
    0x0000, 0x97AC, 0x0000, 0x0000, 0x8FF2, 0x90F3, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9FB4, 0x9FB2, 0x0000, 0x956C, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9FAF, 0x9FB1, 0x0000, 0x8959, 0x0000,
    0x0000, 0x8D5F, 0x9851, 0x0000, 0x8A5C, 0x0000, 0x9582, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9781, 0x0000, 0x0000, 0x8A43,
    0x905A, 0x9FB3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9FB8, 0x0000, 0x0000,
    0x8FC1, 0x0000, 0x0000, 0x0000, 0x974F, 0x0000, 0x9FB5, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9FB0, 0x0000, 0x9FB6, 0x0000, 0x0000,
    0x0000, 0x97DC, 0x0000, 0x9393, 0x93C0, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8A55,
    0x0000, 0x0000, 0x8974, 0x0000, 0x0000, 0x9FBC, 0x0000, 0x0000,
    0x9FBF, 0x0000, 0x0000, 0x0000, 0x97C1, 0x0000, 0x0000, 0x0000,
    0x9784, 0x0000, 0x0000, 0x0000, 0x0000, 0x9FC6, 0x9FC0, 0x9FBD,
    0x0000, 0x0000, 0x0000, 0x97D2, 0x9FC3, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8F69, 0x9FC5, 0x0000, 0x0000, 0x9FCA, 0x0000, 0x0000,
    0x9391, 0x9FC8, 0x0000, 0x0000, 0x0000, 0x0000, 0x9FC2, 0x0000,
    0x0000, 0x9257, 0x0000, 0x0000, 0x9FC9, 0x0000, 0x9FBE, 0x0000,
    0x9FC4, 0x0000, 0x9FCB, 0x88FA, 0x9FC1, 0x0000, 0x9FCC, 0x0000,
    0x0000, 0x905B, 0x0000, 0x8F7E, 0x0000, 0x95A3, 0x0000, 0x8DAC,
    0x0000, 0x9FB9, 0x9FC7, 0x9359, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U6e[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x90B4, 0x0000, 0x8A89,
    0x8DCF, 0x8FC2, 0x9FBB, 0x8F61, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8C6B, 0x0000, 0x9FBA, 0x0000, 0x0000,
    0x0000, 0x9FD0, 0x8F8D, 0x8CB8, 0x0000, 0x9FDF, 0x0000, 0x9FD9,
    0x8B94, 0x936E, 0x0000, 0x9FD4, 0x9FDD, 0x88AD, 0x8951, 0x0000,
    0x0000, 0x89B7, 0x0000, 0x9FD6, 0x91AA, 0x9FCD, 0x9FCF, 0x8D60,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9FE0, 0x0000, 0x9FDB, 0x0000, 0x0000, 0x0000, 0x9FD3, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9FDA, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x96A9, 0x0000, 0x0000, 0x9FD8, 0x9FDC, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8CCE, 0x0000,
    0x8FC3, 0x0000, 0x0000, 0x9258, 0x0000, 0x0000, 0x0000, 0x9FD2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x974E,
    0x0000, 0x0000, 0x0000, 0x9FD5, 0x0000, 0x0000, 0x9FCE, 0x9392,
    0x0000, 0x0000, 0x9FD1, 0x0000, 0x0000, 0x0000, 0x9FD7, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9870, 0x8EBC,
    0x969E, 0x0000, 0x9FE1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x94AC, 0x0000, 0x0000, 0x9FED,
    0x8CB9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F80, 0x0000,
    0x9FE3, 0x0000, 0x0000, 0x0000, 0x97AD, 0x8D61, 0x0000, 0x9FF0,
    0x0000, 0x0000, 0x88EC, 0x0000, 0x0000, 0x9FEE, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9FE2, 0x0000, 0x0000, 0x0000, 0x0000, 0x9FE8,
    0x0000, 0x0000, 0x9FEA, 0x0000, 0x0000, 0x0000, 0x976E, 0x9FE5,
    0x0000, 0x0000, 0x934D, 0x0000, 0x0000, 0x9FE7, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9FEF, 0x0000, 0x9FE9, 0x96C5, 0x0000, 0x0000,
    0x0000, 0x9FE4, 0x0000, 0x8EA0, 0x9FFC, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8A8A, 0x0000, 0x9FE6, 0x9FEB, 0x9FEC, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x91EA, 0x91D8, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9FF4, 0x0000, 0x0000, 0x9FFA,
    0x0000, 0x0000, 0x9FF8, 0x0000, 0x9348, 0x0000, 0x0000, 0xE042,
    0x9FF5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9FF6, 0x9FDE,
};

static const u16 U6f[0x100] =
{
    0x0000, 0x8B99, 0x9559, 0x0000, 0x0000, 0x0000, 0x8EBD, 0x0000,
    0x0000, 0x8D97, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9852,
    0x0000, 0x9FF2, 0x0000, 0xE041, 0x8989, 0x9186, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9499, 0x0000, 0x8ABF, 0x97F8, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x969F, 0x92D0, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9FF9, 0x9FFB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9151, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE040, 0x9FF7,
    0x0000, 0x9FF1, 0x0000, 0x0000, 0x0000, 0x8AC1, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8C89, 0x0000, 0x0000, 0x0000,
    0xE04E, 0x0000, 0x0000, 0xE049, 0x90F6, 0x0000, 0x0000, 0x8A83,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8F81, 0x0000, 0xE052, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE04B, 0x92AA, 0xE048,
    0x92D7, 0x0000, 0x0000, 0x0000, 0xE06B, 0x0000, 0x0000, 0x0000,
    0xE045, 0x0000, 0xE044, 0x0000, 0xE04D, 0x0000, 0x0000, 0x0000,
    0xE047, 0xE046, 0xE04C, 0x0000, 0x909F, 0x0000, 0xE043, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE04F, 0x0000,
    0x0000, 0xE050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8AC0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE055, 0x0000, 0xE054, 0xE056, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9362, 0x0000, 0xE053, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8C83, 0x91F7, 0xE051, 0x945A, 0x0000, 0x0000, 0xE058, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE05D, 0xE05B, 0x0000, 0x0000,
    0xE05E, 0x0000, 0x0000, 0xE061, 0x0000, 0x0000, 0x0000, 0xE05A,
    0x8D8A, 0x9447, 0x0000, 0x0000, 0x9FB7, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9794, 0xE05C, 0x0000, 0xE060, 0x91F3,
    0x0000, 0xE05F, 0x0000, 0xE04A, 0x0000, 0x0000, 0xE889, 0x0000,
    0x0000, 0x0000, 0xE064, 0x0000, 0x0000, 0x0000, 0xE068, 0x0000,
};

static const u16 U70[0x100] =
{
    0x0000, 0xE066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE062, 0x0000, 0xE063, 0x0000, 0x0000, 0x0000, 0xE067,
    0x0000, 0xE065, 0x0000, 0x0000, 0x0000, 0x956D, 0x0000, 0x0000,
    0xE06D, 0x0000, 0xE06A, 0xE069, 0x0000, 0xE06C, 0x93D2, 0xE06E,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9295, 0x91EB,
    0x0000, 0x0000, 0x0000, 0x0000, 0x90A3, 0x0000, 0x0000, 0x0000,
    0xE06F, 0x0000, 0xE071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE070, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9FF3, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x93E5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE073, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x89CE, 0x0000, 0x0000, 0x0000, 0x9394,
    0x8A44, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8B84, 0x0000, 0x0000, 0x0000, 0x8EDC, 0x8DD0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9846, 0x9086, 0x0000, 0x0000, 0x0000, 0x898A, 0x0000,
    0x0000, 0x0000, 0xE075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE078, 0x9259, 0xE07B, 0xE076,
    0x0000, 0x0000, 0x0000, 0xE07A, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE079, 0x935F, 0x88D7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x97F3, 0x0000, 0x0000, 0xE07D, 0x0000, 0x0000, 0x0000, 0x8947,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE080, 0x0000, 0x0000, 0x0000, 0xE07E, 0x0000, 0xE07C,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9642, 0x0000, 0x0000, 0x0000, 0xE082, 0x0000, 0x0000,
};

static const u16 U71[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE081, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x898B, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE084, 0x95B0, 0x0000, 0xE083, 0x0000, 0x0000, 0x0000,
    0x0000, 0x96B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x8FC5, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9152, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8FC4, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x97F9, 0x0000, 0x0000, 0xE08A, 0x0000, 0x90F7, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE086, 0xE08B, 0x0000,
    0x0000, 0x898C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE089, 0x0000, 0x9481, 0xE085, 0xE088, 0x8FC6,
    0x0000, 0x94CF, 0x0000, 0x0000, 0xE08C, 0x0000, 0x8ECF, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x90F8, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE08F, 0x0000, 0x0000, 0x0000,
    0xE087, 0x0000, 0x8C46, 0x0000, 0x0000, 0x0000, 0x0000, 0xE08D,
    0x0000, 0x0000, 0x0000, 0x0000, 0x976F, 0xE090, 0x0000, 0x0000,
    0x0000, 0xEAA4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F6E,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE091, 0x0000, 0x0000, 0x0000, 0xE092, 0x0000, 0x0000, 0x0000,
    0x0000, 0x944D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE094, 0x0000, 0x0000, 0x0000, 0x0000, 0xE095, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9452, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9395, 0xE097, 0x0000, 0x0000, 0x0000, 0x0000, 0xE099, 0x0000,
    0x97D3, 0x0000, 0xE096, 0x0000, 0xE098, 0x898D, 0x0000, 0xE093,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9A7A,
    0xE09A, 0x0000, 0x0000, 0x0000, 0x0000, 0x9187, 0x8E57, 0xE09C,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE09B, 0x9043, 0x99D7, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE09D, 0x0000, 0x0000,
    0x0000, 0xE09F, 0x0000, 0xE08E, 0xE09E, 0x0000, 0x0000, 0xE0A0,
};

static const u16 U72[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x949A, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0A1, 0x0000, 0x0000,
    0xE0A2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE0A3, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE0A4, 0x0000, 0x92DC, 0x0000, 0xE0A6, 0xE0A5, 0x0000, 0x0000,
    0xE0A7, 0x0000, 0xE0A8, 0x0000, 0x0000, 0x8EDD, 0x9583, 0x0000,
    0x0000, 0x0000, 0x96EA, 0xE0A9, 0xE0AA, 0x9175, 0x8EA2, 0xE0AB,
    0xE0AC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0AD, 0x95D0,
    0x94C5, 0x0000, 0x0000, 0xE0AE, 0x9476, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x92AB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE0AF, 0x89E5, 0x0000, 0x8B8D, 0x0000, 0x96C4, 0x0000, 0x96B4,
    0x0000, 0x89B2, 0x9853, 0x0000, 0x0000, 0x0000, 0x0000, 0x9671,
    0x0000, 0x95A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x90B5, 0x0000, 0xE0B0, 0x0000, 0x0000, 0x0000,
    0x0000, 0x93C1, 0x0000, 0x0000, 0x0000, 0x8CA1, 0xE0B1, 0x0000,
    0x8DD2, 0xE0B3, 0xE0B2, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0B4,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE0B5, 0x0000, 0x0000, 0x0000, 0xE0B6, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8B5D, 0x0000, 0xE0B7, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0B8,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8CA2, 0x0000, 0x0000, 0x94C6,
    0x0000, 0x0000, 0xE0BA, 0x0000, 0x0000, 0x0000, 0x8FF3, 0x0000,
    0x0000, 0xE0B9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8BB6, 0xE0BB, 0xE0BD, 0x0000, 0xE0BC, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0BE, 0x0000,
    0x8CCF, 0x0000, 0xE0BF, 0x0000, 0x0000, 0x0000, 0x0000, 0x8BE7,
    0x0000, 0x915F, 0x0000, 0x8D9D, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE0C1, 0xE0C2, 0xE0C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8EEB, 0x0000, 0x0000, 0x93C6, 0x8BB7, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0C4,
    0x924B, 0xE0C3, 0x0000, 0x0000, 0x9854, 0x9482, 0x0000, 0x0000,
};

static const u16 U73[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE0C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0C9, 0xE0C6,
    0x0000, 0x0000, 0x0000, 0x96D2, 0xE0C8, 0xE0CA, 0x0000, 0x97C2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0CE, 0x0000, 0x0000,
    0x0000, 0xE0CD, 0x9296, 0x944C, 0x0000, 0x0000, 0x8CA3, 0xE0CC,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE0CB, 0x0000, 0x9750, 0x9751,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0CF, 0x898E,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8D96, 0x8E82, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0D0, 0xE0D1,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0D3,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8F62, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE0D5, 0x0000, 0xE0D4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE0D6, 0x0000, 0x8A6C, 0x0000, 0x0000, 0xE0D8, 0x0000, 0x0000,
    0xE0D7, 0x0000, 0xE0DA, 0xE0D9, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8CBA, 0x0000, 0x0000, 0x97A6,
    0x0000, 0x8BCA, 0x0000, 0x89A4, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8BE8, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8ADF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x97E6, 0xE0DC, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE0DE, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE0DF, 0x0000, 0x89CF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE0DB, 0x0000, 0x8E58, 0x0000, 0x0000, 0x92BF, 0xE0DD, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0E2, 0x0000,
    0x8EEC, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0E0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8C5D, 0x0000, 0x0000, 0x94C7, 0xE0E1, 0x0000,
    0x0000, 0xE0FC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE0E7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8CBB, 0x0000,
};

static const u16 U74[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x8B85, 0x0000, 0xE0E4, 0x979D, 0x0000,
    0x0000, 0x97AE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x91F4, 0x0000, 0x0000, 0xE0E6, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE0E8, 0x97D4, 0x8BD5, 0x94FA, 0x9469, 0x0000,
    0x0000, 0x0000, 0xE0E9, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0EB,
    0x0000, 0xE0EE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0EA, 0x0000, 0x0000,
    0x0000, 0xE0ED, 0x8CE8, 0x896C, 0xE0EF, 0x0000, 0x9090, 0xE0EC,
    0x97DA, 0x0000, 0x0000, 0xE0F2, 0xEAA2, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE0F0, 0xE0F3, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0E5,
    0xE0F1, 0x0000, 0x0000, 0x8DBA, 0x0000, 0x0000, 0xE0F4, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0F5, 0x0000,
    0x0000, 0x0000, 0x0000, 0x979E, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE0F6, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0F7, 0x0000,
    0x0000, 0x0000, 0xE0E3, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0F8,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8AC2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8EA3, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE0F9, 0x0000, 0x0000, 0x0000, 0x0000, 0xE0FA,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE0FB, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x895A, 0x0000, 0x0000, 0x0000,
    0xE140, 0x0000, 0x955A, 0xE141, 0x0000, 0x0000, 0x8AA2, 0xE142,
    0x0000, 0xE143, 0x0000, 0x0000, 0x0000, 0x0000, 0xE144, 0x0000,
    0xE146, 0xE147, 0xE145, 0x0000, 0x0000, 0x0000, 0x9572, 0xE149,
    0xE148, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U75[0x100] =
{
    0x0000, 0x0000, 0x0000, 0xE14B, 0xE14A, 0xE14C, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE14D, 0xE14F, 0xE14E, 0x0000,
    0x0000, 0x8D99, 0x0000, 0xE151, 0x0000, 0xE150, 0x0000, 0x0000,
    0x8AC3, 0x0000, 0x9072, 0x0000, 0x935B, 0x0000, 0xE152, 0x90B6,
    0x0000, 0x0000, 0x0000, 0x8E59, 0x0000, 0x8999, 0xE153, 0x0000,
    0x9770, 0x0000, 0x0000, 0x95E1, 0xE154, 0x0000, 0x0000, 0x0000,
    0x9363, 0x9752, 0x8D62, 0x905C, 0x0000, 0x0000, 0x0000, 0x926A,
    0x99B2, 0x0000, 0x92AC, 0x89E6, 0xE155, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE156, 0x0000, 0xE15B, 0x0000,
    0x0000, 0xE159, 0xE158, 0x9DC0, 0x8A45, 0xE157, 0x0000, 0x88D8,
    0x0000, 0x94A8, 0x0000, 0x0000, 0x94C8, 0x0000, 0x0000, 0x0000,
    0x0000, 0x97AF, 0xE15C, 0xE15A, 0x927B, 0x90A4, 0x0000, 0x0000,
    0x94A9, 0x0000, 0x954C, 0x0000, 0xE15E, 0x97AA, 0x8C6C, 0xE15F,
    0x0000, 0xE15D, 0x94D4, 0xE160, 0x0000, 0xE161, 0x0000, 0x0000,
    0x88D9, 0x0000, 0x0000, 0x8FF4, 0xE166, 0x0000, 0xE163, 0x93EB,
    0xE162, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8B45,
    0x0000, 0x0000, 0xE169, 0x0000, 0x0000, 0x0000, 0xE164, 0xE165,
    0x0000, 0xE168, 0xE167, 0x9544, 0x0000, 0x0000, 0x9161, 0x9160,
    0x0000, 0x8B5E, 0x0000, 0x0000, 0xE16A, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE16B, 0x0000, 0x0000, 0xE16C, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE16E, 0x0000, 0xE16D, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8975, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE176, 0x94E6, 0xE170, 0x0000, 0xE172, 0x0000, 0x0000,
    0xE174, 0x905D, 0x0000, 0x0000, 0xE175, 0xE173, 0x8EBE, 0x0000,
    0x0000, 0x0000, 0xE16F, 0xE171, 0x0000, 0x9561, 0x0000, 0x8FC7,
    0x0000, 0x0000, 0xE178, 0x0000, 0x0000, 0xE177, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE179, 0x0000, 0x8EA4, 0x8DAD, 0x0000, 0x0000,
    0x9397, 0xE17A, 0x0000, 0x92C9, 0x0000, 0x0000, 0xE17C, 0x0000,
    0x0000, 0x0000, 0x979F, 0xE17B, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9189, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE182, 0x0000, 0xE184, 0xE185, 0x9273, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE183, 0x0000, 0xE180, 0x0000, 0xE17D, 0xE17E,
};

static const u16 U76[0x100] =
{
    0x0000, 0xE181, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE188, 0x0000, 0xE186, 0x0000, 0xE187, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE189,
    0xE18B, 0xE18C, 0xE18D, 0x0000, 0xE18E, 0x0000, 0x0000, 0xE18A,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE190, 0x0000, 0x0000, 0x0000, 0xE18F, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE191, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x97C3, 0x0000, 0x0000, 0x0000, 0xE194, 0xE192,
    0xE193, 0x0000, 0x0000, 0x0000, 0x8AE0, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x96FC, 0x0000, 0x0000, 0x0000, 0x95C8, 0x0000,
    0xE196, 0x0000, 0x0000, 0x0000, 0xE195, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE197, 0xE198, 0x0000, 0x0000, 0x0000, 0x0000, 0xE19C,
    0xE199, 0xE19A, 0xE19B, 0x0000, 0xE19D, 0x0000, 0x0000, 0x0000,
    0xE19E, 0x0000, 0xE19F, 0x0000, 0x0000, 0x0000, 0xE1A0, 0x0000,
    0xE1A1, 0x0000, 0x94AD, 0x936F, 0xE1A2, 0x9492, 0x9553, 0x0000,
    0xE1A3, 0x0000, 0x0000, 0xE1A4, 0x9349, 0x0000, 0x8A46, 0x8D63,
    0xE1A5, 0x0000, 0x0000, 0xE1A6, 0x0000, 0x0000, 0xE1A7, 0x0000,
    0x8E48, 0x0000, 0x0000, 0xE1A9, 0x0000, 0x0000, 0xE1A8, 0x0000,
    0x0000, 0xE1AA, 0xE1AB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x94E7, 0x0000,
    0xE1AC, 0x0000, 0x0000, 0x0000, 0xE1AD, 0x0000, 0x0000, 0xEA89,
    0xE1AE, 0xE1AF, 0xE1B0, 0x0000, 0x0000, 0x0000, 0x0000, 0x8E4D,
    0x0000, 0x0000, 0xE1B1, 0x9475, 0x0000, 0x0000, 0x967E, 0x0000,
    0x896D, 0x0000, 0x8976, 0x0000, 0x0000, 0xE1B2, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE1B4, 0x0000, 0x0000, 0x0000, 0xE1B3, 0x9390,
    0x0000, 0x0000, 0x0000, 0x90B7, 0x9F58, 0x0000, 0xE1B5, 0x96BF,
    0x0000, 0xE1B6, 0x0000, 0x8AC4, 0x94D5, 0xE1B7, 0x0000, 0xE1B8,
    0x0000, 0x0000, 0xE1B9, 0x0000, 0x0000, 0x0000, 0x96DA, 0x0000,
    0x0000, 0x0000, 0x96D3, 0x0000, 0x92BC, 0x0000, 0x0000, 0x0000,
    0x918A, 0x0000, 0x0000, 0xE1BB, 0x0000, 0x0000, 0x8F82, 0x0000,
};

static const u16 U77[0x100] =
{
    0x0000, 0x8FC8, 0x0000, 0x0000, 0xE1BE, 0x0000, 0x0000, 0xE1BD,
    0xE1BC, 0x94FB, 0x0000, 0x8AC5, 0x8CA7, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE1C4, 0x0000, 0x0000, 0xE1C1, 0x905E,
    0x96B0, 0x0000, 0x0000, 0x0000, 0xE1C0, 0xE1C2, 0xE1C3, 0x0000,
    0x0000, 0xE1BF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE1C5,
    0xE1C6, 0x0000, 0x92AD, 0x0000, 0x8AE1, 0x0000, 0x0000, 0x0000,
    0x9285, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE1C7,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE1C8, 0xE1CB, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9087, 0x0000, 0x93C2, 0x0000, 0xE1CC, 0x9672, 0x0000,
    0xE1C9, 0x0000, 0x0000, 0xE1CA, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE1CF, 0x0000, 0x0000, 0x0000, 0x0000, 0xE1CE, 0xE1CD,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE1D1, 0x0000, 0x0000, 0xE1D0, 0x0000,
    0x0000, 0xE1D2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE1D4, 0x0000,
    0xE1D3, 0x0000, 0x0000, 0x0000, 0x0000, 0x95CB, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8F75, 0x97C4, 0x0000, 0x0000,
    0xE1D5, 0x0000, 0x0000, 0x93B5, 0x0000, 0x0000, 0xE1D6, 0x0000,
    0x0000, 0xE1D7, 0x0000, 0xE1DB, 0xE1D9, 0xE1DA, 0x0000, 0xE1D8,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE1DC,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE1DD, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE1DE,
    0x0000, 0x0000, 0xE1DF, 0x96B5, 0xE1E0, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x96EE, 0xE1E1, 0x0000, 0x926D, 0x0000, 0x948A,
    0x0000, 0x8BE9, 0x0000, 0x0000, 0x0000, 0x925A, 0xE1E2, 0x8BB8,
    0x0000, 0x0000, 0x0000, 0x90CE, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE1E3, 0x0000, 0x0000, 0x0000,
};

static const u16 U78[0x100] =
{
    0x0000, 0x0000, 0x8DBB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE1E4, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE1E5, 0x0000, 0x8CA4, 0x8DD3, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE1E7, 0x0000, 0x0000, 0x0000, 0x0000, 0x9375, 0x8DD4, 0x8B6D,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9643, 0x0000, 0x946A, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9376, 0x0000, 0x0000, 0x0000, 0x0000, 0x8D7B,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE1E9, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8FC9, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x97B0, 0x8D64, 0x0000, 0x0000, 0x8CA5,
    0x0000, 0x0000, 0x94A1, 0x0000, 0xE1EB, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE1ED, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8CE9, 0x0000, 0x0000, 0x0000, 0x0000, 0xE1EC, 0x92F4,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE1EF, 0x8A56, 0xE1EA, 0x0000,
    0x0000, 0x94E8, 0x0000, 0x894F, 0x0000, 0x8DEA, 0x0000, 0x9871,
    0x0000, 0x0000, 0xE1EE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE1F0, 0x0000, 0x0000, 0x0000, 0x95C9,
    0x0000, 0x90D7, 0xE1F2, 0x0000, 0x0000, 0x0000, 0x0000, 0xE1F3,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE1F1, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8A6D, 0x0000, 0xE1F9, 0x0000, 0xE1F8, 0x0000,
    0x0000, 0x8EA5, 0x0000, 0x0000, 0x0000, 0xE1FA, 0xE1F5, 0x0000,
    0x0000, 0x0000, 0xE1FB, 0xE1F6, 0x0000, 0x0000, 0x0000, 0x0000,
    0x94D6, 0xE1F4, 0x0000, 0x0000, 0xE1F7, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE241, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE240,
    0x9681, 0x0000, 0x0000, 0x0000, 0xE1FC, 0x0000, 0x0000, 0x88E9,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE243, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE242, 0x0000, 0x0000,
};

static const u16 U79[0x100] =
{
    0x0000, 0x8FCA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE244,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9162, 0x0000,
    0x0000, 0xE246, 0xE245, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE247, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE1E6, 0x0000,
    0x0000, 0x0000, 0xE1E8, 0xE249, 0xE248, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8EA6, 0x0000, 0x97E7, 0x0000, 0x8ED0, 0x0000,
    0xE24A, 0x8C56, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8B5F,
    0x8B46, 0x8E83, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9753, 0x0000, 0x0000, 0xE250, 0x0000, 0xE24F, 0x9163, 0xE24C,
    0x0000, 0x0000, 0xE24E, 0x0000, 0x0000, 0x8F6A, 0x905F, 0xE24D,
    0xE24B, 0x0000, 0x9449, 0x0000, 0x0000, 0x8FCB, 0x0000, 0x0000,
    0x955B, 0x0000, 0x0000, 0x0000, 0x0000, 0x8DD5, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9398,
    0x0000, 0x0000, 0xE251, 0x0000, 0x0000, 0x0000, 0x0000, 0xE252,
    0xE268, 0x8BD6, 0x0000, 0x0000, 0x985C, 0x9154, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE253, 0x0000, 0x0000, 0x89D0, 0x92F5, 0x959F,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE254, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8B9A, 0xE255,
    0x0000, 0x0000, 0xE257, 0x0000, 0x0000, 0x0000, 0xE258, 0x0000,
    0x9448, 0x0000, 0x0000, 0xE259, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE25A, 0xE25B, 0x0000, 0x0000, 0x8BD7, 0x89D1, 0x93C3,
    0x8F47, 0x8E84, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE25C, 0x0000, 0x8F48, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x89C8, 0x9562, 0x0000, 0x0000, 0xE25D, 0x0000, 0x0000,
    0x94E9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9164,
    0x0000, 0xE260, 0x0000, 0xE261, 0x9489, 0x0000, 0x9060, 0xE25E,
    0x0000, 0x9281, 0x0000, 0x0000, 0xE25F, 0x0000, 0x0000, 0x0000,
    0x8FCC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x88DA, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U7a[0x100] =
{
    0x8B48, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE262, 0x0000, 0x0000, 0x92F6, 0x0000, 0xE263, 0x90C5, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x96AB, 0x0000, 0x0000, 0x9542,
    0xE264, 0xE265, 0x9274, 0x0000, 0x97C5, 0x0000, 0x0000, 0xE267,
    0xE266, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8EED, 0x0000,
    0x0000, 0xE269, 0x88EE, 0x0000, 0x0000, 0x0000, 0x0000, 0xE26C,
    0x0000, 0x0000, 0x0000, 0xE26A, 0x89D2, 0x8C6D, 0xE26B, 0x8D65,
    0x8D92, 0x0000, 0x95E4, 0xE26D, 0x0000, 0x0000, 0x9673, 0x0000,
    0x0000, 0xE26F, 0x0000, 0x0000, 0x0000, 0x90CF, 0x896E, 0x89B8,
    0x88AA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE26E,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE270, 0xE271, 0x8FF5, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE272, 0x0000, 0x8A6E, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE274, 0x0000, 0x0000, 0x0000, 0x8C8A, 0x0000, 0x8B86, 0x0000,
    0x0000, 0xE275, 0x8BF3, 0x0000, 0x0000, 0xE276, 0x0000, 0x90FA,
    0x0000, 0x93CB, 0x0000, 0x90DE, 0x8DF3, 0x0000, 0x0000, 0x0000,
    0xE277, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9282, 0x918B, 0x0000, 0xE279, 0xE27B, 0xE278,
    0xE27A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8C41,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE27C, 0x8C45, 0x0000, 0x0000, 0x0000, 0x8B87, 0x9771,
    0xE27E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE280, 0x0000,
    0x0000, 0x0000, 0x894D, 0x0000, 0x0000, 0x0000, 0x0000, 0xE283,
    0x0000, 0x0000, 0x0000, 0x8A96, 0xE282, 0xE281, 0x0000, 0xE285,
    0xE27D, 0x0000, 0xE286, 0x97A7, 0x0000, 0xE287, 0x0000, 0xE288,
    0x0000, 0x0000, 0x9AF2, 0xE28A, 0x0000, 0xE289, 0x0000, 0x0000,
    0x0000, 0xE28B, 0xE28C, 0x0000, 0x97B3, 0xE28D, 0x0000, 0xE8ED,
    0x8FCD, 0xE28E, 0xE28F, 0x8F76, 0x0000, 0x93B6, 0xE290, 0x0000,
    0x0000, 0x0000, 0x9247, 0x0000, 0x0000, 0xE291, 0x0000, 0x925B,
    0xE292, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8BA3, 0x0000,
    0x995E, 0x927C, 0x8EB1, 0x0000, 0x0000, 0x0000, 0x0000, 0x8AC6,
};

static const u16 U7b[0x100] =
{
    0x0000, 0x0000, 0xE293, 0x0000, 0xE2A0, 0x0000, 0xE296, 0x0000,
    0x8B88, 0x0000, 0xE295, 0xE2A2, 0x0000, 0x0000, 0x0000, 0xE294,
    0x0000, 0x8FCE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE298, 0xE299, 0x0000, 0x934A, 0x0000, 0x0000, 0xE29A, 0x0000,
    0x8A7D, 0x0000, 0x0000, 0x0000, 0x0000, 0x9079, 0x9584, 0x0000,
    0xE29C, 0x0000, 0x0000, 0x0000, 0x91E6, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE297, 0x0000, 0xE29B, 0xE29D, 0x0000,
    0x0000, 0x8DF9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE2A4, 0x954D, 0x0000,
    0x94A4, 0x9399, 0x0000, 0x8BD8, 0xE2A3, 0xE2A1, 0x0000, 0x94B3,
    0xE29E, 0x927D, 0x939B, 0x0000, 0x939A, 0x0000, 0x8DF4, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE2B6, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE2A6, 0x0000, 0xE2A8,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE2AB, 0x0000, 0xE2AC, 0x0000,
    0xE2A9, 0xE2AA, 0x0000, 0x0000, 0xE2A7, 0xE2A5, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE29F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x95CD, 0x89D3,
    0x0000, 0x0000, 0x0000, 0xE2B3, 0x0000, 0xE2B0, 0x0000, 0xE2B5,
    0x0000, 0x0000, 0xE2B4, 0x0000, 0x9493, 0x96A5, 0x0000, 0x8E5A,
    0xE2AE, 0xE2B7, 0xE2B2, 0x0000, 0xE2B1, 0xE2AD, 0x0000, 0xE2AF,
    0x0000, 0x8AC7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x925C, 0x0000, 0x0000, 0x90FB, 0x0000, 0x0000,
    0x0000, 0x94A0, 0x0000, 0x0000, 0xE2BC, 0x0000, 0x0000, 0x0000,
    0x94A2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x90DF, 0xE2B9, 0x0000, 0x0000, 0x94CD, 0x0000, 0xE2BD, 0x95D1,
    0x0000, 0x927A, 0x0000, 0xE2B8, 0xE2BA, 0x0000, 0x0000, 0xE2BB,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE2BE, 0x0000, 0x0000,
    0x8EC2, 0x0000, 0x0000, 0x0000, 0x93C4, 0xE2C3, 0xE2C2, 0x0000,
    0x0000, 0xE2BF, 0x0000, 0x0000, 0x0000, 0x9855, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE2C8, 0x0000, 0x0000, 0xE2CC, 0xE2C9,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U7c[0x100] =
{
    0xE2C5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE2C6,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE2CB, 0x0000, 0x0000,
    0x0000, 0xE2C0, 0x99D3, 0xE2C7, 0xE2C1, 0x0000, 0x0000, 0xE2CA,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE2D0,
    0x0000, 0x8AC8, 0x0000, 0xE2CD, 0x0000, 0x0000, 0x0000, 0xE2CE,
    0x0000, 0x0000, 0xE2CF, 0xE2D2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE2D1,
    0x94F4, 0x0000, 0x0000, 0x0000, 0x0000, 0xE2D3, 0x97FA, 0x95EB,
    0xE2D8, 0x0000, 0x0000, 0xE2D5, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE2D4, 0x90D0, 0x0000, 0xE2D7,
    0xE2D9, 0x0000, 0x0000, 0x0000, 0xE2D6, 0x0000, 0xE2DD, 0x0000,
    0xE2DA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE2DB,
    0xE2C4, 0x0000, 0x0000, 0x0000, 0xE2DC, 0xE2DE, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE2DF, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x95C4, 0x0000, 0xE2E0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x96E0, 0x0000,
    0x0000, 0x8BCC, 0x8C48, 0xE2E1, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x95B2, 0x0000, 0x9088, 0x0000, 0x96AE, 0x0000, 0x0000,
    0xE2E2, 0x0000, 0x97B1, 0x0000, 0x0000, 0x9494, 0x0000, 0x9165,
    0x9453, 0x0000, 0x0000, 0x8F6C, 0x0000, 0x0000, 0x0000, 0x88BE,
    0x0000, 0xE2E7, 0xE2E5, 0x0000, 0xE2E3, 0x8A9F, 0x0000, 0x8FCF,
    0xE2E8, 0x0000, 0x0000, 0xE2E6, 0x0000, 0xE2E4, 0xE2EC, 0x0000,
    0x0000, 0xE2EB, 0xE2EA, 0xE2E9, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE2ED, 0x0000, 0x0000, 0x0000, 0xE2EE, 0x90B8, 0x0000,
    0xE2EF, 0x0000, 0xE2F1, 0x0000, 0x0000, 0xE2F0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8CD0, 0x0000, 0x0000, 0x0000, 0x9157, 0x0000,
    0x0000, 0x0000, 0xE2F3, 0x0000, 0x0000, 0x0000, 0x939C, 0x0000,
    0xE2F2, 0x0000, 0x0000, 0x0000, 0xE2F4, 0x0000, 0x95B3, 0x918C,
    0x8D66, 0x0000, 0xE2F5, 0x0000, 0x0000, 0x0000, 0x0000, 0x97C6,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE2F7,
    0x0000, 0x0000, 0xE2F8, 0x0000, 0xE2F9, 0x0000, 0xE2FA, 0x0000,
    0x8E85, 0x0000, 0xE2FB, 0x8C6E, 0x0000, 0x0000, 0x8B8A, 0x0000,
};

static const u16 U7d[0x100] =
{
    0x8B49, 0x0000, 0xE340, 0x0000, 0x96F1, 0x8D67, 0xE2FC, 0x0000,
    0x0000, 0x0000, 0xE343, 0x96E4, 0x0000, 0x945B, 0x0000, 0x0000,
    0x9552, 0x0000, 0x0000, 0x0000, 0x8F83, 0xE342, 0x0000, 0x8ED1,
    0x8D68, 0x8E86, 0x8B89, 0x95B4, 0xE341, 0x0000, 0x0000, 0x0000,
    0x9166, 0x9661, 0x8DF5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8E87, 0x92DB, 0x0000, 0xE346, 0x97DD,
    0x8DD7, 0x0000, 0xE347, 0x9061, 0x0000, 0xE349, 0x0000, 0x0000,
    0x0000, 0x8FD0, 0x8DAE, 0x0000, 0x0000, 0x0000, 0x0000, 0xE348,
    0x0000, 0x0000, 0x8F49, 0x8CBC, 0x9167, 0xE344, 0xE34A, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE345, 0x8C6F, 0x0000, 0xE34D, 0xE351,
    0x8C8B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE34C, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE355, 0x0000, 0x0000, 0x8D69, 0x0000,
    0x0000, 0x978D, 0x88BA, 0xE352, 0x0000, 0x0000, 0x8B8B, 0x0000,
    0xE34F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE350, 0x0000,
    0x0000, 0x939D, 0xE34E, 0xE34B, 0x0000, 0x8A47, 0x90E2, 0x0000,
    0x0000, 0x8CA6, 0x0000, 0x0000, 0x0000, 0xE357, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE354, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE356,
    0x0000, 0x0000, 0x0000, 0xE353, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8C70, 0x91B1, 0xE358, 0x918E, 0x0000, 0x0000, 0xE365,
    0x0000, 0x0000, 0xE361, 0xE35B, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE35F, 0x8EF8, 0x88DB, 0xE35A, 0xE362,
    0xE366, 0x8D6A, 0x96D4, 0x0000, 0x92D4, 0xE35C, 0x0000, 0x0000,
    0xE364, 0x0000, 0xE359, 0x925D, 0x0000, 0xE35E, 0x88BB, 0x96C8,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE35D,
    0x0000, 0x0000, 0x8BD9, 0x94EA, 0x0000, 0x0000, 0x0000, 0x918D,
    0x0000, 0x97CE, 0x8F8F, 0x0000, 0x0000, 0xE38E, 0x0000, 0x0000,
    0xE367, 0x0000, 0x90FC, 0x0000, 0xE363, 0xE368, 0xE36A, 0x0000,
    0x92F7, 0xE36D, 0x0000, 0x0000, 0xE369, 0x0000, 0x0000, 0x0000,
    0x95D2, 0x8AC9, 0x0000, 0x0000, 0x96C9, 0x0000, 0x0000, 0x88DC,
    0x0000, 0x0000, 0xE36C, 0x0000, 0x97FB, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE36B, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U7e[0x100] =
{
    0x0000, 0x898F, 0x0000, 0x0000, 0x93EA, 0xE36E, 0x0000, 0x0000,
    0x0000, 0xE375, 0xE36F, 0xE376, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE372, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x949B, 0x0000, 0x0000, 0x8EC8, 0xE374,
    0x0000, 0xE371, 0xE377, 0xE370, 0x0000, 0x0000, 0x8F63, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9644, 0x0000, 0x0000, 0x8F6B, 0x0000,
    0x0000, 0xE373, 0xE380, 0x0000, 0x0000, 0xE37B, 0x0000, 0xE37E,
    0x0000, 0xE37C, 0xE381, 0xE37A, 0x0000, 0xE360, 0x90D1, 0x0000,
    0x0000, 0x94C9, 0x0000, 0xE37D, 0x0000, 0x0000, 0xE378, 0x0000,
    0x0000, 0x0000, 0x9140, 0x8C71, 0x0000, 0x8F4A, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9044, 0x9155, 0xE384, 0x0000,
    0x0000, 0xE386, 0xE387, 0x0000, 0x0000, 0xE383, 0xE385, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE379, 0xE382,
    0x0000, 0xE38A, 0xE389, 0x0000, 0x0000, 0x969A, 0x0000, 0x0000,
    0x8C4A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE388, 0x0000, 0xE38C, 0xE38B, 0xE38F, 0x0000, 0xE391,
    0x0000, 0x0000, 0x8E5B, 0xE38D, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE392, 0xE393, 0x0000, 0x0000, 0xE394, 0x0000, 0xE39A, 0x935A,
    0xE396, 0x0000, 0xE395, 0xE397, 0xE398, 0x0000, 0xE399, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE39B, 0xE39C, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U7f[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8ACA, 0x0000,
    0xE39D, 0x0000, 0xE39E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE39F, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE3A0, 0xE3A1, 0xE3A2, 0x0000,
    0xE3A3, 0xE3A4, 0x0000, 0x0000, 0xE3A6, 0xE3A5, 0x0000, 0x0000,
    0xE3A7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE3A8,
    0xE3A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE3AC,
    0xE3AA, 0xE3AB, 0x8DDF, 0x8C72, 0x0000, 0x0000, 0x9275, 0x0000,
    0x94B1, 0x0000, 0x8F90, 0x0000, 0x0000, 0x946C, 0x0000, 0x94EB,
    0xE3AD, 0x9CEB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE3AE, 0xE3B0, 0x0000, 0x9785, 0xE3AF, 0xE3B2,
    0xE3B1, 0x0000, 0x9772, 0x0000, 0xE3B3, 0x0000, 0x94FC, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE3B4, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE3B7, 0x0000, 0x0000, 0xE3B6, 0xE3B5, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE3B8, 0x8C51, 0x0000, 0x0000, 0x0000,
    0x9141, 0x8B60, 0x0000, 0x0000, 0x0000, 0x0000, 0xE3BC, 0xE3B9,
    0x0000, 0x0000, 0xE3BA, 0x0000, 0x0000, 0x0000, 0xE3BD, 0x0000,
    0xE3BE, 0xE3BB, 0x0000, 0x0000, 0x0000, 0x8948, 0x0000, 0x0000,
    0x0000, 0x89A5, 0x0000, 0x0000, 0x0000, 0xE3C0, 0xE3C1, 0x0000,
    0x0000, 0x0000, 0xE3C2, 0x0000, 0x9782, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8F4B, 0x0000, 0xE3C4, 0xE3C3, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9089, 0xE3C5, 0x0000, 0x0000, 0x0000, 0x0000, 0xE3C6, 0x0000,
    0x0000, 0xE3C7, 0x0000, 0x8AE3, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8ACB, 0x0000, 0x0000, 0xE3C8, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE3C9, 0x0000, 0x967C, 0x9783, 0x0000, 0x0000, 0x0000,
};

static const u16 U80[0x100] =
{
    0x9773, 0x9856, 0x0000, 0x8D6C, 0xE3CC, 0x8ED2, 0xE3CB, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE3CD, 0x8EA7, 0x0000, 0x0000, 0x0000,
    0x91CF, 0x0000, 0xE3CE, 0x0000, 0x0000, 0x8D6B, 0x0000, 0x96D5,
    0xE3CF, 0xE3D0, 0x0000, 0x0000, 0xE3D1, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE3D2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE3D3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8EA8, 0x0000, 0x0000, 0x96EB, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE3D5, 0x0000, 0x925E, 0x0000, 0xE3D4,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE3D7, 0x0000,
    0x0000, 0x0000, 0xE3D6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE3D8, 0x0000, 0x0000, 0x0000, 0x90B9, 0x0000,
    0xE3D9, 0x0000, 0xE3DA, 0x0000, 0x0000, 0x0000, 0x95B7, 0xE3DB,
    0x0000, 0x918F, 0xE3DC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE3DD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x97FC,
    0xE3E0, 0x0000, 0xE3DF, 0xE3DE, 0x92AE, 0x0000, 0xE3E1, 0x9045,
    0x0000, 0xE3E2, 0x0000, 0x0000, 0x0000, 0xE3E3, 0x9857, 0xE3E4,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE3E5, 0xE3E7, 0xE3E6, 0x94A3,
    0x0000, 0x93F7, 0x0000, 0x985D, 0x94A7, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE3E9, 0x0000, 0x0000, 0x8FD1, 0x0000,
    0x9549, 0x0000, 0xE3EA, 0xE3E8, 0x0000, 0x8ACC, 0x0000, 0x0000,
    0x0000, 0x8CD2, 0x8E88, 0x0000, 0x0000, 0x94EC, 0x0000, 0x0000,
    0x0000, 0x8CA8, 0x9662, 0x0000, 0xE3ED, 0xE3EB, 0x0000, 0x8D6D,
    0x0000, 0x8D6E, 0x88E7, 0x0000, 0x8DE6, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9478, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x88DD, 0xE3F2, 0x0000, 0x925F, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9477, 0x0000, 0x91D9, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE3F4, 0x0000,
    0x0000, 0xE3F0, 0xE3F3, 0xE3EE, 0x0000, 0xE3F1, 0x9645, 0x0000,
    0x0000, 0x8CD3, 0x0000, 0x0000, 0x88FB, 0xE3EF, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE3F6,
    0x0000, 0xE3F7, 0x0000, 0x0000, 0x93B7, 0x0000, 0x0000, 0x0000,
    0x8BB9, 0x0000, 0x0000, 0x0000, 0xE445, 0x945C, 0x0000, 0x0000,
};

static const u16 U81[0x100] =
{
    0x0000, 0x0000, 0x8E89, 0x0000, 0x0000, 0x8BBA, 0x90C6, 0x9865,
    0x96AC, 0xE3F5, 0x90D2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8B72, 0xE3F8, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE3FA, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE3F9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE3FB,
    0x0000, 0x9245, 0x0000, 0x945D, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x92AF, 0x0000, 0x0000, 0x0000, 0x0000, 0xE442, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE441, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE3FC, 0x0000, 0x0000, 0x9074, 0x0000,
    0x9585, 0xE444, 0x0000, 0xE443, 0x8D6F, 0x9872, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE454,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE448, 0xE449, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8EEE, 0x0000, 0x0000, 0xE447, 0x0000,
    0x8D98, 0xE446, 0x0000, 0x0000, 0xE44A, 0x0000, 0x0000, 0x0000,
    0x92B0, 0x95A0, 0x9142, 0x0000, 0x0000, 0x0000, 0x0000, 0x91DA,
    0xE44E, 0x0000, 0xE44F, 0xE44B, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE44C, 0x0000, 0xE44D, 0x0000, 0x0000, 0x0000, 0x0000, 0x8D70,
    0x0000, 0x0000, 0x0000, 0xE455, 0x0000, 0xE451, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9586, 0x0000, 0x968C, 0x9547, 0x0000, 0x0000,
    0xE450, 0x0000, 0x0000, 0xE453, 0xE452, 0x0000, 0x0000, 0x0000,
    0x9663, 0xE456, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE457, 0x0000, 0x0000, 0x9156, 0x0000, 0xE458, 0x0000, 0x0000,
    0xE45A, 0x0000, 0xE45E, 0x0000, 0x0000, 0xE45B, 0xE459, 0x945E,
    0xE45C, 0x0000, 0xE45D, 0x0000, 0x0000, 0x0000, 0x89B0, 0x0000,
    0xE464, 0xE45F, 0x0000, 0x0000, 0x0000, 0xE460, 0x0000, 0x0000,
    0x0000, 0xE461, 0x0000, 0x919F, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE463, 0xE462, 0xE465, 0x0000, 0x0000, 0x0000, 0x0000, 0xE466,
    0xE467, 0x0000, 0x0000, 0x9062, 0x0000, 0x89E7, 0x0000, 0xE468,
    0x97D5, 0x0000, 0x8EA9, 0x0000, 0x0000, 0x8F4C, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8E8A, 0x9276, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE469, 0xE46A, 0x8950, 0x0000, 0xE46B, 0x0000,
};

static const u16 U82[0x100] =
{
    0x0000, 0xE46C, 0xE46D, 0x0000, 0x0000, 0xE46E, 0x0000, 0xE46F,
    0x8BBB, 0x9DA8, 0xE470, 0x0000, 0x90E3, 0xE471, 0x8EC9, 0x0000,
    0xE472, 0x0000, 0x98AE, 0x0000, 0x0000, 0x0000, 0xE473, 0x95DC,
    0x8ADA, 0x0000, 0x0000, 0x9143, 0x8F77, 0x0000, 0x9591, 0x8F4D,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE474, 0x8D71, 0xE475, 0x94CA, 0x0000, 0xE484, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE477, 0x0000, 0x91C7, 0x9495, 0x8CBD,
    0xE476, 0x9144, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE478, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x92F8,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE47A, 0xE479, 0xE47C, 0x0000, 0x0000, 0xE47B, 0x0000, 0xE47D,
    0x0000, 0x0000, 0xE480, 0x0000, 0xE47E, 0x0000, 0x8ACD, 0x0000,
    0xE481, 0x0000, 0xE482, 0xE483, 0x0000, 0x0000, 0x8DAF, 0x97C7,
    0x0000, 0xE485, 0x9046, 0x0000, 0x0000, 0x0000, 0x8990, 0xE486,
    0xE487, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE488, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x88F0, 0x0000, 0xE489, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE48A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9587, 0x0000, 0x0000, 0x0000, 0x8EC5, 0x0000, 0xE48C,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8A48, 0x88B0, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE48B, 0xE48E, 0x946D, 0x0000, 0x9063,
    0x0000, 0x89D4, 0x0000, 0x9646, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8C7C, 0x8BDA, 0x0000, 0xE48D, 0x0000, 0x89E8, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8AA1, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8991, 0xE492, 0x97E8, 0x91DB, 0x0000, 0x0000, 0x9563,
    0x0000, 0xE49E, 0x0000, 0x89D5, 0xE49C, 0x0000, 0xE49A, 0xE491,
    0x0000, 0xE48F, 0x0000, 0xE490, 0x0000, 0x8EE1, 0x8BEA, 0x9297,
    0x0000, 0x0000, 0x0000, 0x93CF, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8970, 0x0000, 0xE494, 0xE493, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE499, 0xE495, 0xE498, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U83[0x100] =
{
    0x0000, 0x0000, 0x96CE, 0xE497, 0x89D6, 0x8A9D, 0xE49B, 0x0000,
    0x0000, 0xE49D, 0x0000, 0x0000, 0x0000, 0x0000, 0x8C73, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE4A1, 0xE4AA,
    0xE4AB, 0x0000, 0x0000, 0x0000, 0x88A9, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE4B2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x88EF, 0x0000, 0x0000, 0xE4A9, 0x0000, 0x0000, 0x0000, 0xE4A8,
    0x0000, 0xE4A3, 0xE4A2, 0x0000, 0xE4A0, 0xE49F, 0x9283, 0x0000,
    0x91F9, 0xE4A5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE4A4, 0x0000, 0x0000, 0x0000, 0x0000, 0xE4A7, 0x0000, 0x0000,
    0x0000, 0x9190, 0x8C74, 0x0000, 0x0000, 0x0000, 0x0000, 0x8960,
    0xE4A6, 0x0000, 0x8D72, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9191, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE4B8, 0x0000, 0xE4B9, 0x0000, 0x89D7,
    0x0000, 0x0000, 0x0000, 0x89AC, 0xE4B6, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE4AC, 0x0000, 0xE4B4,
    0x0000, 0xE4BB, 0xE4B5, 0x0000, 0x0000, 0x0000, 0xE4B3, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE496, 0x0000, 0x0000, 0xE4B1, 0x0000,
    0x0000, 0x0000, 0xE4AD, 0x0000, 0x0000, 0x0000, 0x8ACE, 0xE4AF,
    0xE4BA, 0x0000, 0xE4B0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE4BC, 0x0000, 0xE4AE, 0x949C, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9789, 0x0000, 0x0000, 0x0000, 0xE4B7, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE4CD, 0x0000, 0x0000,
    0x0000, 0xE4C5, 0x0000, 0x0000, 0x0000, 0x909B, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8B65, 0x0000, 0x8BDB, 0x0000, 0xE4C0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x89D9, 0x0000, 0x0000, 0x8FD2, 0x0000,
    0xE4C3, 0x0000, 0x0000, 0x0000, 0x8DD8, 0x0000, 0x0000, 0x9370,
    0xE4C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x95EC, 0x0000, 0xE4BF, 0x0000, 0x0000, 0x0000, 0x89D8,
    0x8CD4, 0x9548, 0xE4C9, 0x0000, 0xE4BD, 0x0000, 0x0000, 0xE4C6,
    0x0000, 0x0000, 0x0000, 0xE4D0, 0x0000, 0xE4C1, 0x0000, 0x0000,
};

static const u16 U84[0x100] =
{
    0x0000, 0x0000, 0x0000, 0xE4C2, 0x93B8, 0x0000, 0x0000, 0xE4C7,
    0x0000, 0x0000, 0x0000, 0xE4C4, 0x9647, 0xE4CA, 0x88DE, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE4BE, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE4CC, 0x0000, 0xE4CB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x948B, 0xE4D2, 0x0000, 0xE4DD, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8A9E, 0x0000, 0x0000, 0x0000, 0xE4E0, 0x0000, 0x0000,
    0xE4CE, 0x0000, 0x0000, 0x0000, 0xE4D3, 0x978E, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE4DC, 0x0000,
    0x0000, 0x9774, 0x0000, 0x0000, 0x0000, 0x0000, 0x97A8, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9298,
    0x0000, 0x0000, 0x0000, 0x8A8B, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x9592, 0xE4E2, 0x939F, 0x0000, 0x0000, 0x88AF, 0x0000,
    0x0000, 0xE4DB, 0x0000, 0xE4D7, 0x9192, 0xE4D1, 0xE4D9, 0xE4DE,
    0x0000, 0x944B, 0x0000, 0x0000, 0x0000, 0x88A8, 0x0000, 0xE4D6,
    0x0000, 0xE4DF, 0x9598, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE4DA, 0x0000, 0xE4D5, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8FD3, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8F4E, 0x0000, 0x0000, 0x0000, 0x8EAA, 0x0000, 0x0000, 0x0000,
    0x0000, 0x96D6, 0x0000, 0x0000, 0x9566, 0x0000, 0x0000, 0xE4E5,
    0x0000, 0xE4EE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE4D8, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8A97, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8FF6, 0xE4E3, 0x0000, 0xE4E8, 0x9193, 0x0000, 0x0000, 0xE4E4,
    0x0000, 0xE4EB, 0x0000, 0x0000, 0x927E, 0x0000, 0xE4EC, 0x0000,
    0x0000, 0x9775, 0xE4E1, 0x8A57, 0x0000, 0xE4E7, 0x0000, 0x0000,
    0xE4EA, 0x96AA, 0x0000, 0x0000, 0x0000, 0x0000, 0xE4ED, 0x0000,
    0x0000, 0xE4E6, 0xE4E9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9648, 0x0000, 0x9840, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE4F1, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE4F8, 0x0000, 0x0000, 0xE4F0,
};

static const u16 U85[0x100] =
{
    0x8EC1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE4CF, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x95CC, 0x0000, 0x96A0, 0xE4F7, 0xE4F6, 0x0000, 0xE4F2,
    0xE4F3, 0x0000, 0x8955, 0x0000, 0x0000, 0x0000, 0x0000, 0xE4F5,
    0x0000, 0xE4EF, 0x0000, 0x0000, 0x0000, 0x0000, 0x92D3, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE4F4, 0x88FC, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x91A0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x95C1, 0x0000, 0x0000,
    0xE4F9, 0xE540, 0x0000, 0x94D7, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE4FC, 0x8FD4, 0x8EC7, 0xE542, 0x0000, 0x0000, 0x8BBC, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE543, 0x0000, 0x9599,
    0xE4FB, 0x0000, 0xE4D4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE4FA, 0x0000, 0x0000, 0x0000, 0x0000,
    0x986E, 0x93A0, 0x9593, 0x0000, 0x0000, 0xE54A, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE550,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE551, 0x0000,
    0xE544, 0x0000, 0x0000, 0x0000, 0x9496, 0x0000, 0x0000, 0xE54E,
    0xE546, 0x0000, 0xE548, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE552, 0xE547, 0x0000, 0x0000, 0xE54B, 0x0000, 0x0000, 0x8992,
    0x0000, 0x93E3, 0x0000, 0xE54C, 0xE54F, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE545, 0x0000, 0x9145, 0x0000,
    0xE549, 0x8E46, 0x9064, 0x8C4F, 0x96F2, 0x0000, 0x96F7, 0x8F92,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE556, 0xE554, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x986D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE553, 0x0000, 0x0000, 0x0000, 0x9795, 0x0000, 0xE555,
    0xE557, 0x0000, 0x0000, 0x0000, 0x0000, 0xE558, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE55B, 0xE559, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x93A1, 0xE55A, 0x0000, 0x0000,
    0x0000, 0x94CB, 0xE54D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F93,
    0x0000, 0xE55C, 0xE561, 0x9194, 0x0000, 0x0000, 0xE560, 0x0000,
};

static const u16 U86[0x100] =
{
    0x0000, 0x0000, 0xE541, 0x0000, 0x0000, 0x0000, 0xE562, 0x9168,
    0x0000, 0x0000, 0xE55D, 0xE55F, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE55E, 0x0000, 0x0000, 0x9F50, 0x9F41,
    0x0000, 0x0000, 0xE564, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE563, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9796, 0x0000, 0xE1BA,
    0xE565, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE566,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE567, 0x8CD5, 0x0000,
    0x8B73, 0x0000, 0x0000, 0x0000, 0xE569, 0x997C, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8B95, 0x0000, 0x97B8, 0x0000, 0x8BF1, 0xE56A,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE56B,
    0x0000, 0x0000, 0x0000, 0x928E, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE56C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x93F8, 0x0000, 0x88B8, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x89E1, 0xE571, 0xE572, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE56D, 0x0000, 0x8E5C, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE56E, 0x9461, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE56F, 0xE570, 0xE57A, 0x0000, 0x0000, 0x0000, 0xE574,
    0xE577, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE573, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE575, 0x0000, 0xE576, 0x8ED6,
    0x0000, 0xE578, 0x0000, 0x9260, 0x0000, 0x8C75, 0x8A61, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE57B, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8A5E, 0x0000, 0xE581, 0x0000, 0x0000, 0xE57C, 0xE580,
    0x0000, 0x0000, 0x0000, 0x0000, 0x94B8, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE57D, 0x0000, 0x0000, 0xE57E, 0x9567, 0x94D8, 0xE582,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x91FB, 0xE58C, 0x0000, 0xE588, 0x0000, 0x0000, 0x89E9, 0x0000,
};

static const u16 U87[0x100] =
{
    0xE586, 0x0000, 0x9649, 0xE587, 0x0000, 0x0000, 0xE584, 0x0000,
    0xE585, 0xE58A, 0xE58D, 0x0000, 0x0000, 0xE58B, 0x0000, 0x0000,
    0x0000, 0xE589, 0xE583, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9277, 0x0000, 0xE594, 0x0000, 0x96A8, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE592, 0x0000, 0x0000,
    0x0000, 0xE593, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE58E, 0x0000, 0x0000, 0xE590,
    0x0000, 0x0000, 0x0000, 0xE591, 0x0000, 0x0000, 0x0000, 0xE58F,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x90E4, 0x0000, 0x9858, 0xE598, 0x0000, 0xE599, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE59F, 0x0000, 0x9049, 0x0000, 0xE59B,
    0x0000, 0xE59E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE596,
    0xE595, 0x0000, 0x0000, 0xE5A0, 0x0000, 0x0000, 0x89DA, 0x0000,
    0xE59C, 0x0000, 0xE5A1, 0x0000, 0x0000, 0x0000, 0xE59D, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE59A, 0x0000, 0x92B1, 0x0000,
    0xE597, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9488,
    0x0000, 0x0000, 0xE5A5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x975A, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE5A4,
    0x0000, 0x0000, 0xE5A3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE5AC, 0x0000, 0x0000, 0x0000, 0xE5A6,
    0x0000, 0x0000, 0x0000, 0xE5AE, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9786, 0xE5B1, 0x0000, 0xE5A8, 0x0000, 0x0000,
    0xE5A9, 0x0000, 0x0000, 0x0000, 0xE5AD, 0x0000, 0xE5B0, 0xE5AF,
    0x0000, 0x0000, 0x0000, 0xE5A7, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE5AA, 0x0000, 0xE5BB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE5B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE5B2,
    0x0000, 0x0000, 0xE5B3, 0x0000, 0x0000, 0x0000, 0xE5B8, 0xE5B9,
    0x0000, 0x8A49, 0x0000, 0x8B61, 0x0000, 0x0000, 0xE5B7, 0x0000,
};

static const u16 U88[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE5A2, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE5B6, 0xE5BA, 0xE5B5,
    0x0000, 0xE5BC, 0x0000, 0x0000, 0x0000, 0xE5BE, 0xE5BD, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE5C0, 0xE5BF, 0xE579, 0x0000, 0x0000, 0x0000, 0xE5C4,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE5C1, 0x0000, 0x0000, 0x0000, 0x0000, 0xE5C2, 0x0000,
    0x0000, 0xE5C3, 0x0000, 0xE5C5, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8C8C, 0x0000, 0xE5C7, 0x0000, 0xE5C6, 0x0000, 0x8F4F, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8D73, 0x9FA5, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE5C8, 0x8F70, 0x0000, 0x0000, 0x0000, 0x8A58,
    0x0000, 0xE5C9, 0x0000, 0x8971, 0x0000, 0x8FD5, 0xE5CA, 0x0000,
    0x0000, 0x8D74, 0xE5CB, 0x88DF, 0x0000, 0x0000, 0x0000, 0x0000,
    0x955C, 0x0000, 0x0000, 0xE5CC, 0x0000, 0x0000, 0x0000, 0x0000,
    0x908A, 0x0000, 0xE5D3, 0x0000, 0x0000, 0xE5D0, 0x0000, 0x928F,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE5D1, 0xE5CE, 0x8BDC,
    0x0000, 0xE5CD, 0xE5D4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8C55, 0x0000, 0x0000, 0x91DC, 0x0000, 0xE5DA, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE5D6, 0x0000, 0x0000, 0x0000, 0x91B3, 0xE5D5,
    0x0000, 0xE5D8, 0x0000, 0x0000, 0x0000, 0x0000, 0xE5CF, 0x0000,
    0x0000, 0x0000, 0xE5D9, 0x0000, 0xE5DB, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x94ED, 0x0000, 0x0000, 0xE5D7, 0x0000,
    0xE5DC, 0xE5DE, 0x0000, 0x0000, 0x8CD1, 0xE5D2, 0x0000, 0x88BF,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE5DD,
    0x0000, 0x8DD9, 0x97F4, 0xE5DF, 0xE5E0, 0x9195, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x97A0,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE5E1, 0x9754, 0x0000, 0x0000,
    0xE5E2, 0xE5E3, 0x0000, 0x0000, 0x95E2, 0xE5E4, 0x0000, 0x8DBE,
    0x0000, 0x97A1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE5E9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE5EA, 0x8FD6, 0xE5E8, 0x0000, 0x0000, 0x0000,
    0x9787, 0xE5E5, 0x0000, 0x0000, 0xE5E7, 0x90BB, 0x909E, 0x0000,
};

static const u16 U89[0x100] =
{
    0x0000, 0x0000, 0xE5E6, 0x0000, 0xE5EB, 0x0000, 0x0000, 0x95A1,
    0x0000, 0x0000, 0xE5ED, 0x0000, 0xE5EC, 0x0000, 0x0000, 0x0000,
    0x8A8C, 0x0000, 0x964A, 0xE5EE, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE5FA, 0xE5F0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE5F1, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE5F2, 0xE5F3, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE5F7, 0x0000,
    0xE5F8, 0x0000, 0x0000, 0xE5F6, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE5F4, 0x0000, 0xE5EF, 0xE5F5, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE5F9, 0xE8B5, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x89A6, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE5FC, 0x8BDD,
    0xE5FB, 0x0000, 0x0000, 0x0000, 0xE641, 0x0000, 0xE640, 0x0000,
    0x0000, 0x0000, 0xE643, 0x0000, 0x0000, 0xE642, 0x0000, 0xE644,
    0x0000, 0x0000, 0x8F50, 0x0000, 0xE645, 0x0000, 0x0000, 0xE646,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE647, 0x90BC,
    0x0000, 0x9776, 0x0000, 0xE648, 0x0000, 0x0000, 0x95A2, 0x9465,
    0xE649, 0x0000, 0xE64A, 0x8CA9, 0x0000, 0x0000, 0x0000, 0x8B4B,
    0x0000, 0x0000, 0x0000, 0xE64B, 0x0000, 0x0000, 0x8E8B, 0x9460,
    0xE64C, 0x0000, 0x8A6F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE64D, 0x0000, 0x0000, 0x0000, 0x0000, 0xE64F, 0x9797,
    0x0000, 0xE64E, 0x9065, 0x0000, 0xE650, 0x0000, 0x0000, 0xE651,
    0x0000, 0x0000, 0xE652, 0x8ACF, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE653, 0x0000, 0x0000, 0xE654, 0x0000, 0xE655,
    0xE656, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8A70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE657, 0x0000, 0xE658, 0xE659, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x89F0, 0x0000, 0x0000, 0x9047, 0xE65A,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE65B, 0x0000, 0x0000, 0x0000,
    0xE65C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U8a[0x100] =
{
    0x8CBE, 0x0000, 0x92F9, 0xE65D, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8C76, 0x0000, 0x9075, 0x0000, 0xE660, 0x0000, 0x93A2, 0x0000,
    0xE65F, 0x0000, 0x0000, 0x8C50, 0x0000, 0x0000, 0xE65E, 0x91F5,
    0x8B4C, 0x0000, 0x0000, 0xE661, 0x0000, 0xE662, 0x0000, 0x8FD7,
    0x0000, 0x0000, 0x0000, 0x8C8D, 0x0000, 0xE663, 0x0000, 0x0000,
    0x0000, 0x0000, 0x964B, 0x0000, 0x0000, 0x90DD, 0x0000, 0x0000,
    0x0000, 0x8B96, 0x0000, 0x96F3, 0x9169, 0x0000, 0xE664, 0x0000,
    0x0000, 0x0000, 0x9066, 0x9290, 0x8FD8, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE665, 0x0000, 0x0000, 0x0000, 0x0000, 0xE668, 0x0000,
    0xE669, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8DBC, 0x91C0, 0xE667, 0x0000, 0x8FD9, 0x955D, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE666, 0x0000, 0x0000, 0x8E8C, 0x0000,
    0x8972, 0x0000, 0xE66D, 0x8C77, 0x0000, 0x0000, 0x8E8E, 0x0000,
    0x0000, 0x8E8D, 0x0000, 0x986C, 0xE66C, 0xE66B, 0x9146, 0x0000,
    0x8B6C, 0x9862, 0x8A59, 0x8FDA, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE66A, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE66F, 0x0000, 0xE670, 0xE66E, 0x0000, 0x8CD6,
    0x0000, 0x975F, 0x0000, 0x0000, 0x8E8F, 0x9446, 0x0000, 0x0000,
    0x0000, 0xE673, 0x0000, 0x90BE, 0x0000, 0x9261, 0x0000, 0x0000,
    0x9755, 0x0000, 0xE676, 0x0000, 0x0000, 0x0000, 0x8CEA, 0x0000,
    0x90BD, 0xE672, 0x0000, 0xE677, 0x8CEB, 0xE674, 0xE675, 0x0000,
    0xE671, 0x0000, 0x0000, 0x0000, 0x90E0, 0x93C7, 0x0000, 0x0000,
    0x924E, 0x0000, 0x89DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x94EE, 0x0000, 0x0000, 0x8B62, 0x0000, 0x0000, 0x92B2,
    0x0000, 0x0000, 0xE67A, 0x0000, 0xE678, 0x0000, 0x0000, 0x926B,
    0x0000, 0x0000, 0x0000, 0x90BF, 0x8AD0, 0xE679, 0x0000, 0x907A,
    0x0000, 0x0000, 0x97C8, 0x0000, 0x0000, 0x0000, 0x985F, 0x0000,
    0x0000, 0x0000, 0xE67B, 0xE687, 0x92B3, 0x0000, 0xE686, 0x0000,
    0xE683, 0xE68B, 0xE684, 0x0000, 0xE680, 0x0000, 0x92FA, 0xE67E,
    0x0000, 0x0000, 0x0000, 0xE67C, 0x0000, 0x9740, 0x8E90, 0x0000,
    0x0000, 0xE681, 0x0000, 0xE67D, 0x0000, 0x0000, 0x0000, 0xE685,
    0x8F94, 0x0000, 0x8CBF, 0x0000, 0x0000, 0x0000, 0x91F8, 0x0000,
};

static const u16 U8b[0x100] =
{
    0x9664, 0x8979, 0x88E0, 0x0000, 0x93A3, 0x0000, 0x0000, 0xE689,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE688, 0x0000, 0x93E4, 0x0000,
    0xE68D, 0x0000, 0x0000, 0x0000, 0xE682, 0x0000, 0xE68C, 0xE68E,
    0x0000, 0x8CAA, 0xE68A, 0x8D75, 0x0000, 0x8ED3, 0x0000, 0x0000,
    0xE68F, 0x9777, 0x0000, 0x0000, 0x0000, 0x0000, 0xE692, 0x0000,
    0xE695, 0x0000, 0x0000, 0xE693, 0x9554, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE690, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8BDE, 0x0000, 0x0000, 0x0000, 0x0000, 0xE694, 0x0000,
    0x0000, 0xE696, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE69A, 0x0000, 0x0000, 0xE697, 0x0000, 0xE699, 0xE698,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE69B, 0x0000,
    0x8EAF, 0x0000, 0xE69D, 0xE69C, 0x9588, 0x0000, 0x0000, 0xE69F,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8C78, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE69E, 0xE6A0, 0x0000, 0x0000, 0xE6A1,
    0x8B63, 0xE3BF, 0x8FF7, 0x0000, 0xE6A2, 0x0000, 0x0000, 0x8CEC,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE6A3, 0x0000, 0x0000,
    0xE6A4, 0x0000, 0x0000, 0x8E5D, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9DCC, 0x0000, 0xE6A5, 0x0000, 0xE6A6, 0x0000,
    0x8F51, 0x0000, 0xE6A7, 0xE6A8, 0x0000, 0x0000, 0xE6A9, 0x0000,
    0x0000, 0xE6AA, 0xE6AB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U8c[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x924A,
    0x0000, 0x0000, 0xE6AC, 0x0000, 0x0000, 0x0000, 0x0000, 0xE6AE,
    0x0000, 0xE6AD, 0x0000, 0x0000, 0x0000, 0x0000, 0x93A4, 0x0000,
    0xE6AF, 0x0000, 0x964C, 0x0000, 0xE6B0, 0x0000, 0xE6B1, 0x0000,
    0xE6B2, 0x0000, 0x0000, 0x0000, 0x0000, 0xE6B3, 0x0000, 0x0000,
    0x0000, 0x0000, 0x93D8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8FDB, 0xE6B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8D8B, 0x98AC, 0xE6B5, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE6B6, 0x955E, 0xE6B7, 0x0000, 0xE6BF, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE6B8, 0x0000, 0x0000, 0xE6BA, 0x0000, 0x0000,
    0x0000, 0xE6B9, 0xE6BB, 0x0000, 0x9665, 0xE6BC, 0xE6BD, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE6BE, 0x0000, 0x0000, 0x0000,
    0xE6C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x8A4C, 0x92E5, 0x0000,
    0x9589, 0x8DE0, 0x8D76, 0x0000, 0x0000, 0x0000, 0x0000, 0x956E,
    0x89DD, 0x94CC, 0xE6C3, 0x8AD1, 0x90D3, 0xE6C2, 0xE6C7, 0x9299,
    0x96E1, 0x0000, 0xE6C5, 0xE6C6, 0x8B4D, 0x0000, 0xE6C8, 0x9483,
    0x91DD, 0x0000, 0x0000, 0x94EF, 0x935C, 0xE6C4, 0x0000, 0x9666,
    0x89EA, 0xE6CA, 0x9847, 0x92C0, 0x9864, 0x0000, 0x0000, 0x8E91,
    0xE6C9, 0x0000, 0x91AF, 0x0000, 0x0000, 0xE6DA, 0x9147, 0x0000,
    0x0000, 0x93F6, 0x0000, 0x956F, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE6CD, 0x8E5E, 0x8E92, 0x0000, 0x8FDC, 0x0000,
    0x9485, 0x0000, 0x8CAB, 0xE6CC, 0xE6CB, 0x0000, 0x958A, 0x0000,
    0x0000, 0x0000, 0x8EBF, 0x0000, 0x0000, 0x9371, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE6CF, 0xE6D0, 0x8D77, 0xE6CE, 0x0000, 0x0000,
};

static const u16 U8d[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0xE6D1, 0xE6D2, 0x0000, 0xE6D4,
    0x91A1, 0x0000, 0xE6D3, 0x8AE4, 0x0000, 0xE6D6, 0x0000, 0xE6D5,
    0xE6D7, 0x0000, 0x0000, 0xE6D9, 0xE6DB, 0x0000, 0xE6DC, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x90D4, 0x0000, 0x8ECD, 0xE6DD,
    0x0000, 0x0000, 0x0000, 0x8A71, 0x0000, 0xE6DE, 0x0000, 0x0000,
    0x9196, 0xE6DF, 0x0000, 0xE6E0, 0x958B, 0x0000, 0x0000, 0x8B4E,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE6E1, 0x0000, 0x0000, 0x0000, 0x92B4, 0x0000, 0x0000,
    0x0000, 0x0000, 0x897A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE6E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8EEF, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9096, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x91AB, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE6E5, 0x0000, 0x0000, 0x0000, 0xE6E4, 0x0000,
    0x0000, 0x0000, 0xE6E3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE6EB, 0xE6E9, 0x0000, 0x0000, 0xE6E6,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE6E8, 0x0000,
    0x0000, 0x0000, 0xE6E7, 0xE6EA, 0x0000, 0x8B97, 0x0000, 0xE6EE,
    0x0000, 0x90D5, 0x0000, 0xE6EF, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8CD7, 0x0000, 0xE6EC, 0xE6ED, 0x0000, 0x0000, 0x0000, 0x9848,
    0x0000, 0x0000, 0x0000, 0x92B5, 0x0000, 0x9148, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE6F0, 0x0000, 0x0000, 0xE6F3,
};

static const u16 U8e[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE6F1, 0xE6F2, 0x9778, 0x0000, 0x0000, 0x0000, 0x0000, 0x93A5,
    0xE6F6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE6F4, 0xE6F5, 0xE6F7,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE748, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE6FA, 0x0000, 0x0000, 0x0000, 0xE6FB, 0xE6F9, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE6F8, 0x0000, 0x92FB, 0x0000, 0x0000, 0xE740,
    0xE744, 0xE741, 0xE6FC, 0x0000, 0xE742, 0x0000, 0x0000, 0x0000,
    0xE743, 0x0000, 0x0000, 0x0000, 0x0000, 0xE74A, 0x0000, 0x0000,
    0x0000, 0xE745, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x90D6,
    0xE747, 0x0000, 0x0000, 0xE749, 0xE746, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE74C, 0x0000, 0x8F52, 0x0000, 0xE74B, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE74D, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE74E, 0x0000, 0x0000, 0xE751, 0xE750, 0x0000, 0xE74F,
    0x0000, 0x0000, 0xE753, 0xE752, 0x0000, 0x96F4, 0x0000, 0x0000,
    0x0000, 0xE755, 0x0000, 0xE754, 0xE756, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE757, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE759, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE758, 0x9067, 0xE75A, 0x0000, 0x0000, 0x8BEB,
    0xE75B, 0xE75D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE75E, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE75F, 0xE75C, 0x0000,
    0xE760, 0x0000, 0x8ED4, 0xE761, 0x8B4F, 0x8C52, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8CAC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE762, 0x0000, 0x0000, 0x0000, 0x93EE,
    0x0000, 0x0000, 0x935D, 0xE763, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE766, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8EB2, 0x0000, 0x0000, 0xE765, 0xE764, 0x8C79, 0xE767, 0x0000,
};

static const u16 U8f[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x8A72, 0x0000, 0xE769, 0x0000, 0x0000,
    0x0000, 0x8DDA, 0xE768, 0x0000, 0xE771, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE76B, 0xE76D, 0x95E3, 0xE76A, 0x0000, 0x0000,
    0x0000, 0xE76C, 0x0000, 0xE770, 0xE76E, 0x8B50, 0x0000, 0xE76F,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE772, 0x0000,
    0x0000, 0x9479, 0x97D6, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F53,
    0x0000, 0x0000, 0x0000, 0xE773, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9741, 0xE775, 0x0000, 0xE774, 0x0000, 0x0000, 0xE778, 0x9760,
    0x0000, 0x0000, 0xE777, 0x0000, 0x8A8D, 0xE776, 0xE77B, 0x0000,
    0x0000, 0xE77A, 0x0000, 0x0000, 0xE779, 0x9351, 0xE77C, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE77D,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE77E, 0x0000, 0x0000, 0x8D8C,
    0x0000, 0x8C44, 0xE780, 0xE781, 0xE782, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9068, 0xE783, 0x0000, 0x8EAB, 0xE784,
    0x0000, 0x0000, 0x0000, 0xE785, 0x0000, 0x0000, 0x0000, 0x999F,
    0x999E, 0x0000, 0x0000, 0x0000, 0x0000, 0xE786, 0xE390, 0xE787,
    0x9243, 0x904A, 0x945F, 0x0000, 0x0000, 0x0000, 0x0000, 0xE788,
    0x0000, 0x0000, 0x95D3, 0x92D2, 0x8D9E, 0x0000, 0x0000, 0x9248,
    0x0000, 0x0000, 0x8949, 0x0000, 0x9698, 0x9076, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8C7D, 0x0000,
    0x0000, 0x8BDF, 0x0000, 0x0000, 0x95D4, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE789, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE78B, 0x0000, 0x0000, 0xE78A, 0x89DE, 0x0000,
    0x0000, 0x93F4, 0xE78C, 0x9497, 0x0000, 0x9352, 0x0000, 0xE78D,
    0x8F71, 0x0000, 0x0000, 0x0000, 0xE78F, 0x0000, 0x0000, 0x96C0,
    0xE79E, 0xE791, 0xE792, 0x0000, 0x0000, 0x92C7, 0x0000, 0x0000,
};

static const u16 U90[0x100] =
{
    0x91DE, 0x9197, 0x0000, 0x93A6, 0x0000, 0xE790, 0x8B74, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE799, 0x0000, 0xE796, 0xE7A3, 0x93A7,
    0x9280, 0xE793, 0x0000, 0x92FC, 0x9372, 0xE794, 0xE798, 0x9080,
    0x0000, 0x9487, 0x92CA, 0x0000, 0x0000, 0x90C0, 0xE797, 0x91AC,
    0x91A2, 0xE795, 0x88A7, 0x9841, 0x0000, 0x0000, 0x0000, 0xE79A,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x91DF, 0x0000,
    0x0000, 0x8F54, 0x9069, 0x0000, 0x0000, 0xE79C, 0xE79B, 0x0000,
    0x88ED, 0xE79D, 0x0000, 0x0000, 0x954E, 0x0000, 0xE7A5, 0x0000,
    0x0000, 0x93D9, 0x908B, 0x0000, 0x0000, 0x9278, 0x0000, 0x8BF6,
    0x0000, 0xE7A4, 0x9756, 0x895E, 0x0000, 0x95D5, 0x89DF, 0xE79F,
    0xE7A0, 0xE7A1, 0xE7A2, 0x93B9, 0x9242, 0x88E1, 0xE7A6, 0x0000,
    0xE7A7, 0xEAA1, 0x0000, 0x0000, 0x91BB, 0x0000, 0xE7A8, 0x0000,
    0x8993, 0x916B, 0x0000, 0x8CAD, 0x0000, 0x9779, 0x0000, 0x0000,
    0xE7A9, 0x934B, 0x0000, 0x0000, 0x0000, 0x9198, 0x8ED5, 0xE7AA,
    0x0000, 0x0000, 0xE7AD, 0x0000, 0x0000, 0x8F85, 0xE7AB, 0x914A,
    0x9149, 0x0000, 0x88E2, 0x0000, 0x97C9, 0xE7AF, 0x0000, 0x94F0,
    0xE7B1, 0xE7B0, 0xE7AE, 0xE284, 0x8AD2, 0x0000, 0x0000, 0xE78E,
    0x0000, 0xE7B3, 0xE7B2, 0x0000, 0x0000, 0x0000, 0x0000, 0xE7B4,
    0x0000, 0x9757, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x93DF, 0x0000, 0x0000, 0x964D, 0x0000,
    0xE7B5, 0x0000, 0x8ED7, 0x0000, 0x0000, 0x0000, 0x0000, 0xE7B6,
    0x0000, 0xE7B7, 0x0000, 0x0000, 0x0000, 0xE7B8, 0x0000, 0x0000,
    0x9340, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x88E8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x8D78, 0x0000, 0x0000, 0x0000, 0x9859, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE7BC, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8C53, 0xE7B9, 0x0000, 0xE7BA, 0x0000, 0x0000, 0x0000,
    0x9594, 0x0000, 0x0000, 0x0000, 0x0000, 0x8A73, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9758, 0x0000, 0x8BBD,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9373, 0x0000, 0x0000,
};

static const u16 U91[0x100] =
{
    0x0000, 0x0000, 0xE7BD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE7BE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE7BF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9341, 0x0000, 0x0000,
    0xE7C1, 0x0000, 0xE7C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x93D1, 0xE7C2, 0x8F55, 0x8EDE, 0x947A, 0x9291, 0x0000,
    0x0000, 0x0000, 0x8EF0, 0x0000, 0x908C, 0x0000, 0xE7C3, 0x0000,
    0xE7C4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x907C, 0xE7C5, 0x0000, 0xE7C6, 0x0000, 0x0000,
    0x0000, 0xE7C7, 0x978F, 0x0000, 0x8F56, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE7C9, 0xE7C8, 0x0000, 0x8D79, 0x0000, 0x8D93,
    0x8E5F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE7CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x8F86,
    0x0000, 0xE7CB, 0x0000, 0xE7CA, 0x0000, 0x91E7, 0x0000, 0x0000,
    0x8CED, 0x0000, 0x90C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x94AE,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8F58, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE7CD, 0x0000, 0x8FDD, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE7D0, 0xE7CE, 0x0000, 0x0000, 0x0000, 0xE7CF,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE7D2, 0xE7D1, 0x0000, 0x0000,
    0x8FF8, 0x0000, 0xE7D3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE7D4, 0xE7D5, 0x0000, 0x0000, 0x0000, 0x0000, 0x94CE, 0x8DD1,
    0x8EDF, 0xE7D6, 0x0000, 0xE7D7, 0x97A2, 0x8F64, 0x96EC, 0x97CA,
    0xE7D8, 0x8BE0, 0x0000, 0x0000, 0x0000, 0x0000, 0xE7D9, 0x0000,
    0x9342, 0x0000, 0x0000, 0xE7DC, 0x8A98, 0x906A, 0x0000, 0xE7DA,
    0x0000, 0xE7DB, 0x0000, 0x92DE, 0x0000, 0x0000, 0x9674, 0x8BFA,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE7DE, 0xE7DF, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE7DD, 0x0000, 0x0000, 0xE7E1,
};

static const u16 U92[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x93DD, 0x8A62, 0x0000,
    0x0000, 0xE7E5, 0x0000, 0x0000, 0xE7E2, 0xE7E4, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE7E0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE86E, 0x0000, 0x0000, 0xE7E3, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x97E9, 0x0000, 0x0000, 0x8CD8,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE7ED,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9353, 0xE7E8, 0x0000, 0x0000,
    0xE7EB, 0xE7E9, 0x0000, 0xE7EE, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE7EF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE7E7,
    0x0000, 0x0000, 0xE7F4, 0x8994, 0x0000, 0x0000, 0xE7E6, 0x0000,
    0x0000, 0x0000, 0x94AB, 0x0000, 0xE7EA, 0x0000, 0x8FDE, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8D7A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9667, 0x0000,
    0x8BE2, 0x0000, 0x0000, 0x8F65, 0x0000, 0x93BA, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x914C, 0x0000, 0xE7F2, 0x0000, 0xE7EC, 0xE7F1, 0x0000,
    0x96C1, 0x0000, 0x92B6, 0xE7F3, 0xE7F0, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x914B, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE7F7,
    0x0000, 0xE7F6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE7F5,
    0x0000, 0x0000, 0x964E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8F9B, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE7F8, 0x95DD, 0x0000, 0x0000, 0x8973, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9565, 0x9292, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8B98, 0x0000, 0xE7FA, 0x0000, 0x8D7C, 0x0000, 0x0000, 0x0000,
};

static const u16 U93[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8E4B, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE7F9,
    0x908D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x908E, 0xE840, 0xE842, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8FF9, 0x0000, 0xE841, 0xE843, 0x0000, 0x0000, 0x8BD1, 0x0000,
    0x9564, 0x0000, 0x0000, 0x8EE0, 0x9842, 0x0000, 0xE7FC, 0x8DF6,
    0x0000, 0x0000, 0x985E, 0x0000, 0x0000, 0xE845, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE844, 0xE846, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE7FB, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x93E7, 0x0000, 0x9374, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x92D5, 0x0000, 0xE84B, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9262, 0xE847, 0x0000, 0x0000, 0x0000,
    0xE848, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8C4C, 0x0000, 0xE84A, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8CAE, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE849, 0x0000, 0x8FDF, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8A99, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE84F, 0x0000, 0x8DBD, 0x9199,
    0x0000, 0x0000, 0x92C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8A5A,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE84D, 0xE84E, 0x92C1, 0x0000,
    0xE84C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE850, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE856, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE859, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE858, 0x934C, 0x0000, 0x0000, 0x0000, 0x0000, 0xE851, 0xE852,
    0xE855, 0x0000, 0x0000, 0x0000, 0x0000, 0xE857, 0x0000, 0x0000,
    0x0000, 0x8BBE, 0x0000, 0x0000, 0xE85A, 0xE854, 0x0000, 0x0000,
    0xE853, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U94[0x100] =
{
    0x0000, 0x0000, 0x0000, 0xE85E, 0x0000, 0x0000, 0x0000, 0xE85F,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE860, 0x0000, 0x0000, 0xE85D, 0xE85C, 0x0000, 0x0000, 0x0000,
    0x8FE0, 0x93A8, 0xE85B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE864, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE862, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE863, 0xE861, 0x0000,
    0x91F6, 0x0000, 0xE865, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE866, 0x0000, 0x0000, 0xE868, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8AD3, 0xE867, 0x96F8, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE873, 0xE869, 0x0000, 0x0000, 0xE86C, 0x0000,
    0xE86A, 0x0000, 0xE86B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xE86D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE86F, 0x0000, 0x0000, 0x0000, 0x0000, 0xE870, 0x0000, 0xE871,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE874, 0xE872, 0xE875, 0xE877,
    0x0000, 0xE876, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U95[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x92B7,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x96E5, 0x0000, 0xE878, 0x914D, 0x0000, 0x0000, 0x0000, 0xE879,
    0x0000, 0x95C2, 0xE87A, 0x8A4A, 0x0000, 0x0000, 0x0000, 0x895B,
    0x0000, 0x8AD5, 0x0000, 0x8AD4, 0xE87B, 0x0000, 0xE87C, 0x0000,
    0xE87D, 0xE87E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE880, 0x0000, 0x8AD6, 0x8A74, 0x8D7D, 0x94B4, 0x0000, 0xE882,
    0xE881, 0x0000, 0x0000, 0x0000, 0x0000, 0xE883, 0x0000, 0x0000,
    0x0000, 0x0000, 0x897B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE886, 0x0000, 0xE885, 0xE884, 0x0000, 0xE887, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE88A, 0x0000, 0x0000, 0x0000, 0x88C5,
    0x0000, 0x0000, 0xE888, 0x0000, 0xE88C, 0xE88B, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE88E, 0xE88D, 0xE88F, 0x0000,
    0x93AC, 0x0000, 0x0000, 0x0000, 0xE890, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE891, 0xE893, 0x0000, 0x0000, 0xE892, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U96[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x958C, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE894, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE895, 0x0000, 0x8DE3, 0x0000, 0x0000, 0x0000, 0xE896, 0xE897,
    0x0000, 0x0000, 0x9668, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x916A, 0x0000, 0x0000, 0x0000, 0x88A2,
    0x91C9, 0x0000, 0xE898, 0x0000, 0x958D, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE89B, 0xE899, 0x8D7E, 0x0000, 0xE89A,
    0x8CC0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x95C3, 0xE89D, 0xE89F, 0xE89E, 0xE8A0,
    0x0000, 0x0000, 0x8940, 0x9077, 0x8F9C, 0x8AD7, 0xE8A1, 0x0000,
    0x0000, 0x0000, 0x9486, 0x0000, 0xE8A3, 0x0000, 0x0000, 0x0000,
    0x8941, 0x0000, 0xE8A2, 0x92C2, 0x0000, 0x97CB, 0x93A9, 0xE89C,
    0x97A4, 0x0000, 0x8CAF, 0x0000, 0x0000, 0x977A, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8BF7, 0x97B2, 0x0000,
    0x8C47, 0x0000, 0x91E0, 0xE440, 0x0000, 0xE8A4, 0x8A4B, 0x908F,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8A75, 0xE8A6, 0x0000, 0xE8A7,
    0xE8A5, 0x8C84, 0x0000, 0x8DDB, 0x8FE1, 0x0000, 0x0000, 0x0000,
    0x8942, 0x0000, 0x0000, 0x97D7, 0x0000, 0x0000, 0x0000, 0xE8A9,
    0xE7AC, 0x0000, 0xE8A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE8AC, 0xE8AA, 0xE8AB, 0x0000, 0xE8AD, 0x0000, 0xE8AE, 0x97EA,
    0xE8AF, 0xE8B0, 0x0000, 0x90C7, 0x94B9, 0x0000, 0x0000, 0x0000,
    0x909D, 0x8AE5, 0x0000, 0x0000, 0x9759, 0x89EB, 0x8F57, 0x8CD9,
    0x0000, 0xE8B3, 0x0000, 0xE8B2, 0x8E93, 0xE8B4, 0xE8B1, 0x0000,
    0x0000, 0x8E47, 0x0000, 0x0000, 0x0000, 0xE8B8, 0xE5AB, 0x0000,
    0x0000, 0x99D4, 0x0000, 0x9097, 0xE8B6, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x97A3, 0x93EF, 0x0000, 0x0000, 0x0000, 0x0000,
    0x894A, 0x0000, 0x90E1, 0x8EB4, 0x0000, 0x0000, 0x0000, 0x0000,
    0x95B5, 0x0000, 0x895F, 0x0000, 0x0000, 0x0000, 0x97EB, 0x978B,
    0x0000, 0xE8B9, 0x0000, 0x9364, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U97[0x100] =
{
    0x8EF9, 0x0000, 0x0000, 0x0000, 0xE8BA, 0x0000, 0xE8BB, 0x906B,
    0xE8BC, 0x0000, 0x97EC, 0x0000, 0x0000, 0xE8B7, 0xE8BE, 0xE8C0,
    0x0000, 0xE8BF, 0x0000, 0xE8BD, 0x0000, 0x0000, 0xE8C1, 0x0000,
    0x0000, 0xE8C2, 0x0000, 0x0000, 0x919A, 0x0000, 0x89E0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE8C3, 0x0000, 0x0000, 0x96B6,
    0x0000, 0x0000, 0xE8C4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE8C5, 0x0000, 0x9849, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9E50, 0xE8C6, 0x0000, 0x0000, 0x0000, 0xE8C7, 0xE8C8, 0x0000,
    0x0000, 0x0000, 0xE8CC, 0x0000, 0xE8C9, 0x0000, 0xE8CA, 0x0000,
    0xE8CB, 0xE8CD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x90C2, 0x0000, 0x0000, 0x0000, 0x96F5, 0x0000,
    0x0000, 0x90C3, 0x0000, 0x0000, 0xE8CE, 0x0000, 0x94F1, 0x0000,
    0xE8CF, 0xEA72, 0x96CA, 0x0000, 0xE8D0, 0x0000, 0xE8D1, 0x0000,
    0xE8D2, 0x8A76, 0x0000, 0xE8D4, 0x0000, 0x9078, 0x0000, 0x0000,
    0x0000, 0xE8D5, 0x0000, 0x0000, 0x8C43, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE8D6, 0xE8DA, 0x0000, 0xE8D8, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE8D9, 0x0000, 0x0000, 0x8A93, 0xE8D7, 0xE8DB, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE8DC, 0x0000, 0x88C6, 0x0000, 0xE8DD,
    0xE8DE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8FE2, 0x0000, 0x0000, 0x0000, 0xE8DF, 0x0000, 0x0000, 0x0000,
    0x8B66, 0x0000, 0x0000, 0xE8E2, 0x0000, 0x0000, 0xE8E1, 0x0000,
    0xE8E0, 0x0000, 0x0000, 0xE691, 0x0000, 0x95DA, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE8E3, 0xE8E4, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE8E5, 0x0000, 0x0000, 0xE8E6, 0x0000,
    0xE8E7, 0x0000, 0x0000, 0xE8E8, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8AD8, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE8E9, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE8EA, 0x9442, 0x0000,
    0x0000, 0x0000, 0xE8EC, 0x89B9, 0x0000, 0xE8EF, 0xE8EE, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8943, 0x0000, 0x0000, 0x0000, 0x8BBF,
};

static const u16 U98[0x100] =
{
    0x0000, 0x95C5, 0x92B8, 0x8DA0, 0x0000, 0x8D80, 0x8F87, 0x0000,
    0x907B, 0x0000, 0x0000, 0x0000, 0xE8F1, 0x0000, 0x0000, 0xE8F0,
    0x9761, 0x8AE6, 0x94D0, 0x93DA, 0x0000, 0x0000, 0x0000, 0x909C,
    0x97CC, 0x0000, 0x8C7A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE8F4, 0x0000, 0x0000, 0xE8F3, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x966A, 0x93AA, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x896F, 0x0000, 0x0000, 0xE8F5,
    0xE8F2, 0x0000, 0x0000, 0x9570, 0x978A, 0xE8F6, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE8F7, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE8F9, 0x91E8, 0x8A7A, 0x8A7B, 0xE8F8,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8AE7, 0x8CB0, 0x0000, 0x0000,
    0x8AE8, 0x0000, 0x0000, 0x935E, 0x0000, 0x0000, 0x97DE, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8CDA,
    0x0000, 0x0000, 0x0000, 0xE8FA, 0x0000, 0x0000, 0x0000, 0xE8FB,
    0xE8FC, 0xE940, 0x0000, 0xE942, 0xE941, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9597, 0x0000, 0xE943, 0x0000, 0x0000, 0x0000, 0x0000, 0xE944,
    0x0000, 0xE945, 0x0000, 0x0000, 0x0000, 0x0000, 0xE946, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE948, 0xE947, 0x0000, 0xE949, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x94F2, 0xE3CA, 0x0000, 0x0000, 0x9048,
    0x0000, 0x0000, 0x8B51, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE94A, 0x0000, 0xE94B, 0x0000, 0x99AA, 0x9F5A, 0x94D1,
    0x0000, 0x0000, 0x88F9, 0x0000, 0x88B9, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x8E94, 0x964F, 0x8FFC, 0x0000,
};

static const u16 U99[0x100] =
{
    0x0000, 0x0000, 0x0000, 0xE94C, 0x0000, 0x96DD, 0x0000, 0x0000,
    0x0000, 0xE94D, 0x977B, 0x0000, 0x8961, 0x0000, 0x0000, 0x0000,
    0x8E60, 0x0000, 0xE94E, 0x89EC, 0xE94F, 0x0000, 0x0000, 0x0000,
    0xE950, 0x0000, 0x0000, 0x0000, 0x0000, 0xE952, 0xE953, 0x0000,
    0xE955, 0xE951, 0x0000, 0x0000, 0xE954, 0x0000, 0x0000, 0x0000,
    0x8AD9, 0x0000, 0x0000, 0x0000, 0xE956, 0x0000, 0xE957, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE958, 0xE959, 0x0000,
    0x0000, 0x0000, 0xE95A, 0x0000, 0x0000, 0xE95C, 0x0000, 0x0000,
    0x0000, 0xE95B, 0x0000, 0xE95E, 0xE961, 0x0000, 0x0000, 0x0000,
    0xE95D, 0xE95F, 0xE960, 0x0000, 0x0000, 0xE962, 0x0000, 0x8BC0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8EF1, 0xE963,
    0xE964, 0x8D81, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE965, 0x0000, 0x0000,
    0x8A5D, 0x0000, 0x0000, 0x0000, 0x946E, 0xE966, 0xE967, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9279, 0x93E9, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE968, 0x0000, 0x0000, 0x0000,
    0x0000, 0x949D, 0x0000, 0x0000, 0x91CA, 0x8977, 0x8BEC, 0x0000,
    0x8BED, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x9293, 0xE96D, 0x8BEE, 0x0000, 0x0000, 0x89ED, 0x0000, 0x0000,
    0xE96C, 0x0000, 0x0000, 0xE96A, 0x0000, 0xE96B, 0x0000, 0xE969,
    0x0000, 0x0000, 0xE977, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE96E, 0xE96F, 0x0000,
    0x0000, 0xE970, 0xE971, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE973, 0x0000, 0x0000, 0xE972, 0x0000, 0x0000, 0x0000, 0x8F78,
};

static const u16 U9a[0x100] =
{
    0x0000, 0xE974, 0x0000, 0x0000, 0x0000, 0xE976, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8B52, 0xE975,
    0x0000, 0x0000, 0x919B, 0x8CB1, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE978, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x91CB, 0x0000, 0x0000, 0xE979, 0x0000, 0x0000, 0x0000, 0x0000,
    0x93AB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE97A,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE980, 0x0000,
    0xE97D, 0x0000, 0xE97C, 0xE97E, 0x0000, 0xE97B, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE982, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE981, 0x0000, 0xE984,
    0x0000, 0x0000, 0x8BC1, 0xE983, 0x0000, 0x0000, 0x0000, 0xE985,
    0x0000, 0x0000, 0xE986, 0x0000, 0xE988, 0xE987, 0x0000, 0x0000,
    0x0000, 0xE989, 0xE98B, 0xE98A, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8D9C, 0x0000, 0x0000, 0x0000, 0x0000, 0xE98C, 0x0000, 0x0000,
    0xE98D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x8A5B, 0x0000, 0x0000, 0x0000, 0xE98E, 0x0000, 0x0000, 0x0000,
    0xE98F, 0x0000, 0x0000, 0x0000, 0x9091, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE990,
    0x0000, 0xE991, 0x0000, 0xE992, 0xE993, 0x0000, 0x0000, 0x0000,
    0x8D82, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE994, 0xE995,
    0x0000, 0x0000, 0xE996, 0xE997, 0x0000, 0x0000, 0xE998, 0x0000,
    0x0000, 0x0000, 0x94AF, 0xE99A, 0x0000, 0x9545, 0xE99B, 0xE999,
    0x0000, 0xE99D, 0x0000, 0x0000, 0xE99C, 0x0000, 0x0000, 0xE99E,
    0x0000, 0x0000, 0x0000, 0xE99F, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U9b[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE9A0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE9A1, 0x0000, 0xE9A2, 0x0000, 0x0000, 0x0000, 0x0000, 0xE9A3,
    0x0000, 0x0000, 0xE9A4, 0xE9A5, 0x0000, 0xE9A6, 0x0000, 0xE9A7,
    0xE9A8, 0xE9A9, 0xE9AA, 0x0000, 0x0000, 0x0000, 0xE9AB, 0xE9AC,
    0x0000, 0x9F54, 0xE9AD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE2F6, 0x8B53, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8A40, 0x8DB0, 0xE9AF, 0xE9AE, 0x96A3, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE9B1, 0xE9B2, 0xE9B0,
    0x0000, 0xE9B3, 0x0000, 0x0000, 0x9682, 0x0000, 0x0000, 0x0000,
    0xE9B4, 0x0000, 0x8B9B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9844,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE9B5, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE9B7, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x88BC, 0x0000,
    0x0000, 0xE9B8, 0x95A9, 0xE9B6, 0x0000, 0x0000, 0xE9B9, 0xE9BA,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE9BB,
    0xE9BC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE9BD, 0x0000, 0x968E, 0x8E4C, 0x0000, 0x8DF8, 0x914E, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xE9BE, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE9C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE9BF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE9C2, 0x0000,
    0x0000, 0x8CEF, 0xE9C0, 0x0000, 0x0000, 0x0000, 0x0000, 0xE9C3,
    0x0000, 0xE9C4, 0xE9C5, 0x0000, 0xE9C9, 0x0000, 0x8E49, 0x0000,
    0x0000, 0x0000, 0x0000, 0x91E2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE9CA, 0xE9C7, 0xE9C6, 0xE9C8, 0x0000, 0x0000, 0x0000,
    0x8C7E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE9CE, 0xE9CD, 0xE9CC, 0x0000, 0x0000, 0x88B1, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U9c[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0xE9D8, 0x0000, 0xE9D4, 0x0000,
    0xE9D5, 0xE9D1, 0xE9D7, 0x0000, 0xE9D3, 0x8A82, 0x0000, 0x0000,
    0x986B, 0x0000, 0xE9D6, 0xE9D2, 0xE9D0, 0xE9CF, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE9DA, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE9DD, 0x0000, 0x0000, 0xE9DC, 0xE9DB, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9568, 0xE9D9, 0x88F1,
    0xE9DE, 0x0000, 0xE9E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x8A8F, 0xE9CB, 0x8956, 0x0000, 0x0000, 0xE9E2, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE9E1, 0xE9DF,
    0x924C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x9690, 0x0000, 0x0000, 0x0000, 0x0000, 0x97D8,
    0x0000, 0x0000, 0xE9E3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xE9E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE9E5,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xE9E6, 0x0000,
    0xE9E7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x92B9, 0x0000, 0xE9E8,
    0x0000, 0x94B5, 0x0000, 0xE9ED, 0xE9E9, 0x0000, 0x0000, 0x0000,
    0xE9EA, 0x0000, 0x0000, 0x9650, 0x96C2, 0x0000, 0x93CE, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 U9d[0x100] =
{
    0x0000, 0x0000, 0x0000, 0xE9EE, 0x0000, 0x0000, 0xE9EF, 0x93BC,
    0xE9EC, 0xE9EB, 0x0000, 0x0000, 0x0000, 0x0000, 0x89A8, 0x0000,
    0x0000, 0x0000, 0xE9F7, 0x0000, 0x0000, 0xE9F6, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8995, 0x0000, 0x0000, 0x0000, 0xE9F4,
    0x0000, 0x0000, 0x0000, 0xE9F3, 0x0000, 0x0000, 0xE9F1, 0x0000,
    0x8A9B, 0x0000, 0xE9F0, 0x8EB0, 0x89A7, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8D83, 0x0000, 0x0000, 0xE9FA, 0xE9F9,
    0x0000, 0xE9F8, 0x0000, 0x0000, 0xE9F5, 0x0000, 0xE9FB, 0x0000,
    0xE9FC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xEA44, 0xEA43, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xEA45, 0x0000, 0x0000, 0x894C, 0xEA40, 0xEA41, 0x0000,
    0x8D94, 0x96B7, 0x0000, 0x0000, 0xEA42, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x9651, 0x0000, 0x0000, 0xEA4A,
    0x0000, 0x0000, 0xEA46, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xEA4B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xEA48,
    0x0000, 0xEA47, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8C7B,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xEA4C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xEA4D, 0x0000, 0x0000, 0x0000,
    0x0000, 0xEA4E, 0x0000, 0xEA49, 0x0000, 0x0000, 0x0000, 0xE9F2,
    0x0000, 0x0000, 0xEA4F, 0x0000, 0x92DF, 0x0000, 0x0000, 0x0000,
    0xEA53, 0x0000, 0xEA54, 0xEA52, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xEA51, 0xEA57, 0x0000, 0xEA50, 0x0000, 0xEA55, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xEA56,
    0x0000, 0x0000, 0x0000, 0xEA59, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xEA58, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xEA5B, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xEA5C, 0x0000, 0xEA5D,
    0x0000, 0x0000, 0x9868, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xEA5A, 0x91E9, 0x8DEB, 0x0000, 0x0000, 0xEA5E, 0x0000, 0x0000,
};

static const u16 U9e[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xEA5F, 0xEA60, 0x0000, 0x0000, 0xEA61, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xEA62, 0x0000, 0x0000,
    0x8CB2, 0xEA63, 0x0000, 0x0000, 0x0000, 0xEA64, 0x0000, 0x8EAD,
    0x0000, 0xEA65, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xEA66, 0x0000, 0x0000, 0xEA67, 0xEA68, 0x0000, 0x0000, 0x0000,
    0x0000, 0xEA6B, 0xEA69, 0x985B, 0x0000, 0xEA6A, 0x0000, 0x97ED,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xEA6C, 0x0000, 0x97D9,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xEA6D, 0x949E, 0x0000,
    0x0000, 0xEA6E, 0xEA70, 0x0000, 0x0000, 0xEA71, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xEA6F, 0x8D8D, 0x96CB, 0x9683, 0x9BF5, 0x0000, 0x9F80, 0x969B,
    0x0000, 0x0000, 0x0000, 0x0000, 0x89A9, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xEA73, 0x8B6F, 0xEA74, 0xEA75,
    0xEA76, 0x0000, 0x8D95, 0x0000, 0xEA77, 0x0000, 0x0000, 0x0000,
    0xE0D2, 0x96D9, 0x0000, 0x91E1, 0xEA78, 0xEA7A, 0xEA79, 0x0000,
    0xEA7B, 0x0000, 0x0000, 0x0000, 0x0000, 0xEA7C, 0x0000, 0x0000,
    0xEA7D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xEA7E,
    0x0000, 0x0000, 0x0000, 0x0000, 0xEA80, 0x0000, 0xEA81, 0xEA82,
    0x0000, 0xEA83, 0x0000, 0xEA84, 0xEA85, 0xEA86, 0x0000, 0x0000,
};

static const u16 U9f[0x100] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xEA87,
    0xEA88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9343, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8CDB, 0x0000, 0xEA8A, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x916C, 0xEA8B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xEA8C, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x9540, 0x0000, 0x0000, 0xEA8D, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xEA8E, 0xE256, 0x0000, 0x0000, 0xE6D8, 0xE8EB,
    0x0000, 0x0000, 0xEA8F, 0x0000, 0xEA90, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xEA92,
    0xEA93, 0xEA94, 0x97EE, 0xEA91, 0x0000, 0x0000, 0xEA95, 0xEA96,
    0x0000, 0x0000, 0xEA98, 0x0000, 0xEA97, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xEA9A, 0x0000, 0x0000, 0x0000, 0xEA9B, 0xEA99,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x97B4, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xEA9C, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0xEA9D, 0xE273, 0x0000, 0x0000,
    0xEA9E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 Uff[0x100] =
{
    0x0000, 0x8149, 0x0000, 0x8194, 0x8190, 0x8193, 0x8195, 0x0000,
    0x8169, 0x816A, 0x8196, 0x817B, 0x8143, 0x0000, 0x8144, 0x815E,
    0x824F, 0x8250, 0x8251, 0x8252, 0x8253, 0x8254, 0x8255, 0x8256,
    0x8257, 0x8258, 0x8146, 0x8147, 0x8183, 0x8181, 0x8184, 0x8148,
    0x8197, 0x8260, 0x8261, 0x8262, 0x8263, 0x8264, 0x8265, 0x8266,
    0x8267, 0x8268, 0x8269, 0x826A, 0x826B, 0x826C, 0x826D, 0x826E,
    0x826F, 0x8270, 0x8271, 0x8272, 0x8273, 0x8274, 0x8275, 0x8276,
    0x8277, 0x8278, 0x8279, 0x816D, 0x0000, 0x816E, 0x814F, 0x8151,
    0x814D, 0x8281, 0x8282, 0x8283, 0x8284, 0x8285, 0x8286, 0x8287,
    0x8288, 0x8289, 0x828A, 0x828B, 0x828C, 0x828D, 0x828E, 0x828F,
    0x8290, 0x8291, 0x8292, 0x8293, 0x8294, 0x8295, 0x8296, 0x8297,
    0x8298, 0x8299, 0x829A, 0x816F, 0x8162, 0x8170, 0x8160, 0x0000,
    0x0000, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8150, 0x0000, 0x818F, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

static const u16 *UtoS_convert_table[0x100] =
{
    U00, ERR, ERR, U03, U04, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    U20, U21, U22, U23, ERR, U25, U26, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    U30, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, U4e, U4f,
    U50, U51, U52, U53, U54, U55, U56, U57, U58, U59, U5a, U5b, U5c, U5d, U5e, U5f,
    U60, U61, U62, U63, U64, U65, U66, U67, U68, U69, U6a, U6b, U6c, U6d, U6e, U6f,
    U70, U71, U72, U73, U74, U75, U76, U77, U78, U79, U7a, U7b, U7c, U7d, U7e, U7f,
    U80, U81, U82, U83, U84, U85, U86, U87, U88, U89, U8a, U8b, U8c, U8d, U8e, U8f,
    U90, U91, U92, U93, U94, U95, U96, U97, U98, U99, U9a, U9b, U9c, U9d, U9e, U9f,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR,
    ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, Uff,
};

#define issjis1(c)	(((c) >= 0x81 && (c) <= 0x9f) | ((c) >= 0xe0 && (c) <= 0xfc))
#define issjis2(c)	((c) >= 0x40 && (c) <= 0xfc && (c) != 0x7f)

/*---------------------------------------------------------------------------
  Shift_JISの一文字をUTF-16に変換する
    sjis: Shift_JIS
    return: UTF-16
---------------------------------------------------------------------------*/
u16 sjis_utf16(u16 sjis)
{
	const u16 *table;

	if ((table = StoU_convert_table[sjis >> 8]) != ERR)
		return table[sjis & 0xff];

	return 0;
}

/*---------------------------------------------------------------------------
  Shift_JIS文字列をUTF-8Nに変換する
    sjis: Shift_JIS文字列へのポインタ
    utf: UTF-8N文字列へのポインタ
    return: 変換した文字数
---------------------------------------------------------------------------*/
u32 sjis_to_utf8(void *utf, const void *sjis)
{
  u16 unicode;
  const u8 *src = (const u8 *)sjis;
  u8 *dst = (u8 *)utf;
  u32 i = 0;

  while(*src)
  {
    if(issjis1(*src) && issjis2(*(src + 1)))
    {
      unicode = sjis_utf16((*src << 8) | *(src + 1));
      src += 2;
    }
    else
    {
      unicode = sjis_utf16(*src);
      src++;
    }

    if(unicode < 0x80)
    {
      *dst++ = unicode;
    }
    else if(unicode < 0x800)
    {
      *dst++ = 0xc0 | ((unicode >> 6) & 0x3f);
      *dst++ = 0x80 | (unicode & 0x3f);
    }
    else
    {
      *dst++ = 0xe0 | ((unicode >> 12) & 0x0f);
      *dst++ = 0x80 | ((unicode >> 6) & 0x3f);
      *dst++ = 0x80 | (unicode & 0x3f);
    }
    i++;
  }

  *dst = '\0';

  return i;
}

/*---------------------------------------------------------------------------
  Shift_JIS文字列をUTF-16に変換する
    sjis: Shift_JIS文字列へのポインタ
    utf16: UTF-16文字列へのポインタ
    return: 変換した文字数
---------------------------------------------------------------------------*/
u32 sjis_to_utf16(void *utf16, const void *sjis)
{
  u16 unicode;
  const u8 *src = (const u8 *)sjis;
  u16 *dst = (u16 *)utf16;
  u32 i = 0;

  while (*src)
  {
    if(issjis1(*src) && issjis2(*(src + 1)))
    {
      unicode = sjis_utf16((*src << 8) | *(src + 1));
      src += 2;
    }
    else
    {
      unicode = sjis_utf16(*src);
      src++;
    }

    dst[i++] = unicode;
  }

  dst[i] = 0;

  return i;
}

/*---------------------------------------------------------------------------
  UTF-16の一文字をShift_JISに変換する
    utf16: UTF-16
    return: Shift_JIS
---------------------------------------------------------------------------*/
u16 utf16_sjis(u16 utf16)
{
    const u16 *table;

    if ((table = UtoS_convert_table[utf16 >> 8]) != ERR)
        return table[utf16 & 0xff];

    return 0;
}

/*---------------------------------------------------------------------------
  UTF-16文字列をShift_JISに変換する
    sjis: Shift_JIS文字列へのポインタ
    utf16: UTF-16文字列へのポインタ
    return: 変換した文字数
---------------------------------------------------------------------------*/
u32 utf16_to_sjis(void *sjis, const void *utf16)
{
  u16 shift_jis;
  const u16 *src = (const u16 *)utf16;
  u8 *dst = (u8 *)sjis;
  u32 i = 0;

  while (*src)
  {
    shift_jis = utf16_sjis(*src);
    if(shift_jis < 0x100)
    {
      *dst = shift_jis;
      dst++;
    }
    else
    {
      *dst = shift_jis >> 8;
      dst++;
      *dst = shift_jis & 0xff;
      dst++;
    }
    i++;
    src++;
  }

  *dst = 0;

  return i;
}
