﻿using System;
using System.Windows.Forms;
using System.IO;

namespace Jasmine
{
	public partial class ServerConfigInterface : Form
	{
		public ServerConfigInterface()
		{
			InitializeComponent();
		}

		public String KeyFile { get; set; }

		private void ServerConfigInterface_Load(object sender, EventArgs e)
		{
			Jasmine.Setting.Servercfg sconfig = new Jasmine.Setting.Servercfg();
			IsOnlyMemberChk.Checked = sconfig.IsOnlyMember;
			if (!String.IsNullOrEmpty(sconfig.KeyPath) && File.Exists(sconfig.KeyPath))
			{
				KeyFile = sconfig.KeyPath;
				EnabledRSA.Checked = true;
			}
			else
			{
				KeyFile = String.Empty;
				EnabledRSA.Checked = false;
			}
			ReceivingSize.Value = sconfig.RecSize;
		}

		private void EnabledRSA_CheckedChanged(object sender, EventArgs e)
		{
			CheckBox cb = (CheckBox)sender;
			if (cb.Checked)
			{
				if (!String.IsNullOrEmpty(KeyFile))
				{
					KeyPath.SetToolTip(cb, KeyFile);
				}
				else
				{
					OpenFileDialog ofd = new OpenFileDialog();
					ofd.Filter = "RSA鍵ファイル(*.rsa)|*.rsa";
					if (ofd.ShowDialog() == DialogResult.OK)
					{
						KeyFile = ofd.FileName;
						KeyPath.SetToolTip(cb, KeyFile);
					}
					else
					{
						cb.Checked = false;
					}
				}
			}
			else
			{
				KeyFile = String.Empty;
				KeyPath.RemoveAll();
			}
		}
	}
}