#include "rtfeditor.h"
RtfEditor::RtfEditor(QWidget *parent):QWidget(parent){
    this->toolbar	=new QToolBar(this);
    this->editor	=new QTextEdit(this);
    this->layout	=new QVBoxLayout(this);
    this->layout->addWidget(this->toolbar);
    this->layout->addWidget(this->editor);

    this->defaltTextColor=this->editor->textColor();
    this->bold	=this->toolbar->addAction(QIcon(":/rtfeditor/bold"),"Bold");
    this->italic=this->toolbar->addAction(QIcon(":/rtfeditor/italic"),"Italic");
    this->color	=this->toolbar->addAction(QIcon(":/rtfeditor/color"),"Color");
    this->link	=this->toolbar->addAction(QIcon(":/rtfeditor/link"),"Link");

    connect(this->bold,		SIGNAL(triggered(bool)),			SLOT(makeBold(bool)));
    connect(this->italic,	SIGNAL(triggered(bool)),			SLOT(makeItalic(bool)));
    connect(this->link,		SIGNAL(triggered(bool)),			SLOT(makeLink(bool)));
    connect(this->color,	SIGNAL(triggered(bool)),			SLOT(makeColor(bool)));
    connect(this->editor,	SIGNAL(cursorPositionChanged()),	SLOT(selectionChnged()));

    this->bold->setCheckable(true);
    this->italic->setCheckable(true);
    this->link->setCheckable(true);
    this->color->setCheckable(true);
#ifdef DEBUG
    qDebug()<<"Rtf editor has initialized. When you press any key(s), keysym will be output to stdout.";
#endif
}
void RtfEditor::selectionChnged(){
    this->bold->setChecked(this->editor->currentFont().bold());
    this->italic->setChecked(this->editor->currentFont().italic());
    this->link->setChecked(this->editor->currentCharFormat().isAnchor());
    if(!this->editor->currentCharFormat().isAnchor())
        this->color->setChecked(this->editor->textColor()!=this->defaltTextColor);
    else
        this->color->setChecked(this->editor->currentCharFormat().foreground().color()!=this->colorset.color(QPalette::Link));
}
void RtfEditor::makeStyle(const style s,bool on){
    QFont font=this->editor->currentFont();
    switch(s){
    case RtfEditor::Bold:
        font.setBold(on);
        break;
    case RtfEditor::Italic:
        font.setItalic(on);
        break;
    default:return;
    }
    this->editor->setCurrentFont(font);
}
void RtfEditor::makeBold(bool checked){this->makeStyle(RtfEditor::Bold,checked);}
void RtfEditor::makeItalic(bool checked){this->makeStyle(RtfEditor::Italic,checked);}
void RtfEditor::makeColor(bool checked){
    if(checked){
        QColorDialog dialog(this);
        connect(&dialog,SIGNAL(colorSelected(const QColor &)),this->editor,SLOT(setTextColor(const QColor &)));
        connect(&dialog,SIGNAL(rejected()),SLOT(selectionChnged()));
        dialog.exec();
        if(this->editor->currentCharFormat().isAnchor()) this->selectionChnged();
    }else{
        QTextCharFormat format=this->editor->currentCharFormat();
        if(format.isAnchor())
            format.setForeground(QBrush(this->colorset.color(QPalette::Link)));
        else format.clearForeground();
        this->editor->setCurrentCharFormat(format);
    }
}
void RtfEditor::makeLink(bool checked){
    if(checked){
        QInputDialog dialog(this);
        dialog.setWindowTitle("Link to");
        dialog.setLabelText("Link to:");
        dialog.setTextValue("http://");
        connect(&dialog,SIGNAL(textValueSelected(const QString &)),SLOT(setLink(const QString &)));
        connect(&dialog,SIGNAL(rejected()),SLOT(selectionChnged()));
        dialog.exec();
    }else{
        QTextCharFormat format=this->editor->currentCharFormat();
        format.setAnchor(false);
        format.setFontUnderline(false);
        if(format.foreground().color()==colorset.color(QPalette::Link)) format.clearForeground();
        this->editor->setCurrentCharFormat(format);
    }
}
void RtfEditor::setLink(const QString &link){
    QUrl link_url(link);
    if(link.isEmpty()){
        this->selectionChnged();
        return;
    }
    if(link_url.scheme().isEmpty()||!link_url.isValid()){
        this->selectionChnged();
        emit invalidLink(link);
        return;
    }
    QTextCharFormat format=this->editor->currentCharFormat();
    format.setAnchorHref(link);
    format.setAnchor(true);
    format.setFontUnderline(true);
    if(format.foreground().color()==this->defaltTextColor)
        format.setForeground(QBrush(colorset.color(QPalette::Link)));
    this->editor->setCurrentCharFormat(format);
}
QString RtfEditor::html() const{return this->editor->toHtml();}
QString RtfEditor::plain() const{return this->editor->toPlainText();}
void RtfEditor::plain(const QString &str){this->editor->setPlainText(str);}
void RtfEditor::html(const QString &str){this->editor->setPlainText(str);}
void RtfEditor::focusInEvent(QFocusEvent *event){
    this->editor->setFocus();
    event->accept();
}
void RtfEditor::keyPressEvent(QKeyEvent *event){
#ifdef DEBUG
    qDebug()<<hex<<event->modifiers()<<":"<<event->key();
#endif
    if(event->modifiers()==Qt::ControlModifier&&(event->key()==Qt::Key_Enter||event->key()==Qt::Key_Return)) emit this->sendTriggered();
    event->accept();
}
