#pragma once
#include <QtNetwork>
#include "../file/QtLockedFile"
#include "../definition.h"
#include "../structures/header.h"
#include "../definition.h"
#include "../ported_rmd6/rmd6.h"

const quint64 default_bandwidth = 0x400;
using namespace structures;
namespace network{
    class tcpSocket;
    class threadedTcpSocket;

    class tcpServer:virtual public QTcpServer{
        Q_OBJECT
    public:
        tcpServer(quint64 buffersize=default_bandwidth,QObject *parent=NULL);
    signals:
        bool pending(threadedTcpSocket &) const;
        void socket_error(const threadedTcpSocket &) const;
    protected:
        void incomingConnection(int handle);
    private:
        quint64 buffersize;
    };

    class threadedTcpSocket:public QThread{
        Q_OBJECT
    public:
        //This constructor is for server. it works as a session.
        threadedTcpSocket(const quint64 buffersize=default_bandwidth,QObject *parent=NULL);
        //This constructor is for client. it works as a client.
        threadedTcpSocket(const AddressAndPort &,const QString &senderName,const quint64 buffersize=default_buffer_size,QObject *parent=NULL);
        /*
            To access these member, accessing critical sections must be needed.
            Hence, these member uses QReadWriteLock to lock them; Making constant functions is not possible.
         */
        quint64 buffersize();
        QString senderName();
        AddressAndPort peerAddr();
        header head_data();
        int socketDescriptor();
        void socketDescriptor(const int);
        void buffersize(const quint64);
        void senderName(const QString &);
        void readWriteMode(const QIODevice::OpenMode);
        void to(const AddressAndPort &);
        QIODevice::OpenMode readWriteMode();
        QString errorString();
        threadedTcpSocket &operator<<(const QString &);
        threadedTcpSocket &operator<<(const QFileInfo &);
    private:
        enum Mode{Session,Client} mode;
        enum lockID{
            Mode        =0,
            BufferSize  =1,
            SenderName  =2,
            Msg         =3,
            File        =4,
            Descriptor  =5,
            RWMode      =6,
            Error       =7,
            AddrAndPort =8,
            HeaderData  =9
        };
        void run();
        QIODevice::OpenMode open_mode;
        QReadWriteLock locks[10];
        int _descriptor;
        quint64 _buffersize;
        QString _senderName,_msg,_error;
        QFileInfo _file;
        AddressAndPort _addrPort;
        header _header;
    private slots:
        void header_received();
        void error_occured(const QAbstractSocket::SocketError);
        void host_connected();
        void host_disconnected();
    signals:
        QString file_pending() const;
        QString fileStream_openFailed(const QFile::FileError &,const QString &) const;

        void msg_received(const QString &) const;

        void file_receive_progress(const quint64 streamPos) const;
        void file_saved() const;

        void sentData();
        void file_header_sent();
        void sending_file_progress(const quint64 pos);

        void connected();
        void disconnected();
        void error(const QAbstractSocket::SocketError);
        void hostFound();
        void proxyAuthenticationRequired(const QNetworkProxy &,QAuthenticator *);
        void stateChanged(QAbstractSocket::SocketState);
    };

    class tcpSocket:public QTcpSocket{
        Q_OBJECT
    public:
        //This constructor is for server. it works as a session.
        tcpSocket(const quint64 buffersize=default_bandwidth,QObject *parent=NULL);
        //This constructor is for client. it works as a client.
        tcpSocket(const QString &senderName,const quint64 buffersize=default_buffer_size,QObject *parent=NULL);
        QString path_to_save() const;
        structures::header header_data() const;

        tcpSocket &operator<<(const QString &),
                  &operator<<(const QFileInfo &);
    signals:
        QString file_pending() const;
        QString fileStream_openFailed(const QFile::FileError &,const QString &) const;

        void header_received() const;
        void msg_received(const QString &) const;

        void file_receive_progress(const quint64 streamPos) const;
        void file_saved() const;

        void sentData() const;
        void file_header_sent() const;
        void sending_file_progress(const quint64 pos) const;
    protected:
        void disconnectFromHostImplementation();
    private:
        enum section {
            Size,
            Header,
            Msg,
            File,
            End
        } event;

        enum Flag {accepted=0,refused=1};
        void size_event();
        void header_event();
        void msg_event();
        void file_event();
        bool check_canceled_then_abort();

        void client_move_section();
        bool client_process_event();
        bool client_flush();
        bool client_send_size();
        bool client_send_header();
        bool client_send_msg();
        bool client_send_file();

        //The size of header needs to be larger than 0, and smaller than or equal to 0xFFFF.
        quint16 header_size,buffer_size,timeout_time;
        structures::header head_data;
        bool canceled;
        QString where_to_save, senderName;
        //These classes are only used for client to store serialized header data.
        QByteArray tmp_buffer,msg;
        QFileInfo src_file;
    private slots:
        void read_data();
        void move_next_section(const qint64);
        void send_flag(const Flag flag);
        void cancel();

        void client_receive_flag();
    };
}
