#pragma once
#include "ui_jasmine_main.h"
#include "memberlist.h"
#include "settingdialog.h"
#include "rtfeditor.h"
#include "../settings.h"
#include "../validator/ipaddressvalidator.h"
#include "../network/tcpnetwork.h"

using namespace structures;
using namespace network;

class mainWindow:public QMainWindow,private Ui::MainWindow{
    Q_OBJECT
public:
    mainWindow();
    ~mainWindow();
private slots:
    //These functions work automatically by automatic connection.
    void on_sendButton_clicked();
    void on_runServerAction_triggered(bool);
    void on_serverSettingAction_triggered();
    void on_clientSettingAction_triggered();
    void on_miscAction_triggered();
    void on_sendFileAction_triggered();
    void on_aboutAction_triggered();
    void on_openMemberListAction_triggered();
    void on_saveLogAction_triggered();
    void on_saveMemberListAction_triggered();
    void on_actionExit_triggered();
    void on_clearAction_triggered();
    void on_addButton_clicked();
    void on_removeButton_clicked();
    void on_saveConfigAction_triggered();
    void on_openConfigAction_triggered();
    //This function works manually.
    void settingDialog_accepted();
    //These are for saving stuff.
    void saveConfig(const QString &);
    void saveMember(const QString &);
    void saveLog(const QString &);
    //This is for links.
    void linkClicked(const QUrl &);
    //These slots are for receiveText.
    void invalidLink(const QString &);
    void selectedLink(const QUrl &);
    //These functions are for tcpclient.
    void tcpclient_error(const QAbstractSocket::SocketError &error);
    void sentData();
    //These functions are for tcpserver.
    bool tcpserver_pending(threadedTcpSocket &);
    void tcpserver_msg_received(const QString &);
    void tcpserver_error(const QAbstractSocket::SocketError &);
public slots:
    //These are for opening stuff.
    void openConfig(const QString &);
    void openMember(const QString &);
protected:
    //Events
    void closeEvent(QCloseEvent *);
    void showEvent(QShowEvent *);
private:
    QObject			*beforesender;
    QStringList		memberFilters,logFilters;

    MemberList		*memberList;
    RtfEditor		*sendTextEditor;
    tcpServer		*mainServer;
    SettingDialog	*settingdialog;
    settings		setting;

    bool isInMember(const AddressAndPort &,bool matchIPOnly);
    void configAndShowSettingDialog(const SettingDialog::tab);
public:
    settings app_setting() const;
};

