#include "tcpclient.h"
#include "../structures/header.h"
using namespace network;
using namespace structures;
tcpClient::tcpClient(quint64 buffersize,const QString &senderName,QObject *parent):QTcpSocket(parent){
	this->buffer_size=buffersize;
	this->senderName=&senderName;
	this->timeout_time=TIMEOUT;
	this->want_disconnect=false;
	connect(this,SIGNAL(readyRead()),SLOT(data_available()));
}
quint64 tcpClient::timeout()const {return this->timeout_time;}
void tcpClient::timeout(const quint64 time){this->timeout_time=time;}
tcpClient &tcpClient::operator<<(const QString &msg){
	if(!this->check_connection_and_wait_connected())return (*this);
	header head_data(*(this->senderName),msg);
	QByteArray head_buffer;
	QDataStream datastream(head_buffer);
	datastream<<head_data;
	quint16 size=(quint16)head_buffer.size();
	this->write((char*)&size,sizeof(__typeof__(size))/sizeof(char));
	if(!this->check_byte_written_and_wait_written())return (*this);
	this->write(head_buffer);
	if(!this->check_byte_written_and_wait_written())return (*this);
	QByteArray array=msg.toUtf8();
	QBuffer memoryStream(&array,this);
	while(this->write(memoryStream.read(this->buffer_size))>0);
	if(this->check_byte_written_and_wait_written())return (*this);
	emit this->sentData();
	return (*this);
}
tcpClient &tcpClient::operator<<(QFile &file){
	if(!this->check_connection_and_wait_connected()){return (*this);}
	header head_data(*(this->senderName),QFileInfo(file));
	QByteArray head_buffer;
	QDataStream datastream(head_buffer);
	quint16 size=(quint16)head_buffer.size();
	datastream<<head_data;
	this->write((char*)&size,sizeof(__typeof__(size))/sizeof(char));
	if(!this->check_byte_written_and_wait_written())return (*this);
	this->write(head_buffer);
	if(!this->check_byte_written_and_wait_written())return (*this);
	while(this->write(file.read(this->buffer_size))>0);
	if(!this->check_byte_written_and_wait_written())return (*this);
	emit this->sentData();
	return (*this);
}
bool tcpClient::check_byte_written_and_wait_written(){
	if(this->want_disconnect) return false;
	if(!this->waitForBytesWritten(this->timeout_time)){
		this->setErrorString(tr("The data couldn't be written."));
		emit this->error(QAbstractSocket::UnknownSocketError);
		return false;
	}
	return true;
}

bool tcpClient::check_connection_and_wait_connected(){
	if(this->want_disconnect) return false;
	if(this->state()!=QAbstractSocket::ConnectingState||this->state()!=QAbstractSocket::ConnectedState){
		this->setErrorString(tr("This socket haven't connected to somewhere yet."));
		emit this->error(QAbstractSocket::SocketAccessError);
		return false;
	}
	if(!this->waitForConnected(this->timeout_time)){
		this->setErrorString(tr("Connection time out"));
		emit this->error(QAbstractSocket::SocketTimeoutError);
		return false;
	}
	return true;
}
bool tcpClient::check_and_wait_byte_available(){
	if(this->want_disconnect) return false;
	if(!this->waitForReadyRead(this->timeout_time)){
		this->setErrorString(tr("The data couldn't be read."));
		emit this->error(QAbstractSocket::UnknownSocketError);
		return false;
	}
	return true;
}
void tcpClient::disconnectFromHostImplementation(){
	this->want_disconnect=true;
	QTcpSocket::disconnectFromHost();
}

void tcpClient::data_available(){
	this->check_and_wait_byte_available();
	QByteArray receive_data=this->read(1);
	switch(receive_data[0]){
	case 0x00:
		this->disconnectFromHost();
		break;
	default:
		return;
	}
}
