#include "editdelegate.h"
#include "memberlist.h"

MemberList::MemberList(QWidget *parent):QTableWidget(parent){
	this->verticalHeader()->setVisible(false);
	this->verticalHeader()->setDefaultSectionSize(15);
	this->verticalHeader()->setDefaultSectionSize(15);
	this->setColumnCount(2);
	QStringList labels;
	labels<<tr("Name")<<tr("IPAddress");
	this->setHorizontalHeaderLabels(labels);
	this->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
	this->horizontalHeader()->setVisible(true);
	this->setItemDelegateForColumn(1,new MemberListEditDelegate(this));
}
void MemberList::remove_selected(){
	while(this->selectedItems().size()>0&&this->selectedRanges()[0].rowCount()>0)
		this->removeRow(this->selectedRanges()[0].topRow());
}
void MemberList::remove_all_contents(){while(this->rowCount()>0) this->removeRow(0);}
void MemberList::keyReleaseEvent(QKeyEvent *event){
	if(event->matches(QKeySequence::Delete)){
		remove_selected();
		event->ignore();
	}else event->accept();
}
