#include "tcpnetwork.h"
#include <cstring>
#include "../structures/header.h"

using namespace network;
using namespace enc_hash;
using namespace structures;
using namespace std;

//Tcp server implementation
tcpServer::tcpServer(quint64 buffersize, QObject *parent):QTcpServer(parent){this->buffersize=buffersize;}

void tcpServer::incomingConnection(int handle){
    threadedTcpSocket *socket=new threadedTcpSocket(this->buffersize,this);
    socket->socketDescriptor(handle);
    if(! emit this->pending(*socket)){
        socket->exit(1);
        return;
    }
    socket->start();
    emit this->newConnection();
}

//Tcp socket implementation
tcpSocket::tcpSocket(const quint64 buffersize, QObject *parent):QTcpSocket(parent){
    this->buffer_size=buffersize;
    this->canceled=false;
    this->event=tcpSocket::Size;
    connect(this,SIGNAL(readyRead()),SLOT(read_data()));
    connect(this,SIGNAL(bytesWritten(qint64)),SLOT(move_next_section(const qint64)));
#ifdef DEBUG
    qDebug()<<"Server:tcpSocket is constructed.";
    qDebug()<<"Server:blocked:"<<this->signalsBlocked();
#endif
}
void tcpSocket::read_data(){
    /*TODO: remove this loop*/
        while(this->bytesAvailable()>=0){
#ifdef DEBUG
          qDebug()<<"Server:server Event Mode:"<<this->event;
          qDebug()<<"Server:server Available bytes:"<<this->bytesAvailable();
#endif
            switch(this->event){
            case tcpSocket::Size:            this->size_event();		break;
            case tcpSocket::Header:          this->header_event();		break;
            case tcpSocket::Msg:             this->msg_event();         break;
            case tcpSocket::File:            this->file_event();        break;
            default: this->disconnectFromHost(); return;
            }
        }
}
void tcpSocket::move_next_section(const qint64 size){
    Q_UNUSED(size);
    switch(this->event){
    case tcpSocket::Size: this->event=tcpSocket::Header; break;
    case tcpSocket::Header:
        this->event=(this->head_data.fileName().isEmpty()?tcpSocket::Msg:tcpSocket::File);
        break;
    default:
        this->event=tcpSocket::End;
        break;
    }
}
void tcpSocket::send_flag(const Flag flag){
    QByteArray send_data;
    send_data.append((int)flag);
    this->write(send_data);
    if(!this->flush()){
        this->setErrorString(tr("Accept signal couldn't be sent."));
        emit this->error(QAbstractSocket::UnknownSocketError);
        return;
    }
#ifdef DEBUG
    qDebug()<<"Server:the flag:"<<flag<<" has been sent.";
#endif
}

void tcpSocket::size_event(){
    if(this->bytesAvailable()<2) return;
    char size_buf[2];
    this->read(size_buf,sizeof(size_buf));
    memcpy(&this->header_size,size_buf,
           (sizeof(quint16)>sizeof(size_buf))?sizeof(quint16):sizeof(size_buf)
           );
    //this->send_flag(tcpSocket::accepted);
    this->move_next_section(0);
}
void tcpSocket::header_event(){
    if(this->bytesAvailable()<this->header_size) return;
    else{
        QByteArray data=this->read(this->header_size);
        QDataStream datastream(data);
        datastream>>this->head_data;
        if(this->head_data==structures::header()){
            this->setErrorString(tr("The header is empty."));
            emit this->error(QAbstractSocket::UnknownSocketError);
            this->disconnectFromHost();
            return;
        }
        if(!this->head_data.fileName().isEmpty()){
            this->where_to_save=(emit this->file_pending());
            if(this->where_to_save.isEmpty()){
                this->write(QByteArray(1,0x00));

                this->setErrorString(tr("The filename is empty."));
                emit this->error(QAbstractSocket::UnknownSocketError);

                this->disconnectFromHost();
                return;
            }
        }
        emit this->header_received();
    }
    //this->send_flag(tcpSocket::accepted);
    this->move_next_section(0);
}
void tcpSocket::msg_event(){
    if((quint64)this->bytesAvailable()<this->header_data().datasize()) return;
    quint64 final_readsize=this->head_data.datasize()%this->buffer_size,
    read_count=(this->head_data.datasize()-final_readsize)/this->buffer_size;
    QByteArray msg;
    for(quint64 count=0;count<read_count;count++){
        if(this->check_canceled_then_abort())return;
        msg+=this->read(this->buffer_size);
    }
    if(this->check_canceled_then_abort())return;
    msg+=this->read(final_readsize);

    rmd6 generator;
    if(this->head_data.ripemd160()==generator.compute_hash(msg)){
        emit this->msg_received(QString::fromUtf8(msg.data()));
    }
    else{
#ifdef DEBUG
        qDebug()<<"Hash digest error. the received message may be broken or modified.";
        qDebug()<<"this->head_date.ripemd160():"<<this->head_data.ripemd160();
        qDebug()<<"RIPEMD160-Hash"<<generator.compute_hash(msg);
#endif
        this->setErrorString(tr("The data has been broken."));
        emit this->error(QAbstractSocket::UnknownSocketError);
    }
    //this->send_flag(tcpSocket::accepted);
    this->move_next_section(0);
}
void tcpSocket::file_event(){
    if((quint64)this->bytesAvailable()<this->header_data().datasize()) return;
    quint64 final_readsize=this->head_data.datasize()%this->buffer_size,
    read_count=(this->head_data.datasize()-final_readsize)/this->buffer_size;
    streamopen:
    if(this->where_to_save.isEmpty()){
        this->setErrorString(tr("The filename is empty."));
        emit this->error(QAbstractSocket::UnknownSocketError);
        this->disconnectFromHost();
        return;
    }
    QFile file(this->where_to_save,this);
    if(!file.open(QIODevice::Truncate|QIODevice::WriteOnly)){
        this->where_to_save=emit this->fileStream_openFailed(file.error(),file.errorString());
        goto streamopen;
    }
    for(quint64 count=0;count<read_count&&!this->check_canceled_then_abort();count++){
        if(this->check_canceled_then_abort())return;
        file.write(this->read(this->buffer_size));
        emit this->file_receive_progress(file.pos());
    }
    if(this->check_canceled_then_abort())return;
    file.write(this->read(final_readsize));
    emit this->file_receive_progress(file.pos());
    file.close();

    rmd6 generator;
    if(this->head_data.ripemd160()==generator.compute_hash(file))
        emit this->file_saved();
    else{
        this->setErrorString(tr("The file has been broken."));
        emit this->error(QAbstractSocket::UnknownSocketError);
    }
    //this->send_flag(tcpSocket::accepted);
    this->move_next_section(0);
}
void threadedTcpSocket::header_received(){
    tcpSocket *socket=qobject_cast<tcpSocket *>(this->sender());
    this->locks[threadedTcpSocket::HeaderData].lockForWrite();
        this->_header=socket->header_data();
    this->locks[threadedTcpSocket::HeaderData].unlock();
}

//Threaded TCP socket (for server) implemantation
threadedTcpSocket::threadedTcpSocket(const quint64 buffersize, QObject *parent):QThread(parent){
    connect(this,SIGNAL(finished()),SLOT(deleteLater()));
    connect(this,SIGNAL(terminated()),SLOT(deleteLater()));
    this->locks[threadedTcpSocket::Mode].lockForWrite();
    this->locks[threadedTcpSocket::BufferSize].lockForWrite();
    this->locks[threadedTcpSocket::RWMode].lockForWrite();
        this->mode=threadedTcpSocket::Session;
        this->_buffersize=buffersize;
        this->open_mode=QAbstractSocket::ReadWrite;
    this->locks[threadedTcpSocket::Mode].unlock();
    this->locks[threadedTcpSocket::BufferSize].unlock();
    this->locks[threadedTcpSocket::RWMode].unlock();;
}
