// /home/tarai/Projects/gsaw/CompactMonochromeRasterFactory.cs created with MonoDevelop
// User: tarai at 21:38 2008/05/18
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;


namespace Holo.Image.Generic {
	using Holo.Image;
	
	public class CompactMonochromeRasterFactory : IRasterFactory {
		private byte[] primaryColor;
		private byte[] alpha;
		
		public CompactMonochromeRasterFactory(byte[] primaryColor, byte[] alpha) {
			this.primaryColor = (byte[])primaryColor.Clone();
			this.alpha = (byte[])alpha.Clone();
		}
		
		public IRaster CreateNewRaster(int width, int height) {
			return new ColoredRaster(width, height, primaryColor, alpha);
		}
		
		public IRaster CreateCopyOfRaster(IRaster src) {
			return new MonochromeRaster(src, primaryColor);
		}
	}
}
