// /home/tarai/Projects/gsaw/gsaw/GenericSurface.cs created with MonoDevelop
// User: tarai at 17:43 2008/04/27
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Image.Generic {
	using Holo.Image;
	
	/**
	 * Simple surface implementation:
	 *  Surface has one-to-one mapping to Raster object.
	 * */
	public class GenericSurface : ISurface {
		private IRaster raster;
		private int offsetX;
		private int offsetY;
		private int width;
		private int height;
		private ISurfaceUpdateAreaHandler onUpdateArea;
		private IRasterFactory rasterFactory;
		
		public GenericSurface(int x, int y, int width, int height, bool hasAlpha) {
			Initialize(x, y, width, height, new GenericRasterFactory(hasAlpha));
		}

		public GenericSurface(int x, int y, int width, int height, bool hasAlpha, IRasterFactory factory) {
			Initialize(x, y, width, height, factory);
		}

		protected void Initialize(int x, int y, int width, int height, IRasterFactory factory) {
			raster = null;
			offsetX = x;
			offsetY = y;
			this.width = width;
			this.height = height;
			this.rasterFactory = factory;
		}
				
		public int OffsetX {
			get { return offsetX; }
			set { offsetX = value; }
		}
		
		public int OffsetY {
			get { return offsetY; }
			set { offsetY = value; }
		}
		
		public int Width {
			get { return width; }
		}
		
		public int Height {
			get { return height; }
		}
		
		public int TileWidth {
			get { return width; }
		}
		
		public int TileHeight {
			get { return height; }
		}
		
		public IRasterFactory RasterFactory {
			get { return rasterFactory; }
			set { 
				if (value != null) {
					rasterFactory = value; 
				}
			}
		}
		
		public void MakeRastersReadOnly(int x, int y, int width, int height) {
		}
		
		public void MakeRastersWriteable(int x, int y, int width, int height) {
			MakeRastersReadable(x, y, width, height);
		}
		
		public void MakeRastersReadable(int x, int y, int width, int height) {			
			if (raster == null) {
				raster = rasterFactory.CreateNewRaster(this.width, this.height);
			}
		}
		
		public void FillRasters(int x, int y, int width, int height, byte[] color, byte[] alpha) {
			if (raster == null)
				MakeRastersReadable(x, y, width, height);
			byte[] pixels = null;
			if (raster.HasColorChannels && raster.HasAlpha) {
				pixels = new byte[color.Length + alpha.Length];
				Array.Copy(color, 0, pixels, 0, color.Length);
				Array.Copy(alpha, 0, pixels, color.Length, alpha.Length);
			} else if (raster.HasColorChannels) {
				pixels = color;
			} else if (raster.HasAlpha) {
				pixels = alpha;
			} else {
				return;
			}
			x = Math.Max(x, offsetX) - offsetX;
			y = Math.Max(y, offsetY) - offsetY;
			int maxX = Math.Min(x + width, offsetX + this.width) - offsetX;
			int maxY = Math.Min(y + height, offsetY + this.height) - offsetY;
			for (int i = y; i < maxY; i ++) {
				for (int j = x; j < maxX; j ++) {
					Array.Copy(pixels, 0, raster.Buffer, i * raster.RowStride + j * raster.PixelStride, pixels.Length);
				}
			}
		}
		
		public ISurfaceIterator GetIteratorAt(int x, int y) {
			return new GenericSurfaceIterator(this, x, y);
		}
		
		public void SetRasterAt(ISurfaceIterator iter, IRaster raster) {
			this.raster = raster;
		}

		public void Resize(int width, int height) {
			// TBD
		}
		
		public IRaster Raster {
			get { return raster; }
		}
		
		public ISurfaceUpdateAreaHandler OnUpdateArea {
			get { return onUpdateArea; }
			set { onUpdateArea = value; }
		}
	}
}
