// /home/tarai/Projects/gsaw/gsaw/Raster.cs created with MonoDevelop
// User: tarai at 0:17 2008/04/22
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Image {
	
	
	public interface IRaster {
		int Width { get; }
		int Height { get; }
		int BitsPerPixel { get; }
		int PixelStride { get; }
		int RowStride { get; }
		int NumChannels { get; }
		string Format { get; }
		byte[] Buffer { get; }
		
		/// HasAlpha
		/// HasAlpha indicates wether Raster has alpha channel or not.
		/// If this value is false, Raster has only colored channels.
		/// When HasAlpha is true, Alpha value included in the buffer
		/// data is used as a alpha channel value.
		/// When HasAlpha is false, PrimaryAlphaValue is treated as a
		/// overall alpha channel value if the Raster is used as  
		/// input data of operations.
		bool HasAlpha { get; }
		
		/// HasColorChannels
		/// HasColorChannels indicates wether Raster has color channel or not.
		/// If this value is false, Raster has only alpha channel (or it does 
		/// not have buffer at all.)
		bool HasColorChannels { get; }
		byte[] PrimaryAlphaValue { get; }
		byte[] PrimaryColor { get; }
		
		bool MustBeCopiedOnWrite { get; set; }
	}
}
