// /home/tarai/Projects/gsaw/gsaw/ColoredRaster.cs created with MonoDevelop
// User: tarai at 16:48 2008/04/27
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using Gdk;

namespace Holo.Image.Generic {
	using Holo.Image;
	
	public class ColoredRaster : IRaster {
		private const int DEFAULT_WIDTH = 64;
		private const int DEFAULT_HEIGHT = 64;
		private const int NUM_CHANNELS = 3;
		private const int DEFAULT_BIT_DEPTH = 8;
		
		private int width;
		private int height;
		private int pixelStride;
		private int bitsPerPixel;
		private int numChannels;
		private bool mustBeCopiedOnWrite;
		
		private byte[] primaryColor;
		private byte[] primaryAlpha;

		public ColoredRaster(int width, int height, byte[] color) {
			byte[] alpha = new byte[1];
			alpha[0] = 255;
			Initialize(width, height, color, alpha);
		}
		
		public ColoredRaster(int width, int height, byte[] color, byte[] alpha) {
			Initialize(width, height, color, alpha);
		}
		
		private void Initialize(int width, int height, byte[] color, byte[] alpha) {
			this.width = (width != 0)? width : DEFAULT_WIDTH;
			this.height = (height != 0)? height : DEFAULT_HEIGHT;
			bitsPerPixel = DEFAULT_BIT_DEPTH >> 3;
			numChannels = NUM_CHANNELS;
			pixelStride = bitsPerPixel * numChannels;
			primaryColor = color;
			primaryAlpha = alpha;
			mustBeCopiedOnWrite = false;
		}
		
		public int Width {
			get { return width; }
		}
		public int Height {
			get { return height; }
		}
		
		public int BitsPerPixel {
			get { return bitsPerPixel; }
		}
		
		public int PixelStride {
			get { return pixelStride; }
		}

		public int RowStride {
			get { return 0; }
		}
		
		public string Format {
			get { return (numChannels == NUM_CHANNELS)? "C": "CA"; }
		}
		
		public int NumChannels {
			get { return numChannels; }
		}
		
		public byte[] Buffer {
			get { return null; }
		}
		
		public bool HasAlpha {
			get { return false; }
		}
		
		public bool HasColorChannels { 
			get { return false; } 
		}
		
		public byte[] PrimaryAlphaValue { 
			get {
				return primaryAlpha;
			}
		}
		
		public byte[] PrimaryColor { 
			get {
				return primaryColor;
			}
		}
		
		public bool MustBeCopiedOnWrite {
			get {
				return mustBeCopiedOnWrite;
			}
			set {
				mustBeCopiedOnWrite = value;
			}
		}
	}
}
