// /home/tarai/Projects/gsaw/gsaw/FilterOperation.cs created with MonoDevelop
// User: tarai at 15:47 2008/04/29
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Operation {
	using Holo.Image;
	
	public class FilterOperation {		

		public delegate void FilterOperator(ISurfaceIterator surfIter, ISurfaceIterator maskIter, ISurfaceIterator destIter, int width, int height);
		private FilterOperator opr;
		private double opacity;
		
		public double Opacity {
			get { return opacity; }
			set { opacity = value; }
		}
		
		public FilterOperator Operator {
			get { return opr; }
			set { opr = value; }
		}
		
		public FilterOperation() {
			opacity = 1.0;
		}
		
		public virtual void Apply(ISurface surface, ISurface mask, ISurface dest) {
			int minX = Math.Max(surface.OffsetX, dest.OffsetX);
			int minY = Math.Max(surface.OffsetY, dest.OffsetY);
			int maxX = Math.Min(surface.OffsetX + surface.Width, dest.OffsetX + dest.Width);
			int maxY = Math.Min(surface.OffsetY + surface.Height, dest.OffsetY + dest.Height);
			Apply(surface, mask, minX, minY, maxX, maxY, dest);
		}
		
		public virtual void Apply(ISurface surface, ISurface mask, int minX, int minY, int maxX, int maxY, ISurface dest) {
			int width = maxX - minX;
			int height = maxY - minY;
			surface.MakeRastersReadable(minX, minY, width, height);
			dest.MakeRastersWriteable(minX, minY, width, height);

			ISurfaceIterator surfaceIter = surface.GetIteratorAt(minX, minY);
			ISurfaceIterator destIter    = dest.GetIteratorAt(minX, minY);
			ISurfaceIterator maskIter    = null;
			ISurfaceIterator[] iterators;
			if (mask != null) {
				maskIter = mask.GetIteratorAt(minX, minY);
				ISurfaceIterator[] definition = { surfaceIter, maskIter, destIter };
				iterators = definition;
			} else {
				ISurfaceIterator[] definition = { surfaceIter, destIter };
				iterators = definition;
			}

			MultipleSurfaceIterator mIter;
			mIter = new MultipleSurfaceIterator(iterators, minX, minY, maxX, maxY);

			while (!mIter.IsYEnded()) {
				int h = mIter.HeightOfRaster;
				while (!mIter.IsXEnded()) {
					int w = mIter.WidthOfRaster;
					
					opr(surfaceIter, maskIter, destIter, w, h);
					mIter.AddX(w);
				}
				mIter.ResetXAndAddY(h);
			}
		}
	}
}
