// FloodFillTool.cs created with MonoDevelop
// User: tarai at 18:47 2008/06/08
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Collections;

namespace Lawrence.Tool {
	using Holo.Image;
	using Holo.Image.Generic;
	using Holo.Image.Tiled;
	using Holo.Operation;
	using Holo.Operation.Processor;
	using Lawrence.Common;
	
	public class FloodFillTool : IPaintTool {
		
		private CompositeOperation apply;
		
		private IRasterFactory rasterFactory;
				
		public CompositeOperation Apply {
			get { return apply; }
			set { apply = value; }
		}
				
		public IRasterFactory RasterFactory {
			get { return rasterFactory; }
			set {
				if (value != null)
					rasterFactory = value;
			}
		}
		
		public FloodFillTool() {
			byte[] primaryColor = {0, 255, 0};
			byte[] primaryAlpha = {0};
			rasterFactory = new CompactMonochromeRasterFactory(primaryColor, primaryAlpha);
		}
		
		public void OnStartStroke(PaintContext context, ImageCoordinate initialCoords, int time) {
		}

		
		public void OnUpdateStroke(PaintContext context, ImageCoordinate newCoords, int time) {
		}
		
		
		public void OnFinishStroke(PaintContext context, ImageCoordinate finalCoords, int time) {
			History.GenericUndoInfo undoInfo = null;
			if (context.History != null) {
				undoInfo = new History.GenericUndoInfo(context);
				undoInfo.Attach();

				context.History.Add(undoInfo);
			}
			
			ISurface selection = new TiledSurface(context.ActiveLayer.Surface.OffsetX, context.ActiveLayer.Surface.OffsetY,
			                                        context.ActiveLayer.Surface.Width, context.ActiveLayer.Surface.Height, 
			                                        rasterFactory);
			selection.MakeRastersReadOnly(context.ActiveLayer.Surface.OffsetX, context.ActiveLayer.Surface.OffsetY,
			                              context.ActiveLayer.Surface.Width, context.ActiveLayer.Surface.Height);
			ClosedRegionExtractOperation operation = new ClosedRegionExtractOperation();
			operation.Threshold = 1.0;
			operation.Apply(context.ActiveLayer.Surface, (int)finalCoords.X, (int)finalCoords.Y, selection);
			if (apply != null)
				apply.Apply(context.ActiveLayer.Surface, selection, null, context.ActiveLayer.Surface);
			
			if (undoInfo != null) {
				undoInfo.Dettach();
				undoInfo = null;
			}
		}
		
	}
}
