// /home/tarai/Projects/gsaw/GenericRasterFactory.cs created with MonoDevelop
// User: tarai at 19:41 2008/05/06
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Image.Generic {
	using Holo.Image;
	
	public class GenericRasterFactory : IRasterFactory {
		private bool hasAlpha;
		
		public GenericRasterFactory(bool hasAlpha) {
			this.hasAlpha = hasAlpha;
		}
		
		public IRaster CreateNewRaster(int width, int height) {
			return new GenericRaster(width, height, hasAlpha);
		}
		
		public IRaster CreateCopyOfRaster(IRaster src) {
			return new GenericRaster(src, hasAlpha);
		}
	}
}
