// /home/tarai/Projects/gsaw/gsaw/Image.cs created with MonoDevelop
// User: tarai at 0:08 2008/04/22
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Collections;
using System.Threading;

namespace Holo.Image {
	using Generic;
	using Holo.Operation.Processor;
	
	public class Image {
		public delegate void OnUpdateAreaHandler(int minX, int minY, int maxX, int maxY);

		private ArrayList layers;
		private int width;
		private int height;
		private int activeLayerIndex;
		private OnUpdateAreaHandler onUpdateArea;		

		private GenericSurface projection;
		private JobProcessor processor;

		private class Area {
			public int minX;
			public int minY;
			public int maxX;
			public int maxY;
			public Area(int x1, int y1, int x2, int y2) {
				minX = Math.Min(x1, x2);
				minY = Math.Min(y1, y2);
				maxX = Math.Max(x1, x2);
				maxY = Math.Max(y1, y2);
			}
		}
		
		private Queue updateArea;
		private bool enableRealtimeUpdate;
		
		public int Width {
			get { return width; }
		}
		
		public int Height {
			get { return height; }
		}

		public Array Layers {
			get { return layers.ToArray(); }
		}
		
		public int ActiveLayerIndex {
			get {
				if (activeLayerIndex >= layers.Count) {
					activeLayerIndex = layers.Count - 1;
				}
				return activeLayerIndex;
			}
			set {
				if (value < layers.Count) {
					activeLayerIndex = value;
				}
			}
		}
		
		public Layer ActiveLayer {
			get {
				return (Layer)layers[ActiveLayerIndex];
			}
		}
		
		public OnUpdateAreaHandler OnUpdateArea {
			get { return onUpdateArea; }
			set { onUpdateArea = value; }
		}
		
		public bool EnableRealtimeUpdate {
			get { return enableRealtimeUpdate; }
			set {
				enableRealtimeUpdate = value;
				if (enableRealtimeUpdate)
					UpdateProjection();
			}
		}
		
		public ISurface Projection {
			get { return projection; }
		}
		
		public JobProcessor Processor {
			get { return processor; }
			set { processor = value; }
		}
		
		public void Resize(int width, int height) {
			// TBD
		}
		
		public Image(int width, int height) {
			this.width = width;
			this.height = height;
			activeLayerIndex = 0;
			layers = new ArrayList();

			byte[] primaryColor = { 255, 255, 255 };
			byte[] primaryAlpha = { 255 };
			Generic.CompactGenericRasterFactory baseFactory = new Generic.CompactGenericRasterFactory(primaryColor, primaryAlpha, false);
			Tiled.TiledRasterFactory factory = new Tiled.TiledRasterFactory(baseFactory);
			Tiled.TiledSurface surface = new Tiled.TiledSurface(0, 0, width, height, factory);
			Layer layer = new Layer(this, surface);
			
			layers.Add(layer);
			layer.Name = "Background";

			layer.Surface.MakeRastersReadable(0, 0, width, height);
			projection = new GenericSurface(0, 0, width, height, false);
			projection.MakeRastersWriteable(0, 0, width, height);
			enableRealtimeUpdate = true;
			updateArea = new Queue();
#if USE_JOB_SCHEDULING
			processor = new JobProcessor2();
#endif
		}
				
		public void QueueUpdatedArea(int minX, int minY, int maxX, int maxY) {
			Area area = new Area(minX, minY, maxX, maxY);
			lock (updateArea) {
				updateArea.Enqueue(area);
			}
			if (enableRealtimeUpdate)
				UpdateProjection(); 
//			Console.WriteLine("Push:"+minX+","+minY+","+maxX+","+maxY);
		}
		
		public void UpdateProjection() {
			try {
			D.StopWatches.Image_UpdateProjection.Start();
			Area overallArea = null;
			while (true) {
//				Console.WriteLine("Wait");
				Area area;
				lock (updateArea) {
					try {
						area = (Area)updateArea.Dequeue();
					} catch (InvalidOperationException) {
						area = null;
					}
				}
				if (area == null && updateArea.Count == 0)
					break;
				if (overallArea == null) {
					overallArea = new Area(area.minX, area.minY, area.maxX, area.maxY);
				} else {
					if (overallArea.minX > area.minX)
						overallArea.minX = area.minX;
					if (overallArea.minY > area.minY)
						overallArea.minY = area.minY;
					if (overallArea.maxX < area.maxX)
						overallArea.maxX = area.maxX;
					if (overallArea.maxY < area.maxY)
						overallArea.maxY = area.maxY;
				}
			}
			
			if (overallArea != null) {
				Layer clippingLayer = null;
//				Console.WriteLine("Image:Update:"+overallArea.minX+","+overallArea.minY+","+overallArea.maxX+","+overallArea.maxY);

				foreach (Layer layer in layers) {
					if (!layer.Clipped)
						clippingLayer = null;
					if (clippingLayer == null || clippingLayer.Visible)
						layer.ApplyToSurface(projection, overallArea.minX, overallArea.minY, overallArea.maxX, overallArea.maxY, (clippingLayer != null)? clippingLayer.Surface: null, processor);
					if (!layer.Clipped)
						clippingLayer = layer;
				}
				if (processor != null)
					processor.ProcessSync();
				if (onUpdateArea != null)
					onUpdateArea(overallArea.minX, overallArea.minY, overallArea.maxX, overallArea.maxY);
			}
			} finally {
				D.StopWatches.Image_UpdateProjection.Stop();
			}
		}
		
		public bool InsertLayerAfter(int index, Layer newLayer) {
			if (index >= layers.Count)
				return false;
			layers.Insert(index + 1, newLayer);
			return true;
		}
		
		public bool AddLayer(Layer newLayer) {
			layers.Add(newLayer);
			QueueUpdatedArea(newLayer.Surface.OffsetX, 
			                 newLayer.Surface.OffsetY, 
			                 newLayer.Surface.OffsetX + newLayer.Surface.Width, 
			                 newLayer.Surface.OffsetY + newLayer.Surface.Height);
			return true;
		}
		
		public bool RemoveLayerAt(int index) {
			if (index >= layers.Count)
				return false;
			Layer layer = (Layer)layers[index];
			layers.RemoveAt(index);
			QueueUpdatedArea(layer.Surface.OffsetX, 
			                 layer.Surface.OffsetY, 
			                 layer.Surface.OffsetX + layer.Surface.Width, 
			                 layer.Surface.OffsetY + layer.Surface.Height);
			return true;
		}
		
		public bool RemoveLayer(Layer layer) {
			layers.Remove(layer);
			QueueUpdatedArea(layer.Surface.OffsetX, 
			                 layer.Surface.OffsetY, 
			                 layer.Surface.OffsetX + layer.Surface.Width, 
			                 layer.Surface.OffsetY + layer.Surface.Height);
			return true;
		}
		
		public Layer GetLayerAt(int index) {
			if (index >= layers.Count)
				return null;
			return (Layer)layers[index];
		}
		
		public int LayerCount {
			get { return layers.Count; }
		}
		
	}
	
}
