// /home/tarai/Projects/gsaw/TransformOperation.cs created with MonoDevelop
// User: tarai at 15:11 2008/05/05
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Operation {
	
	using Holo.Image;
	
	public class TransformOperation {
		
		protected int srcScale;
		protected int destScale;
		protected double rotationDegree; // TBD.
		protected long scaleGrid;

		public delegate void TransformOperator(ISurfaceIterator surfIter, ISurfaceIterator destIter, int w, int h);
		private TransformOperator opr;
		
		private void CalcGrid() {
			long t;
			long m = srcScale;
			long n = destScale;
			while (m % n != 0) {
				t = n;
				n = m % n;
				m = t;
			}
			scaleGrid = (srcScale / n ) * (destScale / n);
//			Console.WriteLine("Scale: src={0},dest={1},ScaleLCM={2}", srcScale, destScale, scaleGrid);
		}
		
		public int SourceScale {
			get { return srcScale; }
			set { 
				if (value > 1)
					srcScale = value; 
				else
					srcScale = 1;
				CalcGrid();
			}
		}
		
		public int DestScale {
			get { return destScale; }
			set { 
				if (value > 1)
					destScale = value; 
				else
					destScale = 1;
				CalcGrid();
			}
		}
		
		public TransformOperator Operator {
			get { return opr; }
			set { opr = value; }
		}
		
		public int GridSize {
			get { return (int)scaleGrid; }
		}
		
		public TransformOperation() {
			srcScale = 1;
			destScale = 1;
			scaleGrid = 1;
		}
		
		public void GetNormalizedBoundary(ISurface surface, ref int minX, ref int minY, ref int maxX, ref int maxY) {
			minX = Math.Max(minX, surface.OffsetX);
			minY = Math.Max(minY, surface.OffsetY);
			maxX = Math.Min(maxX, surface.OffsetX + surface.Width);
			maxY = Math.Min(maxY, surface.OffsetY + surface.Height);

			minX = (int)((minX / scaleGrid) * scaleGrid);
			minY = (int)((minY / scaleGrid) * scaleGrid);
			maxX = (int)(((maxX + scaleGrid - 1) / scaleGrid) * scaleGrid);
			maxY = (int)(((maxY + scaleGrid - 1) / scaleGrid) * scaleGrid);
		}
		
		public virtual void Apply(ISurface surface, int minX, int minY, int maxX, int maxY, int destX, int destY, ISurface dest) {
			
			if (minX >= maxX || minY >= maxY)
				return;

			// Calculate destination rectangle. (currently only for subsampling)
			int destMaxX = destX + ((maxX - minX) * destScale + srcScale - 1) / srcScale;
			int destMaxY = destY + ((maxY - minY) * destScale + srcScale - 1) / srcScale;
			if (destMaxX == destX) 
				destMaxX += 1;
			if (destMaxY == destY) 
				destMaxY += 1;
			int destWidth = destMaxX - destX;
			int destHeight = destMaxY - destY;
			
//			Console.WriteLine("Transform:Apply:"+minX+","+minY+"-"+maxX+","+maxY+"->"+destX+","+destY+"-"+destMaxX+","+destMaxY);
			
			int width = maxX - minX;
			int height = maxY - minY;
			surface.MakeRastersReadable(minX, minY, width, height);
			dest.MakeRastersWriteable(destX, destY, destWidth, destHeight);

			ISurfaceIterator destIter    = dest.GetIteratorAt(destX, destY);
			ISurfaceIterator surfaceIter = surface.GetIteratorAt(minX, minY);
			
			destIter.SetRange(destX, destY, destMaxX, destMaxY);
			surfaceIter.SetRange(minX, minY, maxX, maxY);

			while (!destIter.IsYEnded()) {
				int h = Math.Min(destMaxY - destIter.OffsetY, destIter.HeightOfRaster);
				if (h == 0) {
					Console.WriteLine("TransformOperation: error: height = 0: offset={0},heightOfRaster={1}", destIter.OffsetY, destIter.HeightOfRaster);
					Console.WriteLine("TransformOperation: error: height = 0: destMinY={0}, destMaxY={1}", destY, destMaxY);
					break;
				}
				while (!destIter.IsXEnded()) {
					int w = Math.Min(destMaxX - destIter.OffsetX, destIter.WidthOfRaster);
					if (w == 0) {
						Console.WriteLine("TransformOperation: error: width = 0: offset={0},widthOfRaster={1}", destIter.OffsetX, destIter.WidthOfRaster);
						break;
					}
					if (opr != null)
						opr(surfaceIter, destIter, w, h);
					destIter.AddX(w);
				}
				destIter.ResetXAndAddY(h);
			}
			if (dest.OnUpdateArea != null)
				dest.OnUpdateArea(destX, destY, destMaxX, destMaxY);
		}
	}
}