#ifndef COMPOSITE_LOOP
#define COMPOSITE_LOOP(alpha1_op, alpha2_op, alpha_op, float_alpha_op, numChannels, maxChannel, pixel_op, alpha_set, src2Alpha_pixel_inc, mask_pixel_inc, src2Alpha_row_inc, mask_row_inc)\
	switch (destChannels) {															\
	case (maxChannel-1):																\
		DO_LOOP(alpha1_op, alpha2_op, alpha_op, float_alpha_op, numChannels, maxChannel, \
		{ pixel_op(0);																\
		pixel_op(1);																	\
		pixel_op(2);																	\
		alpha_set; },																\
		src2Alpha_pixel_inc, mask_pixel_inc, src2Alpha_row_inc, mask_row_inc);			\
		break;																		\
	case (maxChannel-4):																\
		DO_LOOP(alpha1_op, alpha2_op, alpha_op, float_alpha_op, numChannels, maxChannel, \
		{alpha_set; },																\
		src2Alpha_pixel_inc, mask_pixel_inc, src2Alpha_row_inc, mask_row_inc);			\
		break;																		\
	default:																			\
		DO_LOOP(alpha1_op, alpha2_op, alpha_op, float_alpha_op, numChannels, maxChannel, \
		{for (c = 0; c < numChannels; c ++)											\
			pixel_op(c);																\
		alpha_set;},																	\
		src2Alpha_pixel_inc, mask_pixel_inc, src2Alpha_row_inc, mask_row_inc);			\
		break;																		\
	}
#endif

#ifndef DO_LOOP
#define DO_LOOP(alpha1_op, alpha2_op, alpha_op, float_alpha_op, numChannels, maxChannel, pixel_ops, src2Alpha_pixel_inc, mask_pixel_inc, src2Alpha_row_inc, mask_row_inc)\
		for (y = 0; y < height; y ++) {												\
			for (x = 0; x < width; x ++) {											\
				int src1Alpha = alpha1_op;											\
				int src2Alpha = alpha2_op;											\
																					\
				int alpha = alpha_op;													\
				float_alpha_op;														\
				if (alpha == 0) {													\
					memset(pDestColorValue, 0, sizeof(byte) * (destChannels));			\
				} else {																\
					pixel_ops;														\
				}																	\
				pDestColorValue += destPixelStride;									\
				pSrc1ColorValue += src1PixelStride;									\
				pSrc2ColorValue += src2PixelStride;									\
				pSrc1AlphaValue += src1AlphaPixelStride;								\
				src2Alpha_pixel_inc;													\
				mask_pixel_inc;														\
			}																		\
			pDestColorValue += destRowStride;										\
			pSrc1ColorValue += src1RowStride;										\
			pSrc2ColorValue += src2RowStride;										\
			pSrc1AlphaValue += src1AlphaRowStride;									\
			src2Alpha_row_inc;														\
			mask_row_inc;															\
		}
#endif

void Function(byte* src1Color, int src1Offset, int src1RowStride, int src1PixelStride, 
		int src1Channels, 
		byte* src1AlphaValue, int src1AlphaOffset, int src1AlphaRowStride, int src1AlphaPixelStride,
		byte* src2Color, int src2Offset, int src2RowStride, int src2PixelStride, 
		int src2Channels, 
		byte* src2AlphaValue, int src2AlphaOffset, int src2AlphaRowStride, int src2AlphaPixelStride,
		byte* maskValue, int maskOffset, int maskRowStride, int maskPixelStride,
		byte* destColor, int destOffset, int destRowStride, int destPixelStride,
		bool destHasAlpha, bool destHasColor, int destChannels,
		int width, int height, double opacity) {
	int x, y, c;
	int t;	// temporary variable for INT_MULT
	byte* pSrc1ColorValue = src1Color + src1Offset;
	byte* pSrc2ColorValue = src2Color + src2Offset;
	byte* pDestColorValue = destColor + destOffset;
	byte* pSrc1AlphaValue = src1AlphaValue + src1AlphaOffset;
	byte* pSrc2AlphaValue = src2AlphaValue + src2AlphaOffset;
	byte* pMaskValue      = maskValue + maskOffset;
	float falpha, fcmpl_alpha;

	destRowStride -= (width * destPixelStride);
	src1RowStride -= (width * src1PixelStride);
	src2RowStride -= (width * src2PixelStride);
	src1AlphaRowStride -= (width * src1AlphaPixelStride);
	src2AlphaRowStride -= (width * src2AlphaPixelStride);

	if (maskValue == null || maskPixelStride == 0) {
		if (maskValue != null)
			opacity *= *maskValue / 255.0;

		if (destHasAlpha) {

			COMPOSITE_LOOP(*pSrc1AlphaValue * opacity, 
						   (int)(*pSrc2AlphaValue), 
						   calc_dest_alpha(), float_alpha_vars,
						   destChannels - 1, 5,
						   pixel_op_with_alpha, 
						   *(pDestColorValue + destChannels - 1) = (byte)(min(255, alpha)),
						   pSrc2AlphaValue += src2AlphaPixelStride, , 
						   pSrc2AlphaValue += src2AlphaRowStride, );
		} else {
			if (src2AlphaRowStride == 0 && src2AlphaPixelStride == 0 && *pSrc2AlphaValue == 255) {
				COMPOSITE_LOOP(*pSrc1AlphaValue * opacity, 
							   255, 
							   255, float_alpha_vars,
							   destChannels, 4,
							   pixel_op_to_opaque, , 
							   , ,
							   , );
			} else {
				COMPOSITE_LOOP(*pSrc1AlphaValue * opacity, 
							   (int)(*pSrc2AlphaValue), 
							   calc_dest_alpha(),float_alpha_vars,
							   destChannels, 4,
							   pixel_op_without_alpha, ,
							   pSrc2AlphaValue += src2AlphaPixelStride, ,
							   pSrc2AlphaValue += src2AlphaRowStride, );
			}
		}
	} else {
		maskRowStride -= (width * maskPixelStride);
		opacity /= 255.0;

		if (destHasAlpha) {

			COMPOSITE_LOOP(min(255, *pSrc1AlphaValue * opacity * *pMaskValue) , 
						   (int)(*pSrc2AlphaValue),
						   calc_dest_alpha(), float_alpha_vars,
						   destChannels - 1, 5,
						   pixel_op_with_alpha, 
						   *(pDestColorValue + destChannels - 1) = (byte)(alpha), 
						   pSrc2AlphaValue += src2AlphaPixelStride, pMaskValue += maskPixelStride, 
						   pSrc2AlphaValue += src2AlphaRowStride, pMaskValue += maskRowStride);

		} else {
			if (src2AlphaRowStride == 0 && src2AlphaPixelStride == 0 && *pSrc2AlphaValue == 255) {
				COMPOSITE_LOOP(min(255, *pSrc1AlphaValue * opacity * *pMaskValue) , 
							   255, 
							   255, float_alpha_vars,
							   destChannels, 4,
							   pixel_op_to_opaque, 
							   , 
							   , pMaskValue += maskPixelStride, 
							   , pMaskValue += maskRowStride);
			} else {
				COMPOSITE_LOOP(min(255, *pSrc1AlphaValue * opacity * *pMaskValue) , 
							   (int)(*pSrc2AlphaValue), 
							   calc_dest_alpha(), float_alpha_vars,
							   destChannels, 4,
							   pixel_op_without_alpha, 
							   , 
							   pSrc2AlphaValue += src2AlphaPixelStride, pMaskValue += maskPixelStride,
							   pSrc2AlphaValue += src2AlphaRowStride, pMaskValue += maskRowStride);
			}
		}
	}

}

#undef COMPOSITE_LOOP
