#ifndef LIBWILMAOPS_H
#define LIBWILMAOPS_H

typedef unsigned char byte;
typedef short int bool;

#define null NULL

#include <string.h>

#define min(a, b) ((a) < (b))? (a):(b)
#define max(a, b) ((a) > (b))? (a):(b)

/* ----- These macros are taken from the GIMP ----- */
#define INT_MULT(a,b,t)  ((t) = (a) * (b) + 0x80, ((((t) >> 8) + (t)) >> 8))

/* This version of INT_MULT3 is very fast, but suffers from some
   slight roundoff errors.  It returns the correct result 99.987
   percent of the time */
#define INT_MULT3(a,b,c,t)  ((t) = (a) * (b) * (c) + 0x7F5B, \
                            ((((t) >> 7) + (t)) >> 16))

#define INT_BLEND(a,b,alpha,tmp)  (INT_MULT((a) - (b), alpha, tmp) + (b))

#define INT_MULT_WITH_BASE(a,b,bit,t)  ((t) = (a) * (b) + (1<<((bit)-1)), ((((t) >> (bit)) + (t)) >> (bit)))
#define INT_BLEND_WITH_BASE(a,b,alpha,base,tmp)  (INT_MULT_WITH_BASE((a) - (b), alpha, base, tmp) + (b))
#define INT_DIV2(x, t) ((t) = (x) + 0x7F5B, ((((t) >> 7) + (t)) >> 16))
#define INT_DIV_WITH_BASE(x,bit,t)  ((t) = (x) + (1<<((bit)-1)), ((((t) >> (bit)) + (t)) >> (bit)))

#define declare_composite_op(name) \
	void name(byte* src1Color, int src1Offset, int src1RowStride, int src1PixelStride, int src1Channels, \
		byte* src1AlphaValue, int src1AlphaOffset, int src1AlphaRowStride, int src1AlphaPixelStride, \
		byte* src2Color, int src2Offset, int src2RowStride, int src2PixelStride, int src2Channels, \
		byte* src2AlphaValue, int src2AlphaOffset, int src2AlphaRowStride, int src2AlphaPixelStride, \
		byte* maskValue, int maskOffset, int maskRowStride, int maskPixelStride, \
		byte* destColor, int destOffset, int destRowStride, int destPixelStride, \
		bool destHasAlpha, bool destHasColor, int destChannels, \
		int width, int height, double opacity);

declare_composite_op(CBlend);

void CShrink(byte* destBuffer,
			 int destOffset, int destRowStride, int destPixelStride, 
			 int destWidth, int destHeight,
			 byte* srcBuffer,
			 int srcOffset, int srcRowStride, int srcPixelStride,  
			 int origSrcWidth, int origSrcHeight,
			 int numChannels, int srcScale, int destScale);

void CExpand(byte* destBuffer,
			 int destOffset, int destRowStride, int destPixelStride, 
			 int destWidth, int destHeight,
			 byte* srcBuffer,
			 int srcOffset, int srcRowStride, int srcPixelStride,  
			 int origSrcWidth, int origSrcHeight,
			 int numChannels, int srcScale, int destScale);

void CRotate(byte* srcPixels, int srcRowStride, int srcPixelStride, int srcOffsetX, int srcOffsetY, int srcWidth, int srcHeight,
             int srcStartX, int srcStartY,
             int dxInXAxis, int dyInXAxis, int dxInYAxis, int dyInYAxis,
             int srcMinX, int srcMinY, int srcMaxX, int srcMaxY, 
             byte* destPixels, int destRowStride, int destPixelStride, int destChannels,
             int destOriginX, int destOriginY,
             int destMinX, int destMinY, int destMaxX, int destMaxY,
             int destStartX, int destStartY, int destEndX, int destEndY);
#endif
