/*
 *	GSFinder+ - File manager software for WindowsCE
 *	Copyright(C) 2000-2005 Y.Nagamidori  (based source code)
 *	Copyright(C) 2004-2005 M.Toda  (modified source code)
 *	Copyright(C) 2006-2007 M.Kawamula  (modified source code)
 *	Copyright(C) 2007-2008 Goripon Software/GORIPON(G2 Co.,LTD.)
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#if !defined(__GSFINDER_H_INCLUDED)
#define __GSFINDER_H_INCLUDED

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

///////////////////////////////////////////////////////////////
#include "resource.h"
#include <windows.h>
#include <winuser.h>
#include <commctrl.h>
#include <commdlg.h>
#include <shellapi.h>
#include <dbt.h>
#include <Sipapi.h>
#include <Aygshell.h>
#include <projects.h>
#include <wininet.h>
#include "MainWnd.h"

///////////////////////////////////////////////////////////////
//DEFINE
#define APP_MAINWND_TITLE	_T("GSFinder+ W03")
#define APP_MUTEX_NAME		_T("GSFINDERW03")
#define APP_CLASS_NAME		_T("GSFINDERW03")
#define APP_CMD_PARAM		_T("/FOLDER:")
#define APP_CMD_PARAM_LEN	8

#define APP_SPLIT_SIZE		4
#define COMPDLL_MODE_LHA	1
#define COMPDLL_MODE_ZIP	2

#define LIST_ITEM_UPPER		0
#define LIST_ITEM_FOLDER	1
#define LIST_ITEM_FILE		2

#define LIST_SORT_NAME		0
#define LIST_SORT_EXT		1
#define LIST_SORT_SIZE		2
#define LIST_SORT_TIME		3

#define RETCODE_YES			0
#define RETCODE_NO			1
#define RETCODE_ALL_YES		2
#define RETCODE_ALL_NO		3

#define ID_TIMER_RESETTIME		1
#define TIMER_RESETTIME_INT		10000
#define ID_TIMER_TVSELECTED		2
#define	TIMER_TVSELECTED_INT	500
#define ID_TIMER_FOWARDFIND		3
#define TIMER_FOWARDFIND_INT	1000
#define ID_TIMER_DEVICECHANGE	5
#define	TIMER_DEVICECHANGE_INT	2000

#define AREA_TAPHOLD		5

#define WM_DROPFILES		0x0233
#define WM_UPDATENOTIFY		(WM_USER + 1)

#define MENU_HEIGHT			26

#define REG_KEY_GSF				_T("Software\\goripon\\GSFinder-W03")
#define REG_KEY_SETTINGS		_T("Software\\goripon\\GSFinder-W03\\Settings")
#define REG_KEY_CMDBANDS		_T("Software\\goripon\\GSFinder-W03\\Settings\\Cmdbands")
#define REG_KEY_FILEIMAGELIST	_T("Software\\goripon\\GSFinder-W03\\Settings\\FileImageList")
#define REG_KEY_LISTVIEW		_T("Software\\goripon\\GSFinder-W03\\Settings\\ListView")
#define REG_KEY_RECENT			_T("Software\\goripon\\GSFinder-W03\\Settings\\Recent")
#define REG_KEY_PHONESTAT		_T("Software\\Sharp\\PhoneStatus")

#define RECT_WIDTH(prc)		((prc)->right - (prc)->left)
#define RECT_HEIGHT(prc)	((prc)->bottom - (prc)->top)

#define GET_X_LPARAM(lp)	((int)(signed short)LOWORD(lp))
#define GET_Y_LPARAM(lp)	((int)(signed short)HIWORD(lp))

#define ID_POPUP_FILEVIEW_FILE		(0)
#define ID_POPUP_FILEVIEW_FOLDER	(1)
#define ID_POPUP_FILEVIEW_MULTI		(2)
#define ID_POPUP_FILEVIEW_NOSELECT	(3)
#define ID_POPUP_DRAGDROP			(4)
#define ID_POPUP_GOTO				(5)
#define ID_POPUP_FOLDERDLG			(6)
#define ID_POPUP_FOLDERVIEW			(7)
#define ID_POPUP_ADDRESSBAR			(8)

#include "PPC2SPLIB/dev/PPC2SPLIB.h"
#pragma comment(lib, "PPC2SPLIB/dev/PPC2SPLIB.lib")
#define PROPERTYSHEET(p)		(g_MainWnd.m_bIsSmartphone? PropertySheet_(p): PropertySheet(p))
#define SHINITDIALOG(s)			(g_MainWnd.m_bIsSmartphone? SHInitDialog_(s): SHInitDialog(s))

#define GetResourceString(ids)	((LPTSTR)LoadString(g_hInst,(ids),NULL,0))

///////////////////////////////////////////////////////////////
// O[oϐ:
extern HINSTANCE g_hInst;			// ݂̃CX^X
extern CMainWnd g_MainWnd;			// CEChE
extern LPTSTR g_lpszFirstLoadFolder;
extern BOOL g_bDraging;

///////////////////////////////////////////////////////////////
extern "C"
{
	LRESULT CALLBACK MainWndProc(HWND, UINT, WPARAM, LPARAM);
	LRESULT CALLBACK About(HWND, UINT, WPARAM, LPARAM);
	void CenterWindow(HWND);
	void SetFormatInteger(LPTSTR, UINT);
	void SetFormatDouble(LPTSTR, UINT);
	void SetFormatDateTime(SYSTEMTIME*, LPTSTR, UINT);
	void SetKickExt(LPTSTR);
	void SetExtFromFileName(LPTSTR, LPTSTR);
	UINT GetFileAndFolderCount(LPCTSTR , LISTITEMINFO*, int);
	BOOL IsFolderShortcut(LPCTSTR, LPCTSTR);
	int CALLBACK PropSheetCallback(HWND, UINT, LPARAM);
	BOOL DefDlgPaintProc(HWND hDlg, WPARAM wParam, LPARAM lParam);
	BOOL DefDlgPaintProc2(HWND hDlg, WPARAM wParam, LPARAM lParam);
	BOOL DefDlgCtlColorStaticProc(HWND hDlg, WPARAM wParam, LPARAM lParam);

	int CALLBACK ListSortCompareFuncByName(LPARAM, LPARAM, LPARAM);
	int CALLBACK ListSortCompareFuncByExt(LPARAM, LPARAM, LPARAM);
	int CALLBACK ListSortCompareFuncBySize(LPARAM, LPARAM, LPARAM);
	int CALLBACK ListSortCompareFuncByTime(LPARAM, LPARAM, LPARAM);
	DWORD GetIMStatus();

	void SetFormatSize(LONGLONG dwSize, TCHAR szBuff[64], LPTSTR lpszFmtKB, LPTSTR lpszFmtMB);
	LPCTSTR GetRootName();
	int AddRootIcon(HIMAGELIST hImageList);
	HFONT MyCreateFont(int, BYTE, LPTSTR);

	void InitUpdateNotify();
	void EnableUpdateNotify();
	void DisableUpdateNotify();
	void SetUpdateNotify(LPCTSTR pszDir);
	void UninitUpdateNotify();

	void OnDlgPathBrowseFolder(HWND hDlg, int nEditId, int nTitleId=IDS_TITLE_SELECTFOLDER);
	void OnDlgPathBrowseFile(HWND hDlg, int nEditId, int nTitleId=IDS_TITLE_SELECTLINK, LPCTSTR szWildcard=_T("*.*"));
	BOOL ProcessShortcutKey(HWND, WORD);
};

///////////////////////////////////////////////////////////////
#endif // !defined(__GSFINDER_H_INCLUDED)
