//FileProperty.cpp
#include "GSFinder.h"
#include "FileProperty.h"

CFileProperty* pfp = NULL;

////////////////////////////////////////////////////////////////
void CFileProperty::PPFileShortcut_InitDialog(HWND hDlg)
{
	SetDlgItemText(hDlg, IDC_TITLE, m_szTitle);
	SetWindowText(GetDlgItem(hDlg, IDC_SHORTCUT_NAME), m_lpliinfo[0].szName);
	
	TCHAR szPath[MAX_PATH];
	wsprintf(szPath, _T("%s\\%s"), m_lpszCurrentFolder, m_lpliinfo[0].szName);

	SHFILEINFO si;

	//^[Qbg̏擾
	TCHAR szTarget[MAX_PATH];
	if (SHGetShortcutTarget(szPath, szTarget, MAX_PATH))
	{
		SetWindowText(GetDlgItem(hDlg, IDC_EDIT_TARGET_PATH), szTarget);

		wcscpy(m_szOldTarget, szTarget);
		wcscpy(m_szNewTarget, szTarget);

		TCHAR szTemp[MAX_PATH] = {0};
		if (szTarget[0] == _T('\"'))
		{
			LPTSTR lpszTemp = szTarget;
			lpszTemp++;
			LPTSTR lpszMark = wcschr(lpszTemp, _T('"'));
			if (lpszMark)
				wcsncpy(szTemp, lpszTemp, lpszMark-lpszTemp);
			else
				wcsncpy(szTemp, lpszTemp, wcslen(lpszTemp)-1);
		}
		else
		{
			LPTSTR lpszTemp = wcschr(szTarget, _T(' '));
			if (lpszTemp)
				wcsncpy(szTemp, szTarget, lpszTemp-szTarget);
			else
				wcscpy(szTemp, szTarget);
		}

		DWORD dwAttr = GetFileAttributes(szTemp);
		if (dwAttr != 0xFFFFFFFF)
		{
			SHGetFileInfo(szTemp, NULL, &si, sizeof(si), SHGFI_LARGEICON | SHGFI_ICON | SHGFI_TYPENAME);
			SendMessage(GetDlgItem(hDlg, IDC_TARGET_ICON), STM_SETIMAGE, IMAGE_ICON, (LPARAM)si.hIcon);
			SetWindowText(GetDlgItem(hDlg, IDC_TARGET_TYPE), si.szTypeName);
		}
		else
			SetWindowText(GetDlgItem(hDlg, IDC_TARGET_TYPE), IDS_MSG_INVALIDSHORTCUT);
	}
	else
	{
		SetWindowText(GetDlgItem(hDlg, IDC_TARGET_TYPE), IDS_MSG_INVALIDSHORTCUT);
		EnableWindow(GetDlgItem(hDlg, IDC_EDIT_TARGET_PATH), FALSE);
	}
}
////////////////////////////////////////////////////////////////
LRESULT CALLBACK PPFileShortcutProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{
			pfp->PPFileShortcut_InitDialog(hDlg);
			return TRUE;
		}
		break;
		case WM_COMMAND:
		{
			if (HIWORD(wParam)==EN_CHANGE)
			{
				if (GetDlgItem(hDlg, IDC_EDIT_TARGET_PATH)==(HWND)lParam)
				{
					GetWindowText(GetDlgItem(hDlg, IDC_EDIT_TARGET_PATH), pfp->m_szNewTarget, MAX_PATH);
					return TRUE;
				}
			}
			break;
		}
		break;
		case WM_PAINT:
			return DefDlgPaintProc(hDlg, wParam, lParam);
		case WM_CTLCOLORSTATIC:
			return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);
	}
    return FALSE;
}

////////////////////////////////////////////////////////////////
void CFileProperty::PPFileMain_OnChkReadonly(HWND hDlg)
{
	if (SendMessage(GetDlgItem(hDlg, IDC_CHK_READONLY), BM_GETCHECK, 0, 0))
		m_dwAttr |= FILE_ATTRIBUTE_READONLY;
	else
		m_dwAttr ^= FILE_ATTRIBUTE_READONLY;
}
void CFileProperty::PPFileMain_OnChkHidden(HWND hDlg) 
{
	if (SendMessage(GetDlgItem(hDlg, IDC_CHK_HIDDEN), BM_GETCHECK, 0, 0))
		m_dwAttr |= FILE_ATTRIBUTE_HIDDEN;
	else
		m_dwAttr ^= FILE_ATTRIBUTE_HIDDEN;
}
void CFileProperty::PPFileMain_OnChkArchive(HWND hDlg) 
{
	if (SendMessage(GetDlgItem(hDlg, IDC_CHK_ARCHIVE), BM_GETCHECK, 0, 0))
		m_dwAttr |= FILE_ATTRIBUTE_ARCHIVE;
	else
		m_dwAttr ^= FILE_ATTRIBUTE_ARCHIVE;
}
////////////////////////////////////////////////////////////////
void CFileProperty::PPFileMain_InitDialog(HWND hDlg)
{
	SetDlgItemText(hDlg, IDC_TITLE, m_szTitle);
	TCHAR szTemp[128];
	wcscpy(m_szNewName, m_lpliinfo[0].szName);

	//t@C
	if (g_MainWnd.m_ListView.m_Settings.bNotShowExt && m_lpliinfo[0].nItem == LIST_ITEM_FILE)
	{
		TCHAR szName[MAX_PATH];
		wcscpy(szName, m_lpliinfo[0].szName);
		SetKickExt(szName);
		SetWindowText(GetDlgItem(hDlg, IDC_EDIT_FILENAME), szName);
	}
	else
		SetWindowText(GetDlgItem(hDlg, IDC_EDIT_FILENAME), m_lpliinfo[0].szName);
	
	//ꏊ
	if (!wcslen(m_lpszCurrentFolder))
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_PATH), GetRootName());
	else
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_PATH), m_lpszCurrentFolder);

	//ADD START TODA ([g)
	BOOL bRoot = FALSE;
	if(wcsicmp(m_lpliinfo[0].szName, GetRootName())==0)
		bRoot = TRUE;
	//ADD END

	TCHAR szFilePath[MAX_PATH];
	//ADD START TODA
	if(bRoot)
		wcscpy(szFilePath, _T("\\"));
	else
	//ADD END
		wsprintf(szFilePath, _T("%s\\%s"), m_lpszCurrentFolder, m_lpliinfo[0].szName);
	
	//t@C擾
	SHFILEINFO si;
	SHGetFileInfo(szFilePath, NULL, &si, sizeof(si), SHGFI_LARGEICON | SHGFI_ICON | SHGFI_TYPENAME);

	//ADD START TODA ([gpACRݒ)
	if(bRoot)
	{
		//[gpACR
//MOD START GORIPON
		//HICON hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROOT_L);
		HICON hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROOT_M);
//MOD END
		SendMessage(GetDlgItem(hDlg, IDC_FILE_ICON), STM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcon);
		DestroyIcon(hIcon);
	}
	else
	//ADD END
		//ACR
		SendMessage(GetDlgItem(hDlg, IDC_FILE_ICON), STM_SETIMAGE, IMAGE_ICON, (LPARAM)si.hIcon);
	

	//t@CJ
//MOD START GORIPON
//VS2005{WM6SDKł̃rhhFile̓eNULLɉ̂邽߁Bϐ̏Փ˂œKH
	//HANDLE hFile = CreateFile(szFilePath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL);
	HANDLE hFileTarget = CreateFile(szFilePath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL);
//MOD END

	//TCY
	DWORD dwSize = 0;
//MOD START GORIPON
	//dwSize = GetFileSize(hFile, NULL);
	dwSize = GetFileSize(hFileTarget, NULL);
//MOD END
	if (dwSize != 0xFFFFFFFF)
	{
		TCHAR szSize[64];
		TCHAR szKSize[64];
		wsprintf(szSize, _T("%d"), dwSize);
		SetFormatInteger(szSize, 64);
		SetFormatSize(dwSize, szKSize, _T("%s"), _T("%s"));
		if (dwSize < 1024000)
			wsprintf(szTemp, IDS_FMT_KBBYTE, szKSize, szSize);
		else
			wsprintf(szTemp, IDS_FMT_MBBYTE, szKSize, szSize);
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_SIZE), szTemp);
	}
	else
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_SIZE), _T(""));

	//쐬
	TCHAR szTime[64];
	FILETIME ftCreate;
	ftCreate.dwHighDateTime = 0;
	ftCreate.dwLowDateTime = 0;
	SYSTEMTIME st;
//MOD START GORIPON
	//if (GetFileTime(hFile, &ftCreate, NULL, NULL) && ftCreate.dwHighDateTime && ftCreate.dwLowDateTime)
	if (GetFileTime(hFileTarget, &ftCreate, NULL, NULL) && ftCreate.dwHighDateTime && ftCreate.dwLowDateTime)
//MOD END
	{
		FileTimeToLocalFileTime(&ftCreate, &ftCreate);
		FileTimeToSystemTime(&ftCreate, &st);
		SetFormatDateTime(&st, szTime, sizeof(szTime));	//MOD TODA
		wsprintf(szTemp, _T("%s"), szTime);
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_CREATE_TIME), szTemp);
	}
	else
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_CREATE_TIME), _T(""));

	//XV
	FILETIME ftUpdate;
//MOD START GORIPON
	//if (GetFileTime(hFile, NULL, NULL, &ftUpdate) && ftUpdate.dwHighDateTime && ftUpdate.dwLowDateTime)
	if (GetFileTime(hFileTarget, NULL, NULL, &ftUpdate) && ftUpdate.dwHighDateTime && ftUpdate.dwLowDateTime)
//MOD END
	{
		FileTimeToLocalFileTime(&ftUpdate, &ftUpdate);
		FileTimeToSystemTime(&ftUpdate, &st);
		SetFormatDateTime(&st, szTime, sizeof(szTime));	//MOD TODA
		wsprintf(szTemp, _T("%s"), szTime);
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_WRITE_TIME), szTemp);
	}
	else
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_WRITE_TIME), _T(""));

//MOD START GORIPON
	//CloseHandle(hFile);
	CloseHandle(hFileTarget);
//MOD END

	//
	m_dwAttr = GetFileAttributes(szFilePath);
	if (m_dwAttr != 0xFFFFFFFF && m_lpliinfo[0].nItem == LIST_ITEM_FILE)
	{
		if ((m_dwAttr&FILE_ATTRIBUTE_READONLY)==FILE_ATTRIBUTE_READONLY)
			SendMessage(GetDlgItem(hDlg, IDC_CHK_READONLY), BM_SETCHECK, 1, 0);
		if ((m_dwAttr&FILE_ATTRIBUTE_HIDDEN)==FILE_ATTRIBUTE_HIDDEN)
			SendMessage(GetDlgItem(hDlg, IDC_CHK_HIDDEN), BM_SETCHECK, 1, 0);
		if ((m_dwAttr&FILE_ATTRIBUTE_ARCHIVE)==FILE_ATTRIBUTE_ARCHIVE)
			SendMessage(GetDlgItem(hDlg, IDC_CHK_ARCHIVE), BM_SETCHECK, 1, 0);
		if ((m_dwAttr&FILE_ATTRIBUTE_SYSTEM)==FILE_ATTRIBUTE_SYSTEM)
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SYSTEM), BM_SETCHECK, 2, 0);
	}
	else
	{
		EnableWindow(GetDlgItem(hDlg, IDC_CHK_READONLY), FALSE);
		EnableWindow(GetDlgItem(hDlg, IDC_CHK_HIDDEN), FALSE);
		EnableWindow(GetDlgItem(hDlg, IDC_CHK_ARCHIVE), FALSE);
		EnableWindow(GetDlgItem(hDlg, IDC_CHK_SYSTEM), FALSE);
	}
	m_dwOrgAttr = m_dwAttr;

	//
	if ((m_dwAttr&FILE_ATTRIBUTE_INROM) == FILE_ATTRIBUTE_INROM)
	{
		wsprintf(szTemp, _T("%s (in ROM)"), si.szTypeName);
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_TYPE), szTemp);
	}
	else
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_TYPE), si.szTypeName);
}

////////////////////////////////////////////////////////////////
LRESULT CALLBACK PPFileMainProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{
			pfp->PPFileMain_InitDialog(hDlg);
			return TRUE;
		}
		case WM_COMMAND:
		{
			if (HIWORD(wParam)==BN_CLICKED)
			{
				if (GetDlgItem(hDlg, IDC_CHK_READONLY)==(HWND)lParam)
					pfp->PPFileMain_OnChkReadonly(hDlg);
				else if (GetDlgItem(hDlg, IDC_CHK_HIDDEN)==(HWND)lParam)
					pfp->PPFileMain_OnChkHidden(hDlg);
				else if (GetDlgItem(hDlg, IDC_CHK_ARCHIVE)==(HWND)lParam)
					pfp->PPFileMain_OnChkArchive(hDlg);
			}
			else if (HIWORD(wParam)==EN_CHANGE)
			{
				if (GetDlgItem(hDlg, IDC_EDIT_FILENAME)==(HWND)lParam)
				{
					GetWindowText(GetDlgItem(hDlg, IDC_EDIT_FILENAME), pfp->m_szNewName, MAX_PATH);
					return TRUE;
				}
			}
			break;
		}
		case WM_PAINT:
			return DefDlgPaintProc(hDlg, wParam, lParam);
		case WM_CTLCOLORSTATIC:
			return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);
	}
    return FALSE;
}

////////////////////////////////////////////////////////////////
void CFileProperty::GetFileSizeAndCount(LPCTSTR szPath, DWORD* lpSize, DWORD* lpFileCount)
{
	HANDLE hFile = CreateFile(szPath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL);
	DWORD dwSize = GetFileSize(hFile, NULL);
	if (dwSize != 0xFFFFFFFF)
		*lpSize += dwSize;

	*lpFileCount += 1;
	CloseHandle(hFile);
}

////////////////////////////////////////////////////////////////
void CFileProperty::GetFolderSizeAndCount(LPCTSTR szPath, DWORD* lpSize, DWORD* lpFileCount, DWORD* lpFolderCount)
{
	TCHAR szTemp[MAX_PATH];
	wsprintf(szTemp, _T("%s\\*.*"), szPath);

	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		BOOL bRet = TRUE;
		do
		{
			TCHAR szChildPath[MAX_PATH];
			wsprintf(szChildPath, _T("%s\\%s"), szPath, finddata.cFileName);
			if (finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
				//tH_
				GetFolderSizeAndCount(szChildPath, lpSize, lpFileCount, lpFolderCount);
			else
				//t@C
				GetFileSizeAndCount(szChildPath, lpSize, lpFileCount);
		}
		while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}
	*lpFolderCount += 1;	
}

////////////////////////////////////////////////////////////////
void CFileProperty::PPFileMulti_InitDialog(HWND hDlg)
{
	HCURSOR hCursor =SetCursor(LoadCursor(NULL, IDC_WAIT));
	SetDlgItemText(hDlg, IDC_TITLE, m_szTitle);
	DWORD dwSize = 0;
	DWORD dwFileCount = 0;
	DWORD dwFolderCount = 0;
	for (int i=0; i<m_nCount; i++)
	{
		TCHAR szPath[MAX_PATH];
		//pX̍쐬
		//ADD START TODA ([g̃pXݒ - advice by Y.Nagamidori)
		if(0 == wcsicmp(m_lpliinfo[i].szName, GetRootName()))
			szPath[0] = 0x00;
		else
		//ADD END
			wsprintf(szPath, _T("%s\\%s"), m_lpszCurrentFolder, m_lpliinfo[i].szName);

		//TCY擾AJEgJn
		if (m_lpliinfo[i].nItem == LIST_ITEM_FOLDER)
			GetFolderSizeAndCount(szPath, &dwSize, &dwFileCount, &dwFolderCount);
		else if (m_lpliinfo[i].nItem == LIST_ITEM_FILE)
			GetFileSizeAndCount(szPath, &dwSize, &dwFileCount);
	}
	
	//\
	if (!wcslen(m_lpszCurrentFolder))
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_PATH), GetRootName());
	else
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_PATH), m_lpszCurrentFolder);

	if (m_nCount == 1 && m_lpliinfo[0].nItem == LIST_ITEM_FOLDER)
		dwFolderCount -= 1;

	TCHAR szTemp[128];
	wsprintf(szTemp, IDS_FMT_FOLDERCOUNT, dwFolderCount);
	SetWindowText(GetDlgItem(hDlg, IDC_FOLDER_COUNT), szTemp);
	wsprintf(szTemp, IDS_FMT_FILECOUNT, dwFileCount);
	SetWindowText(GetDlgItem(hDlg, IDC_FILE_COUNT), szTemp);

	TCHAR szSize[64];
	wsprintf(szSize, _T("%d"), dwSize);
	SetFormatInteger(szSize, 64);
	wsprintf(szTemp, IDS_FMT_BYTE, szSize);
	SetWindowText(GetDlgItem(hDlg, IDC_SIZE_BYTE), szTemp);
	SetFormatSize(dwSize, szSize, _T("%s KB"), _T("%s MB"));
	SetWindowText(GetDlgItem(hDlg, IDC_SIZE_KIROBYTE), szSize);

	SetCursor(hCursor);
}

////////////////////////////////////////////////////////////////
LRESULT CALLBACK PPFileMultiProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{
			pfp->PPFileMulti_InitDialog(hDlg);
			return TRUE;
		}
		case WM_PAINT:
			return DefDlgPaintProc(hDlg, wParam, lParam);
		case WM_CTLCOLORSTATIC:
			return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);
	}
    return FALSE;
}

////////////////////////////////////////////////////////////////
int CFileProperty::ShowMultiProperty()
{
	//t@C̃vpeB
	PROPSHEETPAGE psp;
	psp.dwSize = sizeof(PROPSHEETPAGE);
	psp.dwFlags = PSP_USETITLE;
	psp.pszTemplate = MAKEINTRESOURCE(IDD_PP_FILE_MULTI);
	psp.pszTitle = IDS_PROP_STANDARD;
	psp.pfnDlgProc = (DLGPROC)PPFileMultiProc;
	psp.hInstance = g_hInst;
	psp.pszIcon = NULL;

	PROPSHEETHEADER psh;
	psh.dwSize = sizeof(PROPSHEETHEADER);
	psh.dwFlags = PSH_PROPSHEETPAGE | PSH_MAXIMIZE | PSH_USECALLBACK;
	psh.pfnCallback = PropSheetCallback;
	psh.nPages = 1;
	psh.nStartPage = 0;
	psh.pszIcon = NULL;
	psh.pszCaption= IDS_PROP_OBJECTS;
	psh.hwndParent = g_MainWnd.m_hWnd;
	psh.hInstance = g_hInst;
	psh.ppsp = &psp;
	wcscpy(m_szTitle, IDS_PROP_OBJECTS);

	return PropertySheet(&psh);
}

////////////////////////////////////////////////////////////////
int CFileProperty::ShowFolderProperty()
{	
	PROPSHEETPAGE psp[2];
	psp[0].dwSize = sizeof(PROPSHEETPAGE);
	psp[0].dwFlags = PSP_USETITLE;
	psp[0].pszTemplate = MAKEINTRESOURCE(IDD_PP_FILE_MAIN);
	psp[0].pszTitle = IDS_PROP_STANDARD;
	psp[0].pfnDlgProc = (DLGPROC)PPFileMainProc;
	psp[0].hInstance = g_hInst;
	psp[0].pszIcon = NULL;

	psp[1].dwSize = sizeof(PROPSHEETPAGE);
	psp[1].dwFlags = PSP_USETITLE;
	psp[1].pszTemplate = MAKEINTRESOURCE(IDD_PP_FILE_MULTI);
	psp[1].pszTitle = IDS_PROP_CONTENTS;
	psp[1].pfnDlgProc = (DLGPROC)PPFileMultiProc;
	psp[1].hInstance = g_hInst;
	psp[1].pszIcon = NULL;

	PROPSHEETHEADER psh;
	TCHAR szTemp[MAX_PATH];
	wsprintf(szTemp, IDS_FMT_PROP_OBJECT, m_lpliinfo[0].szName);
	psh.dwSize = sizeof(PROPSHEETHEADER);
	psh.dwFlags = PSH_PROPSHEETPAGE | PSH_MAXIMIZE | PSH_USECALLBACK;
	psh.pfnCallback = PropSheetCallback;
	psh.nPages = 2;
	psh.nStartPage = 0;
	psh.pszIcon = NULL;
	psh.pszCaption = szTemp;
	psh.hwndParent = g_MainWnd.m_hWnd;
	psh.hInstance = g_hInst;
	psh.ppsp = psp;
	wcscpy(m_szTitle, szTemp);

	return PropertySheet(&psh);
}

////////////////////////////////////////////////////////////////
int CFileProperty::ShowLinkProperty()
{
	wcscpy(m_szOldTarget, _T(""));
	wcscpy(m_szNewTarget, _T(""));

	PROPSHEETPAGE psp[2];
	psp[0].dwSize = sizeof(PROPSHEETPAGE);
	psp[0].dwFlags = PSP_USETITLE;
	psp[0].pszTemplate = MAKEINTRESOURCE(IDD_PP_FILE_MAIN);
	psp[0].pszTitle = IDS_PROP_STANDARD;
	psp[0].pfnDlgProc = (DLGPROC)PPFileMainProc;
	psp[0].hInstance = g_hInst;
	psp[0].pszIcon = NULL;

	psp[1].dwSize = sizeof(PROPSHEETPAGE);
	psp[1].dwFlags = PSP_USETITLE;
	psp[1].pszTemplate = MAKEINTRESOURCE(IDD_PP_FILE_SHORTCUT);
	psp[1].pszTitle = IDS_PROP_SHORTCUT;
	psp[1].pfnDlgProc = (DLGPROC)PPFileShortcutProc;
	psp[1].hInstance = g_hInst;
	psp[1].pszIcon = NULL;

	PROPSHEETHEADER psh;
	TCHAR szTemp[MAX_PATH];
	wsprintf(szTemp, IDS_FMT_PROP_OBJECT, m_lpliinfo[0].szName);
	psh.dwSize = sizeof(PROPSHEETHEADER);
	psh.dwFlags = PSH_PROPSHEETPAGE | PSH_MAXIMIZE | PSH_USECALLBACK;
	psh.pfnCallback = PropSheetCallback;
	psh.nPages = 2;
	psh.nStartPage = 0;
	psh.pszIcon = NULL;
	psh.pszCaption = szTemp;
	psh.hwndParent = g_MainWnd.m_hWnd;
	psh.hInstance = g_hInst;
	psh.ppsp = psp;
	wcscpy(m_szTitle, szTemp);

	return PropertySheet(&psh);
}

////////////////////////////////////////////////////////////////
int CFileProperty::ShowSingleProperty()
{
	PROPSHEETPAGE psp;
	psp.dwSize = sizeof(PROPSHEETPAGE);
	psp.dwFlags = PSP_USETITLE;
	psp.pszTemplate = MAKEINTRESOURCE(IDD_PP_FILE_MAIN);
	psp.pszTitle = IDS_PROP_STANDARD;
	psp.pfnDlgProc = (DLGPROC)PPFileMainProc;
	psp.hInstance = g_hInst;
	psp.pszIcon = NULL;

	PROPSHEETHEADER psh;
	TCHAR szTemp[MAX_PATH];
	wsprintf(szTemp, IDS_FMT_PROP_OBJECT, m_lpliinfo[0].szName);
	psh.dwSize = sizeof(PROPSHEETHEADER);
	psh.dwFlags = PSH_PROPSHEETPAGE | PSH_MAXIMIZE | PSH_USECALLBACK;
	psh.pfnCallback = PropSheetCallback;
	psh.nPages = 1;
	psh.nStartPage = 0;
	psh.pszIcon = NULL;
	psh.pszCaption = szTemp;
	psh.hwndParent = g_MainWnd.m_hWnd;
	psh.hInstance = g_hInst;
	psh.ppsp = &psp;
	wcscpy(m_szTitle, szTemp);

	return PropertySheet(&psh);
}

////////////////////////////////////////////////////////////////
int CFileProperty::ShowFileProperty(LPCTSTR lpszCurrentFolder, LISTITEMINFO* pliinfo, int nCount)
{
	pfp = this;

	int nRet;
	m_lpszCurrentFolder = lpszCurrentFolder;
	m_lpliinfo = pliinfo;
	m_nCount = nCount;
	if (nCount > 1)
		nRet = ShowMultiProperty();
	else
	{
		BOOL bLink = FALSE;

		//tH_̏ꍇ
		if (pliinfo[0].nItem == LIST_ITEM_FOLDER)
			nRet = ShowFolderProperty();
		else if (pliinfo[0].nItem == LIST_ITEM_FILE)
		{
			//N̏ꍇ
			TCHAR szTemp[MAX_PATH];
			wcscpy(szTemp, m_lpliinfo[0].szName);
			LPTSTR lpszExt = wcsrchr(szTemp, _T('.'));
			if (lpszExt != NULL)
			{
//				wcsupr(lpszExt);						//DEL TODA
				if (wcsicmp(lpszExt, _T(".LNK"))==0)	//MOD TODA (wcscmp -> wcsicmp)
				{
					bLink = TRUE;
					nRet = ShowLinkProperty();
				}
				else
					nRet = ShowSingleProperty();
			}
			else
				nRet = ShowSingleProperty();
		}

		if (nRet==IDOK)
		{
			BOOL bRename = TRUE;
			if (!wcslen(m_szNewName))
			{
				MessageBox(g_MainWnd.m_hWnd, IDS_MSG_NONAME, NULL, MB_OK | MB_ICONSTOP);
				bRename = FALSE;
			}

			if (g_MainWnd.m_ListView.m_Settings.bNotShowExt && m_lpliinfo[0].nItem == LIST_ITEM_FILE)
				SetExtFromFileName(m_szNewName, m_lpliinfo[0].szName);

			BOOL bRefresh = FALSE;
			TCHAR szOldPath[MAX_PATH];
			TCHAR szNewPath[MAX_PATH];
			TCHAR szTempPath[MAX_PATH];
			wsprintf(szOldPath, _T("%s\\%s"), m_lpszCurrentFolder, m_lpliinfo[0].szName);
			wsprintf(szNewPath, _T("%s\\%s"), m_lpszCurrentFolder, m_szNewName);
			wcscpy(szTempPath, _T("\\Temp\\Temp.lnk"));
			//N蒼
			if (wcscmp(m_szOldTarget, m_szNewTarget) != 0 && bLink)
			{
				if (wcslen(m_szNewTarget))
				{
					//V[gJbg蒼
					DWORD dwAttr = GetFileAttributes(szOldPath);
					SetFileAttributes(szOldPath, FILE_ATTRIBUTE_NORMAL);
					if (DeleteFile(szOldPath))
					{
						bRefresh = TRUE;
						SHCreateShortcut(szOldPath, m_szNewTarget);
						g_MainWnd.m_ListView.m_FileImageListLarge.RefreshIcon(szOldPath);
						g_MainWnd.m_ListView.m_FileImageListSmall.RefreshIcon(szOldPath);
					}
					else
						MessageBox(g_MainWnd.m_hWnd, IDS_MSG_CANNOTCHANGELINK, NULL, MB_OK | MB_ICONSTOP);
					SetFileAttributes(szOldPath, dwAttr);
				}
				else
					MessageBox(g_MainWnd.m_hWnd, IDS_MSG_NOLINKTARGET, NULL, MB_OK | MB_ICONSTOP);
			}

			//ύX
			if (m_dwOrgAttr != m_dwAttr)
			{
				if (SetFileAttributes(szOldPath, m_dwAttr))
					bRefresh = TRUE;
				else
					MessageBox(g_MainWnd.m_hWnd, IDS_MSG_CANNOTCHANGEATTR, NULL, MB_OK|MB_ICONSTOP);
			}

			if (wcscmp(m_szNewName, m_lpliinfo[0].szName)!=0 && bRename)
			{
				//O̕ύX
				if (MoveFile(szOldPath, szNewPath))
					bRefresh = TRUE;
				else
					MessageBox(g_MainWnd.m_hWnd, IDS_MSG_CANNOTCHANGENAME, NULL, MB_OK|MB_ICONSTOP);
				
			}
			pfp = NULL;
			return bRefresh;
		}
	}
	pfp = NULL;
	return 0;
}
////////////////////////////////////////////////////////////////