
//CopyDlg.cpp
#include "GSFinder.h"
#include "CopyDlg.h"

#define ID_THREAD_COPY 1

CCopyFileDlg* pcfd; 
////////////////////////////////////////////////////////////////
typedef struct _tagCopyThread
{
	int m_nCount;
	BOOL* m_pbCancel;
	BOOL m_bFileMove;
	LISTITEMINFO* m_lpliinfo;
	LPCTSTR m_lpszFolderFrom;
	LPCTSTR m_lpszFolderTo;
	HWND m_hWnd; 
}COPYTHREAD;
////////////////////////////////////////////////////////////////
CCopyFileDlg::CCopyFileDlg()
{
	m_nCount = 0;
	m_bCancel = FALSE;
	m_bFileMove = FALSE;
	m_lpliinfo = NULL;
	m_lpszFolderFrom = NULL;
	m_lpszFolderTo = NULL;
	m_hWnd = NULL; 
	m_bTimerReset = TRUE;	//ADD TODA (from GSFinder ver.1.99)
}
////////////////////////////////////////////////////////////////
BOOL CopyFileWithMessage(LPCTSTR lpszPathFrom, LPCTSTR lpszPathTo, int* lpOverWrite, HWND hDlg, BOOL bFileMove)
{
	//\
	LPTSTR lpszFileName = wcsrchr(lpszPathFrom, _T('\\'));
	if (!lpszFileName)
		lpszFileName = (LPTSTR)lpszPathFrom;
	else
		++lpszFileName;
	SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), lpszFileName);

	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(lpszPathTo, &finddata);
	if (hFind != INVALID_HANDLE_VALUE){
		FindClose(hFind);
		//t@C
		if (*lpOverWrite == RETCODE_YES || *lpOverWrite == RETCODE_NO)
		{
			SendMessage(hDlg, WM_SHOWOWMSG, (WPARAM)lpszPathTo, (LPARAM)lpszPathFrom);
			*lpOverWrite = pcfd->m_nRetCode;
		}
		if (*lpOverWrite == RETCODE_YES || *lpOverWrite == RETCODE_ALL_YES)
		{
			if (bFileMove)
			{
				SetFileAttributes(lpszPathTo, FILE_ATTRIBUTE_NORMAL);
				if (!DeleteFile(lpszPathTo))
					return FALSE;
				if (!MoveFile(lpszPathFrom, lpszPathTo))
					return FALSE;
			}
			else
			{
				SetFileAttributes(lpszPathTo, FILE_ATTRIBUTE_NORMAL);
				if (!CopyFile(lpszPathFrom, lpszPathTo, FALSE))
					return FALSE;
			}
		}
	}
	else
	{
		if (bFileMove)
		{
			if (!MoveFile(lpszPathFrom, lpszPathTo))
				return FALSE;
		}
		else
		{
			if (!CopyFile(lpszPathFrom, lpszPathTo, FALSE))
				return FALSE;
		}
	}

	TCHAR szTemp[32];
	pcfd->m_nExecCount += 1;
	wsprintf(szTemp, _T("%d/%d"), pcfd->m_nExecCount, pcfd->m_nFileCount);
	::SetWindowText(GetDlgItem(hDlg, IDC_PROG_TEXT), szTemp);
	SendMessage(GetDlgItem(hDlg, IDC_PROGRESS), PBM_SETPOS, pcfd->m_nExecCount, 0);

	return TRUE;
}

////////////////////////////////////////////////////////////////
BOOL CopyFolder(LPCTSTR lpszPathFrom, LPCTSTR lpszPathTo, BOOL* lpCancelMode, int* lpOverWrite, HWND hDlg, BOOL bFileMove)
{
	//\
	LPTSTR lpszFileName = wcsrchr(lpszPathFrom, _T('\\'));
	if (!lpszFileName)
		lpszFileName = (LPTSTR)lpszPathFrom;
	else
		++lpszFileName;
	SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), lpszFileName);

	//VtH_쐬
	if (!CreateDirectory(lpszPathTo, NULL))
	{
		//ɃtH_̏㏑mFLq
		if (*lpOverWrite == RETCODE_YES || *lpOverWrite == RETCODE_NO)
		{
			SendMessage(hDlg, WM_SHOWFOLDEROWMSG, (WPARAM)lpszPathTo, 0);
			int nRet = pcfd->m_nRetCode;
			if (nRet == IDCANCEL)
				return TRUE;
		}
		if (*lpOverWrite == RETCODE_ALL_NO)
			return TRUE;
	}

	//ړtH_̃t@C
	TCHAR szTemp[MAX_PATH+4];
	wsprintf(szTemp, _T("%s\\*.*"), lpszPathFrom);
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do
		{
			if (*lpCancelMode)
			{
				FindClose(hFind);
				return TRUE;
			}		
			if (finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
				//tH_
				LPTSTR lpszFrom = new TCHAR[wcslen(lpszPathFrom)+wcslen(finddata.cFileName)+2];
				LPTSTR lpszTo = new TCHAR[wcslen(lpszPathTo)+wcslen(finddata.cFileName)+2];
				wsprintf(lpszFrom, _T("%s\\%s"), lpszPathFrom, finddata.cFileName);
				wsprintf(lpszTo, _T("%s\\%s"), lpszPathTo, finddata.cFileName);
				if (!CopyFolder(lpszFrom, lpszTo, lpCancelMode, lpOverWrite, hDlg, bFileMove))
				{
					FindClose(hFind);
					delete[] lpszFrom;
					delete[] lpszTo;
					return FALSE;
				}
				delete[] lpszFrom;
				delete[] lpszTo;
			}else
			{
				//t@C
				LPTSTR lpszFrom = new TCHAR[wcslen(lpszPathFrom)+wcslen(finddata.cFileName)+2];
				LPTSTR lpszTo = new TCHAR[wcslen(lpszPathTo)+wcslen(finddata.cFileName)+2];
				wsprintf(lpszFrom, _T("%s\\%s"), lpszPathFrom, finddata.cFileName);
				wsprintf(lpszTo, _T("%s\\%s"), lpszPathTo, finddata.cFileName);
				if (!CopyFileWithMessage(lpszFrom, lpszTo, lpOverWrite, hDlg, bFileMove))
				{
					FindClose(hFind);
					delete[] lpszFrom;
					delete[] lpszTo;
					return FALSE;
				}
				delete[] lpszFrom;
				delete[] lpszTo;
			}
		}
		while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}
	if (bFileMove)
		RemoveDirectory(lpszPathFrom);

	pcfd->m_nExecCount += 1;
	wsprintf(szTemp, _T("%d/%d"), pcfd->m_nExecCount, pcfd->m_nFileCount);
	::SetWindowText(GetDlgItem(hDlg, IDC_PROG_TEXT), szTemp);
	SendMessage(GetDlgItem(hDlg, IDC_PROGRESS), PBM_SETPOS, pcfd->m_nExecCount, 0);

	return TRUE;
}

////////////////////////////////////////////////////////////////
DWORD WINAPI CopyFileThread(LPVOID pParam)
{
	COPYTHREAD* pct = (COPYTHREAD*)pParam;

	int nOverWrite = RETCODE_YES;

//DEL START TODA
//	//\̍XV
//	TCHAR szTemp[MAX_PATH+4];
//	TCHAR szFrom[MAX_PATH];
//	TCHAR szTo[MAX_PATH];
//	LPTSTR lpszTemp = wcsrchr(pct->m_lpszFolderFrom, _T('\\'));
//	if (lpszTemp)
//		wcscpy(szFrom, ++lpszTemp);
//	else
//		wcscpy(szFrom, _T("\\"));
//
//	lpszTemp = wcsrchr(pct->m_lpszFolderTo, _T('\\'));
//	if (lpszTemp)
//		wcscpy(szTo, ++lpszTemp);
//	else
//		wcscpy(szTo, _T("\\"));
//
//	wsprintf(szTemp, IDS_FMT_FROMTO, szFrom, szTo);
//	SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FOLDER), szTemp);
//DEL END

	//Rs[Jn
	UINT nFileCount = 0;
	for (int i=0; i<pct->m_nCount; i++)
	{
		//LZ`FbN
		if (*pct->m_pbCancel)
		{
//MOD START GORIPON
			//::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), IDS_MSG_CANCELED);
			LPTSTR lpszText = DupStringTable(IDS_MSG_CANCELED);
			::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), lpszText);
			FreeStringTable(lpszText);
//MOD END
			::SendMessage(pct->m_hWnd, WM_DLGCLOSE, 0, 0);
			ExitThread(0);
			return 0;
		}

		//ADD START TODA
		//\̍XV
		TCHAR szTemp[MAX_PATH+4];
		TCHAR szFrom[MAX_PATH];
		TCHAR szTo[MAX_PATH];
		LPTSTR lpszTemp = wcsrchr(pct->m_lpliinfo[i].szPath, _T('\\'));
		if (lpszTemp)
			wcscpy(szFrom, ++lpszTemp);
		else
			wcscpy(szFrom, _T("\\"));

		lpszTemp = wcsrchr(pct->m_lpszFolderTo, _T('\\'));
		if (lpszTemp)
			wcscpy(szTo, ++lpszTemp);
		else
			wcscpy(szTo, _T("\\"));
		
//MOD START GORIPON
		//wsprintf(szTemp, IDS_FMT_FROMTO, szFrom, szTo);
		wsprintf(szTemp, GetStringTable(IDS_FMT_FROMTO), szFrom, szTo);
//MOD END
		SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FOLDER), szTemp);
		//ADD END

//MOD START TODA (pct->m_lpszFolderFrom -> pct->m_lpliinfo[i].szPath)
		// t@C̐ݒ
		wsprintf(szFrom, _T("%s\\%s"), pct->m_lpliinfo[i].szPath, pct->m_lpliinfo[i].szName);
		if (wcscmp(pct->m_lpliinfo[i].szPath, pct->m_lpszFolderTo) == 0)
		{
			// Rs[ƃRs[悪
//MOD START GORIPON
			//wsprintf(szTo, IDS_FMT_COPY_NAME1, pct->m_lpszFolderTo, pct->m_lpliinfo[i].szName);
			wsprintf(szTo, GetStringTable(IDS_FMT_COPY_NAME1), pct->m_lpszFolderTo, pct->m_lpliinfo[i].szName);
//MOD END
			if (GetFileAttributes(szTo) != 0xFFFFFFFF)
			{
				for (int n = 2; n < 512; n++)		//MOD START TODA (from GSFinder ver.1.99)
				{
//MOD START GORIPON
					//wsprintf(szTo, IDS_FMT_COPY_NAME2, pct->m_lpszFolderTo, n, pct->m_lpliinfo[i].szName);
					wsprintf(szTo, GetStringTable(IDS_FMT_COPY_NAME2), pct->m_lpszFolderTo, n, pct->m_lpliinfo[i].szName);
//MOD END
					if (GetFileAttributes(szTo) == 0xFFFFFFFF)
						break;
				}
			}
		}
//MOD END
		else
			wsprintf(szTo, _T("%s\\%s"), pct->m_lpszFolderTo, pct->m_lpliinfo[i].szName);

		//ۂ̃Rs[
		if (pct->m_lpliinfo[i].nItem == LIST_ITEM_FOLDER)
		{
			//tH_̃Rs[
			if (!CopyFolder(szFrom, szTo, pct->m_pbCancel, &nOverWrite, pct->m_hWnd, pct->m_bFileMove))
			{
				SendMessage(pct->m_hWnd, WM_SHOWERRMSG, (WPARAM)pct->m_lpliinfo[i].szName, 0);
//MOD START GORIPON
				//::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), IDS_MSG_CANCELED);
				LPTSTR lpszText = DupStringTable(IDS_MSG_CANCELED);
				::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), lpszText);
				FreeStringTable(lpszText);
//MOD END
				::SendMessage(pct->m_hWnd, WM_DLGCLOSE, 0, 0);
				ExitThread(0);
				return 0;
			}
		}
		else if (pct->m_lpliinfo[i].nItem == LIST_ITEM_FILE)
		{
			//t@C̃Rs[
			if (!CopyFileWithMessage(szFrom, szTo, &nOverWrite, pct->m_hWnd, pct->m_bFileMove))
			{
				SendMessage(pct->m_hWnd, WM_SHOWERRMSG, (WPARAM)pct->m_lpliinfo[i].szName, 0);
//MOD START GORIPON
				//::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), IDS_MSG_CANCELED);
				LPTSTR lpszText = DupStringTable(IDS_MSG_CANCELED);
				::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), lpszText);
				FreeStringTable(lpszText);
//MOD END
				::SendMessage(pct->m_hWnd, WM_DLGCLOSE, 0, 0);
				ExitThread(0);
				return 0;
			}
		}

		if (nOverWrite == RETCODE_ALL_NO)
		{
//MOD START GORIPON
			//::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), IDS_MSG_CANCELED);
			LPTSTR lpszText = DupStringTable(IDS_MSG_CANCELED);
			::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), lpszText);
			FreeStringTable(lpszText);
//MOD END
			::SendMessage(pct->m_hWnd, WM_DLGCLOSE, 0, 0);
			ExitThread(0);
			return 0;
		}
	}
//MOD START GORIPON
	//::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), IDS_MSG_DONE);
	LPTSTR lpszText = DupStringTable(IDS_MSG_DONE);
	::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), lpszText);
	FreeStringTable(lpszText);
//MOD END
	::SendMessage(pct->m_hWnd, WM_DLGCLOSE, 0, 0);
	ExitThread(0);
	return 0;
}

////////////////////////////////////////////////////////////////
void CCopyFileDlg::OnInitDialog(HWND hDlg)
{
	TCHAR szTemp[32];
	m_bCancel = FALSE;
	m_nExecCount = 0;
	m_hWnd = hDlg;

	CenterWindow(hDlg);

	if (m_bFileMove)
	{
//MOD START GORIPON
		//SetWindowText(hDlg, IDS_MSG_MOVING);
		//SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), IDS_MSG_PREP_MOVE);
		LPTSTR lpszText = DupStringTable(IDS_MSG_MOVING);
		SetWindowText(hDlg, lpszText);
		FreeStringTable(lpszText);
		lpszText = DupStringTable(IDS_MSG_PREP_MOVE);
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), lpszText);
		FreeStringTable(lpszText);
//MOD END
	}
	else
	{
//MOD START GORIPON
		//SetWindowText(hDlg, IDS_MSG_COPYING);
		//SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), IDS_MSG_PREP_COPY);
		LPTSTR lpszText = DupStringTable(IDS_MSG_COPYING);
		SetWindowText(hDlg, lpszText);
		FreeStringTable(lpszText);
		lpszText = DupStringTable(IDS_MSG_PREP_COPY);
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), lpszText);
		FreeStringTable(lpszText);
//MOD END
	}

	m_nFileCount = GetFileAndFolderCount(m_lpszFolderFrom, m_lpliinfo, m_nCount);
	SendMessage(GetDlgItem(hDlg, IDC_PROGRESS), PBM_SETRANGE, 0, MAKELPARAM(0, m_nFileCount));
	wsprintf(szTemp, _T("0/%d"), m_nFileCount);
	SetWindowText(GetDlgItem(hDlg, IDC_PROG_TEXT), szTemp);

	ShowWindow(hDlg, SW_SHOW);

	static COPYTHREAD CopyThread;
	CopyThread.m_nCount = m_nCount;
	CopyThread.m_pbCancel = &m_bCancel;
	CopyThread.m_bFileMove = m_bFileMove;
	CopyThread.m_lpliinfo = m_lpliinfo;
	CopyThread.m_lpszFolderFrom = m_lpszFolderFrom;
	CopyThread.m_lpszFolderTo = m_lpszFolderTo;
	CopyThread.m_hWnd = m_hWnd;

#ifndef __WCEEMULATION
	m_hThread = CreateThread(NULL, 0, CopyFileThread, (LPVOID)&CopyThread, 0, &m_dwThreadID);
#else
	EndDialog(hDlg, 0);
#endif
}

////////////////////////////////////////////////////////////////
LRESULT CALLBACK CopyFileDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{
			pcfd->OnInitDialog(hDlg);
			//ADD START TODA (from GSFinder ver.1.99)
			SetTimer(hDlg, ID_TIMER_RESETTIME, TIMER_RESETTIME_INT, NULL);
			//ADD END
			return TRUE;
		}
		case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam);
			int wmEvent = HIWORD(wParam); 
			switch (wmId)
			{
				case IDC_CANCELMODE:
				{
					pcfd->m_bCancel = TRUE;
					EnableWindow(GetDlgItem(hDlg, IDC_CANCELMODE), FALSE);
//MOD START GORIPON
					//SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), IDS_MSG_CANCELING);
					LPTSTR lpszText = DupStringTable(IDS_MSG_CANCELING);
					SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), lpszText);
					FreeStringTable(lpszText);
//MOD END
					return TRUE;
				}
			}
			break;
		}
		case WM_DLGCLOSE:
		{
			CloseHandle(pcfd->m_hThread);
			//ADD START TODA (from GSFinder ver.1.99)
			KillTimer(hDlg, ID_TIMER_RESETTIME);
			//ADD END
			EndDialog(hDlg, 0);
			return TRUE;
		}
		case WM_SHOWOWMSG:
		{
			pcfd->ShowOverWriteMessage((LPTSTR)wParam, (LPTSTR)lParam);
			return TRUE;
		}
		case WM_SHOWERRMSG:
		{
			pcfd->ShowErrorMessage((LPTSTR)wParam);
			return TRUE;
		}
		case WM_SHOWFOLDEROWMSG:
		{
			pcfd->ShowFolderOverWriteMessage((LPTSTR)wParam);
			return TRUE;
		}
		//ADD START TODA (from GSFinder ver.1.99)
		case WM_TIMER:
		{
			if (wParam == ID_TIMER_RESETTIME && pcfd->m_bTimerReset)
				SystemIdleTimerReset();
			return TRUE;
		}
		//ADD END
	}
	return FALSE;
}
////////////////////////////////////////////////////////////////
int CCopyFileDlg::ShowCopyFileDlg(LPCTSTR lpszFolderFrom, LPCTSTR lpszFolderTo, LISTITEMINFO* lpliinfo, int nCount, BOOL bFileMove)
{
	m_lpszFolderFrom = lpszFolderFrom;
	m_lpszFolderTo = lpszFolderTo;
	m_lpliinfo = lpliinfo;
	m_nCount = nCount;
	m_bFileMove = bFileMove;

//DEL START TODA
//	// ړƈړꍇ
//	if (m_bFileMove && wcscmp(m_lpszFolderFrom, m_lpszFolderTo) == 0)
//	{
//		MessageBox(g_MainWnd.m_hWnd, IDS_MSG_CANNOTMOVE, NULL, MB_OK|MB_ICONSTOP);
//		return IDCANCEL;
//	}
//DE END
	//ADD START TODA
	//t@Cړ
	if(m_bFileMove)
	{
		//Xgɐݒ肳ĂpXSă`FbN
		for(int i = 0; i < m_nCount; i++)
		{
			if (wcscmp(m_lpliinfo[i].szPath, m_lpszFolderTo) == 0)
			{
//MOD START GORIPON
				//MessageBox(g_MainWnd.m_hWnd, IDS_MSG_CANNOTMOVE, NULL, MB_OK|MB_ICONSTOP);
				MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_CANNOTMOVE), NULL, MB_OK|MB_ICONSTOP);
//MOD END
				return IDCANCEL;
			}
		} //End of for
	}
	//ADD END

	//TutH_`FbNs
	for (int i=0; i<m_nCount; i++)
	{
		if (m_lpliinfo[i].nItem == LIST_ITEM_FOLDER)
		{
			TCHAR szFrom[MAX_PATH];
			TCHAR szTo[MAX_PATH];

			//ADD START TODA (WindowspX`FbN)
			wsprintf(szFrom, _T("%s\\%s"), m_lpliinfo[i].szPath, m_lpliinfo[i].szName);
			if(wcsicmp(g_MainWnd.m_szWindowsPath, szFrom) == 0)
			{
//MOD START GORIPON
				//MessageBox(g_MainWnd.m_hWnd, IDS_MSG_PASTEERROR3, NULL, MB_OK|MB_ICONSTOP);
				MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_PASTEERROR3), NULL, MB_OK|MB_ICONSTOP);
//MOD END
				return IDCANCEL;
			}
			//ADD END

			//MOD START TODA
//			wsprintf(szFrom, _T("%s\\%s\\"), m_lpszFolderFrom, m_lpliinfo[i].szName);
			wsprintf(szFrom, _T("%s\\%s\\"), m_lpliinfo[i].szPath, m_lpliinfo[i].szName);
			//MOD END
			wsprintf(szTo, _T("%s\\"), m_lpszFolderTo);
			wcsupr(szFrom);
			wcsupr(szTo);
			if (wcsncmp(szFrom, szTo, wcslen(szFrom))==0)
			{
//MOD START GORIPON
				//if (m_bFileMove)
				//	MessageBox(g_MainWnd.m_hWnd, IDS_MSG_CANNOTMOVE, NULL, MB_OK|MB_ICONSTOP);
				//else
				//	MessageBox(g_MainWnd.m_hWnd, IDS_MSG_CANNOTCOPY, NULL, MB_OK|MB_ICONSTOP);
				MessageBox(g_MainWnd.m_hWnd,
					GetStringTable(m_bFileMove?IDS_MSG_CANNOTMOVE:IDS_MSG_CANNOTCOPY),
					NULL, MB_OK|MB_ICONSTOP);
//MOD END
				return IDCANCEL;
			}
		}
	}
	pcfd = this;
	DisableUpdateNotify();				//ADD TODA (t@CύXʒm from Y.Nagamidori)
	DialogBox(g_hInst, (LPCTSTR)IDD_FILECOPY_DLG, g_MainWnd.m_hWnd, (DLGPROC)CopyFileDlgProc);
	EnableUpdateNotify();				//ADD TODA (t@CύXʒm from Y.Nagamidori)

	pcfd = NULL;

	return IDOK;
}
////////////////////////////////////////////////////////////////
LRESULT CALLBACK OverWriteDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{
			TCHAR szOldFilePath[MAX_PATH];
			TCHAR szNewFilePath[MAX_PATH];
			wcscpy(szOldFilePath, pcfd->m_lpszwParam);
			wcscpy(szNewFilePath, pcfd->m_lpszlParam);

			pcfd->m_nRetCode = RETCODE_NO;

			LPTSTR lpszFileName = wcsrchr(szOldFilePath, _T('\\'));
			if (lpszFileName)
				lpszFileName++;
			else
				lpszFileName = szOldFilePath;

			TCHAR szTemp[MAX_PATH];
			DWORD dwAttr = GetFileAttributes(szOldFilePath);
//MOD START GORIPON
			//if ((dwAttr&FILE_ATTRIBUTE_SYSTEM)==FILE_ATTRIBUTE_SYSTEM)
			//	wsprintf(szTemp, IDS_FMT_OW_SYSTEM, lpszFileName);
			//else if ((dwAttr&FILE_ATTRIBUTE_READONLY)==FILE_ATTRIBUTE_READONLY)
			//	wsprintf(szTemp, IDS_FMT_OW_READONLY, lpszFileName);
			//else
			//	wsprintf(szTemp, IDS_FMT_OW_FILE, lpszFileName);
			if ((dwAttr&FILE_ATTRIBUTE_SYSTEM)==FILE_ATTRIBUTE_SYSTEM)
				wsprintf(szTemp, GetStringTable(IDS_FMT_OW_SYSTEM), lpszFileName);
			else if ((dwAttr&FILE_ATTRIBUTE_READONLY)==FILE_ATTRIBUTE_READONLY)
				wsprintf(szTemp, GetStringTable(IDS_FMT_OW_READONLY), lpszFileName);
			else
				wsprintf(szTemp, GetStringTable(IDS_FMT_OW_FILE), lpszFileName);
//MOD END			
			SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), szTemp);

			//Old
			TCHAR szSize[64];
			SHFILEINFO shfi;
			SHGetFileInfo(szOldFilePath, NULL, &shfi, sizeof(shfi), SHGFI_LARGEICON | SHGFI_ICON);
			SendMessage(GetDlgItem(hDlg, IDC_OLD_ICON), STM_SETIMAGE, IMAGE_ICON, (LPARAM)shfi.hIcon);

			HANDLE hFile = CreateFile(szOldFilePath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL);
			wsprintf(szSize, _T("%d"), GetFileSize(hFile, NULL));
			SetFormatInteger(szSize, 64);
//MOD START GORIPON
			//wsprintf(szTemp, IDS_FMT_SIZEBYTE, szSize);
			wsprintf(szTemp, GetStringTable(IDS_FMT_SIZEBYTE), szSize);
//MOD END
			SetWindowText(GetDlgItem(hDlg, IDC_OLD_SIZE), szTemp);

			TCHAR szTime[64];
			SYSTEMTIME st;
			FILETIME ft;
			GetFileTime(hFile, NULL, NULL, &ft);
			FileTimeToLocalFileTime(&ft, &ft);
			FileTimeToSystemTime(&ft, &st);
			SetFormatDateTime(&st, szTime, 64);
//MOD START GORIPON
			//wsprintf(szTemp, IDS_FMT_UPDATETIME, szTime);
			wsprintf(szTemp, GetStringTable(IDS_FMT_UPDATETIME), szTime);
//MOD END
			SetWindowText(GetDlgItem(hDlg, IDC_OLD_TIME), szTemp);
			CloseHandle(hFile);

			//New
			SHGetFileInfo(szNewFilePath, NULL, &shfi, sizeof(shfi), SHGFI_LARGEICON | SHGFI_ICON);
			SendMessage(GetDlgItem(hDlg, IDC_NEW_ICON), STM_SETIMAGE, IMAGE_ICON, (LPARAM)shfi.hIcon);

			hFile = CreateFile(szNewFilePath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL); 
			wsprintf(szSize, _T("%d"), GetFileSize(hFile, NULL));
			SetFormatInteger(szSize, 64);
//MOD START GORIPON
			//wsprintf(szTemp, IDS_FMT_SIZEBYTE, szSize);
			wsprintf(szTemp, GetStringTable(IDS_FMT_SIZEBYTE), szSize);
//MOD END
			SetWindowText(GetDlgItem(hDlg, IDC_NEW_SIZE), szTemp);

			GetFileTime(hFile, NULL, NULL, &ft);
			FileTimeToLocalFileTime(&ft, &ft);
			FileTimeToSystemTime(&ft, &st);
			SetFormatDateTime(&st, szTime, 64);
//MOD START GORIPON
			//wsprintf(szTemp, IDS_FMT_UPDATETIME, szTime);
			wsprintf(szTemp, GetStringTable(IDS_FMT_UPDATETIME), szTime);
//MOD END
			SetWindowText(GetDlgItem(hDlg, IDC_NEW_TIME), szTemp);

			CloseHandle(hFile);

			CenterWindow(hDlg);
			ShowWindow(hDlg, SW_SHOW);
			SetForegroundWindow(hDlg);

			return TRUE;
		}
		case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam); 
			int wmEvent = HIWORD(wParam); 
			switch (wmId)
			{
				case IDC_BTN_YES:
				{
					pcfd->m_nRetCode = RETCODE_YES;
					EndDialog(hDlg, IDOK);
					return TRUE;
				}
				case IDC_BTN_NO:
				{
					pcfd->m_nRetCode = RETCODE_NO;
					EndDialog(hDlg, IDCANCEL);
					return TRUE;
				}
				case IDC_BTN_ALL_YES:
				{
					pcfd->m_nRetCode = RETCODE_ALL_YES;
					EndDialog(hDlg, IDOK);
					return TRUE;
				}
				case IDC_BTN_ALL_NO:
				{
					pcfd->m_nRetCode = RETCODE_ALL_NO;
					EndDialog(hDlg, IDCANCEL);
					return TRUE;
				}
			}
		}
		case WM_CLOSE:
		{
			pcfd->m_nRetCode = RETCODE_NO;
			EndDialog(hDlg, IDCANCEL);
			return TRUE;
		}
	}
	return FALSE;
}
////////////////////////////////////////////////////////////////
int CCopyFileDlg::ShowOverWriteMessage(LPTSTR lpszwParam, LPTSTR lpszlParam)
{
	m_lpszwParam = lpszwParam;
	m_lpszlParam = lpszlParam;
	m_bTimerReset = FALSE;		//ADD TODA (from GSFinder ver.1.99)
	DialogBox(g_hInst, (LPCTSTR)IDD_OVERWRITE_DLG, m_hWnd, (DLGPROC)OverWriteDlgProc);
	m_bTimerReset = TRUE;		//ADD TODA (from GSFinder ver.1.99)
	return m_nRetCode;
}

void CCopyFileDlg::ShowErrorMessage(LPTSTR lspzFileName)
{
	TCHAR szTemp[128];
//MOD START GORIPON
	//wsprintf(szTemp, IDS_FMT_COPYERROR, lspzFileName);
	wsprintf(szTemp, GetStringTable(IDS_FMT_COPYERROR), lspzFileName);
//MOD END
	MessageBox(m_hWnd, szTemp, NULL, MB_OK|MB_ICONSTOP);
}


////////////////////////////////////////////////////////////////
LRESULT CALLBACK FolderOverWriteDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{
			TCHAR szChild[MAX_PATH] = {0};
			TCHAR szParent[MAX_PATH] = {0};

			LPTSTR lpszTemp = wcsrchr(pcfd->m_lpszwParam, _T('\\'));
			if (lpszTemp)
			{
				wcsncpy(szParent, pcfd->m_lpszwParam, lpszTemp - pcfd->m_lpszwParam);
				wcscpy(szChild, ++lpszTemp);
			}
			else
			{
				wcscpy(szParent, pcfd->m_lpszwParam);
				wcscpy(szChild, GetRootName());
			}

			lpszTemp = wcsrchr(szParent, _T('\\'));
			if (lpszTemp)
				wcscpy(szParent, ++lpszTemp);
			else
				wcscpy(szParent, GetRootName());

			TCHAR szTemp[MAX_PATH];
//MOD START GORIPON
			//wsprintf(szTemp, IDS_FMT_OW_FOLDER, szParent, szChild);
			wsprintf(szTemp, GetStringTable(IDS_FMT_OW_FOLDER), szParent, szChild);
//MOD END
			SetWindowText(GetDlgItem(hDlg, IDC_FOLDER_TEXT), szTemp);
			
			CenterWindow(hDlg);
			ShowWindow(hDlg, SW_SHOW);
			SetForegroundWindow(hDlg);
			return TRUE;
		}
		case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam); 
			int wmEvent = HIWORD(wParam); 
			switch (wmId)
			{
				case IDYES:
				{
					pcfd->m_nRetCode = IDOK;
					EndDialog(hDlg, IDOK);
					return TRUE;
				}
				case IDNO:
				{
					pcfd->m_nRetCode = IDCANCEL;
					EndDialog(hDlg, IDCANCEL);
					return TRUE;
				}
			}
		}
		case WM_CLOSE:
		{
			pcfd->m_nRetCode = IDCANCEL;
			EndDialog(hDlg, IDCANCEL);
			return TRUE;
		}
	}
	return FALSE;
}

int CCopyFileDlg::ShowFolderOverWriteMessage(LPTSTR lpszwParam)
{
	m_lpszwParam = lpszwParam;
	m_bTimerReset = FALSE;		//ADD TODA (from GSFinder ver.1.99)
	DialogBox(g_hInst, (LPCTSTR)IDD_FOLDER_OVERWRITE_DLG, m_hWnd, (DLGPROC)FolderOverWriteDlgProc);
	m_bTimerReset = TRUE;		//ADD TODA (from GSFinder ver.1.99)
	return m_nRetCode;
}