///////////////////////////////////////////////////////////////
//FileSearch.cpp
//t@Cݒ/t@C

///////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "FileSearch.h"
#include "FolderDlgPPC.h"
///////////////////////////////////////////////////////////////
//O[oϐ
//CFileSearch		*g_pfsch;	//DEL GORIPON

///////////////////////////////////////////////////////////////
//񌟍(ChJ[ĥݑΉ)
BOOL StrStr(LPTSTR lpszData, LPTSTR lpszWord, BOOL bUpr)
{
	LPTSTR lpszDataPos = lpszData;
	LPTSTR lpszWordPos = lpszWord;

	TCHAR szDataTemp[MAX_PATH] = _T("");
	TCHAR szWordTemp[MAX_PATH] = _T("");

	//qʖ
	if(!bUpr)
	{
		//啶ɕϊ
		wcscpy(szDataTemp, lpszDataPos);
		wcsupr(szDataTemp);
		lpszDataPos = szDataTemp;
		//wcscpy(szWordTemp, lpszWordPos);
		//wcsupr(szWordTemp);
		//lpszWordPos = szWordTemp;
	}

	//Jn(ȂȂ܂)
	while(*lpszWordPos)
	{
		if(*lpszWordPos == _T('*'))
		{
			lpszWordPos++;
		}
		else if(!(*lpszDataPos))
		{
			break;
		}
		else
		{
			if(*lpszWordPos == _T('?'))
			{
				lpszWordPos++;
				lpszDataPos++;
			}
			else
			{
				//̏I[mF
				LPTSTR lpszEnd = wcschr(lpszWordPos, _T('*'));
				if(!lpszEnd)
					lpszEnd = wcschr(lpszWordPos, _T('?'));

				//`FbN쐬
				TCHAR szBuf[MAX_PATH];
				int nLen = (lpszEnd?lpszEnd-lpszWordPos:wcslen(lpszWordPos));
				wcsncpy(szBuf, lpszWordPos, nLen);
				szBuf[nLen] = 0x00;
			
				//`FbN
				LPTSTR lpszTemp = wcsstr(lpszDataPos, szBuf);
				
				//Ɏs(sv)
				if(!lpszTemp) return FALSE;

				//`FbN̏ꍇ(㑱)
				lpszWordPos += nLen;
				lpszDataPos = lpszTemp + nLen;
			}
		}

	} //End of while

	if(*lpszWordPos) return FALSE;
	return TRUE;
}

///////////////////////////////////////////////////////////////
//t@C`FbN
BOOL TextCheck(LPTSTR lpszPath, LPTSTR lpszName, DWORD dwSize, LPTSTR lpszWord, BOOL bUpr)
{
	TCHAR szPath[MAX_PATH];

	//pX쐬
	if(wcslen(lpszPath))
		wsprintf(szPath, _T("%s\\%s"), lpszPath, lpszName);
	else
		wsprintf(szPath, _T("\\%s"), lpszName);

	//t@CI[v
	HANDLE hFile = CreateFile(szPath, GENERIC_READ, 0, NULL,
				OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	
	//I[vɎs
	if(INVALID_HANDLE_VALUE == hFile) return FALSE;

	//obt@쐬
	int nWordLen = wcslen(lpszWord)*2+1;
	char *szWordBuf1 = new char[nWordLen];
	char *szWordBuf2 = new char[nWordLen];
	
	//ϊ(Unicode->S-JIS)
	memset(szWordBuf1, 0x00, nWordLen);
	memset(szWordBuf2, 0x00, nWordLen);
	wcstombs(szWordBuf1, lpszWord, nWordLen);
	wcstombs(szWordBuf2, lpszWord, nWordLen);

	//啶ʖ
	if(!bUpr)
	{
		_strupr(szWordBuf1);
		_strlwr(szWordBuf2);
	}

	//t@C̓ǂݍ݁`FbN
	DWORD dwLen=0;
	char *pchk1 = szWordBuf1;
	char *pchk2 = szWordBuf2;
	BOOL bChk=FALSE;
	while(!bChk)
	{
		DWORD dwRead;
		char szDataBuf[4096];
		memset(szDataBuf, 0x00, sizeof(szDataBuf));

		//t@C̓ǂݍ
		dwRead = 0;
		if(!ReadFile(hFile, &szDataBuf, sizeof(szDataBuf), &dwRead, 0) || !dwRead)
			break;

		//obt@e1oCgÂ`FbN
		for(DWORD i=0; i<dwRead && !bChk; i++)
		{
			//擪1oCĝݔr
			if(!bUpr)
			{
				if((*pchk1) != szDataBuf[i] &&
				   (*pchk2) != szDataBuf[i]) continue;
			}
			else
				if((*pchk1) != szDataBuf[i]) continue;
			
			//`FbN郌OXZo
			DWORD nLen = strlen(pchk1);
			if(nLen > (dwRead-i))
				nLen = dwRead-i;
				
			//召ʖ
			if(!bUpr)
			{
				//`FbN
				for(DWORD j=0; j<nLen; j++)
				{
					bChk = TRUE;
					//召ÂꂩvȂꍇ
					if((*pchk1) != szDataBuf[i+j] &&
					   (*pchk2) != szDataBuf[i+j]) {
						pchk1 = szWordBuf1;
						pchk2 = szWordBuf2;
						bChk = FALSE;
						break;
					}
					pchk1++;
					pchk2++;

				} //End of for
			}
			//召ʗL
			else
			{
				//`FbN
				if(memcmp(pchk1, &szDataBuf[i], nLen) == 0)
				{
					pchk1 += nLen;
					bChk = TRUE;
					break;
				} else {
					pchk1 = szWordBuf1;
				}
			}

		} //End of for

		//JE^XV
		dwLen += dwRead;
	
	} //End of for

	//obt@폜
	delete[] szWordBuf1;
	delete[] szWordBuf2;

	//t@CN[Y
	CloseHandle(hFile);
	return bChk;
}

///////////////////////////////////////////////////////////////
//EBhEX^Cݒ
LONG SetWindowStyle(HWND hWnd, LONG style, BOOL Add) {
	LONG				src;
	LONG				n;
	src = GetWindowLong(hWnd, GWL_STYLE);
	if(Add) {
		n = src | style;
	} else {
		n = src & ~style;
	}
	SetWindowLong(hWnd, GWL_STYLE, n);
	return n;
}

///////////////////////////////////////////////////////////////
//EBhEvV[W
LRESULT CALLBACK FileSearchProc(
		HWND hDlg,
		UINT message,
		WPARAM wParam,
		LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
//MOD START GORIPON
			//DialogBoxParamœnꂽCAssociatioñCX^XUSERDATAɊi[
			SetWindowLong(hDlg,GWL_USERDATA,lParam);
			((CFileSearch*)(lParam))->m_hWnd = hDlg;
			((CFileSearch*)(lParam))->OnInit();
			break;
//MOD END
		case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam);
			int wmEvent = HIWORD(wParam);
			switch(wmId)
			{
				//t`FbN{^
				case IDC_CHK_DATE:
					((CFileSearch*)GetWindowLong(hDlg,GWL_USERDATA))->OnChkDateChange();	//MOD GORIPON
					break;
				//TCY`FbN{^
				case IDC_CHK_SIZE:
					((CFileSearch*)GetWindowLong(hDlg,GWL_USERDATA))->OnChkSizeChange();	//MOD GORIPON
					break;
				//Qƃ{^
				case IDC_BTN_BROWSE:
					((CFileSearch*)GetWindowLong(hDlg,GWL_USERDATA))->OnBrowse();	//MOD GORIPON
					break;
				//OK{^
				case IDOK:
					ShowWindow(hDlg, SW_HIDE);
					((CFileSearch*)GetWindowLong(hDlg,GWL_USERDATA))->OnOK();	//MOD GORIPON
					break;
				//tʕύX
				case IDC_COMB_DATE:
					((CFileSearch*)GetWindowLong(hDlg,GWL_USERDATA))->OnCombDateChange();	//MOD GORIPON
					break;
				//TCYʕύX
				case IDC_COMB_SIZE:
					((CFileSearch*)GetWindowLong(hDlg,GWL_USERDATA))->OnCombSizeChange();	//MOD GORIPON
					break;
				//LZ{^
				case IDCANCEL:
				{
					EndDialog(hDlg, (INT)FALSE);
					return TRUE;
				}
			}
			break;
		}
		case WM_DLGCLOSE:
		{
			//SIPN[Y
			SipShowIM(SIPF_OFF);
//MOD START GORIPON
			EndDialog(hDlg, ((CFileSearch*)GetWindowLong(hDlg,GWL_USERDATA))->OnFileSerch());
//MOD END
			break;
		}
		case WM_PAINT:
			return DefDlgPaintProc(hDlg, wParam, lParam);
		case WM_CTLCOLORSTATIC:
			return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);
	}
	return FALSE;
}

///////////////////////////////////////////////////////////////
//RXgN^
CFileSearch::CFileSearch(HWND hWnd, HINSTANCE hInst, LPTSTR lpszPath)
{
	//g_pfsch = this;	//DEL GORIPON

	//p[^̕ۑ
	m_hparWnd = hWnd;
	m_hInst = hInst;
	if(lpszPath)
		wcscpy(m_szCurrent, lpszPath);
	else
		m_szCurrent[0]=0x00;

	//Rg[̏
	InitCommonControls();

	//twRg[̏
	INITCOMMONCONTROLSEX ctl;
	ctl.dwSize = sizeof(ctl);
	ctl.dwICC = ICC_DATE_CLASSES;
	InitCommonControlsEx(&ctl);

	//oϐ̏
	m_ListView = &g_MainWnd.m_ListView;
}

///////////////////////////////////////////////////////////////
//fXgN^
CFileSearch::~CFileSearch()
{
}

///////////////////////////////////////////////////////////////
//EBhEI[v
int CFileSearch::Open()
{
//DEL START GORIPON
//	//SIPI[v
//	BOOL bSetSip = FALSE;
//	SIPINFO si;
//	memset(&si, 0, sizeof(SIPINFO));
//	si.cbSize = sizeof(SIPINFO);
//	SipGetInfo(&si);
//	if ((si.fdwFlags&SIPF_ON)!=SIPF_ON)
//	{
//		SipShowIM(SIPF_ON);
//		bSetSip = TRUE;
//	}
//DEL END
	//EBhE쐬
//MOD START GORIPON
	int rtn =  DialogBoxParam(m_hInst, (LPCTSTR)IDD_SEARCH_DLG,
				m_hparWnd, (DLGPROC)FileSearchProc, LPARAM(this));
//MOD END
	//SIPN[Y
	//if (bSetSip)	//DEL GORIPON
		SipShowIM(SIPF_OFF);
	return rtn;
}

///////////////////////////////////////////////////////////////
void CFileSearch::SetEditPath(LPTSTR lpszPath)
{
	//pX̏ꍇA[gݒ肷
	if((!wcslen(lpszPath)) || (wcscmp(GetStringTable(IDS_SEARCH_FOLDER_NAME), lpszPath)==0))	//MOD GORIPON
	{
		SetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_PATH), GetRootName());
	}
	else
	{
		wcscpy(m_szCurrent, lpszPath);
		SetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_PATH), lpszPath);
	}
}

///////////////////////////////////////////////////////////////
void CFileSearch::SetDateList()
{
	HWND hCB = GetDlgItem(m_hWnd, IDC_COMB_DATE);
	if(hCB)
	{
//MOD START GORIPON
		LPTSTR lpszText = DupStringTable(IDS_LIST_DATETYPE_CMP);
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)lpszText);
		FreeStringTable(lpszText);
		lpszText = DupStringTable(IDS_LIST_DATETYPE_AREA);
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)lpszText);
		FreeStringTable(lpszText);
		lpszText = DupStringTable(IDS_LIST_DATETYPE_BEF);
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)lpszText);
		FreeStringTable(lpszText);
		lpszText = DupStringTable(IDS_LIST_DATETYPE_AFT);
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)lpszText);
		FreeStringTable(lpszText);
//MOD END
	}
}

///////////////////////////////////////////////////////////////
void CFileSearch::SetSizeList()
{
	HWND hCB = GetDlgItem(m_hWnd, IDC_COMB_SIZE);
	if(hCB)
	{
//MOD START GORIPON
		LPTSTR lpszText = DupStringTable(IDS_LIST_SIZETYPE_CMP);
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)lpszText);
		FreeStringTable(lpszText);
		lpszText = DupStringTable(IDS_LIST_SIZETYPE_LOW);
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)lpszText);
		FreeStringTable(lpszText);
		lpszText = DupStringTable(IDS_LIST_SIZETYPE_HIGH);
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)lpszText);
		FreeStringTable(lpszText);
//MOD END
	}
}

///////////////////////////////////////////////////////////////
//t@C`FbN
BOOL CFileSearch::FileCheck(WIN32_FIND_DATA *lpFind, SEARCHINFO *lpSearch, LPTSTR lpszPath)
{
	//t@C`FbN
	if(wcslen(lpSearch->szName))
	{
		if(!StrStr(lpFind->cFileName, lpSearch->szName, FALSE))
		{
			return FALSE;
		}
	}

	//fBNg̏ꍇ͂܂
	if (lpFind->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
	{
		//t@CȊȌݒ肳ĂȂꍇ̂
		if(wcslen(lpSearch->szName) &&
		   lpSearch->nDateType == DATE_TYPE_NON &&
		   lpSearch->nSizeType == SIZE_TYPE_NON &&
		   !(wcslen(lpSearch->szText)))
			return TRUE;
		else
			return FALSE;
	}

	//t`FbN
	if(lpSearch->nDateType != DATE_TYPE_NON)
	{	
		//ϊ
		TCHAR szDate[8+1];
		SYSTEMTIME sys;
		FILETIME ft;
		
		ft = lpFind->ftLastWriteTime;
		FileTimeToLocalFileTime(&ft, &ft);
		FileTimeToSystemTime(&ft, &sys);
		wsprintf(szDate, _T("%04d%02d%02d"), sys.wYear, sys.wMonth, sys.wDay);

		switch(lpSearch->nDateType)
		{
		//v
		case DATE_TYPE_CMP:
			if(wcscmp(lpSearch->szFromDate, szDate)!=0)
				return FALSE;
			break;
		//v(͈)
		case DATE_TYPE_AREA:
			if(wcscmp(lpSearch->szFromDate, szDate)>0)
				return FALSE;
			if(wcscmp(lpSearch->szToDate, szDate)<0)
				return FALSE;
			break;
		//ȑO
		case DATE_TYPE_BEF:
			if(wcscmp(lpSearch->szFromDate, szDate)<0)
				return FALSE;
			break;
		//ȍ~
		case DATE_TYPE_AFT:
			if(wcscmp(lpSearch->szFromDate, szDate)>0)
				return FALSE;
			break;
		}
	}

	//TCY`FbN
	if(lpSearch->nSizeType != SIZE_TYPE_NON)
	{
		double fSize;
		fSize = (double)(lpFind->nFileSizeLow/1024);

		switch(lpSearch->nSizeType)
		{
		//v
		case SIZE_TYPE_CMP:
			if(lpSearch->dwSize != fSize)
				return FALSE;
			break;
		//
		case SIZE_TYPE_LOW:
			if(lpSearch->dwSize > fSize)
				return FALSE;
			break;
		//
		case SIZE_TYPE_HIGH:
			if(lpSearch->dwSize < fSize)
				return FALSE;
			break;
		}
	}

	//eLXg`FbN
	if(wcslen(lpSearch->szText))
	{
		if(!TextCheck(lpszPath, lpFind->cFileName, lpFind->nFileSizeLow,
				lpSearch->szText, lpSearch->bTextUpr))
			return FALSE;
	}
		
	return TRUE;
}

///////////////////////////////////////////////////////////////
//t@C
void CFileSearch::FileSearch(LPTSTR lpszPath)
{
	TCHAR szPath[MAX_PATH];
	LPTSTR lpszCurrent;

	//JgpXݒ
	if(!lpszPath)
	{
		lpszCurrent = m_lpSearch.szCurrent;
	}
	else
		lpszCurrent = lpszPath;

	//pX쐬
	if(wcslen(lpszCurrent))
		wsprintf(szPath, _T("%s\\*.*"), lpszCurrent);
	else
		wsprintf(szPath, _T("\\*.*"));

	//t@C̓ǂݍ
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szPath, &finddata);
	if(hFind != INVALID_HANDLE_VALUE)
	{
		do
		{
			//`FbNOK̏ꍇ
			if(FileCheck(&finddata, &m_lpSearch, lpszCurrent))
			{
				//ACeXgɓo^
				if(finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
				{
					//Xgǉ
					m_ListView->m_lpSearchData = 
						m_ListView->AddSearch(
							m_ListView->m_lpSearchData,
							lpszCurrent,
							finddata.cFileName,
							finddata.ftCreationTime,
							0,
							finddata.dwFileAttributes);
				}
				else
				{
					//Xgǉ
					m_ListView->m_lpSearchData = 
						m_ListView->AddSearch(
							m_ListView->m_lpSearchData,
							lpszCurrent,
							finddata.cFileName,
							finddata.ftLastWriteTime,
							finddata.nFileSizeLow,
							finddata.dwFileAttributes);
				}
			}

			//TufBNgfBNg̏ꍇ
			if(m_lpSearch.bSubFolder &&
			   finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
				TCHAR szTemp[MAX_PATH];
				if(wcslen(lpszCurrent))
					wsprintf(szTemp, _T("%s\\%s"), lpszCurrent, finddata.cFileName);
				else
					wsprintf(szTemp, _T("\\%s"), finddata.cFileName);

				//ċNĂяo
				FileSearch(szTemp);
			}

//			Sleep(0);
		}
		while(FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}
}

///////////////////////////////////////////////////////////////
//EBhE
void CFileSearch::OnInit()
{
	SHINITDLGINFO shidi;
	shidi.dwMask = SHIDIM_FLAGS;
	shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIZEDLGFULLSCREEN;
	shidi.hDlg = m_hWnd;
	SHInitDialog(&shidi);

	//EBhE^Cg
//MOD START GORIPON
	LPTSTR lpszText = DupStringTable(IDS_TITLE_FILESEARCHDLG);
	SetWindowText(m_hWnd, lpszText);
	FreeStringTable(lpszText);
//MOD END

	//EBhE
//ADD START GORIPON
	//j[o[ǉ
	SHMENUBARINFO mbi;
	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize = sizeof(SHMENUBARINFO);
	mbi.hwndParent = m_hWnd;
	mbi.nToolBarId = IDR_FILESEARCH;
	mbi.hInstRes = g_hInst;
	mbi.nBmpId = 0;
	mbi.cBmpImages = 0;
	SHCreateMenuBar(&mbi);
//ADD END

	//ꏊ
	SetEditPath(m_szCurrent);
	
	//tXgݒ
	SetDateList();

	//ti\/\
	OnChkDateChange();

	//TCYXgݒ
	SetSizeList();

	//TCYi\/\
	OnChkSizeChange();

	//TCYlݒ
	SetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_SIZE), _T("0"));

	//召ʂOFF
	SendMessage(GetDlgItem(m_hWnd, IDC_CHK_UPR), BM_SETCHECK, 0, 0);	//MOD GORIPON (WOFF)

	//TutH_ON
	SendMessage(GetDlgItem(m_hWnd, IDC_CHK_SUBFOLDER), BM_SETCHECK, 1, 0);

	//tH[JXݒ
	SetFocus(GetDlgItem(m_hWnd, IDC_EDIT_NAME));
}

///////////////////////////////////////////////////////////////
//Qƃ{^
void CFileSearch::OnBrowse()
{
	TCHAR szFolderTo[MAX_PATH] = _T("");
	
	//ꏊ擾
	GetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_PATH),
							szFolderTo, sizeof(szFolderTo));
	
	//fBNgLmF
	DWORD dwAttr = GetFileAttributes(szFolderTo);
	if(!(FILE_ATTRIBUTE_DIRECTORY == (dwAttr & FILE_ATTRIBUTE_DIRECTORY) && dwAttr != 0xFFFFFFFF))
	{
		//̏ꍇ͋󔒂Ƃ
		szFolderTo[0] = 0x00;
	}
	
	//tH_w_CAOI[v
	CFolderDlg fd;
//MOD START GORIPON
	LPTSTR lpszTitle = DupStringTable(IDS_TITLE_FILESEARCH);
	int nRet = fd.ShowFolderDlg(lpszTitle, szFolderTo, sizeof(szFolderTo));
	FreeStringTable(lpszTitle);
	if (nRet == IDOK)
//MOD END
	{
		SetEditPath(szFolderTo);
	}
}

///////////////////////////////////////////////////////////////
//t`FbN{bNX
void CFileSearch::OnChkDateChange()
{
	BOOL bChk = IsDlgButtonChecked(m_hWnd, IDC_CHK_DATE);

	for(int i=0; i<3; i++)
	{
		HWND hItemWnd;
		switch(i)
		{
			//t`FbN
			case 0:
				hItemWnd = GetDlgItem(m_hWnd, IDC_COMB_DATE);
				break;
			//Jnt
			case 1:
				hItemWnd = GetDlgItem(m_hWnd, IDC_DATE_FROM);
				break;
			//It
			case 2:
			{	
				//tʏ
				OnCombDateChange();

				hItemWnd = GetDlgItem(m_hWnd, IDC_DATE_TO);
				break;
			}
		}
		EnableWindow(hItemWnd, bChk);
	} //End of for
}

///////////////////////////////////////////////////////////////
//TCY`FbN{bNX
void CFileSearch::OnChkSizeChange()
{
	BOOL bChk = IsDlgButtonChecked(m_hWnd, IDC_CHK_SIZE);

	for(int i=0; i<3; i++)
	{
		HWND hItemWnd;
		switch(i)
		{
			//t`FbN
			case 0:
				hItemWnd = GetDlgItem(m_hWnd, IDC_EDIT_SIZE);
				break;
			//Jnt
			case 1:
				hItemWnd = GetDlgItem(m_hWnd, IDC_COMB_SIZE);
				break;
		}
		EnableWindow(hItemWnd, bChk);
	} //End of for
}

///////////////////////////////////////////////////////////////
//tʕύX
void CFileSearch::OnCombDateChange()
{
	HWND hItemWnd = GetDlgItem(m_hWnd, IDC_DATE_TO);

	//tʎ擾
	int nIndex = SendMessage(GetDlgItem(m_hWnd, IDC_COMB_DATE),CB_GETCURSEL, 0, 0)+1;
	
	//͈͎w̏ꍇ
	if(nIndex != DATE_TYPE_AREA)
		//It\
		ShowWindow(hItemWnd, SW_HIDE);
	else
		//It\
		ShowWindow(hItemWnd, SW_SHOW);
}

///////////////////////////////////////////////////////////////
//TCYʕύX
void CFileSearch::OnCombSizeChange()
{
}

///////////////////////////////////////////////////////////////
//nj{^
void CFileSearch::OnOK()
{
	//EBhE\
	ShowWindow(m_hWnd, SW_HIDE);

	//I(Jn)bZ[WM
	SendMessage(m_hWnd, WM_DLGCLOSE, 0, 0);
}

///////////////////////////////////////////////////////////////
//Jn
int CFileSearch::OnFileSerch()
{
	//J[\ɂ
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	//Xg폜
	if(m_ListView->m_lpSearchData)
	{
		m_ListView->DeleteSearch(m_ListView->m_lpSearchData);
		m_ListView->m_lpSearchData = NULL;
	}
	
	memset(&m_lpSearch, 0x00, sizeof(m_lpSearch));

	//t@C
	GetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_NAME),
					m_lpSearch.szName, sizeof(m_lpSearch.szName));

	//啶/ϊ
	wcsupr(m_lpSearch.szName);

	//eLXg
	GetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_TEXT),
					m_lpSearch.szText, sizeof(m_lpSearch.szText));

	//召
	m_lpSearch.bTextUpr = IsDlgButtonChecked(m_hWnd, IDC_CHK_UPR);

	//ꏊ
	GetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_PATH),
					m_lpSearch.szCurrent, sizeof(m_lpSearch.szCurrent));

	//fBNgLmF
	DWORD dwAttr = GetFileAttributes(m_lpSearch.szCurrent);
	if(!(FILE_ATTRIBUTE_DIRECTORY == (dwAttr & FILE_ATTRIBUTE_DIRECTORY) && dwAttr != 0xFFFFFFFF))
	{
		//Ȃꍇ͋([g)
		m_lpSearch.szCurrent[0] = 0x00;
	}
	if(!wcscmp(m_lpSearch.szCurrent, _T("\\")))
		m_lpSearch.szCurrent[0] = 0x00;
	
	//TutH_
	m_lpSearch.bSubFolder = IsDlgButtonChecked(m_hWnd, IDC_CHK_SUBFOLDER);

	//t
	m_lpSearch.nDateType = DATE_TYPE_NON;
	if(IsDlgButtonChecked(m_hWnd, IDC_CHK_DATE))
	{
		SYSTEMTIME sys;
		//t`FbN
		m_lpSearch.nDateType = 
			SendMessage(GetDlgItem(m_hWnd, IDC_COMB_DATE), CB_GETCURSEL, 0, 0)+1;
		if(!m_lpSearch.nDateType) m_lpSearch.nDateType = DATE_TYPE_CMP;

		//Jnt
		DateTime_GetSystemtime(GetDlgItem(m_hWnd, IDC_DATE_FROM), &sys);
		wsprintf(m_lpSearch.szFromDate, _T("%04d%02d%02d"), sys.wYear, sys.wMonth, sys.wDay);

		//It
		DateTime_GetSystemtime(GetDlgItem(m_hWnd, IDC_DATE_TO), &sys);
		wsprintf(m_lpSearch.szToDate, _T("%04d%02d%02d"), sys.wYear, sys.wMonth, sys.wDay);
	}
	
	//TCY
	m_lpSearch.nSizeType = SIZE_TYPE_NON;
	if(IsDlgButtonChecked(m_hWnd, IDC_CHK_SIZE))
	{
		//TCY`FbN
		m_lpSearch.nSizeType = 
			SendMessage(GetDlgItem(m_hWnd, IDC_COMB_SIZE), CB_GETCURSEL, 0, 0)+1;
		if(!m_lpSearch.nSizeType) m_lpSearch.nSizeType = SIZE_TYPE_CMP;
		
		//TCY
		TCHAR szBuf[16];
		GetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_SIZE), szBuf, sizeof(szBuf));
		m_lpSearch.dwSize = _wtoi(szBuf);
	}

	//s
	FileSearch();

	//J[\ɖ߂
	SetCursor(hCursor);

	return (INT)TRUE;
}
