///////////////////////////////////////////////////////////////
//ListView.cpp
//t@Cꗗ\

///////////////////////////////////////////////////////////////
#include "GSFinder.h"
#include "ListView.h"
#include "CommandBandsPPC.h"
#include "FolderDlgPPC.h"
#include "FileProperty.h"
#include "CopyDlg.h"
#include "DeleteDlg.h"
#include "UserPathDlg.h"	//ADD TODA
#include "FileSearch.h"		//ADD TODA
#include "Association.h"	//ADD TODA
///////////////////////////////////////////////////////////////
#define ID_LISTVIEW			0

//ADD START TODA (from GSFinder ver.1.99)
#define DEF_LIST_STYLE	(WS_BORDER | WS_TABSTOP | WS_VISIBLE | WS_CHILD | \
							LVS_SHAREIMAGELISTS | \
							LVS_ALIGNTOP | LVS_EDITLABELS | \
							LVS_SHOWSELALWAYS | LVS_OWNERDATA)	//MOD GORIPON
//#define DEF_LIST_EXSTYLE	(LVS_EX_ONECLICKACTIVATE | LVS_EX_FULLROWSELECT)
#define DEF_LIST_EXSTYLE	(LVS_EX_ONECLICKACTIVATE)
//ADD END

//ADD START TODA
WNDPROC	Org_ListViewProc = NULL;
///////////////////////////////////////////////////////////////
//MOD START GORIPON
LRESULT CALLBACK ListViewProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) 
	{
		//L[
		case WM_KEYDOWN:
			g_MainWnd.m_ListView.m_bThroughContextMenu = FALSE;
			switch (wParam)
			{
			case VK_HOME:
				//HOMEL[
				g_MainWnd.m_ListView.OnGoBack();
				return 0;
			case VK_END:
				//ENDL[
				g_MainWnd.m_ListView.OnGoFront();
				return 0;
			case VK_RETURN:
				//ENTERL[
				g_MainWnd.m_ListView.m_bOwnKeyup = TRUE;
				break;
			case VK_BACK:
				return 0;
			case VK_LEFT:
				if (g_MainWnd.m_ListView.OnKeyArrowDown(wParam, lParam))
					return 0;
				if (g_MainWnd.m_ListView.m_Settings.dwListStyle == LVS_REPORT)
				{
					if (g_MainWnd.m_ListView.m_bUseReportPageMove)
					{
						keybd_event(VK_PRIOR, 0, 0, 0);
						return 0;
					}
				}
				break;
			case VK_RIGHT:
				if (g_MainWnd.m_ListView.OnKeyArrowDown(wParam, lParam))
					return 0;
				if (g_MainWnd.m_ListView.m_Settings.dwListStyle == LVS_REPORT)
				{
					if (g_MainWnd.m_ListView.m_bUseReportPageMove)
					{
						keybd_event(VK_NEXT, 0, 0, 0);
						return 0;
					}
				}
				break;
			case VK_UP:
				if (g_MainWnd.m_ListView.OnKeyArrowDown(wParam, lParam))
					return 0;
				if (g_MainWnd.m_ListView.m_Settings.dwListStyle == LVS_REPORT)
				{
					int fi = ListView_GetNextItem(g_MainWnd.m_ListView.m_hWnd, -1, LVIS_FOCUSED);
					if (fi == 0)
					{
						int ic = ListView_GetItemCount(g_MainWnd.m_ListView.m_hWnd);
						if ((GET_KEYSTATE(VK_SHIFT)&0x8000) || (GET_KEYSTATE(VK_CONTROL)&0x8000))
						{
							ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, fi, 0, LVIS_FOCUSED);
							ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, ic-1, LVIS_FOCUSED, LVIS_FOCUSED);
						}
						else
						{
							ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, -1, 0, LVIS_FOCUSED|LVIS_SELECTED);
							ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, ic-1, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);
						}
						ListView_EnsureVisible(g_MainWnd.m_ListView.m_hWnd, ic-1, FALSE);
						return 0;
					}
				}
				break;
			case VK_DOWN:
				if (g_MainWnd.m_ListView.OnKeyArrowDown(wParam, lParam))
					return 0;
				if (g_MainWnd.m_ListView.m_Settings.dwListStyle == LVS_REPORT)
				{
					int fi = ListView_GetNextItem(g_MainWnd.m_ListView.m_hWnd, -1, LVIS_FOCUSED);
					int ic = ListView_GetItemCount(g_MainWnd.m_ListView.m_hWnd);
					if (fi == (ic-1))
					{
						int test = ListView_GetCountPerPage(g_MainWnd.m_ListView.m_hWnd);
						if ((GET_KEYSTATE(VK_SHIFT)&0x8000) || (GET_KEYSTATE(VK_CONTROL)&0x8000))
						{
							ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, fi, 0, LVIS_FOCUSED);
							ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, 0, LVIS_FOCUSED, LVIS_FOCUSED);
						}
						else
						{
							ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, -1, 0, LVIS_FOCUSED|LVIS_SELECTED);
							ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, 0, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);
						}
						ListView_EnsureVisible(g_MainWnd.m_ListView.m_hWnd, 0, FALSE);
						return 0;
					}
				}
				break;
			default:
				break;
			}
			break;
		case WM_KEYUP:
			switch (wParam)
			{
			case VK_RETURN:
				//SHIFT/CTRLL[
				if (g_MainWnd.m_ListView.m_bOwnKeyup)
				{
					g_MainWnd.m_ListView.m_bOwnKeyup = FALSE;
					if (!g_MainWnd.m_ListView.m_bThroughContextMenu)
					{
						if (!(GET_KEYSTATE(VK_CONTROL)&0x8000))
						{
							if (g_MainWnd.m_bControlKey)
							{
								keybd_event(VK_CONTROL, 0, 0, 0);
								keybd_event(VK_RETURN, 0, 0, 0);
								keybd_event(VK_RETURN, 0, KEYEVENTF_KEYUP, 0);
								keybd_event(VK_CONTROL, 0, KEYEVENTF_KEYUP, 0);
							}
							else
							{
								g_MainWnd.m_ListView.OnFileOpen();
							}
						}
					}
				}
				break;
			case VK_LEFT:
				if (g_MainWnd.m_ListView.OnKeyArrowUp(wParam, lParam))
					return 0;
				if (g_MainWnd.m_ListView.m_Settings.dwListStyle==LVS_REPORT)
				{
					keybd_event(VK_PRIOR, 0, KEYEVENTF_KEYUP, 0);
					return 0;
				}
				break;
			case VK_RIGHT:
				if (g_MainWnd.m_ListView.OnKeyArrowUp(wParam, lParam))
					return 0;
				if (g_MainWnd.m_ListView.m_Settings.dwListStyle==LVS_REPORT)
				{
					keybd_event(VK_NEXT, 0, KEYEVENTF_KEYUP, 0);
					return 0;
				}
				break;
			case VK_UP:
				if (g_MainWnd.m_ListView.OnKeyArrowUp(wParam, lParam))
					return 0;
				break;
			case VK_DOWN:
				if (g_MainWnd.m_ListView.OnKeyArrowUp(wParam, lParam))
					return 0;
				break;
			case VK_BACK:
				if (wcslen(g_MainWnd.m_ListView.m_szCurrentFolder)==0)
					SetFocus(g_MainWnd.m_TreeView.m_hWnd);
				else
					g_MainWnd.m_ListView.OnViewUpFolder();
				return 0;
			default:
				break;
			}
			g_MainWnd.m_ListView.m_bThroughContextMenu = FALSE;
			break;
		//ReNXgj[̃I[v
		case WM_CONTEXTMENU:
			g_MainWnd.m_ListView.m_bThroughContextMenu = TRUE;
			break;
		case WM_LBUTTONDOWN:
			//^bvJn
			g_MainWnd.m_ListView.OnTapHoldBegin((DWORD)lParam);
			//SHIFT/CTRLL[
			if (g_MainWnd.m_bShiftKey)
				wParam |= MK_SHIFT;
			if (g_MainWnd.m_bControlKey)
				wParam |= MK_CONTROL;
			break;
		case WM_LBUTTONUP:
			//SHIFT/CTRLL[
			if (g_MainWnd.m_bShiftKey)
				wParam |= MK_SHIFT;
			if (g_MainWnd.m_bControlKey)
				wParam |= MK_CONTROL;
			break;
		case WM_KILLFOCUS:
			//SHIFT/CTRLL[
			if (g_MainWnd.m_bShiftKey)
				g_MainWnd.OnEditShiftOn();
			if (g_MainWnd.m_bControlKey)
				g_MainWnd.OnEditCtrlOn();
			break;
		//ȊO
		default:
			break;
	}
	return CallWindowProc((WNDPROC)Org_ListViewProc, hWnd, message, wParam, lParam);
}
//MOD END
//ADD END

////////////////////////////////////////////////////////////////
LRESULT CALLBACK FileOpenParamDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{
			SHINITDLGINFO shidi;
			shidi.dwMask = SHIDIM_FLAGS;
			shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIZEDLGFULLSCREEN;
			shidi.hDlg = hDlg;
			SHInitDialog(&shidi);
//ADD START GORIPON
			//j[o[ǉ
			SHMENUBARINFO mbi;
			memset(&mbi, 0, sizeof(SHMENUBARINFO));
			mbi.cbSize = sizeof(SHMENUBARINFO);
			mbi.hwndParent = hDlg;
			mbi.nToolBarId = IDR_OPENPARAM;
			mbi.hInstRes = g_hInst;
			mbi.nBmpId = 0;
			mbi.cBmpImages = 0;	
			SHCreateMenuBar(&mbi);
//ADD END
			int nIndex = g_MainWnd.m_ListView.GetSelectedItemIndex(0);
			LISTITEMCOMP* plic = g_MainWnd.m_ListView.GetListItemStruct(nIndex);
			TCHAR szTemp[MAX_PATH];
			wsprintf(szTemp, GetStringTable(IDS_FMT_OPENPARAM), plic->lpszName);	//MOD GORIPON
			SetWindowText(GetDlgItem(hDlg, IDC_MESSAGE), szTemp);
			return TRUE;
		}
		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK)
			{
				int nIndex = g_MainWnd.m_ListView.GetSelectedItemIndex(0);
				LISTITEMCOMP* plic = g_MainWnd.m_ListView.GetListItemStruct(nIndex);

				TCHAR szParam[MAX_PATH];
				GetWindowText(GetDlgItem(hDlg, IDC_EDIT_PATH), szParam, 512);
				TCHAR szPath[MAX_PATH];
				wsprintf(szPath, _T("%s\\%s"), g_MainWnd.m_ListView.m_szCurrentFolder, plic->lpszName);

				SHELLEXECUTEINFO sei;
				sei.cbSize = sizeof(SHELLEXECUTEINFO);
				sei.fMask = 0;
				sei.hwnd = hDlg;
				sei.lpVerb = _T("open");
				sei.lpFile = szPath;
				sei.lpParameters = szParam;
				sei.lpDirectory = _T("");
				sei.nShow = SW_SHOW;
				sei.hInstApp = g_hInst;
				ShellExecuteEx(&sei);

				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			else if (LOWORD(wParam) == IDCANCEL)
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
		case WM_PAINT:
			return DefDlgPaintProc(hDlg, wParam, lParam);
		case WM_CTLCOLORSTATIC:
			return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);
	}
	return FALSE;
}

///////////////////////////////////////////////////////////////
CListView::CListView()
{
	m_Settings.nSort = LIST_SORT_NAME;
	m_Settings.bSortRaise = TRUE;
	m_Settings.dwListStyle = LVS_ICON;
	m_Settings.dwListExStyle = 0;

	m_Settings.bHideHidden = TRUE;
	m_Settings.bHideSystem = FALSE;
	m_Settings.bHideROM = FALSE;

	m_Settings.nNameColumnSize = 145;
	m_Settings.nSizeColumnSize = 75;
	m_Settings.nTypeColumnSize = 75;
	m_Settings.nTimeColumnSize = 75;

	m_Settings.bSaveFolder = FALSE;
	wcscpy(m_szCurrentFolder, _T(""));
	m_Settings.bNotShortcutName = FALSE;
	m_Settings.bNotShowExt = TRUE;
	m_Settings.bSingleClick = TRUE;
	m_Settings.bAddUpper = TRUE;
	//ADD START TODA
	m_Settings.bHideHeader = FALSE;
	m_Settings.nCompDLL = COMPDLL_MODE_ZIP;
	m_Settings.bAutoUnComp = FALSE;
	m_Settings.bMakeDir = FALSE;
	m_Settings.bMoveDir = FALSE;
	m_Settings.bDblClick = FALSE;
	wcscpy(m_szCompressFolder, _T("\\Temp"));
	wcscpy(m_szOldFolder, _T(""));
	m_bTimeStump = FALSE;
	m_bHideFolder = FALSE;
	m_bNoExtShortcut = TRUE;

//DEL START GORIPON
	//m_bTaping = FALSE;
	//m_bHolding = FALSE;
//DEL END
	m_bMenu = FALSE;
	m_lpHistory = NULL;
	m_lpHistoryCurrent = NULL;
	m_lpSearchData = NULL;
	m_lpFavorites = NULL;
	m_lpFavoritesCurrent = NULL;
	m_nFavoritesCount = 0;
	//ADD END
//ADD START GORIPON
	m_bThroughContextMenu = FALSE;
	m_bOwnKeyup = FALSE;
	m_bUseReportPageMove = FALSE;
//ADD END

	m_nCount = 0;
	m_bFileMove = FALSE;
	m_lpliinfo = NULL;
	wcscpy(m_szFolderFrom, _T(""));
	m_nFileSize = 0;
	m_hMenuPopup = NULL;
	m_pFileImageList = NULL;
	m_bEditing = FALSE;
	m_dwUpperParam = NULL;
	m_nOpenPthInfoCount = 0;	//ADD TODA

	m_ImageListSettings.bNotLoadFileIcon = FALSE;
	m_ImageListSettings.bNotLoadROMIcon = TRUE;
	m_ImageListSettings.bNotLoadCompIcon = TRUE;	//ADD TODA
	m_ImageListSettings.bStuffingIcons = FALSE;		//ADD GORIPON
}
///////////////////////////////////////////////////////////////
CListView::~CListView()
{
	//ADD START TODA (/̍폜ǉ)
	//̍폜
	DeleteHistory(m_lpHistory);

	//ʂ̍폜
	DeleteSearch(m_lpSearchData);
	//ADD END
}
///////////////////////////////////////////////////////////////
void CListView::Init(HWND hwndParent)
{
	//ݒǂݍ
	GetSettings();

	//MOD START TODA (from GSFinder ver.1.99)
	DWORD dwStyle = DEF_LIST_STYLE /*| m_Settings.dwListStyle*/;
//MOD START GORIPON
	DWORD dwExStyle = 0;
//MOD END

//DEL START TODA (\ݒ菈ƂŎs)
//	if (m_Settings.dwListStyle == LVS_REPORT && m_Settings.bHideHeader)
//		dwStyle |= LVS_NOCOLUMNHEADER;
//DEL END
	m_hWnd = CreateWindowEx(dwExStyle,
							WC_LISTVIEW,
							NULL, dwStyle, 0, 0, 0, 0,
							hwndParent, (HMENU)ID_LISTVIEW,
							g_hInst, NULL);
	//MOD END

	//ADD START TODA (^bv&z[hp)
	Org_ListViewProc = (WNDPROC)GetWindowLong(m_hWnd, GWL_WNDPROC);
	SetWindowLong(m_hWnd, GWL_WNDPROC, (DWORD)ListViewProc);
	//ADD END

//DEL START TODA (\ݒ菈ƂŎs)
//	//MOD START TODA (from GSFinder ver.1.99)
//	if (m_Settings.dwListStyle == LVS_REPORT)
//		ListView_SetExtendedListViewStyle(m_hWnd, ListView_GetExtendedListViewStyle(m_hWnd) | (DEF_LIST_EXSTYLE|m_Settings.dwListExStyle));
//	//MOD END
//
//	if (m_Settings.dwListStyle == LVS_ICON)
//		ListView_SetIconSpacing(m_hWnd, 72, 72);
//
//	SendMessage(m_hWnd, CCM_SETVERSION, COMCTL32_VERSION, 0);
//DEL END

	//
	LVCOLUMN lvc;
	lvc.mask = LVCF_FMT | LVCF_SUBITEM | LVCF_TEXT | LVCF_WIDTH;
	lvc.fmt = LVCFMT_LEFT;
	lvc.cx = m_Settings.nNameColumnSize;
	lvc.pszText = DupStringTable(IDS_COLUMN_NAME);	//MOD GORIPON
	lvc.iSubItem = 0;
	ListView_InsertColumn(m_hWnd, 0, &lvc);
	FreeStringTable(lvc.pszText);	//ADD GORIPON
	lvc.fmt = LVCFMT_RIGHT;
	lvc.cx = m_Settings.nSizeColumnSize;
	lvc.pszText = DupStringTable(IDS_COLUMN_SIZE);	//MOD GORIPON
	lvc.iSubItem = 1;
	ListView_InsertColumn(m_hWnd, 1, &lvc);
	FreeStringTable(lvc.pszText);	//ADD GORIPON
	lvc.fmt = LVCFMT_LEFT;
	lvc.cx = m_Settings.nTypeColumnSize;
	lvc.pszText = DupStringTable(IDS_COLUMN_TYPE);	//MOD GORIPON
	lvc.iSubItem = 2;
	ListView_InsertColumn(m_hWnd, 2, &lvc);
	FreeStringTable(lvc.pszText);	//ADD GORIPON
	lvc.fmt = LVCFMT_LEFT;
	lvc.cx = m_Settings.nTimeColumnSize;
	lvc.pszText = DupStringTable(IDS_COLUMN_DATE);	//MOD GORIPON
	lvc.iSubItem = 3;
	ListView_InsertColumn(m_hWnd, 3, &lvc);
	FreeStringTable(lvc.pszText);	//ADD GORIPON

	SetImageList();

	if (g_lpszFirstLoadFolder == NULL)
	{
		//R}hCp[^w莞
		if (m_Settings.bSaveFolder)
		{
			DWORD dwAttr = GetFileAttributes(m_szCurrentFolder);
			if (dwAttr == 0xFFFFFFFF || (dwAttr & FILE_ATTRIBUTE_DIRECTORY) != FILE_ATTRIBUTE_DIRECTORY)
				wcscpy(m_szCurrentFolder, _T(""));
		}
		else
			wcscpy(m_szCurrentFolder, _T(""));
	}
	else 
	{
		DWORD dwAttr = GetFileAttributes(g_lpszFirstLoadFolder);
		if (dwAttr != 0xFFFFFFFF && (dwAttr & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY)
			wcscpy(m_szCurrentFolder, g_lpszFirstLoadFolder);
	}

//DEL START TODA
//	g_MainWnd.m_CmdBands.SetCheckListStyle(m_Settings.dwListStyle, m_Settings.dwListExStyle);	//MOD TODA
//DEL END
	g_MainWnd.m_CmdBands.SetCheckSort(m_Settings.nSort, m_Settings.bSortRaise);
	g_MainWnd.m_CmdBands.SetEnableEditPaste(FALSE);
	m_hMenuPopup = LoadMenu(g_hInst, (LPCTSTR)(g_MainWnd.m_bNumberShortcut? IDR_POPUP1:IDR_POPUP));	//MOD GORIPON

	InitOpenAppMenu();
	InitUserPathMenu();		//ADD TODA
	InitFavoritesMenu();	//ADD TODA

	//\`ݒ
	OnChangeListStyle(0);	//ADD TODA
}

///////////////////////////////////////////////////////////////
void CListView::Destroy()
{
	//ݒۑ
	SaveSettings();

	if (m_lpliinfo)
	{
		delete[] m_lpliinfo;
		m_lpliinfo = NULL;
		m_nCount = 0;
	}

	int i;
	for (i = 0; i < m_nOpenAppInfoCount; i++)
	{
		OPENAPPINFO* poa= m_lpOpenAppInfo[i];
		if (poa)
		{
			delete poa->lpszPath;
			delete poa;
			m_lpOpenAppInfo[i] = NULL;
		}
	}

	m_nOpenAppInfoCount = NULL;

	DeleteAllItem();
	DeleteUserPathMenu();		//ADD TODA
	DeleteFavoritesMenu();		//ADD TODA

	DestroyMenu(m_hMenuPopup);

	m_FileImageListLarge.Destroy();
	m_FileImageListSmall.Destroy();
	//DestroyWindow(m_hWnd);	//DEL GORIPON (eEChEDestroyWindowőp)
}

///////////////////////////////////////////////////////////////
void CListView::SetImageList()
{
	m_FileImageListSmall.InitImageList(FALSE);
	ListView_SetImageList(m_hWnd, m_FileImageListSmall.m_hImageList, LVSIL_SMALL);
	m_FileImageListLarge.InitImageList(TRUE);
	ListView_SetImageList(m_hWnd, m_FileImageListLarge.m_hImageList, LVSIL_NORMAL);

	if ((m_Settings.dwListStyle&LVS_TYPEMASK)==LVS_ICON)
		m_pFileImageList = &m_FileImageListLarge;
	else
		m_pFileImageList = &m_FileImageListSmall;
}
///////////////////////////////////////////////////////////////
//MOD START GORIPON
void CListView::GetSettings()
{
	HKEY hKey = 0;
	DWORD dwDisposition;

	//L[擾
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_SETTINGS, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition)==ERROR_SUCCESS)
	{
		DWORD dwDataSize;
		DWORD dwValue;
		BYTE bString[MAX_PATH*2];

		//m_nOpenPthInfoCount
		dwDataSize = sizeof(dwValue);
		int iTemp = 0;
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("OpenPthInfoCount"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			iTemp = dwValue;

		//m_lpOpenPthInfo
		CUserPathDlg *pup = new CUserPathDlg((HWND)0, (HINSTANCE)0);
		for(int i=0; i<iTemp; i++)
		{
			BYTE bString[MAX_PATH*sizeof(TCHAR)];
			dwDataSize = sizeof(bString);
			TCHAR szKey[16];
			wsprintf(szKey, _T("OpenPthInfo%d"), i);
			if (RegQueryValueEx(hKey, szKey, 0, NULL, bString, &dwDataSize) == ERROR_SUCCESS)
				pup->AddPath(i, (LPTSTR)bString);
		}
		if(pup) delete pup;

		//m_szCurrentFolder
		dwDataSize = sizeof(bString);
		if (RegQueryValueEx(hKey, _T("LastFolder"), 0, NULL, bString, &dwDataSize) == ERROR_SUCCESS)
			memcpy(&m_szCurrentFolder, bString, dwDataSize);
		
		//m_szCompressFolder
		dwDataSize = sizeof(bString);
		if (RegQueryValueEx(hKey, _T("CompressFolder"), 0, NULL, bString, &dwDataSize) == ERROR_SUCCESS)
			memcpy(&m_szCompressFolder, bString, dwDataSize);

		//m_bTimeStump
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TimeStump"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bTimeStump = dwValue;

		//m_bHideFolder
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("HideFolder"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bHideFolder = dwValue;

		//m_bNoExtShortcut
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NoExtShortcut"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bNoExtShortcut = dwValue;

		//m_bUseReportPageMove
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("UseReportPageMove"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bUseReportPageMove = dwValue;

		RegCloseKey(hKey);
	}
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_LISTVIEW, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition)==ERROR_SUCCESS)
	{
		DWORD dwDataSize;
		DWORD dwValue;

		//m_Settings.nSort
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("Sort"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.nSort = dwValue;

		//m_Settings.bSortRaise
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("SortRaise"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bSortRaise = dwValue;

		//m_Settings.dwListStyle
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ListStyle"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.dwListStyle = dwValue;

		//m_Settings.dwListExStyle
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ListExStyle"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.dwListExStyle = dwValue;

		//m_Settings.bHideHidden
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("HideHidden"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bHideHidden = dwValue;

		//m_Settings.bHideSystem
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("HideSystem"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bHideSystem = dwValue;

		//m_Settings.bHideROM
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("HideROM"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bHideROM = dwValue;

		//m_Settings.nNameColumnSize
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NameColumnSize"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.nNameColumnSize = dwValue;

		//m_Settings.nSizeColumnSize
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("SizeColumnSize"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.nSizeColumnSize = dwValue;

		//m_Settings.nTypeColumnSize
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TypeColumnSize"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.nTypeColumnSize = dwValue;

		//m_Settings.nTimeColumnSize
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TimeColumnSize"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.nTimeColumnSize = dwValue;

		//m_Settings.bSaveFolder
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("SaveFolder"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bSaveFolder = dwValue;

		//m_Settings.bNotShortcutName
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NotShortcutName"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bNotShortcutName = dwValue;

		//m_Settings.bNotShowExt
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NotShowExt"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bNotShowExt = dwValue;

		//m_Settings.bSingleClick
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("SingleClick"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bSingleClick = dwValue;

		//m_Settings.bHideHeader
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("HideHeader"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bHideHeader = dwValue;

		//m_Settings.bAddUpper
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("AddUpper"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bAddUpper = dwValue;

		//m_Settings.nCompDLL
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("CompDLL"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.nCompDLL = dwValue;

		//m_Settings.bAutoUnComp
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("AutoUnComp"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bAutoUnComp = dwValue;

		//m_Settings.bMakeDir
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("MakeDir"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bMakeDir = dwValue;

		//m_Settings.bMoveDir
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("MoveDir"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bMoveDir = dwValue;

		//m_Settings.bDblClick
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("DblClick"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bDblClick = dwValue;
	}
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_FILEIMAGELIST, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition)==ERROR_SUCCESS)
	{
		DWORD dwDataSize;
		DWORD dwValue;

		//m_ImageListSettings.bNotLoadFileIcon
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NotLoadFileIcon"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_ImageListSettings.bNotLoadFileIcon = dwValue;

		//m_ImageListSettings.bNotLoadROMIcon
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NotLoadROMIcon"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_ImageListSettings.bNotLoadROMIcon = dwValue;

		//m_ImageListSettings.bNotLoadCompIcon
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NotLoadCompIcon"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_ImageListSettings.bNotLoadCompIcon = dwValue;

		//m_ImageListSettings.bStuffingIcons
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("StuffingIcons"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_ImageListSettings.bStuffingIcons = dwValue;
	}
}
//MOD END

///////////////////////////////////////////////////////////////
void CListView::SaveSettings()
{
//MOD START GORIPON
	//ۑOɃJTCY擾
	if (m_Settings.dwListStyle==LVS_REPORT)
	{
		m_Settings.nNameColumnSize = ListView_GetColumnWidth(m_hWnd, 0);
		m_Settings.nSizeColumnSize = ListView_GetColumnWidth(m_hWnd, 1);
		m_Settings.nTypeColumnSize = ListView_GetColumnWidth(m_hWnd, 2);
		m_Settings.nTimeColumnSize = ListView_GetColumnWidth(m_hWnd, 3);
	}

	HKEY hKey;
	DWORD dwDisposition;

	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_SETTINGS, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition)==ERROR_SUCCESS)
	{
		//m_nOpenPthInfoCount
		RegSetValueEx(hKey, _T("OpenPthInfoCount"), 0, REG_DWORD,
				(LPBYTE)&m_nOpenPthInfoCount, sizeof(m_nOpenPthInfoCount));

		for(int i=0; i<m_nOpenPthInfoCount; i++)
		{
			OPENAPPINFO* poa= m_lpOpenPthInfo[i];
			TCHAR szKey[16];
			wsprintf(szKey, _T("OpenPthInfo%d"), i);
			RegSetValueEx(hKey, szKey, 0, REG_SZ,
					(LPBYTE)poa->lpszPath, ((wcslen(poa->lpszPath)+1)  * sizeof(TCHAR)));
		} //End of for

		//m_szCurrentFolder[MAX_PATH];
		RegSetValueEx(hKey, _T("LastFolder"), 0, REG_SZ,
				(LPBYTE)m_szCurrentFolder, ((wcslen(m_szCurrentFolder)+1) * sizeof(TCHAR)));

		//m_szCompressFolder[MAX_PATH];
		RegSetValueEx(hKey, _T("CompressFolder"), 0, REG_SZ,
				(LPBYTE)m_szCompressFolder, ((wcslen(m_szCompressFolder)+1) * sizeof(TCHAR)));

		//m_bTimeStump
		RegSetValueEx(hKey, _T("TimeStump"), 0, REG_DWORD,
				(LPBYTE)&m_bTimeStump, sizeof(m_bTimeStump));

		//m_bHideFolder
		RegSetValueEx(hKey, _T("HideFolder"), 0, REG_DWORD,
				(LPBYTE)&m_bHideFolder, sizeof(m_bHideFolder));

		//m_bNoExtShortcut
		RegSetValueEx(hKey, _T("NoExtShortcut"), 0, REG_DWORD,
				(LPBYTE)&m_bNoExtShortcut, sizeof(m_bNoExtShortcut));

		//m_bUseReportPageMove
		RegSetValueEx(hKey, _T("UseReportPageMove"), 0, REG_DWORD,
				(LPBYTE)&m_bUseReportPageMove, sizeof(m_bUseReportPageMove));

		RegCloseKey(hKey);
	}
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_LISTVIEW, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition)==ERROR_SUCCESS)
	{
		//m_Settings.nSort
		RegSetValueEx(hKey, _T("Sort"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.nSort, sizeof(m_Settings.nSort));

		//m_Settings.bSortRaise
		RegSetValueEx(hKey, _T("SortRaise"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bSortRaise, sizeof(m_Settings.bSortRaise));

		//m_Settings.dwListStyle
		RegSetValueEx(hKey, _T("ListStyle"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.dwListStyle, sizeof(m_Settings.dwListStyle));

		//m_Settings.dwListExStyle
		RegSetValueEx(hKey, _T("ListExStyle"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.dwListExStyle, sizeof(m_Settings.dwListExStyle));

		//m_Settings.bHideHidden
		RegSetValueEx(hKey, _T("HideHidden"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bHideHidden, sizeof(m_Settings.bHideHidden));

		//m_Settings.bHideSystem
		RegSetValueEx(hKey, _T("HideSystem"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bHideSystem, sizeof(m_Settings.bHideSystem));

		//m_Settings.bHideROM
		RegSetValueEx(hKey, _T("HideROM"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bHideROM, sizeof(m_Settings.bHideROM));

		//m_Settings.nNameColumnSize
		RegSetValueEx(hKey, _T("NameColumnSize"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.nNameColumnSize, sizeof(m_Settings.nNameColumnSize));

		//m_Settings.nSizeColumnSize
		RegSetValueEx(hKey, _T("SizeColumnSize"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.nSizeColumnSize, sizeof(m_Settings.nSizeColumnSize));

		//m_Settings.nTypeColumnSize
		RegSetValueEx(hKey, _T("TypeColumnSize"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.nTypeColumnSize, sizeof(m_Settings.nTypeColumnSize));

		//m_Settings.nTimeColumnSize
		RegSetValueEx(hKey, _T("TimeColumnSize"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.nTimeColumnSize, sizeof(m_Settings.nTimeColumnSize));

		//m_Settings.bSaveFolder
		RegSetValueEx(hKey, _T("SaveFolder"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bSaveFolder, sizeof(m_Settings.bSaveFolder));

		//m_Settings.bNotShortcutName
		RegSetValueEx(hKey, _T("NotShortcutName"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bNotShortcutName, sizeof(m_Settings.bNotShortcutName));

		//m_Settings.bNotShowExt
		RegSetValueEx(hKey, _T("NotShowExt"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bNotShowExt, sizeof(m_Settings.bNotShowExt));

		//m_Settings.bSingleClick
		RegSetValueEx(hKey, _T("SingleClick"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bSingleClick, sizeof(m_Settings.bSingleClick));

		//m_Settings.bHideHeader
		RegSetValueEx(hKey, _T("HideHeader"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bHideHeader, sizeof(m_Settings.bHideHeader));

		//m_Settings.bAddUpper
		RegSetValueEx(hKey, _T("AddUpper"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bAddUpper, sizeof(m_Settings.bAddUpper));

		//m_Settings.nCompDLL
		RegSetValueEx(hKey, _T("CompDLL"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.nCompDLL, sizeof(m_Settings.nCompDLL));

		//m_Settings.bAutoUnComp
		RegSetValueEx(hKey, _T("AutoUnComp"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bAutoUnComp, sizeof(m_Settings.bAutoUnComp));

		//m_Settings.bMakeDir
		RegSetValueEx(hKey, _T("MakeDir"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bMakeDir, sizeof(m_Settings.bMakeDir));

		//m_Settings.bMoveDir
		RegSetValueEx(hKey, _T("MoveDir"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bMoveDir, sizeof(m_Settings.bMoveDir));

		//m_Settings.bDblClick
		RegSetValueEx(hKey, _T("DblClick"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bDblClick, sizeof(m_Settings.bDblClick));

	}
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_FILEIMAGELIST, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition)==ERROR_SUCCESS)
	{
		//m_ImageListSettings.bNotLoadFileIcon
		RegSetValueEx(hKey, _T("NotLoadFileIcon"), 0, REG_DWORD,
				(LPBYTE)&m_ImageListSettings.bNotLoadFileIcon, sizeof(m_ImageListSettings.bNotLoadFileIcon));

		//m_ImageListSettings.bNotLoadROMIcon
		RegSetValueEx(hKey, _T("NotLoadROMIcon"), 0, REG_DWORD,
				(LPBYTE)&m_ImageListSettings.bNotLoadROMIcon, sizeof(m_ImageListSettings.bNotLoadROMIcon));

		//m_ImageListSettings.bNotLoadCompIcon
		RegSetValueEx(hKey, _T("NotLoadCompIcon"), 0, REG_DWORD,
				(LPBYTE)&m_ImageListSettings.bNotLoadCompIcon, sizeof(m_ImageListSettings.bNotLoadCompIcon));

		//m_ImageListSettings.bStuffingIcons
		RegSetValueEx(hKey, _T("StuffingIcons"), 0, REG_DWORD,
				(LPBYTE)&m_ImageListSettings.bStuffingIcons, sizeof(m_ImageListSettings.bStuffingIcons));
	}
}
//MOD END

//ADD START TODA
///////////////////////////////////////////////////////////////
void CListView::MainWindowReset(LPCTSTR lpszPath, int nAllSize)
{
	TCHAR szTemp[MAX_PATH];

	//JgtH_XV
	wcscpy(m_szCurrentFolder, lpszPath);

	//AhXo[փpXݒ
	g_MainWnd.m_CmdBands.SetFolderName(lpszPath);
	
	//ACeATCY\
	if (g_MainWnd.m_CmdBands.m_Settings.bShowAddressBar)
	{
		//AhXo[\
		TCHAR szItemCount[64];
		TCHAR szAllSize[64];
//MOD START GORIPON
		wsprintf(szTemp, _T("%d"), (m_dwUpperParam && wcslen(lpszPath) && wcsicmp(GetStringTable(IDS_SEARCH_FOLDER_NAME),lpszPath)!=0) ?
			ListView_GetItemCount(m_hWnd) - 1 : ListView_GetItemCount(m_hWnd));
//MOD END

		SetFormatInteger(szTemp, 64);
		wsprintf(szItemCount, GetStringTable(IDS_FMT_OBJECTSCOUNT), szTemp);	//MOD GORIPON
		wsprintf(szTemp, _T("%d"), nAllSize);
		SetFormatInteger(szTemp, 64);
		wsprintf(szAllSize, GetStringTable(IDS_FMT_TOTALBYTES), szTemp);	//MOD GORIPON
		g_MainWnd.m_StatusWnd.SetTwoPaneText(szItemCount, szAllSize);
	}
	else
	{
		//AhXo[\
		TCHAR szItemCount[64];
		TCHAR szAllSize[64];
		TCHAR szFolder[64];
//MOD START GORIPON
		wsprintf(szTemp, _T("%d"), (m_dwUpperParam && wcslen(lpszPath) && wcsicmp(GetStringTable(IDS_SEARCH_FOLDER_NAME),lpszPath)!=0) ?
			ListView_GetItemCount(m_hWnd) - 1 : ListView_GetItemCount(m_hWnd));
//MOD END

		SetFormatInteger(szTemp, 64);
		wsprintf(szItemCount, GetStringTable(IDS_FMT_OBJECTSCOUNT_S), szTemp);	//MOD GORIPON
		TCHAR szFmtKB[256], szFmtMB[256];
		wcscpy(szFmtKB, GetStringTable(IDS_FMT_TOTALBYTES_SKB));
		wcscpy(szFmtMB, GetStringTable(IDS_FMT_TOTALBYTES_SMB));
		SetFormatSize(nAllSize, szAllSize, szFmtKB, szFmtMB);
		LPTSTR lpszFolderName = wcsrchr(m_szCurrentFolder, _T('\\'));
		if (lpszFolderName)
			wcscpy(szFolder, ++lpszFolderName);
		else
			wcscpy(szFolder, GetRootName());

		g_MainWnd.m_StatusWnd.SetThreePaneText(szFolder, szItemCount, szAllSize);
	}

	//MOD START TODA (from GSFinder ver.1.99)
	//̃tH_ւLE
	g_MainWnd.m_CmdBands.SetEnableUpperFolder(wcslen(lpszPath) ? TRUE : FALSE);

	//iރ{^L/
	g_MainWnd.m_CmdBands.SetEnableFront(m_lpHistoryCurrent->lpNext ? TRUE : FALSE);
	
	//߂{^L/
	g_MainWnd.m_CmdBands.SetEnableBack(m_lpHistoryCurrent->lpPrev ? TRUE : FALSE);
	//MOD END
}

///////////////////////////////////////////////////////////////
void CListView::LoadFolderReset(LPCTSTR lpszPath)
{
	//ACeATCỸJEg
	UINT nAllSize = 0;

	//t@C̓ǂݍ
	TCHAR szTemp[MAX_PATH];
	wsprintf(szTemp, _T("%s\\*.*"), lpszPath);
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do
		{
			//ACet@C̏ꍇ̂
//MOD START GORIPON
			if(!(finddata.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY))
				//TCYJEg
				nAllSize += finddata.nFileSizeLow;
//MOD END
		}
		while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}
	
	//ʍč\z
	MainWindowReset(lpszPath, nAllSize);
	m_nFileSize = nAllSize;
}
///////////////////////////////////////////////////////////////
void CListView::LoadFolderSearch(LPCTSTR lpszPath)
{
	//J[\ɂ
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	//Xe[^Xo[\(\)
	TCHAR szTemp[MAX_PATH];
	wsprintf(szTemp, GetStringTable(IDS_FMT_LOADING));	//MOD GORIPON
	g_MainWnd.m_StatusWnd.SetSimpleText(szTemp);

	//ACeATCỸJEg
	UINT nAllSize = 0;

	//ACe̍폜
	DeleteAllItem();

	//ȍ~̃AhX폜
	SEARCHDATA *pCurrent = m_lpSearchData;
	while(pCurrent)
	{
		SEARCHDATA *pNext = pCurrent->lpNext;
		
		TCHAR szTemp[MAX_PATH];
		wsprintf(szTemp, _T("%s\\%s"), pCurrent->lpszPath, pCurrent->lpszName);
		if (GetFileAttributes(szTemp) == 0xFFFFFFFF)
		{
			//Xg̘A
			if(pCurrent->lpPrev) {
				pCurrent->lpPrev->lpNext = pNext;
			} else {
				m_lpSearchData = pNext;
			}
			if(pCurrent->lpNext) {
				pCurrent->lpNext->lpPrev = pCurrent->lpPrev;
			}
			//ACe̍폜
			pCurrent->lpNext = NULL;
			DeleteSearch(pCurrent);
		}
		else
		{
			//ACe̒ǉ
			AddFolderItemSub(pCurrent->lpszPath,
							 pCurrent->lpszName,
							 pCurrent->dwAttr,
							 pCurrent->ft,
							 pCurrent->dwSize,
//MOD START GORIPON
							 &nAllSize);
//MOD END
		}

		//̃o
		pCurrent = pNext;

	} //End of while

//ADD START GORIPON
	//zXgr[̍ڐݒ
	ListView_SetItemCountEx(m_hWnd, m_ItemStruct.GetCount(), 0);
//ADD END

	// \[g
	if (m_ItemStruct.GetCount())	//MOD GORIPON
		SortList();

	//ʍč\z
	MainWindowReset(lpszPath, nAllSize);
	m_nFileSize = nAllSize;

//MOD START GORIPON
	//c[r[XV
	g_MainWnd.m_TreeView.SetCurrentFolder(lpszPath, FALSE, TRUE);

	//ACeI
	ListView_SetItemState(m_hWnd, 0, LVIS_SELECTED, LVIS_SELECTED);
	ListView_SetItemState(m_hWnd, 0, LVIS_FOCUSED, LVIS_FOCUSED);

	//J[\ɖ߂
	SetCursor(hCursor);
//MOD END
}

///////////////////////////////////////////////////////////////
//ADD START GORIPON
BOOL SeekUpperFloder(LPARAM lParam1, LPARAM lParam2)
{
	LISTITEMCOMP* plic = (LISTITEMCOMP*)lParam1;
	LPTSTR upfolder = (LPTSTR)lParam2;

	return (wcscmp(plic->lpszName, upfolder) != 0);
}
//ADD END
void CListView::LoadFolderFiles(LPCTSTR lpszPath, BOOL bTVUpdate)
{
	//J[\ɂ
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	//Xe[^Xo[\(\)
	TCHAR szTemp[MAX_PATH];
	wsprintf(szTemp, GetStringTable(IDS_FMT_LOADING));	//MOD GORIPON
	g_MainWnd.m_StatusWnd.SetSimpleText(szTemp);

	//ǉ
	m_lpHistoryCurrent = AddHistory(m_lpHistoryCurrent, lpszPath);
	if(!m_lpHistory)
		m_lpHistory = m_lpHistoryCurrent;

	//ACeATCỸJEg
	UINT nAllSize = 0;

	//ACe̍폜
	DeleteAllItem();

	// ̃tH_ւǉ
	if (wcslen(lpszPath) && m_Settings.bAddUpper)
		AddUpper();
	else
		m_dwUpperParam = NULL;

	//ÕtH_𔻒
	LPTSTR lpszUpprFolder = NULL;
	if(wcslen(m_szOldFolder)!=0) {
		if(lpszUpprFolder=wcsrchr(m_szOldFolder, _T('\\'))) {
			if(wcsncmp(lpszPath, m_szOldFolder, (lpszUpprFolder-m_szOldFolder))==0) {
				lpszUpprFolder++;
			} else {
				lpszUpprFolder=NULL;
			}
		}
	}

	//t@C̓ǂݍ
	//BOOL bSelect=FALSE;	//DEL GORIPON
	wsprintf(szTemp, _T("%s\\*.*"), lpszPath);
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do
		{
			//tH_\̏ꍇtH_𖳎
//MOD START GORIPON
			if(m_bHideFolder && (finddata.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY))
				continue;
//MOD END

//DEL START GORIPON
			////ACeI
			//BOOL bItemSelect=FALSE;
			//if(lpszUpprFolder) {
			//	if(wcscmp(lpszUpprFolder, finddata.cFileName) == 0)
			//		bSelect=bItemSelect=TRUE;
			//}
//DEL END

			//ACeǉ
			AddFolderItem(&finddata, lpszPath, &nAllSize);	//MOD GORIPON
		}
		while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

//ADD START GORIPON
	//zXgr[̍ڐݒ
	ListView_SetItemCountEx(m_hWnd, m_ItemStruct.GetCount(), 0);
//ADD END

	// \[g
	if (m_ItemStruct.GetCount())	//MOD GORIPON
		SortList();

	//ʍč\z
	MainWindowReset(lpszPath, nAllSize);
	m_nFileSize = nAllSize;

//MOD START GORIPON
	//c[r[XV
	g_MainWnd.m_TreeView.SetCurrentFolder(lpszPath, bTVUpdate);

	//ACeI
	int nItem = 0;
	if (lpszUpprFolder)
	{
		nItem = m_ItemStruct.Find((LPFINDFUNC)SeekUpperFloder, 0, (DWORD)lpszUpprFolder);
		if (nItem < 0)
			nItem = 0;
	}
	ListView_SetItemState(m_hWnd, -1, 0, LVIS_SELECTED);
	ListView_SetItemState(m_hWnd, nItem, LVIS_SELECTED, LVIS_SELECTED);
	ListView_SetItemState(m_hWnd, nItem, LVIS_FOCUSED, LVIS_FOCUSED);
	ListView_EnsureVisible(m_hWnd, nItem, FALSE);

	//J[\ɖ߂
	SetCursor(hCursor);
//MOD END

	//OpXƂăpXۑ
	wcscpy(m_szOldFolder, lpszPath);
}

///////////////////////////////////////////////////////////////
void CListView::LoadFolderItem(LPCTSTR lpszPath, BOOL bTVUpdate)
{
	//ADD START TODA (t@CύXʒm from Y.Nagamidori)
	//XVʒmsv
	DisableUpdateNotify();
	//ADD END

	//ĕ`~
	SendMessage(m_hWnd, WM_SETREDRAW, (WPARAM)0, (LPARAM)0);

	//̏ꍇ
	if(0 == wcscmp(lpszPath, GetStringTable(IDS_SEARCH_FOLDER_NAME)))	//MOD GORIPON
		LoadFolderSearch(lpszPath);
	else
		LoadFolderFiles(lpszPath, bTVUpdate);

	//ĕ`Jn
	SendMessage(m_hWnd, WM_SETREDRAW, (WPARAM)1, (LPARAM)0);

	//ADD START TODA (t@CύXʒm from Y.Nagamidori)
	SetUpdateNotify(lpszPath);
	EnableUpdateNotify();
	//ADD END
}

///////////////////////////////////////////////////////////////
void CListView::LoadFolderItemSub(LPCTSTR lpszPath)
{
	//ĕ`~
	SendMessage(m_hWnd, WM_SETREDRAW, (WPARAM)0, (LPARAM)0);

	//ACe폜
	DeleteAllItem();

	// ̃tH_ւݒ肵Ȃ
	m_dwUpperParam = NULL;

	//ACeATCỸJEgp
	UINT nAllSize = 0;

	//t@C̓ǂݍ
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(lpszPath, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		//pXƃfBNg𕪗
		TCHAR szPath[MAX_PATH];
		wcscpy(szPath, lpszPath);
		LPTSTR lpszTemp = wcsrchr(szPath, _T('\\'));
		*lpszTemp = 0x00;

		//ACeǉ
		AddFolderItem(&finddata, szPath, &nAllSize);

		//nhN[Y
		FindClose(hFind);
	}
	
	//JgtH_ݒ
	wcscpy(m_szCurrentFolder, lpszPath);

	//ĕ`Jn
	SendMessage(m_hWnd, WM_SETREDRAW, (WPARAM)1, (LPARAM)0);
}

///////////////////////////////////////////////////////////////
void CListView::SelectFile(LPCTSTR lpszPath)
{
	//ADD START TODA ([g̃pXݒ - advice by Y.Nagamidori)
	//[gfBNg̏ꍇ
	if(wcslen(lpszPath) == 0 || wcscmp(lpszPath, GetRootName()) == 0)
		wcscpy(m_szCurrentFolder, _T(""));
	//ADD END
	else
	{
		//fBNgֈړ
		LoadFolderItemSub(lpszPath);
	
		//SẴACeIԂƂ
		ListView_SetItemState(m_hWnd, -1, LVIS_SELECTED, LVIS_SELECTED);
	}
}
//ADD END

///////////////////////////////////////////////////////////////
void CListView::AddUpper()
{
	// ̃tH_ւǉ
	LISTITEMCOMP *plic = new LISTITEMCOMP;
	memset(plic, 0, sizeof(LISTITEMCOMP));
	plic->nItem = LIST_ITEM_UPPER;

//MOD START GORIPON
	plic->lpszName = new TCHAR[2+1];
	wcscpy(plic->lpszName, _T(".."));
	m_ItemStruct.Insert((DWORD)plic);
	m_dwUpperParam = (DWORD)plic;
//MOD END
}

//MOD START GORIPON
///////////////////////////////////////////////////////////////
void CListView::AddFolderItemFolder(LPCTSTR lpszPath, LPCTSTR lpszName, DWORD dwAttr, FILETIME ft, DWORD dwSize, UINT* lpAllSize)
{
	//Bt@C`FbN
	if ((dwAttr & FILE_ATTRIBUTE_HIDDEN) && m_Settings.bHideHidden)
		return;

	//tH_
	LISTITEMCOMP *plic = new LISTITEMCOMP;
	plic->nItem = LIST_ITEM_FOLDER;
	plic->lpszName = new TCHAR[wcslen(lpszName)+1];
	wcscpy(plic->lpszName, lpszName);
	plic->lpszPath = new TCHAR[wcslen(lpszPath)+1];
	wcscpy(plic->lpszPath, lpszPath);
	plic->dwSize = 0;
	plic->ft = ft;
	plic->dwAttr = dwAttr;
	m_ItemStruct.Add((DWORD)plic);
}
///////////////////////////////////////////////////////////////
void CListView::AddFolderItemFile(LPCTSTR lpszPath, LPCTSTR lpszName, DWORD dwAttr, FILETIME ft, DWORD dwSize, UINT* lpAllSize)
{
	//Bt@C`FbN
	if ((dwAttr & FILE_ATTRIBUTE_HIDDEN) && m_Settings.bHideHidden)
		return;

	//VXet@C`FbN
	if ((dwAttr & FILE_ATTRIBUTE_SYSTEM) && m_Settings.bHideSystem)
		return;

	//ROM`FbN
	if ((dwAttr & FILE_ATTRIBUTE_INROM) && m_Settings.bHideROM)
		return;

	// t@C
	LISTITEMCOMP *plic = new LISTITEMCOMP;
	plic->nItem = LIST_ITEM_FILE;
	plic->lpszName = new TCHAR[wcslen(lpszName)+1];
	wcscpy(plic->lpszName, lpszName);
	plic->lpszPath = new TCHAR[wcslen(lpszPath)+1];
	wcscpy(plic->lpszPath, lpszPath);
	plic->dwSize = dwSize;
	plic->ft = ft;
	plic->dwAttr = dwAttr;
	FileTimeToLocalFileTime(&plic->ft, &plic->ft);
	*lpAllSize += dwSize;
	m_ItemStruct.Add((DWORD)plic);
}
///////////////////////////////////////////////////////////////
void CListView::AddFolderItemSub(LPCTSTR lpszPath, LPCTSTR lpszName, DWORD dwAttr, FILETIME ft, DWORD dwSize, UINT* lpAllSize)
{
	if (FILE_ATTRIBUTE_DIRECTORY == (dwAttr & FILE_ATTRIBUTE_DIRECTORY))
		AddFolderItemFolder(lpszPath, lpszName, dwAttr, ft, dwSize, lpAllSize);
	else
		AddFolderItemFile(lpszPath, lpszName, dwAttr, ft, dwSize, lpAllSize);
}
//MOD END

///////////////////////////////////////////////////////////////
void CListView::AddFolderItem(WIN32_FIND_DATA *finddata, LPCTSTR lpszPath, UINT* lpAllSize)	//MOD GORIPON (p[^폜)
{
	//MDD START TODA (AddFolderItemSub()̌ĂяoɕύX)
	if(finddata->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
	{
		AddFolderItemFolder(lpszPath,	//MOD GORIPON
						 finddata->cFileName,
						 finddata->dwFileAttributes,
						 finddata->ftCreationTime,
						 0,
//MOD START GORIPON
						 lpAllSize);
//MOD END
	}
	else
	{
		AddFolderItemFile(lpszPath,		//MOD GORIPON
						 finddata->cFileName,
						 finddata->dwFileAttributes,
						 finddata->ftLastWriteTime,
						 finddata->nFileSizeLow,
//MOD START GORIPON
						 lpAllSize);
//MOD END
	}
	//MDD END
}
//ADD START TODA (t@CI[vʉ)
///////////////////////////////////////////////////////////////
void CListView::ComFileOpen(LPCTSTR lpszPath)
{
	//gq݂̂Rs[
	LPTSTR lpszExt = wcsrchr(lpszPath, _T('.'));

	//ŏIIɃI[vpX
	LPTSTR lpszOpen = (LPTSTR)lpszPath;
	LPTSTR lpszParam = NULL;			//ADD TODA
	
	//gq`FbN
	if (wcsicmp(lpszExt, _T(".LNK"))==0)
	{
		//Nt@CƔF
		TCHAR szPath[MAX_PATH];
		if (SHGetShortcutTarget(lpszPath, szPath, MAX_PATH))
		{
			LPTSTR lpszStart = szPath;
			if(lpszStart[0] == _T('\"'))
			{
				LPTSTR lpszEnd = wcschr(++lpszStart, _T('\"'));
				if(lpszEnd)
				{
					*lpszEnd=0x00;
					if(*(++lpszEnd)) lpszParam=lpszEnd;
				}
			}
			else
			{
				LPTSTR lpszEnd = wcschr(lpszStart, _T(' '));
				if(lpszEnd)
				{
					*lpszEnd=0x00;
					if(*(++lpszEnd)) lpszParam=lpszEnd;
				}
			}
			
			//p[^l(󔒍폜)
			while(lpszParam)
			{
				if(!(*lpszParam))
					break;

				if(*lpszParam == _T(' '))
					lpszParam++;
				else
					break;

			} //End of while

			HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));	//ADD TODA (from GSFinder ver.1.99)
			DWORD dwAttr = GetFileAttributes(lpszStart);
			SetCursor(hCursor);											//ADD TODA (from GSFinder ver.1.99)
			//fBNg̏ꍇ
			if (FILE_ATTRIBUTE_DIRECTORY == (dwAttr & FILE_ATTRIBUTE_DIRECTORY) && dwAttr != 0xFFFFFFFF)
			{
				LoadFolderItem(lpszStart);
				return;
			}
			
			//pX擾Nɐݒ
			lpszOpen = lpszStart;
			
			//gq݂̂ăRs[
			LPTSTR lpszExt = wcsrchr(lpszStart, _T('.'));
		}
	}

	//kt@C𔻒
	if((m_Settings.bDblClick) &&
	   ((g_MainWnd.m_Compress.IsCompress(COMPDLL_MODE_LHA) && wcsicmp(lpszExt, _T(".LZH"))==0) ||
	    (g_MainWnd.m_Compress.IsCompress(COMPDLL_MODE_ZIP) && wcsicmp(lpszExt, _T(".ZIP"))==0)))
	{
		//t@C𓀂̎s
		OnFileUnCompress();
		return;
	}
	
	//J
	SHELLEXECUTEINFO sei;
	sei.cbSize = sizeof(SHELLEXECUTEINFO);
	sei.fMask = 0;
	sei.hwnd = g_MainWnd.m_hWnd;
	sei.lpVerb = _T("open");
	sei.lpFile = lpszOpen;
	sei.lpParameters = lpszParam;
	sei.lpDirectory = NULL;
	sei.nShow = SW_SHOW;
	sei.hInstApp = g_hInst;
	ShellExecuteEx(&sei);
}
//ADD END
///////////////////////////////////////////////////////////////
//\`̕ύX
void CListView::OnChangeListStyle(UINT nCmdID)
{
//	ShowWindow(m_hWnd, SW_HIDE);	//DEL TODA
	//m_Settings.dwListExStyle = 0; //del by kawa
	//MOD START TODA (from GSFinder ver.1.99)
	DWORD dwStyle = 0;
	switch (nCmdID)
	{
		case ID_VIEW_LARGEICON:
			m_Settings.dwListExStyle = 0; //add by kawa
			m_Settings.dwListStyle = LVS_ICON;
			break;
		case ID_VIEW_SMALLICON:
			m_Settings.dwListExStyle = 0; //add by kawa
			m_Settings.dwListStyle = LVS_SMALLICON;
			break;
		case ID_VIEW_LIST:
			m_Settings.dwListExStyle = 0; //add by kawa
			m_Settings.dwListStyle = LVS_LIST;
			break;
		case ID_VIEW_REPORT:
			m_Settings.dwListExStyle = 0; //add by kawa
			m_Settings.dwListStyle = LVS_REPORT;
			break;
		//ADD START TODA
		case ID_VIEW_REPORTLINE:
			m_Settings.dwListExStyle = LVS_EX_FULLROWSELECT;
			m_Settings.dwListStyle = LVS_REPORT;
			break;
		default:
			//ȂɂȂ(ݒ̂܂)
			break;
		//ADD END
	}
	dwStyle = DEF_LIST_STYLE | m_Settings.dwListStyle;
	//MOD END
	if (m_Settings.dwListStyle == LVS_REPORT && m_Settings.bHideHeader)
		dwStyle |= LVS_NOCOLUMNHEADER;
	if ((m_Settings.dwListStyle&LVS_TYPEMASK)==LVS_ICON)
		m_pFileImageList = &m_FileImageListLarge;
	else
		m_pFileImageList = &m_FileImageListSmall;

	SetWindowLong(m_hWnd, GWL_STYLE, dwStyle);
	g_MainWnd.m_CmdBands.SetCheckListStyle(m_Settings.dwListStyle, m_Settings.dwListExStyle);	//MOD TODA

	//MOD START TODA (from GSFinder ver.1.99)
	if (m_Settings.dwListStyle == LVS_REPORT && m_Settings.dwListExStyle)
		ListView_SetExtendedListViewStyle(m_hWnd, ListView_GetExtendedListViewStyle(m_hWnd) | DEF_LIST_EXSTYLE|m_Settings.dwListExStyle);
	//MOD END
	else
		ListView_SetExtendedListViewStyle(m_hWnd, 0);

	if (m_Settings.dwListStyle == LVS_ICON)
//MOD START GORIPON (nC]Ή)
	{
		int is = (g_MainWnd.m_ListView.m_ImageListSettings.bStuffingIcons)? 56: 72;
		is = (g_MainWnd.m_bHighRresolutionMode||!g_MainWnd.m_bHighDpiHardware)? is:((int)(is*g_MainWnd.m_fpHighResolutionScale));
		ListView_SetIconSpacing(m_hWnd, is, is);
	}
//MOD END
	ListView_Arrange(m_hWnd, LVA_DEFAULT);
//	ShowWindow(m_hWnd, SW_SHOW);	//DEL TODA
//	UpdateWindow(m_hWnd);			//DEL TODA
//	SetFocus(m_hWnd);				//DEL TODA

	//ʍXV
	InvalidateRect(g_MainWnd.m_hWnd, NULL, FALSE);
}
///////////////////////////////////////////////////////////////
//Xg̕בւ
void CListView::OnChangeSort(UINT nCmdID)
{
	switch (nCmdID)
	{
		case ID_VIEW_SORT_NAME: m_Settings.nSort = LIST_SORT_NAME; break;
		case ID_VIEW_SORT_EXT: m_Settings.nSort = LIST_SORT_EXT; break;
		case ID_VIEW_SORT_SIZE: m_Settings.nSort = LIST_SORT_SIZE; break;
		case ID_VIEW_SORT_TIME: m_Settings.nSort = LIST_SORT_TIME; break;
		case ID_VIEW_SORT_NOT_RAISE: m_Settings.bSortRaise = !m_Settings.bSortRaise; break;
	}

	SortList();
	
	g_MainWnd.m_CmdBands.SetCheckSort(m_Settings.nSort, m_Settings.bSortRaise);
}
///////////////////////////////////////////////////////////////
void CListView::OnViewUpdate(LPCTSTR lpszPath) //MOD TODA (p[^ǉ)
{
	TCHAR szTemp[MAX_PATH];
	//MOD START TODA (pXw莞̏ǉ)
	if(lpszPath)
		wcscpy(szTemp, lpszPath);
	else
		GetWindowText(g_MainWnd.m_CmdBands.m_hComboBox, szTemp, MAX_PATH);
	//MOD END

	if (wcscmp(szTemp, GetRootName()) == 0 || wcscmp(szTemp, _T("\\")) == 0 ||
		wcscmp(szTemp, _T("\\\\")) == 0 || wcscmp(szTemp, _T("/")) == 0 || wcslen(szTemp) == 0)
		LoadFolderItem(_T(""));
	else
	{
		//ADD START TODA
		//zpX̏ꍇ`FbNȂ
		if(0 == wcscmp(GetStringTable(IDS_SEARCH_FOLDER_NAME), szTemp))	//MOD GORIPON
		{
			LoadFolderItem(szTemp);
			return;
		}
		//ADD END

		//݂邩̊mF
		HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));	//ADD TODA (from GSFinder ver.1.99)
		DWORD dwAttr = GetFileAttributes(szTemp);
		SetCursor(hCursor);											//ADD TODA (from GSFinder ver.1.99)
		if (dwAttr != 0xFFFFFFFF)
		{
			if (FILE_ATTRIBUTE_DIRECTORY == (dwAttr & FILE_ATTRIBUTE_DIRECTORY))
				LoadFolderItem(szTemp);
			else
			{
				//ADD START TODA (t@CI[vʏĂяo) 
				ComFileOpen(szTemp);
				//ADD END

//DEL START TODA (t@CI[vʏĂяoɕύX)
//				//t@CJ
//				SHELLEXECUTEINFO sei;
//				sei.cbSize = sizeof(SHELLEXECUTEINFO);
//				sei.fMask = 0;
//				sei.hwnd = g_MainWnd.m_hWnd;
//				sei.lpVerb = _T("open");
//				sei.lpFile = szTemp;
//				sei.lpParameters = NULL;
//				sei.lpDirectory = NULL;
//				sei.nShow = SW_SHOW;
//				sei.hInstApp = g_hInst;
//				ShellExecuteEx(&sei);
//DEL END
			}
		}
		else
			MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_NOTFOUND_PATH), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON
	}
}
///////////////////////////////////////////////////////////////
void CListView::OnViewUpFolder()
{
//	TCHAR szPath[MAX_PATH] = _T("");	//DEL TODA (from GSFinder ver.1.99)

//ADD START GORIPON
	if (wcscmp(m_szCurrentFolder, GetStringTable(IDS_SEARCH_FOLDER_NAME)) == 0)
	{
		*m_szOldFolder = _T('\0');
		LoadFolderItem(_T(""));
	}
	else
//ADD END
	if (wcscmp(m_szCurrentFolder, _T(""))!=0)
	{
		LPTSTR lpszTemp = wcsrchr(m_szCurrentFolder, _T('\\'));
		if (lpszTemp)
		{
			*lpszTemp = NULL;
			if (wcscmp(m_szCurrentFolder, _T("\\")) == 0)
				*m_szCurrentFolder = _T('\0');	//MOD GORIPON
			LoadFolderItem(m_szCurrentFolder);
		}
		else
			LoadFolderItem(_T(""));
	}
}

///////////////////////////////////////////////////////////////
void CListView::OnFileOpen()
{
	int nIndex = GetSelectedItemIndex(0);
	OnFileOpen(nIndex);
}
///////////////////////////////////////////////////////////////
void CListView::OnFileOpen(int nIndex)
{
	if (nIndex != -1)
	{
		LISTITEMCOMP *plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_FOLDER)
		{
			//tH_J
			TCHAR szPath[MAX_PATH];
			//MOD START TODA
//			wsprintf(szPath, _T("%s\\%s"), m_szCurrentFolder, plic->lpszName);
			wsprintf(szPath, _T("%s\\%s"), plic->lpszPath, plic->lpszName);
			//MOD END
			LoadFolderItem(szPath);
		}
		else if (plic->nItem == LIST_ITEM_FILE)
		{
			//t@CJ
			TCHAR szPath[MAX_PATH];

			//MOD START TODA (t@CI[vʏĂяo)
			wsprintf(szPath, _T("%s\\%s"), plic->lpszPath, plic->lpszName);
			ComFileOpen(szPath);
			//MOD END
		}
		else if (plic->nItem == LIST_ITEM_UPPER)
			OnViewUpFolder();
	}
}

///////////////////////////////////////////////////////////////
void CListView::OnItemChanged()				//MOD TODA (폜)
{
	g_MainWnd.m_CmdBands.SetEnableItemSelected();
}

///////////////////////////////////////////////////////////////
void CListView::OnFileCreateFolder()
{
	int nCount = 1;
	TCHAR szFolderPath[MAX_PATH];
	TCHAR szFolderName[MAX_PATH];
	BOOL bRet = FALSE;
	DisableUpdateNotify();						//ADD TODA (t@CύXʒm from Y.Nagamidori)
	while(!bRet)
	{
		if (nCount==1)
		{
//MOD START GORIPON
			wsprintf(szFolderPath, _T("%s\\%s"), m_szCurrentFolder, GetStringTable(IDS_NEW_FOLDER_NAME));
			wsprintf(szFolderName, _T("%s"), GetStringTable(IDS_NEW_FOLDER_NAME));
//MOD END
		}
		else
		{
//MOD START GORIPON
			wsprintf(szFolderPath, _T("%s\\%s(%d)"), m_szCurrentFolder, GetStringTable(IDS_NEW_FOLDER_NAME), nCount);
			wsprintf(szFolderName, _T("%s(%d)"), GetStringTable(IDS_NEW_FOLDER_NAME), nCount);
//MOD END
		}
		nCount++;
		bRet = CreateDirectory(szFolderPath, NULL);
		if (nCount > 4096)
		{
			MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_CANNOTCREATEFOLDER), NULL, MB_OK);	//MOD GORIPON
			EnableUpdateNotify();				//ADD TODA (t@CύXʒm from Y.Nagamidori)
			return;
		}
	}
	LoadFolderItem(m_szCurrentFolder, TRUE);	//MOD TODA
	LVFINDINFO lvfi;
	lvfi.flags = LVFI_STRING;
	lvfi.psz = szFolderName;

	//SipShowIM(SIPF_ON);	//DEL GORIPON
	SetFocus(m_hWnd);							//ADD TODA
	ListView_EditLabel(m_hWnd, ListView_FindItem(m_hWnd, -1, &lvfi));
	EnableUpdateNotify();						//ADD TODA (t@CύXʒm from Y.Nagamidori)
}
///////////////////////////////////////////////////////////////
BOOL CListView::OnEndLabelEdit(LV_DISPINFO* pdi)
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pdi;

	int nIndex = pDispInfo->item.iItem;
	if (!pDispInfo->item.pszText) return FALSE;

	//G[`FbN
	if (wcschr(pDispInfo->item.pszText, _T('\\'))!=NULL || wcschr(pDispInfo->item.pszText, _T('/'))!=NULL || wcschr(pDispInfo->item.pszText, _T(':'))!=NULL || wcschr(pDispInfo->item.pszText, _T(','))!=NULL || wcschr(pDispInfo->item.pszText, _T(';'))!=NULL || wcschr(pDispInfo->item.pszText, _T('*'))!=NULL || wcschr(pDispInfo->item.pszText, _T('?'))!=NULL || wcschr(pDispInfo->item.pszText, _T('<'))!=NULL || wcschr(pDispInfo->item.pszText, _T('>'))!=NULL || wcschr(pDispInfo->item.pszText, _T('|'))!=NULL)
	{
		MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_CANNOTUSECHAR), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON
		SetFocus(m_hWnd);							//ADD TODA
		ListView_EditLabel(m_hWnd, nIndex);
		return FALSE;
	}
	else
	{
		LISTITEMCOMP* plic = GetListItemStruct(nIndex);
		TCHAR szOldName[MAX_PATH];
		TCHAR szNewName[MAX_PATH];
		wcscpy(szOldName,  plic->lpszName);
		wcscpy(szNewName,  pDispInfo->item.pszText);

		if (plic->nItem == LIST_ITEM_UPPER)
			return FALSE;

		//gq\Ȃݒł͊gq
		if (m_Settings.bNotShowExt && plic->nItem == LIST_ITEM_FILE)
			SetExtFromFileName(szNewName, szOldName);
		if (wcslen(pDispInfo->item.pszText))
		{
			TCHAR szNewPath[MAX_PATH];
			TCHAR szOldPath[MAX_PATH];

			//MOD START TODA
//			wsprintf(szOldPath, _T("%s\\%s"), m_szCurrentFolder, szOldName);
//			wsprintf(szNewPath, _T("%s\\%s"), m_szCurrentFolder, szNewName);
			wsprintf(szOldPath, _T("%s\\%s"), plic->lpszPath, szOldName);
			wsprintf(szNewPath, _T("%s\\%s"), plic->lpszPath, szNewName);
			//MOD END
			DisableUpdateNotify();					//ADD TODA (t@CύXʒm from Y.Nagamidori)
			if (MoveFile(szOldPath, szNewPath)!=0)
			{
				EnableUpdateNotify();				//ADD TODA (t@CύXʒm from Y.Nagamidori)

				//\̂̕ύX
				delete[] plic->lpszName;
				if (plic->lpszDispName) delete[] plic->lpszDispName;
				if (plic->lpszDispSize) delete[] plic->lpszDispSize;
				if (plic->lpszDispType) delete[] plic->lpszDispType;
				if (plic->lpszDispTime) delete[] plic->lpszDispTime;
				plic->lpszDispName = NULL;
				plic->lpszDispSize = NULL;
				plic->lpszDispType = NULL;
				plic->lpszDispTime = NULL;
				plic->lpszName = new TCHAR[wcslen(szNewName)+1];
				wcscpy(plic->lpszName, szNewName);
				if (plic->nItem != LIST_ITEM_FOLDER)
					plic->nIcon = -1;
				
				//ADD START TODA (ʃtH_)
				if(0 == wcscmp(m_szCurrentFolder, GetStringTable(IDS_SEARCH_FOLDER_NAME)))	//MOD GORIPON
					EditSearch(plic->lpszPath, szOldName, plic->lpszPath, szNewName);
				//ADD END

				//DEL START TODA (̈)
//				//\̃tbV
//				ShowWindow(m_hWnd, SW_HIDE);
//				ShowWindow(m_hWnd, SW_SHOW);
				//DEL END
				//ADD START TODA (c[r[̍XVǉ)
				g_MainWnd.m_TreeView.SetCurrentFolder(m_szCurrentFolder);
				//ADD END
			}
			else
			{
				MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_RENAMEERROR), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON
				EnableUpdateNotify();				//ADD TODA (t@CύXʒm from Y.Nagamidori)
				return FALSE;
			}

		}
		else
		{
			//s
			MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_INPUTNAME), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON
			SetFocus(m_hWnd);						//ADD TODA
			ListView_EditLabel(m_hWnd, nIndex);
			return FALSE;
		}
	}
	return TRUE;
}
///////////////////////////////////////////////////////////////
void CListView::OnFileRename()
{
	int nIndex = GetSelectedItemIndex(0);
	if (nIndex != -1)
	{
		//SipShowIM(SIPF_ON);						//DEL GORIPON
		SetFocus(m_hWnd);							//ADD TODA
		ListView_EditLabel(m_hWnd, nIndex);
	}
}
////////////////////////////////////////////////////////////////
int CListView::GetSelectedItemIndex(int nStart)
{
//MOD START TODA (̈)
	//int nItemCount = ListView_GetItemCount(m_hWnd);
	//for (int i= nStart; i<nItemCount; i++)
	//{
	//	if (ListView_GetItemState(m_hWnd, i, LVIS_SELECTED)==LVIS_SELECTED)
	//		return i;
	//}
	//return -1;
	return ListView_GetNextItem(m_hWnd, (nStart-1), LVNI_SELECTED);
//MOD END
}

////////////////////////////////////////////////////////////////
void CListView::OnEditCopyFileName() 
{
	int nIndex = GetSelectedItemIndex(0);
	if (nIndex != -1)
	{
		LISTITEMCOMP *plic = GetListItemStruct(nIndex);
		if (OpenClipboard(g_MainWnd.m_hWnd))
		{
			EmptyClipboard();
			HANDLE hHandle = LocalAlloc(LMEM_FIXED , sizeof(TCHAR)*(wcslen(plic->lpszName)+1));
			TCHAR* lpsz = (TCHAR*)LocalLock(hHandle);
			wcscpy(lpsz, plic->lpszName);
			LocalUnlock(hHandle);
			SetClipboardData(CF_UNICODETEXT, hHandle);
			CloseClipboard();
		}
	}
}

////////////////////////////////////////////////////////////////
LISTITEMCOMP* CListView::GetListItemStruct(int nIndex)
{
//MOD START GORIPON
	return (LISTITEMCOMP*)m_ItemStruct.GetAt(nIndex);
//MOD END
}

////////////////////////////////////////////////////////////////
void CListView::OnEditCopyFilePath() 
{
	int nIndex = GetSelectedItemIndex(0);
	if (nIndex != -1)
	{
		LISTITEMCOMP *plic = GetListItemStruct(nIndex);

		TCHAR szPath[MAX_PATH];
		//MOD START TODA
//		wsprintf(szPath, _T("%s\\%s"), m_szCurrentFolder, plic->lpszName);
		wsprintf(szPath, _T("%s\\%s"), plic->lpszPath, plic->lpszName);
		//MOD END
		if (OpenClipboard(g_MainWnd.m_hWnd))
		{
			EmptyClipboard();
			HANDLE hHandle = LocalAlloc(LMEM_FIXED , sizeof(TCHAR)*(wcslen(szPath)+1));
			TCHAR* lpsz = (TCHAR*)LocalLock(hHandle);
			wcscpy(lpsz, szPath);
			LocalUnlock(hHandle);
			SetClipboardData(CF_UNICODETEXT , hHandle);
			CloseClipboard();
		}
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnSelEndOK()
{
	TCHAR szTemp[MAX_PATH];
	SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETLBTEXT,
		SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETCURSEL, 0, 0), (LPARAM)szTemp);

	SetFocus(m_hWnd);

	//ADD START TODA(OnViewUpdate()Ăяoǉ)
	//AhXo[̃R}hs
	OnViewUpdate(szTemp);
	//ADD END

//DEL START TODA (OnViewUpdate()Ăяoɂď\Ȉ)
//	if (wcscmp(szTemp, GetRootName())==0 || wcscmp(szTemp, _T("\\"))==0 || wcslen(szTemp)==0)
//	{
//		LoadFolderItem(_T(""));
//		SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETLBTEXT, SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETCURSEL, 0, 0), (LPARAM)szTemp);
//	}
//	else
//	{
//		//݂邩̊mF
//		DWORD dwAttr = GetFileAttributes(szTemp);
//		if (dwAttr != 0xFFFFFFFF)
//		{
//			if ((dwAttr&FILE_ATTRIBUTE_DIRECTORY)==FILE_ATTRIBUTE_DIRECTORY)
//				LoadFolderItem(szTemp);
//			else
//			{
//				//t@CJ
//				SHELLEXECUTEINFO sei;
//				sei.cbSize = sizeof(SHELLEXECUTEINFO);
//				sei.fMask = 0;
//				sei.hwnd = g_MainWnd.m_hWnd;
//				sei.lpVerb = _T("open");
//				sei.lpFile = szTemp;
//				sei.lpParameters = NULL;
//				sei.lpDirectory = NULL;
//				sei.nShow = SW_SHOW;
//				sei.hInstApp = g_hInst;
//				ShellExecuteEx(&sei);
//			}
//		}
//		else
//			MessageBox(g_MainWnd.m_hWnd, IDS_MSG_NOTFOUND_PATH, NULL, MB_OK|MB_ICONSTOP);
//	}
//DEL END
}
//MOD START TODA (from GSFinder ver.1.99)
////////////////////////////////////////////////////////////////
void CListView::OnFileCreateShortcut()
{
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	//V[gJbg̍쐬
	int nIndex = GetSelectedItemIndex(0);
	while(nIndex != -1)
	{
		LISTITEMCOMP* plic = GetListItemStruct(nIndex);
		CreateShortcut(m_szCurrentFolder, plic->lpszPath, plic->lpszName); //MOD TODA
		nIndex = GetSelectedItemIndex(nIndex+1);
	}
	LoadFolderItem(m_szCurrentFolder, FALSE);	//MOD TODA

	SetCursor(hCursor);
}
////////////////////////////////////////////////////////////////
void CListView::OnFileShortcutFolder(LPTSTR lpszPath)	//MOD TODA (ǉ)
{
	TCHAR szFolder[MAX_PATH];
	BOOL bRefresh = FALSE;						//ADD TODA
	int Rtn = IDOK;								//ADD TODA
	//MOD START TODA (pXwΉ)
	if(lpszPath)
		wcscpy(szFolder, lpszPath);
	else
	{
		wcscpy(szFolder, m_szCurrentFolder);
		CFolderDlg fd;
//MOD START GORIPON
		LPTSTR lpszTitle = DupStringTable(IDS_TITLE_SHORTCUT);
		Rtn = fd.ShowFolderDlg(lpszTitle, szFolder, MAX_PATH);
		FreeStringTable(lpszTitle);
//MOD END
	}
	if(Rtn==IDOK)
	//MOD END
	{
		//ADD TODA
		if(wcsicmp(szFolder, m_szCurrentFolder) == 0)
			bRefresh = TRUE;

		//ADD END
		HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

		//V[gJbg̍쐬
		int nIndex = GetSelectedItemIndex(0);
		while(nIndex != -1)
		{
			LISTITEMCOMP* plic = GetListItemStruct(nIndex);
			CreateShortcut(szFolder, plic->lpszPath, plic->lpszName);
			nIndex = GetSelectedItemIndex(nIndex + 1);
		}
		SetCursor(hCursor);
	}

	//ADD START TODA
	if(bRefresh)
		LoadFolderItem(m_szCurrentFolder, FALSE);
	//ADD END
}
//MOD END
////////////////////////////////////////////////////////////////
void CListView::OnViewFolder()
{
	TCHAR szPath[MAX_PATH];
	wcscpy(szPath, m_szCurrentFolder);
	CFolderDlg fd;
//MOD START GORIPON
	LPTSTR lpszTitle = DupStringTable(IDS_TITLE_FOLDERVIEW);
	int nRet = fd.ShowFolderDlg(lpszTitle, szPath, MAX_PATH);
	FreeStringTable(lpszTitle);
	if (nRet == IDOK)
//MOD END
	{
		LoadFolderItem(szPath);
	}
	else
	{
		if (fd.m_bRefresh)
			LoadFolderItem(m_szCurrentFolder);
	}
}
////////////////////////////////////////////////////////////////
void CListView::OnFileProperty()
{
	DisableUpdateNotify();					//ADD TODA (t@CύXʒm from Y.Nagamidori)
	int nCount = GetValidAndSelectedCount();
	if (nCount > 0)
	{
		LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];

		MakeSelectedItemsStrings(pliinfo, nCount);

		CFileProperty fp;

		//MOD START TODA
//		if (fp.ShowFileProperty(m_szCurrentFolder, pliinfo, nCount))
//			LoadFolderItem(m_szCurrentFolder);
		if (fp.ShowFileProperty(pliinfo->szPath, pliinfo, nCount))
			LoadFolderItem(pliinfo->szPath);
		//MOD END

		delete[] pliinfo;
	}
	else if (wcslen(m_szCurrentFolder) && (ListView_GetSelectedCount(m_hWnd) == 0 || nCount ==0)) {	//MOD GORIPON
		LISTITEMINFO liinfo;
		TCHAR szParent[MAX_PATH];
		wcscpy(szParent, m_szCurrentFolder);
		LPTSTR psz = wcsrchr(szParent, _T('\\'));
		if (psz) *psz = _T('\0');
		//MOD START TODA (from GSFinder ver.1.99)
//		liinfo.nItem = LIST_ITEM_FILE;
		liinfo.nItem = LIST_ITEM_FOLDER;
		//MOD END
		wcscpy(liinfo.szName, ++psz);

		CFileProperty fp;
		if (fp.ShowFileProperty(szParent, &liinfo, 1)) {
			wsprintf(m_szCurrentFolder, _T("%s\\%s"), szParent, fp.m_szNewName);
			LoadFolderItem(m_szCurrentFolder);
		}
	}
	//ADD START TODA ([g̃pXݒ - advice by Y.Nagamidori)
	else
	{
		LISTITEMINFO liinfo;
		liinfo.nItem = LIST_ITEM_FOLDER;
		liinfo.bDone = FALSE;
		liinfo.nIndex = 1;
		wcscpy(liinfo.szPath, _T(""));
		wcscpy(liinfo.szName, GetRootName());

		CFileProperty fp;
		if (fp.ShowFileProperty(liinfo.szPath, &liinfo, 1)) {
			LoadFolderItem(liinfo.szPath);
		}
	}
	//ADD END
	EnableUpdateNotify();					//ADD TODA (t@CύXʒm from Y.Nagamidori)
}

////////////////////////////////////////////////////////////////
void CListView::MakeSelectedItemsStrings(LISTITEMINFO* lpListItemComp, int nCount)
{
	int i = 0;
	int nIndex = GetSelectedItemIndex(0);
	while (nIndex != -1)
	{
		LISTITEMCOMP* plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_UPPER) 
		{
			nIndex = GetSelectedItemIndex(++nIndex);	
			continue;
		}

		wcscpy(lpListItemComp[i].szPath, plic->lpszPath);	//ADD TODA
		wcscpy(lpListItemComp[i].szName, plic->lpszName);
		lpListItemComp[i].nItem = plic->nItem;
		lpListItemComp[i].bDone = FALSE;
		lpListItemComp[i].nIndex = nIndex;
		i++;

		nIndex = GetSelectedItemIndex(++nIndex);
	}
}
////////////////////////////////////////////////////////////////
void CListView::OnFileIRSend()
{
	int nIndex = GetSelectedItemIndex(0);
	if (nIndex != -1)
	{
		LISTITEMCOMP* plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_FILE)
		{
			TCHAR szPath[MAX_PATH];
			//MOD START TODA
//			wsprintf(szPath, _T("%s\\%s"), m_szCurrentFolder, plic->lpszName);
			wsprintf(szPath, _T("%s\\%s"), plic->lpszPath, plic->lpszName);
			//MOD END

			//MOD START TODA (from GSFinder ver.1.99)
			SHELLEXECUTEINFO sei;
			sei.cbSize = sizeof(SHELLEXECUTEINFO);
			sei.fMask = 0;
			sei.hwnd = g_MainWnd.m_hWnd;
			sei.lpVerb = _T("open");
			sei.lpParameters = szPath;
			sei.lpDirectory = g_MainWnd.m_szWindowsPath;
			sei.nShow = SW_SHOW;
			sei.hInstApp = g_hInst;

			if (GetFileAttributes(_T("\\Windows\\beam.exe")) != 0xFFFFFFFF)
				sei.lpFile = _T("beam.exe");
			else 
				sei.lpFile = _T("irsquirt.exe");

			ShellExecuteEx(&sei);
			//MOD END
		}
	}
}
////////////////////////////////////////////////////////////////
void CListView::OnFileCopyFolder()
{
	TCHAR szFolderTo[MAX_PATH] = {0};
	wcscpy(szFolderTo, m_szCurrentFolder);
	CFolderDlg fd;
//MOD START GORIPON
	LPTSTR lpszTitle = DupStringTable(IDS_TITLE_COPY);
	int nRet = fd.ShowFolderDlg(lpszTitle, szFolderTo, MAX_PATH);
	FreeStringTable(lpszTitle);
	if (nRet == IDOK)
//MOD END
	{
		//t@C̃Rs[s
		int nCount = ListView_GetSelectedCount(m_hWnd);
		if (nCount > 0)
		{
			LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
			MakeSelectedItemsStrings(pliinfo, nCount);

			CCopyFileDlg cfd;
			//MOD START TODA
			int nRet = cfd.ShowCopyFileDlg(m_szCurrentFolder, szFolderTo, pliinfo, nCount, FALSE);
			//MOD END
			//ADD START TODA
			if (fd.m_bRefresh || nRet == IDOK)
			{
				g_MainWnd.m_TreeView.SetCurrentFolder(szFolderTo);
				LoadFolderItem(m_szCurrentFolder, FALSE);
			}
			//ADD END

			delete[] pliinfo;
		}
	}
	else
	{
		if (fd.m_bRefresh)
		{
			g_MainWnd.m_TreeView.SetCurrentFolder(szFolderTo);	//ADD TODA
			LoadFolderItem(m_szCurrentFolder, FALSE);			//MOD TODA
		}
	}
}
////////////////////////////////////////////////////////////////
void CListView::OnFileMoveFolder()
{
	TCHAR szFolderTo[MAX_PATH] = {0};
	wcscpy(szFolderTo, m_szCurrentFolder);
	CFolderDlg fd;
//MOD START GORIPON
	LPTSTR lpszTitle = DupStringTable(IDS_TITLE_MOVE);
	int nRet = fd.ShowFolderDlg(lpszTitle, szFolderTo, MAX_PATH);
	FreeStringTable(lpszTitle);
	if (nRet == IDOK)
//MOD END
	{
		//t@C̃Rs[s
		int nCount = ListView_GetSelectedCount(m_hWnd);
		if (nCount > 0)
		{
			LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
			MakeSelectedItemsStrings(pliinfo, nCount);

			CCopyFileDlg cfd;
			//MOD START TODA
//			if (cfd.ShowCopyFileDlg(m_szCurrentFolder, szFolderTo, pliinfo, nCount, TRUE)==IDOK)
//				LoadFolderItem(m_szCurrentFolder);
			int nRet = cfd.ShowCopyFileDlg(m_szCurrentFolder, szFolderTo, pliinfo, nCount, TRUE);
			if (fd.m_bRefresh || nRet == IDOK)
			{
				g_MainWnd.m_TreeView.SetCurrentFolder(szFolderTo);
				LoadFolderItem(m_szCurrentFolder, TRUE);
			}
			//MOD END

			delete[] pliinfo;
		}
	}
	else
	{
		if (fd.m_bRefresh)
		{
			g_MainWnd.m_TreeView.SetCurrentFolder(szFolderTo);		//ADD TODA
			LoadFolderItem(m_szCurrentFolder, TRUE);				//MOD TODA
		}
	}
}
//ADD START TODA
////////////////////////////////////////////////////////////////
void CListView::OnFileToApp()
{
	//IACe擾
	int nIndex = GetSelectedItemIndex(0);
	if (nIndex == -1)
		return;

	LISTITEMCOMP* plic = GetListItemStruct(nIndex);
	if (plic->nItem != LIST_ITEM_FILE)
		return;

	//AvP[VI_CAO쐬
//MOD START HOUMING
	CAssociation Dlg(g_MainWnd.m_hWnd, g_hInst);
	Dlg.OpenChoose(plic->lpszPath, plic->lpszName);
//MOD END
}
//ADD END
//ADD START GORIPON
////////////////////////////////////////////////////////////////
void CListView::OnFileMailSend()
{
	TCHAR szProc[MAX_PATH];
	TCHAR szParam[1024];
	STARTUPINFO info;
	PROCESS_INFORMATION pinfo;
	LISTITEMCOMP *plic;
	int nIndex;

	nIndex = GetSelectedItemIndex(0);
	if (nIndex != -1)
	{
		plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_FILE)
		{
			wsprintf(szProc, _T("%s\\tmail.exe"), g_MainWnd.m_szWindowsPath);
			wsprintf(szParam, _T("-attach \"%s\\%s\""), plic->lpszPath, plic->lpszName);
			memset(&info, 0, sizeof(info));
			info.cb = sizeof(info);
			info.wShowWindow = SW_SHOWNORMAL;	
			CreateProcess(szProc,szParam,NULL,NULL,FALSE,0,NULL,NULL,&info,&pinfo);
		}
	}
}
//ADD END
////////////////////////////////////////////////////////////////
void CListView::OnEditCut(LPCWCH lpszFolderFrom)	//MOD GORIPON (p[^ǉ)
{
	//؂
	int nCount = GetValidAndSelectedCount();
	if (nCount > 0)
	{
		if (m_lpliinfo)
		{
			delete[] m_lpliinfo;
			m_lpliinfo = NULL;
			m_nCount = 0;
		}
	
		LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
		MakeSelectedItemsStrings(pliinfo, nCount);

		wcscpy(m_szFolderFrom, lpszFolderFrom? lpszFolderFrom: m_szCurrentFolder);	//MOD GORIPON

		m_lpliinfo = pliinfo;
		m_nCount = nCount;
		m_bFileMove = TRUE;

		g_MainWnd.m_CmdBands.SetEnableEditPaste(TRUE);

		for (int i = 0; i < ListView_GetItemCount(m_hWnd); i++)
		{
			BOOL bFocused = FALSE;
			if (ListView_GetItemState(m_hWnd, i, LVIS_FOCUSED) == LVIS_FOCUSED)
				bFocused = TRUE;

			if (ListView_GetItemState(m_hWnd, i, LVIS_SELECTED) == LVIS_SELECTED)
			{
				if (bFocused)
				{
					ListView_SetItemState(m_hWnd, i, LVIS_FOCUSED | LVIS_CUT, LVIS_FOCUSED | LVIS_CUT);
				}
				else
				{
					ListView_SetItemState(m_hWnd, i, LVIS_CUT, LVIS_CUT);
				}
			}
		} //End of for
	}
}
////////////////////////////////////////////////////////////////
void CListView::OnEditCopy(LPCWCH lpszFolderFrom)	//MOD GORIPON (p[^ǉ)
{
	//Rs[
	if (m_lpliinfo)
	{
		delete[] m_lpliinfo;
		m_lpliinfo = NULL;
		m_nCount = 0;
	}

	int nCount = GetValidAndSelectedCount();
	if (nCount > 0)
	{
		LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
		MakeSelectedItemsStrings(pliinfo, nCount);

		wcscpy(m_szFolderFrom, lpszFolderFrom? lpszFolderFrom: m_szCurrentFolder);	//MOD GORIPON

		m_lpliinfo = pliinfo;
		m_nCount = nCount;
		m_bFileMove = FALSE;

		g_MainWnd.m_CmdBands.SetEnableEditPaste(TRUE);

		for (int i=0; i<ListView_GetItemCount(m_hWnd); i++)
		{
			if (ListView_GetItemState(m_hWnd, i, LVIS_SELECTED)==LVIS_SELECTED)
				ListView_SetItemState(m_hWnd, i, 0, LVIS_CUT);
		}
	}
}
////////////////////////////////////////////////////////////////
void CListView::OnEditPaste(BOOL bUpdate)		//MOD TODA
{
	//\t
	if (m_nCount > 0 && m_lpliinfo)
	{
		// ݊mF
		for (int i = 0; i < m_nCount; i++)
		{
			if (m_lpliinfo[i].nItem == LIST_ITEM_UPPER)
				continue;

			TCHAR szPath[MAX_PATH];
			//MOD START TODA
//			wsprintf(szPath, _T("%s\\%s"), m_szFolderFrom, m_lpliinfo[i].szName);
			wsprintf(szPath, _T("%s\\%s"), m_lpliinfo[i].szPath, m_lpliinfo[i].szName);
			//MOD END
			if (GetFileAttributes(szPath) == 0xFFFFFFFF)
			{
				// G[
				MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_PASTEERROR), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON

				delete[] m_lpliinfo;
				m_lpliinfo = NULL;
				m_nCount = 0;
				wcscpy(m_szFolderFrom, _T(""));
				g_MainWnd.m_CmdBands.SetEnableEditPaste(FALSE);
				return;
			}
		} //End of for

//DEL START TODA
//		// ړ悪ړƓꍇŐ؂̎̓G[
//		if (m_bFileMove && wcscmp(m_szFolderFrom, m_szCurrentFolder) == 0)
//		{
//			MessageBox(g_MainWnd.m_hWnd, IDS_MSG_PASTEERROR1, NULL, MB_OK|MB_ICONSTOP);
//			return;
//		}
//DEL END

		// \t
		CCopyFileDlg cfd;
		if (cfd.ShowCopyFileDlg(m_szFolderFrom, m_szCurrentFolder, m_lpliinfo, m_nCount, m_bFileMove)==IDOK)
		{
			//Xgr[XV
			if(bUpdate)										//ADD TODA
				LoadFolderItem(m_szCurrentFolder, FALSE);	//MOD TODA

			//ADD START TODA
			//tH_Ȃ̂
			BOOL bSearch = FALSE;
			if(0 == wcscmp(m_szFolderFrom, GetStringTable(IDS_SEARCH_FOLDER_NAME)))	//MOD GORIPON
				bSearch = TRUE;

			// Rs[orړ̂ɃtH_ꍇ̓c[r[XV
			BOOL bFolders = FALSE;	//ADD TODA
			for (int i = 0; i < m_nCount; i++) {

				//ADD START TODA (ʃtH_)
				if(bSearch && m_bFileMove)
					EditSearch(m_lpliinfo[i].szPath, m_lpliinfo[i].szName, m_szCurrentFolder, m_lpliinfo[i].szName);
				//ADD END

				if (m_lpliinfo[i].nItem == LIST_ITEM_FOLDER)
				{
					g_MainWnd.m_TreeView.SetCurrentFolder(m_lpliinfo[i].szPath, TRUE, FALSE);
					bFolders = TRUE;
				}
			} //End of for

			//XVΏۂꍇ
			if(bFolders)
				g_MainWnd.m_TreeView.SetCurrentFolder(m_szCurrentFolder, TRUE, bUpdate);
			//ADD END
		}

		if (m_bFileMove)
		{
			delete[] m_lpliinfo;
			m_lpliinfo = NULL;
			m_nCount = 0;
			wcscpy(m_szFolderFrom, _T(""));
			g_MainWnd.m_CmdBands.SetEnableEditPaste(FALSE);
		}
	}
}
////////////////////////////////////////////////////////////////
void CListView::OnFileDelete()
{
	//t@C̍폜
	int nCount = GetValidAndSelectedCount();
	if (nCount > 0)
	{
		LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
		MakeSelectedItemsStrings(pliinfo, nCount);

		CDeleteFileDlg dfd;
		if (dfd.ShowDeleteFileDlg(m_szCurrentFolder, pliinfo, nCount) == IDOK) {
			//DEL START TODA (̈)
//			HWND hwndPrev = GetFocus();
//			ShowWindow(m_hWnd, SW_HIDE);
			//DEL END
			
			for (int i = nCount - 1; i >= 0; i--) {
				if (pliinfo[i].bDone) {
					LISTITEMCOMP* pDel = GetListItemStruct(pliinfo[i].nIndex);
					if (pDel->lpszDispName) delete[] pDel->lpszDispName;
					if (pDel->lpszDispSize) delete[] pDel->lpszDispSize;
					if (pDel->lpszDispType) delete[] pDel->lpszDispType;
					if (pDel->lpszDispTime) delete[] pDel->lpszDispTime;
					delete[] pDel->lpszName; 
					delete[] pDel->lpszPath;					//ADD TODA 
					delete pDel;
					ListView_DeleteItem(m_hWnd, pliinfo[i].nIndex);
					//ADD START TODA
					if (pliinfo[i].nItem == LIST_ITEM_FOLDER)
						g_MainWnd.m_TreeView.SetCurrentFolder(pliinfo[i].szPath);
					//ADD END
				}
			}
			ListView_Arrange(m_hWnd, LVA_DEFAULT);
			LoadFolderReset(m_szCurrentFolder);					//ADD TODA
			
			//DEL START TODA
//			ShowWindow(m_hWnd, SW_SHOW);
//			SetFocus(hwndPrev);
			//DEL END
		}

		delete[] pliinfo;
	}
}
//ADD START TODA
////////////////////////////////////////////////////////////////
BOOL CListView::OnFileCompress() {
	//IACe擾
	int nCount = GetValidAndSelectedCount();
	//G[
	if (nCount <= 0) return FALSE;

	//ACeXg쐬
	LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
	MakeSelectedItemsStrings(pliinfo, nCount);

	//k
	BOOL bRtn = g_MainWnd.m_Compress.OnFileCompress(
						m_szCurrentFolder,
						nCount,
						pliinfo,
						m_Settings.nCompDLL,
						m_Settings.bMoveDir,
						m_Settings.bAutoUnComp,
						m_szCompressFolder);

	//Xg폜
	delete[] pliinfo;

	//k
	if(bRtn) {
		//c[r[/Xgr[̍XV
		LoadFolderItem(m_szCurrentFolder);
		return TRUE;
	}

	return FALSE;
}

////////////////////////////////////////////////////////////////
BOOL CListView::OnFileUnCompress() {
	//IACe擾
	int nCount = GetValidAndSelectedCount();
	//G[
	if (nCount <= 0) return FALSE;

	//ACeXg쐬
	LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
	MakeSelectedItemsStrings(pliinfo, nCount);

	//
	BOOL bRtn = g_MainWnd.m_Compress.OnFileUnCompress(
						m_szCurrentFolder,
						nCount,
						pliinfo,
						m_Settings.nCompDLL,
						m_Settings.bMoveDir,
						m_Settings.bMakeDir,
						m_Settings.bAutoUnComp,
						m_szCompressFolder);

	//Xg폜
	delete[] pliinfo;

	//𓀂ꍇ
	if(bRtn) {
		//c[r[/Xgr[̍XV
		LoadFolderItem(m_szCurrentFolder);
	}

	return bRtn;
}
//ADD END
////////////////////////////////////////////////////////////////
void CListView::OnFileOpenParam()
{
	int nIndex = GetSelectedItemIndex(0);
	if (nIndex != -1)
	{
		LISTITEMCOMP* plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_FILE)
		{
//DEL START GORIPON
			//BOOL bSetSip = FALSE;
			//SIPINFO si;
			//memset(&si, 0, sizeof(SIPINFO));
			//si.cbSize = sizeof(SIPINFO);
			//SipGetInfo(&si);
			//if ((si.fdwFlags&SIPF_ON)!=SIPF_ON)
			//{
			//	SipShowIM(SIPF_ON);
			//	bSetSip = TRUE;
			//}
//DEL END
			DialogBox(g_hInst, (LPCTSTR)IDD_EXECUTE_DLG, g_MainWnd.m_hWnd, (DLGPROC)FileOpenParamDlgProc);
			//if (bSetSip)	//DEL GORIPON
				SipShowIM(SIPF_OFF);
		}
	}
}

//ADD START TODA
////////////////////////////////////////////////////////////////
HMENU CListView::GetOpenAppSubMenu1() 
{
	return GetSubMenu(GetSubMenu(m_hMenuPopup, ID_POPUP_FILEVIEW_FILE), 1);	//MOD GORIPON
}
////////////////////////////////////////////////////////////////
HMENU CListView::GetOpenAppSubMenu2() 
{
	return GetSubMenu((HMENU)SendMessage(g_MainWnd.m_CmdBands.m_hWnd, SHCMBM_GETSUBMENU, 0, ID_MENU_LEFT), 1);	//MOD GORIPON
}
////////////////////////////////////////////////////////////////
void CListView::DeleteOpenAppSubMenuSep(HMENU hMenu)
{
	DeleteMenu(hMenu, 7, MF_BYPOSITION);	//MOD GORIPON
}
//ADD END

////////////////////////////////////////////////////////////////
void CListView::InitOpenAppMenu()
{
	//MOD TODA START (from GSFinder ver.1.99)
	HMENU hSubMenu1 = GetOpenAppSubMenu1();
	HMENU hSubMenu2 = GetOpenAppSubMenu2();
	//MOD END

	if (m_nOpenAppInfoCount)
	{
		//MOD TODA START (2 -> 6 from GSFinder ver.1.99)
		DeleteOpenAppSubMenuSep(hSubMenu1);
		DeleteOpenAppSubMenuSep(hSubMenu2);
		//MOD END
	}

	for (int i = 0; i < m_nOpenAppInfoCount; i++)
	{
		OPENAPPINFO* poa= m_lpOpenAppInfo[i];
		if (poa)
		{
			delete poa->lpszPath;
			delete poa;
			m_lpOpenAppInfo[i] = NULL;
		}
		
		DeleteMenu(hSubMenu1, ID_FILE_OPEN_APP + i, MF_BYCOMMAND);
		DeleteMenu(hSubMenu2, ID_FILE_OPEN_APP + i, MF_BYCOMMAND);
	}
	m_nOpenAppInfoCount = 0;

	TCHAR szTemp[MAX_PATH + 4];
	int nCount = 0;

	wsprintf(szTemp, _T("%s\\*.*"), g_MainWnd.m_szSendAppPath);
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do
		{
			if (!(finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			{
				LPTSTR lpszExt = wcsrchr(finddata.cFileName, _T('.'));
				if (lpszExt != NULL)
				{
//MOD START TODA (wcscmp -> wcsicmp, tH_V[gJbgL)
//					TCHAR szExt[6];
//					wcscpy(szExt, lpszExt);
//					wcsupr(szExt);
					if (wcsicmp(lpszExt, _T(".EXE"))==0 || wcsicmp(lpszExt, _T(".LNK"))==0)
					{
						nCount += 1;
						if (nCount >= MAX_OPENAPP) break;
					}
//MDO END
				}
			}
		}
		while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

	m_nOpenAppInfoCount = nCount;
	if (nCount == 0) return;

	hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		nCount = 0;
		AppendMenu(hSubMenu1, MF_SEPARATOR, NULL, NULL);
		AppendMenu(hSubMenu2, MF_SEPARATOR, NULL, NULL);
		do
		{
			if (!(finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			{
				LPTSTR lpszExt = wcsrchr(finddata.cFileName, _T('.'));
				if (lpszExt != NULL)
				{
//MOD START TODA (wcscmp -> wcsicmp, tH_V[gJbgL)
//					TCHAR szExt[6];
//					wcscpy(szExt, lpszExt);
//					wcsupr(szExt);
					if (wcsicmp(lpszExt, _T(".EXE"))==0 || wcsicmp(lpszExt, _T(".LNK"))==0)
					{
						//ǉ
						//MOD START TODA (szFileName -> szPath)
						TCHAR szPath[MAX_PATH];
						wcscpy(szPath, finddata.cFileName);
						SetKickExt(szPath);
						//j[쐬
						AppendMenu(hSubMenu1, MF_STRING|MF_ENABLED, ID_FILE_OPEN_APP + nCount, szPath);
						AppendMenu(hSubMenu2, MF_STRING|MF_ENABLED, ID_FILE_OPEN_APP + nCount, szPath);
						//MOD END
						//ADD START TODA
						TCHAR szAppPath[MAX_PATH];
						wsprintf(szPath, _T("%s\\%s"), g_MainWnd.m_szSendAppPath, finddata.cFileName);
						//NpX擾
						if(wcsicmp(lpszExt, _T(".LNK"))==0)
							SHGetShortcutTarget(szPath, szAppPath, sizeof(szAppPath));
						else
							wcscpy(szAppPath, szPath);

						//_uNH[e[V̍폜
						LPTSTR lpszStart = szAppPath;
						if(lpszStart[0] == _T('\"'))
						{
							LPTSTR lpszEnd = wcschr(++lpszStart, _T('\"'));
							if(lpszEnd) *lpszEnd=0x00;
						}
						//ADD END
						//MOD START TODA
						//pXۑ
						OPENAPPINFO* poa = new OPENAPPINFO;
						poa->lpszPath = new TCHAR[wcslen(lpszStart) + 1];
						wcscpy(poa->lpszPath, lpszStart);
						//MOD END
						m_lpOpenAppInfo[nCount] = poa;
						nCount += 1;

						if (nCount >= MAX_OPENAPP) break;
					}
//MDO END
				}
			}
		}
		while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnFileOpenApp(int nMenuIndex)
{
	if (nMenuIndex >= m_nOpenAppInfoCount) return;	//ADD TODA

	int nIndex = GetSelectedItemIndex(0);
	if (nIndex != -1)
	{
		LISTITEMCOMP* plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_FILE)
		{
			TCHAR szPath[MAX_PATH + 2] = _T("");
			if (g_MainWnd.m_bCheckQAdd)
				//MOD START TODA
//				wsprintf(szPath, _T("\"%s\\%s\""), m_szCurrentFolder, plic->lpszName);
				wsprintf(szPath, _T("\"%s\\%s\""), plic->lpszPath, plic->lpszName);
				//MOD END
			else
				//MOD START TODA
//				wsprintf(szPath, _T("%s\\%s"), m_szCurrentFolder, plic->lpszName);
				wsprintf(szPath, _T("%s\\%s"), plic->lpszPath, plic->lpszName);
				//MOD END

			//if (nIndex >= m_nOpenAppInfoCount) return;

			//ADD START TODA (tH_V[gJbg)
			//fBNg
			DWORD dwAttr = GetFileAttributes(m_lpOpenAppInfo[nMenuIndex]->lpszPath);
			if(dwAttr != 0xFFFFFFFF && FILE_ATTRIBUTE_DIRECTORY == (dwAttr & FILE_ATTRIBUTE_DIRECTORY))
			{
				//V[gJbg쐬
				OnFileShortcutFolder(m_lpOpenAppInfo[nMenuIndex]->lpszPath);
				return;
			}
			//ADD END

			SHELLEXECUTEINFO sei;
			sei.cbSize = sizeof(SHELLEXECUTEINFO);
			sei.fMask = 0;
			sei.hwnd = g_MainWnd.m_hWnd;
			sei.lpVerb = _T("open");
			sei.lpFile = m_lpOpenAppInfo[nMenuIndex]->lpszPath;
			sei.lpParameters = szPath;
			sei.lpDirectory = NULL;
			sei.nShow = SW_SHOW;
			sei.hInstApp = g_hInst;
			ShellExecuteEx(&sei);
		}
	}
}
//ADD START TODA
////////////////////////////////////////////////////////////////
HMENU CListView::GetUserPathSubMenu1() 
{
	return GetSubMenu(m_hMenuPopup, ID_POPUP_GOTO);	//MOD GORIPON
}

//////////////////////////////////////////////////////////////////ADD by kawa
HMENU CListView::GetUserPathSubMenu2() 
{
	return GetSubMenu((HMENU)SendMessage(g_MainWnd.m_CmdBands.m_hWnd, SHCMBM_GETSUBMENU, 0, ID_MENU_RIGHT), 1);	//MOD GORIPON
}

////////////////////////////////////////////////////////////////
void CListView::DeleteUserPathMenuSep(HMENU hSubMenu)
{
	DeleteMenu(hSubMenu, 5, MF_BYPOSITION);	//MOD GORIPON
}

////////////////////////////////////////////////////////////////
void CListView::DeleteUserPathMenu()
{
	//pXo^ȂꍇȂ
	if(!m_nOpenPthInfoCount)
		return;

	//j[̃nh擾
	HMENU hSubMenu1 = GetUserPathSubMenu1();//mod by kawa
	HMENU hSubMenu2 = GetUserPathSubMenu2();//add by kawa

	//[U[pX폜
	int j = 0;
	for (int i = 0; i < m_nOpenPthInfoCount; i++)
	{//ADD GORIPON
		j = ID_TOOL_USERPATH_MENU+i; //add by kawa
		DeleteMenu(hSubMenu1, j, MF_BYCOMMAND);//mod by kawa
		DeleteMenu(hSubMenu2, j, MF_BYCOMMAND);//add by kawa
	}//ADD GORIPON

	//Zp[^폜
	DeleteUserPathMenuSep(hSubMenu1);//mod by kawa
	DeleteUserPathMenuSep(hSubMenu2);//add by kawa
}

////////////////////////////////////////////////////////////////
void CListView::InitUserPathMenu()
{
	//pXo^ȂꍇȂ
	if(!m_nOpenPthInfoCount)
		return;
	
	//j[̃nh擾
	HMENU hSubMenu1 = GetUserPathSubMenu1();//mod by kawa
	HMENU hSubMenu2 = GetUserPathSubMenu2();//add by kawa

	//o^ĂpXj[o^
	for (int i = 0; i < m_nOpenPthInfoCount; i++)
	{
		TCHAR szMenu[MAX_PATH+7];
		LPTSTR lpszTemp = wcsrchr(m_lpOpenPthInfo[i]->lpszPath, _T('\\'));

		wsprintf(szMenu, _T("%s"),
			(lpszTemp?lpszTemp+1:m_lpOpenPthInfo[i]->lpszPath));

		InsertMenu(hSubMenu1, ID_TOOL_USERPATH, MF_STRING|MF_ENABLED,
			(ID_TOOL_USERPATH_MENU+i), szMenu);							//mod by kawa
		InsertMenu(hSubMenu2, ID_TOOL_USERPATH, MF_STRING|MF_ENABLED,
			(ID_TOOL_USERPATH_MENU+i), szMenu);							//add by kawa
	} //End of for

	//Zp[^̒ǉ
	InsertMenu(hSubMenu1, ID_TOOL_USERPATH, MF_SEPARATOR, NULL, NULL); //mod by kawa
	InsertMenu(hSubMenu2, ID_TOOL_USERPATH, MF_SEPARATOR, NULL, NULL); //add by kawa
}

////////////////////////////////////////////////////////////////
void CListView::OnToolUserPath(int nMenuIndex)
{
	if (nMenuIndex >= m_nOpenPthInfoCount) return;

	//[U[pXֈړ
	OnViewUpdate(m_lpOpenPthInfo[nMenuIndex]->lpszPath);
}

////////////////////////////////////////////////////////////////
HMENU CListView::GetFavoritesSubMenu1() 
{
	return GetSubMenu(GetSubMenu(m_hMenuPopup, ID_POPUP_GOTO), 0);	//MOD GORIPON
}

////////////////////////////////////////////////////////////////  add by kawa
HMENU CListView::GetFavoritesSubMenu2() 
{
	return GetSubMenu(GetSubMenu((HMENU)SendMessage(g_MainWnd.m_CmdBands.m_hWnd, SHCMBM_GETSUBMENU, 0, ID_MENU_RIGHT), 1), 0);	//MOD GORIPON
}

///////////////////////////////////////////////////////////////
int CListView::DeleteFavoritesItem(FAVORITESINFO *lpList)
{
	//폜
	if(!lpList) return 0;

	//ȍ~̃AhX폜
	FAVORITESINFO *pCurrent = lpList;
	for(int cnt=0; pCurrent; cnt++)
	{
		FAVORITESINFO *pNext = pCurrent->lpNext;
		
		//\̍폜
		delete[] pCurrent->lpszPath;
		delete pCurrent;

		//̍폜o
		pCurrent = pNext;

	} //End of while
	
	return 0;
}

///////////////////////////////////////////////////////////////
FAVORITESINFO *CListView::AddFavoritesItem(FAVORITESINFO *lpList, LPCTSTR lpszPath)
{
	//VKo쐬
	FAVORITESINFO *fav = new FAVORITESINFO;
	fav->lpszPath = new TCHAR[wcslen(lpszPath)+1];
	wcscpy(fav->lpszPath, lpszPath);
	fav->lpNext = NULL;

	//VKoXgɘA
	if(lpList)
		lpList->lpNext = fav;

	//R[h|WVړ
	return fav;
}

////////////////////////////////////////////////////////////////
void CListView::DeleteFavoritesMenu()
{
	//j[̃nh擾
	HMENU hSubMenu1 = GetFavoritesSubMenu1(); //mod by kawa
	HMENU hSubMenu2 = GetFavoritesSubMenu2(); //add by kawa

	//쐬ꂽj[̍폜
	DeleteFavoritesItem(m_lpFavorites);
	int j=0; //add by kawa
	for (int i = 0; i < m_nFavoritesCount; i++)
	{//ADD GORIPON
		j=ID_TOOL_FAVORITES_LNK + i ;//add by kawa
		DeleteMenu(hSubMenu1, j, MF_BYCOMMAND);//mod by kawa
		DeleteMenu(hSubMenu2, j, MF_BYCOMMAND);//add by kawa
	}//ADD GORIPON
	m_lpFavorites = m_lpFavoritesCurrent = NULL;
	m_nFavoritesCount = 0;

	//Tuj[̍폜
	HMENU hworkMenu;
	while((hworkMenu=GetSubMenu(hSubMenu1, 3))) //mod by kawa
	{
		DeleteSubMenu(hworkMenu);
		DeleteMenu(hSubMenu1, 3, MF_BYPOSITION); //mod by kawa
	} //End of while
	
	//add by kawa
	while((hworkMenu=GetSubMenu(hSubMenu2, 3)))
	{
		DeleteSubMenu(hworkMenu);
		DeleteMenu(hSubMenu2, 3, MF_BYPOSITION);
	} //End of while

	//Xvb^̍폜
	DeleteMenu(hSubMenu1, 2, MF_BYPOSITION); //mod by kawa
	DeleteMenu(hSubMenu2, 2, MF_BYPOSITION); //add by kawa
}

////////////////////////////////////////////////////////////////
void CListView::DeleteSubMenu(HMENU hMenu)
{
	HMENU hworkMenu;
	while((hworkMenu=GetSubMenu(hMenu, 0)))
	{
		DeleteSubMenu(hworkMenu);
		DeleteMenu(hMenu, 0, MF_BYPOSITION);
	} //End of while
}

////////////////////////////////////////////////////////////////
void CListView::InitFavoritesMenu()
{
	//j[̃nh擾
	HMENU hSubMenu1 = GetFavoritesSubMenu1(); //mod by kawa
	HMENU hSubMenu2 = GetFavoritesSubMenu2(); //add by kawa

	//j[폜
	DeleteFavoritesMenu();	//ADD GORIPON

	//j[쐬
	InitFavoritesSubMenu(hSubMenu1, g_MainWnd.m_szFavoritesPath); //mod by kawa
 	InitFavoritesSubMenu(hSubMenu2, g_MainWnd.m_szFavoritesPath); //add by kawa
}

////////////////////////////////////////////////////////////////
void CListView::InitFavoritesSubMenu(HMENU hMenu, LPTSTR szCurrentFolder, int *pnCnt)
{
	TCHAR szTemp[MAX_PATH];
	wsprintf(szTemp, _T("%s\\*.*"), szCurrentFolder);

	HMENU hSubMenu=0;
	WIN32_FIND_DATA finddata;
	
	//fBNg
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do
		{
			//̂ݎ{
			if(hMenu && !hSubMenu)
			{
				if(lstrcmp(g_MainWnd.m_szFavoritesPath, szCurrentFolder)==0)
				{
					//Zp[^ǉ
					AppendMenu(hMenu, MF_SEPARATOR, NULL, NULL);
					hSubMenu = hMenu;
				}
				else
				{
					hSubMenu = CreatePopupMenu();
				}
			}

			//fBNg̏ꍇ
			if (finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
				//ċNĂяo
				TCHAR szPath[MAX_PATH];
				wsprintf(szPath, _T("%s\\%s"), szCurrentFolder, finddata.cFileName);
				InitFavoritesSubMenu(hSubMenu, szPath, pnCnt);
			}
		}
		while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

	//t@C
	hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do
		{
			//̂ݎ{
			if(hMenu && !hSubMenu)
			{
				if(lstrcmp(g_MainWnd.m_szFavoritesPath, szCurrentFolder)!=0)
				{
					hSubMenu = CreatePopupMenu();
				}
				else
				{
					hSubMenu = hMenu;
					//Zp[^ǉ
					AppendMenu(hSubMenu, MF_SEPARATOR, NULL, NULL);
				}
			}

			//fBNgł͂Ȃꍇ
			if (!(finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			{
				LPTSTR lpszExt = wcsrchr(finddata.cFileName, _T('.'));
				if (lpszExt != NULL)
				{
					if(hSubMenu)
					{
						TCHAR szPath[MAX_PATH];
						wsprintf(szPath, _T("%s\\%s"), szCurrentFolder, finddata.cFileName);
						
						//Cɓǉ
						m_lpFavoritesCurrent = AddFavoritesItem(m_lpFavoritesCurrent, szPath);
						if(!m_lpFavorites)
							m_lpFavorites = m_lpFavoritesCurrent;

						(*lpszExt) = 0x00;
						AppendMenu(hSubMenu, MF_STRING|MF_ENABLED,
							ID_TOOL_FAVORITES_LNK + m_nFavoritesCount, finddata.cFileName);
					
						m_nFavoritesCount += 1;
					}
					if(pnCnt) (*pnCnt)++;
				}
			}
		}
		while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

	//쐬j[ǉ([gȊO)
	if(hMenu && hSubMenu && hSubMenu != hMenu) {
		LPTSTR lpszFolder = wcsrchr(szCurrentFolder, _T('\\'));
		AppendMenu(hMenu, MF_STRING|MF_POPUP, (UINT)hSubMenu, lpszFolder+1);
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnToolFavoritesLnk(int nMenuIndex)
{
	FAVORITESINFO *lpList = m_lpFavorites;
	for(int i=0; i<nMenuIndex; i++)
		lpList = lpList->lpNext;

	//t@CJ
	ComFileOpen(lpList->lpszPath);
}
//ADD END

////////////////////////////////////////////////////////////////
void CListView::OnColumnClick(NMLISTVIEW* lpnmlv)
{
//MOD START GORIPON
	int nSort;
	switch (lpnmlv->iSubItem)
	{
	case 1: nSort = LIST_SORT_SIZE; break;
	case 2: nSort = LIST_SORT_EXT; break;
	case 3: nSort = LIST_SORT_TIME; break;
	//case 0:
	default: nSort = LIST_SORT_NAME; break;
	}
//MOD END

	if (nSort == m_Settings.nSort)
		m_Settings.bSortRaise = !m_Settings.bSortRaise;
	
	m_Settings.nSort = nSort;
	SortList();
	g_MainWnd.m_CmdBands.SetCheckSort(m_Settings.nSort, m_Settings.bSortRaise);
}
////////////////////////////////////////////////////////////////
DWORD CListView::OnKeyDown(LPNMLVKEYDOWN lpnkd)		//MOD TODA (߂lύX)
{
	if (m_bEditing) return 0;

	//ADD START TODA
	if(g_bDraging)
	{
		if(lpnkd->wVKey == VK_ESCAPE) {
			g_MainWnd.OnDropCansel();
			g_bDraging = FALSE;
		}
		return 0;
	}
	//ADD END

	//MOD START TODA (j[IDԋp`ɏC)
	//V[gJbgL[e[u
	if(lpnkd->wVKey == VK_RIGHT && (GET_KEYSTATE(VK_MENU)&0x8000))
		return ID_GO_FRONT;
	else if(lpnkd->wVKey == VK_LEFT && (GET_KEYSTATE(VK_MENU)&0x8000))
		return ID_GO_BACK;	
	else if (lpnkd->wVKey == VK_BACK)
		return ID_VIEW_UPFOLDER;
	else if (lpnkd->wVKey == VK_DELETE)
		return ID_FILE_DELETE;
	else if (lpnkd->wVKey >= '1' && lpnkd->wVKey <= '9' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_FILE_OPEN_APP + (lpnkd->wVKey - '1');
	else if (lpnkd->wVKey == '0' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_FILE_OPEN_APP + (9);
	else if (lpnkd->wVKey >= '1' && lpnkd->wVKey <= '9' && (GET_KEYSTATE(VK_MENU)&0x8000))
		return ID_TOOL_USERPATH_MENU + (lpnkd->wVKey - '1');
	else if (lpnkd->wVKey == '0' && (GET_KEYSTATE(VK_MENU)&0x8000))
		return ID_TOOL_USERPATH_MENU + (9);
	else if (lpnkd->wVKey == 'Q' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_FILE_EXIT;
	else if (lpnkd->wVKey == 'C' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_EDIT_COPY;
	else if (lpnkd->wVKey == 'X' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_EDIT_CUT;
	else if (lpnkd->wVKey == 'V' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_EDIT_PASTE;
	else if (lpnkd->wVKey == 'A' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_EDIT_SELECTALL;
	else if (lpnkd->wVKey == 'F' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_EDIT_FILESEARCH;
	else if (lpnkd->wVKey == 'R' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_VIEW_UPDATE;
	else if (lpnkd->wVKey == 'O' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_FILE_COPY_FOLDER;
	else if (lpnkd->wVKey == 'T' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_FILE_MOVE_FOLDER;
	else if (lpnkd->wVKey == 'S' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_FILE_SHORTCUT_FOLDER;
	else if (lpnkd->wVKey == 'L' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_VIEW_STYLE;
	else if (lpnkd->wVKey == 'P' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_FILE_PROPERTY;
	else if (lpnkd->wVKey == 'D' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_FILE_DELETE;
	else if (lpnkd->wVKey == 'N' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_FILE_CREATEFOLDER;
	else if (lpnkd->wVKey == 'B' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_FILE_OPEN_PARAM;
	else if (lpnkd->wVKey == 'I' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_FAVORITES_ADD;
	else if (lpnkd->wVKey == 'U' && (GET_KEYSTATE(VK_CONTROL)&0x8000))
		return ID_TOOL_USERPATH;
	else if (lpnkd->wVKey == VK_F2)
		return ID_FILE_RENAME;
	else if (lpnkd->wVKey == VK_F3)
		return ID_EDIT_FILESEARCH;
	else if (lpnkd->wVKey == VK_F4)
		return ID_TOOL_OPTION;
	else if (lpnkd->wVKey == VK_F5)
		return ID_VIEW_UPDATE;
	else if (lpnkd->wVKey == VK_F6)
	{
		if (g_MainWnd.m_CmdBands.m_Settings.bShowAddressBar)
			SetFocus(g_MainWnd.m_CmdBands.m_hComboBox);
	}
	else if ((lpnkd->wVKey == 'M' && (GET_KEYSTATE(VK_CONTROL)&0x8000)) ||
			(lpnkd->wVKey == VK_CONTROL && (GET_KEYSTATE(VK_MENU)&0x8000)))
	{
		int nIndex = GetSelectedItemIndex(0);
		if (nIndex != -1)
		{
			RECT rc;	
			ListView_GetItemRect(m_hWnd, nIndex, &rc, LVIR_ICON);
			OnRClick(rc.left + (rc.right - rc.left) / 2, rc.top + (rc.bottom - rc.top) / 2);
		}
		else
			OnRClick(0, 0);
	}

	return 0;
	//MOD END
}
//ADD START GORIPON
////////////////////////////////////////////////////////////////
BOOL CListView::OnKeyArrowDown(WPARAM wParam, LPARAM lParam)
{
	//SHIFT/CTRLL[
	if (g_MainWnd.m_bShiftKey)
	{
		if (!(GET_KEYSTATE(VK_SHIFT)&0x8000))
		{
			keybd_event(VK_SHIFT, 0, 0, 0);
			keybd_event(wParam, 0, 0, 0);
			return TRUE;
		}
	}
	if (g_MainWnd.m_bControlKey)
	{
		if (!(GET_KEYSTATE(VK_CONTROL)&0x8000))
		{
			keybd_event(VK_CONTROL, 0, 0, 0);
			keybd_event(wParam, 0, 0, 0);
			return TRUE;
		}
	}
	return FALSE;
}
////////////////////////////////////////////////////////////////
BOOL CListView::OnKeyArrowUp(WPARAM wParam, LPARAM lParam)
{
	//SHIFT/CTRLL[
	if (g_MainWnd.m_bShiftKey)
		keybd_event(VK_SHIFT, 0, KEYEVENTF_KEYUP, 0);
	if (g_MainWnd.m_bControlKey)
		keybd_event(VK_CONTROL, 0, KEYEVENTF_KEYUP, 0);
	return FALSE;
}
//ADD END

//ADD START TODA
////////////////////////////////////////////////////////////////
int CListView::CheckMessageID(int dwWID)
{
	//ȊO͖
	if(wcscmp(GetStringTable(IDS_SEARCH_FOLDER_NAME), m_szCurrentFolder)!=0)	//MOD GORIPON
	{
		return dwWID;
	}

	//bZ[WID
	int wID = dwWID;
	switch(wID)
	{
		//\t
		case ID_EDIT_PASTE:
			wID = 0;
			break;
		// V[gJbg̓\t
		case ID_EDIT_PASTE_SHORTCUT:
			wID = 0;
			break;
//DEL START GORIPON
		////̃tH_
		//case ID_VIEW_UPFOLDER:
		//	wID = 0;
		//	break;
//DEL END
		//VKtH_쐬
		case ID_FILE_CREATEFOLDER:
			wID = 0;
			break;
		//V[gJbg쐬
		case ID_FILE_CREATE_SHORTCUT:
			wID = 0;
			break;
		//k
		case ID_FILE_COMPRESS:
			wID = 0;
			break;
	}
	return wID;
}
//ADD END

///////////////////////////////////////////////////////////////
void CListView::OnRClick(int cx, int cy)
{
	//j[\
	RECT rc;
	GetWindowRect(m_hWnd, &rc);
	cx += rc.left;
	cy += rc.top;

	int nCount = GetValidAndSelectedCount();
	if (nCount == 1)
	{
		//ACePI
		int nIndex = GetSelectedItemIndex(0);
		if (nIndex != -1)
		{
			HMENU hMenu;
//MOD START GORIPON
			if (GetListItemStruct(nIndex)->nItem == LIST_ITEM_FILE)
				hMenu = GetSubMenu(m_hMenuPopup, ID_POPUP_FILEVIEW_FILE);
			else
				hMenu = GetSubMenu(m_hMenuPopup, ID_POPUP_FILEVIEW_FOLDER);
//MOD END

			//ADD START TODA (k/̗L/)
			//g_MainWnd.m_CmdBands.SetEnableCompressSelected(hMenu, 0, 2, m_Settings.nCompDLL);
			g_MainWnd.m_CmdBands.SetEnableCompressSelected(hMenu, hMenu, 0, 2, m_Settings.nCompDLL);// add by kawa
			g_MainWnd.m_CmdBands.SetEnableSearchSelected(hMenu, m_szCurrentFolder);
			//ADD END
			TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN, cx, cy, 0, g_MainWnd.m_hWnd, NULL);
		}
	}
	else if (nCount > 1)
	{
		//ACeI
		int nIndex = GetSelectedItemIndex(0);
		if (nIndex != -1)
		{
			HMENU hMenu = GetSubMenu(m_hMenuPopup, ID_POPUP_FILEVIEW_MULTI);	//MOD GORIPON
			//ADD START TODA (k/̗L/)
			//g_MainWnd.m_CmdBands.SetEnableCompressSelected(hMenu, 0, 0, m_Settings.nCompDLL);
			g_MainWnd.m_CmdBands.SetEnableCompressSelected(hMenu, hMenu, 0, 0, m_Settings.nCompDLL); //add by kawa
			g_MainWnd.m_CmdBands.SetEnableSearchSelected(hMenu, m_szCurrentFolder);
			//ADD END
			TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN, cx, cy, 0, g_MainWnd.m_hWnd, NULL);
		}
	}
	else if (ListView_GetSelectedCount(m_hWnd) == 0 || nCount == 0)	//MOD GORIPON
	{
		//ACeI
		HMENU hMenu = GetSubMenu(m_hMenuPopup, ID_POPUP_FILEVIEW_NOSELECT);	//MOD GORIPON
		CheckMenuItem(hMenu, ID_VIEW_SORT_NAME, (m_Settings.nSort == LIST_SORT_NAME) ?
												MF_BYCOMMAND|MF_CHECKED : MF_BYCOMMAND|MF_UNCHECKED);
		CheckMenuItem(hMenu, ID_VIEW_SORT_EXT, (m_Settings.nSort == LIST_SORT_EXT) ? 
												MF_BYCOMMAND|MF_CHECKED : MF_BYCOMMAND|MF_UNCHECKED);
		CheckMenuItem(hMenu, ID_VIEW_SORT_SIZE, (m_Settings.nSort == LIST_SORT_SIZE) ?
												MF_BYCOMMAND|MF_CHECKED : MF_BYCOMMAND|MF_UNCHECKED);
		CheckMenuItem(hMenu, ID_VIEW_SORT_TIME, (m_Settings.nSort == LIST_SORT_TIME) ? 
												MF_BYCOMMAND|MF_CHECKED : MF_BYCOMMAND|MF_UNCHECKED);
		CheckMenuItem(hMenu, ID_VIEW_SORT_NOT_RAISE, m_Settings.bSortRaise ? 
												MF_BYCOMMAND|MF_UNCHECKED : MF_BYCOMMAND|MF_CHECKED);
		EnableMenuItem(hMenu, ID_EDIT_PASTE, m_nCount ? MF_BYCOMMAND|MF_ENABLED : MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hMenu, ID_EDIT_PASTE_SHORTCUT, m_nCount ? MF_BYCOMMAND|MF_ENABLED : MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hMenu, ID_FILE_PROPERTY, wcslen(m_szCurrentFolder) ? MF_BYCOMMAND|MF_ENABLED : MF_BYCOMMAND|MF_GRAYED);
		//ADD START TODA (VK쐬/̗L/)
		EnableMenuItem(hMenu, ID_FILE_CREATEFOLDER, MF_BYCOMMAND|MF_ENABLED);
		g_MainWnd.m_CmdBands.SetEnableSearchSelected(hMenu, m_szCurrentFolder);
		//ADD END
		TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN, cx, cy, 0, g_MainWnd.m_hWnd, NULL);
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnEditSelectSwitch()
{
	for (int i=0; i<ListView_GetItemCount(m_hWnd); i++)
	{
		if (ListView_GetItemState(m_hWnd, i, LVIS_SELECTED)==LVIS_SELECTED) {
			ListView_SetItemState(m_hWnd, i, 0, LVIS_SELECTED);
		}
		else {
			ListView_SetItemState(m_hWnd, i, LVIS_SELECTED, LVIS_SELECTED);
		}
	}
}
//MOD START GORIPON
////////////////////////////////////////////////////////////////
void CListView::SortList()
{
	switch (m_Settings.nSort)
	{
		case LIST_SORT_EXT:
			m_ItemStruct.Sort((LPCOMPAREFUNC)ListSortCompareFuncByExt, m_Settings.bSortRaise);
			break;
		case LIST_SORT_SIZE:
			m_ItemStruct.Sort((LPCOMPAREFUNC)ListSortCompareFuncBySize, m_Settings.bSortRaise);
			break;
		case LIST_SORT_TIME:
			m_ItemStruct.Sort((LPCOMPAREFUNC)ListSortCompareFuncByTime, m_Settings.bSortRaise);
			break;
		//case LIST_SORT_NAME:
		default:
			m_ItemStruct.Sort((LPCOMPAREFUNC)ListSortCompareFuncByName, m_Settings.bSortRaise);
			break;
	}
	ListView_Update(m_hWnd, -1);
}
//MOD END

///////////////////////////////////////////////////////////////
void CListView::OnGetDispInfo(NMLVDISPINFO* lpnmdi)
{
	//xACRǂݍ
	LISTITEMCOMP* lplic = (LISTITEMCOMP*)m_ItemStruct.GetAt(lpnmdi->item.iItem);	//MOD GORIPON
	if (lpnmdi->item.mask & LVIF_IMAGE)
	{
		if (lplic->nIcon == -1)
			//MOD START TODA
//			lpnmdi->item.iImage = m_pFileImageList->GetImageListIndex(lplic->lpszName, m_szCurrentFolder, lplic->dwAttr);
			lpnmdi->item.iImage = m_pFileImageList->GetImageListIndex(lplic->lpszName, lplic->lpszPath, lplic->dwAttr);
			//MOD END
		else
			lpnmdi->item.iImage = lplic->nIcon;
	}
	if ((lpnmdi->item.mask & LVIF_TEXT))
	{
//ADD START GORIPON
		if (lplic->nItem == LIST_ITEM_UPPER)
		{
			if (lpnmdi->item.iSubItem == 0)
				lpnmdi->item.pszText = lplic->lpszName;
		}
		else
//ADD END
		if (lplic->nItem == LIST_ITEM_FOLDER)
		{
			switch (lpnmdi->item.iSubItem)
			{
				case 0: //Name
					lpnmdi->item.pszText = lplic->lpszName;
					break;
				case 2: //Type
					lpnmdi->item.pszText = GetStringTable(IDS_FOLDER);	//MOD GORIPON
					break;
				default: break;
			}
		}
		else if (lplic->nItem == LIST_ITEM_FILE)
		{
			switch (lpnmdi->item.iSubItem)
			{
				case 0: //Name
				{
					if (!lplic->lpszDispName)
					{
						if (m_Settings.bNotShowExt)
						{
							lplic->lpszDispName = new TCHAR[wcslen(lplic->lpszName)+1];
							wcscpy(lplic->lpszDispName, lplic->lpszName);
							SetKickExt(lplic->lpszDispName);
						}
						else
						{
							lpnmdi->item.pszText = lplic->lpszName;
							break;
						}
					}
					lpnmdi->item.pszText = lplic->lpszDispName;
					break;
				}
				case 1: //Size
				{
					if (!lplic->lpszDispSize)
					{
						lplic->lpszDispSize = new TCHAR[16];
						SetFormatSize(lplic->dwSize, lplic->lpszDispSize, _T("%s KB"), _T("%s MB"));
					}
					lpnmdi->item.pszText = lplic->lpszDispSize;
					break;
				}
				case 2: //Type
				{
					if (!lplic->lpszDispType)
					{
						TCHAR szTemp[MAX_PATH];
						lplic->lpszDispType = new TCHAR[80];
						SHFILEINFO shfi;
						//MOD START TODA
//						wsprintf(szTemp, _T("%s\\%s"), m_szCurrentFolder, lplic->lpszName);
						wsprintf(szTemp, _T("%s\\%s"), lplic->lpszPath, lplic->lpszName);
						//MOD END
						SHGetFileInfo(szTemp, NULL, &shfi, sizeof(shfi), SHGFI_TYPENAME);
						wcscpy(lplic->lpszDispType, shfi.szTypeName);
					}
					lpnmdi->item.pszText = lplic->lpszDispType;
					break;
				}
				case 3: //Date
				{
					if (!lplic->lpszDispTime)
					{
						lplic->lpszDispTime = new TCHAR[32];
						SYSTEMTIME st;
						FileTimeToSystemTime(&lplic->ft, &st);
						SetFormatDateTime(&st, lplic->lpszDispTime, 32, m_bTimeStump);	//MOD TODA
					}
					lpnmdi->item.pszText = lplic->lpszDispTime;
					break;
				}
				default: break;
			}
		}
	}
}
///////////////////////////////////////////////////////////////
void CListView::OnListStyle()
{
	switch (m_Settings.dwListStyle)
	{
		case LVS_ICON: OnChangeListStyle(ID_VIEW_SMALLICON); break;
		case LVS_SMALLICON: OnChangeListStyle(ID_VIEW_LIST); break;
		case LVS_LIST: OnChangeListStyle(ID_VIEW_REPORT); break;
		//MOD START TODA
		case LVS_REPORT:
			if(!m_Settings.dwListExStyle)
				OnChangeListStyle(ID_VIEW_REPORTLINE);
			else
				OnChangeListStyle(ID_VIEW_LARGEICON);
			break;
		//MOD END
		default: OnChangeListStyle(ID_VIEW_LARGEICON); break;
	}	
//	SetFocus(m_hWnd);
}

///////////////////////////////////////////////////////////////
void CListView::OnTapAndHold(NMRGINFO* pnmri)
{
	RECT rc;
	GetWindowRect(m_hWnd, &rc);
	int cx = pnmri->ptAction.x - rc.left;
	int cy = pnmri->ptAction.y - rc.top;
	OnRClick(cx, cy);
}
//ADD START TODA
///////////////////////////////////////////////////////////////
void CListView::OnTapHoldBegin(DWORD dwPos)
{
	SetFocus(m_hWnd);

	//IACeۑ
	m_nSelectItem = GetValidAndSelectedCount();
	m_nSelectMin = -1;
	
	//^bvACe擾
	LVHITTESTINFO lv_ht;
	memset(&lv_ht, 0x00, sizeof(lv_ht));
	lv_ht.flags = LVHT_ONITEM;
//MOD START GORIPON
	lv_ht.pt.x = GET_X_LPARAM(dwPos);
	lv_ht.pt.y = GET_Y_LPARAM(dwPos);
//MOD END
	int nIndex = ListView_HitTest(m_hWnd, &lv_ht);
	if(ListView_GetItemState(m_hWnd, nIndex, LVIS_SELECTED)!=LVIS_SELECTED)
		m_nSelectItem = 0;
}
//DEL START GORIPON
///////////////////////////////////////////////////////////////
//void CListView::OnTapHoldCancel()
//{
//	if(m_bTaping)
//	{
//		//^C}̍폜
//		m_bTaping = !m_bTaping;
//		KillTimer(m_hWnd, ID_TIMER_TAPHOLD);
//	}
//}
//
///////////////////////////////////////////////////////////////
//void CListView::OnTapHoldEnter()
//{
//	if(m_bTaping)
//	{
//		//^C}̍폜
//		KillTimer(m_hWnd, ID_TIMER_TAPHOLD);
//
//		//݂̃EBhEʒu擾
//		DWORD dwPos = GetMessagePos();
//
//		//^bvACe擾
//		LVHITTESTINFO lv_ht;
//		memset(&lv_ht, 0x00, sizeof(lv_ht));
//		lv_ht.flags = LVHT_ONITEM;
//		lv_ht.pt.x = LOWORD(m_dwTapPos);
//		lv_ht.pt.y = HIWORD(m_dwTapPos);
//		int nFromIndex = ListView_HitTest(m_hWnd, &lv_ht);
//
//		//݂̃ACe擾
//		memset(&lv_ht, 0x00, sizeof(lv_ht));
//		lv_ht.flags = LVHT_ONITEM;
//		lv_ht.pt.x = LOWORD(dwPos);
//		lv_ht.pt.y = HIWORD(dwPos);
//		ScreenToClient(m_hWnd, &(lv_ht.pt));
//		int nToIndex = ListView_HitTest(m_hWnd, &lv_ht);
//
//		//W̍
//		DWORD dwX = max(lv_ht.pt.x,LOWORD(m_dwTapPos))
//				  - min(lv_ht.pt.x,LOWORD(m_dwTapPos));
//		DWORD dwY = max(lv_ht.pt.y,HIWORD(m_dwTapPos))
//				  - min(lv_ht.pt.y,HIWORD(m_dwTapPos));
//
//		//ACev(z[h)
//		if((nFromIndex == nToIndex) &&
//		   (dwX <= AREA_TAPHOLD && dwY <= AREA_TAPHOLD))
//			//j[\
//			OnRClick(LOWORD(m_dwTapPos)+10, HIWORD(m_dwTapPos));
//	}
//}
//
///////////////////////////////////////////////////////////////
//void CListView::OnExitMenuLoop()
//{
//	//^bv&z[hȊO͖
//	if(!m_bTaping) return;
//
//	m_bTaping = !m_bTaping;
//	m_bHolding = !m_bHolding;
//
//	m_nItemCnt = 0;
//
//	//^bvACe擾
//	LVHITTESTINFO lv_ht;
//	memset(&lv_ht, 0x00, sizeof(lv_ht));
//	lv_ht.flags = LVHT_ONITEM;
//	lv_ht.pt.x = LOWORD(m_dwTapPos);
//	lv_ht.pt.y = HIWORD(m_dwTapPos);
//	int nFromIndex = ListView_HitTest(m_hWnd, &lv_ht);
//	
//	//ACeʕs\̏ꍇ
//	if(nFromIndex < 0) return;
//
//	//IACẽJEgу`FbN
//	BOOL bChk = FALSE;
//	int nItem = -1;
//	while((nItem=ListView_GetNextItem(m_hWnd, nItem, LVNI_SELECTED))!=-1)
//	{
//		//I͈͂ɃACeꍇ
//		if(nFromIndex == nItem)	bChk = TRUE;
//		m_nItemCnt++;
//
//	} //End of while
//
//	//PACȅꍇ͕ۑȂ
//	if(m_nItemCnt == 1) m_nItemCnt = 0;
//
//	//IACẽCfbNXۑ
//	if(bChk && m_nItemCnt)
//	{
//		m_lpnItem = new int[m_nItemCnt];
//	
//		nItem = -1;
//		for(int i=0; i<m_nItemCnt; i++)
//		{
//			nItem = ListView_GetNextItem(m_hWnd, nItem, LVNI_SELECTED);
//			*(m_lpnItem+i) = nItem;
//		
//		} //End of for
//	}
//
//	//j[LZp^C}ݒ
//	SetTimer(m_hWnd, ID_TIMER_MENUCANCEL, 500, NULL);
//}
//
///////////////////////////////////////////////////////////////
//void CListView::OnSelectMenuLoop()
//{
//	//^bv&z[hȊȌꍇ
//	if(!m_bHolding) return;
//
//	//tOݒ
//	m_bMenu = !m_bMenu;
//
//	//1(ĂяoO)̏ꍇ
//	if(m_bMenu)
//		KillTimer(m_hWnd, ID_TIMER_MENUCANCEL);
//
//	//IACȅԂ֕
//	for(int i=0; i<m_nItemCnt; i++)
//	{
//		ListView_SetItemState(m_hWnd, *(m_lpnItem+i),
//				LVIS_SELECTED, LVIS_SELECTED);
//	} //End of for
//
//	//2(Ăяo)̏ꍇ
//	if(!m_bMenu)
//	{
//		//e[u폜JE^NA
//		delete[] m_lpnItem;
//		m_nItemCnt = 0;
//
//		//^bv&z[h
//		m_bHolding = !m_bHolding;
//	}
//}
//DEL END
//ADD END

///////////////////////////////////////////////////////////////
void CListView::DeleteAllItem()
{
//MOD START GORIPON
	for (int i = 0; i < m_ItemStruct.GetCount(); i++)
	{
		LISTITEMCOMP* pDel = (LISTITEMCOMP*)m_ItemStruct.GetAt(i);
		delete[] pDel->lpszDispName;
		delete[] pDel->lpszDispSize;
		delete[] pDel->lpszDispType;
		delete[] pDel->lpszDispTime;
		delete[] pDel->lpszName; 
		delete[] pDel->lpszPath;	//ADD TODA
		delete pDel;
	}
	m_ItemStruct.RemoveAll();
//MOD END
}

//MOD START TODA (from GSFinder ver.1.99)
///////////////////////////////////////////////////////////////
void CListView::OnEditPasteShortcut(BOOL bUpdate)	//MOD TODA
{
	TCHAR szFolder[MAX_PATH];
	wcscpy(szFolder, m_szCurrentFolder);

	if (m_nCount) {
		HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
		for (int i = 0; i < m_nCount; i++) 
		{
			CreateShortcut(m_szCurrentFolder, m_lpliinfo[i].szPath, m_lpliinfo[i].szName);	//MOD TODA
		}
		SetCursor(hCursor);
		//MOD START TODA (tOǉ) 
//		OnViewUpdate();
		if(bUpdate) LoadFolderItem(m_szCurrentFolder, FALSE);
		//MOD END
	}
}
//MOD END
///////////////////////////////////////////////////////////////
int CListView::GetValidAndSelectedCount()
{
	int nCount = ListView_GetSelectedCount(m_hWnd);

//MOD START GORIPON
	if (m_dwUpperParam)
	{
		LV_FINDINFO lvfi;
		lvfi.flags = LVFI_STRING;
		lvfi.psz = ((LISTITEMCOMP*)m_dwUpperParam)->lpszName;
		int nUpper = ListView_FindItem(m_hWnd, -1, &lvfi);
		if (nUpper != -1) {
			if (ListView_GetItemState(m_hWnd, nUpper, LVIS_SELECTED) == LVIS_SELECTED)
				nCount -= 1;
		}
	}
//MOD END
	return nCount;
}

//ADD START TODA
///////////////////////////////////////////////////////////////
void CListView::OnMouseMove(POINT ptWnd)
{
	HWND hMain = g_MainWnd.m_hWnd;
	ClientToScreen(hMain, &ptWnd);

	//ÕhbOnCCg
	ListView_SetItemState(m_hWnd, -1, 0, LVIS_DROPHILITED);
	
	//|C^̈ʒuɂACeփnCCgݒ
	LVHITTESTINFO lv_ht;
	memset(&lv_ht, 0x00, sizeof(lv_ht));
	lv_ht.flags = LVHT_ONITEM;
	lv_ht.pt.x = ptWnd.x;
	lv_ht.pt.y = ptWnd.y;
	ScreenToClient(m_hWnd, &(lv_ht.pt));

	int nIndex = ListView_HitTest(m_hWnd, &lv_ht);
	if(nIndex >= 0) {
		LISTITEMCOMP *plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_FOLDER)
		{
			ListView_SetItemState(m_hWnd, nIndex, LVIS_DROPHILITED, LVIS_DROPHILITED);
		}
	}

	//EBhEĕ`(cc)
	UpdateWindow(m_hWnd);
}

///////////////////////////////////////////////////////////////
void CListView::OnMouseMoveArea(POINT ptWnd)
{
	HWND hMain = g_MainWnd.m_hWnd;
	ClientToScreen(hMain, &ptWnd);

	//|C^̈ʒuɂACeփnCCgݒ
	LVHITTESTINFO lv_ht;
	memset(&lv_ht, 0x00, sizeof(lv_ht));
	lv_ht.flags = LVHT_ONITEM;
	lv_ht.pt.x = ptWnd.x;
	lv_ht.pt.y = ptWnd.y;
	ScreenToClient(m_hWnd, &(lv_ht.pt));

	int nIndex = ListView_HitTest(m_hWnd, &lv_ht);
	if(nIndex >= 0) {
		int nMin = (nIndex<=m_nSelectStart?nIndex:m_nSelectStart);
		int nMax = (nIndex>m_nSelectStart?nIndex:m_nSelectStart);

		for(int i = (m_nSelectMin==-1?0:m_nSelectMin); i < nMin; i++)
			ListView_SetItemState(m_hWnd, i, 0, LVIS_SELECTED);

		for(int j = nMin; j <= nMax; j++)
			ListView_SetItemState(m_hWnd, j, LVIS_SELECTED, LVIS_SELECTED);

		int nItem = nMax;
		while((nItem=ListView_GetNextItem(m_hWnd, nItem, LVNI_SELECTED))!=-1)
			ListView_SetItemState(m_hWnd, nItem, 0, LVIS_SELECTED);

		m_nSelectMin = nMin;
	}
}

///////////////////////////////////////////////////////////////
BOOL CListView::OnLButtonUp(HWND hWnd)
{
	HWND hMain = g_MainWnd.m_hWnd;
	
	//Xgr[̃hbv
	DWORD dwPos = GetMessagePos();
	LVHITTESTINFO lv_ht;
	memset(&lv_ht, 0x00, sizeof(lv_ht));
	lv_ht.flags = LVHT_ONITEM;
//MOD START GORIPON
	lv_ht.pt.x = GET_X_LPARAM(dwPos);
	lv_ht.pt.y = GET_Y_LPARAM(dwPos);
//MOD END
	ScreenToClient(m_hWnd, &(lv_ht.pt));

	int nIndex = ListView_HitTest(m_hWnd, &lv_ht);
	if((nIndex >= 0) || (lv_ht.flags & LVHT_NOWHERE)) {
		OnDropEnter(hWnd, nIndex);
		return TRUE;
	} else
		return FALSE;
}

///////////////////////////////////////////////////////////////
void CListView::OnDropEnter(HWND hWnd, int nIndex)
{
	HWND hMain = g_MainWnd.m_hWnd;
	BOOL b_shortcut = FALSE;
	BOOL b_cut = FALSE;
	
	DWORD iMenuID=0;
	//ShiftL[̓j[\
	if(GET_KEYSTATE(VK_LSHIFT)&0x8000  ||
		GET_KEYSTATE(VK_RSHIFT)&0x8000 ||
		g_MainWnd.m_bShiftKey ||
		g_MainWnd.m_bContextMenu)
	{
		DWORD dwPos = GetMessagePos();
		POINT pt;
//MOD START GORIPON
		pt.x = GET_X_LPARAM(dwPos);
		pt.y = GET_Y_LPARAM(dwPos);
		HMENU hMenu = GetSubMenu(m_hMenuPopup, ID_POPUP_DRAGDROP);
//MOD END
		iMenuID = TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN|TPM_RETURNCMD, pt.x, pt.y, 0, m_hWnd, NULL);
		
		//j[I𖳂yуLZ̏ꍇ
		if(!iMenuID || iMenuID == ID_DROP_CANCEL) {
			//hbvACȅԂ
			ListView_SetItemState(m_hWnd, -1, 0, LVIS_DROPHILITED);
			return;
		}
	}

	//hbvACȅԂ
	ListView_SetItemState(m_hWnd, -1, 0, LVIS_DROPHILITED);

	//Rs[ȌԂ[ۑ
	TCHAR szFromFolder[MAX_PATH];
	wcscpy(szFromFolder, m_szCurrentFolder);

	//Rs[쐬
	TCHAR szToFolder[MAX_PATH];
	wcscpy(szToFolder, m_szCurrentFolder);
	
	//fBNgIĂꍇ
	if(nIndex >= 0) {
		LISTITEMCOMP *plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_FOLDER)
		{
			//tH_IĂꍇ
			wsprintf(szToFolder, _T("%s\\%s"), m_szCurrentFolder, plic->lpszName);
		}
	}

	//Rs[/؂/V[gJbg쐬s
	//Xgr[̃hbv
	if(hWnd == m_hWnd) {
		//1.Rs[̏ꍇ(+Ctl)
		if(iMenuID == ID_DROP_COPY ||
		   GET_KEYSTATE(VK_CONTROL)&0x8000 ||
		   g_MainWnd.m_bControlKey) {
			OnEditCopy();
			
		//2.V[gJbg쐬(+Alt)̏ꍇ
		} else if(iMenuID == ID_DROP_SHORTCUT ||
			      GET_KEYSTATE(VK_MENU)&0x8000) {
			OnEditCopy();
			b_shortcut = TRUE;

		//3.؂̏ꍇ
		} else {
			OnEditCut();
		}
	//c[r[̃hbv
	} else {

		//hbOACeI
		HWND hTree = g_MainWnd.m_TreeView.m_hWnd;
		TreeView_SelectItem(hTree, g_MainWnd.m_hDragTree);

		//1.Rs[̏ꍇ(+Ctl)
		if(iMenuID == ID_DROP_COPY ||
		   GET_KEYSTATE(VK_CONTROL)&0x8000 ||
		   g_MainWnd.m_bControlKey) {
			g_MainWnd.m_TreeView.OnEditCopy();
			
		//2.V[gJbg쐬(+Alt)̏ꍇ
		} else if(iMenuID == ID_DROP_SHORTCUT ||
				  GET_KEYSTATE(VK_MENU)&0x8000) {
			g_MainWnd.m_TreeView.OnEditCopy();
			b_shortcut = TRUE;

		//3.؂̏ꍇ
		} else {
			g_MainWnd.m_TreeView.OnEditCut();
			b_cut = TRUE;
		}
		
		//̃tH_ֈړ
		LoadFolderItem(szFromFolder, FALSE);
	}

	//\tpXݒ
	wcscpy(m_szCurrentFolder, szToFolder);

	//\ts
	if(b_shortcut) {
		OnEditPasteShortcut(FALSE);
	} else {
		OnEditPaste(FALSE);
	}

	//\t悪JgtH_̏ꍇ
	if(0 == wcscmp(szFromFolder, szToFolder)) {
		wcscpy(m_szCurrentFolder, szFromFolder);
	}
	LoadFolderItem(m_szCurrentFolder, FALSE);
}

///////////////////////////////////////////////////////////////
void CListView::OnDropCansel()
{
	//hbvI
	ListView_SetItemState(m_hWnd, -1, 0, LVIS_DROPHILITED);
}

///////////////////////////////////////////////////////////////
void CListView::OnFavoritesAdd()
{
	//݂̃fBNgۑ
	TCHAR szFromFolder[MAX_PATH];
	wcscpy(szFromFolder, m_szCurrentFolder);

	//Rs[s
	if(ListView_GetSelectedCount(m_hWnd) > 0)
		OnEditCopy();
	else
		g_MainWnd.m_TreeView.OnEditCopy();

	//Cɓ̃fBNgֈړ
	wcscpy(m_szCurrentFolder, g_MainWnd.m_szFavoritesPath);

	//V[gJbg̓\t
	OnEditPasteShortcut(FALSE);

	//Ỉ
	ListView_SetItemState(m_hWnd, -1, 0, LVIS_SELECTED);
	wcscpy(m_szCurrentFolder, szFromFolder);

	//Cɓ胁j[̍č쐬
	//DeleteFavoritesMenu();	//DEL GORIPON InitFavoritesMenu()Ɉړ
	InitFavoritesMenu();
}

///////////////////////////////////////////////////////////////
void CListView::OnFavoritesOrganize()
{
	//Cɓ̃pXֈړ
	OnViewUpdate(g_MainWnd.m_szFavoritesPath);

	//Cɓ胁j[̍č쐬
	//DeleteFavoritesMenu();	//DEL GORIPON InitFavoritesMenu()Ɉړ
	InitFavoritesMenu();
}

///////////////////////////////////////////////////////////////
void CListView::OnUserPath()
{
	//O񃁃j[̍폜
	DeleteUserPathMenu();

	//[UpX_CAO
	CUserPathDlg *upd = new CUserPathDlg(g_MainWnd.m_hWnd, g_hInst);
	upd->Open();
	delete upd;

	//폜j[č쐬
	InitUserPathMenu();
}

///////////////////////////////////////////////////////////////
HISTORYINFO *CListView::AddHistory(HISTORYINFO *lpHistory, LPCTSTR lpszPath)
{
	//ǉ/폜
	if(lpHistory)
	{
		//ύXȂꍇ͒ǉȂ
		if(0 == wcscmp(lpszPath, lpHistory->lpszPath))
			return lpHistory;
		
		//ȍ~̃o[폜
		DeleteHistory(lpHistory->lpNext);
		lpHistory->lpNext = NULL;
	}		

	//VKo쐬
	HISTORYINFO *his = new HISTORYINFO;
	his->lpszPath = new TCHAR[wcslen(lpszPath)+1];
	wcscpy(his->lpszPath, lpszPath);
	his->lpPrev = lpHistory;
	his->lpNext = NULL;

	//VKoXgɘA
	if(lpHistory)
	{
		lpHistory->lpNext = his;
	}

	//R[h|WVړ
	return his;
}

///////////////////////////////////////////////////////////////
void CListView::DeleteHistory(HISTORYINFO *lpHistory)
{
	//폜
	if(!lpHistory) return;

	//ȍ~̃AhX폜
	HISTORYINFO *pCurrent = lpHistory;
	while(pCurrent)
	{
		HISTORYINFO *pNext = pCurrent->lpNext;
		
		//\̍폜
		delete[] pCurrent->lpszPath;
		delete pCurrent;

		//̍폜o
		pCurrent = pNext;

	} //End of while
}
///////////////////////////////////////////////////////////////
void CListView::OnGoFront()
{
	//zpXȊȌꍇ̂
	if(0 != wcscmp(m_szCurrentFolder, GetStringTable(IDS_SEARCH_FOLDER_NAME)))	//MOD GORIPON
	{
		//Ȃꍇ͈ړȂ
		if(!m_lpHistoryCurrent->lpNext) return;

		//ړ
		m_lpHistoryCurrent = m_lpHistoryCurrent->lpNext;
	}

	LoadFolderItem(m_lpHistoryCurrent->lpszPath);
}
///////////////////////////////////////////////////////////////
void CListView::OnGoBack()
{
	//zpXȊȌꍇ̂
	if(0 != wcscmp(m_szCurrentFolder, GetStringTable(IDS_SEARCH_FOLDER_NAME)))	//MOD GORIPON
	{
		//OȂꍇ͈ړȂ
		if(!m_lpHistoryCurrent->lpPrev) return;

		//ړ
		m_lpHistoryCurrent = m_lpHistoryCurrent->lpPrev;
	}

	LoadFolderItem(m_lpHistoryCurrent->lpszPath);
}
///////////////////////////////////////////////////////////////
SEARCHDATA *CListView::AddSearch(
	SEARCHDATA	*lpSearch,
	LPCTSTR		lpszPath,
	LPCTSTR		lpszName,
	FILETIME	ft,
	DWORD		dwSize,
	DWORD		dwAttr)
{
	//VKo쐬
	SEARCHDATA *sch = new SEARCHDATA;
	sch->lpszPath = new TCHAR[wcslen(lpszPath)+1];
	wcscpy(sch->lpszPath, lpszPath);
	sch->lpszName = new TCHAR[wcslen(lpszName)+1];
	wcscpy(sch->lpszName, lpszName);
	sch->ft = ft;
	sch->dwSize = dwSize;
	sch->dwAttr = dwAttr;
	sch->lpPrev = lpSearch;
	sch->lpNext = NULL;

	//VKoXgɘA
	if(lpSearch)
	{
		//ŏIR[h擾
		SEARCHDATA *lpCurrent = lpSearch;
		for(int i=0; lpCurrent->lpNext; i++)
		{
			lpCurrent = lpCurrent->lpNext;
		} //End of for

		//R[hA
		lpCurrent->lpNext = sch;
		return lpSearch;
	}

	return sch;
}
///////////////////////////////////////////////////////////////
void CListView::DeleteSearch(SEARCHDATA *lpSearch)
{
	//폜
	if(!lpSearch) return;

	//ȍ~̃AhX폜
	SEARCHDATA *pCurrent = lpSearch;
	while(pCurrent)
	{
		SEARCHDATA *pNext = pCurrent->lpNext;
		
		//\̍폜
		delete[] pCurrent->lpszName;
		delete[] pCurrent->lpszPath;
		delete pCurrent;

		//̍폜o
		pCurrent = pNext;

	} //End of while
}
///////////////////////////////////////////////////////////////
void CListView::EditSearch(LPTSTR lpszOldPath, LPTSTR lpszOldName, LPTSTR lpszNewPath, LPTSTR lpszNewName, BOOL bDelete)
{
	SEARCHDATA *pCurrent = m_lpSearchData;
	for(int i=0; pCurrent; i++)
	{
		SEARCHDATA *pNext = pCurrent->lpNext;
	
		//ΏۃR[hXV
		if(0 == wcscmp(pCurrent->lpszPath, lpszOldPath) &&
		   0 == wcscmp(pCurrent->lpszName, lpszOldName))
		{
			if(pCurrent->lpszPath) delete[] pCurrent->lpszPath;
			if(pCurrent->lpszName) delete[] pCurrent->lpszName;

			//폜
			if(bDelete)
			{
				if(pCurrent->lpPrev)
					pCurrent->lpPrev->lpNext = pCurrent->lpNext;
				else
					m_lpSearchData = pCurrent->lpNext;
				delete pCurrent;
			}
			//ύX
			else
			{
				pCurrent->lpszPath = new TCHAR[wcslen(lpszNewPath)+1];
				wcscpy(pCurrent->lpszPath, lpszNewPath);
				pCurrent->lpszName = new TCHAR[wcslen(lpszNewName)+1];
				wcscpy(pCurrent->lpszName, lpszNewName);
			}
			break;
		}
		
		//̃o
		pCurrent = pNext;

	} //End of while
}
///////////////////////////////////////////////////////////////
void CListView::OnFileSearch()
{
	//_CAO쐬
//MOD START GORIPON
	CFileSearch Dlg(g_MainWnd.m_hWnd, g_hInst, m_szCurrentFolder);
	if(Dlg.Open())
	{
		//ʓWJ
		LPTSTR lpszPath = DupStringTable(IDS_SEARCH_FOLDER_NAME);
		LoadFolderItem(lpszPath);
		FreeStringTable(lpszPath);
	}
	SetFocus(m_hWnd);
//MOD END
}
///////////////////////////////////////////////////////////////
void CListView::OnGotoFolderDropDown()
{
	//c[{^ʒu擾
	RECT rc;
	HWND hToolbar = g_MainWnd.m_CmdBands.m_hToolbar;
	SendMessage(hToolbar, TB_GETRECT, (WPARAM)IDC_BTN_GOTOFOLDER, (LPARAM)&rc);
	MapWindowPoints(hToolbar, HWND_DESKTOP, (LPPOINT)&rc, 2);

	//|bvAbvj[̃nh擾
	HMENU hSubMenu = GetUserPathSubMenu1();

	//c[{^̃hbv_Ej[\
	TPMPARAMS tpm;
	memset(&tpm, 0x00, sizeof(tpm));
	tpm.cbSize = sizeof(TPMPARAMS);
	tpm.rcExclude = rc;

	//j[̕\
	TrackPopupMenu(hSubMenu, TPM_LEFTALIGN|TPM_BOTTOMALIGN,
			rc.left, rc.top, 0, g_MainWnd.m_hWnd, NULL);
}
//ADD END
//ADD START TODA (from GSFinder ver.1.99)
///////////////////////////////////////////////////////////////
BOOL CListView::IsSelectionFile()
{
	int nIndex = GetSelectedItemIndex(0);
	if (nIndex == -1)
		return FALSE;
	LISTITEMCOMP *plic = GetListItemStruct(nIndex);
	return plic->nItem == LIST_ITEM_FILE ? TRUE : FALSE;
}
///////////////////////////////////////////////////////////////
BOOL CListView::CreateShortcut(LPTSTR szDir, LPTSTR szTargetDir, LPTSTR szTargetFile)
{
	int n = 0;
	TCHAR szTarget[MAX_PATH];
	TCHAR szPath[MAX_PATH];
	TCHAR szFileName[MAX_PATH];

	DisableUpdateNotify();
	wsprintf(szTarget, _T("\"%s\\%s\""), szTargetDir, szTargetFile);
	wcscpy(szFileName, szTargetFile);
	if (m_Settings.bNotShowExt || m_bNoExtShortcut) {	//MOD TODA
		LPTSTR p = wcsrchr(szFileName, _T('.'));
		if (p) *p = NULL;
	}
	
	for (int i = 1; i < 512; i++) {
		if (m_Settings.bNotShortcutName) {
			//`ւ̃V[gJbgȂ
//MOD START GORIPON
			wsprintf(szPath, GetStringTable(i==1?IDS_FMT_NEWSHORTCUT3:IDS_FMT_NEWSHORTCUT4), szDir, szFileName, i);	//MOD GORIPON
//MOD END
		}
		else {
			//`ւ̃V[gJbg
//MOD START GORIPON
			wsprintf(szPath, GetStringTable(i==1?IDS_FMT_NEWSHORTCUT1:IDS_FMT_NEWSHORTCUT2), szDir, szFileName, i);	//MOD GORIPON
//MOD END
		}
		if (SHCreateShortcut(szPath, szTarget))
			break;
	}
	EnableUpdateNotify();
	return TRUE;
}
//ADD END