#include "GSFinder.h"

///////////////////////////////////////////////////////////////
int CALLBACK ListSortCompareFuncByName(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	LISTITEMCOMP* pList1 = (LISTITEMCOMP*)lParam1;
	LISTITEMCOMP* pList2 = (LISTITEMCOMP*)lParam2;
	BOOL bRaise = (BOOL)lParamSort;

//MOD START GORIPON
	if (pList1->nItem < pList2->nItem)
		return -1;
	else if (pList1->nItem > pList2->nItem)
		return 1;
	else
		return bRaise ? wcsicmp(pList1->lpszName, pList2->lpszName) : wcsicmp(pList2->lpszName, pList1->lpszName);
//MOD END

	return 0;
}

///////////////////////////////////////////////////////////////
int CALLBACK ListSortCompareFuncByExt(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	LISTITEMCOMP* pList1 = (LISTITEMCOMP*)lParam1;
	LISTITEMCOMP* pList2 = (LISTITEMCOMP*)lParam2;
	BOOL bRaise = (BOOL)lParamSort;

//MOD START GORIPON
	if (pList1->nItem < pList2->nItem)
		return -1;
	else if (pList1->nItem > pList2->nItem)
		return 1;
	else
	{
		if (pList1->nItem == LIST_ITEM_FILE)
		{
			LPCTSTR lpszExt1 = wcsrchr(pList1->lpszName,_T('.'));	//MOD TODA
			LPCTSTR lpszExt2 = wcsrchr(pList2->lpszName,_T('.'));	//MOD TODA
			if (lpszExt1 && lpszExt2)
			{
				if (bRaise)
				{
					int nRet = wcsicmp(lpszExt1, lpszExt2);
					return nRet ? nRet : wcsicmp(pList1->lpszName, pList2->lpszName);
				}	
				else
				{
					int nRet = wcsicmp(lpszExt2, lpszExt1);
					return nRet ? nRet : wcsicmp(pList2->lpszName, pList1->lpszName);
				}
			}
			else if (lpszExt1 == NULL)
				return bRaise ? -1 : 1;
			else
				return bRaise ? 1 : -1;
		}
		else
			return bRaise ? wcsicmp(pList1->lpszName, pList2->lpszName) : wcsicmp(pList2->lpszName, pList1->lpszName);
	}
//MOD END

	return 0;
}
///////////////////////////////////////////////////////////////
int CALLBACK ListSortCompareFuncBySize(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	LISTITEMCOMP* pList1 = (LISTITEMCOMP*)lParam1;
	LISTITEMCOMP* pList2 = (LISTITEMCOMP*)lParam2;
	BOOL bRaise = (BOOL)lParamSort;

//MOD START GORIPON
	if (pList1->nItem < pList2->nItem)
		return -1;
	else if (pList1->nItem > pList2->nItem)
		return 1;
	else
	{
		if (pList1->nItem == LIST_ITEM_FILE)
		{
			if (bRaise)
			{
				if (pList1->dwSize < pList2->dwSize)
					return -1;
				else if (pList1->dwSize > pList2->dwSize)
					return 1;
				else
					return 0;
			}
			else
			{
				if (pList1->dwSize < pList2->dwSize)
					return 1;
				else if (pList1->dwSize > pList2->dwSize)
					return -1;
				else
					return 0;
			}
		}
		else
			return bRaise ? wcsicmp(pList1->lpszName, pList2->lpszName) : wcsicmp(pList2->lpszName, pList1->lpszName);
	}
//MOD END

	return 0;
}
///////////////////////////////////////////////////////////////
int CALLBACK ListSortCompareFuncByTime(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	//MOD START TODA r̍ (from Y.Nagamidori)
	LISTITEMCOMP* pList1 = (LISTITEMCOMP*)lParam1;
	LISTITEMCOMP* pList2 = (LISTITEMCOMP*)lParam2;
	BOOL bRaise = (BOOL)lParamSort;

//MOD START GORIPON
	if (pList1->nItem < pList2->nItem)
		return -1;
	else if (pList1->nItem > pList2->nItem)
		return 1;
	else
		return bRaise ? CompareFileTime(&pList1->ft, &pList2->ft) : CompareFileTime(&pList2->ft, &pList1->ft);
//MOD END
	//MOD END

	return 0;
}