/*
 *	GSFinder+ - File manager software for WindowsCE
 *	Copyright(C) 2000-2005 Y.Nagamidori (based source code)
 *	Copyright(C) 2004-2005 M.Toda (modified source code)
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#if !defined(__GSFINDER_H_INCLUDED)
#define __GSFINDER_H_INCLUDED

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

///////////////////////////////////////////////////////////////
#include "resource.h"
#include <windows.h>
#include <winuser.h>
#include <commctrl.h>
#include <commdlg.h>
#include <shellapi.h>
#include <dbt.h>
#include <Sipapi.h>
#include <Aygshell.h>
#include <projects.h>
//#include "Strings.h"	//DEL GORIPON
#include "MainWnd.h"

///////////////////////////////////////////////////////////////
//DEFINE
//#define MAX_LOADSTRING		100				//DEL GORIPON
//MOD START GORIPON
#define APP_MAINWND_TITLE	_T("GSFinder+ W03")
#define APP_MUTEX_NAME		_T("GSFINDERW03")
//MOD END
#define APP_CMD_PARAM		_T("/FOLDER:")
#define APP_CMD_PARAM_LEN	8

//DEL START GORIPON
//#define ID_EDIT_COPY		IDM_EDIT_COPY
//#define ID_EDIT_CUT		IDM_EDIT_CUT
//#define ID_EDIT_PASTE		IDM_EDIT_PASTE
//#define ID_FILE_OPEN		IDM_FILE_OPEN
//#define ID_VIEW_TOOLBAR	IDM_VIEW_TOOLBAR
//DEL END

#define APP_SPLIT_SIZE		4
#define COMPDLL_MODE_LHA	1		//ADD TODA
#define COMPDLL_MODE_ZIP	2		//ADD TODA

#define LIST_ITEM_UPPER		0
#define LIST_ITEM_FOLDER	1
#define LIST_ITEM_FILE		2

#define LIST_SORT_NAME		0
#define LIST_SORT_EXT		1
#define LIST_SORT_SIZE		2
#define LIST_SORT_TIME		3

#define RETCODE_YES			0
#define RETCODE_NO			1
#define RETCODE_ALL_YES		2
#define RETCODE_ALL_NO		3

//ADD START GORIPON (CopyDlg.hړ)
#define ID_TIMER_RESETTIME		1
#define TIMER_RESETTIME_INT		10000
//ADD END
#define ID_TIMER_TVSELECTED		2	//ADD TODA
#define	TIMER_TVSELECTED_INT	500	//ADD GORIPON
//DEL START GORIPON (sv[`폜ɂ薢gp̂)
//#define ID_TIMER_MENUCANCEL	3	//ADD TODA
//#define ID_TIMER_TAPHOLD		4	//ADD TODA
//DEL END
//ADD START GORIPON
#define ID_TIMER_FOWARDFIND		3
#define TIMER_FOWARDFIND_INT	1000
//ADD END
#define ID_TIMER_DEVICECHANGE	5	//ADD TODA
#define	TIMER_DEVICECHANGE_INT	2000	//ADD GORIPON

#define AREA_TAPHOLD		5		//ADD TODA

#define WM_DROPFILES		0x0233
#define WM_UPDATENOTIFY		(WM_USER + 1)	//ADD TODA (from Y.Nagamidori)

#define MENU_HEIGHT			26

//ADD START TODA (from GSFinder ver.1.99)
#define RECT_WIDTH(prc)		((prc)->right - (prc)->left)
#define RECT_HEIGHT(prc)	((prc)->bottom - (prc)->top)
//MOD START GORIPON
#define REG_KEY_GSF				_T("Software\\goripon\\GSFinder-W03")
#define REG_KEY_SETTINGS		_T("Software\\goripon\\GSFinder-W03\\Settings")
#define REG_KEY_CMDBANDS		_T("Software\\goripon\\GSFinder-W03\\Settings\\Cmdbands")
#define REG_KEY_FILEIMAGELIST	_T("Software\\goripon\\GSFinder-W03\\Settings\\FileImageList")
#define REG_KEY_LISTVIEW		_T("Software\\goripon\\GSFinder-W03\\Settings\\ListView")
#define REG_KEY_RECENT			_T("Software\\goripon\\GSFinder-W03\\Settings\\Recent")
#define REG_KEY_PHONESTAT		_T("Software\\Sharp\\PhoneStatus")
//MOD END
//ADD END

//ADD START TODA (PocketPC̃L[Ώ)
#define GET_KEYSTATE			GetKeyState
//ADD END

//ADD START GORIPON
#define GET_X_LPARAM(lp)	((int)(short)LOWORD(lp))
#define GET_Y_LPARAM(lp)	((int)(short)HIWORD(lp))

#define ID_POPUP_FILEVIEW_FILE		(0)
#define ID_POPUP_FILEVIEW_FOLDER	(1)
#define ID_POPUP_FILEVIEW_MULTI		(2)
#define ID_POPUP_FILEVIEW_NOSELECT	(3)
#define ID_POPUP_DRAGDROP			(4)
#define ID_POPUP_GOTO				(5)
#define ID_POPUP_FOLDERDLG			(6)
#define ID_POPUP_FOLDERVIEW			(7)
//ADD END

///////////////////////////////////////////////////////////////
// O[oϐ:
extern HINSTANCE g_hInst;			// ݂̃CX^X
extern CMainWnd g_MainWnd;			//CEChE
extern LPTSTR g_lpszFirstLoadFolder;
extern BOOL		g_bDraging;			//ADD TODA

///////////////////////////////////////////////////////////////
extern "C"
{
	LRESULT CALLBACK MainWndProc(HWND, UINT, WPARAM, LPARAM);
	LRESULT CALLBACK About(HWND, UINT, WPARAM, LPARAM);
	DWORD GetVersion();
	BOOL VGACheck();
	void CenterWindow(HWND);
	void SetFormatInteger(LPTSTR, UINT);
	void SetFormatDouble(LPTSTR, UINT);
	void SetFormatDateTime(SYSTEMTIME*, LPTSTR, UINT, BOOL bToday=FALSE);
	void SetKickExt(LPTSTR);
	void SetExtFromFileName(LPTSTR, LPTSTR);
	UINT GetFileAndFolderCount(LPCTSTR , LISTITEMINFO*, int);
	BOOL IsFolderShortcut(LPCTSTR, LPCTSTR);
	int CALLBACK PropSheetCallback(HWND, UINT, LPARAM);
	BOOL DefDlgPaintProc(HWND hDlg, WPARAM wParam, LPARAM lParam);
	BOOL DefDlgPaintProc2(HWND hDlg, WPARAM wParam, LPARAM lParam);
	BOOL DefDlgCtlColorStaticProc(HWND hDlg, WPARAM wParam, LPARAM lParam);

	int CALLBACK ListSortCompareFuncByName(LPARAM, LPARAM, LPARAM);
	int CALLBACK ListSortCompareFuncByExt(LPARAM, LPARAM, LPARAM);
	int CALLBACK ListSortCompareFuncBySize(LPARAM, LPARAM, LPARAM);
	int CALLBACK ListSortCompareFuncByTime(LPARAM, LPARAM, LPARAM);
	//DWORD GetIMStatus();	//DEL GORIPON

	void SetFormatSize(DWORD dwSize, TCHAR szBuff[64], LPTSTR lpszFmtKB, LPTSTR lpszFmtMB);
	LPCTSTR GetRootName();					//ADD TODA
	int AddRootIcon(HIMAGELIST hImageList);	//ADD TODA
	HFONT MyCreateFont(int, BYTE, LPTSTR);	//ADD TODA

	void InitUpdateNotify();				//ADD TODA
	void EnableUpdateNotify();				//ADD TODA
	void DisableUpdateNotify();				//ADD TODA
	void SetUpdateNotify(LPCTSTR pszDir);	//ADD TODA
	void UninitUpdateNotify();				//ADD TODA

//ADD START GORIPON
	LPWSTR GetStringTable(int);
	LPWSTR DupStringTable(int);
	VOID FreeStringTable(LPWSTR);
//ADD END
};

///////////////////////////////////////////////////////////////
#endif // !defined(__GSFINDER_H_INCLUDED)
