#if !defined(__LISTVIEW_H_INCLUDED)
#define __LISTVIEW_H_INCLUDED

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

///////////////////////////////////////////////////////////////
//INCLUDE
#include "resource.h"
#include "FileImageList.h"
#include "MultiBuff.h"
#include "Compress.h"		//ADD TODA

///////////////////////////////////////////////////////////////
typedef struct _tagListItemComp
{
	LPTSTR lpszPath;		//ADD TODA (p)
	LPTSTR lpszName;
	FILETIME ft;
	DWORD dwSize;
	int nItem;
	DWORD dwAttr;

	//\p
	int nState;
	int nIcon;
	LPTSTR lpszDispName;
	LPTSTR lpszDispSize;
	LPTSTR lpszDispType;
	LPTSTR lpszDispTime;
	_tagListItemComp()
	{
		nIcon = -1;
		lpszDispName = NULL;
		lpszDispSize = NULL;
		lpszDispType = NULL;
		lpszDispTime = NULL;
	}
} LISTITEMCOMP;

typedef struct _tagListItemInfo
{
	int		nIndex;
	int		nItem;
	TCHAR	szPath[MAX_PATH];	//ADD TODA
	TCHAR	szName[MAX_PATH];
	BOOL	bDone;
} LISTITEMINFO;

typedef struct _tagOpenAppInfo
{
	LPTSTR lpszPath;
} OPENAPPINFO;

//ADD START TODA
typedef struct _tagFavoritesInfo
{
	LPTSTR lpszPath;
	struct _tagFavoritesInfo	*lpNext;
} FAVORITESINFO;

typedef struct _tagHistoryInfo
{
	LPTSTR					lpszPath;
	struct _tagHistoryInfo	*lpPrev;
	struct _tagHistoryInfo	*lpNext;
} HISTORYINFO;

typedef struct _tabSearchData
{
	LPTSTR					lpszPath;
	LPTSTR					lpszName;
	DWORD					dwAttr;
	FILETIME				ft;
	DWORD					dwSize;
	struct _tabSearchData	*lpPrev;
	struct _tabSearchData	*lpNext;
} SEARCHDATA;
//ADD END

///////////////////////////////////////////////////////////////
//DEFINE
#define MAX_OPENAPP 16
#define KEY_ACTION_COUNT 1000

///////////////////////////////////////////////////////////////
// CListViewNX
typedef struct _tagFileImageListSettings
{
	BOOL bNotLoadFileIcon;		//t@C̃ACRǂݍނ
	BOOL bNotLoadROMIcon;		//ROMt@C̃ACRǂݍނ
	BOOL bNotLoadCompIcon;		//kt@C̃ACRǂݍނ
	BOOL bStuffingIcons;		//ADD GORIPON
}FILEIMAGELISTSETTINGS;

typedef struct _tagListViewSettings
{
	int		nSort;
	BOOL	bSortRaise;
	DWORD	dwListStyle;
	DWORD	dwListExStyle;
	BOOL	bHideHidden;
	BOOL	bHideSystem;
	BOOL	bHideROM;
	int		nNameColumnSize;
	int		nSizeColumnSize;
	int		nTypeColumnSize;
	int		nTimeColumnSize;
	BOOL	bSaveFolder;
	BOOL	bNotShortcutName;
	BOOL	bNotShowExt;
	BOOL	bSingleClick;
	BOOL	bHideHeader;
	BOOL	bAddUpper;

	DWORD	nCompDLL;				//ADD TODA
	BOOL	bAutoUnComp;			//ADD TODA
	BOOL	bMakeDir;				//ADD TODA
	BOOL	bMoveDir;				//ADD TODA
	BOOL	bDblClick;				//ADD TODA
}LISTVIEWSETTINGS;

class CListView
{
public:
	HWND		m_hWnd;// R}h o[ nh

	CFileImageList m_FileImageListLarge;
	CFileImageList m_FileImageListSmall;
	CFileImageList* m_pFileImageList;
	FILEIMAGELISTSETTINGS m_ImageListSettings;
	LISTVIEWSETTINGS m_Settings;
	TCHAR	m_szCurrentFolder[MAX_PATH];
	TCHAR	m_szCompressFolder[MAX_PATH];	//ADD TODA
	TCHAR	m_szOldFolder[MAX_PATH];		//ADD TODA
	BOOL	m_bTimeStump;					//ADD TODA
	BOOL	m_bHideFolder;					//ADD TODA
	BOOL	m_bNoExtShortcut;				//ADD TODA
	CCompress	*m_pCompress;				//ADD TODA
//ADD START GORIPON
	CMultiBuff	m_ItemStruct;
	BOOL	m_bUseReportPageMove;
	TCHAR	m_szFowardFindName[MAX_PATH];
//ADD END

	//CUT & PASTEp
	int m_nCount;
	BOOL m_bFileMove;
	LISTITEMINFO* m_lpliinfo;
	TCHAR m_szFolderFrom[MAX_PATH];

	UINT m_nFileSize;
	
	//j[
	HMENU m_hMenuPopup;

	OPENAPPINFO* m_lpOpenAppInfo[MAX_OPENAPP];
	OPENAPPINFO* m_lpOpenPthInfo[MAX_OPENAPP];	//ADD TODA
	int m_nOpenAppInfoCount;
	int m_nOpenPthInfoCount;					//ADD TODA
	
	BOOL			m_bEditing;
	DWORD			m_dwUpperParam;
	//ADD START TODA
//DEL START GORIPON
	//BOOL			m_bTaping;
	//BOOL			m_bHolding;
//DEL END
	BOOL			m_bMenu;
	HWND			m_hFocus;
	DWORD			m_dwTapPos;
	int				m_nItemCnt;
	int				*m_lpnItem;
	int				m_nSelectStart;
	int				m_nSelectMin;
	int				m_nSelectItem;
	HISTORYINFO		*m_lpHistory;
	HISTORYINFO		*m_lpHistoryCurrent;
	SEARCHDATA		*m_lpSearchData;
	FAVORITESINFO	*m_lpFavorites;
	FAVORITESINFO	*m_lpFavoritesCurrent;
	int				m_nFavoritesCount;
	//ADD END
//ADD START GORIPON
	BOOL			m_bThroughContextMenu;
	BOOL			m_bOwnKeyup;
//ADD END GORIPON

public:
	CListView();
	~CListView();
	void Init(HWND);
	void Destroy();
	void SetImageList();
	void GetSettings();
	void SaveSettings();

	void SortList();

	void OnSelEndOK();
	void OnColumnClick(NMLISTVIEW*);

	void MainWindowReset(LPCTSTR, int);			//ADD TODA
	void LoadFolderReset(LPCTSTR);				//ADD TODA
	void LoadFolderSearch(LPCTSTR);				//ADD TODA
	void LoadFolderFiles(LPCTSTR, BOOL);		//ADD TODA
	void LoadFolderItem(LPCTSTR lpszPath, BOOL bTVUpdate = TRUE);	//MOD TODA
	void InitFolderItem(LPCTSTR lpszPath);		//ADD GORIPON
	void LoadFolderItemSub(LPCTSTR);			//ADD TODA
	void SelectFile(LPCTSTR);					//ADD TODA
	void AddFolderItemSub(LPCTSTR, LPCTSTR, DWORD, FILETIME, DWORD, UINT*);	//MOD GORIPON
//ADD START GORIPON
	void AddFolderItemFolder(LPCTSTR, LPCTSTR, DWORD, FILETIME, DWORD, UINT*);
	void AddFolderItemFile(LPCTSTR, LPCTSTR, DWORD, FILETIME, DWORD, UINT*);
//ADD END
	void AddFolderItem(WIN32_FIND_DATA*, LPCTSTR, UINT*);		//MOD GORIPON
	void ComFileOpen(LPCTSTR);					//ADD TODA

	HMENU GetOpenAppSubMenu1();					//ADD TODA
	HMENU GetOpenAppSubMenu2();					//ADD TODA
	void DeleteOpenAppSubMenuSep(HMENU);		//ADD TODA
	void InitOpenAppMenu();
	HMENU GetUserPathSubMenu1();					//mod by kawa
	HMENU GetUserPathSubMenu2();					//add by kawa
	void DeleteUserPathMenuSep(HMENU);			//ADD TODA
	void DeleteUserPathMenu();					//ADD TODA
	void InitUserPathMenu();					//ADD TODA
	void OnToolUserPath(int);					//ADD TODA
	HMENU GetFavoritesSubMenu1();				//mod by kawa
	HMENU GetFavoritesSubMenu2();				//add by kawa
	int  DeleteFavoritesItem(FAVORITESINFO*);					//ADD TODA
	FAVORITESINFO *AddFavoritesItem(FAVORITESINFO*,LPCTSTR);	//ADD TODA
	void DeleteFavoritesMenu();					//ADD TODA
	void DeleteSubMenu(HMENU);					//ADD TODA
	void InitFavoritesMenu();					//ADD TODA
	void InitFavoritesSubMenu(HMENU, LPTSTR, int *pnCnt=NULL);	//ADD TODA
	void OnToolFavoritesLnk(int);				//ADD TODA

	void OnChangeListStyle(UINT);
	void OnChangeSort(UINT);

	void OnViewUpdate(LPCTSTR lpszPath=NULL);	//MOD TODA
	void OnViewUpFolder();
	void OnViewFolder();

	void OnItemChanged(LPNMLISTVIEW lpnmlv);	//MOD GORIPON (p[^ǉ)
	DWORD OnKeyDown(LPNMLVKEYDOWN);				//MOD TODA
	int CheckMessageID(int);					//ADD TODA
	void OnRClick(int, int);

	BOOL OnEndLabelEdit(LV_DISPINFO*);
	void OnFileRename();
	void OnEditCopyFileName();
	void OnEditCopyFilePath();
//MOD START GORIPON
	void OnEditCut(LPCWCH lpszFolderFrom=NULL);
	void OnEditCopy(LPCWCH lpszFolderFrom=NULL);
//MOD END
	void OnEditPaste(BOOL bUpdate = TRUE);		//MOD TODA
	void OnEditSelectSwitch();
	void OnEditPasteShortcut(BOOL bUpdate = TRUE); //MOD TODA

	int GetSelectedItemIndex(int);
	LISTITEMCOMP* GetListItemStruct(int);
	void MakeSelectedItemsStrings(LISTITEMINFO*, int);

	void OnFileCreateFolder();
	void OnFileCreateShortcut();
	void OnFileShortcutFolder(LPTSTR lpszPath=NULL);//MOD TODA
	void OnFileProperty();
	void OnFileOpen();
	void OnFileOpen(int);
	void OnFileOpenParam();
	void OnFileOpenApp(int);
	void OnFileToApp();					//ADD TODA (from GSFinder ver.1.99)
	void OnFileIRSend();
	void OnFileCopyFolder();
	void OnFileMoveFolder();
	void OnFileDelete();

	BOOL OnFileCompress();				//ADD TODA
	BOOL OnFileUnCompress();			//ADD TODA

	void OnTapAndHold(NMRGINFO*);
	void OnTapHoldBegin(DWORD);
	//void OnTapHoldCancel();			//DEL GORIPON
	void OnTapHoldEnter();
//DEL START GORIPON
	//void OnExitMenuLoop();
	//void OnSelectMenuLoop();
//DEL END
	void OnGetDispInfo(NMLVDISPINFO*);
	void OnListStyle();

	void DeleteAllItem();
	void AddUpper();
	int GetValidAndSelectedCount();

	//ADD START TODA
	void OnMouseMove(POINT);
	void OnMouseMoveArea(POINT);
	BOOL OnLButtonUp(HWND);
	void OnDropEnter(HWND, int);
	void OnDropCansel();
	void OnFavoritesAdd();
	void OnFavoritesOrganize();
	void OnUserPath();
	HISTORYINFO* AddHistory(HISTORYINFO*, LPCTSTR);
	void DeleteHistory(HISTORYINFO*);
	void OnGoFront();
	void OnGoBack();
	
	SEARCHDATA *AddSearch(SEARCHDATA*,LPCTSTR,LPCTSTR,FILETIME,DWORD,DWORD);
	void DeleteSearch(SEARCHDATA*);
	void EditSearch(LPTSTR,LPTSTR,LPTSTR,LPTSTR,BOOL bDelete=FALSE);
	void OnFileSearch();
	void OnGotoFolderDropDown();
	//ADD END
	//ADD START TODA (from GSFinder ver.1.99)
	BOOL IsSelectionFile();
	BOOL CreateShortcut(LPTSTR szDir, LPTSTR szTargetDir, LPTSTR szTargetFile);
	//ADD END
//ADD GORIPON
	void OnFileMailSend();
	BOOL OnKeyArrowDown(WPARAM, LPARAM);
	BOOL OnKeyArrowUp(WPARAM, LPARAM);
	BOOL OnKeyDownMoveTop(WPARAM, LPARAM);
	BOOL OnKeyDownMoveTail(WPARAM, LPARAM);
	void OnSetFocus();
//ADD END
};
///////////////////////////////////////////////////////////////
#endif // !defined(__LISTVIEW_H_INCLUDED)
