///////////////////////////////////////////////////////////////
//TreeView.cpp
//tH_ꗗ\

///////////////////////////////////////////////////////////////
#include "GSFinder.h"
#include "TreeView2.h"
///////////////////////////////////////////////////////////////
#define ID_TREEVIEW			1

//ADD START TODA
WNDPROC	Org_TreeViewProc = NULL;
///////////////////////////////////////////////////////////////
LRESULT CALLBACK TreeViewProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
//MOD START GORIPON
	switch (message)
	{
	case WM_KEYUP:
		switch (wParam)
		{
		case VK_PROCESSKEY:
			return 0;
		case VK_BACK:
			if (TreeView_GetSelection(hWnd) == g_MainWnd.m_TreeView.m_hRootItem)
				SetFocus(g_MainWnd.m_ListView.m_hWnd);
			else
				g_MainWnd.m_TreeView.OnViewUpFolder();
			return 0;
		}
		break;
	case WM_KEYDOWN:
		switch (wParam)
		{
		case VK_PROCESSKEY:
			return 0;
		case VK_HOME://HOMEL[
			g_MainWnd.m_ListView.OnGoBack();
			return 0;
		case VK_END://ENDL[
			g_MainWnd.m_ListView.OnGoFront();
			return 0;
		case VK_UP:
			if (TreeView_GetSelection(hWnd) == g_MainWnd.m_TreeView.m_hRootItem)
			{
				if (g_MainWnd.m_bEdgeLoop)
				{
					TreeView_SelectItem(hWnd, g_MainWnd.m_TreeView.m_hSearchItem);
					return 0;
				}
			}
			break;
		case VK_DOWN:
			if (TreeView_GetSelection(hWnd) == g_MainWnd.m_TreeView.m_hSearchItem)
			{
				if (g_MainWnd.m_bEdgeLoop)
				{
					TreeView_SelectItem(hWnd, g_MainWnd.m_TreeView.m_hRootItem);
					return 0;
				}
			}
			break;
		case VK_BACK:
			return 0;
		default:
			break;
		}
		break;
	case WM_CHAR:
		switch (wParam)
		{
		case VK_BACK:
			return 0;
		default:
			break;
		}
		break;
	case WM_SETFOCUS:
		g_MainWnd.m_CmdBands.SetModeFocusMove(TRUE);
		break;
	case WM_KILLFOCUS:
		g_MainWnd.m_CmdBands.SetModeFocusMove(FALSE);
		break;
	case WM_LBUTTONDOWN:	//^bvJn
		g_MainWnd.m_TreeView.OnTapHoldBegin((DWORD)lParam);
		break;
//ADD START GORIPON (EMEONEXN[zC[Ή)
	case WM_MOUSEWHEEL:	//
		if (GET_WHEEL_DELTA_WPARAM(wParam) < 0)
		{
			keybd_event(VK_DOWN, 0x3D, 0, 0);
			keybd_event(VK_DOWN, 0x3D, KEYEVENTF_KEYUP, 0);
		}
		else if (GET_WHEEL_DELTA_WPARAM(wParam) > 0)
		{
			keybd_event(VK_UP, 0x3E, 0, 0);
			keybd_event(VK_UP, 0x3E, KEYEVENTF_KEYUP, 0);
		}
		return 0;
//ADD END
	//ȊO
	default:
		break;
	}
	return CallWindowProc((WNDPROC)Org_TreeViewProc, hWnd, message, wParam, lParam);
//MOD END
}
//ADD END

///////////////////////////////////////////////////////////////
CTreeView::CTreeView()
{
	m_hImageList = NULL;
	m_bEditing = FALSE;
	m_hRootItem = NULL;
	m_bLoadReq = TRUE;
	m_bTimer = FALSE;
//DEL START GORIPON
	//m_bTaping = FALSE;
	//m_bHolding = FALSE;
//DEL END
	m_nPressAndHoldCount = 0;	//ADD GORIPON
}
///////////////////////////////////////////////////////////////
CTreeView::~CTreeView()
{
}
///////////////////////////////////////////////////////////////
void CTreeView::Init(HWND hwndParent)
{
//MOD START GORIPON
	DWORD dwStyle = WS_TABSTOP | WS_VISIBLE | WS_CHILD | TVS_EDITLABELS |
				TVS_HASBUTTONS | TVS_HASLINES | TVS_SHOWSELALWAYS | WS_BORDER;
	DWORD dwExStyle = 0;
//MOD END

	m_hWnd = CreateWindowEx(dwExStyle,
							WC_TREEVIEW,
							NULL, dwStyle, 0, 0, 0, 0,
							hwndParent, (HMENU)ID_TREEVIEW,
							g_hInst, NULL);

	//ADD START TODA (^bv&z[hp)
	Org_TreeViewProc = (WNDPROC)GetWindowLong(m_hWnd, GWL_WNDPROC);
	SetWindowLong(m_hWnd, GWL_WNDPROC, (DWORD)TreeViewProc);

	//ADD END
	InitImageList();
	LoadFolderTree();	//MOD TODA (Rg̉)

//DEL START TODA ({̈)
//	TreeView_DeleteAllItems(m_hWnd);
//
//	TVINSERTSTRUCT tvis;
//	tvis.hParent = NULL;
//	tvis.hInsertAfter = TVI_SORT;
//	tvis.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN;
//	tvis.item.pszText = (LPTSTR)GetRootName();
//	tvis.item.iImage = 0;
//	tvis.item.iSelectedImage = 0;
//	tvis.item.cChildren = 1;
//	HTREEITEM hRoot = TreeView_InsertItem(m_hWnd, &tvis);
//	m_hRootItem = hRoot;
//	TreeView_Expand(m_hWnd, hRoot, TVE_EXPAND);
//DEL END
}

///////////////////////////////////////////////////////////////
void CTreeView::Destroy()
{
	ImageList_Destroy(m_hImageList);
	//DestroyWindow(m_hWnd);	//DEL GORIPON (eEChEDestroyWindowőp)
}

//ADD START TODA
///////////////////////////////////////////////////////////////
void CTreeView::TreeExpand(HWND hTree, HTREEITEM hItem, BOOL bDelete)
{
	if(bDelete)
	{
		//c[̎qm[hSč폜
		HTREEITEM hChild = TreeView_GetChild(hTree, hItem);
		while(hChild) {
			HTREEITEM hNext = TreeView_GetNextItem(hTree, hChild, TVGN_NEXT);
			TreeView_DeleteItem(hTree, hChild);
			hChild = hNext;
		}
	}

	//qm[h̍Ď擾
	TCHAR szKey[MAX_PATH];
	//1.tH_擾
	GetTree(hItem, szKey);
	//2.qc[񋓂
	EnumChildren(hItem, szKey);
}
//ADD END

///////////////////////////////////////////////////////////////
void CTreeView::LoadChildFolder(HTREEITEM hParent, LPCTSTR szPath)
{
	WIN32_FIND_DATA finddata;
	TCHAR szTemp[MAX_PATH];
	HTREEITEM hTreeItem;
	wsprintf(szTemp, _T("%s\\*.*"), szPath);

	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		BOOL bRet = TRUE;
		do
		{
			if (finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
				TVINSERTSTRUCT tvis;
				tvis.hParent = hParent;
				tvis.hInsertAfter = TVI_SORT;
				tvis.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
				tvis.item.pszText = finddata.cFileName;
				tvis.item.iImage = 1;
				tvis.item.iSelectedImage = 1;
				hTreeItem = TreeView_InsertItem(m_hWnd, &tvis);
				wsprintf(szTemp, _T("%s\\%s"), szPath, finddata.cFileName);
				LoadChildFolder(hTreeItem, szTemp);
			}
		}
		while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

	TreeView_SortChildren(m_hWnd, hParent, 0);
}

///////////////////////////////////////////////////////////////
//MOD TODA (p[^ǉ)
void CTreeView::SetCurrentFolder(LPCTSTR lpszPath, BOOL bUpdate, BOOL bSelect)
{
//DEL START TODA (\ɂȂ?{h~) 
//	//c[r[\
//	HWND hwndPrev = GetFocus();
//	ShowWindow(m_hWnd, SW_HIDE);
//DEL END
	m_bLoadReq = FALSE;

	//fBNgw̏ꍇ
	if(0 == _tcscmp(GetStringTable(IDS_SEARCH_FOLDER_NAME), lpszPath))	//MOD GORIPON
	{
		//[gWJ
		TreeView_Expand(m_hWnd, m_hRootItem, TVE_EXPAND);

		//ACeI
		TreeView_SelectItem(m_hWnd, m_hSearchItem);
		m_bLoadReq = TRUE;
		return;
	}

	KillTimer(NULL, ID_TIMER_TVSELECTED);
	LPCTSTR lpszStart = wcschr(lpszPath, _T('\\'));

	//Jnm[h[gɐݒ
	HTREEITEM hSelectItem = m_hRootItem;
	HTREEITEM hParent = m_hRootItem;

	//[gWJ
	TreeView_Expand(m_hWnd, hParent, TVE_EXPAND);

	//ACeȂȂ܂ŌJԂ
	while (lpszStart)
	{
		//fBNgo
		TCHAR szName[MAX_PATH] = _T("");
		LPCTSTR lpszEnd = wcschr(lpszStart + 1, _T('\\'));
		if (lpszEnd) {
			int len = lpszEnd - (lpszStart + 1);
			wcsncpy(szName, ++lpszStart, len);
			szName[len] = 0;
		}
		else
			wcscpy(szName, ++lpszStart);

		//qm[h擾
		HTREEITEM hChild = TreeView_GetChild(m_hWnd, hParent);
		while (hChild)
		{
			//qm[h̃ACe擾
			TCHAR szChildName[MAX_PATH] = _T("");
			TVITEM tvi;
			tvi.mask = TVIF_TEXT | TVIF_HANDLE;
			tvi.pszText = szChildName;
			tvi.cchTextMax = MAX_PATH;
			tvi.hItem = hChild;
			TreeView_GetItem(m_hWnd, &tvi);
			
			//Ώۂ̃fBNg̏ꍇ
			if (wcsicmp(szName, szChildName) == 0)	//MOD GORIPON
			{
				hSelectItem = hParent = hChild;
				lpszStart = wcschr(lpszStart, _T('\\'));
				if (lpszStart) {
					//qm[hWJ
					TreeView_Expand(m_hWnd, hParent, TVE_EXPAND);
				}
				break;
			}

			hChild = TreeView_GetNextItem(m_hWnd, hChild, TVGN_NEXT);
		
		} //End of while

		if(!hChild) break;

	} //End of while

	//ADD START TODA (m[hXV鏈ǉ)
	if(bUpdate)
	{
		//m[h̏Ԃ擾
		TVITEM tvi;
		tvi.mask = TVIF_CHILDREN | TVIF_STATE | TVIF_HANDLE;
		tvi.hItem = hParent;
		tvi.cChildren = 0;
		TreeView_GetItem(m_hWnd, &tvi);

		//XVO̎qm[h擾
		HTREEITEM hChild = TreeView_GetChild(m_hWnd, hParent);

		//擪m[hXV(쐬Ȃ)
		TreeExpand(m_hWnd, hParent);

		//XVOɎqm[hAm[hWJĂꍇ
		if (hChild && (tvi.state&TVIS_EXPANDED))	//MOD GORIPON
			//m[hJ
			TreeView_Expand(m_hWnd, hParent, TVE_EXPAND);
		else
			//m[h
			TreeView_Expand(m_hWnd, hParent, TVE_COLLAPSE);
	}
	//ADD END

	//ACeI
	if(bSelect)			//ADD TODA
		TreeView_SelectItem(m_hWnd, hSelectItem);

	m_bLoadReq = TRUE;

//DEL START TODA (\ɂȂ?{h~) 
//	//c[r[\
//	ShowWindow(m_hWnd, SW_SHOW);
//	SetFocus(hwndPrev);
//DEL END
}

///////////////////////////////////////////////////////////////
void CTreeView::LoadFolderTree()
{
	m_bLoadReq = FALSE;

//	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
	HWND hwndPrev = GetFocus();
	ShowWindow(m_hWnd, SW_HIDE);
	
	TreeView_DeleteAllItems(m_hWnd);

	TVINSERTSTRUCT tvis;
	tvis.hParent = NULL;
	tvis.hInsertAfter = TVI_SORT;
	tvis.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN;
	tvis.item.pszText = (LPTSTR)GetRootName();
	tvis.item.iImage = 0;
	tvis.item.iSelectedImage = 0;
	tvis.item.cChildren = 1;
	HTREEITEM hRoot = TreeView_InsertItem(m_hWnd, &tvis);
//	LoadChildFolder(hRoot, _T(""));
	m_hRootItem = hRoot;
	TreeView_Expand(m_hWnd, hRoot, TVE_EXPAND);

//	m_hRootItem = hRoot;

//	SetCursor(hCursor);

	//ADD TODA (ʃtH_쐬)
	LoadSeachFolderRoot();

	m_bLoadReq = TRUE;

	ShowWindow(m_hWnd, SW_SHOW);
	SetFocus(hwndPrev);
}

//ADD START TODA
///////////////////////////////////////////////////////////////
void CTreeView::LoadSeachFolderRoot()
{
	TVINSERTSTRUCT tvis;
	tvis.hParent = NULL;
	tvis.hInsertAfter = TVI_LAST;
	tvis.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN;
	tvis.item.pszText = DupStringTable(IDS_SEARCH_FOLDER_NAME);	//MOD GORIPON
	tvis.item.iImage = 7;
	tvis.item.iSelectedImage = 7;
	tvis.item.cChildren = 0;
	m_hSearchItem = TreeView_InsertItem(m_hWnd, &tvis);
	FreeStringTable(tvis.item.pszText);
}
//ADD END

///////////////////////////////////////////////////////////////
void CTreeView::InitImageList()
{
	m_bLoadReq = FALSE;
	TreeView_DeleteAllItems(m_hWnd);
	TreeView_SetImageList(m_hWnd, NULL, TVSIL_NORMAL);
	ImageList_Destroy(m_hImageList);

	//ImageList쐬
//MOD START GORIPON (nC]Ή)
	if (g_MainWnd.m_bHighRresolutionMode || !g_MainWnd.m_bHighDpiHardware)
	{
		m_hImageList = ImageList_Create(16, 16, ILC_COLOR|ILC_MASK, 1, 2);
		AddRootIcon(m_hImageList);
		HICON hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDERO_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_START_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_NETFOLDER_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_SEARCH_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
	}
	else
	{
		m_hImageList = ImageList_Create(32, 32, ILC_COLOR|ILC_MASK, 1, 2);
		AddRootIcon(m_hImageList);
		HICON hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_M);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDERO_M);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_M);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_M);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_START_M);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_NETFOLDER_M);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_SEARCH_M);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
	}
//MOD END
	TreeView_SetImageList(m_hWnd, m_hImageList, TVSIL_NORMAL);
	m_bLoadReq = TRUE;
}

///////////////////////////////////////////////////////////////
void CTreeView::SetCurrentFolder()
{
	TCHAR szPath[MAX_PATH] = _T("");
	TCHAR szTemp[MAX_PATH] = _T("");
	TCHAR szName[MAX_PATH] = _T("");
	
	HTREEITEM hTreeItem = TreeView_GetSelection(m_hWnd);
	TVITEM tvi;
	tvi.mask = TVIF_TEXT | TVIF_HANDLE;
	tvi.pszText = szName;
	tvi.cchTextMax = MAX_PATH;
	tvi.hItem = hTreeItem;
	TreeView_GetItem(m_hWnd, &tvi);
	if (wcscmp(szName, GetRootName()) != 0)
	{
		wcscpy(szPath, szName);
		hTreeItem = TreeView_GetParent(m_hWnd, hTreeItem);
		while (hTreeItem)
		{
			tvi.hItem = hTreeItem;
			TreeView_GetItem(m_hWnd, &tvi);
			if (wcscmp(szName, GetRootName()) != 0)
				wsprintf(szTemp, _T("%s\\%s"), szName, szPath);
			else
				wsprintf(szTemp, _T("\\%s"), szPath);
			wcscpy(szPath, szTemp);
			hTreeItem = TreeView_GetParent(m_hWnd, hTreeItem);
		}
		
		wcscpy(szTemp, szPath);
	}
	else
	{
		wcscpy(szTemp, _T(""));
	}
	
	g_MainWnd.m_ListView.LoadFolderItem(szTemp, FALSE);
}

//ADD START TODA
////////////////////////////////////////////////////////////////
void CTreeView::GetCurrentFolder(LPTSTR lpszPath)
{
	TCHAR szPath[MAX_PATH] = _T("");
	TCHAR szTemp[MAX_PATH] = _T("");
	TCHAR szName[MAX_PATH] = _T("");
	
	HTREEITEM hTreeItem = TreeView_GetSelection(m_hWnd);
	TVITEM tvi;
	tvi.mask = TVIF_TEXT | TVIF_HANDLE;
	tvi.pszText = szName;
	tvi.cchTextMax = MAX_PATH;
	tvi.hItem = hTreeItem;
	TreeView_GetItem(m_hWnd, &tvi);
	if (wcscmp(szName, GetRootName()) != 0)
	{
		wcscpy(szPath, szName);
		hTreeItem = TreeView_GetParent(m_hWnd, hTreeItem);
		while (hTreeItem)
		{
			tvi.hItem = hTreeItem;
			TreeView_GetItem(m_hWnd, &tvi);
			if (wcscmp(szName, GetRootName()) != 0)
				wsprintf(szTemp, _T("%s\\%s"), szName, szPath);
			else
				wsprintf(szTemp, _T("\\%s"), szPath);
			wcscpy(szPath, szTemp);
			hTreeItem = TreeView_GetParent(m_hWnd, hTreeItem);
		}
		
		wcscpy(szTemp, szPath);
	}
	else
	{
//		wcscpy(szTemp, _T(""));
		szTemp[0] = 0x00;
	}
	
	wcscpy(m_szCurrentFolder, szTemp);
	if(lpszPath) wcscpy(lpszPath, szTemp);
}
////////////////////////////////////////////////////////////////
DWORD CTreeView::OnKeydown(LPNMTVKEYDOWN lpnkd)
{
	if (m_bEditing) return 0;

	if(g_bDraging)
	{
		if(lpnkd->wVKey == VK_ESCAPE) {
			g_MainWnd.OnDropCansel();
			g_bDraging = FALSE;
		}
		return 0;
	}

	//V[gJbgL[e[u
	if ((lpnkd->wVKey == 'M' && (GET_KEYSTATE(VK_CONTROL)&0x8000)) ||
		(lpnkd->wVKey == VK_CONTROL && (GET_KEYSTATE(VK_MENU)&0x8000)))
	{
		HTREEITEM hItem = TreeView_GetSelection(m_hWnd);
		if(hItem)
		{
			RECT rc;
			TreeView_GetItemRect(m_hWnd, hItem, &rc, TRUE);
			OnRClick(rc.left + (rc.right - rc.left) / 2, rc.top + (rc.bottom - rc.top) / 2);
		}
		else
			OnRClick(0, 0);
	}
	else
		//Xgr[̃L[Ɠꍇ
		return g_MainWnd.m_ListView.OnKeydown((LPNMLVKEYDOWN)lpnkd);

	return 0;
}

///////////////////////////////////////////////////////////////
void CTreeView::OnSetFocus()
{
	g_MainWnd.m_CmdBands.SetEnableItemSelected2();
}
//ADD END

///////////////////////////////////////////////////////////////
void CTreeView::OnKillFocus()
{
	KillTimer(g_MainWnd.m_hWnd, ID_TIMER_TVSELECTED);
	if (m_bTimer) {
		SetCurrentFolder();
		m_bTimer = FALSE;
	}
}

///////////////////////////////////////////////////////////////
void CTreeView::OnSelChanged(NMTREEVIEW* lpnmtv)
{
	if (!m_bLoadReq) return;

	KillTimer(g_MainWnd.m_hWnd, ID_TIMER_TVSELECTED);
	if (lpnmtv->action == TVC_BYKEYBOARD) {
		SetTimer(g_MainWnd.m_hWnd, ID_TIMER_TVSELECTED, TIMER_TVSELECTED_INT, NULL);	//MOD GORIPON
		m_bTimer = TRUE;
	}
	else if (lpnmtv->action == TVC_BYMOUSE)
		SetCurrentFolder();
}
//ADD START TODA
///////////////////////////////////////////////////////////////
BOOL CTreeView::OnEndLabelEdit(TV_DISPINFO* pdi)
{
	TV_DISPINFO* pDispInfo = (TV_DISPINFO*)pdi;

	int nIndex = (int)pDispInfo->item.hItem;
	if (!pDispInfo->item.pszText) return FALSE;

	//G[`FbN
	if (wcschr(pDispInfo->item.pszText, _T('\\'))!=NULL || wcschr(pDispInfo->item.pszText, _T('/'))!=NULL || wcschr(pDispInfo->item.pszText, _T(':'))!=NULL || wcschr(pDispInfo->item.pszText, _T(','))!=NULL || wcschr(pDispInfo->item.pszText, _T(';'))!=NULL || wcschr(pDispInfo->item.pszText, _T('*'))!=NULL || wcschr(pDispInfo->item.pszText, _T('?'))!=NULL || wcschr(pDispInfo->item.pszText, _T('<'))!=NULL || wcschr(pDispInfo->item.pszText, _T('>'))!=NULL || wcschr(pDispInfo->item.pszText, _T('|'))!=NULL)
	{
		MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_CANNOTUSECHAR), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON
		SetFocus(m_hWnd);
		TreeView_EditLabel(m_hWnd, nIndex);
		return FALSE;
	}
	else
	{
		if (wcslen(pDispInfo->item.pszText))
		{
			TCHAR szTempPath[MAX_PATH];
			wcscpy(szTempPath, m_szCurrentFolder);
			LPTSTR lpszTemp = wcsrchr(szTempPath, _T('\\'));
			if (lpszTemp)
			{
				*lpszTemp = 0;
				TCHAR szNewPath[MAX_PATH];
				TCHAR szOldPath[MAX_PATH];
				wsprintf(szOldPath, _T("%s"), m_szCurrentFolder);
				wsprintf(szNewPath, _T("%s\\%s"), szTempPath, pDispInfo->item.pszText);
				DisableUpdateNotify();			//ADD TODA (t@CύXʒm from Y.Nagamidori)
		
				//tH_ύX
				if (!MoveFile(szOldPath, szNewPath))
				{
					MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_RENAMEERROR), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON
					SetFocus(m_hWnd);
					TreeView_EditLabel(m_hWnd, nIndex);
					EnableUpdateNotify();		//ADD TODA (t@CύXʒm from Y.Nagamidori)
					return FALSE;
				}

				EnableUpdateNotify();			//ADD TODA (t@CύXʒm from Y.Nagamidori)
				
				//ύX̃pX֍XV
				wcscat(szNewPath, _T("\\"));
				g_MainWnd.m_ListView.LoadFolderItem(szNewPath, FALSE);
			}
			else
			{
				//ۑpX(oȌꍇ̂ݔ)
				MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_RENAMEERROR), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON
				SetFocus(m_hWnd);
				TreeView_EditLabel(m_hWnd, nIndex);
				return FALSE;
			}
		}
		else
		{
			//s
			MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_INPUTNAME), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON
			SetFocus(m_hWnd);
			TreeView_EditLabel(m_hWnd, nIndex);
			return FALSE;
		}

	}

	return TRUE;
}
////////////////////////////////////////////////////////////////
void CTreeView::OnRClick(int cx, int cy, BOOL bSelect)
{
	HTREEITEM hItem=0;
	TVHITTESTINFO tv_ht;
	
	//IACe̎擾
	memset(&tv_ht, 0x00, sizeof(tv_ht));
	tv_ht.flags = TVHT_ONITEM;
	tv_ht.pt.x = cx;
	tv_ht.pt.y = cy;
	if(bSelect) ScreenToClient(m_hWnd, &(tv_ht.pt));
	hItem = TreeView_HitTest(m_hWnd, &tv_ht);

	//IACeȂꍇȂɂȂ
	if(!hItem) return;

	if(bSelect)
	{
		//ACẽnCCg
		TreeView_SelectItem(m_hWnd, hItem);
	}

	//ACẽx擾
	TCHAR szChildName[MAX_PATH] = _T("");
	TVITEM tvi;
	tvi.mask = TVIF_TEXT | TVIF_HANDLE;
	tvi.pszText = szChildName;
	tvi.cchTextMax = MAX_PATH;
	tvi.hItem = hItem;
	TreeView_GetItem(m_hWnd, &tvi);

	//tH_̏ꍇ
	if (wcscmp(szChildName, GetStringTable(IDS_SEARCH_FOLDER_NAME)) == 0)	//MOD GORIPON
	{
		//j[͕\Ȃ
		return;
	}

//MOD START GORIPON
	//ENbNj[쐬
	HMENU hMenu = GetSubMenu(g_MainWnd.m_ListView.m_hMenuPopup, ID_POPUP_FOLDERVIEW);
	UINT uEnable = g_MainWnd.m_ListView.m_nCount? MF_BYCOMMAND|MF_ENABLED: MF_BYCOMMAND|MF_GRAYED;
	EnableMenuItem(hMenu, ID_EDIT_PASTE, uEnable);
	uEnable = (wcscmp(szChildName, GetRootName()) == 0)? MF_BYCOMMAND|MF_GRAYED: MF_BYCOMMAND|MF_ENABLED;
	EnableMenuItem(hMenu, ID_EDIT_CUT, uEnable);
	EnableMenuItem(hMenu, ID_EDIT_COPY, uEnable);
//MOD END

	//k/̗L/
	g_MainWnd.m_CmdBands.SetEnableCompressSelected(hMenu, hMenu, 0, 2, g_MainWnd.m_ListView.m_Settings.nCompDLL); //add by kawa

	//ENbNj[\
	TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN,
				cx, cy, 0, g_MainWnd.m_hWnd, NULL);
}
//ADD END
///////////////////////////////////////////////////////////////
// -- Ex.Q --
// c[ r[̍ڂ̐΃pX߂
void CTreeView::GetTree (HTREEITEM hItem, LPTSTR pszKey)
{
	TCHAR szName[MAX_PATH];

	TV_ITEM tvi;
	memset (&tvi, 0, sizeof (tvi));

	// e擾
	HTREEITEM hParent;
	hParent = TreeView_GetParent (m_hWnd, hItem);
	if (hParent) { 
		// ڂ̐e̐eEEE擾
		GetTree (hParent, pszKey);

		// ڂ̖O擾
		tvi.mask       = TVIF_TEXT;
		tvi.hItem      = hItem;
		tvi.pszText    = szName;
		tvi.cchTextMax = MAX_PATH;
		TreeView_GetItem (m_hWnd, &tvi);

		// [głȂ΁
		if (wcscmp(pszKey, GetRootName()) != 0)
			lstrcat (pszKey, TEXT("\\"));
		else
			lstrcpy (pszKey, TEXT("\\"));

		// ẽpXɍ̃tH_ǉ
		lstrcat (pszKey, szName);
	} else {
		//MOD START TODA ([gǉ)
		if(hItem == m_hRootItem)
		{
			// ڂ̖O擾
			lstrcpy(pszKey, GetRootName());
			szName[0]      = _T('\0');
			tvi.mask       = TVIF_TEXT | TVIF_PARAM;
			tvi.hItem      = hItem;
			tvi.pszText    = szName;
			tvi.cchTextMax = MAX_PATH;
			TreeView_GetItem (m_hWnd, &tvi);
		}
		//MOD END
		//ADD START TODA ()
		if(hItem == m_hSearchItem)
		{
			// ڂ̖O擾
			lstrcpy(pszKey, GetStringTable(IDS_SEARCH_FOLDER_NAME));	//MOD GORIPON
			szName[0]      = _T('\0');
			tvi.mask       = TVIF_TEXT | TVIF_PARAM;
			tvi.hItem      = hItem;
			tvi.pszText    = szName;
			tvi.cchTextMax = MAX_PATH;
			TreeView_GetItem (m_hWnd, &tvi);
		}
	}
}

///////////////////////////////////////////////////////////////
// CountChildren - L[̃TuL[̐𒲂ׂ
//
int CTreeView::CountChildren (LPTSTR pszPath, LPTSTR pszKey)
{
	int rc;
	TCHAR szName[MAX_PATH];
	HANDLE ff;
	WIN32_FIND_DATA wfd;
    DWORD dwCnt = 0;

	if (wcscmp(pszPath, GetRootName()) != 0)
		wsprintf (szName, _T("%s\\%s\\*.*"), pszPath, pszKey);
	else
		wsprintf (szName, _T("\\%s\\*.*"), pszKey);

	ff = FindFirstFile( szName, &wfd );
	if (ff != INVALID_HANDLE_VALUE) {
		while (1) {
			if (wcsicmp(wfd.cFileName, _T("Recycled")) != 0 &&
				(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) {
				dwCnt++;
				break;
			}
			rc = FindNextFile (ff, &wfd);
			if (rc == 0)
				break;
		}
		FindClose(ff);
    }
	return dwCnt;
}

///////////////////////////////////////////////////////////////
// EnumChildren - L[̃TuL[񋓂
int CTreeView::EnumChildren(HTREEITEM hParent, LPTSTR pszPath)
{
	int rc;
    DWORD nChild;
	HANDLE ff;
	WIN32_FIND_DATA wfd;
	TCHAR szName[MAX_PATH];
	TVINSERTSTRUCT tvis;
	DWORD dwCnt = 0;

	//ADD START TODA (tH_̏ꍇ)
	if (_tcscmp(pszPath, GetStringTable(IDS_SEARCH_FOLDER_NAME)) == 0)	//MOD GORIPON
		return 0;
	//ADD END

	//ADD START TODA (qm[h̑݃`FbN)
	HTREEITEM hChild = TreeView_GetChild(m_hWnd, hParent);
	while(hChild) {

		//̃ACe擾
		HTREEITEM hNext = TreeView_GetNextItem(m_hWnd, hChild, TVGN_NEXT);

		//qm[h̃ACe擾
		TCHAR szChildName[MAX_PATH] = _T("");
		TVITEM tvi;
		tvi.mask = TVIF_TEXT | TVIF_HANDLE;
		tvi.pszText = szChildName;
		tvi.cchTextMax = MAX_PATH;
		tvi.hItem = hChild;
		TreeView_GetItem(m_hWnd, &tvi);

		if (wcscmp(pszPath, GetRootName()) != 0)
			wsprintf (szName, _T("%s\\%s"), pszPath, szChildName);
		else
			wsprintf (szName, _T("\\%s"), szChildName);

		//݂Ȃꍇ
		if(GetFileAttributes(szName) == 0xFFFFFFFF)
			TreeView_DeleteItem(m_hWnd, hChild);
		hChild = hNext;

	} //End of while
	//ADD END

	if (wcscmp(pszPath, GetRootName()) != 0)
		wsprintf (szName, _T("%s\\*.*"), pszPath);
	else
		wsprintf (szName, _T("\\*.*"));

	ff = FindFirstFile (szName, &wfd);
	if (ff != INVALID_HANDLE_VALUE) {
		
		while (1) {
			if ((wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ||
				wfd.dwFileAttributes & FILE_ATTRIBUTE_TEMPORARY) &&
				wcsicmp(wfd.cFileName, _T("Recycled")) != 0) {
				
				//ADD START TODA (qm[h̑݃`FbNǉ)
				//qm[h̑݃`FbN
				BOOL bFind = FALSE;
				HTREEITEM hChild = TreeView_GetChild(m_hWnd, hParent);
				while(hChild) {

					//̃ACe擾
					HTREEITEM hNext = TreeView_GetNextItem(m_hWnd, hChild, TVGN_NEXT);

					//qm[h̃ACe擾
					TCHAR szChildName[MAX_PATH] = _T("");
					TVITEM tvi;
					tvi.mask = TVIF_TEXT | TVIF_HANDLE;
					tvi.pszText = szChildName;
					tvi.cchTextMax = MAX_PATH;
					tvi.hItem = hChild;
					TreeView_GetItem(m_hWnd, &tvi);

					if (wcscmp(szChildName, wfd.cFileName) == 0)
					{
						bFind = !bFind;
						break;
					}
					hChild = hNext;

				} //End of while
				//ADD END

				if(!bFind)		//ADD TODA (ǉ)
				{
					// ʂ̃fBNg邩
					nChild = CountChildren (pszPath, wfd.cFileName);

					// c[ r[ Rg[ɃL[}
					tvis.hParent      = hParent;
					tvis.hInsertAfter = TVI_SORT;
					tvis.item.mask    = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN;
					tvis.item.pszText = wfd.cFileName;
					tvis.item.cChildren = (nChild ? 1 : 0);
					
					//ADD START TODA
					if (wcsicmp(wfd.cFileName, g_MainWnd.m_lpszStartMenu) == 0) {
						tvis.item.iImage = 5;
						tvis.item.iSelectedImage = 5;
					}
					else
					if (wcsicmp(wfd.cFileName, g_MainWnd.m_lpszNetwork) == 0) {
						tvis.item.iImage = 6;
						tvis.item.iSelectedImage = 6;
					}
					else
					//ADD END
					if (wfd.dwFileAttributes & FILE_ATTRIBUTE_TEMPORARY) {
						tvis.item.iImage = 3;
						tvis.item.iSelectedImage = 3;
					}
					else if (wcsicmp(wfd.cFileName, g_MainWnd.m_lpszMyDocument) == 0) {
						tvis.item.iImage = 4;
						tvis.item.iSelectedImage = 4;
					}
					else {
						tvis.item.iImage = 1;
						tvis.item.iSelectedImage = 2;
					}

					TreeView_InsertItem(m_hWnd, &tvis);
				}
				dwCnt++;
			}
			rc = FindNextFile (ff, &wfd);
			if (rc == 0)
				break;
		} //End of while
		FindClose(ff);
	}

	// TuL[Ȃꍇ͓WJ{^폜
	TVITEM tvi;
	tvi.hItem = hParent;
	tvi.mask  = TVIF_CHILDREN;
	//MOD TODA

	if (!TreeView_GetChild(m_hWnd, hParent))
		tvi.cChildren = 0;
	else
		tvi.cChildren = 1;
	TreeView_SetItem (m_hWnd, &tvi);

	// \[g
	TreeView_SortChildren(m_hWnd, hParent, 0);

	return dwCnt;
}

///////////////////////////////////////////////////////////////
void CTreeView::OnItemExpanded(NMTREEVIEW* lpnmtv)
{
	// Ƀu`WJƂɉ߂ė񋓂̂ŃTuL[폜
	if (lpnmtv->action == TVE_COLLAPSE) {
//ADD START TODA (IĂm[hꍇ̃tH[JXړ)
		if(lpnmtv->itemNew.hItem != lpnmtv->itemOld.hItem)
			SetCurrentFolder();
//ADD END
//DEL START TODA (OnItemExpanding()ɏړ)
//		HTREEITEM hChild;
//		HTREEITEM hNext;
//
//		hChild = TreeView_GetChild (lpnmtv->hdr.hwndFrom, lpnmtv->itemNew.hItem);
//		while (hChild) {
//			hNext = TreeView_GetNextItem (lpnmtv->hdr.hwndFrom, hChild, TVGN_NEXT);
//			TreeView_DeleteItem (lpnmtv->hdr.hwndFrom, hChild);
//			hChild = hNext;
//		}
//DEL END
	}
}

///////////////////////////////////////////////////////////////
void CTreeView::OnItemExpanding(NMTREEVIEW* lpnmtv)
{
	if (lpnmtv->action == TVE_EXPAND) {
		TreeExpand(m_hWnd, lpnmtv->itemNew.hItem);	//ADD TODA
//DEL START TODA (֐Ăяo(TreeExpand())ɂ)
//		TCHAR szKey[MAX_PATH];
//		//tH_擾
//		GetTree (lpnmtv->itemNew.hItem, szKey);
//		//qc[񋓂
//		EnumChildren (lpnmtv->itemNew.hItem, szKey);
//DEL END
	}
}

//ADD START TODA
///////////////////////////////////////////////////////////////
void CTreeView::OnMouseMove(POINT ptWnd)
{
	HWND hMain = g_MainWnd.m_hWnd;
	ClientToScreen(hMain, &ptWnd);

	//c[r[ɃnCCgݒ
	TVHITTESTINFO tv_ht ;
	memset(&tv_ht, 0x00, sizeof(tv_ht));
	tv_ht.flags = TVHT_ONITEM;
	tv_ht.pt.x = ptWnd.x;
	tv_ht.pt.y = ptWnd.y;
	ScreenToClient(m_hWnd, &(tv_ht.pt));
	
	HTREEITEM hItem = TreeView_HitTest(m_hWnd, &tv_ht);
	if(hItem)
	{
		//ACẽx擾
		TCHAR szChildName[MAX_PATH] = _T("");
		TVITEM tvi;
		tvi.mask = TVIF_TEXT | TVIF_HANDLE;
		tvi.pszText = szChildName;
		tvi.cchTextMax = MAX_PATH;
		tvi.hItem = hItem;
		TreeView_GetItem(m_hWnd, &tvi);

		//tH_ȊȌꍇ
		if (_tcscmp(szChildName, GetStringTable(IDS_SEARCH_FOLDER_NAME)) != 0)	//MOD GORIPON
			TreeView_SelectDropTarget(m_hWnd, hItem);
		else
			TreeView_SelectDropTarget(m_hWnd, NULL);
	}
	else
		TreeView_SelectDropTarget(m_hWnd, NULL);
}

///////////////////////////////////////////////////////////////
BOOL CTreeView::OnLButtonUp(HWND hWnd)
{
	HWND hMain = g_MainWnd.m_hWnd;
	
	//c[r[̃hbv
	DWORD dwPos = GetMessagePos();
	TVHITTESTINFO tv_ht;
	memset(&tv_ht, 0x00, sizeof(tv_ht));
	tv_ht.flags = TVHT_ONITEM;
//MOD START GORIPON
	tv_ht.pt.x = GET_X_LPARAM(dwPos);
	tv_ht.pt.y = GET_Y_LPARAM(dwPos);
//MOD END
	ScreenToClient(m_hWnd, &(tv_ht.pt));

	HTREEITEM hItem = TreeView_HitTest(m_hWnd, &tv_ht);
	if(hItem)
	{
		//ACẽx擾
		TCHAR szChildName[MAX_PATH] = _T("");
		TVITEM tvi;
		tvi.mask = TVIF_TEXT | TVIF_HANDLE;
		tvi.pszText = szChildName;
		tvi.cchTextMax = MAX_PATH;
		tvi.hItem = hItem;
		TreeView_GetItem(m_hWnd, &tvi);

		//tH_ȊȌꍇ
		if (_tcscmp(szChildName, GetStringTable(IDS_SEARCH_FOLDER_NAME)) != 0)	//MOD GORIPON
		{
			OnDropEnter(hWnd, hItem);
			return TRUE;
		}
		else
			return FALSE;

	} else
		return FALSE;
}

///////////////////////////////////////////////////////////////
void CTreeView::OnDropEnter(HWND hWnd, HTREEITEM hItem)
{
	HWND hMain = g_MainWnd.m_hWnd;
	BOOL b_shortcut = FALSE;
	BOOL b_cut = FALSE;
	
	DWORD iMenuID=0;
	//ShiftL[̓j[\
	if(GET_KEYSTATE(VK_LSHIFT)&0x8000  ||
		GET_KEYSTATE(VK_RSHIFT)&0x8000 ||
		g_MainWnd.m_bShiftKey ||
		g_MainWnd.m_bContextMenu)
	{
		DWORD dwPos = GetMessagePos();
		POINT pt;
//MOD START GORIPON
		pt.x = GET_X_LPARAM(dwPos);
		pt.y = GET_Y_LPARAM(dwPos);
		HMENU hMenu = GetSubMenu(g_MainWnd.m_ListView.m_hMenuPopup, ID_POPUP_DRAGDROP);
//MOD END
		iMenuID = TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN|TPM_RETURNCMD, pt.x, pt.y, 0, m_hWnd, NULL);		
		
		//j[I𖳂yуLZ̏ꍇ
		if(!iMenuID || iMenuID == ID_DROP_CANCEL) {
			//hbvACȅԂ
			TreeView_SelectDropTarget(m_hWnd, NULL);
			return;
		}
	}

	//hbvACȅԂ
	TreeView_SelectDropTarget(m_hWnd, NULL);

	//Rs[ȌԂ[ۑ
	TCHAR szFromFolder[MAX_PATH];
	GetCurrentFolder(szFromFolder);
	HTREEITEM hCurrent = TreeView_GetSelection(m_hWnd);

	//Rs[/؂/V[gJbg쐬s
	//Xgr[̃hbv
	if(hWnd != m_hWnd) {
		//1.Rs[̏ꍇ(+Ctl)
		if(iMenuID == ID_DROP_COPY ||
		   GET_KEYSTATE(VK_CONTROL)&0x8000 ||
		   g_MainWnd.m_bControlKey) {
			g_MainWnd.m_ListView.OnEditCopy();
			
		//2.V[gJbg쐬(+Alt)̏ꍇ
		} else if(iMenuID == ID_DROP_SHORTCUT ||
			      GET_KEYSTATE(VK_MENU)&0x8000) {
			g_MainWnd.m_ListView.OnEditCopy();
			b_shortcut = TRUE;

		//3.؂̏ꍇ
		} else {
			g_MainWnd.m_ListView.OnEditCut();
		}
	//c[r[̃hbv
	} else {
		//hbOACeI
		TreeView_SelectItem(m_hWnd, g_MainWnd.m_hDragTree);

		//1.Rs[̏ꍇ(+Ctl)
		if(iMenuID == ID_DROP_COPY ||
		   GET_KEYSTATE(VK_CONTROL)&0x8000 ||
		   g_MainWnd.m_bControlKey) {
			OnEditCopy();
			
		//2.V[gJbg쐬(+Alt)̏ꍇ
		} else if(iMenuID == ID_DROP_SHORTCUT ||
				  GET_KEYSTATE(VK_MENU)&0x8000) {
			OnEditCopy();
			b_shortcut = TRUE;

		//3.؂̏ꍇ
		} else {
			OnEditCut();
			b_cut = TRUE;
		}
	}

	//hbvACeI
	TreeView_SelectItem(m_hWnd, hItem);
	GetCurrentFolder(g_MainWnd.m_ListView.m_szCurrentFolder);

	//\ts
	if(iMenuID != ID_DROP_CANCEL) {
		if(b_shortcut) {
			g_MainWnd.m_ListView.OnEditPasteShortcut(FALSE);
		} else {
			g_MainWnd.m_ListView.OnEditPaste(FALSE);
		}
	}

	//\tÕfBNgȂꍇAʃfBNgֈړ
	while(GetFileAttributes(szFromFolder) == 0xFFFFFFFF) {
		LPTSTR lpszTemp = wcsrchr(szFromFolder, _T('\\'));
		if(lpszTemp) *lpszTemp = 0;
		else break;
	} // End of while

	//\tȌԂ֖߂
	g_MainWnd.m_ListView.LoadFolderItem(szFromFolder, FALSE);
}

///////////////////////////////////////////////////////////////
void CTreeView::OnDropCansel()
{
	//hbvI
	TreeView_SelectDropTarget(m_hWnd, NULL);
}

///////////////////////////////////////////////////////////////
void CTreeView::OnViewUpFolder()
{
//MOD START GORIPON
	if (wcscmp(g_MainWnd.m_ListView.m_szCurrentFolder, GetStringTable(IDS_SEARCH_FOLDER_NAME)) == 0)
	{
		*g_MainWnd.m_ListView.m_szOldFolder = _T('\0');
		g_MainWnd.m_ListView.LoadFolderItem(_T(""));
	}
	else
	{
		//݂̃ACe擾
		HTREEITEM hTreeItem = TreeView_GetSelection(m_hWnd);
		if(hTreeItem)
		{
			//̃ACe擾
			hTreeItem = TreeView_GetParent(m_hWnd, hTreeItem);

			if(hTreeItem)
				//ACẽnCCg
				TreeView_SelectItem(m_hWnd, hTreeItem);
		}

		//Xgr[̍XV
		SetCurrentFolder();
	}
//MOD END
}

///////////////////////////////////////////////////////////////
void CTreeView::OnEditCopy()
{
	//݂̃fBNgACeƂđI
	TCHAR szPath[MAX_PATH];
	GetCurrentFolder(szPath);
	g_MainWnd.m_ListView.SelectFile(szPath);

//MOD START GORIPON
	//Rs[s
	WCHAR szFromPath[MAX_PATH], *ptr;
	wcscpy(szFromPath, szPath);
	if (ptr = wcsrchr(szFromPath, _T('\\')))	//tH_\ł́uRs[tH_v́AJgtH_1Kww
		*ptr = _T('\0');
	g_MainWnd.m_ListView.OnEditCopy(szFromPath);
//MOD END

	//̃fBNg֖߂
	g_MainWnd.m_ListView.LoadFolderItem(szPath, FALSE);
}

///////////////////////////////////////////////////////////////
void CTreeView::OnEditCut()
{
	//݂̃fBNgACeƂđI
	TCHAR szPath[MAX_PATH];
	GetCurrentFolder(szPath);
	g_MainWnd.m_ListView.SelectFile(szPath);

//MOD START GORIPON
	//؂菈s
	WCHAR szFromPath[MAX_PATH], *ptr;
	wcscpy(szFromPath, szPath);
	if (ptr = wcsrchr(szFromPath, _T('\\')))	//tH_\ł́uRs[tH_v́AJgtH_1Kww
		*ptr = _T('\0');
	g_MainWnd.m_ListView.OnEditCut(szFromPath);
//MOD END

	//̃fBNg֖߂
	g_MainWnd.m_ListView.LoadFolderItem(szPath, FALSE);
}

///////////////////////////////////////////////////////////////
void CTreeView::OnFileDelete()
{
	//݂̃fBNgACeƂđI
	TCHAR szPath[MAX_PATH];
	GetCurrentFolder(szPath);
	g_MainWnd.m_ListView.SelectFile(szPath);

	//폜s
	g_MainWnd.m_ListView.OnFileDelete();

	//\tÕfBNgȂꍇAʃfBNgֈړ
	while(GetFileAttributes(szPath) == 0xFFFFFFFF) {
		LPTSTR lpszTemp = wcsrchr(szPath, _T('\\'));
		if(lpszTemp) *lpszTemp = 0;
		else break;
	} // End of while

	//̃fBNg֖߂
	g_MainWnd.m_ListView.LoadFolderItem(szPath, FALSE);
}

///////////////////////////////////////////////////////////////
void CTreeView::OnFileRename()
{
	//݂̑IACe擾
	HTREEITEM hItem = TreeView_GetSelection(m_hWnd);
	if (hItem) {
		//SipShowIM(SIPF_ON);	//DEL GORIPON
		//xҏWԂɂ
		SetFocus(m_hWnd);
		TreeView_EditLabel(m_hWnd, hItem);
	}
}

///////////////////////////////////////////////////////////////
void CTreeView::OnFileCreateShortcut()
{
	//݂̃fBNgACeƂđI
	TCHAR szPath[MAX_PATH];
	GetCurrentFolder(szPath);
	g_MainWnd.m_ListView.SelectFile(szPath);

	//V[gJbg쐬s
	g_MainWnd.m_ListView.OnFileCreateShortcut();

	//̃fBNg֖߂
	g_MainWnd.m_ListView.LoadFolderItem(szPath, FALSE);
}

///////////////////////////////////////////////////////////////
void CTreeView::OnFileProperty()
{
	//݂̃fBNgACeƂđI
	TCHAR szPath[MAX_PATH];
	GetCurrentFolder(szPath);
	g_MainWnd.m_ListView.SelectFile(szPath);

	//vpeBs
	g_MainWnd.m_ListView.OnFileProperty();

	//̃fBNg֖߂
	g_MainWnd.m_ListView.LoadFolderItem(szPath, FALSE);
}


//DEL START GORIPON
///////////////////////////////////////////////////////////////
//void CTreeView::OnFileIRSend()
//{
//	//݂̃fBNgACeƂđI
//	TCHAR szPath[MAX_PATH];
//	GetCurrentFolder(szPath);
//	g_MainWnd.m_ListView.SelectFile(szPath);
//
//	//ԊOMs
//	g_MainWnd.m_ListView.OnFileIRSend();
//
//	//̃fBNg֖߂
//	g_MainWnd.m_ListView.LoadFolderItem(szPath, FALSE);
//}
//
//DEL END
///////////////////////////////////////////////////////////////
void CTreeView::OnFileShortcutFolder()
{
	//݂̃fBNgACeƂđI
	TCHAR szPath[MAX_PATH];
	GetCurrentFolder(szPath);
	g_MainWnd.m_ListView.SelectFile(szPath);

	//V[gJbg𑗂鏈s
	g_MainWnd.m_ListView.OnFileShortcutFolder();

	//̃fBNg֖߂
	g_MainWnd.m_ListView.LoadFolderItem(szPath, FALSE);
}

///////////////////////////////////////////////////////////////
void CTreeView::OnFileCopyFolder()
{
	//݂̃fBNgACeƂđI
	TCHAR szPath[MAX_PATH];
	GetCurrentFolder(szPath);
	g_MainWnd.m_ListView.SelectFile(szPath);

	//t@CtH_փRs[s
	g_MainWnd.m_ListView.OnFileCopyFolder();

	//̃fBNg֖߂
	g_MainWnd.m_ListView.LoadFolderItem(szPath, FALSE);
}

///////////////////////////////////////////////////////////////
void CTreeView::OnFileMoveFolder()
{
	//݂̃fBNgACeƂđI
	TCHAR szPath[MAX_PATH];
	GetCurrentFolder(szPath);
	g_MainWnd.m_ListView.SelectFile(szPath);

	//t@CtH_ֈړs
	g_MainWnd.m_ListView.OnFileMoveFolder();

	//\tÕfBNgȂꍇAʃfBNgֈړ
	while(GetFileAttributes(szPath) == 0xFFFFFFFF) {
		LPTSTR lpszTemp = wcsrchr(szPath, _T('\\'));
		if(lpszTemp) *lpszTemp = 0;
		else break;
	} // End of while

	//̃fBNg֖߂
	g_MainWnd.m_ListView.LoadFolderItem(szPath, FALSE);
}

///////////////////////////////////////////////////////////////
void CTreeView::OnEditCopyFileName()
{
	//݂̃fBNgACeƂđI
	TCHAR szPath[MAX_PATH];
	GetCurrentFolder(szPath);
	g_MainWnd.m_ListView.SelectFile(szPath);

	//ORs[s
	g_MainWnd.m_ListView.OnEditCopyFileName();

	//̃fBNg֖߂
	g_MainWnd.m_ListView.LoadFolderItem(szPath, FALSE);
}

///////////////////////////////////////////////////////////////
void CTreeView::OnEditCopyFilePath()
{
	//݂̃fBNgACeƂđI
	TCHAR szPath[MAX_PATH];
	GetCurrentFolder(szPath);
	g_MainWnd.m_ListView.SelectFile(szPath);

	//ORs[s
	g_MainWnd.m_ListView.OnEditCopyFilePath();

	//̃fBNg֖߂
	g_MainWnd.m_ListView.LoadFolderItem(szPath, FALSE);
}

///////////////////////////////////////////////////////////////
BOOL CTreeView::OnFileCompress()
{
	//݂̃fBNgACeƂđI
	TCHAR szPath[MAX_PATH];
	GetCurrentFolder(szPath);
	g_MainWnd.m_ListView.SelectFile(szPath);

	//ks
	BOOL bRtn = g_MainWnd.m_ListView.OnFileCompress();

	//̃fBNg֖߂
	if(!(g_MainWnd.m_ListView.m_Settings.bMoveDir || 
		g_MainWnd.m_ListView.m_Settings.bAutoUnComp))
	{
		//̃fBNg֖߂
		g_MainWnd.m_ListView.LoadFolderItem(szPath, FALSE);
	}

	return bRtn;
}

///////////////////////////////////////////////////////////////
void CTreeView::OnFavoritesAdd()
{
	//݂̃fBNgACeƂđI
	TCHAR szPath[MAX_PATH];
	GetCurrentFolder(szPath);
	g_MainWnd.m_ListView.SelectFile(szPath);

	//Rs[s
	g_MainWnd.m_ListView.OnEditCopy();

	//Cɓ̃fBNgֈړ
	wcscpy(g_MainWnd.m_ListView.m_szCurrentFolder, g_MainWnd.m_szFavoritesPath);

//MOD START GORIPON
	//V[gJbg̓\t(ݒɊ֌WȂ"`ւ̃V[gJbg"͕tȂ)
	BOOL bTemp = g_MainWnd.m_ListView.m_Settings.bNotShortcutName;
	g_MainWnd.m_ListView.m_Settings.bNotShortcutName = TRUE;
	g_MainWnd.m_ListView.OnEditPasteShortcut(FALSE);
	g_MainWnd.m_ListView.m_Settings.bNotShortcutName = bTemp;
//MOD END

	//̃fBNg֖߂
	g_MainWnd.m_ListView.LoadFolderItem(szPath, FALSE);
//ADD START GORIPON

	//Cɓ胁j[̍č쐬
	g_MainWnd.m_ListView.InitFavoritesMenu();
//ADD END
}
///////////////////////////////////////////////////////////////
void CTreeView::OnTapAndHold()
{
	DWORD dwPos = GetMessagePos();
	OnRClick(GET_X_LPARAM(dwPos), GET_Y_LPARAM(dwPos), TRUE);	//MOD GORIPON
}
//ADD START GORIPON

///////////////////////////////////////////////////////////////
void CTreeView::OnTapAndHold(NMRGINFO* pnmri)
{
	OnRClick(pnmri->ptAction.x, pnmri->ptAction.y, TRUE);
}

//ADD END
///////////////////////////////////////////////////////////////
void CTreeView::OnTapHoldBegin(DWORD dwPos)
{
	SetFocus(m_hWnd);
}

//DEL START GORIPON
/////////////////////////////////////////////////////////////////
//void CTreeView::OnTapHoldCancel()
//{
//	if(m_bTaping)
//	{
//		//^C} ̍폜
//		m_bTaping = !m_bTaping;
//		KillTimer(m_hWnd, ID_TIMER_TAPHOLD);
//	}
//}
//
/////////////////////////////////////////////////////////////////
//void CTreeView::OnTapHoldEnter()
//{
//	if(m_bTaping)
//	{
//		//^C}̍폜
//		KillTimer(m_hWnd, ID_TIMER_TAPHOLD);
//
//		//݂̃EBhEʒu擾
//		DWORD dwPos = GetMessagePos();
//
//		//^bvACe擾
//		TVHITTESTINFO tv_ht;
//		memset(&tv_ht, 0x00, sizeof(tv_ht));
//		tv_ht.flags = TVHT_ONITEM;
////MOD START GORIPON
//		//tv_ht.pt.x = LOWORD(m_dwTapPos);
//		//tv_ht.pt.y = HIWORD(m_dwTapPos);
//		tv_ht.pt.x = GET_X_LPARAM(m_dwTapPos);
//		tv_ht.pt.y = GET_Y_LPARAM(m_dwTapPos);
////MOD END
//		HTREEITEM hFromItem = TreeView_HitTest(m_hWnd, &tv_ht);
//		
//		//݂̃ACe擾
//		memset(&tv_ht, 0x00, sizeof(tv_ht));
//		tv_ht.flags = TVHT_ONITEM;
////MOD START GORIPON
//		//tv_ht.pt.x = LOWORD(dwPos);
//		//tv_ht.pt.y = HIWORD(dwPos);
//		tv_ht.pt.x = GET_X_LPARAM(dwPos);
//		tv_ht.pt.y = GET_Y_LPARAM(dwPos);
////MOD END
//		ScreenToClient(m_hWnd, &(tv_ht.pt));
//		HTREEITEM hToItem = TreeView_HitTest(m_hWnd, &tv_ht);
//
//		//W̍
////MOD START GORIPON
//		//DWORD dwX = max(tv_ht.pt.x,LOWORD(m_dwTapPos))
//		//		  - min(tv_ht.pt.x,LOWORD(m_dwTapPos));
//		//DWORD dwY = max(tv_ht.pt.y,HIWORD(m_dwTapPos))
//		//		  - min(tv_ht.pt.y,HIWORD(m_dwTapPos));
//		DWORD dwX = max(tv_ht.pt.x,GET_X_LPARAM(m_dwTapPos))
//				  - min(tv_ht.pt.x,GET_X_LPARAM(m_dwTapPos));
//		DWORD dwY = max(tv_ht.pt.y,GET_Y_LPARAM(m_dwTapPos))
//				  - min(tv_ht.pt.y,GET_Y_LPARAM(m_dwTapPos));
////MOD END
//
//		//ACeLv(z[h)
//		if((hFromItem && hFromItem == hToItem) &&
//		   (dwX <= AREA_TAPHOLD && dwY <= AREA_TAPHOLD))
//			
//			//j[\
////MOD START GORIPON
//			//OnRClick(LOWORD(m_dwTapPos)+10, HIWORD(m_dwTapPos), FALSE);
//			OnRClick(GET_X_LPARAM(m_dwTapPos)+10, GET_Y_LPARAM(m_dwTapPos), FALSE);
////MOD END
//	}
//}
//
/////////////////////////////////////////////////////////////////
//void CTreeView::OnExitMenuLoop()
//{
//	//^bv&z[hȊO͖
//	if(!m_bTaping) return;
//
//	m_bTaping = !m_bTaping;
//	m_bHolding = !m_bHolding;
//
//	//j[LZp^C}ݒ
//	SetTimer(m_hWnd, ID_TIMER_MENUCANCEL, 500, NULL);
//}
//
/////////////////////////////////////////////////////////////////
//void CTreeView::OnSelectMenuLoop()
//{
//	//^bv&z[hȊȌꍇ
//	if(!m_bHolding) return;
//
//	//tOݒ
//	static BOOL bFlg = FALSE;
//	bFlg = !bFlg;
//
//	//1(ĂяoO)̏ꍇ
//	if(bFlg)
//	{
//		KillTimer(m_hWnd, ID_TIMER_MENUCANCEL);
//	}
//
//	//ҏWԂ̉
//	TreeView_EndEditLabelNow(m_hWnd, FALSE);
//
//	//2(Ăяo)̏ꍇ
//	if(!bFlg)
//	{
//		//^bv&z[h
//		m_bHolding = !m_bHolding;
//	}
//}
///////////////////////////////////////////////////////////////
//DEL END