#if !defined(__TREEVIEW_H_INCLUDED)
#define __TREEVIEW_H_INCLUDED

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

///////////////////////////////////////////////////////////////
//INCLUDE
#include "resource.h"

///////////////////////////////////////////////////////////////
// CTreeViewNX

class CTreeView
{
public:
	HWND		m_hWnd;
	HIMAGELIST	m_hImageList;
	BOOL		m_bEditing;
	HTREEITEM	m_hRootItem;
	HTREEITEM	m_hSearchItem;					//ADD TODA
	BOOL		m_bLoadReq;
	BOOL		m_bTimer;
//DEL START GORIPON
	//BOOL		m_bTaping;
	//BOOL		m_bHolding;
//DEL END
	HWND		m_hFocus;						//ADD TODA
	DWORD		m_dwTapPos;						//ADD TODA
	TCHAR		m_szCurrentFolder[MAX_PATH];	//ADD TODA
	INT			m_nPressAndHoldCount;			//ADD GORIPON

public:
	CTreeView();
	~CTreeView();
	void Init(HWND);
	void Destroy();

	void InitImageList();									//MOD TODA

	void TreeExpand(HWND, HTREEITEM, BOOL bDelete=FALSE);	//ADD TODA
	void LoadFolderTree(); //Refresh;
	void LoadSeachFolderRoot();								//ADD TODA
	void LoadChildFolder(HTREEITEM hParent, LPCTSTR szPath);

	void SetCurrentFolder(LPCTSTR lpszPath, BOOL bUpdate=TRUE, BOOL bSelect=TRUE);	//MOD TODA
	void SetCurrentFolder();
	void GetCurrentFolder(LPTSTR lpszPath=NULL);			//ADD TODA
	DWORD OnKeydown(LPNMTVKEYDOWN);							//ADD TODA
	void OnSetFocus();										//ADD TODA
	void OnKillFocus();
	void OnSelChanged(NMTREEVIEW*);
	BOOL OnEndLabelEdit(TV_DISPINFO*);						//ADD TODA

	void OnRClick(int cx, int cy, BOOL bSelect=FALSE);		//ADD TODA

	void OnItemExpanded(NMTREEVIEW*);
	void OnItemExpanding(NMTREEVIEW*);

	void GetTree (HTREEITEM, LPTSTR);
	int  CountChildren (LPTSTR, LPTSTR);
	int  EnumChildren (HTREEITEM, LPTSTR);

	void OnMouseMove(POINT);								//ADD TODA
	BOOL OnLButtonUp(HWND);									//ADD TODA
	void OnDropEnter(HWND, HTREEITEM);						//ADD TODA
	void OnDropCansel();									//ADD TODA

	void OnViewUpFolder();									//ADD TODA
	void OnEditCopy();										//ADD TODA
	void OnEditCut();										//ADD TODA
	void OnFileDelete();									//ADD TODA
	void OnFileRename();									//ADD TODA
	void OnFileCreateShortcut();							//ADD TODA
	void OnFileShortcutFolder();							//ADD TODA
	//void OnFileIRSend();									//DEL GORIPON

	void OnFileProperty();									//ADD TODA
	void OnFileCopyFolder();								//ADD TODA
	void OnFileMoveFolder();								//ADD TODA
	void OnEditCopyFileName();								//ADD TODA
	void OnEditCopyFilePath();								//ADD TODA

	BOOL OnFileCompress();									//ADD TODA

	void OnFavoritesAdd();									//ADD TODA
	void OnTapAndHold();									//ADD TODA
	void OnTapAndHold(NMRGINFO*);							//ADD GORIPON
	void OnTapHoldBegin(DWORD);								//ADD TODA
//DEL START GORIPON
	//void OnTapHoldCancel();
	//void OnTapHoldEnter();
	//void OnExitMenuLoop();
	//void OnSelectMenuLoop();
//DEL END
};
///////////////////////////////////////////////////////////////
#endif // !defined(__TREEVIEW_H_INCLUDED)
