///////////////////////////////////////////////////////////////
//TreeView.h
//tH_ꗗ\ - CTreeView

#if !defined(__TREEVIEW_H_INCLUDED)
#define __TREEVIEW_H_INCLUDED

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

///////////////////////////////////////////////////////////////
//INCLUDE
#include "resource.h"

///////////////////////////////////////////////////////////////
// CTreeViewNX

class CTreeView
{
public:
	HWND		m_hWnd;
	HIMAGELIST	m_hImageList;
	BOOL		m_bEditing;
	HTREEITEM	m_hRootItem;
	HTREEITEM	m_hSearchItem;
	BOOL		m_bLoadReq;
	BOOL		m_bTimer;
	HWND		m_hFocus;
	DWORD		m_dwTapPos;
	TCHAR		m_szCurrentFolder[MAX_PATH];
	BOOL		m_bPressAndHoldCorrect;

public:
	CTreeView();
	~CTreeView();
	void Init(HWND);
	void Destroy();

	void InitImageList();

	void TreeExpand(HWND, HTREEITEM, BOOL bDelete=FALSE);
	void LoadFolderTree(); //Refresh;
	void LoadSeachFolderRoot();
	void LoadChildFolder(HTREEITEM hParent, LPCTSTR szPath);

	void SetCurrentFolder(LPCTSTR lpszPath, BOOL bUpdate=TRUE, BOOL bSelect=TRUE);
	void SetCurrentFolder();
	void GetCurrentFolder(LPTSTR lpszPath=NULL);
	void OnKeydown(HWND, LPNMTVKEYDOWN);
	void OnSetFocus();
	void OnKillFocus();
	void OnSelChanged(NMTREEVIEW*);
	BOOL OnEndLabelEdit(TV_DISPINFO*);

	void OnRClick(int cx, int cy, BOOL bSelect=FALSE);

	void OnItemExpanded(NMTREEVIEW*);
	void OnItemExpanding(NMTREEVIEW*);

	void GetTree(HTREEITEM, LPTSTR);
	int  CountChildren (LPTSTR, LPTSTR);
	int  EnumChildren (HTREEITEM, LPTSTR);

	void OnMouseMove(POINT);
	BOOL OnLButtonUp(HWND);
	void OnDropEnter(HWND, HTREEITEM);
	void OnDropCansel();

	void OnViewUpFolder();
	void OnEditCopy();
	void OnEditCut();
	void OnFileDelete();
	void OnFileRename();
	void OnFileCreateShortcut();
	void OnFileShortcutFolder();

	void OnFileProperty();
	void OnFileCopyFolder();
	void OnFileMoveFolder();
	void OnEditCopyFileName();
	void OnEditCopyFilePath();

	BOOL OnFileCompress();

	void OnFavoritesAdd();
	void OnTapAndHold();
	void OnTapAndHold(NMRGINFO*);
	void OnTapHoldBegin(DWORD);
};

#endif // !defined(__TREEVIEW_H_INCLUDED)
