///////////////////////////////////////////////////////////////
//FolderDlgPPC.cpp
//tH_I_CAO - CFolderDlg

///////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "FolderDlgPPC.h"

///////////////////////////////////////////////////////////////
LRESULT CALLBACK FolderDlgTreeViewProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	CFolderDlg* pfd = (CFolderDlg*)GetWindowLong(hWnd, GWL_USERDATA);

	switch (message)
	{
	case WM_KEYUP:
		switch (wParam)
		{
		case VK_PROCESSKEY:
			return 0;

		case VK_RETURN:
			return 0;

		case VK_RIGHT:
			{
				HTREEITEM hItem = TreeView_GetSelection(hWnd);
				if (hItem)
				{
					RECT rc;
					TreeView_GetItemRect(hWnd, hItem, &rc, TRUE);
					PostMessage(hWnd, WM_LBUTTONDBLCLK, 0, MAKELPARAM(rc.left+1, rc.top+1));
				}
			}
			return 0;

		default:
			break;
		}
		break;

	case WM_KEYDOWN:
		switch (wParam)
		{
		case VK_PROCESSKEY:
			return 0;

		case VK_RETURN:
			{
				//tH_I_CAOł̃ReLXgj[Ή
				SHRGINFO shrg;
				RECT rc;

				HTREEITEM hItem = TreeView_GetSelection(hWnd);
				if (hItem)
				{
					TreeView_GetItemRect(hWnd, hItem, &rc, TRUE);
					shrg.cbSize = sizeof(shrg);
					shrg.hwndClient = hWnd;
					shrg.ptDown.x = rc.left + (int)(16 * g_MainWnd.m_fpHighResolutionScale);
					shrg.ptDown.y = rc.top + RECT_HEIGHT(&rc) / 2;
					shrg.dwFlags = SHRG_NOTIFYPARENT;
					pfd->m_bPressAndHoldCorrect = TRUE;
					if (SHRecognizeGesture(&shrg))
						return 0;
				}
			}
			return 0;

		default:
			break;
		}
		break;

	default:
		break;
	}

	return CallWindowProc(pfd->m_OldProc, hWnd, message, wParam, lParam);
}

///////////////////////////////////////////////////////////////
void CFolderDlg::CreateNewFolder(HWND hDlg)
{
	HWND hTV = GetDlgItem(hDlg, IDC_TREE_FOLDER);

	TCHAR szPath[MAX_PATH] = _T("");
	TCHAR szTemp[MAX_PATH] = _T("");
	TCHAR szName[MAX_PATH] = _T("");
	
	HTREEITEM hTreeItem = TreeView_GetSelection(hTV);
	TVITEM tvi;
	ZeroMemory(&tvi, sizeof(TVITEM));
	tvi.mask = TVIF_TEXT | TVIF_HANDLE;
	tvi.pszText = szName;
	tvi.cchTextMax = MAX_PATH;
	tvi.hItem = hTreeItem;
	TreeView_GetItem(hTV, &tvi);
	if (_tcscmp(szName, GetRootName()) != 0)
	{
		_tcscpy(szPath, szName);
		hTreeItem = TreeView_GetParent(hTV, hTreeItem);
		while (hTreeItem)
		{
			tvi.hItem = hTreeItem;
			TreeView_GetItem(hTV, &tvi);
			if (_tcscmp(szName, GetRootName()) != 0)
				_stprintf(szTemp, _T("%s\\%s"), szName, szPath);
			else
				_stprintf(szTemp, _T("\\%s"), szPath);
			_tcscpy(szPath, szTemp);
			hTreeItem = TreeView_GetParent(hTV, hTreeItem);
		}
	}
	else
		_tcscpy(szPath, _T(""));

	int nCount = 1;
	BOOL bCreate = FALSE;
	TCHAR szNewFolderName[MAX_PATH];
	while (!bCreate)
	{
		TCHAR szNewFolderPath[MAX_PATH] = _T("");

		_stprintf(szNewFolderName, GetResourceString((nCount > 1)? IDS_FMT_NEWFOLDERNAME1: IDS_FMT_NEWFOLDERNAME), nCount);
		_stprintf(szNewFolderPath, _T("%s\\%s"), szPath, szNewFolderName);

		bCreate = CreateDirectory(szNewFolderPath, NULL);
		nCount++;
		if (nCount > 1024)
		{
			MessageBox(hDlg, GetResourceString(IDS_MSG_CANNOTCREATEFOLDER), NULL, MB_OK|MB_ICONSTOP);
			return;
		}
	}

	SetFocus(hTV);
	HTREEITEM hParent = TreeView_GetSelection(hTV);
	ZeroMemory(&tvi, sizeof(TVITEM));
	tvi.hItem = hParent;
	tvi.mask = TVIF_CHILDREN|TVIF_STATE;
	TreeView_GetItem(hTV, &tvi);
	if (tvi.cChildren == 0)
	{
		ZeroMemory(&tvi, sizeof(TVITEM));
		tvi.hItem = hParent;
		tvi.mask  = TVIF_CHILDREN;
		tvi.cChildren = 1;
		TreeView_SetItem(hTV, &tvi);
		TreeView_Expand(hTV, hParent, TVE_EXPAND);
		hTreeItem = TreeView_GetChild(hTV, hParent);
		TreeView_SelectItem(hTV, hTreeItem);
	}
	else
	{
		TVINSERTSTRUCT tvis;
		ZeroMemory(&tvis, sizeof(TVINSERTSTRUCT));
		tvis.hParent = hParent;
		tvis.hInsertAfter = TVI_SORT;
		tvis.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
		tvis.item.pszText = szNewFolderName;
		tvis.item.iImage = 1;
		tvis.item.iSelectedImage = 1;
		hTreeItem = TreeView_InsertItem(hTV, &tvis);
		TreeView_Expand(hTV, hParent, TVE_EXPAND);
		TreeView_SelectItem(hTV, hTreeItem);
	}

	m_bRefresh = TRUE;
}

///////////////////////////////////////////////////////////////
void CFolderDlg::OnInitDialog(HWND hDlg)
{
	HWND hTreeView = GetDlgItem(hDlg, IDC_TREE_FOLDER);

	m_bRefresh = FALSE;
	m_hImageList = NULL;
	HICON hIcon;

	SHINITDLGINFO shidi;
	shidi.dwMask = SHIDIM_FLAGS;
	shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
	shidi.hDlg = hDlg;
	SHINITDIALOG(&shidi);

	if (!g_MainWnd.m_bIsSmartphone)	//Smartphone/Standard̏ꍇPPC2SPLIBɔĈŕsv
	{
		//j[o[ǉ
		SHMENUBARINFO mbi;
		memset(&mbi, 0, sizeof(SHMENUBARINFO));
		mbi.cbSize = sizeof(SHMENUBARINFO);
		mbi.hwndParent = hDlg;
		mbi.nToolBarId = IDR_FOLDER;
		mbi.hInstRes = g_hInst;
		mbi.nBmpId = 0;
		mbi.cBmpImages = 0;
		SHCreateMenuBar(&mbi);
	}

	//c[r[̃vV[Wo^(EL[c[WJp)
	m_OldProc = (WNDPROC)GetWindowLong(hTreeView, GWL_WNDPROC);
	SetWindowLong(hTreeView, GWL_USERDATA, (DWORD)this);
	SetWindowLong(hTreeView, GWL_WNDPROC, (DWORD)FolderDlgTreeViewProc);

	SendMessage(hTreeView, CCM_SETVERSION, COMCTL32_VERSION, 0);

	SetWindowText(hDlg, APP_MAINWND_TITLE);
	if (_tcslen(m_lpszTitle))
		SetDlgItemText(hDlg, IDC_TITLE, m_lpszTitle);

	//tHgύX
	SendMessage(hTreeView, WM_SETFONT, (WPARAM)g_MainWnd.m_hFont, MAKELPARAM(TRUE, 0));

	//TCY (TreeView)
	OnSize(hDlg);

	//C[WXg쐬
	if (g_MainWnd.m_bHighRresolutionMode || !g_MainWnd.m_bHighDpiHardware)
	{
		m_hImageList = ImageList_Create((int)((float)GetSystemMetrics(SM_CXSMICON)/g_MainWnd.m_fpHighResolutionScale), (int)((float)GetSystemMetrics(SM_CYSMICON)/g_MainWnd.m_fpHighResolutionScale), ILC_COLOR|ILC_MASK, 1, 2);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROOT_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DeleteObject(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDERO_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FILE_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
	}
	else
	{
		m_hImageList = ImageList_Create(GetSystemMetrics(SM_CXSMICON), GetSystemMetrics(SM_CYSMICON), ILC_COLOR | ILC_MASK, 1, 2);
		if (g_MainWnd.m_bIsSmartphone && !g_MainWnd.m_bDisableResizeSpIcon)
		{
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROOT_M);
			MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
			DeleteObject(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_M);
			MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDERO_M);
			MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_M);
			MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_M);
			MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FILE_M);
			MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
			DestroyIcon(hIcon);
		}
		else
		{
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROOT_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DeleteObject(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDERO_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FILE_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
		}
	}
	TreeView_SetImageList(hTreeView, m_hImageList, TVSIL_NORMAL);
	SetWindowLong(hTreeView, GWL_STYLE, GetWindowLong(hTreeView, GWL_STYLE)|TVS_HASBUTTONS|TVS_HASLINES|TVS_SHOWSELALWAYS);

	//tH_ǂݍ
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	TVINSERTSTRUCT tvis;
	tvis.hParent = NULL;
	tvis.hInsertAfter = TVI_SORT;
	tvis.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN;
	tvis.item.pszText = (LPTSTR)GetRootName();
	tvis.item.iImage = 0;
	tvis.item.iSelectedImage = 0;
	tvis.item.cChildren = 1;
	HTREEITEM hRoot = TreeView_InsertItem(hTreeView, &tvis);
	TreeView_Expand(hTreeView, hRoot, TVE_EXPAND);

	//JgtH_Zbg
	SetCurrentFolder(hTreeView, m_lpszPath);

	SipShowIM(SIPF_OFF);
	SetCursor(hCursor);
}
///////////////////////////////////////////////////////////////
BOOL CFolderDlg::OnOK(HWND hDlg)
{
	HWND hTV = GetDlgItem(hDlg, IDC_TREE_FOLDER);

	HTREEITEM hTreeItem = TreeView_GetSelection(hTV);
	GetTree(hTV, hTreeItem, m_lpszPath);
	if (m_bSelectFile && (GetFileAttributes(m_lpszPath) & FILE_ATTRIBUTE_DIRECTORY))
		return FALSE;
	else
	{
		EndDialog(hDlg, IDOK);
		return TRUE;
	}
}

///////////////////////////////////////////////////////////////
void CFolderDlg::OnSize(HWND hDlg)
{
	//TCY (TreeView)
	RECT rc;
	POINT pt;
	HWND htv;

	htv = GetDlgItem(hDlg, IDC_TREE_FOLDER);
	GetWindowRect(htv, &rc);
	pt.x = rc.left; pt.y = rc.top;
	ScreenToClient(hDlg, &pt);
	GetWindowRect(hDlg, &rc);
	MoveWindow(htv, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc)-pt.y, TRUE);
}

///////////////////////////////////////////////////////////////
LRESULT CALLBACK FolderDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	CFolderDlg* pfd = (CFolderDlg*)GetWindowLong(hDlg, GWL_USERDATA);
	int wmId, wmEvent;
	NMHDR* lpnmh;

	switch (message)
	{
	case WM_INITDIALOG:
		//DialogBoxParamœnꂽCFolderDlg̃CX^XUSERDATAɊi[
		SetWindowLong(hDlg, GWL_USERDATA, lParam);
		pfd = (CFolderDlg*)lParam;
		//
		pfd->OnInitDialog(hDlg);
		return TRUE;

	case WM_SIZE:
		pfd->OnSize(hDlg);
		break;

	case WM_COMMAND:
		wmId    = LOWORD(wParam); 
		wmEvent = HIWORD(wParam); 
		switch (wmId)
		{
		case IDOK:
			return pfd->OnOK(hDlg);

		case IDCANCEL:
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;

		case ID_CREATE_FOLDER:
			pfd->CreateNewFolder(hDlg);
			return TRUE;

		case ID_RENAME_FOLDER:
			pfd->OnRenameFolder(hDlg);
			return TRUE;

		default:
			break;
		}
		break;

	case WM_NOTIFY:
		lpnmh = (NMHDR*)lParam;
		switch (lpnmh->code)
		{
		case TVN_ITEMEXPANDING:
			pfd->OnItemExpanding((NMTREEVIEW*)lpnmh);
			return TRUE;

		case TVN_ITEMEXPANDED:
			pfd->OnItemExpanded((NMTREEVIEW*)lpnmh);
			return TRUE;

		case GN_CONTEXTMENU:
			if (pfd->m_bPressAndHoldCorrect)
				pfd->m_bPressAndHoldCorrect = FALSE;
			else
			{
				if (TreeView_GetSelection(GetDlgItem(hDlg, IDC_TREE_FOLDER)))
				{
					NMRGINFO* lpnmri = (NMRGINFO*)lParam;
					HMENU hMenu = GetSubMenu(g_MainWnd.m_ListView.m_hMenuPopup, ID_POPUP_FOLDERDLG);
					TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN, lpnmri->ptAction.x, lpnmri->ptAction.y, 0, hDlg, NULL);
				}
			}
			return TRUE;

		default:
			break;
		}
		break;

	case WM_CTLCOLORSTATIC:
		return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);

	default:
		break;
	}

    return FALSE;
}

///////////////////////////////////////////////////////////////
int CFolderDlg::ShowFolderDlg(LPCTSTR szTitle, LPTSTR szPath, int nSize)
{
	m_lpszTitle = szTitle;
	m_lpszPath = szPath;
	m_nSize = nSize;
	m_bSelectFile = FALSE;

	int nRet =  DialogBoxParam(g_hInst, (LPCTSTR)IDD_FOLDER_DLG, g_MainWnd.m_hWnd, (DLGPROC)FolderDlgProc, LPARAM(this));
	return nRet;
}

///////////////////////////////////////////////////////////////
int CFolderDlg::ShowFileDlg(LPCTSTR szTitle, LPTSTR szPath, int nSize, LPCTSTR szWildcard)
{
	m_lpszTitle = szTitle;
	m_lpszPath = szPath;
	m_nSize = nSize;
	m_bSelectFile = TRUE;
	m_lpszWildcard = szWildcard;

	int nRet =  DialogBoxParam(g_hInst, (LPCTSTR)IDD_FOLDER_DLG, g_MainWnd.m_hWnd, (DLGPROC)FolderDlgProc, LPARAM(this));
	return nRet;
}

///////////////////////////////////////////////////////////////
LRESULT CALLBACK RenameDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	CFolderDlg* pfd = (CFolderDlg*)GetWindowLong(hDlg, GWL_USERDATA);
	int wmId, wmEvent;

	switch (message)
	{
	case WM_INITDIALOG:
		//DialogBoxParamœnꂽCFolderDlg̃CX^XUSERDATAɊi[
		SetWindowLong(hDlg, GWL_USERDATA, lParam);
		pfd = (CFolderDlg*)lParam;
		//
		CenterWindow(hDlg);
		SetWindowText(GetDlgItem(hDlg, IDC_EDIT_OLDNAME), pfd->m_lpszName);
		SetWindowText(GetDlgItem(hDlg, IDC_EDIT_NEWNAME), pfd->m_lpszName);
		SetFocus(GetDlgItem(hDlg, IDC_EDIT_NEWNAME));
		SendMessage(GetDlgItem(hDlg, IDC_EDIT_NEWNAME), EM_SETSEL, 0, -1);
		return FALSE;

	case WM_COMMAND:
		wmId    = LOWORD(wParam); 
		wmEvent = HIWORD(wParam); 
		// j[ڂ𕪗ޕʂɋ؂܂:
		switch (wmId)
		{
		case IDOK :
			GetWindowText(GetDlgItem(hDlg, IDC_EDIT_NEWNAME), pfd->m_lpszName, MAX_PATH);
			EndDialog(hDlg, IDOK);
			return TRUE;

		case IDCANCEL:
			EndDialog(hDlg, IDCANCEL);
			return TRUE;

		default:
			break;
		}
		break;
	case WM_CLOSE:
		EndDialog(hDlg, IDCANCEL);
		return TRUE;

	case WM_PAINT:
		return DefDlgPaintProc(hDlg, wParam, lParam);

	case WM_CTLCOLORSTATIC:
		return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);

	default:
		break;
	}
    return FALSE;
}
///////////////////////////////////////////////////////////////
void CFolderDlg::OnRenameFolder(HWND hDlg)
{
	HWND hTV = GetDlgItem(hDlg, IDC_TREE_FOLDER);
	TCHAR szOldName[MAX_PATH] = _T("");
	TCHAR szNewName[MAX_PATH] = _T("");
	m_lpszName = szNewName;

	HTREEITEM hSelItem = TreeView_GetSelection(hTV);
	TVITEM tvi;
	tvi.mask = TVIF_TEXT | TVIF_HANDLE;
	tvi.pszText = szOldName;
	tvi.cchTextMax = MAX_PATH;
	tvi.hItem = hSelItem;
	TreeView_GetItem(hTV, &tvi);
	_tcscpy(szNewName, szOldName);
	if (_tcscmp(m_lpszName, GetRootName()) != 0)
	{
		if (DialogBoxParam(g_hInst, (LPCTSTR)IDD_RENAME_DLG, hDlg, (DLGPROC)RenameDlgProc, LPARAM(this)) == IDOK)
		{
			if (_tcscmp(szOldName, szNewName) != 0)
			{
				//O̕ύX
				TCHAR szName[MAX_PATH] = _T("");
				TCHAR szPath[MAX_PATH] = _T("");
				TCHAR szTemp[MAX_PATH] = _T("");
				HTREEITEM hTreeItem = TreeView_GetParent(hTV, hSelItem);
				TVITEM tvi;
				tvi.mask = TVIF_TEXT | TVIF_HANDLE;
				tvi.pszText = szName;
				tvi.cchTextMax = MAX_PATH;
				while (hTreeItem)
				{
					tvi.hItem = hTreeItem;
					TreeView_GetItem(hTV, &tvi);
					if (_tcscmp(szName, GetRootName()) != 0)
						_stprintf(szTemp, _T("%s\\%s"), szName, szPath);
					else
						_stprintf(szTemp, _T("\\%s"), szPath);
					_tcscpy(szPath, szTemp);
					hTreeItem = TreeView_GetParent(hTV, hTreeItem);
				}
				_tcscpy(szName, szOldName);
				_stprintf(szOldName, _T("%s%s"), szPath, szName);
				_tcscpy(szName, szNewName);
				_stprintf(szNewName, _T("%s%s"), szPath, szName);
				if (MoveFile(szOldName, szNewName))
				{
					TVITEM tvi;
					tvi.mask = TVIF_TEXT | TVIF_HANDLE;
					tvi.pszText = szName;
					tvi.cchTextMax = MAX_PATH;
					tvi.hItem = hSelItem;
					TreeView_SetItem(hTV, &tvi);
					m_bRefresh = TRUE;
				}
				else
					MessageBox(hDlg, GetResourceString(IDS_MSG_CANNOTCHANGENAME1), NULL, MB_OK|MB_ICONSTOP);
			}
		}
		SipShowIM(SIPF_OFF);
	}
	else
	{
		_tcscat(m_lpszName, GetResourceString(IDS_FMT_RENAME));
		MessageBox(hDlg, m_lpszName, NULL, MB_OK|MB_ICONEXCLAMATION);
	}
	SetFocus(hTV);
}

///////////////////////////////////////////////////////////////
// -- Ex.Q --
// c[ r[̍ڂ̐΃pX߂
void CFolderDlg::GetTree(HWND hwndTV, HTREEITEM hItem, LPTSTR pszKey)
{
	TCHAR szName[MAX_PATH];

    TV_ITEM tvi;
    memset (&tvi, 0, sizeof (tvi));

	// e擾
    HTREEITEM hParent;
	hParent = TreeView_GetParent (hwndTV, hItem);
    if (hParent)
	{ 
		// ڂ̐e̐eEEE擾
		GetTree(hwndTV, hParent, pszKey);

		// ڂ̖O擾
		tvi.mask       = TVIF_TEXT;
		tvi.hItem      = hItem;
		tvi.pszText    = szName;
		tvi.cchTextMax = MAX_PATH;
		TreeView_GetItem(hwndTV, &tvi);

		// [głȂ΁
		if (_tcscmp(pszKey, GetRootName()) != 0)
			lstrcat (pszKey, TEXT("\\"));
		else
			lstrcpy (pszKey, TEXT("\\"));

		// ẽpXɍ̃tH_ǉ
		lstrcat (pszKey, szName);
	}
	else
	{
        // ڂ̖O擾
		lstrcpy(pszKey, _T(""));
        szName[0]      = _T('\0');
        tvi.mask       = TVIF_TEXT | TVIF_PARAM;
        tvi.hItem      = hItem;
        tvi.pszText    = szName;
        tvi.cchTextMax = MAX_PATH;
		TreeView_GetItem(hwndTV, &tvi);
    }
}

///////////////////////////////////////////////////////////////
// CountChildrenFolder - L[̃TuL[(tH_)̐𒲂ׂ
//
DWORD CFolderDlg::CountChildrenFolder(LPTSTR pszPath, LPTSTR pszKey)
{
	TCHAR szName[MAX_PATH];
	HANDLE ff;
	WIN32_FIND_DATA wfd;
    DWORD dwCnt = 0;

	//tH_
	wsprintf(szName, _T("%s\\%s\\*.*"), pszPath, pszKey);
	ff = FindFirstFile(szName, &wfd);
	if (ff != INVALID_HANDLE_VALUE)
	{
		do{
			if (wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
				dwCnt++;
		}while (FindNextFile(ff, &wfd));
		FindClose(ff);
    }

	return dwCnt;
}

///////////////////////////////////////////////////////////////
// CountChildrenFile - L[̃TuL[(t@C)̐𒲂ׂ(ċA)
//
DWORD CFolderDlg::CountChildrenFile(LPTSTR pszTargetPath, LPTSTR pszTargetKey)
{
	TCHAR szName[MAX_PATH];
	TCHAR szPath[MAX_PATH];
	HANDLE ff;
	WIN32_FIND_DATA wfd;
    DWORD dwCnt = 0;

	//tH_
	if (_tcslen(pszTargetPath))
		wsprintf(szPath, _T("%s\\%s"), pszTargetPath, pszTargetKey);
	else
		_tcscpy(szPath, pszTargetKey);
	_tcscpy(szName, szPath);
	_tcscat(szName, _T("\\*.*"));
	ff = FindFirstFile(szName, &wfd);
	if (ff != INVALID_HANDLE_VALUE)
	{
		do{
			if (wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
				dwCnt += CountChildrenFile(szPath, wfd.cFileName);
		}while (FindNextFile(ff, &wfd));
		FindClose(ff);
    }
	//t@C(ChJ[hΉ)
	for (LPTSTR lpszTemp = m_lpszWildcard? m_lpszWildcard: _T("*.*"); _tcslen(lpszTemp); )
	{
		TCHAR szWildcard[MAX_PATH];
		LPTSTR lpszSep = _tcschr(lpszTemp, _T(';'));
		ZeroMemory(szWildcard, sizeof(szWildcard));
		if (lpszSep)
		{
			_tcsncpy(szWildcard, lpszTemp, (lpszSep - lpszTemp));
			lpszTemp = lpszSep + 1;
		}
		else
		{
			_tcscpy(szWildcard, lpszTemp);
			lpszTemp = _tcsrchr(lpszTemp, _T('\0'));
		}
		_tcscat(szPath, _T("\\"));
		_tcscat(szPath, szWildcard);
		ff = FindFirstFile(szPath, &wfd);
		if (ff != INVALID_HANDLE_VALUE)
		{
			do{
				if (!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
					dwCnt++;
			}while (FindNextFile(ff, &wfd));
			FindClose(ff);
		}
	}

	return dwCnt;
}

///////////////////////////////////////////////////////////////
// EnumChildren - L[̃TuL[񋓂
DWORD CFolderDlg::EnumChildren(HWND hwndTV, HTREEITEM hParent, LPTSTR pszPath)
{
    DWORD nChild;
	HANDLE ff;
	WIN32_FIND_DATA wfd;
	TCHAR szName[MAX_PATH];
	TVINSERTSTRUCT tvis;
	DWORD dwCnt = 0;

	if (m_bSelectFile)
	{
		//tH_
		wsprintf(szName, _T("%s\\*.*"), pszPath);
		ff = FindFirstFile(szName, &wfd);
		if (ff != INVALID_HANDLE_VALUE)
		{
			do{
				if (_tcsicmp(wfd.cFileName, _T("Recycled")) != 0 && (wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
				{
					// ʂɊYt@C邩
					if (CountChildrenFile(pszPath, wfd.cFileName))
					{
						// c[ r[ Rg[ɃL[}
						tvis.hParent      = hParent;
						tvis.hInsertAfter = TVI_SORT;
						tvis.item.mask    = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN;
						tvis.item.pszText = wfd.cFileName;
						tvis.item.cChildren = 1;

						if (wfd.dwFileAttributes & FILE_ATTRIBUTE_TEMPORARY)
						{
							tvis.item.iImage = 3;
							tvis.item.iSelectedImage = 3;
						}
						else if (_tcsicmp(wfd.cFileName, _T("My Documents")) == 0)
						{
							tvis.item.iImage = 4;
							tvis.item.iSelectedImage = 4;
						}
						else
						{
							tvis.item.iImage = 1;
							tvis.item.iSelectedImage = 2;
						}
						TreeView_InsertItem(hwndTV, &tvis);
						dwCnt++;
					}
				}
			}while (FindNextFile(ff, &wfd));
			FindClose(ff);
		}
		//t@C(ChJ[hΉ)
		for (LPTSTR lpszTemp = m_lpszWildcard? m_lpszWildcard: _T("*.*"); _tcslen(lpszTemp); )
		{
			TCHAR szWildcard[MAX_PATH];
			LPTSTR lpszSep = _tcschr(lpszTemp, _T(';'));
			ZeroMemory(szWildcard, sizeof(szWildcard));
			if (lpszSep)
			{
				_tcsncpy(szWildcard, lpszTemp, (lpszSep - lpszTemp));
				lpszTemp = lpszSep + 1;
			}
			else
			{
				_tcscpy(szWildcard, lpszTemp);
				lpszTemp = _tcsrchr(lpszTemp, _T('\0'));
			}
			wsprintf(szName, _T("%s\\%s"), pszPath, szWildcard);
			ff = FindFirstFile(szName, &wfd);
			if (ff != INVALID_HANDLE_VALUE)
			{
				do{
					if (!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
					{
						// c[ r[ Rg[ɃL[}
						tvis.hParent      = hParent;
						tvis.hInsertAfter = TVI_SORT;
						tvis.item.mask    = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN;
						tvis.item.pszText = wfd.cFileName;
						tvis.item.cChildren = 0;
						tvis.item.iImage = 5;
						tvis.item.iSelectedImage = 5;
						TreeView_InsertItem(hwndTV, &tvis);
						dwCnt++;
					}
				}while (FindNextFile(ff, &wfd));
				FindClose(ff);
			}
		}
	}
	else
	{
		//tH_
		wsprintf(szName, _T("%s\\*.*"), pszPath);
		ff = FindFirstFile(szName, &wfd);
		if (ff != INVALID_HANDLE_VALUE)
		{
			do{
				if (_tcsicmp(wfd.cFileName, _T("Recycled")) != 0 && (wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
				{
					// ʂ̃fBNg邩
					nChild = CountChildrenFolder(pszPath, wfd.cFileName);

					// c[ r[ Rg[ɃL[}
					tvis.hParent      = hParent;
					tvis.hInsertAfter = TVI_SORT;
					tvis.item.mask    = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN;
					tvis.item.pszText = wfd.cFileName;
					tvis.item.cChildren = (nChild? 1: 0);

					if (wfd.dwFileAttributes & FILE_ATTRIBUTE_TEMPORARY)
					{
						tvis.item.iImage = 3;
						tvis.item.iSelectedImage = 3;
					}
					else if (_tcsicmp(wfd.cFileName, _T("My Documents")) == 0)
					{
						tvis.item.iImage = 4;
						tvis.item.iSelectedImage = 4;
					}
					else
					{
						tvis.item.iImage = 1;
						tvis.item.iSelectedImage = 2;
					}
					TreeView_InsertItem(hwndTV, &tvis);
					dwCnt++;
				}
			}while (FindNextFile(ff, &wfd));
			FindClose(ff);
		}
	}
    if (dwCnt == 0)
	{
		// TuL[Ȃꍇ̓L[̂폜
		TreeView_DeleteItem(hwndTV, hParent);
	}
	else
	{
		// \[g
		TreeView_SortChildren(hwndTV, hParent, 0);
	}

	return dwCnt;
}

///////////////////////////////////////////////////////////////
void CFolderDlg::OnItemExpanded(NMTREEVIEW* lpnmtv)
{
	// Ƀu`WJƂɉ߂ė񋓂̂ŃTuL[폜
	if (lpnmtv->action == TVE_COLLAPSE)
	{
		HTREEITEM hChild;
		HTREEITEM hNext;

		hChild = TreeView_GetChild(lpnmtv->hdr.hwndFrom, lpnmtv->itemNew.hItem);
		while (hChild)
		{
			hNext = TreeView_GetNextItem(lpnmtv->hdr.hwndFrom, hChild, TVGN_NEXT);
			TreeView_DeleteItem(lpnmtv->hdr.hwndFrom, hChild);
			hChild = hNext;
		}
	}
}

///////////////////////////////////////////////////////////////
void CFolderDlg::OnItemExpanding(NMTREEVIEW* lpnmtv)
{
	if (lpnmtv->action == TVE_EXPAND)
	{
		TCHAR szKey[MAX_PATH];
		//tH_擾
		GetTree(lpnmtv->hdr.hwndFrom, lpnmtv->itemNew.hItem, szKey);
		//qc[񋓂
		EnumChildren(lpnmtv->hdr.hwndFrom, lpnmtv->itemNew.hItem, szKey);
	}
}

void CFolderDlg::SetCurrentFolder(HWND hwndTV, LPCTSTR lpszPath)
{
	LPCTSTR lpszStart = _tcschr(lpszPath, _T('\\'));
	HTREEITEM hSelectItem = TreeView_GetRoot(hwndTV);

	HTREEITEM hParent = hSelectItem;
	TreeView_Expand(hwndTV, hParent, TVE_EXPAND);

	while (lpszStart)
	{
		TCHAR szName[MAX_PATH] = _T("");
		LPCTSTR lpszEnd = _tcschr(lpszStart + 1, _T('\\'));
		if (lpszEnd)
		{
			int len = lpszEnd - (lpszStart + 1);
			_tcsncpy(szName, ++lpszStart, len);
			szName[len] = 0;
		}
		else
			_tcscpy(szName, ++lpszStart);

		HTREEITEM hChild = TreeView_GetChild(hwndTV, hParent);
		while (hChild)
		{
			TCHAR szChildName[MAX_PATH] = _T("");
			TVITEM tvi;
			tvi.mask = TVIF_TEXT | TVIF_HANDLE;
			tvi.pszText = szChildName;
			tvi.cchTextMax = MAX_PATH;
			tvi.hItem = hChild;
			TreeView_GetItem(hwndTV, &tvi);
			if (_tcscmp(szName, szChildName) == 0)
			{
				hSelectItem = hParent = hChild;
				TreeView_Expand(hwndTV, hParent, TVE_EXPAND);
				break;
			}

			hChild = TreeView_GetNextItem(hwndTV, hChild, TVGN_NEXT);
		}
		if (!hChild) break;

		lpszStart = _tcschr(lpszStart, _T('\\'));
	}

	TreeView_SelectItem(hwndTV, hSelectItem);
}