///////////////////////////////////////////////////////////////
//FileSearch.cpp
//t@Cݒ/t@C - CFileSearch

///////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "FileSearch.h"
#include "FolderDlgPPC.h"

///////////////////////////////////////////////////////////////
//񌟍(ChJ[ĥݑΉ)
BOOL StrStr(LPTSTR lpszData, LPTSTR lpszWord, BOOL bUpr)
{
	LPTSTR lpszDataPos = lpszData;
	LPTSTR lpszWordPos = lpszWord;

	TCHAR szDataTemp[MAX_PATH] = _T("");
	TCHAR szWordTemp[MAX_PATH] = _T("");

	//qʖ
	if (!bUpr)
	{
		//啶ɕϊ
		_tcscpy(szDataTemp, lpszDataPos);
		_tcsupr(szDataTemp);
		lpszDataPos = szDataTemp;
	}

	//Jn(ȂȂ܂)
	while (*lpszWordPos)
	{
		if (*lpszWordPos == _T('*'))
		{
			lpszWordPos++;
		}
		else if (!(*lpszDataPos))
		{
			break;
		}
		else
		{
			if (*lpszWordPos == _T('?'))
			{
				lpszWordPos++;
				lpszDataPos++;
			}
			else
			{
				//̏I[mF
				LPTSTR lpszEnd = _tcschr(lpszWordPos, _T('*'));
				if (!lpszEnd)
					lpszEnd = _tcschr(lpszWordPos, _T('?'));

				//`FbN쐬
				TCHAR szBuf[MAX_PATH];
				int nLen = (lpszEnd? lpszEnd-lpszWordPos: _tcslen(lpszWordPos));
				_tcsncpy(szBuf, lpszWordPos, nLen);
				szBuf[nLen] = _T('\0');
			
				//`FbN
				LPTSTR lpszTemp = _tcsstr(lpszDataPos, szBuf);
				
				//Ɏs(sv)
				if (!lpszTemp) return FALSE;

				//`FbN̏ꍇ(㑱)
				lpszWordPos += nLen;
				lpszDataPos = lpszTemp + nLen;
			}
		}

	}

	if (*lpszWordPos) return FALSE;

	return TRUE;
}

///////////////////////////////////////////////////////////////
//t@C`FbN
BOOL TextCheck(LPTSTR lpszPath, LPTSTR lpszName, DWORD dwSize, LPTSTR lpszWord, BOOL bUpr)
{
	TCHAR szPath[MAX_PATH];

	//pX쐬
	if (_tcslen(lpszPath))
		_stprintf(szPath, _T("%s\\%s"), lpszPath, lpszName);
	else
		_stprintf(szPath, _T("\\%s"), lpszName);

	//t@CI[v
	HANDLE hFile = CreateFile(szPath, GENERIC_READ, 0, NULL,
				OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	
	//I[vɎs
	if (INVALID_HANDLE_VALUE == hFile) return FALSE;

	//obt@쐬
	int nWordLen = _tcslen(lpszWord)*2+1;
	char *szWordBuf1 = new char[nWordLen];
	char *szWordBuf2 = new char[nWordLen];
	
	//ϊ(Unicode->S-JIS)
#ifdef UNICODE
	memset(szWordBuf1, 0, nWordLen);
	memset(szWordBuf2, 0, nWordLen);
	wcstombs(szWordBuf1, lpszWord, nWordLen);
	wcstombs(szWordBuf2, lpszWord, nWordLen);
#else
	_tcscpy(szWordBuf1, lpszWord);
	_tcscpy(szWordBuf2, lpszWord);
#endif

	//啶ʖ
	if (!bUpr)
	{
		_strupr(szWordBuf1);
		_strlwr(szWordBuf2);
	}

	//t@C̓ǂݍ݁`FbN
	DWORD dwLen=0;
	char *pchk1 = szWordBuf1;
	char *pchk2 = szWordBuf2;
	BOOL bChk = FALSE;
	while (!bChk)
	{
		DWORD dwRead;
		char szDataBuf[4096];
		memset(szDataBuf, 0, sizeof(szDataBuf));

		//t@C̓ǂݍ
		dwRead = 0;
		if (!ReadFile(hFile, &szDataBuf, sizeof(szDataBuf), &dwRead, 0) || !dwRead)
			break;

		//obt@e1oCgÂ`FbN
		for (DWORD i=0; i<dwRead && !bChk; i++)
		{
			//擪1oCĝݔr
			if (!bUpr)
			{
				if ((*pchk1) != szDataBuf[i] && (*pchk2) != szDataBuf[i])
				   continue;
			}
			else
			{
				if ((*pchk1) != szDataBuf[i])
					continue;
			}
			
			//`FbN郌OXZo
			DWORD nLen = strlen(pchk1);
			if (nLen > (dwRead-i))
				nLen = dwRead-i;
				
			//召ʖ
			if (!bUpr)
			{
				//`FbN
				for (DWORD j=0; j<nLen; j++)
				{
					bChk = TRUE;
					//召ꂩvȂꍇ
					if ((*pchk1) != szDataBuf[i+j] && (*pchk2) != szDataBuf[i+j])
					{
						pchk1 = szWordBuf1;
						pchk2 = szWordBuf2;
						bChk = FALSE;
						break;
					}
					pchk1++;
					pchk2++;

				}
			}
			//召ʗL
			else
			{
				//`FbN
				if (memcmp(pchk1, &szDataBuf[i], nLen) == 0)
				{
					pchk1 += nLen;
					bChk = TRUE;
					break;
				}
				else
					pchk1 = szWordBuf1;
			}

		}

		//JE^XV
		dwLen += dwRead;
	
	}

	//obt@폜
	delete[] szWordBuf1;
	delete[] szWordBuf2;

	//t@CN[Y
	CloseHandle(hFile);

	return bChk;
}

///////////////////////////////////////////////////////////////
//EBhEX^Cݒ
LONG SetWindowStyle(HWND hWnd, LONG style, BOOL Add)
{
	LONG				src;
	LONG				n;

	src = GetWindowLong(hWnd, GWL_STYLE);
	if (Add)
	{
		n = src | style;
	}
	else
	{
		n = src & ~style;
	}
	SetWindowLong(hWnd, GWL_STYLE, n);

	return n;
}

///////////////////////////////////////////////////////////////
//EBhEvV[W
LRESULT CALLBACK FileSearchProc(
		HWND hDlg,
		UINT message,
		WPARAM wParam,
		LPARAM lParam)
{
	CFileSearch* pfsch = (CFileSearch*)GetWindowLong(hDlg, GWL_USERDATA);
	int wmId, wmEvent;

	switch (message)
	{
	case WM_INITDIALOG:
		//DialogBoxParamœnꂽCAssociatioñCX^XUSERDATAɊi[
		SetWindowLong(hDlg, GWL_USERDATA, lParam);
		pfsch = (CFileSearch*)lParam;
		//
		pfsch->m_hWnd = hDlg;
		pfsch->OnInit();
		break;

	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		switch (wmId)
		{
		case IDC_CHK_DATE:
			//t`FbN{^
			pfsch->OnChkDateChange();
			break;

		case IDC_CHK_SIZE:
			//TCY`FbN{^
			pfsch->OnChkSizeChange();
			break;

		case IDC_BTN_BROWSE:
			//Qƃ{^
			OnDlgPathBrowseFolder(hDlg, IDC_EDIT_PATH, IDS_TITLE_FILESEARCH);
			break;

		case IDOK:
			//OK{^
			ShowWindow(hDlg, SW_HIDE);
			pfsch->OnOK();
			break;

		case IDC_COMB_DATE:
			//tʕύX
			pfsch->OnCombDateChange();
			break;

		case IDC_COMB_SIZE:
			//TCYʕύX
			pfsch->OnCombSizeChange();
			break;

		case IDCANCEL:
			//LZ{^
			EndDialog(hDlg, (INT)FALSE);
			return TRUE;

		default:
			break;
		}
		break;

	case WM_DLGCLOSE:
		SipShowIM(SIPF_OFF);	//SIPN[Y
		EndDialog(hDlg, pfsch->OnFileSerch());
		break;

	case WM_PAINT:
		return DefDlgPaintProc(hDlg, wParam, lParam);

	case WM_CTLCOLORSTATIC:
		return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);

	default:
		break;
	}

	return FALSE;
}

///////////////////////////////////////////////////////////////
//RXgN^
CFileSearch::CFileSearch(HWND hWnd, HINSTANCE hInst, LPTSTR lpszPath)
{
	//p[^̕ۑ
	m_hparWnd = hWnd;
	m_hInst = hInst;
	if (lpszPath)
		_tcscpy(m_szCurrent, lpszPath);
	else
		m_szCurrent[0] = _T('\0');

	//Rg[̏
	InitCommonControls();

	//twRg[̏
	INITCOMMONCONTROLSEX ctl;
	ctl.dwSize = sizeof(ctl);
	ctl.dwICC = ICC_DATE_CLASSES;
	InitCommonControlsEx(&ctl);

	//oϐ̏
	m_ListView = &g_MainWnd.m_ListView;
}

///////////////////////////////////////////////////////////////
//fXgN^
CFileSearch::~CFileSearch()
{
}

///////////////////////////////////////////////////////////////
//EBhEI[v
int CFileSearch::Open()
{
	//EBhE쐬
	int rtn =  DialogBoxParam(m_hInst, (LPCTSTR)IDD_SEARCH_DLG,
				m_hparWnd, (DLGPROC)FileSearchProc, LPARAM(this));

	//SIPN[Y
	SipShowIM(SIPF_OFF);

	return rtn;
}

///////////////////////////////////////////////////////////////
void CFileSearch::SetEditPath(LPTSTR lpszPath)
{
	//pX̏ꍇA[gݒ肷
	if (!_tcslen(lpszPath) || IsSearchFolder(lpszPath))
	{
		SetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_PATH), GetRootName());
	}
	else
	{
		_tcscpy(m_szCurrent, lpszPath);
		SetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_PATH), lpszPath);
	}
}

///////////////////////////////////////////////////////////////
void CFileSearch::SetDateList()
{
	HWND hCB = GetDlgItem(m_hWnd, IDC_COMB_DATE);
	if (hCB)
	{
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)_T(""));
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)GetResourceString(IDS_LIST_DATETYPE_AREA));
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)GetResourceString(IDS_LIST_DATETYPE_BEF));
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)GetResourceString(IDS_LIST_DATETYPE_AFT));
	}
}

///////////////////////////////////////////////////////////////
void CFileSearch::SetSizeList()
{
	HWND hCB = GetDlgItem(m_hWnd, IDC_COMB_SIZE);
	if (hCB)
	{
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)_T(""));
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)GetResourceString(IDS_LIST_SIZETYPE_LOW));
		SendMessage(hCB, CB_ADDSTRING, 0, (LPARAM)GetResourceString(IDS_LIST_SIZETYPE_HIGH));
	}
}

///////////////////////////////////////////////////////////////
//t@C`FbN
BOOL CFileSearch::FileCheck(WIN32_FIND_DATA *lpFind, SEARCHINFO *lpSearch, LPTSTR lpszPath)
{
	//t@C`FbN
	if (_tcslen(lpSearch->szName))
	{
		if (!StrStr(lpFind->cFileName, lpSearch->szName, FALSE))
		{
			return FALSE;
		}
	}

	//fBNg̏ꍇ͂܂
	if (lpFind->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
	{
		//t@CȊȌݒ肳ĂȂꍇ̂
		if (_tcslen(lpSearch->szName) &&
		   lpSearch->nDateType == DATE_TYPE_NON &&
		   lpSearch->nSizeType == SIZE_TYPE_NON &&
		   !(_tcslen(lpSearch->szText)))
			return TRUE;
		else
			return FALSE;
	}

	//t`FbN
	if (lpSearch->nDateType != DATE_TYPE_NON)
	{	
		//ϊ
		TCHAR szDate[8+1];
		SYSTEMTIME sys;
		FILETIME ft;
		
		ft = lpFind->ftLastWriteTime;
		FileTimeToLocalFileTime(&ft, &ft);
		FileTimeToSystemTime(&ft, &sys);
		_stprintf(szDate, _T("%04d%02d%02d"), sys.wYear, sys.wMonth, sys.wDay);

		switch (lpSearch->nDateType)
		{
		case DATE_TYPE_CMP:
			//v
			if (_tcscmp(lpSearch->szFromDate, szDate) != 0)
				return FALSE;
			break;

		case DATE_TYPE_AREA:
			//v(͈)
			if (_tcscmp(lpSearch->szFromDate, szDate)>0)
				return FALSE;
			if (_tcscmp(lpSearch->szToDate, szDate)<0)
				return FALSE;
			break;

		case DATE_TYPE_BEF:
			//ȑO
			if (_tcscmp(lpSearch->szFromDate, szDate)<0)
				return FALSE;
			break;

		case DATE_TYPE_AFT:
			//ȍ~
			if (_tcscmp(lpSearch->szFromDate, szDate)>0)
				return FALSE;
			break;

		default:
			break;
		}
	}

	//TCY`FbN
	if (lpSearch->nSizeType != SIZE_TYPE_NON)
	{
		double fSize;
		fSize = (double)(lpFind->nFileSizeLow/1024);

		switch (lpSearch->nSizeType)
		{
		case SIZE_TYPE_CMP:
			//v
			if (lpSearch->dwSize != fSize)
				return FALSE;
			break;

		case SIZE_TYPE_LOW:
			//
			if (lpSearch->dwSize > fSize)
				return FALSE;
			break;

		case SIZE_TYPE_HIGH:
			//
			if (lpSearch->dwSize < fSize)
				return FALSE;
			break;

		default:
			break;
		}
	}

	//eLXg`FbN
	if (_tcslen(lpSearch->szText))
	{
		if (!TextCheck(lpszPath, lpFind->cFileName, lpFind->nFileSizeLow,
				lpSearch->szText, lpSearch->bTextUpr))
			return FALSE;
	}
		
	return TRUE;
}

///////////////////////////////////////////////////////////////
//t@C
void CFileSearch::FileSearch(LPTSTR lpszPath)
{
	TCHAR szPath[MAX_PATH];
	LPTSTR lpszCurrent;

	//JgpXݒ
	if (!lpszPath)
	{
		lpszCurrent = m_lpSearch.szCurrent;
	}
	else
		lpszCurrent = lpszPath;

	//pX쐬
	if (_tcslen(lpszCurrent))
		_stprintf(szPath, _T("%s\\*.*"), lpszCurrent);
	else
		_stprintf(szPath, _T("\\*.*"));

	//t@C̓ǂݍ
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szPath, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do{
			//`FbNOK̏ꍇ
			if (FileCheck(&finddata, &m_lpSearch, lpszCurrent))
			{
				//ACeXgɓo^
				if (finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
				{
					//Xgǉ
					m_ListView->m_lpSearchData = 
						m_ListView->AddSearch(
							m_ListView->m_lpSearchData,
							lpszCurrent,
							finddata.cFileName,
							finddata.ftCreationTime,
							0,
							finddata.dwFileAttributes);
				}
				else
				{
					//Xgǉ
					m_ListView->m_lpSearchData = 
						m_ListView->AddSearch(
							m_ListView->m_lpSearchData,
							lpszCurrent,
							finddata.cFileName,
							finddata.ftLastWriteTime,
							finddata.nFileSizeLow,
							finddata.dwFileAttributes);
				}
			}

			//TufBNgfBNg̏ꍇ
			if (m_lpSearch.bSubFolder &&
			   finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
				TCHAR szTemp[MAX_PATH];
				if (_tcslen(lpszCurrent))
					_stprintf(szTemp, _T("%s\\%s"), lpszCurrent, finddata.cFileName);
				else
					_stprintf(szTemp, _T("\\%s"), finddata.cFileName);

				//ċNĂяo
				FileSearch(szTemp);
			}

			//Sleep(0);
		}while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}
}

///////////////////////////////////////////////////////////////
//EBhE
void CFileSearch::OnInit()
{
	SHINITDLGINFO shidi;
	shidi.dwMask = SHIDIM_FLAGS;
	shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIZEDLGFULLSCREEN;
	shidi.hDlg = m_hWnd;
	SHINITDIALOG(&shidi);

	//EBhE^Cg
	SetWindowText(m_hWnd, APP_MAINWND_TITLE);

	//EBhE
	if (!g_MainWnd.m_bIsSmartphone)	//Smartphone/Standard̏ꍇPPC2SPLIBɔĈŕsv
	{
		//j[o[ǉ
		SHMENUBARINFO mbi;
		memset(&mbi, 0, sizeof(SHMENUBARINFO));
		mbi.cbSize = sizeof(SHMENUBARINFO);
		mbi.hwndParent = m_hWnd;
		mbi.nToolBarId = IDR_FILESEARCH;
		mbi.hInstRes = g_hInst;
		mbi.nBmpId = 0;
		mbi.cBmpImages = 0;
		SHCreateMenuBar(&mbi);
	}

	//ꏊ
	SetEditPath(m_szCurrent);
	
	//tXgݒ
	SetDateList();

	//ti\/\
	OnChkDateChange();

	//TCYXgݒ
	SetSizeList();

	//TCYi\/\
	OnChkSizeChange();

	//TCYlݒ
	SetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_SIZE), _T("0"));

	//召ʂOFF
	SendMessage(GetDlgItem(m_hWnd, IDC_CHK_UPR), BM_SETCHECK, 0, 0);

	//TutH_ON
	SendMessage(GetDlgItem(m_hWnd, IDC_CHK_SUBFOLDER), BM_SETCHECK, 1, 0);

	//tH[JXݒ
	SetFocus(GetDlgItem(m_hWnd, IDC_EDIT_NAME));
}

///////////////////////////////////////////////////////////////
//t`FbN{bNX
void CFileSearch::OnChkDateChange()
{
	BOOL bChk = IsDlgButtonChecked(m_hWnd, IDC_CHK_DATE);

	for (int i=0; i<3; i++)
	{
		HWND hItemWnd;
		switch (i)
		{
		case 0:
			//t`FbN
			hItemWnd = GetDlgItem(m_hWnd, IDC_COMB_DATE);
			break;

		case 1:
			//Jnt
			hItemWnd = GetDlgItem(m_hWnd, IDC_DATE_FROM);
			break;

		case 2:
			//It
			//tʏ
			OnCombDateChange();
			hItemWnd = GetDlgItem(m_hWnd, IDC_DATE_TO);
			break;
		}
		EnableWindow(hItemWnd, bChk);
	}
}

///////////////////////////////////////////////////////////////
//TCY`FbN{bNX
void CFileSearch::OnChkSizeChange()
{
	BOOL bChk = IsDlgButtonChecked(m_hWnd, IDC_CHK_SIZE);

	for (int i=0; i<3; i++)
	{
		HWND hItemWnd;
		switch (i)
		{
		case 0:
			//t`FbN
			hItemWnd = GetDlgItem(m_hWnd, IDC_EDIT_SIZE);
			break;

		case 1:
			//Jnt
			hItemWnd = GetDlgItem(m_hWnd, IDC_COMB_SIZE);
			break;

		default:
			break;
		}
		EnableWindow(hItemWnd, bChk);
	}
}

///////////////////////////////////////////////////////////////
//tʕύX
void CFileSearch::OnCombDateChange()
{
	HWND hItemWnd = GetDlgItem(m_hWnd, IDC_DATE_TO);

	//tʎ擾
	int nIndex = SendMessage(GetDlgItem(m_hWnd, IDC_COMB_DATE),CB_GETCURSEL, 0, 0)+1;
	
	//͈͎w̏ꍇ
	if (nIndex != DATE_TYPE_AREA)
	{
		//It\
		ShowWindow(hItemWnd, SW_HIDE);
	}
	else
	{
		//It\
		ShowWindow(hItemWnd, SW_SHOW);
	}
}

///////////////////////////////////////////////////////////////
//TCYʕύX
void CFileSearch::OnCombSizeChange()
{
}

///////////////////////////////////////////////////////////////
//nj{^
void CFileSearch::OnOK()
{
	//EBhE\
	ShowWindow(m_hWnd, SW_HIDE);

	//I(Jn)bZ[WM
	SendMessage(m_hWnd, WM_DLGCLOSE, 0, 0);
}

///////////////////////////////////////////////////////////////
//Jn
int CFileSearch::OnFileSerch()
{
	//J[\ɂ
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	//Xg폜
	if (m_ListView->m_lpSearchData)
	{
		m_ListView->DeleteSearch(m_ListView->m_lpSearchData);
		m_ListView->m_lpSearchData = NULL;
	}
	
	memset(&m_lpSearch, 0, sizeof(m_lpSearch));

	//t@C
	GetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_NAME),
					m_lpSearch.szName, sizeof(m_lpSearch.szName));

	//啶/ϊ
	_tcsupr(m_lpSearch.szName);

	//eLXg
	GetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_TEXT),
					m_lpSearch.szText, sizeof(m_lpSearch.szText));

	//召
	m_lpSearch.bTextUpr = IsDlgButtonChecked(m_hWnd, IDC_CHK_UPR);

	//ꏊ
	GetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_PATH),
					m_lpSearch.szCurrent, sizeof(m_lpSearch.szCurrent));

	//fBNgLmF
	DWORD dwAttr = GetFileAttributes(m_lpSearch.szCurrent);
	if (!((dwAttr & FILE_ATTRIBUTE_DIRECTORY) && dwAttr != 0xFFFFFFFF))
	{
		//Ȃꍇ͋([g)
		m_lpSearch.szCurrent[0] = _T('\0');
	}
	if (!_tcscmp(m_lpSearch.szCurrent, _T("\\")))
		m_lpSearch.szCurrent[0] = _T('\0');
	
	//TutH_
	m_lpSearch.bSubFolder = IsDlgButtonChecked(m_hWnd, IDC_CHK_SUBFOLDER);

	//t
	m_lpSearch.nDateType = DATE_TYPE_NON;
	if (IsDlgButtonChecked(m_hWnd, IDC_CHK_DATE))
	{
		SYSTEMTIME sys;
		//t`FbN
		m_lpSearch.nDateType = 
			SendMessage(GetDlgItem(m_hWnd, IDC_COMB_DATE), CB_GETCURSEL, 0, 0)+1;
		if (!m_lpSearch.nDateType) m_lpSearch.nDateType = DATE_TYPE_CMP;

		//Jnt
		DateTime_GetSystemtime(GetDlgItem(m_hWnd, IDC_DATE_FROM), &sys);
		_stprintf(m_lpSearch.szFromDate, _T("%04d%02d%02d"), sys.wYear, sys.wMonth, sys.wDay);

		//It
		DateTime_GetSystemtime(GetDlgItem(m_hWnd, IDC_DATE_TO), &sys);
		_stprintf(m_lpSearch.szToDate, _T("%04d%02d%02d"), sys.wYear, sys.wMonth, sys.wDay);
	}
	
	//TCY
	m_lpSearch.nSizeType = SIZE_TYPE_NON;
	if (IsDlgButtonChecked(m_hWnd, IDC_CHK_SIZE))
	{
		//TCY`FbN
		m_lpSearch.nSizeType = 
			SendMessage(GetDlgItem(m_hWnd, IDC_COMB_SIZE), CB_GETCURSEL, 0, 0)+1;
		if (!m_lpSearch.nSizeType) m_lpSearch.nSizeType = SIZE_TYPE_CMP;
		
		//TCY
		TCHAR szBuf[16];
		GetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_SIZE), szBuf, sizeof(szBuf));
		m_lpSearch.dwSize = _wtoi(szBuf);
	}

	//s
	FileSearch();

	//J[\ɖ߂
	SetCursor(hCursor);

	return (INT)TRUE;
}
