///////////////////////////////////////////////////////////////
//ListSort.cpp
//t@C̃Xg\̃\[g֘A

///////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"

///////////////////////////////////////////////////////////////
int CALLBACK ListSortCompareFuncByName(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	LISTITEMCOMP* pList1 = (LISTITEMCOMP*)lParam1;
	LISTITEMCOMP* pList2 = (LISTITEMCOMP*)lParam2;
	BOOL bRaise = (BOOL)lParamSort;

	if (pList1->nItem < pList2->nItem)
		return -1;
	else if (pList1->nItem > pList2->nItem)
		return 1;
	else
		return bRaise? _tcsicmp(pList1->lpszName, pList2->lpszName): _tcsicmp(pList2->lpszName, pList1->lpszName);

	return 0;
}

///////////////////////////////////////////////////////////////
int CALLBACK ListSortCompareFuncByExt(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	LISTITEMCOMP* pList1 = (LISTITEMCOMP*)lParam1;
	LISTITEMCOMP* pList2 = (LISTITEMCOMP*)lParam2;
	BOOL bRaise = (BOOL)lParamSort;

	if (pList1->nItem < pList2->nItem)
		return -1;
	else if (pList1->nItem > pList2->nItem)
		return 1;
	else
	{
		if (pList1->nItem == LIST_ITEM_FILE)
		{
			LPCTSTR lpszExt1 = _tcsrchr(pList1->lpszName,_T('.'));
			LPCTSTR lpszExt2 = _tcsrchr(pList2->lpszName,_T('.'));
			if (lpszExt1 && lpszExt2)
			{
				if (bRaise)
				{
					int nRet = _tcsicmp(lpszExt1, lpszExt2);
					return nRet? nRet: _tcsicmp(pList1->lpszName, pList2->lpszName);
				}	
				else
				{
					int nRet = _tcsicmp(lpszExt2, lpszExt1);
					return nRet? nRet: _tcsicmp(pList2->lpszName, pList1->lpszName);
				}
			}
			else if (lpszExt1 == NULL)
				return bRaise? -1: 1;
			else
				return bRaise? 1: -1;
		}
		else
			return bRaise? _tcsicmp(pList1->lpszName, pList2->lpszName): _tcsicmp(pList2->lpszName, pList1->lpszName);
	}

	return 0;
}
///////////////////////////////////////////////////////////////
int CALLBACK ListSortCompareFuncBySize(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	LISTITEMCOMP* pList1 = (LISTITEMCOMP*)lParam1;
	LISTITEMCOMP* pList2 = (LISTITEMCOMP*)lParam2;
	BOOL bRaise = (BOOL)lParamSort;

	if (pList1->nItem < pList2->nItem)
		return -1;
	else if (pList1->nItem > pList2->nItem)
		return 1;
	else
	{
		if (pList1->nItem == LIST_ITEM_FILE)
		{
			if (bRaise)
			{
				if (pList1->dwSize < pList2->dwSize)
					return -1;
				else if (pList1->dwSize > pList2->dwSize)
					return 1;
				else
					return 0;
			}
			else
			{
				if (pList1->dwSize < pList2->dwSize)
					return 1;
				else if (pList1->dwSize > pList2->dwSize)
					return -1;
				else
					return 0;
			}
		}
		else
			return bRaise? _tcsicmp(pList1->lpszName, pList2->lpszName): _tcsicmp(pList2->lpszName, pList1->lpszName);
	}

	return 0;
}
///////////////////////////////////////////////////////////////
int CALLBACK ListSortCompareFuncByTime(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	LISTITEMCOMP* pList1 = (LISTITEMCOMP*)lParam1;
	LISTITEMCOMP* pList2 = (LISTITEMCOMP*)lParam2;
	BOOL bRaise = (BOOL)lParamSort;

	if (pList1->nItem < pList2->nItem)
		return -1;
	else if (pList1->nItem > pList2->nItem)
		return 1;
	else
		return bRaise? CompareFileTime(&pList1->ft, &pList2->ft): CompareFileTime(&pList2->ft, &pList1->ft);

	return 0;
}