//----------------------------------------------------------------------------
// wxHtmlListBox
// extracted from htmllbox.tex
//----------------------------------------------------------------------------
#include "stdafx.h"

Gura_BeginModule(wx)

Gura_DeclarePrivUserSymbol(OnLinkClicked);

//----------------------------------------------------------------------------
// Class derivation
//----------------------------------------------------------------------------
class wx_HtmlListBox: public wxHtmlListBox, public GuraObjectObserver {
private:
	Gura::Signal _sig;
	Object_wx_HtmlListBox *_pObj;
public:
	//inline wx_HtmlListBox(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size, long style, const wxString& name) : wxHtmlListBox(parent, id, pos, size, style, name), _sig(NULL), _pObj(NULL) {}
	//inline wx_HtmlListBox() : wxHtmlListBox(), _sig(NULL), _pObj(NULL) {}
	//virtual void OnLinkClicked(size_t n, const wxHtmlLinkInfo& link);
	~wx_HtmlListBox();
	inline void AssocWithGura(Gura::Signal &sig, Object_wx_HtmlListBox *pObj) {
		_sig = sig, _pObj = pObj;
	}
	// virtual function of GuraObjectObserver
	virtual void GuraObjectDeleted();
};

wx_HtmlListBox::~wx_HtmlListBox()
{
	if (_pObj != NULL) _pObj->InvalidateEntity();
}

void wx_HtmlListBox::GuraObjectDeleted()
{
	_pObj = NULL;
}

//----------------------------------------------------------------------------
// Gura interfaces for wxHtmlListBox
//----------------------------------------------------------------------------
Gura_DeclareFunction(HtmlListBox)
{
	SetMode(RSLTMODE_Normal, FLAG_Map);
#if 0
	SetClassToConstruct(Gura_UserClass(wx_HtmlListBox));
	DeclareArg(env, "parent", VTYPE_wx_Window, OCCUR_Once);
	DeclareArg(env, "id", VTYPE_number, OCCUR_ZeroOrOnce);
	DeclareArg(env, "pos", VTYPE_wx_Point, OCCUR_ZeroOrOnce);
	DeclareArg(env, "size", VTYPE_wx_Size, OCCUR_ZeroOrOnce);
	DeclareArg(env, "style", VTYPE_number, OCCUR_ZeroOrOnce);
	DeclareArg(env, "name", VTYPE_string, OCCUR_ZeroOrOnce);
	DeclareBlock(OCCUR_ZeroOrOnce);
#endif
}

Gura_ImplementFunction(HtmlListBox)
{
#if 0
	wxWindow *parent = Object_wx_Window::GetObject(args, 0)->GetEntity();
	wxWindowID id = wxID_ANY;
	if (args.IsValid(1)) id = static_cast<wxWindowID>(args.GetInt(1));
	wxPoint *pos = (wxPoint *)(&wxDefaultPosition);
	if (args.IsValid(2)) pos = Object_wx_Point::GetObject(args, 2)->GetEntity();
	wxSize *size = (wxSize *)(&wxDefaultSize);
	if (args.IsValid(3)) size = Object_wx_Size::GetObject(args, 3)->GetEntity();
	long style = 0;
	if (args.IsValid(4)) style = args.GetLong(4);
	wxString name = wxHtmlListBoxNameStr;
	if (args.IsValid(5)) name = wxString::FromUTF8(args.GetString(5));
	wx_HtmlListBox *pEntity = new wx_HtmlListBox(parent, id, *pos, *size, style, name);
	Object_wx_HtmlListBox *pObj = Object_wx_HtmlListBox::GetSelfObj(args);
	if (pObj == NULL) {
		pObj = new Object_wx_HtmlListBox(pEntity, pEntity, OwnerFalse);
		pEntity->AssocWithGura(sig, pObj);
		return ReturnValue(env, sig, args, Value(pObj));
	}
	pObj->SetEntity(pEntity, pEntity, OwnerFalse);
	pEntity->AssocWithGura(sig, pObj);
	return ReturnValue(env, sig, args, args.GetSelf());
#endif
	SetError_NotImplemented(sig);
	return Value::Null;
}

Gura_DeclareFunction(HtmlListBoxEmpty)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
#if 0
	SetClassToConstruct(Gura_UserClass(wx_HtmlListBox));
	DeclareBlock(OCCUR_ZeroOrOnce);
#endif
}

Gura_ImplementFunction(HtmlListBoxEmpty)
{
#if 0
	wx_HtmlListBox *pEntity = new wx_HtmlListBox();
	Object_wx_HtmlListBox *pObj = Object_wx_HtmlListBox::GetSelfObj(args);
	if (pObj == NULL) {
		pObj = new Object_wx_HtmlListBox(pEntity, pEntity, OwnerFalse);
		pEntity->AssocWithGura(sig, pObj);
		return ReturnValue(env, sig, args, Value(pObj));
	}
	pObj->SetEntity(pEntity, pEntity, OwnerFalse);
	pEntity->AssocWithGura(sig, pObj);
	return ReturnValue(env, sig, args, args.GetSelf());
#endif
	SetError_NotImplemented(sig);
	return Value::Null;
}

Gura_DeclareMethod(wx_HtmlListBox, Create)
{
	SetMode(RSLTMODE_Normal, FLAG_Map);
	DeclareArg(env, "parent", VTYPE_wx_Window, OCCUR_Once);
	DeclareArg(env, "id", VTYPE_number, OCCUR_ZeroOrOnce);
	DeclareArg(env, "pos", VTYPE_wx_Point, OCCUR_ZeroOrOnce);
	DeclareArg(env, "size", VTYPE_wx_Size, OCCUR_ZeroOrOnce);
	DeclareArg(env, "style", VTYPE_number, OCCUR_ZeroOrOnce);
	DeclareArg(env, "name", VTYPE_string, OCCUR_ZeroOrOnce);
	DeclareBlock(OCCUR_ZeroOrOnce);
}

Gura_ImplementMethod(wx_HtmlListBox, Create)
{
	Object_wx_HtmlListBox *pSelf = Object_wx_HtmlListBox::GetSelfObj(args);
	if (pSelf->IsInvalid(sig)) return Value::Null;
	wxWindow *parent = Object_wx_Window::GetObject(args, 0)->GetEntity();
	wxWindowID id = wxID_ANY;
	if (args.IsValid(1)) id = static_cast<wxWindowID>(args.GetInt(1));
	wxPoint *pos = (wxPoint *)(&wxDefaultPosition);
	if (args.IsValid(2)) pos = Object_wx_Point::GetObject(args, 2)->GetEntity();
	wxSize *size = (wxSize *)(&wxDefaultSize);
	if (args.IsValid(3)) size = Object_wx_Size::GetObject(args, 3)->GetEntity();
	long style = 0;
	if (args.IsValid(4)) style = args.GetLong(4);
	wxString name = wxHtmlListBoxNameStr;
	if (args.IsValid(5)) name = wxString::FromUTF8(args.GetString(5));
	bool rtn = pSelf->GetEntity()->Create(parent, id, *pos, *size, style, name);
	return ReturnValue(env, sig, args, Value(rtn));
}

Gura_DeclareMethod(wx_HtmlListBox, GetFileSystem)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
	DeclareBlock(OCCUR_ZeroOrOnce);
}

Gura_ImplementMethod(wx_HtmlListBox, GetFileSystem)
{
#if 0
	Object_wx_HtmlListBox *pSelf = Object_wx_HtmlListBox::GetSelfObj(args);
	if (pSelf->IsInvalid(sig)) return Value::Null;
	wxFileSystem &rtn = pSelf->GetEntity()->GetFileSystem();
	return ReturnValue(env, sig, args, Value(new Object_wx_FileSystem(new wxFileSystem(rtn), NULL, OwnerTrue)));
#endif
	SetError_NotImplemented(sig);
	return Value::Null;
}

Gura_DeclareMethod(wx_HtmlListBox, GetFileSystem_1)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
	DeclareBlock(OCCUR_ZeroOrOnce);
}

Gura_ImplementMethod(wx_HtmlListBox, GetFileSystem_1)
{
#if 0
	Object_wx_HtmlListBox *pSelf = Object_wx_HtmlListBox::GetSelfObj(args);
	if (pSelf->IsInvalid(sig)) return Value::Null;
	const wxFileSystem &rtn = pSelf->GetEntity()->GetFileSystem();
	return ReturnValue(env, sig, args, Value(new Object_wx_FileSystem(new wxFileSystem(rtn), NULL, OwnerTrue)));
#endif
	SetError_NotImplemented(sig);
	return Value::Null;
}

Gura_DeclareMethod(wx_HtmlListBox, GetSelectedTextBgColour)
{
	SetMode(RSLTMODE_Normal, FLAG_Map);
#if 0
	DeclareArg(env, "colBg", VTYPE_wx_Colour, OCCUR_Once);
#endif
	DeclareBlock(OCCUR_ZeroOrOnce);
}

Gura_ImplementMethod(wx_HtmlListBox, GetSelectedTextBgColour)
{
#if 0
	Object_wx_HtmlListBox *pSelf = Object_wx_HtmlListBox::GetSelfObj(args);
	if (pSelf->IsInvalid(sig)) return Value::Null;
	wxColour *colBg = Object_wx_Colour::GetObject(args, 0)->GetEntity();
	wxColour rtn = pSelf->GetEntity()->GetSelectedTextBgColour(*colBg);
	return ReturnValue(env, sig, args, Value(new Object_wx_Colour(new wxColour(rtn), NULL, OwnerTrue)));
#endif
	SetError_NotImplemented(sig);
	return Value::Null;
}

Gura_DeclareMethod(wx_HtmlListBox, GetSelectedTextColour)
{
	SetMode(RSLTMODE_Normal, FLAG_Map);
#if 0
	DeclareArg(env, "colFg", VTYPE_wx_Colour, OCCUR_Once);
#endif
	DeclareBlock(OCCUR_ZeroOrOnce);
}

Gura_ImplementMethod(wx_HtmlListBox, GetSelectedTextColour)
{
#if 0
	Object_wx_HtmlListBox *pSelf = Object_wx_HtmlListBox::GetSelfObj(args);
	if (pSelf->IsInvalid(sig)) return Value::Null;
	wxColour *colFg = Object_wx_Colour::GetObject(args, 0)->GetEntity();
	wxColour rtn = pSelf->GetEntity()->GetSelectedTextColour(*colFg);
	return ReturnValue(env, sig, args, Value(new Object_wx_Colour(new wxColour(rtn), NULL, OwnerTrue)));
#endif
	SetError_NotImplemented(sig);
	return Value::Null;
}

Gura_DeclareMethod(wx_HtmlListBox, OnGetItem)
{
	SetMode(RSLTMODE_Normal, FLAG_Map);
#if 0
	DeclareArg(env, "n", VTYPE_number, OCCUR_Once);
#endif
	DeclareBlock(OCCUR_ZeroOrOnce);
}

Gura_ImplementMethod(wx_HtmlListBox, OnGetItem)
{
#if 0
	Object_wx_HtmlListBox *pSelf = Object_wx_HtmlListBox::GetSelfObj(args);
	if (pSelf->IsInvalid(sig)) return Value::Null;
	size_t n = args.GetSizeT(0);
	wxString rtn = pSelf->GetEntity()->OnGetItem(n);
	return ReturnValue(env, sig, args, Value(env, static_cast<const char *>(rtn.ToUTF8())));
#endif
	SetError_NotImplemented(sig);
	return Value::Null;
}

Gura_DeclareMethod(wx_HtmlListBox, OnGetItemMarkup)
{
	SetMode(RSLTMODE_Normal, FLAG_Map);
#if 0
	DeclareArg(env, "n", VTYPE_number, OCCUR_Once);
#endif
	DeclareBlock(OCCUR_ZeroOrOnce);
}

Gura_ImplementMethod(wx_HtmlListBox, OnGetItemMarkup)
{
#if 0
	Object_wx_HtmlListBox *pSelf = Object_wx_HtmlListBox::GetSelfObj(args);
	if (pSelf->IsInvalid(sig)) return Value::Null;
	size_t n = args.GetSizeT(0);
	wxString rtn = pSelf->GetEntity()->OnGetItemMarkup(n);
	return ReturnValue(env, sig, args, Value(env, static_cast<const char *>(rtn.ToUTF8())));
#endif
	SetError_NotImplemented(sig);
	return Value::Null;
}

Gura_DeclareMethod(wx_HtmlListBox, OnLinkClicked)
{
	SetMode(RSLTMODE_Void, FLAG_Map);
#if 0
	DeclareArg(env, "n", VTYPE_number, OCCUR_Once);
	DeclareArg(env, "link", VTYPE_wx_HtmlLinkInfo, OCCUR_Once);
#endif
}

Gura_ImplementMethod(wx_HtmlListBox, OnLinkClicked)
{
#if 0
	Object_wx_HtmlListBox *pSelf = Object_wx_HtmlListBox::GetSelfObj(args);
	if (pSelf->IsInvalid(sig)) return Value::Null;
	size_t n = args.GetSizeT(0);
	wxHtmlLinkInfo *link = Object_wx_HtmlLinkInfo::GetObject(args, 1)->GetEntity();
	pSelf->GetEntity()->OnLinkClicked(n, *link);
	return Value::Null;
#endif
	SetError_NotImplemented(sig);
	return Value::Null;
}

//----------------------------------------------------------------------------
// Object implementation for wxHtmlListBox
//----------------------------------------------------------------------------
Object_wx_HtmlListBox::~Object_wx_HtmlListBox()
{
}

Object *Object_wx_HtmlListBox::Clone() const
{
	return NULL;
}

String Object_wx_HtmlListBox::ToString(Signal sig, bool exprFlag)
{
	String rtn("<wx.HtmlListBox:");
	if (GetEntity() == NULL) {
		rtn += "invalid>";
	} else {
		char buff[64];
		::sprintf(buff, "%p>", GetEntity());
		rtn += buff;
	}
	return rtn;
}

void Object_wx_HtmlListBox::OnModuleEntry(Environment &env, Signal sig)
{
	Gura_RealizeUserSymbol(OnLinkClicked);
	Gura_AssignWxStringValue(HtmlListBoxNameStr);
	Gura_AssignFunction(HtmlListBox);
	Gura_AssignFunction(HtmlListBoxEmpty);
}

//----------------------------------------------------------------------------
// Class implementation for wxHtmlListBox
//----------------------------------------------------------------------------
Gura_ImplementUserInheritableClass(wx_HtmlListBox)
{
	Gura_AssignMethod(wx_HtmlListBox, Create);
	Gura_AssignMethod(wx_HtmlListBox, GetFileSystem);
	Gura_AssignMethod(wx_HtmlListBox, GetFileSystem_1);
	Gura_AssignMethod(wx_HtmlListBox, GetSelectedTextBgColour);
	Gura_AssignMethod(wx_HtmlListBox, GetSelectedTextColour);
	Gura_AssignMethod(wx_HtmlListBox, OnGetItem);
	Gura_AssignMethod(wx_HtmlListBox, OnGetItemMarkup);
	Gura_AssignMethod(wx_HtmlListBox, OnLinkClicked);
}

Gura_ImplementDescendantCreator(wx_HtmlListBox)
{
	return new Object_wx_HtmlListBox((pClass == NULL)? this : pClass, NULL, NULL, OwnerFalse);
}

}}
