//-----------------------------------------------------------------------------
// Gura wx module
//-----------------------------------------------------------------------------
#include "stdafx.h"

#define RealizeBaseClass(className, str) \
Gura_RealizeUserClassExWithoutPrepare(className, str, env.LookupClass(VTYPE_object))

#define RealizeChildClass(className, str, classNameParent) \
Gura_RealizeUserClassExWithoutPrepare(className, str, Gura_UserClass(classNameParent))

#define PrepareClass(className) \
Gura_UserClass(className)->Prepare()

#define InitializeClass(className) \
Object_##className::OnModuleEntry(env, sig)

Gura_BeginModule(wx)

bool OwnerFalse = false;
bool OwnerTrue = true;

//-----------------------------------------------------------------------------
// Gura module functions: wx
//-----------------------------------------------------------------------------
// Module entry
Gura_ModuleEntry()
{
	RealizeBaseClass (wx_EventFactory,						"EventFactory");
	PrepareClass(wx_EventFactory);
	InitializeClass(wx_EventFactory);
	// Realize classes
	RealizeBaseClass (wx_AboutDialogInfo,					"AboutDialogInfo");
	RealizeBaseClass (wx_AcceleratorEntry,					"AcceleratorEntry");
	RealizeBaseClass (wx_AppTraits,							"AppTraits");
	RealizeBaseClass (wx_AuiDockArt,						"AuiDockArt");
	RealizeBaseClass (wx_AuiTabArt,							"AuiTabArt");
	RealizeBaseClass (wx_AuiPaneInfo,						"AuiPaneInfo");
	RealizeBaseClass (wx_List,								"List");
	RealizeBaseClass (wx_BusyCursor,						"BusyCursor");
	RealizeBaseClass (wx_BusyInfo,							"BusyInfo");
	RealizeBaseClass (wx_CalendarDateAttr,					"CalendarDateAttr");
	RealizeBaseClass (wx_Caret,								"Caret");
	RealizeBaseClass (wx_BookCtrlBase,						"BookCtrlBase");
	RealizeChildClass(wx_Choicebook,						"Choicebook",						wx_BookCtrlBase);
	RealizeChildClass(wx_Toolbook,							"Toolbook",							wx_BookCtrlBase);
	RealizeChildClass(wx_Treebook,							"Treebook",							wx_BookCtrlBase);
	RealizeBaseClass (wx_ClassInfo,							"ClassInfo");
	RealizeBaseClass (wx_ClientBase,						"ClientBase");
	RealizeChildClass(wx_Client,							"Client",							wx_ClientBase);
	RealizeChildClass(wx_DDEClient,							"DDEClient",						wx_ClientBase);
	RealizeChildClass(wx_TCPClient,							"TCPClient",						wx_ClientBase);
	RealizeBaseClass (wx_ClientData,						"ClientData");
	RealizeChildClass(wx_StringClientData,					"StringClientData",					wx_ClientData);
	RealizeChildClass(wx_TreeItemData,						"TreeItemData",						wx_ClientData);
	RealizeBaseClass (wx_ClientDataContainer,				"ClientDataContainer");
	RealizeBaseClass (wx_CmdLineParser,						"CmdLineParser");
	RealizeBaseClass (wx_ColourDatabase,					"ColourDatabase");
	RealizeBaseClass (wx_ComboPopup,						"ComboPopup");
	RealizeBaseClass (wx_Condition,							"Condition");
	RealizeBaseClass (wx_ConfigBase,						"ConfigBase");
	RealizeChildClass(wx_FileConfig,						"FileConfig",						wx_ConfigBase);
	RealizeBaseClass (wx_ConnectionBase,					"ConnectionBase");
	RealizeChildClass(wx_Connection,						"Connection",						wx_ConnectionBase);
	RealizeChildClass(wx_DDEConnection,						"DDEConnection",					wx_ConnectionBase);
	RealizeChildClass(wx_TCPConnection,						"TCPConnection",					wx_ConnectionBase);
	RealizeBaseClass (wx_CriticalSection,					"CriticalSection");
	RealizeBaseClass (wx_CriticalSectionLocker,				"CriticalSectionLocker");
	RealizeBaseClass (wx_DataFormat,						"DataFormat");
	RealizeBaseClass (wx_DataInputStream,					"DataInputStream");
	RealizeBaseClass (wx_DataObject,						"DataObject");
	RealizeChildClass(wx_DataObjectComposite,				"DataObjectComposite",				wx_DataObject);
	RealizeChildClass(wx_URLDataObject,						"URLDataObject",					wx_DataObjectComposite);
	RealizeChildClass(wx_DataObjectSimple,					"DataObjectSimple",					wx_DataObject);
	RealizeChildClass(wx_BitmapDataObject,					"BitmapDataObject",					wx_DataObjectSimple);
	RealizeChildClass(wx_CustomDataObject,					"CustomDataObject",					wx_DataObjectSimple);
	RealizeChildClass(wx_FileDataObject,					"FileDataObject",					wx_DataObjectSimple);
	RealizeChildClass(wx_TextDataObject,					"TextDataObject",					wx_DataObjectSimple);
	RealizeBaseClass (wx_DataOutputStream,					"DataOutputStream");
	RealizeBaseClass (wx_DateSpan,							"DateSpan");
	RealizeBaseClass (wx_DateTime,							"DateTime");
	RealizeBaseClass (wx_DateTimeHolidayAuthority,			"DateTimeHolidayAuthority");
	RealizeBaseClass (wx_DateTimeWorkDays,					"DateTimeWorkDays");
	RealizeBaseClass (wx_DCClipper,							"DCClipper");
	RealizeBaseClass (wx_ServerBase,						"ServerBase");
	RealizeChildClass(wx_DDEServer,							"DDEServer",						wx_ServerBase);
	RealizeChildClass(wx_Server,							"Server",							wx_ServerBase);
	RealizeChildClass(wx_TCPServer,							"TCPServer",						wx_ServerBase);
	RealizeBaseClass (wx_DebugReport,						"DebugReport");
	RealizeChildClass(wx_DebugReportCompress,				"DebugReportCompress",				wx_DebugReport);
	RealizeChildClass(wx_DebugReportUpload,					"DebugReportUpload",				wx_DebugReportCompress);
	RealizeBaseClass (wx_DebugReportPreview,				"DebugReportPreview");
	RealizeChildClass(wx_DebugReportPreviewStd,				"DebugReportPreviewStd",			wx_DebugReportPreview);
	RealizeBaseClass (wx_DialUpManager,						"DialUpManager");
	RealizeBaseClass (wx_Dir,								"Dir");
	RealizeBaseClass (wx_DirTraverser,						"DirTraverser");
	RealizeBaseClass (wx_Display,							"Display");
	RealizeBaseClass (wx_DropSource,						"DropSource");
	RealizeBaseClass (wx_DropTarget,						"DropTarget");
	RealizeChildClass(wx_FileDropTarget,					"FileDropTarget",					wx_DropTarget);
	RealizeChildClass(wx_TextDropTarget,					"TextDropTarget",					wx_DropTarget);
	RealizeBaseClass (wx_DynamicLibrary,					"DynamicLibrary");
	RealizeBaseClass (wx_DynamicLibraryDetails,				"DynamicLibraryDetails");
	RealizeBaseClass (wx_FFile,								"FFile");
	RealizeBaseClass (wx_File,								"File");
	RealizeBaseClass (wx_FileName,							"FileName");
	RealizeBaseClass (wx_FileType,							"FileType");
	RealizeBaseClass (wx_FontEnumerator,					"FontEnumerator");
	RealizeBaseClass (wx_FontMapper,						"FontMapper");
	RealizeBaseClass (wx_GBPosition,						"GBPosition");
	RealizeBaseClass (wx_GBSpan,							"GBSpan");
	RealizeBaseClass (wx_GridCellAttr,						"GridCellAttr");
	RealizeBaseClass (wx_GridCellWorker,					"GridCellWorker");
	RealizeChildClass(wx_GridCellEditor,					"GridCellEditor",					wx_GridCellWorker);
	RealizeChildClass(wx_GridCellBoolEditor,				"GridCellBoolEditor",				wx_GridCellEditor);
	RealizeChildClass(wx_GridCellChoiceEditor,				"GridCellChoiceEditor",				wx_GridCellEditor);
	RealizeChildClass(wx_GridCellTextEditor,				"GridCellTextEditor",				wx_GridCellEditor);
	RealizeChildClass(wx_GridCellFloatEditor,				"GridCellFloatEditor",				wx_GridCellTextEditor);
	RealizeChildClass(wx_GridCellNumberEditor,				"GridCellNumberEditor",				wx_GridCellTextEditor);
	RealizeChildClass(wx_GridCellRenderer,					"GridCellRenderer",					wx_GridCellWorker);
	RealizeChildClass(wx_GridCellBoolRenderer,				"GridCellBoolRenderer",				wx_GridCellRenderer);
	RealizeChildClass(wx_GridCellStringRenderer,			"GridCellStringRenderer",			wx_GridCellRenderer);
	RealizeChildClass(wx_GridCellFloatRenderer,				"GridCellFloatRenderer",			wx_GridCellStringRenderer);
	RealizeChildClass(wx_GridCellNumberRenderer,			"GridCellNumberRenderer",			wx_GridCellStringRenderer);
	RealizeBaseClass (wx_HelpControllerBase,				"HelpControllerBase");
	RealizeChildClass(wx_HelpController,					"HelpController",					wx_HelpControllerBase);
	RealizeChildClass(wx_HtmlHelpController,				"HtmlHelpController",				wx_HelpControllerBase);
	RealizeBaseClass (wx_HelpProvider,						"HelpProvider");
	RealizeChildClass(wx_SimpleHelpProvider,				"SimpleHelpProvider",				wx_HelpProvider);
	RealizeChildClass(wx_HelpControllerHelpProvider,		"HelpControllerHelpProvider",		wx_SimpleHelpProvider);
	RealizeBaseClass (wx_HtmlModalHelp,						"HtmlModalHelp");
	RealizeBaseClass (wx_IconBundle,						"IconBundle");
	RealizeBaseClass (wx_IconLocation,						"IconLocation");
	RealizeBaseClass (wx_ListItemAttr,						"ListItemAttr");
	RealizeBaseClass (wx_Locale,							"Locale");
	RealizeBaseClass (wx_Log,								"Log");
	RealizeChildClass(wx_LogChain,							"LogChain",							wx_Log);
	RealizeChildClass(wx_LogPassThrough,					"LogPassThrough",					wx_LogChain);
	RealizeChildClass(wx_LogWindow,							"LogWindow",						wx_LogPassThrough);
	RealizeChildClass(wx_LogGui,							"LogGui",							wx_Log);
	RealizeChildClass(wx_LogStderr,							"LogStderr",						wx_Log);
	RealizeChildClass(wx_LogTextCtrl,						"LogTextCtrl",						wx_Log);
	RealizeBaseClass (wx_LongLong,							"LongLong");
	RealizeBaseClass (wx_MBConv,							"MBConv");
	RealizeChildClass(wx_CSConv,							"CSConv",							wx_MBConv);
	RealizeChildClass(wx_MBConvUTF7,						"MBConvUTF7",						wx_MBConv);
	RealizeChildClass(wx_MBConvUTF8,						"MBConvUTF8",						wx_MBConv);
	RealizeChildClass(wx_MBConvUTF16,						"MBConvUTF16",						wx_MBConv);
	RealizeChildClass(wx_MBConvUTF32,						"MBConvUTF32",						wx_MBConv);
	RealizeBaseClass (wx_MemoryBuffer,						"MemoryBuffer");
	RealizeBaseClass (wx_MimeTypesManager,					"MimeTypesManager");
	RealizeBaseClass (wx_Mutex,								"Mutex");
	RealizeBaseClass (wx_MutexLocker,						"MutexLocker");
	RealizeBaseClass (wx_Node,								"Node");
	RealizeBaseClass (wx_Object,							"Object");
	RealizeChildClass(wx_AcceleratorTable,					"AcceleratorTable",					wx_Object);
	RealizeChildClass(wx_ArchiveClassFactory,				"ArchiveClassFactory",				wx_Object);
	RealizeChildClass(wx_TarClassFactory,					"TarClassFactory",					wx_ArchiveClassFactory);
	RealizeChildClass(wx_ZipClassFactory,					"ZipClassFactory",					wx_ArchiveClassFactory);
	RealizeChildClass(wx_ArchiveEntry,						"ArchiveEntry",						wx_Object);
	RealizeChildClass(wx_TarEntry,							"TarEntry",							wx_ArchiveEntry);
	RealizeChildClass(wx_ZipEntry,							"ZipEntry",							wx_ArchiveEntry);
	RealizeChildClass(wx_ArtProvider,						"ArtProvider",						wx_Object);
	RealizeChildClass(wx_AutomationObject,					"AutomationObject",					wx_Object);
	RealizeChildClass(wx_BitmapHandler,						"BitmapHandler",					wx_Object);
	RealizeChildClass(wx_Clipboard,							"Clipboard",						wx_Object);
	RealizeChildClass(wx_Colour,							"Colour",							wx_Object);
	RealizeChildClass(wx_ColourData,						"ColourData",						wx_Object);
	RealizeChildClass(wx_Command,							"Command",							wx_Object);
	RealizeChildClass(wx_CommandProcessor,					"CommandProcessor",					wx_Object);
	RealizeChildClass(wx_ContextHelp,						"ContextHelp",						wx_Object);
	RealizeChildClass(wx_DataViewColumn,					"DataViewColumn",					wx_Object);
	RealizeChildClass(wx_DataViewListModelNotifier,			"DataViewListModelNotifier",		wx_Object);
	RealizeChildClass(wx_DataViewModel,						"DataViewModel",					wx_Object);
	RealizeChildClass(wx_DataViewListModel,					"DataViewListModel",				wx_DataViewModel);
	RealizeChildClass(wx_DataViewSortedListModel,			"DataViewSortedListModel",			wx_DataViewListModel);
	RealizeChildClass(wx_DataViewRenderer,					"DataViewRenderer",					wx_Object);
	RealizeChildClass(wx_DataViewTextRenderer,				"DataViewTextRenderer",				wx_DataViewRenderer);
	RealizeChildClass(wx_DataViewProgressRenderer,			"DataViewProgressRenderer",			wx_DataViewRenderer);
	RealizeChildClass(wx_DataViewToggleRenderer,			"DataViewToggleRenderer",			wx_DataViewRenderer);
	RealizeChildClass(wx_DataViewBitmapRenderer,			"DataViewBitmapRenderer",			wx_DataViewRenderer);
	RealizeChildClass(wx_DataViewDateRenderer,				"DataViewDateRenderer",				wx_DataViewRenderer);
	RealizeChildClass(wx_DataViewCustomRenderer,			"DataViewCustomRenderer",			wx_DataViewRenderer);
	RealizeChildClass(wx_DC,								"DC",								wx_Object);
	RealizeChildClass(wx_MemoryDC,							"MemoryDC",							wx_DC);
	RealizeChildClass(wx_BufferedDC,						"BufferedDC",						wx_MemoryDC);
	RealizeChildClass(wx_BufferedPaintDC,					"BufferedPaintDC",					wx_BufferedDC);
	RealizeChildClass(wx_AutoBufferedPaintDC,				"AutoBufferedPaintDC",				wx_BufferedPaintDC);
	RealizeChildClass(wx_MetafileDC,						"MetafileDC",						wx_DC);
	RealizeChildClass(wx_MirrorDC,							"MirrorDC",							wx_DC);
	RealizeChildClass(wx_PrinterDC,							"PrinterDC",						wx_DC);
	RealizeChildClass(wx_ScreenDC,							"ScreenDC",							wx_DC);
	RealizeChildClass(wx_WindowDC,							"WindowDC",							wx_DC);
	RealizeChildClass(wx_ClientDC,							"ClientDC",							wx_WindowDC);
	RealizeChildClass(wx_PaintDC,							"PaintDC",							wx_WindowDC);
	RealizeChildClass(wx_DocTemplate,						"DocTemplate",						wx_Object);
	RealizeChildClass(wx_DragImage,							"DragImage",						wx_Object);
	RealizeChildClass(wx_EncodingConverter,					"EncodingConverter",				wx_Object);
	RealizeChildClass(wx_Event,								"Event",							wx_Object);
	RealizeChildClass(wx_ActivateEvent,						"ActivateEvent",					wx_Event);
	RealizeChildClass(wx_CalculateLayoutEvent,				"CalculateLayoutEvent",				wx_Event);
	RealizeChildClass(wx_CloseEvent,						"CloseEvent",						wx_Event);
	RealizeChildClass(wx_CommandEvent,						"CommandEvent",						wx_Event);
	RealizeChildClass(wx_ActiveXEvent,						"ActiveXEvent",						wx_CommandEvent);
	RealizeChildClass(wx_ClipboardTextEvent,				"ClipboardTextEvent",				wx_CommandEvent);
	RealizeChildClass(wx_CollapsiblePaneEvent,				"CollapsiblePaneEvent",				wx_CommandEvent);
	RealizeChildClass(wx_ColourPickerEvent,					"ColourPickerEvent",				wx_CommandEvent);
	RealizeChildClass(wx_ChildFocusEvent,					"ChildFocusEvent",					wx_CommandEvent);
	RealizeChildClass(wx_ContextMenuEvent,					"ContextMenuEvent",					wx_CommandEvent);
	RealizeChildClass(wx_DateEvent,							"DateEvent",						wx_CommandEvent);
	RealizeChildClass(wx_CalendarEvent,						"CalendarEvent",					wx_DateEvent);
	RealizeChildClass(wx_FileDirPickerEvent,				"FileDirPickerEvent",				wx_CommandEvent);
	RealizeChildClass(wx_FindDialogEvent,					"FindDialogEvent",					wx_CommandEvent);
	RealizeChildClass(wx_FontPickerEvent,					"FontPickerEvent",					wx_CommandEvent);
	RealizeChildClass(wx_HelpEvent,							"HelpEvent",						wx_CommandEvent);
	RealizeChildClass(wx_HtmlLinkEvent,						"HtmlLinkEvent",					wx_CommandEvent);
	RealizeChildClass(wx_HtmlCellEvent,						"HtmlCellEvent",					wx_CommandEvent);
	RealizeChildClass(wx_HyperlinkEvent,					"HyperlinkEvent",					wx_CommandEvent);
	RealizeChildClass(wx_NotifyEvent,						"NotifyEvent",						wx_CommandEvent);
	RealizeChildClass(wx_DataViewEvent,						"DataViewEvent",					wx_NotifyEvent);
	RealizeChildClass(wx_GridEvent,							"GridEvent",						wx_NotifyEvent);
	RealizeChildClass(wx_GridRangeSelectEvent,				"GridRangeSelectEvent",				wx_NotifyEvent);
	RealizeChildClass(wx_GridSizeEvent,						"GridSizeEvent",					wx_NotifyEvent);
	RealizeChildClass(wx_ListEvent,							"ListEvent",						wx_NotifyEvent);
	RealizeChildClass(wx_MediaEvent,						"MediaEvent",						wx_NotifyEvent);
	RealizeChildClass(wx_NotebookEvent,						"NotebookEvent",					wx_NotifyEvent);
	RealizeChildClass(wx_RichTextEvent,						"RichTextEvent",					wx_NotifyEvent);
	RealizeChildClass(wx_SpinEvent,							"SpinEvent",						wx_NotifyEvent);
	RealizeChildClass(wx_SplitterEvent,						"SplitterEvent",					wx_NotifyEvent);
	RealizeChildClass(wx_TreeEvent,							"TreeEvent",						wx_NotifyEvent);
	RealizeChildClass(wx_WizardEvent,						"WizardEvent",						wx_NotifyEvent);
	RealizeChildClass(wx_SashEvent,							"SashEvent",						wx_CommandEvent);
	RealizeChildClass(wx_ScrollEvent,						"ScrollEvent",						wx_CommandEvent);
	RealizeChildClass(wx_UpdateUIEvent,						"UpdateUIEvent",					wx_CommandEvent);
	RealizeChildClass(wx_WindowCreateEvent,					"WindowCreateEvent",				wx_CommandEvent);
	RealizeChildClass(wx_WindowDestroyEvent,				"WindowDestroyEvent",				wx_CommandEvent);
	RealizeChildClass(wx_DialUpEvent,						"DialUpEvent",						wx_Event);
	RealizeChildClass(wx_DropFilesEvent,					"DropFilesEvent",					wx_Event);
	RealizeChildClass(wx_EraseEvent,						"EraseEvent",						wx_Event);
	RealizeChildClass(wx_FocusEvent,						"FocusEvent",						wx_Event);
	RealizeChildClass(wx_GridEditorCreatedEvent,			"GridEditorCreatedEvent",			wx_Event);
	RealizeChildClass(wx_IconizeEvent,						"IconizeEvent",						wx_Event);
	RealizeChildClass(wx_IdleEvent,							"IdleEvent",						wx_Event);
	RealizeChildClass(wx_InitDialogEvent,					"InitDialogEvent",					wx_Event);
	RealizeChildClass(wx_JoystickEvent,						"JoystickEvent",					wx_Event);
	RealizeChildClass(wx_KeyEvent,							"KeyEvent",							wx_Event);
	RealizeChildClass(wx_MaximizeEvent,						"MaximizeEvent",					wx_Event);
	RealizeChildClass(wx_MenuEvent,							"MenuEvent",						wx_Event);
	RealizeChildClass(wx_MouseCaptureChangedEvent,			"MouseCaptureChangedEvent",			wx_Event);
	RealizeChildClass(wx_MouseCaptureLostEvent,				"MouseCaptureLostEvent",			wx_Event);
	RealizeChildClass(wx_MouseEvent,						"MouseEvent",						wx_Event);
	RealizeChildClass(wx_MoveEvent,							"MoveEvent",						wx_Event);
	RealizeChildClass(wx_PaintEvent,						"PaintEvent",						wx_Event);
	RealizeChildClass(wx_PowerEvent,						"PowerEvent",						wx_Event);
	RealizeChildClass(wx_ProcessEvent,						"ProcessEvent",						wx_Event);
	RealizeChildClass(wx_QueryLayoutInfoEvent,				"QueryLayoutInfoEvent",				wx_Event);
	RealizeChildClass(wx_ScrollWinEvent,					"ScrollWinEvent",					wx_Event);
	RealizeChildClass(wx_SetCursorEvent,					"SetCursorEvent",					wx_Event);
	RealizeChildClass(wx_SizeEvent,							"SizeEvent",						wx_Event);
	RealizeChildClass(wx_SocketEvent,						"SocketEvent",						wx_Event);
	RealizeChildClass(wx_SysColourChangedEvent,				"SysColourChangedEvent",			wx_Event);
	RealizeChildClass(wx_TimerEvent,						"TimerEvent",						wx_Event);
	RealizeChildClass(wx_EvtHandler,						"EvtHandler",						wx_Object);
	RealizeChildClass(wx_App,								"App",								wx_EvtHandler);
	RealizeChildClass(wx_AuiManager,						"AuiManager",						wx_EvtHandler);
	RealizeChildClass(wx_DocManager,						"DocManager",						wx_EvtHandler);
	RealizeChildClass(wx_Document,							"Document",							wx_EvtHandler);
	RealizeChildClass(wx_Menu,								"Menu",								wx_EvtHandler);
	RealizeChildClass(wx_Process,							"Process",							wx_EvtHandler);
	RealizeChildClass(wx_TaskBarIcon,						"TaskBarIcon",						wx_EvtHandler);
	RealizeChildClass(wx_Timer,								"Timer",							wx_EvtHandler);
	RealizeChildClass(wx_Validator,							"Validator",						wx_EvtHandler);
	RealizeChildClass(wx_GenericValidator,					"GenericValidator",					wx_Validator);
	RealizeChildClass(wx_TextValidator,						"TextValidator",					wx_Validator);
	RealizeChildClass(wx_View,								"View",								wx_EvtHandler);
	RealizeChildClass(wx_Window,							"Window",							wx_EvtHandler);
	RealizeChildClass(wx_ActiveXContainer,					"ActiveXContainer",					wx_Window);
	RealizeChildClass(wx_Control,							"Control",							wx_Window);
	RealizeChildClass(wx_AnimationCtrl,						"AnimationCtrl",					wx_Control);
	RealizeChildClass(wx_AuiNotebook,						"AuiNotebook",						wx_Control);
	RealizeChildClass(wx_Button,							"Button",							wx_Control);
	RealizeChildClass(wx_BitmapButton,						"BitmapButton",						wx_Button);
	RealizeChildClass(wx_ContextHelpButton,					"ContextHelpButton",				wx_BitmapButton);
	RealizeChildClass(wx_CalendarCtrl,						"CalendarCtrl",						wx_Control);
	RealizeChildClass(wx_CheckBox,							"CheckBox",							wx_Control);
	RealizeChildClass(wx_CollapsiblePane,					"CollapsiblePane",					wx_Control);
	RealizeChildClass(wx_ComboCtrl,							"ComboCtrl",						wx_Control);
	RealizeChildClass(wx_OwnerDrawnComboBox,				"OwnerDrawnComboBox",				wx_ComboCtrl);
	RealizeChildClass(wx_BitmapComboBox,					"BitmapComboBox",					wx_OwnerDrawnComboBox);
	RealizeChildClass(wx_RichTextStyleComboCtrl,			"RichTextStyleComboCtrl",			wx_ComboCtrl);
	RealizeChildClass(wx_ControlWithItems,					"ControlWithItems",					wx_Control);
	RealizeChildClass(wx_Choice,							"Choice",							wx_ControlWithItems);
	RealizeChildClass(wx_ComboBox,							"ComboBox",							wx_ControlWithItems);
	RealizeChildClass(wx_ListBox,							"ListBox",							wx_ControlWithItems);
	RealizeChildClass(wx_CheckListBox,						"CheckListBox",						wx_ListBox);
	RealizeChildClass(wx_DataViewCtrl,						"DataViewCtrl",						wx_Control);
	RealizeChildClass(wx_DatePickerCtrl,					"DatePickerCtrl",					wx_Control);
	RealizeChildClass(wx_Gauge,								"Gauge",							wx_Control);
	RealizeChildClass(wx_GenericDirCtrl,					"GenericDirCtrl",					wx_Control);
	RealizeChildClass(wx_HyperlinkCtrl,						"HyperlinkCtrl",					wx_Control);
	RealizeChildClass(wx_Listbook,							"Listbook",							wx_Control);
	RealizeChildClass(wx_ListCtrl,							"ListCtrl",							wx_Control);
	RealizeChildClass(wx_ListView,							"ListView",							wx_ListCtrl);
	RealizeChildClass(wx_MediaCtrl,							"MediaCtrl",						wx_Control);
	RealizeChildClass(wx_Notebook,							"Notebook",							wx_Control);
	RealizeChildClass(wx_PickerBase,						"PickerBase",						wx_Control);
	RealizeChildClass(wx_ColourPickerCtrl,					"ColourPickerCtrl",					wx_PickerBase);
	RealizeChildClass(wx_DirPickerCtrl,						"DirPickerCtrl",					wx_PickerBase);
	RealizeChildClass(wx_FilePickerCtrl,					"FilePickerCtrl",					wx_PickerBase);
	RealizeChildClass(wx_FontPickerCtrl,					"FontPickerCtrl",					wx_PickerBase);
	RealizeChildClass(wx_RadioBox,							"RadioBox",							wx_Control);
	RealizeChildClass(wx_RadioButton,						"RadioButton",						wx_Control);
	RealizeChildClass(wx_RichTextStyleListCtrl,				"RichTextStyleListCtrl",			wx_Control);
	RealizeChildClass(wx_ScrollBar,							"ScrollBar",						wx_Control);
	RealizeChildClass(wx_Slider,							"Slider",							wx_Control);
	RealizeChildClass(wx_SpinButton,						"SpinButton",						wx_Control);
	RealizeChildClass(wx_SpinCtrl,							"SpinCtrl",							wx_Control);
	RealizeChildClass(wx_StaticBitmap,						"StaticBitmap",						wx_Control);
	RealizeChildClass(wx_StaticBox,							"StaticBox",						wx_Control);
	RealizeChildClass(wx_StaticLine,						"StaticLine",						wx_Control);
	RealizeChildClass(wx_StaticText,						"StaticText",						wx_Control);
	RealizeChildClass(wx_TextCtrl,							"TextCtrl",							wx_Control);
	RealizeChildClass(wx_ToggleButton,						"ToggleButton",						wx_Control);
	RealizeChildClass(wx_TreeCtrl,							"TreeCtrl",							wx_Control);
	RealizeChildClass(wx_HtmlHelpDialog,					"HtmlHelpDialog",					wx_Window);
	RealizeChildClass(wx_HtmlHelpWindow,					"HtmlHelpWindow",					wx_Window);
	RealizeChildClass(wx_MDIClientWindow,					"MDIClientWindow",					wx_Window);
	RealizeChildClass(wx_MenuBar,							"MenuBar",							wx_Window);
	RealizeChildClass(wx_Panel,								"Panel",							wx_Window);
	RealizeChildClass(wx_PreviewControlBar,					"PreviewControlBar",				wx_Panel);
	RealizeChildClass(wx_ScrolledWindow,					"ScrolledWindow",					wx_Panel);
	RealizeChildClass(wx_Grid,								"Grid",								wx_ScrolledWindow);
	RealizeChildClass(wx_HtmlWindow,						"HtmlWindow",						wx_ScrolledWindow);
	RealizeChildClass(wx_PreviewCanvas,						"PreviewCanvas",					wx_ScrolledWindow);
	RealizeChildClass(wx_VScrolledWindow,					"VScrolledWindow",					wx_Panel);
	RealizeChildClass(wx_VListBox,							"VListBox",							wx_VScrolledWindow);
	RealizeChildClass(wx_HtmlListBox,						"HtmlListBox",						wx_VListBox);
	RealizeChildClass(wx_SimpleHtmlListBox,					"SimpleHtmlListBox",				wx_HtmlListBox);
	RealizeChildClass(wx_RichTextStyleListBox,				"RichTextStyleListBox",				wx_HtmlListBox);
	RealizeChildClass(wx_WizardPage,						"WizardPage",						wx_Panel);
	RealizeChildClass(wx_WizardPageSimple,					"WizardPageSimple",					wx_WizardPage);
	RealizeChildClass(wx_SashWindow,						"SashWindow",						wx_Window);
	RealizeChildClass(wx_SashLayoutWindow,					"SashLayoutWindow",					wx_SashWindow);
	RealizeChildClass(wx_SearchCtrl,						"SearchCtrl",						wx_Window);
	RealizeChildClass(wx_SplitterWindow,					"SplitterWindow",					wx_Window);
	RealizeChildClass(wx_StatusBar,							"StatusBar",						wx_Window);
	RealizeChildClass(wx_TopLevelWindow,					"TopLevelWindow",					wx_Window);
	RealizeChildClass(wx_Dialog,							"Dialog",							wx_TopLevelWindow);
	RealizeChildClass(wx_ColourDialog,						"ColourDialog",						wx_Dialog);
	RealizeChildClass(wx_DirDialog,							"DirDialog",						wx_Dialog);
	RealizeChildClass(wx_FileDialog,						"FileDialog",						wx_Dialog);
	RealizeChildClass(wx_FindReplaceDialog,					"FindReplaceDialog",				wx_Dialog);
	RealizeChildClass(wx_FontDialog,						"FontDialog",						wx_Dialog);
	RealizeChildClass(wx_MessageDialog,						"MessageDialog",					wx_Dialog);
	RealizeChildClass(wx_MultiChoiceDialog,					"MultiChoiceDialog",				wx_Dialog);
	RealizeChildClass(wx_ProgressDialog,					"ProgressDialog",					wx_Dialog);
	RealizeChildClass(wx_PropertySheetDialog,				"PropertySheetDialog",				wx_Dialog);
	RealizeChildClass(wx_RichTextFormattingDialog,			"RichTextFormattingDialog",			wx_PropertySheetDialog);
	RealizeChildClass(wx_RichTextStyleOrganiserDialog,		"RichTextStyleOrganiserDialog",		wx_Dialog);
	RealizeChildClass(wx_SingleChoiceDialog,				"SingleChoiceDialog",				wx_Dialog);
	RealizeChildClass(wx_SymbolPickerDialog,				"SymbolPickerDialog",				wx_Dialog);
	RealizeChildClass(wx_TextEntryDialog,					"TextEntryDialog",					wx_Dialog);
	RealizeChildClass(wx_PasswordEntryDialog,				"PasswordEntryDialog",				wx_TextEntryDialog);
	RealizeChildClass(wx_Wizard,							"Wizard",							wx_Dialog);
	RealizeChildClass(wx_Frame,								"Frame",							wx_TopLevelWindow);
	RealizeChildClass(wx_DocChildFrame,						"DocChildFrame",					wx_Frame);
	RealizeChildClass(wx_DocParentFrame,					"DocParentFrame",					wx_Frame);
	RealizeChildClass(wx_HtmlHelpFrame,						"HtmlHelpFrame",					wx_Frame);
	RealizeChildClass(wx_MDIChildFrame,						"MDIChildFrame",					wx_Frame);
	RealizeChildClass(wx_DocMDIChildFrame,					"DocMDIChildFrame",					wx_MDIChildFrame);
	RealizeChildClass(wx_MDIParentFrame,					"MDIParentFrame",					wx_Frame);
	RealizeChildClass(wx_DocMDIParentFrame,					"DocMDIParentFrame",				wx_MDIParentFrame);
	RealizeChildClass(wx_MiniFrame,							"MiniFrame",						wx_Frame);
	RealizeChildClass(wx_PreviewFrame,						"PreviewFrame",						wx_Frame);
	RealizeChildClass(wx_SplashScreen,						"SplashScreen",						wx_Frame);
	RealizeChildClass(wx_FileHistory,						"FileHistory",						wx_Object);
	RealizeChildClass(wx_FileSystem,						"FileSystem",						wx_Object);
	RealizeChildClass(wx_FileSystemHandler,					"FileSystemHandler",				wx_Object);
	RealizeChildClass(wx_MemoryFSHandler,					"MemoryFSHandler",					wx_FileSystemHandler);
	RealizeChildClass(wx_FilterClassFactory,				"FilterClassFactory",				wx_Object);
	RealizeChildClass(wx_FindReplaceData,					"FindReplaceData",					wx_Object);
	RealizeChildClass(wx_FontData,							"FontData",							wx_Object);
	RealizeChildClass(wx_FSFile,							"FSFile",							wx_Object);
	RealizeChildClass(wx_GDIObject,							"GDIObject",						wx_Object);
	RealizeChildClass(wx_Animation,							"Animation",						wx_GDIObject);
	RealizeChildClass(wx_Bitmap,							"Bitmap",							wx_GDIObject);
	RealizeChildClass(wx_Brush,								"Brush",							wx_GDIObject);
	RealizeChildClass(wx_Cursor,							"Cursor",							wx_GDIObject);
	RealizeChildClass(wx_Font,								"Font",								wx_GDIObject);
	RealizeChildClass(wx_Icon,								"Icon",								wx_GDIObject);
	RealizeChildClass(wx_Palette,							"Palette",							wx_GDIObject);
	RealizeChildClass(wx_Pen,								"Pen",								wx_GDIObject);
	RealizeChildClass(wx_Region,							"Region",							wx_GDIObject);
	RealizeChildClass(wx_GridTableBase,						"GridTableBase",					wx_Object);
	RealizeChildClass(wx_HashTable,							"HashTable",						wx_Object);
	RealizeChildClass(wx_HtmlCell,							"HtmlCell",							wx_Object);
	RealizeChildClass(wx_HtmlColourCell,					"HtmlColourCell",					wx_HtmlCell);
	RealizeChildClass(wx_HtmlContainerCell,					"HtmlContainerCell",				wx_HtmlCell);
	RealizeChildClass(wx_HtmlWidgetCell,					"HtmlWidgetCell",					wx_HtmlCell);
	RealizeChildClass(wx_HtmlDCRenderer,					"HtmlDCRenderer",					wx_Object);
	RealizeChildClass(wx_HtmlEasyPrinting,					"HtmlEasyPrinting",					wx_Object);
	RealizeChildClass(wx_HtmlFilter,						"HtmlFilter",						wx_Object);
	RealizeChildClass(wx_HtmlHelpData,						"HtmlHelpData",						wx_Object);
	RealizeChildClass(wx_HtmlLinkInfo,						"HtmlLinkInfo",						wx_Object);
	RealizeChildClass(wx_HtmlParser,						"HtmlParser",						wx_Object);
	RealizeChildClass(wx_HtmlWinParser,						"HtmlWinParser",					wx_HtmlParser);
	RealizeChildClass(wx_HtmlTag,							"HtmlTag",							wx_Object);
	RealizeChildClass(wx_HtmlTagHandler,					"HtmlTagHandler",					wx_Object);
	RealizeChildClass(wx_HtmlWinTagHandler,					"HtmlWinTagHandler",				wx_HtmlTagHandler);
	RealizeChildClass(wx_Image,								"Image",							wx_Object);
	RealizeChildClass(wx_ImageHandler,						"ImageHandler",						wx_Object);
	RealizeChildClass(wx_ImageList,							"ImageList",						wx_Object);
	RealizeChildClass(wx_IndividualLayoutConstraint,		"IndividualLayoutConstraint",		wx_Object);
	RealizeChildClass(wx_Joystick,							"Joystick",							wx_Object);
	RealizeChildClass(wx_LayoutAlgorithm,					"LayoutAlgorithm",					wx_Object);
	RealizeChildClass(wx_LayoutConstraints,					"LayoutConstraints",				wx_Object);
	RealizeChildClass(wx_ListItem,							"ListItem",							wx_Object);
	RealizeChildClass(wx_Mask,								"Mask",								wx_Object);
	RealizeChildClass(wx_MenuItem,							"MenuItem",							wx_Object);
	RealizeChildClass(wx_Metafile,							"Metafile",							wx_Object);
	RealizeChildClass(wx_Module,							"Module",							wx_Object);
	RealizeChildClass(wx_HtmlTagsModule,					"HtmlTagsModule",					wx_Module);
	RealizeChildClass(wx_PageSetupDialog,					"PageSetupDialog",					wx_Object);
	RealizeChildClass(wx_PageSetupDialogData,				"PageSetupDialogData",				wx_Object);
	RealizeChildClass(wx_PrintData,							"PrintData",						wx_Object);
	RealizeChildClass(wx_PrintDialog,						"PrintDialog",						wx_Object);
	RealizeChildClass(wx_PrintDialogData,					"PrintDialogData",					wx_Object);
	RealizeChildClass(wx_Printer,							"Printer",							wx_Object);
	RealizeChildClass(wx_Printout,							"Printout",							wx_Object);
	RealizeChildClass(wx_HtmlPrintout,						"HtmlPrintout",						wx_Printout);
	RealizeChildClass(wx_RichTextPrintout,					"RichTextPrintout",					wx_Printout);
	RealizeChildClass(wx_PrintPreview,						"PrintPreview",						wx_Object);
	RealizeChildClass(wx_Quantize,							"Quantize",							wx_Object);
	RealizeChildClass(wx_RegionIterator,					"RegionIterator",					wx_Object);
	RealizeChildClass(wx_RichTextFileHandler,				"RichTextFileHandler",				wx_Object);
	RealizeChildClass(wx_RichTextHTMLHandler,				"RichTextHTMLHandler",				wx_RichTextFileHandler);
	RealizeChildClass(wx_RichTextXMLHandler,				"RichTextXMLHandler",				wx_RichTextFileHandler);
	RealizeChildClass(wx_RichTextFormattingDialogFactory,	"RichTextFormattingDialogFactory",	wx_Object);
	RealizeChildClass(wx_RichTextHeaderFooterData,			"RichTextHeaderFooterData",			wx_Object);
	RealizeChildClass(wx_RichTextPrinting,					"RichTextPrinting",					wx_Object);
	RealizeChildClass(wx_RichTextStyleDefinition,			"RichTextStyleDefinition",			wx_Object);
	RealizeChildClass(wx_RichTextCharacterStyleDefinition,	"RichTextCharacterStyleDefinition",	wx_RichTextStyleDefinition);
	RealizeChildClass(wx_RichTextParagraphStyleDefinition,	"RichTextParagraphStyleDefinition",	wx_RichTextStyleDefinition);
	RealizeChildClass(wx_RichTextListStyleDefinition,		"RichTextListStyleDefinition",		wx_RichTextParagraphStyleDefinition);
	RealizeChildClass(wx_RichTextStyleSheet,				"RichTextStyleSheet",				wx_Object);
	RealizeChildClass(wx_Sizer,								"Sizer",							wx_Object);
	RealizeChildClass(wx_BoxSizer,							"BoxSizer",							wx_Sizer);
	RealizeChildClass(wx_StaticBoxSizer,					"StaticBoxSizer",					wx_BoxSizer);
	RealizeChildClass(wx_StdDialogButtonSizer,				"StdDialogButtonSizer",				wx_BoxSizer);
	RealizeChildClass(wx_GridSizer,							"GridSizer",						wx_Sizer);
	RealizeChildClass(wx_FlexGridSizer,						"FlexGridSizer",					wx_GridSizer);
	RealizeChildClass(wx_GridBagSizer,						"GridBagSizer",						wx_FlexGridSizer);
	RealizeChildClass(wx_SizerItem,							"SizerItem",						wx_Object);
	RealizeChildClass(wx_GBSizerItem,						"GBSizerItem",						wx_SizerItem);
	RealizeChildClass(wx_SockAddress,						"SockAddress",						wx_Object);
	RealizeChildClass(wx_IPaddress,							"IPaddress",						wx_SockAddress);
	RealizeChildClass(wx_IPV4address,						"IPV4address",						wx_IPaddress);
	RealizeChildClass(wx_SocketBase,						"SocketBase",						wx_Object);
	RealizeChildClass(wx_DatagramSocket,					"DatagramSocket",					wx_SocketBase);
	RealizeChildClass(wx_SocketClient,						"SocketClient",						wx_SocketBase);
	RealizeChildClass(wx_Protocol,							"Protocol",							wx_SocketClient);
	RealizeChildClass(wx_FTP,								"FTP",								wx_Protocol);
	RealizeChildClass(wx_HTTP,								"HTTP",								wx_Protocol);
	RealizeChildClass(wx_SocketServer,						"SocketServer",						wx_SocketBase);
	RealizeChildClass(wx_Sound,								"Sound",							wx_Object);
	RealizeChildClass(wx_StringTokenizer,					"StringTokenizer",					wx_Object);
	RealizeChildClass(wx_SystemOptions,						"SystemOptions",					wx_Object);
	RealizeChildClass(wx_ToolTip,							"ToolTip",							wx_Object);
	RealizeChildClass(wx_URI,								"URI",								wx_Object);
	RealizeChildClass(wx_URL,								"URL",								wx_URI);
	RealizeChildClass(wx_Variant,							"Variant",							wx_Object);
	RealizeChildClass(wx_VariantData,						"VariantData",						wx_Object);
	RealizeChildClass(wx_XmlDocument,						"XmlDocument",						wx_Object);
	RealizeChildClass(wx_XmlResource,						"XmlResource",						wx_Object);
	RealizeChildClass(wx_XmlResourceHandler,				"XmlResourceHandler",				wx_Object);
	RealizeBaseClass (wx_ObjectRefData,						"ObjectRefData");
	RealizeBaseClass (wx_PenList,							"PenList");
	RealizeBaseClass (wx_PlatformInfo,						"PlatformInfo");
	RealizeBaseClass (wx_Point,								"Point");
	RealizeBaseClass (wx_RealPoint,							"RealPoint");
	RealizeBaseClass (wx_Rect,								"Rect");
	RealizeBaseClass (wx_RecursionGuard,					"RecursionGuard");
	RealizeBaseClass (wx_RegEx,								"RegEx");
	RealizeBaseClass (wx_RegKey,							"RegKey");
	RealizeBaseClass (wx_RendererNative,					"RendererNative");
	RealizeChildClass(wx_DelegateRendererNative,			"DelegateRendererNative",			wx_RendererNative);
	RealizeBaseClass (wx_RendererVersion,					"RendererVersion");
	RealizeBaseClass (wx_RichTextAttr,						"RichTextAttr");
	RealizeBaseClass (wx_RichTextParagraphLayoutBox,		"RichTextParagraphLayoutBox");
	RealizeChildClass(wx_RichTextBuffer,					"RichTextBuffer",					wx_RichTextParagraphLayoutBox);
	RealizeBaseClass (wx_TextCtrlBase,						"TextCtrlBase");
	RealizeChildClass(wx_RichTextCtrl,						"RichTextCtrl",						wx_TextCtrlBase);
	RealizeBaseClass (wx_RichTextRange,						"RichTextRange");
	RealizeBaseClass (wx_Semaphore,							"Semaphore");
	RealizeBaseClass (wx_SingleInstanceChecker,				"SingleInstanceChecker");
	RealizeBaseClass (wx_Size,								"Size");
	RealizeBaseClass (wx_SizerFlags,						"SizerFlags");
	RealizeBaseClass (wx_SplitterRenderParams,				"SplitterRenderParams");
	RealizeBaseClass (wx_StackFrame,						"StackFrame");
	RealizeBaseClass (wx_StackWalker,						"StackWalker");
	RealizeBaseClass (wx_StandardPaths,						"StandardPaths");
	RealizeBaseClass (wx_StopWatch,							"StopWatch");
	RealizeBaseClass (wx_StreamBase,						"StreamBase");
	RealizeChildClass(wx_InputStream,						"InputStream",						wx_StreamBase);
	RealizeChildClass(wx_FFileInputStream,					"FFileInputStream",					wx_InputStream);
	RealizeChildClass(wx_FileInputStream,					"FileInputStream",					wx_InputStream);
	RealizeChildClass(wx_FilterInputStream,					"FilterInputStream",				wx_InputStream);
	RealizeChildClass(wx_ArchiveInputStream,				"ArchiveInputStream",				wx_FilterInputStream);
	RealizeChildClass(wx_TarInputStream,					"TarInputStream",					wx_ArchiveInputStream);
	RealizeChildClass(wx_ZipInputStream,					"ZipInputStream",					wx_ArchiveInputStream);
	RealizeChildClass(wx_BufferedInputStream,				"BufferedInputStream",				wx_FilterInputStream);
	RealizeChildClass(wx_MemoryInputStream,					"MemoryInputStream",				wx_InputStream);
	RealizeChildClass(wx_SocketInputStream,					"SocketInputStream",				wx_InputStream);
	RealizeChildClass(wx_StringInputStream,					"StringInputStream",				wx_InputStream);
	RealizeChildClass(wx_OutputStream,						"OutputStream",						wx_StreamBase);
	RealizeChildClass(wx_CountingOutputStream,				"CountingOutputStream",				wx_OutputStream);
	RealizeChildClass(wx_FFileOutputStream,					"FFileOutputStream",				wx_OutputStream);
	RealizeChildClass(wx_FFileStream,						"FFileStream",						wx_FFileOutputStream);
	RealizeChildClass(wx_FileOutputStream,					"FileOutputStream",					wx_OutputStream);
	RealizeChildClass(wx_FileStream,						"FileStream",						wx_FileOutputStream);
	RealizeChildClass(wx_FilterOutputStream,				"FilterOutputStream",				wx_OutputStream);
	RealizeChildClass(wx_BufferedOutputStream,				"BufferedOutputStream",				wx_FilterOutputStream);
	RealizeChildClass(wx_MemoryOutputStream,				"MemoryOutputStream",				wx_OutputStream);
	RealizeChildClass(wx_SocketOutputStream,				"SocketOutputStream",				wx_OutputStream);
	RealizeChildClass(wx_StringOutputStream,				"StringOutputStream",				wx_OutputStream);
	RealizeChildClass(wx_TempFileOutputStream,				"TempFileOutputStream",				wx_OutputStream);
	RealizeBaseClass (wx_StreamBuffer,						"StreamBuffer");
	RealizeBaseClass (wx_String,							"String");
	RealizeBaseClass (wx_StringBuffer,						"StringBuffer");
	RealizeBaseClass (wx_StringBufferLength,				"StringBufferLength");
	RealizeBaseClass (wx_SystemSettings,					"SystemSettings");
	RealizeBaseClass (wx_ArchiveOutputStream,				"ArchiveOutputStream");
	RealizeChildClass(wx_TarOutputStream,					"TarOutputStream",					wx_ArchiveOutputStream);
	RealizeChildClass(wx_ZipOutputStream,					"ZipOutputStream",					wx_ArchiveOutputStream);
	RealizeBaseClass (wx_TempFile,							"TempFile");
	RealizeBaseClass (wx_TextAttr,							"TextAttr");
	RealizeChildClass(wx_TextAttrEx,						"TextAttrEx",						wx_TextAttr);
	RealizeBaseClass (wx_TextFile,							"TextFile");
	RealizeBaseClass (wx_TextInputStream,					"TextInputStream");
	RealizeBaseClass (wx_TextOutputStream,					"TextOutputStream");
	RealizeBaseClass (wx_Thread,							"Thread");
	RealizeBaseClass (wx_ThreadHelper,						"ThreadHelper");
	RealizeBaseClass (wx_TimeSpan,							"TimeSpan");
	RealizeBaseClass (wx_TipProvider,						"TipProvider");
	RealizeBaseClass (wx_PopupTransientWindow,				"PopupTransientWindow");
	RealizeChildClass(wx_TipWindow,							"TipWindow",						wx_PopupTransientWindow);
	RealizeBaseClass (wx_ToolBarBase,						"ToolBarBase");
	RealizeChildClass(wx_ToolBar,							"ToolBar",							wx_ToolBarBase);
	RealizeBaseClass (wx_BookCtrlBaseEvent,					"BookCtrlBaseEvent");
	RealizeChildClass(wx_TreebookEvent,						"TreebookEvent",					wx_BookCtrlBaseEvent);
	RealizeBaseClass (wx_TreeItemId,						"TreeItemId");
	RealizeBaseClass (wx_WindowUpdateLocker,				"WindowUpdateLocker");
	RealizeBaseClass (wx_WindowDisabler,					"WindowDisabler");
	RealizeBaseClass (wx_XmlNode,							"XmlNode");
	RealizeBaseClass (wx_XmlProperty,						"XmlProperty");
	RealizeBaseClass (wx_ZipNotifier,						"ZipNotifier");
	RealizeBaseClass (wx_NativeEncodingInfo,				"NativeEncodingInfo");
	RealizeBaseClass (wx_FileTypeInfo,						"FileTypeInfo");
	RealizeBaseClass (wx_ArchiveNotifier,					"ArchiveNotifier");
	RealizeBaseClass (wx_ArtClient,							"ArtClient");
	RealizeBaseClass (wx_AppConsole,						"AppConsole");
	RealizeBaseClass (wx_GridCellCoords,					"GridCellCoords");
	RealizeBaseClass (wx_GridCellAttrProvider,				"GridCellAttrProvider");
	RealizeBaseClass (wx_PageSetupData,						"PageSetupData");
	RealizeBaseClass (wx_ToolBarToolBase,					"ToolBarToolBase");
	RealizeBaseClass (wx_HtmlWindowInterface,				"HtmlWindowInterface");
	RealizeBaseClass (wx_HtmlTagsCache,						"HtmlTagsCache");
	RealizeBaseClass (wx_HtmlEntitiesParser,				"HtmlEntitiesParser");
	RealizeBaseClass (wx_RichTextObject,					"RichTextObject");
	RealizeBaseClass (wx_RichTextImageBlock,				"RichTextImageBlock");
	RealizeBaseClass (wx_RichTextRenderer,					"RichTextRenderer");
	RealizeBaseClass (wx_RichTextAction,					"RichTextAction");
	// Prepare classes
	PrepareClass(wx_AboutDialogInfo);
	PrepareClass(wx_AcceleratorEntry);
	PrepareClass(wx_AppTraits);
	PrepareClass(wx_AuiDockArt);
	PrepareClass(wx_AuiTabArt);
	PrepareClass(wx_AuiPaneInfo);
	PrepareClass(wx_List);
	PrepareClass(wx_BusyCursor);
	PrepareClass(wx_BusyInfo);
	PrepareClass(wx_CalendarDateAttr);
	PrepareClass(wx_Caret);
	PrepareClass(wx_BookCtrlBase);
	PrepareClass(wx_Choicebook);
	PrepareClass(wx_Toolbook);
	PrepareClass(wx_Treebook);
	PrepareClass(wx_ClassInfo);
	PrepareClass(wx_ClientBase);
	PrepareClass(wx_Client);
	PrepareClass(wx_DDEClient);
	PrepareClass(wx_TCPClient);
	PrepareClass(wx_ClientData);
	PrepareClass(wx_StringClientData);
	PrepareClass(wx_TreeItemData);
	PrepareClass(wx_ClientDataContainer);
	PrepareClass(wx_CmdLineParser);
	PrepareClass(wx_ColourDatabase);
	PrepareClass(wx_ComboPopup);
	PrepareClass(wx_Condition);
	PrepareClass(wx_ConfigBase);
	PrepareClass(wx_FileConfig);
	PrepareClass(wx_ConnectionBase);
	PrepareClass(wx_Connection);
	PrepareClass(wx_DDEConnection);
	PrepareClass(wx_TCPConnection);
	PrepareClass(wx_CriticalSection);
	PrepareClass(wx_CriticalSectionLocker);
	PrepareClass(wx_DataFormat);
	PrepareClass(wx_DataInputStream);
	PrepareClass(wx_DataObject);
	PrepareClass(wx_DataObjectComposite);
	PrepareClass(wx_URLDataObject);
	PrepareClass(wx_DataObjectSimple);
	PrepareClass(wx_BitmapDataObject);
	PrepareClass(wx_CustomDataObject);
	PrepareClass(wx_FileDataObject);
	PrepareClass(wx_TextDataObject);
	PrepareClass(wx_DataOutputStream);
	PrepareClass(wx_DateSpan);
	PrepareClass(wx_DateTime);
	PrepareClass(wx_DateTimeHolidayAuthority);
	PrepareClass(wx_DateTimeWorkDays);
	PrepareClass(wx_DCClipper);
	PrepareClass(wx_ServerBase);
	PrepareClass(wx_DDEServer);
	PrepareClass(wx_Server);
	PrepareClass(wx_TCPServer);
	PrepareClass(wx_DebugReport);
	PrepareClass(wx_DebugReportCompress);
	PrepareClass(wx_DebugReportUpload);
	PrepareClass(wx_DebugReportPreview);
	PrepareClass(wx_DebugReportPreviewStd);
	PrepareClass(wx_DialUpManager);
	PrepareClass(wx_Dir);
	PrepareClass(wx_DirTraverser);
	PrepareClass(wx_Display);
	PrepareClass(wx_DropSource);
	PrepareClass(wx_DropTarget);
	PrepareClass(wx_FileDropTarget);
	PrepareClass(wx_TextDropTarget);
	PrepareClass(wx_DynamicLibrary);
	PrepareClass(wx_DynamicLibraryDetails);
	PrepareClass(wx_FFile);
	PrepareClass(wx_File);
	PrepareClass(wx_FileName);
	PrepareClass(wx_FileType);
	PrepareClass(wx_FontEnumerator);
	PrepareClass(wx_FontMapper);
	PrepareClass(wx_GBPosition);
	PrepareClass(wx_GBSpan);
	PrepareClass(wx_GridCellAttr);
	PrepareClass(wx_GridCellWorker);
	PrepareClass(wx_GridCellEditor);
	PrepareClass(wx_GridCellBoolEditor);
	PrepareClass(wx_GridCellChoiceEditor);
	PrepareClass(wx_GridCellTextEditor);
	PrepareClass(wx_GridCellFloatEditor);
	PrepareClass(wx_GridCellNumberEditor);
	PrepareClass(wx_GridCellRenderer);
	PrepareClass(wx_GridCellBoolRenderer);
	PrepareClass(wx_GridCellStringRenderer);
	PrepareClass(wx_GridCellFloatRenderer);
	PrepareClass(wx_GridCellNumberRenderer);
	PrepareClass(wx_HelpControllerBase);
	PrepareClass(wx_HelpController);
	PrepareClass(wx_HtmlHelpController);
	PrepareClass(wx_HelpProvider);
	PrepareClass(wx_SimpleHelpProvider);
	PrepareClass(wx_HelpControllerHelpProvider);
	PrepareClass(wx_HtmlModalHelp);
	PrepareClass(wx_IconBundle);
	PrepareClass(wx_IconLocation);
	PrepareClass(wx_ListItemAttr);
	PrepareClass(wx_Locale);
	PrepareClass(wx_Log);
	PrepareClass(wx_LogChain);
	PrepareClass(wx_LogPassThrough);
	PrepareClass(wx_LogWindow);
	PrepareClass(wx_LogGui);
	PrepareClass(wx_LogStderr);
	PrepareClass(wx_LogTextCtrl);
	PrepareClass(wx_LongLong);
	PrepareClass(wx_MBConv);
	PrepareClass(wx_CSConv);
	PrepareClass(wx_MBConvUTF7);
	PrepareClass(wx_MBConvUTF8);
	PrepareClass(wx_MBConvUTF16);
	PrepareClass(wx_MBConvUTF32);
	PrepareClass(wx_MemoryBuffer);
	PrepareClass(wx_MimeTypesManager);
	PrepareClass(wx_Mutex);
	PrepareClass(wx_MutexLocker);
	PrepareClass(wx_Node);
	PrepareClass(wx_Object);
	PrepareClass(wx_AcceleratorTable);
	PrepareClass(wx_ArchiveClassFactory);
	PrepareClass(wx_TarClassFactory);
	PrepareClass(wx_ZipClassFactory);
	PrepareClass(wx_ArchiveEntry);
	PrepareClass(wx_TarEntry);
	PrepareClass(wx_ZipEntry);
	PrepareClass(wx_ArtProvider);
	PrepareClass(wx_AutomationObject);
	PrepareClass(wx_BitmapHandler);
	PrepareClass(wx_Clipboard);
	PrepareClass(wx_Colour);
	PrepareClass(wx_ColourData);
	PrepareClass(wx_Command);
	PrepareClass(wx_CommandProcessor);
	PrepareClass(wx_ContextHelp);
	PrepareClass(wx_DataViewColumn);
	PrepareClass(wx_DataViewListModelNotifier);
	PrepareClass(wx_DataViewModel);
	PrepareClass(wx_DataViewListModel);
	PrepareClass(wx_DataViewSortedListModel);
	PrepareClass(wx_DataViewRenderer);
	PrepareClass(wx_DataViewTextRenderer);
	PrepareClass(wx_DataViewProgressRenderer);
	PrepareClass(wx_DataViewToggleRenderer);
	PrepareClass(wx_DataViewBitmapRenderer);
	PrepareClass(wx_DataViewDateRenderer);
	PrepareClass(wx_DataViewCustomRenderer);
	PrepareClass(wx_DC);
	PrepareClass(wx_MemoryDC);
	PrepareClass(wx_BufferedDC);
	PrepareClass(wx_BufferedPaintDC);
	PrepareClass(wx_AutoBufferedPaintDC);
	PrepareClass(wx_MetafileDC);
	PrepareClass(wx_MirrorDC);
	PrepareClass(wx_PrinterDC);
	PrepareClass(wx_ScreenDC);
	PrepareClass(wx_WindowDC);
	PrepareClass(wx_ClientDC);
	PrepareClass(wx_PaintDC);
	PrepareClass(wx_DocTemplate);
	PrepareClass(wx_DragImage);
	PrepareClass(wx_EncodingConverter);
	PrepareClass(wx_Event);
	PrepareClass(wx_ActivateEvent);
	PrepareClass(wx_CalculateLayoutEvent);
	PrepareClass(wx_CloseEvent);
	PrepareClass(wx_CommandEvent);
	PrepareClass(wx_ActiveXEvent);
	PrepareClass(wx_ClipboardTextEvent);
	PrepareClass(wx_CollapsiblePaneEvent);
	PrepareClass(wx_ColourPickerEvent);
	PrepareClass(wx_ChildFocusEvent);
	PrepareClass(wx_ContextMenuEvent);
	PrepareClass(wx_DateEvent);
	PrepareClass(wx_CalendarEvent);
	PrepareClass(wx_FileDirPickerEvent);
	PrepareClass(wx_FindDialogEvent);
	PrepareClass(wx_FontPickerEvent);
	PrepareClass(wx_HelpEvent);
	PrepareClass(wx_HtmlLinkEvent);
	PrepareClass(wx_HtmlCellEvent);
	PrepareClass(wx_HyperlinkEvent);
	PrepareClass(wx_NotifyEvent);
	PrepareClass(wx_DataViewEvent);
	PrepareClass(wx_GridEvent);
	PrepareClass(wx_GridRangeSelectEvent);
	PrepareClass(wx_GridSizeEvent);
	PrepareClass(wx_ListEvent);
	PrepareClass(wx_MediaEvent);
	PrepareClass(wx_NotebookEvent);
	PrepareClass(wx_RichTextEvent);
	PrepareClass(wx_SpinEvent);
	PrepareClass(wx_SplitterEvent);
	PrepareClass(wx_TreeEvent);
	PrepareClass(wx_WizardEvent);
	PrepareClass(wx_SashEvent);
	PrepareClass(wx_ScrollEvent);
	PrepareClass(wx_UpdateUIEvent);
	PrepareClass(wx_WindowCreateEvent);
	PrepareClass(wx_WindowDestroyEvent);
	PrepareClass(wx_DialUpEvent);
	PrepareClass(wx_DropFilesEvent);
	PrepareClass(wx_EraseEvent);
	PrepareClass(wx_FocusEvent);
	PrepareClass(wx_GridEditorCreatedEvent);
	PrepareClass(wx_IconizeEvent);
	PrepareClass(wx_IdleEvent);
	PrepareClass(wx_InitDialogEvent);
	PrepareClass(wx_JoystickEvent);
	PrepareClass(wx_KeyEvent);
	PrepareClass(wx_MaximizeEvent);
	PrepareClass(wx_MenuEvent);
	PrepareClass(wx_MouseCaptureChangedEvent);
	PrepareClass(wx_MouseCaptureLostEvent);
	PrepareClass(wx_MouseEvent);
	PrepareClass(wx_MoveEvent);
	PrepareClass(wx_PaintEvent);
	PrepareClass(wx_PowerEvent);
	PrepareClass(wx_ProcessEvent);
	PrepareClass(wx_QueryLayoutInfoEvent);
	PrepareClass(wx_ScrollWinEvent);
	PrepareClass(wx_SetCursorEvent);
	PrepareClass(wx_SizeEvent);
	PrepareClass(wx_SocketEvent);
	PrepareClass(wx_SysColourChangedEvent);
	PrepareClass(wx_TimerEvent);
	PrepareClass(wx_EvtHandler);
	PrepareClass(wx_App);
	PrepareClass(wx_AuiManager);
	PrepareClass(wx_DocManager);
	PrepareClass(wx_Document);
	PrepareClass(wx_Menu);
	PrepareClass(wx_Process);
	PrepareClass(wx_TaskBarIcon);
	PrepareClass(wx_Timer);
	PrepareClass(wx_Validator);
	PrepareClass(wx_GenericValidator);
	PrepareClass(wx_TextValidator);
	PrepareClass(wx_View);
	PrepareClass(wx_Window);
	PrepareClass(wx_ActiveXContainer);
	PrepareClass(wx_Control);
	PrepareClass(wx_AnimationCtrl);
	PrepareClass(wx_AuiNotebook);
	PrepareClass(wx_Button);
	PrepareClass(wx_BitmapButton);
	PrepareClass(wx_ContextHelpButton);
	PrepareClass(wx_CalendarCtrl);
	PrepareClass(wx_CheckBox);
	PrepareClass(wx_CollapsiblePane);
	PrepareClass(wx_ComboCtrl);
	PrepareClass(wx_OwnerDrawnComboBox);
	PrepareClass(wx_BitmapComboBox);
	PrepareClass(wx_RichTextStyleComboCtrl);
	PrepareClass(wx_ControlWithItems);
	PrepareClass(wx_Choice);
	PrepareClass(wx_ComboBox);
	PrepareClass(wx_ListBox);
	PrepareClass(wx_CheckListBox);
	PrepareClass(wx_DataViewCtrl);
	PrepareClass(wx_DatePickerCtrl);
	PrepareClass(wx_Gauge);
	PrepareClass(wx_GenericDirCtrl);
	PrepareClass(wx_HyperlinkCtrl);
	PrepareClass(wx_Listbook);
	PrepareClass(wx_ListCtrl);
	PrepareClass(wx_ListView);
	PrepareClass(wx_MediaCtrl);
	PrepareClass(wx_Notebook);
	PrepareClass(wx_PickerBase);
	PrepareClass(wx_ColourPickerCtrl);
	PrepareClass(wx_DirPickerCtrl);
	PrepareClass(wx_FilePickerCtrl);
	PrepareClass(wx_FontPickerCtrl);
	PrepareClass(wx_RadioBox);
	PrepareClass(wx_RadioButton);
	PrepareClass(wx_RichTextStyleListCtrl);
	PrepareClass(wx_ScrollBar);
	PrepareClass(wx_Slider);
	PrepareClass(wx_SpinButton);
	PrepareClass(wx_SpinCtrl);
	PrepareClass(wx_StaticBitmap);
	PrepareClass(wx_StaticBox);
	PrepareClass(wx_StaticLine);
	PrepareClass(wx_StaticText);
	PrepareClass(wx_TextCtrl);
	PrepareClass(wx_ToggleButton);
	PrepareClass(wx_TreeCtrl);
	PrepareClass(wx_HtmlHelpDialog);
	PrepareClass(wx_HtmlHelpWindow);
	PrepareClass(wx_MDIClientWindow);
	PrepareClass(wx_MenuBar);
	PrepareClass(wx_Panel);
	PrepareClass(wx_PreviewControlBar);
	PrepareClass(wx_ScrolledWindow);
	PrepareClass(wx_Grid);
	PrepareClass(wx_HtmlWindow);
	PrepareClass(wx_PreviewCanvas);
	PrepareClass(wx_VScrolledWindow);
	PrepareClass(wx_VListBox);
	PrepareClass(wx_HtmlListBox);
	PrepareClass(wx_SimpleHtmlListBox);
	PrepareClass(wx_RichTextStyleListBox);
	PrepareClass(wx_WizardPage);
	PrepareClass(wx_WizardPageSimple);
	PrepareClass(wx_SashWindow);
	PrepareClass(wx_SashLayoutWindow);
	PrepareClass(wx_SearchCtrl);
	PrepareClass(wx_SplitterWindow);
	PrepareClass(wx_StatusBar);
	PrepareClass(wx_TopLevelWindow);
	PrepareClass(wx_Dialog);
	PrepareClass(wx_ColourDialog);
	PrepareClass(wx_DirDialog);
	PrepareClass(wx_FileDialog);
	PrepareClass(wx_FindReplaceDialog);
	PrepareClass(wx_FontDialog);
	PrepareClass(wx_MessageDialog);
	PrepareClass(wx_MultiChoiceDialog);
	PrepareClass(wx_ProgressDialog);
	PrepareClass(wx_PropertySheetDialog);
	PrepareClass(wx_RichTextFormattingDialog);
	PrepareClass(wx_RichTextStyleOrganiserDialog);
	PrepareClass(wx_SingleChoiceDialog);
	PrepareClass(wx_SymbolPickerDialog);
	PrepareClass(wx_TextEntryDialog);
	PrepareClass(wx_PasswordEntryDialog);
	PrepareClass(wx_Wizard);
	PrepareClass(wx_Frame);
	PrepareClass(wx_DocChildFrame);
	PrepareClass(wx_DocParentFrame);
	PrepareClass(wx_HtmlHelpFrame);
	PrepareClass(wx_MDIChildFrame);
	PrepareClass(wx_DocMDIChildFrame);
	PrepareClass(wx_MDIParentFrame);
	PrepareClass(wx_DocMDIParentFrame);
	PrepareClass(wx_MiniFrame);
	PrepareClass(wx_PreviewFrame);
	PrepareClass(wx_SplashScreen);
	PrepareClass(wx_FileHistory);
	PrepareClass(wx_FileSystem);
	PrepareClass(wx_FileSystemHandler);
	PrepareClass(wx_MemoryFSHandler);
	PrepareClass(wx_FilterClassFactory);
	PrepareClass(wx_FindReplaceData);
	PrepareClass(wx_FontData);
	PrepareClass(wx_FSFile);
	PrepareClass(wx_GDIObject);
	PrepareClass(wx_Animation);
	PrepareClass(wx_Bitmap);
	PrepareClass(wx_Brush);
	PrepareClass(wx_Cursor);
	PrepareClass(wx_Font);
	PrepareClass(wx_Icon);
	PrepareClass(wx_Palette);
	PrepareClass(wx_Pen);
	PrepareClass(wx_Region);
	PrepareClass(wx_GridTableBase);
	PrepareClass(wx_HashTable);
	PrepareClass(wx_HtmlCell);
	PrepareClass(wx_HtmlColourCell);
	PrepareClass(wx_HtmlContainerCell);
	PrepareClass(wx_HtmlWidgetCell);
	PrepareClass(wx_HtmlDCRenderer);
	PrepareClass(wx_HtmlEasyPrinting);
	PrepareClass(wx_HtmlFilter);
	PrepareClass(wx_HtmlHelpData);
	PrepareClass(wx_HtmlLinkInfo);
	PrepareClass(wx_HtmlParser);
	PrepareClass(wx_HtmlWinParser);
	PrepareClass(wx_HtmlTag);
	PrepareClass(wx_HtmlTagHandler);
	PrepareClass(wx_HtmlWinTagHandler);
	PrepareClass(wx_Image);
	PrepareClass(wx_ImageHandler);
	PrepareClass(wx_ImageList);
	PrepareClass(wx_IndividualLayoutConstraint);
	PrepareClass(wx_Joystick);
	PrepareClass(wx_LayoutAlgorithm);
	PrepareClass(wx_LayoutConstraints);
	PrepareClass(wx_ListItem);
	PrepareClass(wx_Mask);
	PrepareClass(wx_MenuItem);
	PrepareClass(wx_Metafile);
	PrepareClass(wx_Module);
	PrepareClass(wx_HtmlTagsModule);
	PrepareClass(wx_PageSetupDialog);
	PrepareClass(wx_PageSetupDialogData);
	PrepareClass(wx_PrintData);
	PrepareClass(wx_PrintDialog);
	PrepareClass(wx_PrintDialogData);
	PrepareClass(wx_Printer);
	PrepareClass(wx_Printout);
	PrepareClass(wx_HtmlPrintout);
	PrepareClass(wx_RichTextPrintout);
	PrepareClass(wx_PrintPreview);
	PrepareClass(wx_Quantize);
	PrepareClass(wx_RegionIterator);
	PrepareClass(wx_RichTextFileHandler);
	PrepareClass(wx_RichTextHTMLHandler);
	PrepareClass(wx_RichTextXMLHandler);
	PrepareClass(wx_RichTextFormattingDialogFactory);
	PrepareClass(wx_RichTextHeaderFooterData);
	PrepareClass(wx_RichTextPrinting);
	PrepareClass(wx_RichTextStyleDefinition);
	PrepareClass(wx_RichTextCharacterStyleDefinition);
	PrepareClass(wx_RichTextParagraphStyleDefinition);
	PrepareClass(wx_RichTextListStyleDefinition);
	PrepareClass(wx_RichTextStyleSheet);
	PrepareClass(wx_Sizer);
	PrepareClass(wx_BoxSizer);
	PrepareClass(wx_StaticBoxSizer);
	PrepareClass(wx_StdDialogButtonSizer);
	PrepareClass(wx_GridSizer);
	PrepareClass(wx_FlexGridSizer);
	PrepareClass(wx_GridBagSizer);
	PrepareClass(wx_SizerItem);
	PrepareClass(wx_GBSizerItem);
	PrepareClass(wx_SockAddress);
	PrepareClass(wx_IPaddress);
	PrepareClass(wx_IPV4address);
	PrepareClass(wx_SocketBase);
	PrepareClass(wx_DatagramSocket);
	PrepareClass(wx_SocketClient);
	PrepareClass(wx_Protocol);
	PrepareClass(wx_FTP);
	PrepareClass(wx_HTTP);
	PrepareClass(wx_SocketServer);
	PrepareClass(wx_Sound);
	PrepareClass(wx_StringTokenizer);
	PrepareClass(wx_SystemOptions);
	PrepareClass(wx_ToolTip);
	PrepareClass(wx_URI);
	PrepareClass(wx_URL);
	PrepareClass(wx_Variant);
	PrepareClass(wx_VariantData);
	PrepareClass(wx_XmlDocument);
	PrepareClass(wx_XmlResource);
	PrepareClass(wx_XmlResourceHandler);
	PrepareClass(wx_ObjectRefData);
	PrepareClass(wx_PenList);
	PrepareClass(wx_PlatformInfo);
	PrepareClass(wx_Point);
	PrepareClass(wx_RealPoint);
	PrepareClass(wx_Rect);
	PrepareClass(wx_RecursionGuard);
	PrepareClass(wx_RegEx);
	PrepareClass(wx_RegKey);
	PrepareClass(wx_RendererNative);
	PrepareClass(wx_DelegateRendererNative);
	PrepareClass(wx_RendererVersion);
	PrepareClass(wx_RichTextAttr);
	PrepareClass(wx_RichTextParagraphLayoutBox);
	PrepareClass(wx_RichTextBuffer);
	PrepareClass(wx_TextCtrlBase);
	PrepareClass(wx_RichTextCtrl);
	PrepareClass(wx_RichTextRange);
	PrepareClass(wx_Semaphore);
	PrepareClass(wx_SingleInstanceChecker);
	PrepareClass(wx_Size);
	PrepareClass(wx_SizerFlags);
	PrepareClass(wx_SplitterRenderParams);
	PrepareClass(wx_StackFrame);
	PrepareClass(wx_StackWalker);
	PrepareClass(wx_StandardPaths);
	PrepareClass(wx_StopWatch);
	PrepareClass(wx_StreamBase);
	PrepareClass(wx_InputStream);
	PrepareClass(wx_FFileInputStream);
	PrepareClass(wx_FileInputStream);
	PrepareClass(wx_FilterInputStream);
	PrepareClass(wx_ArchiveInputStream);
	PrepareClass(wx_TarInputStream);
	PrepareClass(wx_ZipInputStream);
	PrepareClass(wx_BufferedInputStream);
	PrepareClass(wx_MemoryInputStream);
	PrepareClass(wx_SocketInputStream);
	PrepareClass(wx_StringInputStream);
	PrepareClass(wx_OutputStream);
	PrepareClass(wx_CountingOutputStream);
	PrepareClass(wx_FFileOutputStream);
	PrepareClass(wx_FFileStream);
	PrepareClass(wx_FileOutputStream);
	PrepareClass(wx_FileStream);
	PrepareClass(wx_FilterOutputStream);
	PrepareClass(wx_BufferedOutputStream);
	PrepareClass(wx_MemoryOutputStream);
	PrepareClass(wx_SocketOutputStream);
	PrepareClass(wx_StringOutputStream);
	PrepareClass(wx_TempFileOutputStream);
	PrepareClass(wx_StreamBuffer);
	PrepareClass(wx_String);
	PrepareClass(wx_StringBuffer);
	PrepareClass(wx_StringBufferLength);
	PrepareClass(wx_SystemSettings);
	PrepareClass(wx_ArchiveOutputStream);
	PrepareClass(wx_TarOutputStream);
	PrepareClass(wx_ZipOutputStream);
	PrepareClass(wx_TempFile);
	PrepareClass(wx_TextAttr);
	PrepareClass(wx_TextAttrEx);
	PrepareClass(wx_TextFile);
	PrepareClass(wx_TextInputStream);
	PrepareClass(wx_TextOutputStream);
	PrepareClass(wx_Thread);
	PrepareClass(wx_ThreadHelper);
	PrepareClass(wx_TimeSpan);
	PrepareClass(wx_TipProvider);
	PrepareClass(wx_PopupTransientWindow);
	PrepareClass(wx_TipWindow);
	PrepareClass(wx_ToolBarBase);
	PrepareClass(wx_ToolBar);
	PrepareClass(wx_BookCtrlBaseEvent);
	PrepareClass(wx_TreebookEvent);
	PrepareClass(wx_TreeItemId);
	PrepareClass(wx_WindowUpdateLocker);
	PrepareClass(wx_WindowDisabler);
	PrepareClass(wx_XmlNode);
	PrepareClass(wx_XmlProperty);
	PrepareClass(wx_ZipNotifier);
	PrepareClass(wx_NativeEncodingInfo);
	PrepareClass(wx_FileTypeInfo);
	PrepareClass(wx_ArchiveNotifier);
	PrepareClass(wx_ArtClient);
	PrepareClass(wx_AppConsole);
	PrepareClass(wx_GridCellCoords);
	PrepareClass(wx_GridCellAttrProvider);
	PrepareClass(wx_PageSetupData);
	PrepareClass(wx_ToolBarToolBase);
	PrepareClass(wx_HtmlWindowInterface);
	PrepareClass(wx_HtmlTagsCache);
	PrepareClass(wx_HtmlEntitiesParser);
	PrepareClass(wx_RichTextObject);
	PrepareClass(wx_RichTextImageBlock);
	PrepareClass(wx_RichTextRenderer);
	PrepareClass(wx_RichTextAction);
	// Initialize classes
	InitializeClass(wx_AboutDialogInfo);
	InitializeClass(wx_AcceleratorEntry);
	InitializeClass(wx_AppTraits);
	InitializeClass(wx_AuiDockArt);
	InitializeClass(wx_AuiTabArt);
	InitializeClass(wx_AuiPaneInfo);
	InitializeClass(wx_List);
	InitializeClass(wx_BusyCursor);
	InitializeClass(wx_BusyInfo);
	InitializeClass(wx_CalendarDateAttr);
	InitializeClass(wx_Caret);
	InitializeClass(wx_BookCtrlBase);
	InitializeClass(wx_Choicebook);
	InitializeClass(wx_Toolbook);
	InitializeClass(wx_Treebook);
	InitializeClass(wx_ClassInfo);
	InitializeClass(wx_ClientBase);
	InitializeClass(wx_Client);
	InitializeClass(wx_DDEClient);
	InitializeClass(wx_TCPClient);
	InitializeClass(wx_ClientData);
	InitializeClass(wx_StringClientData);
	InitializeClass(wx_TreeItemData);
	InitializeClass(wx_ClientDataContainer);
	InitializeClass(wx_CmdLineParser);
	InitializeClass(wx_ColourDatabase);
	InitializeClass(wx_ComboPopup);
	InitializeClass(wx_Condition);
	InitializeClass(wx_ConfigBase);
	InitializeClass(wx_FileConfig);
	InitializeClass(wx_ConnectionBase);
	InitializeClass(wx_Connection);
	InitializeClass(wx_DDEConnection);
	InitializeClass(wx_TCPConnection);
	InitializeClass(wx_CriticalSection);
	InitializeClass(wx_CriticalSectionLocker);
	InitializeClass(wx_DataFormat);
	InitializeClass(wx_DataInputStream);
	InitializeClass(wx_DataObject);
	InitializeClass(wx_DataObjectComposite);
	InitializeClass(wx_URLDataObject);
	InitializeClass(wx_DataObjectSimple);
	InitializeClass(wx_BitmapDataObject);
	InitializeClass(wx_CustomDataObject);
	InitializeClass(wx_FileDataObject);
	InitializeClass(wx_TextDataObject);
	InitializeClass(wx_DataOutputStream);
	InitializeClass(wx_DateSpan);
	InitializeClass(wx_DateTime);
	InitializeClass(wx_DateTimeHolidayAuthority);
	InitializeClass(wx_DateTimeWorkDays);
	InitializeClass(wx_DCClipper);
	InitializeClass(wx_ServerBase);
	InitializeClass(wx_DDEServer);
	InitializeClass(wx_Server);
	InitializeClass(wx_TCPServer);
	InitializeClass(wx_DebugReport);
	InitializeClass(wx_DebugReportCompress);
	InitializeClass(wx_DebugReportUpload);
	InitializeClass(wx_DebugReportPreview);
	InitializeClass(wx_DebugReportPreviewStd);
	InitializeClass(wx_DialUpManager);
	InitializeClass(wx_Dir);
	InitializeClass(wx_DirTraverser);
	InitializeClass(wx_Display);
	InitializeClass(wx_DropSource);
	InitializeClass(wx_DropTarget);
	InitializeClass(wx_FileDropTarget);
	InitializeClass(wx_TextDropTarget);
	InitializeClass(wx_DynamicLibrary);
	InitializeClass(wx_DynamicLibraryDetails);
	InitializeClass(wx_FFile);
	InitializeClass(wx_File);
	InitializeClass(wx_FileName);
	InitializeClass(wx_FileType);
	InitializeClass(wx_FontEnumerator);
	InitializeClass(wx_FontMapper);
	InitializeClass(wx_GBPosition);
	InitializeClass(wx_GBSpan);
	InitializeClass(wx_GridCellAttr);
	InitializeClass(wx_GridCellWorker);
	InitializeClass(wx_GridCellEditor);
	InitializeClass(wx_GridCellBoolEditor);
	InitializeClass(wx_GridCellChoiceEditor);
	InitializeClass(wx_GridCellTextEditor);
	InitializeClass(wx_GridCellFloatEditor);
	InitializeClass(wx_GridCellNumberEditor);
	InitializeClass(wx_GridCellRenderer);
	InitializeClass(wx_GridCellBoolRenderer);
	InitializeClass(wx_GridCellStringRenderer);
	InitializeClass(wx_GridCellFloatRenderer);
	InitializeClass(wx_GridCellNumberRenderer);
	InitializeClass(wx_HelpControllerBase);
	InitializeClass(wx_HelpController);
	InitializeClass(wx_HtmlHelpController);
	InitializeClass(wx_HelpProvider);
	InitializeClass(wx_SimpleHelpProvider);
	InitializeClass(wx_HelpControllerHelpProvider);
	InitializeClass(wx_HtmlModalHelp);
	InitializeClass(wx_IconBundle);
	InitializeClass(wx_IconLocation);
	InitializeClass(wx_ListItemAttr);
	InitializeClass(wx_Locale);
	InitializeClass(wx_Log);
	InitializeClass(wx_LogChain);
	InitializeClass(wx_LogPassThrough);
	InitializeClass(wx_LogWindow);
	InitializeClass(wx_LogGui);
	InitializeClass(wx_LogStderr);
	InitializeClass(wx_LogTextCtrl);
	InitializeClass(wx_LongLong);
	InitializeClass(wx_MBConv);
	InitializeClass(wx_CSConv);
	InitializeClass(wx_MBConvUTF7);
	InitializeClass(wx_MBConvUTF8);
	InitializeClass(wx_MBConvUTF16);
	InitializeClass(wx_MBConvUTF32);
	InitializeClass(wx_MemoryBuffer);
	InitializeClass(wx_MimeTypesManager);
	InitializeClass(wx_Mutex);
	InitializeClass(wx_MutexLocker);
	InitializeClass(wx_Node);
	InitializeClass(wx_Object);
	InitializeClass(wx_AcceleratorTable);
	InitializeClass(wx_ArchiveClassFactory);
	InitializeClass(wx_TarClassFactory);
	InitializeClass(wx_ZipClassFactory);
	InitializeClass(wx_ArchiveEntry);
	InitializeClass(wx_TarEntry);
	InitializeClass(wx_ZipEntry);
	InitializeClass(wx_ArtProvider);
	InitializeClass(wx_AutomationObject);
	InitializeClass(wx_BitmapHandler);
	InitializeClass(wx_Clipboard);
	InitializeClass(wx_Colour);
	InitializeClass(wx_ColourData);
	InitializeClass(wx_Command);
	InitializeClass(wx_CommandProcessor);
	InitializeClass(wx_ContextHelp);
	InitializeClass(wx_DataViewColumn);
	InitializeClass(wx_DataViewListModelNotifier);
	InitializeClass(wx_DataViewModel);
	InitializeClass(wx_DataViewListModel);
	InitializeClass(wx_DataViewSortedListModel);
	InitializeClass(wx_DataViewRenderer);
	InitializeClass(wx_DataViewTextRenderer);
	InitializeClass(wx_DataViewProgressRenderer);
	InitializeClass(wx_DataViewToggleRenderer);
	InitializeClass(wx_DataViewBitmapRenderer);
	InitializeClass(wx_DataViewDateRenderer);
	InitializeClass(wx_DataViewCustomRenderer);
	InitializeClass(wx_DC);
	InitializeClass(wx_MemoryDC);
	InitializeClass(wx_BufferedDC);
	InitializeClass(wx_BufferedPaintDC);
	InitializeClass(wx_AutoBufferedPaintDC);
	InitializeClass(wx_MetafileDC);
	InitializeClass(wx_MirrorDC);
	InitializeClass(wx_PrinterDC);
	InitializeClass(wx_ScreenDC);
	InitializeClass(wx_WindowDC);
	InitializeClass(wx_ClientDC);
	InitializeClass(wx_PaintDC);
	InitializeClass(wx_DocTemplate);
	InitializeClass(wx_DragImage);
	InitializeClass(wx_EncodingConverter);
	InitializeClass(wx_Event);
	InitializeClass(wx_ActivateEvent);
	InitializeClass(wx_CalculateLayoutEvent);
	InitializeClass(wx_CloseEvent);
	InitializeClass(wx_CommandEvent);
	InitializeClass(wx_ActiveXEvent);
	InitializeClass(wx_ClipboardTextEvent);
	InitializeClass(wx_CollapsiblePaneEvent);
	InitializeClass(wx_ColourPickerEvent);
	InitializeClass(wx_ChildFocusEvent);
	InitializeClass(wx_ContextMenuEvent);
	InitializeClass(wx_DateEvent);
	InitializeClass(wx_CalendarEvent);
	InitializeClass(wx_FileDirPickerEvent);
	InitializeClass(wx_FindDialogEvent);
	InitializeClass(wx_FontPickerEvent);
	InitializeClass(wx_HelpEvent);
	InitializeClass(wx_HtmlLinkEvent);
	InitializeClass(wx_HtmlCellEvent);
	InitializeClass(wx_HyperlinkEvent);
	InitializeClass(wx_NotifyEvent);
	InitializeClass(wx_DataViewEvent);
	InitializeClass(wx_GridEvent);
	InitializeClass(wx_GridRangeSelectEvent);
	InitializeClass(wx_GridSizeEvent);
	InitializeClass(wx_ListEvent);
	InitializeClass(wx_MediaEvent);
	InitializeClass(wx_NotebookEvent);
	InitializeClass(wx_RichTextEvent);
	InitializeClass(wx_SpinEvent);
	InitializeClass(wx_SplitterEvent);
	InitializeClass(wx_TreeEvent);
	InitializeClass(wx_WizardEvent);
	InitializeClass(wx_SashEvent);
	InitializeClass(wx_ScrollEvent);
	InitializeClass(wx_UpdateUIEvent);
	InitializeClass(wx_WindowCreateEvent);
	InitializeClass(wx_WindowDestroyEvent);
	InitializeClass(wx_DialUpEvent);
	InitializeClass(wx_DropFilesEvent);
	InitializeClass(wx_EraseEvent);
	InitializeClass(wx_FocusEvent);
	InitializeClass(wx_GridEditorCreatedEvent);
	InitializeClass(wx_IconizeEvent);
	InitializeClass(wx_IdleEvent);
	InitializeClass(wx_InitDialogEvent);
	InitializeClass(wx_JoystickEvent);
	InitializeClass(wx_KeyEvent);
	InitializeClass(wx_MaximizeEvent);
	InitializeClass(wx_MenuEvent);
	InitializeClass(wx_MouseCaptureChangedEvent);
	InitializeClass(wx_MouseCaptureLostEvent);
	InitializeClass(wx_MouseEvent);
	InitializeClass(wx_MoveEvent);
	InitializeClass(wx_PaintEvent);
	InitializeClass(wx_PowerEvent);
	InitializeClass(wx_ProcessEvent);
	InitializeClass(wx_QueryLayoutInfoEvent);
	InitializeClass(wx_ScrollWinEvent);
	InitializeClass(wx_SetCursorEvent);
	InitializeClass(wx_SizeEvent);
	InitializeClass(wx_SocketEvent);
	InitializeClass(wx_SysColourChangedEvent);
	InitializeClass(wx_TimerEvent);
	InitializeClass(wx_EvtHandler);
	InitializeClass(wx_App);
	InitializeClass(wx_AuiManager);
	InitializeClass(wx_DocManager);
	InitializeClass(wx_Document);
	InitializeClass(wx_Menu);
	InitializeClass(wx_Process);
	InitializeClass(wx_TaskBarIcon);
	InitializeClass(wx_Timer);
	InitializeClass(wx_Validator);
	InitializeClass(wx_GenericValidator);
	InitializeClass(wx_TextValidator);
	InitializeClass(wx_View);
	InitializeClass(wx_Window);
	InitializeClass(wx_ActiveXContainer);
	InitializeClass(wx_Control);
	InitializeClass(wx_AnimationCtrl);
	InitializeClass(wx_AuiNotebook);
	InitializeClass(wx_Button);
	InitializeClass(wx_BitmapButton);
	InitializeClass(wx_ContextHelpButton);
	InitializeClass(wx_CalendarCtrl);
	InitializeClass(wx_CheckBox);
	InitializeClass(wx_CollapsiblePane);
	InitializeClass(wx_ComboCtrl);
	InitializeClass(wx_OwnerDrawnComboBox);
	InitializeClass(wx_BitmapComboBox);
	InitializeClass(wx_RichTextStyleComboCtrl);
	InitializeClass(wx_ControlWithItems);
	InitializeClass(wx_Choice);
	InitializeClass(wx_ComboBox);
	InitializeClass(wx_ListBox);
	InitializeClass(wx_CheckListBox);
	InitializeClass(wx_DataViewCtrl);
	InitializeClass(wx_DatePickerCtrl);
	InitializeClass(wx_Gauge);
	InitializeClass(wx_GenericDirCtrl);
	InitializeClass(wx_HyperlinkCtrl);
	InitializeClass(wx_Listbook);
	InitializeClass(wx_ListCtrl);
	InitializeClass(wx_ListView);
	InitializeClass(wx_MediaCtrl);
	InitializeClass(wx_Notebook);
	InitializeClass(wx_PickerBase);
	InitializeClass(wx_ColourPickerCtrl);
	InitializeClass(wx_DirPickerCtrl);
	InitializeClass(wx_FilePickerCtrl);
	InitializeClass(wx_FontPickerCtrl);
	InitializeClass(wx_RadioBox);
	InitializeClass(wx_RadioButton);
	InitializeClass(wx_RichTextStyleListCtrl);
	InitializeClass(wx_ScrollBar);
	InitializeClass(wx_Slider);
	InitializeClass(wx_SpinButton);
	InitializeClass(wx_SpinCtrl);
	InitializeClass(wx_StaticBitmap);
	InitializeClass(wx_StaticBox);
	InitializeClass(wx_StaticLine);
	InitializeClass(wx_StaticText);
	InitializeClass(wx_TextCtrl);
	InitializeClass(wx_ToggleButton);
	InitializeClass(wx_TreeCtrl);
	InitializeClass(wx_HtmlHelpDialog);
	InitializeClass(wx_HtmlHelpWindow);
	InitializeClass(wx_MDIClientWindow);
	InitializeClass(wx_MenuBar);
	InitializeClass(wx_Panel);
	InitializeClass(wx_PreviewControlBar);
	InitializeClass(wx_ScrolledWindow);
	InitializeClass(wx_Grid);
	InitializeClass(wx_HtmlWindow);
	InitializeClass(wx_PreviewCanvas);
	InitializeClass(wx_VScrolledWindow);
	InitializeClass(wx_VListBox);
	InitializeClass(wx_HtmlListBox);
	InitializeClass(wx_SimpleHtmlListBox);
	InitializeClass(wx_RichTextStyleListBox);
	InitializeClass(wx_WizardPage);
	InitializeClass(wx_WizardPageSimple);
	InitializeClass(wx_SashWindow);
	InitializeClass(wx_SashLayoutWindow);
	InitializeClass(wx_SearchCtrl);
	InitializeClass(wx_SplitterWindow);
	InitializeClass(wx_StatusBar);
	InitializeClass(wx_TopLevelWindow);
	InitializeClass(wx_Dialog);
	InitializeClass(wx_ColourDialog);
	InitializeClass(wx_DirDialog);
	InitializeClass(wx_FileDialog);
	InitializeClass(wx_FindReplaceDialog);
	InitializeClass(wx_FontDialog);
	InitializeClass(wx_MessageDialog);
	InitializeClass(wx_MultiChoiceDialog);
	InitializeClass(wx_ProgressDialog);
	InitializeClass(wx_PropertySheetDialog);
	InitializeClass(wx_RichTextFormattingDialog);
	InitializeClass(wx_RichTextStyleOrganiserDialog);
	InitializeClass(wx_SingleChoiceDialog);
	InitializeClass(wx_SymbolPickerDialog);
	InitializeClass(wx_TextEntryDialog);
	InitializeClass(wx_PasswordEntryDialog);
	InitializeClass(wx_Wizard);
	InitializeClass(wx_Frame);
	InitializeClass(wx_DocChildFrame);
	InitializeClass(wx_DocParentFrame);
	InitializeClass(wx_HtmlHelpFrame);
	InitializeClass(wx_MDIChildFrame);
	InitializeClass(wx_DocMDIChildFrame);
	InitializeClass(wx_MDIParentFrame);
	InitializeClass(wx_DocMDIParentFrame);
	InitializeClass(wx_MiniFrame);
	InitializeClass(wx_PreviewFrame);
	InitializeClass(wx_SplashScreen);
	InitializeClass(wx_FileHistory);
	InitializeClass(wx_FileSystem);
	InitializeClass(wx_FileSystemHandler);
	InitializeClass(wx_MemoryFSHandler);
	InitializeClass(wx_FilterClassFactory);
	InitializeClass(wx_FindReplaceData);
	InitializeClass(wx_FontData);
	InitializeClass(wx_FSFile);
	InitializeClass(wx_GDIObject);
	InitializeClass(wx_Animation);
	InitializeClass(wx_Bitmap);
	InitializeClass(wx_Brush);
	InitializeClass(wx_Cursor);
	InitializeClass(wx_Font);
	InitializeClass(wx_Icon);
	InitializeClass(wx_Palette);
	InitializeClass(wx_Pen);
	InitializeClass(wx_Region);
	InitializeClass(wx_GridTableBase);
	InitializeClass(wx_HashTable);
	InitializeClass(wx_HtmlCell);
	InitializeClass(wx_HtmlColourCell);
	InitializeClass(wx_HtmlContainerCell);
	InitializeClass(wx_HtmlWidgetCell);
	InitializeClass(wx_HtmlDCRenderer);
	InitializeClass(wx_HtmlEasyPrinting);
	InitializeClass(wx_HtmlFilter);
	InitializeClass(wx_HtmlHelpData);
	InitializeClass(wx_HtmlLinkInfo);
	InitializeClass(wx_HtmlParser);
	InitializeClass(wx_HtmlWinParser);
	InitializeClass(wx_HtmlTag);
	InitializeClass(wx_HtmlTagHandler);
	InitializeClass(wx_HtmlWinTagHandler);
	InitializeClass(wx_Image);
	InitializeClass(wx_ImageHandler);
	InitializeClass(wx_ImageList);
	InitializeClass(wx_IndividualLayoutConstraint);
	InitializeClass(wx_Joystick);
	InitializeClass(wx_LayoutAlgorithm);
	InitializeClass(wx_LayoutConstraints);
	InitializeClass(wx_ListItem);
	InitializeClass(wx_Mask);
	InitializeClass(wx_MenuItem);
	InitializeClass(wx_Metafile);
	InitializeClass(wx_Module);
	InitializeClass(wx_HtmlTagsModule);
	InitializeClass(wx_PageSetupDialog);
	InitializeClass(wx_PageSetupDialogData);
	InitializeClass(wx_PrintData);
	InitializeClass(wx_PrintDialog);
	InitializeClass(wx_PrintDialogData);
	InitializeClass(wx_Printer);
	InitializeClass(wx_Printout);
	InitializeClass(wx_HtmlPrintout);
	InitializeClass(wx_RichTextPrintout);
	InitializeClass(wx_PrintPreview);
	InitializeClass(wx_Quantize);
	InitializeClass(wx_RegionIterator);
	InitializeClass(wx_RichTextFileHandler);
	InitializeClass(wx_RichTextHTMLHandler);
	InitializeClass(wx_RichTextXMLHandler);
	InitializeClass(wx_RichTextFormattingDialogFactory);
	InitializeClass(wx_RichTextHeaderFooterData);
	InitializeClass(wx_RichTextPrinting);
	InitializeClass(wx_RichTextStyleDefinition);
	InitializeClass(wx_RichTextCharacterStyleDefinition);
	InitializeClass(wx_RichTextParagraphStyleDefinition);
	InitializeClass(wx_RichTextListStyleDefinition);
	InitializeClass(wx_RichTextStyleSheet);
	InitializeClass(wx_Sizer);
	InitializeClass(wx_BoxSizer);
	InitializeClass(wx_StaticBoxSizer);
	InitializeClass(wx_StdDialogButtonSizer);
	InitializeClass(wx_GridSizer);
	InitializeClass(wx_FlexGridSizer);
	InitializeClass(wx_GridBagSizer);
	InitializeClass(wx_SizerItem);
	InitializeClass(wx_GBSizerItem);
	InitializeClass(wx_SockAddress);
	InitializeClass(wx_IPaddress);
	InitializeClass(wx_IPV4address);
	InitializeClass(wx_SocketBase);
	InitializeClass(wx_DatagramSocket);
	InitializeClass(wx_SocketClient);
	InitializeClass(wx_Protocol);
	InitializeClass(wx_FTP);
	InitializeClass(wx_HTTP);
	InitializeClass(wx_SocketServer);
	InitializeClass(wx_Sound);
	InitializeClass(wx_StringTokenizer);
	InitializeClass(wx_SystemOptions);
	InitializeClass(wx_ToolTip);
	InitializeClass(wx_URI);
	InitializeClass(wx_URL);
	InitializeClass(wx_Variant);
	InitializeClass(wx_VariantData);
	InitializeClass(wx_XmlDocument);
	InitializeClass(wx_XmlResource);
	InitializeClass(wx_XmlResourceHandler);
	InitializeClass(wx_ObjectRefData);
	InitializeClass(wx_PenList);
	InitializeClass(wx_PlatformInfo);
	InitializeClass(wx_Point);
	InitializeClass(wx_RealPoint);
	InitializeClass(wx_Rect);
	InitializeClass(wx_RecursionGuard);
	InitializeClass(wx_RegEx);
	InitializeClass(wx_RegKey);
	InitializeClass(wx_RendererNative);
	InitializeClass(wx_DelegateRendererNative);
	InitializeClass(wx_RendererVersion);
	InitializeClass(wx_RichTextAttr);
	InitializeClass(wx_RichTextParagraphLayoutBox);
	InitializeClass(wx_RichTextBuffer);
	InitializeClass(wx_TextCtrlBase);
	InitializeClass(wx_RichTextCtrl);
	InitializeClass(wx_RichTextRange);
	InitializeClass(wx_Semaphore);
	InitializeClass(wx_SingleInstanceChecker);
	InitializeClass(wx_Size);
	InitializeClass(wx_SizerFlags);
	InitializeClass(wx_SplitterRenderParams);
	InitializeClass(wx_StackFrame);
	InitializeClass(wx_StackWalker);
	InitializeClass(wx_StandardPaths);
	InitializeClass(wx_StopWatch);
	InitializeClass(wx_StreamBase);
	InitializeClass(wx_InputStream);
	InitializeClass(wx_FFileInputStream);
	InitializeClass(wx_FileInputStream);
	InitializeClass(wx_FilterInputStream);
	InitializeClass(wx_ArchiveInputStream);
	InitializeClass(wx_TarInputStream);
	InitializeClass(wx_ZipInputStream);
	InitializeClass(wx_BufferedInputStream);
	InitializeClass(wx_MemoryInputStream);
	InitializeClass(wx_SocketInputStream);
	InitializeClass(wx_StringInputStream);
	InitializeClass(wx_OutputStream);
	InitializeClass(wx_CountingOutputStream);
	InitializeClass(wx_FFileOutputStream);
	InitializeClass(wx_FFileStream);
	InitializeClass(wx_FileOutputStream);
	InitializeClass(wx_FileStream);
	InitializeClass(wx_FilterOutputStream);
	InitializeClass(wx_BufferedOutputStream);
	InitializeClass(wx_MemoryOutputStream);
	InitializeClass(wx_SocketOutputStream);
	InitializeClass(wx_StringOutputStream);
	InitializeClass(wx_TempFileOutputStream);
	InitializeClass(wx_StreamBuffer);
	InitializeClass(wx_String);
	InitializeClass(wx_StringBuffer);
	InitializeClass(wx_StringBufferLength);
	InitializeClass(wx_SystemSettings);
	InitializeClass(wx_ArchiveOutputStream);
	InitializeClass(wx_TarOutputStream);
	InitializeClass(wx_ZipOutputStream);
	InitializeClass(wx_TempFile);
	InitializeClass(wx_TextAttr);
	InitializeClass(wx_TextAttrEx);
	InitializeClass(wx_TextFile);
	InitializeClass(wx_TextInputStream);
	InitializeClass(wx_TextOutputStream);
	InitializeClass(wx_Thread);
	InitializeClass(wx_ThreadHelper);
	InitializeClass(wx_TimeSpan);
	InitializeClass(wx_TipProvider);
	InitializeClass(wx_PopupTransientWindow);
	InitializeClass(wx_TipWindow);
	InitializeClass(wx_ToolBarBase);
	InitializeClass(wx_ToolBar);
	InitializeClass(wx_BookCtrlBaseEvent);
	InitializeClass(wx_TreebookEvent);
	InitializeClass(wx_TreeItemId);
	InitializeClass(wx_WindowUpdateLocker);
	InitializeClass(wx_WindowDisabler);
	InitializeClass(wx_XmlNode);
	InitializeClass(wx_XmlProperty);
	InitializeClass(wx_ZipNotifier);
	InitializeClass(wx_NativeEncodingInfo);
	InitializeClass(wx_FileTypeInfo);
	InitializeClass(wx_ArchiveNotifier);
	InitializeClass(wx_ArtClient);
	InitializeClass(wx_AppConsole);
	InitializeClass(wx_GridCellCoords);
	InitializeClass(wx_GridCellAttrProvider);
	InitializeClass(wx_PageSetupData);
	InitializeClass(wx_ToolBarToolBase);
	InitializeClass(wx_HtmlWindowInterface);
	InitializeClass(wx_HtmlTagsCache);
	InitializeClass(wx_HtmlEntitiesParser);
	InitializeClass(wx_RichTextObject);
	InitializeClass(wx_RichTextImageBlock);
	InitializeClass(wx_RichTextRenderer);
	InitializeClass(wx_RichTextAction);
	// value assignments
	do {
		Gura_AssignWxValue(ID_ANY);
		Gura_AssignWxValue(ID_LOWEST);
		Gura_AssignWxValue(ID_OPEN);
		Gura_AssignWxValue(ID_CLOSE);
		Gura_AssignWxValue(ID_NEW);
		Gura_AssignWxValue(ID_SAVE);
		Gura_AssignWxValue(ID_SAVEAS);
		Gura_AssignWxValue(ID_REVERT);
		Gura_AssignWxValue(ID_EXIT);
		Gura_AssignWxValue(ID_UNDO);
		Gura_AssignWxValue(ID_REDO);
		Gura_AssignWxValue(ID_HELP);
		Gura_AssignWxValue(ID_PRINT);
		Gura_AssignWxValue(ID_PRINT_SETUP);
		Gura_AssignWxValue(ID_PAGE_SETUP);
		Gura_AssignWxValue(ID_PREVIEW);
		Gura_AssignWxValue(ID_ABOUT);
		Gura_AssignWxValue(ID_HELP_CONTENTS);
		Gura_AssignWxValue(ID_HELP_INDEX);
		Gura_AssignWxValue(ID_HELP_SEARCH);
		Gura_AssignWxValue(ID_HELP_COMMANDS);
		Gura_AssignWxValue(ID_HELP_PROCEDURES);
		Gura_AssignWxValue(ID_HELP_CONTEXT);
		Gura_AssignWxValue(ID_CLOSE_ALL);
		Gura_AssignWxValue(ID_EDIT);
		Gura_AssignWxValue(ID_CUT);
		Gura_AssignWxValue(ID_COPY);
		Gura_AssignWxValue(ID_PASTE);
		Gura_AssignWxValue(ID_CLEAR);
		Gura_AssignWxValue(ID_FIND);
		Gura_AssignWxValue(ID_DUPLICATE);
		Gura_AssignWxValue(ID_SELECTALL);
		Gura_AssignWxValue(ID_DELETE);
		Gura_AssignWxValue(ID_REPLACE);
		Gura_AssignWxValue(ID_REPLACE_ALL);
		Gura_AssignWxValue(ID_PROPERTIES);
		Gura_AssignWxValue(ID_VIEW_DETAILS);
		Gura_AssignWxValue(ID_VIEW_LARGEICONS);
		Gura_AssignWxValue(ID_VIEW_SMALLICONS);
		Gura_AssignWxValue(ID_VIEW_LIST);
		Gura_AssignWxValue(ID_VIEW_SORTDATE);
		Gura_AssignWxValue(ID_VIEW_SORTNAME);
		Gura_AssignWxValue(ID_VIEW_SORTSIZE);
		Gura_AssignWxValue(ID_VIEW_SORTTYPE);
		Gura_AssignWxValue(ID_FILE);
		Gura_AssignWxValue(ID_FILE1);
		Gura_AssignWxValue(ID_FILE2);
		Gura_AssignWxValue(ID_FILE3);
		Gura_AssignWxValue(ID_FILE4);
		Gura_AssignWxValue(ID_FILE5);
		Gura_AssignWxValue(ID_FILE6);
		Gura_AssignWxValue(ID_FILE7);
		Gura_AssignWxValue(ID_FILE8);
		Gura_AssignWxValue(ID_FILE9);
		// Standard button IDs
		Gura_AssignWxValue(ID_OK);
		Gura_AssignWxValue(ID_CANCEL);
		Gura_AssignWxValue(ID_APPLY);
		Gura_AssignWxValue(ID_YES);
		Gura_AssignWxValue(ID_NO);
		Gura_AssignWxValue(ID_STATIC);
		Gura_AssignWxValue(ID_FORWARD);
		Gura_AssignWxValue(ID_BACKWARD);
		Gura_AssignWxValue(ID_DEFAULT);
		Gura_AssignWxValue(ID_MORE);
		Gura_AssignWxValue(ID_SETUP);
		Gura_AssignWxValue(ID_RESET);
		Gura_AssignWxValue(ID_CONTEXT_HELP);
		Gura_AssignWxValue(ID_YESTOALL);
		Gura_AssignWxValue(ID_NOTOALL);
		Gura_AssignWxValue(ID_ABORT);
		Gura_AssignWxValue(ID_RETRY);
		Gura_AssignWxValue(ID_IGNORE);
		Gura_AssignWxValue(ID_UP);
		Gura_AssignWxValue(ID_DOWN);
		Gura_AssignWxValue(ID_HOME);
		Gura_AssignWxValue(ID_REFRESH);
		Gura_AssignWxValue(ID_STOP);
		Gura_AssignWxValue(ID_INDEX);
		Gura_AssignWxValue(ID_BOLD);
		Gura_AssignWxValue(ID_ITALIC);
		Gura_AssignWxValue(ID_JUSTIFY_CENTER);
		Gura_AssignWxValue(ID_JUSTIFY_FILL);
		Gura_AssignWxValue(ID_JUSTIFY_RIGHT);
		Gura_AssignWxValue(ID_JUSTIFY_LEFT);
		Gura_AssignWxValue(ID_UNDERLINE);
		Gura_AssignWxValue(ID_INDENT);
		Gura_AssignWxValue(ID_UNINDENT);
		Gura_AssignWxValue(ID_ZOOM_100);
		Gura_AssignWxValue(ID_ZOOM_FIT);
		Gura_AssignWxValue(ID_ZOOM_IN);
		Gura_AssignWxValue(ID_ZOOM_OUT);
		Gura_AssignWxValue(ID_UNDELETE);
		Gura_AssignWxValue(ID_REVERT_TO_SAVED);
		// System menu IDs (used by wxUniv):
		Gura_AssignWxValue(ID_SYSTEM_MENU);
		Gura_AssignWxValue(ID_CLOSE_FRAME);
		Gura_AssignWxValue(ID_MOVE_FRAME);
		Gura_AssignWxValue(ID_RESIZE_FRAME);
		Gura_AssignWxValue(ID_MAXIMIZE_FRAME);
		Gura_AssignWxValue(ID_ICONIZE_FRAME);
		Gura_AssignWxValue(ID_RESTORE_FRAME);
		// IDs used by generic file dialog (13 consecutive starting from this value)
		Gura_AssignWxValue(ID_FILEDLGG);
		Gura_AssignWxValue(ID_HIGHEST);
	} while (0);
	do {
		Gura_AssignMacroValue(WXK_BACK);
		Gura_AssignMacroValue(WXK_TAB);
		Gura_AssignMacroValue(WXK_RETURN);
		Gura_AssignMacroValue(WXK_ESCAPE);
		Gura_AssignMacroValue(WXK_SPACE);
		Gura_AssignMacroValue(WXK_DELETE);
		Gura_AssignMacroValue(WXK_START);
		Gura_AssignMacroValue(WXK_LBUTTON);
		Gura_AssignMacroValue(WXK_RBUTTON);
		Gura_AssignMacroValue(WXK_CANCEL);
		Gura_AssignMacroValue(WXK_MBUTTON);
		Gura_AssignMacroValue(WXK_CLEAR);
		Gura_AssignMacroValue(WXK_SHIFT);
		Gura_AssignMacroValue(WXK_ALT);
		Gura_AssignMacroValue(WXK_CONTROL);
		Gura_AssignMacroValue(WXK_MENU);
		Gura_AssignMacroValue(WXK_PAUSE);
		Gura_AssignMacroValue(WXK_CAPITAL);
		Gura_AssignMacroValue(WXK_END);
		Gura_AssignMacroValue(WXK_HOME);
		Gura_AssignMacroValue(WXK_LEFT);
		Gura_AssignMacroValue(WXK_UP);
		Gura_AssignMacroValue(WXK_RIGHT);
		Gura_AssignMacroValue(WXK_DOWN);
		Gura_AssignMacroValue(WXK_SELECT);
		Gura_AssignMacroValue(WXK_PRINT);
		Gura_AssignMacroValue(WXK_EXECUTE);
		Gura_AssignMacroValue(WXK_SNAPSHOT);
		Gura_AssignMacroValue(WXK_INSERT);
		Gura_AssignMacroValue(WXK_HELP);
		Gura_AssignMacroValue(WXK_NUMPAD0);
		Gura_AssignMacroValue(WXK_NUMPAD1);
		Gura_AssignMacroValue(WXK_NUMPAD2);
		Gura_AssignMacroValue(WXK_NUMPAD3);
		Gura_AssignMacroValue(WXK_NUMPAD4);
		Gura_AssignMacroValue(WXK_NUMPAD5);
		Gura_AssignMacroValue(WXK_NUMPAD6);
		Gura_AssignMacroValue(WXK_NUMPAD7);
		Gura_AssignMacroValue(WXK_NUMPAD8);
		Gura_AssignMacroValue(WXK_NUMPAD9);
		Gura_AssignMacroValue(WXK_MULTIPLY);
		Gura_AssignMacroValue(WXK_ADD);
		Gura_AssignMacroValue(WXK_SEPARATOR);
		Gura_AssignMacroValue(WXK_SUBTRACT);
		Gura_AssignMacroValue(WXK_DECIMAL);
		Gura_AssignMacroValue(WXK_DIVIDE);
		Gura_AssignMacroValue(WXK_F1);
		Gura_AssignMacroValue(WXK_F2);
		Gura_AssignMacroValue(WXK_F3);
		Gura_AssignMacroValue(WXK_F4);
		Gura_AssignMacroValue(WXK_F5);
		Gura_AssignMacroValue(WXK_F6);
		Gura_AssignMacroValue(WXK_F7);
		Gura_AssignMacroValue(WXK_F8);
		Gura_AssignMacroValue(WXK_F9);
		Gura_AssignMacroValue(WXK_F10);
		Gura_AssignMacroValue(WXK_F11);
		Gura_AssignMacroValue(WXK_F12);
		Gura_AssignMacroValue(WXK_F13);
		Gura_AssignMacroValue(WXK_F14);
		Gura_AssignMacroValue(WXK_F15);
		Gura_AssignMacroValue(WXK_F16);
		Gura_AssignMacroValue(WXK_F17);
		Gura_AssignMacroValue(WXK_F18);
		Gura_AssignMacroValue(WXK_F19);
		Gura_AssignMacroValue(WXK_F20);
		Gura_AssignMacroValue(WXK_F21);
		Gura_AssignMacroValue(WXK_F22);
		Gura_AssignMacroValue(WXK_F23);
		Gura_AssignMacroValue(WXK_F24);
		Gura_AssignMacroValue(WXK_NUMLOCK);
		Gura_AssignMacroValue(WXK_SCROLL);
		Gura_AssignMacroValue(WXK_PAGEUP);
		Gura_AssignMacroValue(WXK_PAGEDOWN);
		Gura_AssignMacroValue(WXK_NUMPAD_SPACE);
		Gura_AssignMacroValue(WXK_NUMPAD_TAB);
		Gura_AssignMacroValue(WXK_NUMPAD_ENTER);
		Gura_AssignMacroValue(WXK_NUMPAD_F1);
		Gura_AssignMacroValue(WXK_NUMPAD_F2);
		Gura_AssignMacroValue(WXK_NUMPAD_F3);
		Gura_AssignMacroValue(WXK_NUMPAD_F4);
		Gura_AssignMacroValue(WXK_NUMPAD_HOME);
		Gura_AssignMacroValue(WXK_NUMPAD_LEFT);
		Gura_AssignMacroValue(WXK_NUMPAD_UP);
		Gura_AssignMacroValue(WXK_NUMPAD_RIGHT);
		Gura_AssignMacroValue(WXK_NUMPAD_DOWN);
		Gura_AssignMacroValue(WXK_NUMPAD_PAGEUP);
		Gura_AssignMacroValue(WXK_NUMPAD_PAGEDOWN);
		Gura_AssignMacroValue(WXK_NUMPAD_END);
		Gura_AssignMacroValue(WXK_NUMPAD_BEGIN);
		Gura_AssignMacroValue(WXK_NUMPAD_INSERT);
		Gura_AssignMacroValue(WXK_NUMPAD_DELETE);
		Gura_AssignMacroValue(WXK_NUMPAD_EQUAL);
		Gura_AssignMacroValue(WXK_NUMPAD_MULTIPLY);
		Gura_AssignMacroValue(WXK_NUMPAD_ADD);
		Gura_AssignMacroValue(WXK_NUMPAD_SEPARATOR);
		Gura_AssignMacroValue(WXK_NUMPAD_SUBTRACT);
		Gura_AssignMacroValue(WXK_NUMPAD_DECIMAL);
		Gura_AssignMacroValue(WXK_NUMPAD_DIVIDE);
		Gura_AssignMacroValue(WXK_WINDOWS_LEFT);
		Gura_AssignMacroValue(WXK_WINDOWS_RIGHT);
		Gura_AssignMacroValue(WXK_WINDOWS_MENU);
		Gura_AssignMacroValue(WXK_COMMAND);
		Gura_AssignMacroValue(WXK_SPECIAL1);
		Gura_AssignMacroValue(WXK_SPECIAL2);
		Gura_AssignMacroValue(WXK_SPECIAL3);
		Gura_AssignMacroValue(WXK_SPECIAL4);
		Gura_AssignMacroValue(WXK_SPECIAL5);
		Gura_AssignMacroValue(WXK_SPECIAL6);
		Gura_AssignMacroValue(WXK_SPECIAL7);
		Gura_AssignMacroValue(WXK_SPECIAL8);
		Gura_AssignMacroValue(WXK_SPECIAL9);
		Gura_AssignMacroValue(WXK_SPECIAL10);
		Gura_AssignMacroValue(WXK_SPECIAL11);
		Gura_AssignMacroValue(WXK_SPECIAL12);
		Gura_AssignMacroValue(WXK_SPECIAL13);
		Gura_AssignMacroValue(WXK_SPECIAL14);
		Gura_AssignMacroValue(WXK_SPECIAL15);
		Gura_AssignMacroValue(WXK_SPECIAL16);
		Gura_AssignMacroValue(WXK_SPECIAL17);
		Gura_AssignMacroValue(WXK_SPECIAL18);
		Gura_AssignMacroValue(WXK_SPECIAL19);
		Gura_AssignMacroValue(WXK_SPECIAL20);
	} while (0);
	do {
		Gura_AssignWxValue(TOP);
		Gura_AssignWxValue(BOTTOM);
		Gura_AssignWxValue(LEFT);
		Gura_AssignWxValue(RIGHT);
		Gura_AssignWxValue(ALL);
		Gura_AssignWxValue(BOTH);
		Gura_AssignWxValue(VERTICAL);
		Gura_AssignWxValue(HORIZONTAL);
		Gura_AssignWxValue(BORDER_SIMPLE);
		Gura_AssignWxValue(BORDER_DOUBLE);
		Gura_AssignWxValue(MOUSE_BTN_LEFT);
		Gura_AssignWxValue(MOUSE_BTN_MIDDLE);
		Gura_AssignWxValue(MOUSE_BTN_RIGHT);
		Gura_AssignWxValue(MOUSE_BTN_ANY);
		Gura_AssignWxValue(NOT_FOUND);
	} while (0);
	// Styles for Pen and Brush
	do {
		Gura_AssignWxValue(SOLID);
		Gura_AssignWxValue(TRANSPARENT);
		Gura_AssignWxValue(DOT);
		Gura_AssignWxValue(LONG_DASH);
		Gura_AssignWxValue(SHORT_DASH);
		Gura_AssignWxValue(DOT_DASH);
		Gura_AssignWxValue(STIPPLE);
		Gura_AssignWxValue(USER_DASH);
		Gura_AssignWxValue(BDIAGONAL_HATCH);
		Gura_AssignWxValue(CROSSDIAG_HATCH);
		Gura_AssignWxValue(FDIAGONAL_HATCH);
		Gura_AssignWxValue(CROSS_HATCH);
		Gura_AssignWxValue(HORIZONTAL_HATCH);
		Gura_AssignWxValue(VERTICAL_HATCH);
	} while (0);
	// Fill style
	do {
		Gura_AssignWxValue(ODDEVEN_RULE);
		Gura_AssignWxValue(WINDING_RULE);
	} while (0);
	do {
		Gura_AssignWxValue(ACCEL_ALT);
		Gura_AssignWxValue(ACCEL_SHIFT);
		Gura_AssignWxValue(ACCEL_CTRL);
		Gura_AssignWxValue(ACCEL_NORMAL);
		Gura_AssignWxValue(BITMAP_TYPE_ICO);
		Gura_AssignWxValue(BITMAP_TYPE_ICO_RESOURCE);
		Gura_AssignWxValue(BITMAP_TYPE_GIF);
		Gura_AssignWxValue(BITMAP_TYPE_XBM);
		Gura_AssignWxValue(BITMAP_TYPE_XPM);
		Gura_AssignWxValue(CMD_LINE_SWITCH);
		Gura_AssignWxValue(CMD_LINE_OPTION);
		Gura_AssignWxValue(CMD_LINE_PARAM);
		Gura_AssignWxValue(CMD_LINE_NONE);
		Gura_AssignWxValue(CMD_LINE_VAL_STRING);
		Gura_AssignWxValue(CMD_LINE_VAL_NUMBER);
		Gura_AssignWxValue(CMD_LINE_VAL_DATE);
		Gura_AssignWxValue(CMD_LINE_VAL_NONE);
		Gura_AssignWxValue(CMD_LINE_OPTION_MANDATORY);
		Gura_AssignWxValue(CMD_LINE_PARAM_OPTIONAL);
		Gura_AssignWxValue(CMD_LINE_PARAM_MULTIPLE);
		Gura_AssignWxValue(CMD_LINE_OPTION_HELP);
		Gura_AssignWxValue(CMD_LINE_NEEDS_SEPARATOR);
		Gura_AssignWxValue(ALPHA_TRANSPARENT);
		Gura_AssignWxValue(ALPHA_OPAQUE);
		Gura_AssignWxValue(C2S_NAME);
		Gura_AssignWxValue(C2S_CSS_SYNTAX);
		Gura_AssignWxValue(C2S_HTML_SYNTAX);
		Gura_AssignWxValue(CURSOR_ARROW);
		Gura_AssignWxValue(CURSOR_RIGHT_ARROW);
		Gura_AssignWxValue(CURSOR_BLANK);
		Gura_AssignWxValue(CURSOR_BULLSEYE);
		Gura_AssignWxValue(CURSOR_CHAR);
		Gura_AssignWxValue(CURSOR_CROSS);
		Gura_AssignWxValue(CURSOR_HAND);
		Gura_AssignWxValue(CURSOR_IBEAM);
		Gura_AssignWxValue(CURSOR_LEFT_BUTTON);
		Gura_AssignWxValue(CURSOR_MAGNIFIER);
		Gura_AssignWxValue(CURSOR_MIDDLE_BUTTON);
		Gura_AssignWxValue(CURSOR_NO_ENTRY);
		Gura_AssignWxValue(CURSOR_PAINT_BRUSH);
		Gura_AssignWxValue(CURSOR_PENCIL);
		Gura_AssignWxValue(CURSOR_POINT_LEFT);
		Gura_AssignWxValue(CURSOR_POINT_RIGHT);
		Gura_AssignWxValue(CURSOR_QUESTION_ARROW);
		Gura_AssignWxValue(CURSOR_RIGHT_BUTTON);
		Gura_AssignWxValue(CURSOR_SIZENESW);
		Gura_AssignWxValue(CURSOR_SIZENS);
		Gura_AssignWxValue(CURSOR_SIZENWSE);
		Gura_AssignWxValue(CURSOR_SIZEWE);
		Gura_AssignWxValue(CURSOR_SIZING);
		Gura_AssignWxValue(CURSOR_SPRAYCAN);
		Gura_AssignWxValue(CURSOR_WAIT);
		Gura_AssignWxValue(CURSOR_WATCH);
		Gura_AssignWxValue(CURSOR_ARROWWAIT);
		Gura_AssignWxValue(DF_INVALID);
		Gura_AssignWxValue(DF_TEXT);
		Gura_AssignWxValue(DF_BITMAP);
		Gura_AssignWxValue(DF_METAFILE);
		Gura_AssignWxValue(DF_FILENAME);
		Gura_AssignWxValue(DF_HTML);
		Gura_AssignWxValue(FD_DEFAULT_STYLE);
		Gura_AssignWxValue(FD_OPEN);
		Gura_AssignWxValue(FD_SAVE);
		Gura_AssignWxValue(FD_OVERWRITE_PROMPT);
		Gura_AssignWxValue(FD_FILE_MUST_EXIST);
		Gura_AssignWxValue(FD_MULTIPLE);
		Gura_AssignWxValue(FD_CHANGE_DIR);
		Gura_AssignWxValue(FD_PREVIEW);
		Gura_AssignWxValue(FLEX_GROWMODE_NONE);
		Gura_AssignWxValue(FLEX_GROWMODE_SPECIFIED);
		Gura_AssignWxValue(FLEX_GROWMODE_ALL);
		Gura_AssignWxValue(FONTFAMILY_DEFAULT);
		Gura_AssignWxValue(FONTFAMILY_DECORATIVE);
		Gura_AssignWxValue(FONTFAMILY_ROMAN);
		Gura_AssignWxValue(FONTFAMILY_SCRIPT);
		Gura_AssignWxValue(FONTFAMILY_SWISS);
		Gura_AssignWxValue(FONTFAMILY_MODERN);
		Gura_AssignWxValue(FONTFAMILY_TELETYPE);
		Gura_AssignWxValue(FONTSTYLE_NORMAL);
		Gura_AssignWxValue(FONTSTYLE_SLANT);
		Gura_AssignWxValue(FONTSTYLE_ITALIC);
		Gura_AssignWxValue(FONTWEIGHT_NORMAL);
		Gura_AssignWxValue(FONTWEIGHT_LIGHT);
		Gura_AssignWxValue(FONTWEIGHT_BOLD);
		Gura_AssignWxValue(FONTFLAG_DEFAULT);
		Gura_AssignWxValue(FONTFLAG_ITALIC);
		Gura_AssignWxValue(FONTFLAG_SLANT);
		Gura_AssignWxValue(FONTFLAG_LIGHT);
		Gura_AssignWxValue(FONTFLAG_BOLD);
		Gura_AssignWxValue(FONTFLAG_ANTIALIASED);
		Gura_AssignWxValue(FONTFLAG_NOT_ANTIALIASED);
		Gura_AssignWxValue(FONTFLAG_UNDERLINED);
		Gura_AssignWxValue(FONTFLAG_STRIKETHROUGH);
		Gura_AssignWxValue(FONTENCODING_SYSTEM);
		Gura_AssignWxValue(FONTENCODING_DEFAULT);
		Gura_AssignWxValue(FONTENCODING_ISO8859_1);
		Gura_AssignWxValue(FONTENCODING_ISO8859_2);
		Gura_AssignWxValue(FONTENCODING_ISO8859_3);
		Gura_AssignWxValue(FONTENCODING_ISO8859_4);
		Gura_AssignWxValue(FONTENCODING_ISO8859_5);
		Gura_AssignWxValue(FONTENCODING_ISO8859_6);
		Gura_AssignWxValue(FONTENCODING_ISO8859_7);
		Gura_AssignWxValue(FONTENCODING_ISO8859_8);
		Gura_AssignWxValue(FONTENCODING_ISO8859_9);
		Gura_AssignWxValue(FONTENCODING_ISO8859_10);
		Gura_AssignWxValue(FONTENCODING_ISO8859_11);
		Gura_AssignWxValue(FONTENCODING_ISO8859_12);
		Gura_AssignWxValue(FONTENCODING_ISO8859_13);
		Gura_AssignWxValue(FONTENCODING_ISO8859_14);
		Gura_AssignWxValue(FONTENCODING_ISO8859_15);
		Gura_AssignWxValue(FONTENCODING_KOI8);
		Gura_AssignWxValue(FONTENCODING_ALTERNATIVE);
		Gura_AssignWxValue(FONTENCODING_BULGARIAN);
		Gura_AssignWxValue(FONTENCODING_CP437);
		Gura_AssignWxValue(FONTENCODING_CP850);
		Gura_AssignWxValue(FONTENCODING_CP852);
		Gura_AssignWxValue(FONTENCODING_CP855);
		Gura_AssignWxValue(FONTENCODING_CP866);
		Gura_AssignWxValue(FONTENCODING_CP874);
		Gura_AssignWxValue(FONTENCODING_CP1250);
		Gura_AssignWxValue(FONTENCODING_CP1251);
		Gura_AssignWxValue(FONTENCODING_CP1252);
		Gura_AssignWxValue(FONTENCODING_CP1253);
		Gura_AssignWxValue(FONTENCODING_CP1254);
		Gura_AssignWxValue(FONTENCODING_CP1255);
		Gura_AssignWxValue(FONTENCODING_CP1256);
		Gura_AssignWxValue(FONTENCODING_CP1257);
		Gura_AssignWxValue(FONTENCODING_UTF7);
		Gura_AssignWxValue(FONTENCODING_UTF8);
		Gura_AssignWxValue(FONTENCODING_UNICODE);
		Gura_AssignWxValue(IDLE_PROCESS_ALL);
		Gura_AssignWxValue(IDLE_PROCESS_SPECIFIED);
		Gura_AssignWxValue(IMAGELIST_DRAW_NORMAL);
		Gura_AssignWxValue(IMAGELIST_DRAW_TRANSPARENT);
		Gura_AssignWxValue(IMAGELIST_DRAW_SELECTED);
		Gura_AssignWxValue(IMAGELIST_DRAW_FOCUSED);
		Gura_AssignWxValue(JOY_BUTTON_ANY);
		Gura_AssignWxValue(JOY_BUTTON1);
		Gura_AssignWxValue(JOY_BUTTON2);
		Gura_AssignWxValue(JOY_BUTTON3);
		Gura_AssignWxValue(JOY_BUTTON4);
		Gura_AssignWxValue(JOYSTICK1);
		Gura_AssignWxValue(JOYSTICK2);
		Gura_AssignWxValue(LIST_ALIGN_DEFAULT);
		Gura_AssignWxValue(LIST_ALIGN_LEFT);
		Gura_AssignWxValue(LIST_ALIGN_TOP);
		Gura_AssignWxValue(LIST_ALIGN_SNAP_TO_GRID);
		Gura_AssignWxValue(LIST_NEXT_ABOVE);
		Gura_AssignWxValue(LIST_NEXT_ALL);
		Gura_AssignWxValue(LIST_NEXT_BELOW);
		Gura_AssignWxValue(LIST_NEXT_LEFT);
		Gura_AssignWxValue(LIST_NEXT_RIGHT);
		Gura_AssignWxValue(LIST_STATE_DONTCARE);
		Gura_AssignWxValue(LIST_STATE_DROPHILITED);
		Gura_AssignWxValue(LIST_STATE_FOCUSED);
		Gura_AssignWxValue(LIST_STATE_SELECTED);
		Gura_AssignWxValue(LIST_STATE_CUT);
		Gura_AssignWxValue(LIST_MASK_STATE);
		Gura_AssignWxValue(LIST_MASK_TEXT);
		Gura_AssignWxValue(LIST_MASK_IMAGE);
		Gura_AssignWxValue(LIST_MASK_DATA);
		Gura_AssignWxValue(LIST_MASK_WIDTH);
		Gura_AssignWxValue(LIST_MASK_FORMAT);
		Gura_AssignWxValue(LIST_FORMAT_LEFT);
		Gura_AssignWxValue(LIST_FORMAT_RIGHT);
		Gura_AssignWxValue(LIST_FORMAT_CENTRE);
		Gura_AssignWxValue(LIST_HITTEST_ABOVE);
		Gura_AssignWxValue(LIST_HITTEST_BELOW);
		Gura_AssignWxValue(LIST_HITTEST_NOWHERE);
		Gura_AssignWxValue(LIST_HITTEST_ONITEMICON);
		Gura_AssignWxValue(LIST_HITTEST_ONITEMLABEL);
		Gura_AssignWxValue(LIST_HITTEST_ONITEMRIGHT);
		Gura_AssignWxValue(LIST_HITTEST_ONITEMSTATEICON);
		Gura_AssignWxValue(LIST_HITTEST_TOLEFT);
		Gura_AssignWxValue(LIST_HITTEST_TORIGHT);
		Gura_AssignWxValue(LIST_HITTEST_ONITEM);
		Gura_AssignWxValue(LIST_STATE_DONTCARE);
		Gura_AssignWxValue(OK);
		Gura_AssignWxValue(CANCEL);
		Gura_AssignWxValue(YES_NO);
		Gura_AssignWxValue(YES_DEFAULT);
		Gura_AssignWxValue(NO_DEFAULT);
		Gura_AssignWxValue(ICON_EXCLAMATION);
		Gura_AssignWxValue(ICON_HAND);
		Gura_AssignWxValue(ICON_ERROR);
		Gura_AssignWxValue(ICON_QUESTION);
		Gura_AssignWxValue(ICON_INFORMATION);
		Gura_AssignWxValue(BK_DEFAULT);
		Gura_AssignWxValue(JOIN_BEVEL);
		Gura_AssignWxValue(JOIN_ROUND);
		Gura_AssignWxValue(JOIN_MITER);
		Gura_AssignWxValue(TEXT_ALIGNMENT_DEFAULT);
		Gura_AssignWxValue(TEXT_ALIGNMENT_LEFT);
		Gura_AssignWxValue(TEXT_ALIGNMENT_CENTRE);
		Gura_AssignWxValue(TEXT_ALIGNMENT_CENTER);
		Gura_AssignWxValue(TEXT_ALIGNMENT_RIGHT);
		Gura_AssignWxValue(TEXT_ALIGNMENT_JUSTIFIED);
		Gura_AssignWxValue(TEXT_ATTR_TEXT_COLOUR);
		Gura_AssignWxValue(TEXT_ATTR_BACKGROUND_COLOUR);
		Gura_AssignWxValue(TEXT_ATTR_FONT_FACE);
		Gura_AssignWxValue(TEXT_ATTR_FONT_SIZE);
		Gura_AssignWxValue(TEXT_ATTR_FONT_WEIGHT);
		Gura_AssignWxValue(TEXT_ATTR_FONT_ITALIC);
		Gura_AssignWxValue(TEXT_ATTR_FONT_UNDERLINE);
		Gura_AssignWxValue(TEXT_ATTR_FONT);
		Gura_AssignWxValue(TEXT_ATTR_ALIGNMENT);
		Gura_AssignWxValue(TEXT_ATTR_LEFT_INDENT);
		Gura_AssignWxValue(TEXT_ATTR_RIGHT_INDENT);
		Gura_AssignWxValue(TEXT_ATTR_TABS);
		Gura_AssignWxValue(TEXT_ATTR_PARA_SPACING_AFTER);
		Gura_AssignWxValue(TEXT_ATTR_PARA_SPACING_BEFORE);
		Gura_AssignWxValue(TEXT_ATTR_LINE_SPACING);
		Gura_AssignWxValue(TEXT_ATTR_CHARACTER_STYLE_NAME);
		Gura_AssignWxValue(TEXT_ATTR_PARAGRAPH_STYLE_NAME);
		Gura_AssignWxValue(TEXT_ATTR_LIST_STYLE_NAME);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_NUMBER);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_TEXT);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_NAME);
		Gura_AssignWxValue(TEXT_ATTR_URL);
		Gura_AssignWxValue(TEXT_ATTR_PAGE_BREAK);
		Gura_AssignWxValue(TEXT_ATTR_EFFECTS);
		Gura_AssignWxValue(TEXT_ATTR_OUTLINE_LEVEL);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_NONE);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_ARABIC);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_LETTERS_UPPER);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_LETTERS_LOWER);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_ROMAN_UPPER);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_ROMAN_LOWER);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_SYMBOL);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_BITMAP);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_PARENTHESES);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_PERIOD);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_STANDARD);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_RIGHT_PARENTHESIS);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_OUTLINE);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_ALIGN_LEFT);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_ALIGN_RIGHT);
		Gura_AssignWxValue(TEXT_ATTR_BULLET_STYLE_ALIGN_CENTRE);
		Gura_AssignWxValue(TEXT_ATTR_LINE_SPACING_NORMAL);
		Gura_AssignWxValue(TEXT_ATTR_LINE_SPACING_HALF);
		Gura_AssignWxValue(TEXT_ATTR_LINE_SPACING_TWICE);
		Gura_AssignWxValue(TEXT_ATTR_EFFECT_NONE);
		Gura_AssignWxValue(TEXT_ATTR_EFFECT_CAPITALS);
		Gura_AssignWxValue(TEXT_ATTR_EFFECT_SMALL_CAPITALS);
		Gura_AssignWxValue(TEXT_ATTR_EFFECT_STRIKETHROUGH);
		Gura_AssignWxValue(TEXT_ATTR_EFFECT_DOUBLE_STRIKETHROUGH);
		Gura_AssignWxValue(TEXT_ATTR_EFFECT_SHADOW);
		Gura_AssignWxValue(TEXT_ATTR_EFFECT_EMBOSS);
		Gura_AssignWxValue(TEXT_ATTR_EFFECT_OUTLINE);
		Gura_AssignWxValue(TEXT_ATTR_EFFECT_ENGRAVE);
		Gura_AssignWxValue(TEXT_ATTR_EFFECT_SUPERSCRIPT);
		Gura_AssignWxValue(TEXT_ATTR_EFFECT_SUBSCRIPT);
		Gura_AssignWxValue(SASH_STATUS_OK);
		Gura_AssignWxValue(SASH_STATUS_OUT_OF_RANGE);
		Gura_AssignWxValue(LAYOUT_TOP);
		Gura_AssignWxValue(LAYOUT_LEFT);
		Gura_AssignWxValue(LAYOUT_RIGHT);
		Gura_AssignWxValue(LAYOUT_BOTTOM);
		Gura_AssignWxValue(LAYOUT_HORIZONTAL);
		Gura_AssignWxValue(LAYOUT_VERTICAL);
		Gura_AssignWxValue(SASH_TOP);
		Gura_AssignWxValue(SASH_RIGHT);
		Gura_AssignWxValue(SASH_BOTTOM);
		Gura_AssignWxValue(SASH_LEFT);
		Gura_AssignWxValue(ALIGN_CENTER);
		Gura_AssignWxValue(ALIGN_CENTRE);
		Gura_AssignWxValue(ALIGN_LEFT);
		Gura_AssignWxValue(ALIGN_RIGHT);
		Gura_AssignWxValue(ALIGN_TOP);
		Gura_AssignWxValue(ALIGN_BOTTOM);
		Gura_AssignWxValue(ALIGN_CENTER_VERTICAL);
		Gura_AssignWxValue(ALIGN_CENTRE_VERTICAL);
		Gura_AssignWxValue(ALIGN_CENTER_HORIZONTAL);
		Gura_AssignWxValue(ALIGN_CENTRE_HORIZONTAL);
		Gura_AssignWxValue(SYS_COLOUR_SCROLLBAR);
		Gura_AssignWxValue(SYS_COLOUR_BACKGROUND);
		Gura_AssignWxValue(SYS_COLOUR_ACTIVECAPTION);
		Gura_AssignWxValue(SYS_COLOUR_INACTIVECAPTION);
		Gura_AssignWxValue(SYS_COLOUR_MENU);
		Gura_AssignWxValue(SYS_COLOUR_WINDOW);
		Gura_AssignWxValue(SYS_COLOUR_WINDOWFRAME);
		Gura_AssignWxValue(SYS_COLOUR_MENUTEXT);
		Gura_AssignWxValue(SYS_COLOUR_WINDOWTEXT);
		Gura_AssignWxValue(SYS_COLOUR_CAPTIONTEXT);
		Gura_AssignWxValue(SYS_COLOUR_ACTIVEBORDER);
		Gura_AssignWxValue(SYS_COLOUR_INACTIVEBORDER);
		Gura_AssignWxValue(SYS_COLOUR_APPWORKSPACE);
		Gura_AssignWxValue(SYS_COLOUR_HIGHLIGHT);
		Gura_AssignWxValue(SYS_COLOUR_HIGHLIGHTTEXT);
		Gura_AssignWxValue(SYS_COLOUR_LISTBOXHIGHLIGHTTEXT);
		Gura_AssignWxValue(SYS_COLOUR_BTNFACE);
		Gura_AssignWxValue(SYS_COLOUR_BTNSHADOW);
		Gura_AssignWxValue(SYS_COLOUR_GRAYTEXT);
		Gura_AssignWxValue(SYS_COLOUR_BTNTEXT);
		Gura_AssignWxValue(SYS_COLOUR_INACTIVECAPTIONTEXT);
		Gura_AssignWxValue(SYS_COLOUR_BTNHIGHLIGHT);
		Gura_AssignWxValue(SYS_COLOUR_3DDKSHADOW);
		Gura_AssignWxValue(SYS_COLOUR_3DLIGHT);
		Gura_AssignWxValue(SYS_COLOUR_INFOTEXT);
		Gura_AssignWxValue(SYS_COLOUR_INFOBK);
		Gura_AssignWxValue(SYS_COLOUR_DESKTOP);
		Gura_AssignWxValue(SYS_COLOUR_3DFACE);
		Gura_AssignWxValue(SYS_COLOUR_3DSHADOW);
		Gura_AssignWxValue(SYS_COLOUR_3DHIGHLIGHT);
		Gura_AssignWxValue(SYS_COLOUR_3DHILIGHT);
		Gura_AssignWxValue(SYS_COLOUR_BTNHILIGHT);
		Gura_AssignWxValue(SYS_OEM_FIXED_FONT);
		Gura_AssignWxValue(SYS_ANSI_FIXED_FONT);
		Gura_AssignWxValue(SYS_ANSI_VAR_FONT);
		Gura_AssignWxValue(SYS_SYSTEM_FONT);
		Gura_AssignWxValue(SYS_DEVICE_DEFAULT_FONT);
		Gura_AssignWxValue(SYS_DEFAULT_GUI_FONT);
		Gura_AssignWxValue(SYS_MOUSE_BUTTONS);
		Gura_AssignWxValue(SYS_BORDER_X);
		Gura_AssignWxValue(SYS_BORDER_Y);
		Gura_AssignWxValue(SYS_CURSOR_X);
		Gura_AssignWxValue(SYS_CURSOR_Y);
		Gura_AssignWxValue(SYS_DCLICK_X);
		Gura_AssignWxValue(SYS_DCLICK_Y);
		Gura_AssignWxValue(SYS_DRAG_X);
		Gura_AssignWxValue(SYS_DRAG_Y);
		Gura_AssignWxValue(SYS_EDGE_X);
		Gura_AssignWxValue(SYS_EDGE_Y);
		Gura_AssignWxValue(SYS_HSCROLL_ARROW_X);
		Gura_AssignWxValue(SYS_HSCROLL_ARROW_Y);
		Gura_AssignWxValue(SYS_HTHUMB_X);
		Gura_AssignWxValue(SYS_ICON_X);
		Gura_AssignWxValue(SYS_ICON_Y);
		Gura_AssignWxValue(SYS_ICONSPACING_X);
		Gura_AssignWxValue(SYS_ICONSPACING_Y);
		Gura_AssignWxValue(SYS_WINDOWMIN_X);
		Gura_AssignWxValue(SYS_WINDOWMIN_Y);
		Gura_AssignWxValue(SYS_SCREEN_X);
		Gura_AssignWxValue(SYS_SCREEN_Y);
		Gura_AssignWxValue(SYS_FRAMESIZE_X);
		Gura_AssignWxValue(SYS_FRAMESIZE_Y);
		Gura_AssignWxValue(SYS_SMALLICON_X);
		Gura_AssignWxValue(SYS_SMALLICON_Y);
		Gura_AssignWxValue(SYS_HSCROLL_Y);
		Gura_AssignWxValue(SYS_VSCROLL_X);
		Gura_AssignWxValue(SYS_VSCROLL_ARROW_X);
		Gura_AssignWxValue(SYS_VSCROLL_ARROW_Y);
		Gura_AssignWxValue(SYS_VTHUMB_Y);
		Gura_AssignWxValue(SYS_CAPTION_Y);
		Gura_AssignWxValue(SYS_MENU_Y);
		Gura_AssignWxValue(SYS_NETWORK_PRESENT);
		Gura_AssignWxValue(SYS_PENWINDOWS_PRESENT);
		Gura_AssignWxValue(SYS_SHOW_SOUNDS);
		Gura_AssignWxValue(SYS_SWAP_BUTTONS);
		Gura_AssignWxValue(SYS_SCREEN_NONE);
		Gura_AssignWxValue(SYS_SCREEN_TINY);
		Gura_AssignWxValue(SYS_SCREEN_PDA);
		Gura_AssignWxValue(SYS_SCREEN_SMALL);
		Gura_AssignWxValue(SYS_SCREEN_DESKTOP);
		Gura_AssignWxValue(FILTER_NONE);
		Gura_AssignWxValue(FILTER_ASCII);
		Gura_AssignWxValue(FILTER_ALPHA);
		Gura_AssignWxValue(FILTER_ALPHANUMERIC);
		Gura_AssignWxValue(FILTER_NUMERIC);
		Gura_AssignWxValue(FILTER_INCLUDE_LIST);
		Gura_AssignWxValue(FILTER_EXCLUDE_LIST);
		Gura_AssignWxValue(FILTER_INCLUDE_CHAR_LIST);
		Gura_AssignWxValue(FILTER_EXCLUDE_CHAR_LIST);
		Gura_AssignWxValue(TIMER_CONTINUOUS);
		Gura_AssignWxValue(TIMER_ONE_SHOT);
		Gura_AssignWxValue(ITEM_NORMAL);
		Gura_AssignWxValue(ITEM_CHECK);
		Gura_AssignWxValue(ITEM_RADIO);
		Gura_AssignWxValue(FULLSCREEN_NOMENUBAR);
		Gura_AssignWxValue(FULLSCREEN_NOTOOLBAR);
		Gura_AssignWxValue(FULLSCREEN_NOSTATUSBAR);
		Gura_AssignWxValue(FULLSCREEN_NOBORDER);
		Gura_AssignWxValue(FULLSCREEN_NOCAPTION);
		Gura_AssignWxValue(FULLSCREEN_ALL);
		Gura_AssignWxValue(USER_ATTENTION_INFO);
		Gura_AssignWxValue(USER_ATTENTION_ERROR);
		Gura_AssignWxValue(BK_HITTEST_NOWHERE);
		Gura_AssignWxValue(BK_HITTEST_ONICON);
		Gura_AssignWxValue(BK_HITTEST_ONLABEL);
		Gura_AssignWxValue(BK_HITTEST_ONITEM);
		Gura_AssignWxValue(BK_HITTEST_ONPAGE);
		Gura_AssignWxValue(TreeItemIcon_Normal);
		Gura_AssignWxValue(TreeItemIcon_Selected);
		Gura_AssignWxValue(TreeItemIcon_Expanded);
		Gura_AssignWxValue(TreeItemIcon_SelectedExpanded);
		Gura_AssignWxValue(WINDOW_VARIANT_NORMAL);
		Gura_AssignWxValue(WINDOW_VARIANT_SMALL);
		Gura_AssignWxValue(WINDOW_VARIANT_MINI);
		Gura_AssignWxValue(WINDOW_VARIANT_LARGE);
		Gura_AssignWxValue(BG_STYLE_SYSTEM);
		Gura_AssignWxValue(BG_STYLE_COLOUR);
		Gura_AssignWxValue(BG_STYLE_CUSTOM);
	} while (0);
	do {
		Gura_AssignWxValue(AC_DEFAULT_STYLE);
		Gura_AssignWxValue(AC_NO_AUTORESIZE);
		Gura_AssignWxValue(ADJUST_MINSIZE);
		Gura_AssignWxValue(ALL);
		Gura_AssignWxValue(ALWAYS_SHOW_SB);
		Gura_AssignWxValue(AUI_NB_BOTTOM);
		Gura_AssignWxValue(AUI_NB_CLOSE_BUTTON);
		Gura_AssignWxValue(AUI_NB_CLOSE_ON_ACTIVE_TAB);
		Gura_AssignWxValue(AUI_NB_CLOSE_ON_ALL_TABS);
		Gura_AssignWxValue(AUI_NB_DEFAULT_STYLE);
		Gura_AssignWxValue(AUI_NB_SCROLL_BUTTONS);
		Gura_AssignWxValue(AUI_NB_TAB_EXTERNAL_MOVE);
		Gura_AssignWxValue(AUI_NB_TAB_FIXED_WIDTH);
		Gura_AssignWxValue(AUI_NB_TAB_MOVE);
		Gura_AssignWxValue(AUI_NB_TAB_SPLIT);
		Gura_AssignWxValue(AUI_NB_TOP);
		Gura_AssignWxValue(AUI_NB_WINDOWLIST_BUTTON);
		Gura_AssignWxValue(BK_BOTTOM);
		Gura_AssignWxValue(BK_DEFAULT);
		Gura_AssignWxValue(BK_LEFT);
		Gura_AssignWxValue(BK_RIGHT);
		Gura_AssignWxValue(BK_TOP);
		Gura_AssignWxValue(BORDER_DOUBLE);
		Gura_AssignWxValue(BORDER_NONE);
		Gura_AssignWxValue(BORDER_RAISED);
		Gura_AssignWxValue(BORDER_SIMPLE);
		Gura_AssignWxValue(BORDER_STATIC);
		Gura_AssignWxValue(BORDER_SUNKEN);
		Gura_AssignWxValue(BORDER_THEME);
		Gura_AssignWxValue(BOTTOM);
		Gura_AssignWxValue(BU_AUTODRAW);
		Gura_AssignWxValue(BU_BOTTOM);
		Gura_AssignWxValue(BU_EXACTFIT);
		Gura_AssignWxValue(BU_LEFT);
		Gura_AssignWxValue(BU_RIGHT);
		Gura_AssignWxValue(BU_TOP);
		Gura_AssignWxValue(CAL_MONDAY_FIRST);
		Gura_AssignWxValue(CAL_NO_MONTH_CHANGE);
		Gura_AssignWxValue(CAL_NO_YEAR_CHANGE);
		Gura_AssignWxValue(CAL_SEQUENTIAL_MONTH_SELECTION);
		Gura_AssignWxValue(CAL_SHOW_HOLIDAYS);
		Gura_AssignWxValue(CAL_SHOW_SURROUNDING_WEEKS);
		Gura_AssignWxValue(CAL_SUNDAY_FIRST);
		Gura_AssignWxValue(CAPTION);
		Gura_AssignWxValue(CB_DROPDOWN);
		Gura_AssignWxValue(CB_READONLY);
		Gura_AssignWxValue(CB_SIMPLE);
		Gura_AssignWxValue(CB_SORT);
		Gura_AssignWxValue(CC_SPECIAL_DCLICK);
		Gura_AssignWxValue(CC_STD_BUTTON);
		Gura_AssignWxValue(CHB_BOTTOM);
		Gura_AssignWxValue(CHB_DEFAULT);
		Gura_AssignWxValue(CHB_LEFT);
		Gura_AssignWxValue(CHB_RIGHT);
		Gura_AssignWxValue(CHB_TOP);
		Gura_AssignWxValue(CHK_2STATE);
		Gura_AssignWxValue(CHK_3STATE);
		Gura_AssignWxValue(CHK_ALLOW_3RD_STATE_FOR_USER);
		Gura_AssignWxValue(CLIP_CHILDREN);
		Gura_AssignWxValue(CLOSE_BOX);
		Gura_AssignWxValue(CLRP_DEFAULT_STYLE);
		Gura_AssignWxValue(CLRP_SHOW_LABEL);
		Gura_AssignWxValue(CLRP_USE_TEXTCTRL);
		Gura_AssignWxValue(CP_DEFAULT_STYLE);
		Gura_AssignWxValue(DD_CHANGE_DIR);
		Gura_AssignWxValue(DD_DEFAULT_STYLE);
		Gura_AssignWxValue(DD_DIR_MUST_EXIST);
		Gura_AssignWxValue(DEFAULT_DIALOG_STYLE);
		Gura_AssignWxValue(DEFAULT_FRAME_STYLE);
		Gura_AssignWxValue(DIALOG_EX_CONTEXTHELP);
		Gura_AssignWxValue(DIALOG_EX_METAL);
		Gura_AssignWxValue(DIALOG_NO_PARENT);
		Gura_AssignWxValue(DIRP_CHANGE_DIR);
		Gura_AssignWxValue(DIRP_DEFAULT_STYLE);
		Gura_AssignWxValue(DIRP_DIR_MUST_EXIST);
		Gura_AssignWxValue(DIRP_USE_TEXTCTRL);
		Gura_AssignWxValue(DP_ALLOWNONE);
		Gura_AssignWxValue(DP_DEFAULT);
		Gura_AssignWxValue(DP_DROPDOWN);
		Gura_AssignWxValue(DP_SHOWCENTURY);
		Gura_AssignWxValue(DP_SPIN);
		Gura_AssignWxValue(DV_MULTIPLE);
		Gura_AssignWxValue(DV_SINGLE);
		Gura_AssignWxValue(EXPAND);
		Gura_AssignWxValue(FIXED_MINSIZE);
		Gura_AssignWxValue(FLP_CHANGE_DIR);
		Gura_AssignWxValue(FLP_DEFAULT_STYLE);
		Gura_AssignWxValue(FLP_FILE_MUST_EXIST);
		Gura_AssignWxValue(FLP_OPEN);
		Gura_AssignWxValue(FLP_OVERWRITE_PROMPT);
		Gura_AssignWxValue(FLP_SAVE);
		Gura_AssignWxValue(FLP_USE_TEXTCTRL);
		Gura_AssignWxValue(FNTP_DEFAULT_STYLE);
		Gura_AssignWxValue(FNTP_FONTDESC_AS_LABEL);
		Gura_AssignWxValue(FNTP_USEFONT_FOR_LABEL);
		Gura_AssignWxValue(FNTP_USE_TEXTCTRL);
		Gura_AssignWxValue(FRAME_EX_CONTEXTHELP);
		Gura_AssignWxValue(FRAME_EX_METAL);
		Gura_AssignWxValue(FRAME_FLOAT_ON_PARENT);
		Gura_AssignWxValue(FRAME_NO_TASKBAR);
		Gura_AssignWxValue(FRAME_NO_WINDOW_MENU);
		Gura_AssignWxValue(FRAME_SHAPED);
		Gura_AssignWxValue(FRAME_TOOL_WINDOW);
		Gura_AssignWxValue(FULL_REPAINT_ON_RESIZE);
		Gura_AssignWxValue(GA_HORIZONTAL);
		Gura_AssignWxValue(GA_PROGRESSBAR);
		Gura_AssignWxValue(GA_SMOOTH);
		Gura_AssignWxValue(GA_VERTICAL);
		Gura_AssignWxValue(HF_BOOKMARKS);
		Gura_AssignWxValue(HF_CONTENTS);
		Gura_AssignWxValue(HF_DEFAULT_STYLE);
		Gura_AssignWxValue(HF_DIALOG);
		Gura_AssignWxValue(HF_EMBEDDED);
		Gura_AssignWxValue(HF_FLAT_TOOLBAR);
		Gura_AssignWxValue(HF_FRAME);
		Gura_AssignWxValue(HF_ICONS_BOOK);
		Gura_AssignWxValue(HF_ICONS_BOOK_CHAPTER);
		Gura_AssignWxValue(HF_ICONS_FOLDER);
		Gura_AssignWxValue(HF_INDEX);
		Gura_AssignWxValue(HF_MERGE_BOOKS);
		Gura_AssignWxValue(HF_MODAL);
		Gura_AssignWxValue(HF_OPEN_FILES);
		Gura_AssignWxValue(HF_PRINT);
		Gura_AssignWxValue(HF_SEARCH);
		Gura_AssignWxValue(HF_TOOLBAR);
		Gura_AssignWxValue(HLB_DEFAULT_STYLE);
		Gura_AssignWxValue(HLB_MULTIPLE);
		Gura_AssignWxValue(HL_ALIGN_CENTRE);
		Gura_AssignWxValue(HL_ALIGN_LEFT);
		Gura_AssignWxValue(HL_ALIGN_RIGHT);
		Gura_AssignWxValue(HL_CONTEXTMENU);
		Gura_AssignWxValue(HL_DEFAULT_STYLE);
		Gura_AssignWxValue(HSCROLL);
		Gura_AssignWxValue(HW_NO_SELECTION);
		Gura_AssignWxValue(HW_SCROLLBAR_AUTO);
		Gura_AssignWxValue(HW_SCROLLBAR_NEVER);
		Gura_AssignWxValue(ICONIZE);
		Gura_AssignWxValue(IMAGE_LIST_NORMAL);
		Gura_AssignWxValue(IMAGE_LIST_SMALL);
		Gura_AssignWxValue(IMAGE_LIST_STATE);
		Gura_AssignWxValue(LB_ALWAYS_SB);
		Gura_AssignWxValue(LB_BOTTOM);
		Gura_AssignWxValue(LB_DEFAULT);
		Gura_AssignWxValue(LB_EXTENDED);
		Gura_AssignWxValue(LB_HSCROLL);
		Gura_AssignWxValue(LB_LEFT);
		Gura_AssignWxValue(LB_MULTIPLE);
		Gura_AssignWxValue(LB_NEEDED_SB);
		Gura_AssignWxValue(LB_RIGHT);
		Gura_AssignWxValue(LB_SINGLE);
		Gura_AssignWxValue(LB_SORT);
		Gura_AssignWxValue(LB_TOP);
		Gura_AssignWxValue(LC_ALIGN_LEFT);
		Gura_AssignWxValue(LC_ALIGN_TOP);
		Gura_AssignWxValue(LC_AUTOARRANGE);
		Gura_AssignWxValue(LC_EDIT_LABELS);
		Gura_AssignWxValue(LC_HRULES);
		Gura_AssignWxValue(LC_ICON);
		Gura_AssignWxValue(LC_LIST);
		Gura_AssignWxValue(LC_NO_HEADER);
		Gura_AssignWxValue(LC_REPORT);
		Gura_AssignWxValue(LC_SINGLE_SEL);
		Gura_AssignWxValue(LC_SMALL_ICON);
		Gura_AssignWxValue(LC_SORT_ASCENDING);
		Gura_AssignWxValue(LC_SORT_DESCENDING);
		Gura_AssignWxValue(LC_VIRTUAL);
		Gura_AssignWxValue(LC_VRULES);
		Gura_AssignWxValue(LEFT);
		Gura_AssignWxValue(LI_HORIZONTAL);
		Gura_AssignWxValue(LI_VERTICAL);
		Gura_AssignWxValue(LOCALE_CONV_ENCODING);
		Gura_AssignWxValue(LOCALE_LOAD_DEFAULT);
		Gura_AssignWxValue(MAXIMIZE);
		Gura_AssignWxValue(MAXIMIZE_BOX);
		Gura_AssignWxValue(MINIMIZE);
		Gura_AssignWxValue(MINIMIZE_BOX);
		Gura_AssignWxValue(NB_BOTTOM);
		Gura_AssignWxValue(NB_FIXEDWIDTH);
		Gura_AssignWxValue(NB_FLAT);
		Gura_AssignWxValue(NB_LEFT);
		Gura_AssignWxValue(NB_MULTILINE);
		Gura_AssignWxValue(NB_NOPAGETHEME);
		Gura_AssignWxValue(NB_RIGHT);
		Gura_AssignWxValue(NB_TOP);
		Gura_AssignWxValue(NO_3D);
		Gura_AssignWxValue(NO_BORDER);
		Gura_AssignWxValue(NO_FULL_REPAINT_ON_RESIZE);
		Gura_AssignWxValue(ODCB_DCLICK_CYCLES);
		Gura_AssignWxValue(ODCB_STD_CONTROL_PAINT);
		Gura_AssignWxValue(PB_USE_TEXTCTRL);
		Gura_AssignWxValue(PD_APP_MODAL);
		Gura_AssignWxValue(PD_AUTO_HIDE);
		Gura_AssignWxValue(PD_CAN_ABORT);
		Gura_AssignWxValue(PD_CAN_SKIP);
		Gura_AssignWxValue(PD_ELAPSED_TIME);
		Gura_AssignWxValue(PD_ESTIMATED_TIME);
		Gura_AssignWxValue(PD_REMAINING_TIME);
		Gura_AssignWxValue(PD_SMOOTH);
		Gura_AssignWxValue(RA_SPECIFY_COLS);
		Gura_AssignWxValue(RA_SPECIFY_ROWS);
		Gura_AssignWxValue(RA_USE_CHECKBOX);
		Gura_AssignWxValue(RB_GROUP);
		Gura_AssignWxValue(RB_SINGLE);
		Gura_AssignWxValue(RB_USE_CHECKBOX);
		Gura_AssignWxValue(RESERVE_SPACE_EVEN_IF_HIDDEN);
		Gura_AssignWxValue(RESIZE_BORDER);
		Gura_AssignWxValue(RETAINED);
		Gura_AssignWxValue(RE_CENTER_CARET);
		Gura_AssignWxValue(RE_CENTRE_CARET);
		Gura_AssignWxValue(RE_READONLY);
		Gura_AssignWxValue(RICHTEXTSTYLELIST_HIDE_TYPE_SELECTOR);
		Gura_AssignWxValue(RICHTEXT_HANDLER_INCLUDE_STYLESHEET);
		Gura_AssignWxValue(RICHTEXT_HANDLER_NO_HEADER_FOOTER);
		Gura_AssignWxValue(RICHTEXT_HANDLER_SAVE_IMAGES_TO_BASE64);
		Gura_AssignWxValue(RICHTEXT_HANDLER_SAVE_IMAGES_TO_FILES);
		Gura_AssignWxValue(RICHTEXT_HANDLER_SAVE_IMAGES_TO_MEMORY);
		Gura_AssignWxValue(RICHTEXT_HANDLER_USE_CSS);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_APPLY_STYLES);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_BROWSE);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_BROWSE_NUMBERING);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_CREATE_STYLES);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_DELETE_STYLES);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_EDIT_STYLES);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_OK_CANCEL);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_ORGANISE);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_RENAME_STYLES);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_RENUMBER);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_SHOW_ALL);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_SHOW_CHARACTER);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_SHOW_LIST);
		Gura_AssignWxValue(RICHTEXT_ORGANISER_SHOW_PARAGRAPH);
		Gura_AssignWxValue(RIGHT);
		Gura_AssignWxValue(SB_FLAT);
		Gura_AssignWxValue(SB_HORIZONTAL);
		Gura_AssignWxValue(SB_NORMAL);
		Gura_AssignWxValue(SB_RAISED);
		Gura_AssignWxValue(SB_VERTICAL);
		Gura_AssignWxValue(SHAPED);
		Gura_AssignWxValue(SL_AUTOTICKS);
		Gura_AssignWxValue(SL_BOTTOM);
		Gura_AssignWxValue(SL_HORIZONTAL);
		Gura_AssignWxValue(SL_INVERSE);
		Gura_AssignWxValue(SL_LABELS);
		Gura_AssignWxValue(SL_LEFT);
		Gura_AssignWxValue(SL_RIGHT);
		Gura_AssignWxValue(SL_SELRANGE);
		Gura_AssignWxValue(SL_TOP);
		Gura_AssignWxValue(SL_VERTICAL);
		Gura_AssignWxValue(SP_3D);
		Gura_AssignWxValue(SP_3DBORDER);
		Gura_AssignWxValue(SP_3DSASH);
		Gura_AssignWxValue(SP_ARROW_KEYS);
		Gura_AssignWxValue(SP_BORDER);
		Gura_AssignWxValue(SP_HORIZONTAL);
		Gura_AssignWxValue(SP_LIVE_UPDATE);
		Gura_AssignWxValue(SP_NOBORDER);
		Gura_AssignWxValue(SP_NO_XP_THEME);
		Gura_AssignWxValue(SP_PERMIT_UNSPLIT);
		Gura_AssignWxValue(SP_VERTICAL);
		Gura_AssignWxValue(SP_WRAP);
		Gura_AssignWxValue(STAY_ON_TOP);
		Gura_AssignWxValue(ST_NO_AUTORESIZE);
		Gura_AssignWxValue(ST_SIZEGRIP);
		Gura_AssignWxValue(SW_3D);
		Gura_AssignWxValue(SW_3DBORDER);
		Gura_AssignWxValue(SW_3DSASH);
		Gura_AssignWxValue(SW_BORDER);
		Gura_AssignWxValue(SYSTEM_MENU);
		Gura_AssignWxValue(TAB_TRAVERSAL);
		Gura_AssignWxValue(TB_BOTTOM);
		Gura_AssignWxValue(TB_DOCKABLE);
		Gura_AssignWxValue(TB_FLAT);
		Gura_AssignWxValue(TB_HORIZONTAL);
		Gura_AssignWxValue(TB_HORZ_LAYOUT);
		Gura_AssignWxValue(TB_HORZ_TEXT);
		Gura_AssignWxValue(TB_NOALIGN);
		Gura_AssignWxValue(TB_NODIVIDER);
		Gura_AssignWxValue(TB_NOICONS);
		Gura_AssignWxValue(TB_NO_TOOLTIPS);
		Gura_AssignWxValue(TB_RIGHT);
		Gura_AssignWxValue(TB_TEXT);
		Gura_AssignWxValue(TB_VERTICAL);
		Gura_AssignWxValue(TE_AUTO_URL);
		Gura_AssignWxValue(TE_BESTWRAP);
		Gura_AssignWxValue(TE_CAPITALIZE);
		Gura_AssignWxValue(TE_CENTRE);
		Gura_AssignWxValue(TE_CHARWRAP);
		Gura_AssignWxValue(TE_DONTWRAP);
		Gura_AssignWxValue(TE_LEFT);
		Gura_AssignWxValue(TE_MULTILINE);
		Gura_AssignWxValue(TE_NOHIDESEL);
		Gura_AssignWxValue(TE_PASSWORD);
		Gura_AssignWxValue(TE_PROCESS_ENTER);
		Gura_AssignWxValue(TE_PROCESS_TAB);
		Gura_AssignWxValue(TE_READONLY);
		Gura_AssignWxValue(TE_RICH);
		Gura_AssignWxValue(TE_RICH2);
		Gura_AssignWxValue(TE_RIGHT);
		Gura_AssignWxValue(TE_WORDWRAP);
		Gura_AssignWxValue(THICK_FRAME);
		Gura_AssignWxValue(TINY_CAPTION_HORIZ);
		Gura_AssignWxValue(TINY_CAPTION_VERT);
		Gura_AssignWxValue(TOP);
		Gura_AssignWxValue(TRANSPARENT_WINDOW);
		Gura_AssignWxValue(TR_DEFAULT_STYLE);
		Gura_AssignWxValue(TR_EDIT_LABELS);
		Gura_AssignWxValue(TR_EXTENDED);
		Gura_AssignWxValue(TR_FULL_ROW_HIGHLIGHT);
		Gura_AssignWxValue(TR_HAS_BUTTONS);
		Gura_AssignWxValue(TR_HAS_VARIABLE_ROW_HEIGHT);
		Gura_AssignWxValue(TR_HIDE_ROOT);
		Gura_AssignWxValue(TR_LINES_AT_ROOT);
		Gura_AssignWxValue(TR_MULTIPLE);
		Gura_AssignWxValue(TR_NO_BUTTONS);
		Gura_AssignWxValue(TR_NO_LINES);
		Gura_AssignWxValue(TR_ROW_LINES);
		Gura_AssignWxValue(TR_SINGLE);
		Gura_AssignWxValue(VSCROLL);
		Gura_AssignWxValue(WANTS_CHARS);
		Gura_AssignWxValue(WIZARD_EX_HELPBUTTON);
		Gura_AssignWxValue(WS_EX_BLOCK_EVENTS);
		Gura_AssignWxValue(WS_EX_CONTEXTHELP);
		Gura_AssignWxValue(WS_EX_PROCESS_IDLE);
		Gura_AssignWxValue(WS_EX_PROCESS_UI_UPDATES);
		Gura_AssignWxValue(WS_EX_TRANSIENT);
		Gura_AssignWxValue(WS_EX_VALIDATE_RECURSIVELY);
	} while (0);
	Gura_AssignWxEvent(EVT_ACTIVATE,							EVT_ACTIVATE,					ActivateEvent);
	Gura_AssignWxEvent(EVT_ACTIVATE_APP,						EVT_ACTIVATE_APP,				ActivateEvent);
	Gura_AssignWxEvent(EVT_HIBERNATE,							EVT_HIBERNATE,					ActivateEvent);
	Gura_AssignWxEvent(EVT_COMMAND_BUTTON_CLICKED,				EVT_BUTTON,						CommandEvent);
	Gura_AssignWxEvent(EVT_CALCULATE_LAYOUT,					EVT_CALCULATE_LAYOUT,			CalculateLayoutEvent);
	Gura_AssignWxEvent(EVT_COMMAND_CHECKBOX_CLICKED,			EVT_CHECKBOX,					CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_CHECKLISTBOX_TOGGLED,		EVT_CHECKLISTBOX,				CommandEvent);
	Gura_AssignWxEvent(EVT_CHILD_FOCUS,							EVT_CHILD_FOCUS,				ChildFocusEvent);
	Gura_AssignWxEvent(EVT_COMMAND_CHOICE_SELECTED,				EVT_CHOICE,						CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TEXT_COPY,					EVT_TEXT_COPY,					ClipboardTextEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TEXT_CUT,					EVT_TEXT_CUT,					ClipboardTextEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TEXT_PASTE,					EVT_TEXT_PASTE,					ClipboardTextEvent);
	Gura_AssignWxEvent(EVT_CLOSE_WINDOW,						EVT_CLOSE,						CloseEvent);
	Gura_AssignWxEvent(EVT_QUERY_END_SESSION,					EVT_QUERY_END_SESSION,			CloseEvent);
	Gura_AssignWxEvent(EVT_END_SESSION,							EVT_END_SESSION,				CloseEvent);
	Gura_AssignWxEvent(EVT_COMMAND_COLOURPICKER_CHANGED,		EVT_COLOURPICKER_CHANGED,		ColourPickerEvent);
	Gura_AssignWxEvent(EVT_COMMAND_COMBOBOX_SELECTED,			EVT_COMBOBOX,					CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_MENU_SELECTED,				EVT_MENU,						CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_MENU_SELECTED,				EVT_MENU_RANGE,					CommandEvent);
//	Gura_AssignWxEvent(EVT_COMMAND_CONTEXT_MENU,				EVT_CONTEXT_MENU,				CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TOGGLEBUTTON_CLICKED,		EVT_TOGGLEBUTTON,				CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TOOL_CLICKED,				EVT_TOOL,						CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TOOL_CLICKED,				EVT_TOOL_RANGE,					CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TOOL_RCLICKED,				EVT_TOOL_RCLICKED,				CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TOOL_RCLICKED,				EVT_TOOL_RCLICKED_RANGE,		CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TOOL_ENTER,					EVT_TOOL_ENTER,					CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LEFT_CLICK,					EVT_COMMAND_LEFT_CLICK,			CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LEFT_DCLICK,					EVT_COMMAND_LEFT_DCLICK,		CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_RIGHT_CLICK,					EVT_COMMAND_RIGHT_CLICK,		CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_RIGHT_DCLICK,				EVT_COMMAND_RIGHT_DCLICK,		CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_SET_FOCUS,					EVT_COMMAND_SET_FOCUS,			CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_KILL_FOCUS,					EVT_COMMAND_KILL_FOCUS,			CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_ENTER,						EVT_COMMAND_ENTER,				CommandEvent);
	Gura_AssignWxEvent(EVT_CONTEXT_MENU,						EVT_CONTEXT_MENU,				ContextMenuEvent);
	Gura_AssignWxEvent(EVT_DROP_FILES,							EVT_DROP_FILES,					DropFilesEvent);
	Gura_AssignWxEvent(EVT_ERASE_BACKGROUND,					EVT_ERASE_BACKGROUND,			EraseEvent);
	Gura_AssignWxEvent(EVT_COMMAND_FILEPICKER_CHANGED,			EVT_FILEPICKER_CHANGED,			FileDirPickerEvent);
	Gura_AssignWxEvent(EVT_COMMAND_DIRPICKER_CHANGED,			EVT_DIRPICKER_CHANGED,			FileDirPickerEvent);
	Gura_AssignWxEvent(EVT_SET_FOCUS,							EVT_SET_FOCUS,					FocusEvent);
	Gura_AssignWxEvent(EVT_KILL_FOCUS,							EVT_KILL_FOCUS,					FocusEvent);
	Gura_AssignWxEvent(EVT_COMMAND_FONTPICKER_CHANGED,			EVT_FONTPICKER_CHANGED,			FontPickerEvent);
	Gura_AssignWxEvent(EVT_GRID_EDITOR_CREATED,					EVT_GRID_EDITOR_CREATED,		GridEditorCreatedEvent);
	Gura_AssignWxEvent(EVT_GRID_CELL_LEFT_CLICK,				EVT_GRID_CELL_LEFT_CLICK,		GridEvent);
	Gura_AssignWxEvent(EVT_GRID_CELL_RIGHT_CLICK,				EVT_GRID_CELL_RIGHT_CLICK,		GridEvent);
	Gura_AssignWxEvent(EVT_GRID_CELL_LEFT_DCLICK,				EVT_GRID_CELL_LEFT_DCLICK,		GridEvent);
	Gura_AssignWxEvent(EVT_GRID_CELL_RIGHT_DCLICK,				EVT_GRID_CELL_RIGHT_DCLICK,		GridEvent);
	Gura_AssignWxEvent(EVT_GRID_LABEL_LEFT_CLICK,				EVT_GRID_LABEL_LEFT_CLICK,		GridEvent);
	Gura_AssignWxEvent(EVT_GRID_LABEL_RIGHT_CLICK,				EVT_GRID_LABEL_RIGHT_CLICK,		GridEvent);
	Gura_AssignWxEvent(EVT_GRID_LABEL_LEFT_DCLICK,				EVT_GRID_LABEL_LEFT_DCLICK,		GridEvent);
	Gura_AssignWxEvent(EVT_GRID_LABEL_RIGHT_DCLICK,				EVT_GRID_LABEL_RIGHT_DCLICK,	GridEvent);
	Gura_AssignWxEvent(EVT_GRID_CELL_CHANGE,					EVT_GRID_CELL_CHANGE,			GridEvent);
	Gura_AssignWxEvent(EVT_GRID_SELECT_CELL,					EVT_GRID_SELECT_CELL,			GridEvent);
	Gura_AssignWxEvent(EVT_GRID_EDITOR_HIDDEN,					EVT_GRID_EDITOR_HIDDEN,			GridEvent);
	Gura_AssignWxEvent(EVT_GRID_EDITOR_SHOWN,					EVT_GRID_EDITOR_SHOWN,			GridEvent);
	Gura_AssignWxEvent(EVT_GRID_RANGE_SELECT,					EVT_GRID_RANGE_SELECT,			GridRangeSelectEvent);
//	Gura_AssignWxEvent(EVT_GRID_COL_SIZE,						EVT_GRID_COL_SIZE,				GridSizeEvent);
//	Gura_AssignWxEvent(EVT_GRID_ROW_SIZE,						EVT_GRID_ROW_SIZE,				GridSizeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_HTML_CELL_HOVER,				EVT_HTML_CELL_HOVER,			HtmlCellEvent);
	Gura_AssignWxEvent(EVT_COMMAND_HTML_CELL_CLICKED,			EVT_HTML_CELL_CLICKED,			HtmlCellEvent);
	Gura_AssignWxEvent(EVT_COMMAND_HTML_LINK_CLICKED,			EVT_HTML_LINK_CLICKED,			HtmlLinkEvent);
	Gura_AssignWxEvent(EVT_COMMAND_HYPERLINK,					EVT_HYPERLINK,					HyperlinkEvent);
	Gura_AssignWxEvent(EVT_IDLE,								EVT_IDLE,						IdleEvent);
	Gura_AssignWxEvent(EVT_INIT_DIALOG,							EVT_INIT_DIALOG,				InitDialogEvent);
	Gura_AssignWxEvent(EVT_JOY_BUTTON_DOWN,						EVT_JOY_BUTTON_DOWN,			JoystickEvent);
	Gura_AssignWxEvent(EVT_JOY_BUTTON_UP,						EVT_JOY_BUTTON_UP,				JoystickEvent);
	Gura_AssignWxEvent(EVT_JOY_MOVE,							EVT_JOY_MOVE,					JoystickEvent);
	Gura_AssignWxEvent(EVT_JOY_ZMOVE,							EVT_JOY_ZMOVE,					JoystickEvent);
	Gura_AssignWxEvent(EVT_NULL,								EVT_JOYSTICK_EVENTS,			JoystickEvent);
	Gura_AssignWxEvent(EVT_KEY_DOWN,							EVT_KEY_DOWN,					KeyEvent);
	Gura_AssignWxEvent(EVT_KEY_UP,								EVT_KEY_UP,						KeyEvent);
	Gura_AssignWxEvent(EVT_CHAR,								EVT_CHAR,						KeyEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LISTBOX_SELECTED,			EVT_LISTBOX,					CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LISTBOX_DOUBLECLICKED,		EVT_LISTBOX_DCLICK,				CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_BEGIN_DRAG,				EVT_LIST_BEGIN_DRAG,			ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_BEGIN_RDRAG,			EVT_LIST_BEGIN_RDRAG,			ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_BEGIN_LABEL_EDIT,		EVT_LIST_BEGIN_LABEL_EDIT,		ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_END_LABEL_EDIT,			EVT_LIST_END_LABEL_EDIT,		ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_DELETE_ITEM,			EVT_LIST_DELETE_ITEM,			ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_DELETE_ALL_ITEMS,		EVT_LIST_DELETE_ALL_ITEMS,		ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_ITEM_SELECTED,			EVT_LIST_ITEM_SELECTED,			ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_ITEM_DESELECTED,		EVT_LIST_ITEM_DESELECTED,		ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_ITEM_ACTIVATED,			EVT_LIST_ITEM_ACTIVATED,		ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_ITEM_FOCUSED,			EVT_LIST_ITEM_FOCUSED,			ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_ITEM_MIDDLE_CLICK,		EVT_LIST_ITEM_MIDDLE_CLICK,		ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_ITEM_RIGHT_CLICK,		EVT_LIST_ITEM_RIGHT_CLICK,		ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_KEY_DOWN,				EVT_LIST_KEY_DOWN,				ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_INSERT_ITEM,			EVT_LIST_INSERT_ITEM,			ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_COL_CLICK,				EVT_LIST_COL_CLICK,				ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_COL_RIGHT_CLICK,		EVT_LIST_COL_RIGHT_CLICK,		ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_COL_BEGIN_DRAG,			EVT_LIST_COL_BEGIN_DRAG,		ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_COL_DRAGGING,			EVT_LIST_COL_DRAGGING,			ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_COL_END_DRAG,			EVT_LIST_COL_END_DRAG,			ListEvent);
	Gura_AssignWxEvent(EVT_COMMAND_LIST_CACHE_HINT,				EVT_LIST_CACHE_HINT,			ListEvent);
	Gura_AssignWxEvent(EVT_MAXIMIZE,							EVT_MAXIMIZE,					MaximizeEvent);
	Gura_AssignWxEvent(EVT_MENU_OPEN,							EVT_MENU_OPEN,					MenuEvent);
	Gura_AssignWxEvent(EVT_MENU_CLOSE,							EVT_MENU_CLOSE,					MenuEvent);
	Gura_AssignWxEvent(EVT_MENU_HIGHLIGHT,						EVT_MENU_HIGHLIGHT,				MenuEvent);
	Gura_AssignWxEvent(EVT_ENTER_WINDOW,						EVT_ENTER_WINDOW,				MouseEvent);
	Gura_AssignWxEvent(EVT_LEAVE_WINDOW,						EVT_LEAVE_WINDOW,				MouseEvent);
	Gura_AssignWxEvent(EVT_LEFT_DOWN,							EVT_LEFT_DOWN,					MouseEvent);
	Gura_AssignWxEvent(EVT_LEFT_UP,								EVT_LEFT_UP,					MouseEvent);
	Gura_AssignWxEvent(EVT_LEFT_DCLICK,							EVT_LEFT_DCLICK,				MouseEvent);
	Gura_AssignWxEvent(EVT_MIDDLE_DOWN,							EVT_MIDDLE_DOWN,				MouseEvent);
	Gura_AssignWxEvent(EVT_MIDDLE_UP,							EVT_MIDDLE_UP,					MouseEvent);
	Gura_AssignWxEvent(EVT_MIDDLE_DCLICK,						EVT_MIDDLE_DCLICK,				MouseEvent);
	Gura_AssignWxEvent(EVT_RIGHT_DOWN,							EVT_RIGHT_DOWN,					MouseEvent);
	Gura_AssignWxEvent(EVT_RIGHT_UP,							EVT_RIGHT_UP,					MouseEvent);
	Gura_AssignWxEvent(EVT_RIGHT_DCLICK,						EVT_RIGHT_DCLICK,				MouseEvent);
	Gura_AssignWxEvent(EVT_MOTION,								EVT_MOTION,						MouseEvent);
	Gura_AssignWxEvent(EVT_MOUSEWHEEL,							EVT_MOUSEWHEEL,					MouseEvent);
	Gura_AssignWxEvent(EVT_MOVE,								EVT_MOVE,						MoveEvent);
	Gura_AssignWxEvent(EVT_COMMAND_NOTEBOOK_PAGE_CHANGED,		EVT_NOTEBOOK_PAGE_CHANGED,		NotebookEvent);
	Gura_AssignWxEvent(EVT_COMMAND_NOTEBOOK_PAGE_CHANGING,		EVT_NOTEBOOK_PAGE_CHANGING,		NotebookEvent);
	Gura_AssignWxEvent(EVT_PAINT,								EVT_PAINT,						PaintEvent);
	Gura_AssignWxEvent(EVT_QUERY_LAYOUT_INFO,					EVT_QUERY_LAYOUT_INFO,			QueryLayoutInfoEvent);
	Gura_AssignWxEvent(EVT_COMMAND_RADIOBOX_SELECTED,			EVT_RADIOBOX,					CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_RADIOBUTTON_SELECTED,		EVT_RADIOBUTTON,				CommandEvent);
	Gura_AssignWxEvent(EVT_SASH_DRAGGED,						EVT_SASH_DRAGGED,				SashEvent);
	Gura_AssignWxEvent(EVT_SASH_DRAGGED,						EVT_SASH_DRAGGED_RANGE,			SashEvent);
	Gura_AssignWxEvent(EVT_COMMAND_SCROLLBAR_UPDATED,			EVT_SCROLLBAR,					CommandEvent);
	Gura_AssignWxEvent(EVT_NULL,								EVT_SCROLL,						ScrollEvent);
	Gura_AssignWxEvent(EVT_SCROLL_TOP,							EVT_SCROLL_TOP,					ScrollEvent);
	Gura_AssignWxEvent(EVT_SCROLL_BOTTOM,						EVT_SCROLL_BOTTOM,				ScrollEvent);
	Gura_AssignWxEvent(EVT_SCROLL_LINEUP,						EVT_SCROLL_LINEUP,				ScrollEvent);
	Gura_AssignWxEvent(EVT_SCROLL_LINEDOWN,						EVT_SCROLL_LINEDOWN,			ScrollEvent);
	Gura_AssignWxEvent(EVT_SCROLL_PAGEUP,						EVT_SCROLL_PAGEUP,				ScrollEvent);
	Gura_AssignWxEvent(EVT_SCROLL_PAGEDOWN,						EVT_SCROLL_PAGEDOWN,			ScrollEvent);
	Gura_AssignWxEvent(EVT_SCROLL_THUMBTRACK,					EVT_SCROLL_THUMBTRACK,			ScrollEvent);
	Gura_AssignWxEvent(EVT_SCROLL_THUMBRELEASE,					EVT_SCROLL_THUMBRELEASE,		ScrollEvent);
	Gura_AssignWxEvent(EVT_SCROLL_CHANGED,						EVT_SCROLL_CHANGED,				ScrollEvent);
	Gura_AssignWxEvent(EVT_NULL,								EVT_SCROLLWIN,					ScrollWinEvent);
	Gura_AssignWxEvent(EVT_SCROLLWIN_TOP,						EVT_SCROLLWIN_TOP,				ScrollWinEvent);
	Gura_AssignWxEvent(EVT_SCROLLWIN_BOTTOM,					EVT_SCROLLWIN_BOTTOM,			ScrollWinEvent);
	Gura_AssignWxEvent(EVT_SCROLLWIN_LINEUP,					EVT_SCROLLWIN_LINEUP,			ScrollWinEvent);
	Gura_AssignWxEvent(EVT_SCROLLWIN_LINEDOWN,					EVT_SCROLLWIN_LINEDOWN,			ScrollWinEvent);
	Gura_AssignWxEvent(EVT_SCROLLWIN_PAGEUP,					EVT_SCROLLWIN_PAGEUP,			ScrollWinEvent);
	Gura_AssignWxEvent(EVT_SCROLLWIN_PAGEDOWN,					EVT_SCROLLWIN_PAGEDOWN,			ScrollWinEvent);
	Gura_AssignWxEvent(EVT_SCROLLWIN_THUMBTRACK,				EVT_SCROLLWIN_THUMBTRACK,		ScrollWinEvent);
	Gura_AssignWxEvent(EVT_SCROLLWIN_THUMBRELEASE,				EVT_SCROLLWIN_THUMBRELEASE,		ScrollWinEvent);
//	Gura_AssignWxEvent(EVT_SCROLLWIN_CHANGED,					EVT_SCROLLWIN_CHANGED,			ScrollWinEvent);
	Gura_AssignWxEvent(EVT_COMMAND_SEARCHCTRL_SEARCH_BTN,		EVT_SEARCHCTRL_SEARCH_BTN,		CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_SEARCHCTRL_CANCEL_BTN,		EVT_SEARCHCTRL_CANCEL_BTN,		CommandEvent);
	Gura_AssignWxEvent(EVT_SET_CURSOR,							EVT_SET_CURSOR,					SetCursorEvent);
	Gura_AssignWxEvent(EVT_SIZE,								EVT_SIZE,						SizeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_SLIDER_UPDATED,				EVT_SLIDER,						CommandEvent);
	Gura_AssignWxEvent(EVT_SCROLL_THUMBTRACK,					EVT_SPIN,						SpinEvent);
	Gura_AssignWxEvent(EVT_SCROLL_LINEUP,						EVT_SPIN_UP,					SpinEvent);
	Gura_AssignWxEvent(EVT_SCROLL_LINEDOWN,						EVT_SPIN_DOWN,					SpinEvent);
	Gura_AssignWxEvent(EVT_COMMAND_SPINCTRL_UPDATED,			EVT_SPINCTRL,					SpinEvent);
	Gura_AssignWxEvent(EVT_COMMAND_SPINCTRL_UPDATED,			EVT_SPINCTRL,					CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_SPLITTER_SASH_POS_CHANGING,	EVT_SPLITTER_SASH_POS_CHANGING,	SplitterEvent);
	Gura_AssignWxEvent(EVT_COMMAND_SPLITTER_SASH_POS_CHANGED,	EVT_SPLITTER_SASH_POS_CHANGED,	SplitterEvent);
	Gura_AssignWxEvent(EVT_COMMAND_SPLITTER_UNSPLIT,			EVT_SPLITTER_UNSPLIT,			SplitterEvent);
	Gura_AssignWxEvent(EVT_COMMAND_SPLITTER_DOUBLECLICKED,		EVT_SPLITTER_DCLICK,			SplitterEvent);
	Gura_AssignWxEvent(EVT_SYS_COLOUR_CHANGED,					EVT_SYS_COLOUR_CHANGED,			SysColourChangedEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TEXT_UPDATED,				EVT_TEXT,						CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TEXT_ENTER,					EVT_TEXT_ENTER,					CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TEXT_URL,					EVT_TEXT_URL,					CommandEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TEXT_MAXLEN,					EVT_TEXT_MAXLEN,				CommandEvent);
	Gura_AssignWxEvent(EVT_TIMER,								EVT_TIMER,						TimerEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREEBOOK_PAGE_CHANGED,		EVT_TREEBOOK_PAGE_CHANGED,		TreebookEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREEBOOK_PAGE_CHANGING,		EVT_TREEBOOK_PAGE_CHANGING,		TreebookEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREEBOOK_NODE_COLLAPSED,		EVT_TREEBOOK_NODE_COLLAPSED,	TreebookEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREEBOOK_NODE_EXPANDED,		EVT_TREEBOOK_NODE_EXPANDED,		TreebookEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_BEGIN_DRAG,				EVT_TREE_BEGIN_DRAG,			TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_BEGIN_RDRAG,			EVT_TREE_BEGIN_RDRAG,			TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_BEGIN_LABEL_EDIT,		EVT_TREE_BEGIN_LABEL_EDIT,		TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_END_DRAG,				EVT_TREE_END_DRAG,				TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_END_LABEL_EDIT,			EVT_TREE_END_LABEL_EDIT,		TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_DELETE_ITEM,			EVT_TREE_DELETE_ITEM,			TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_ITEM_ACTIVATED,			EVT_TREE_ITEM_ACTIVATED,		TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_ITEM_COLLAPSED,			EVT_TREE_ITEM_COLLAPSED,		TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_ITEM_COLLAPSING,		EVT_TREE_ITEM_COLLAPSING,		TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_ITEM_EXPANDED,			EVT_TREE_ITEM_EXPANDED,			TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_ITEM_EXPANDING,			EVT_TREE_ITEM_EXPANDING,		TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_ITEM_RIGHT_CLICK,		EVT_TREE_ITEM_RIGHT_CLICK,		TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_ITEM_MIDDLE_CLICK,		EVT_TREE_ITEM_MIDDLE_CLICK,		TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_KEY_DOWN,				EVT_TREE_KEY_DOWN,				TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_SEL_CHANGED,			EVT_TREE_SEL_CHANGED,			TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_SEL_CHANGING,			EVT_TREE_SEL_CHANGING,			TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_ITEM_GETTOOLTIP,		EVT_TREE_ITEM_GETTOOLTIP,		TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_ITEM_MENU,				EVT_TREE_ITEM_MENU,				TreeEvent);
	Gura_AssignWxEvent(EVT_COMMAND_TREE_STATE_IMAGE_CLICK,		EVT_TREE_STATE_IMAGE_CLICK,		TreeEvent);
	Gura_AssignWxEvent(EVT_CREATE,								EVT_WINDOW_CREATE,				WindowCreateEvent);
	Gura_AssignWxEvent(EVT_DESTROY,								EVT_WINDOW_DESTROY,				WindowDestroyEvent);
	do {
		Gura_AssignWxObjectEx(NullColour,		&wxNullColour,	Colour);
		Gura_AssignWxObject(BLACK,								Colour);
		Gura_AssignWxObject(WHITE,								Colour);
		Gura_AssignWxObject(RED,								Colour);
		Gura_AssignWxObject(BLUE,								Colour);
		Gura_AssignWxObject(GREEN,								Colour);
		Gura_AssignWxObject(CYAN,								Colour);
		Gura_AssignWxObject(LIGHT_GREY,							Colour);
	} while (0);
	do {
		Gura_AssignWxObjectEx(NullPen,			&wxNullPen,		Pen);
		Gura_AssignWxObject(RED_PEN,							Pen);
		Gura_AssignWxObject(CYAN_PEN,							Pen);
		Gura_AssignWxObject(GREEN_PEN,							Pen);
		Gura_AssignWxObject(BLACK_PEN,							Pen);
		Gura_AssignWxObject(WHITE_PEN,							Pen);
		Gura_AssignWxObject(TRANSPARENT_PEN,					Pen);
		Gura_AssignWxObject(BLACK_DASHED_PEN,					Pen);
		Gura_AssignWxObject(GREY_PEN,							Pen);
		Gura_AssignWxObject(MEDIUM_GREY_PEN,					Pen);
		Gura_AssignWxObject(LIGHT_GREY_PEN,						Pen);
	} while (0);
	do {
		Gura_AssignWxObjectEx(NullBrush,		&wxNullBrush,	Brush);
		Gura_AssignWxObject(BLUE_BRUSH,							Brush);
		Gura_AssignWxObject(GREEN_BRUSH,						Brush);
		Gura_AssignWxObject(WHITE_BRUSH,						Brush);
		Gura_AssignWxObject(BLACK_BRUSH,						Brush);
		Gura_AssignWxObject(GREY_BRUSH,							Brush);
		Gura_AssignWxObject(MEDIUM_GREY_BRUSH,					Brush);
		Gura_AssignWxObject(LIGHT_GREY_BRUSH,					Brush);
		Gura_AssignWxObject(TRANSPARENT_BRUSH,					Brush);
		Gura_AssignWxObject(CYAN_BRUSH,							Brush);
		Gura_AssignWxObject(RED_BRUSH,							Brush);
	} while (0);
	do {
		Gura_AssignWxObjectEx(NullFont,			&wxNullFont,	Font);
		Gura_AssignWxObject(NORMAL_FONT,						Font);
		Gura_AssignWxObject(SMALL_FONT,							Font);
		Gura_AssignWxObject(ITALIC_FONT,						Font);
		Gura_AssignWxObject(SWISS_FONT,							Font);
	} while (0);
	do {
		Gura_AssignWxObjectEx(NullBitmap,		&wxNullBitmap,	Bitmap);
	} while (0);
	do {
		Gura_AssignWxObjectEx(NullIcon,			&wxNullIcon,	Icon);
	} while (0);
	do {
		Gura_AssignWxObjectEx(NullPalette,		&wxNullPalette,	Palette);
	} while (0);
	do {
		Gura_AssignWxObjectEx(NullCursor,		&wxNullCursor,	Cursor);
		Gura_AssignWxObject(STANDARD_CURSOR,					Cursor);
		Gura_AssignWxObject(HOURGLASS_CURSOR,					Cursor);
		Gura_AssignWxObject(CROSS_CURSOR,						Cursor);
	} while (0);
}

Gura_ModuleTerminate()
{
}

//-----------------------------------------------------------------------------
// EventHandlerPack
//-----------------------------------------------------------------------------
void EventHandlerPack::Eval(wxEvent &event)
{
	Object_wx_Event *pObj = _pEventFactory->CreateEventObject(event);
	ValueList valList;
	valList.push_back(Value(pObj));
	Args args(valList);
	_pFunc->Eval(_env, _sig, args);
}

//-----------------------------------------------------------------------------
// utility functions
//-----------------------------------------------------------------------------
void SetError_NotImplemented(Signal sig)
{
	sig.SetError(ERR_NotImplementedError, "sorry, not yet implemented");
}

void SetError_InvalidWxObject(Signal sig, const char *name)
{
	sig.SetError(ERR_ValueError, "invalid wx object of %s", name);
}

int *CreateListOfInt(const ValueList &valList)
{
	int *buff = new int [valList.size()];
	size_t i = 0;
	foreach_const (ValueList, pValue, valList) {
		buff[i++] = pValue->GetInt();
	}
	return buff;
}

wxString *CreateListOfString(const ValueList &valList)
{
	wxString *buff = new wxString [valList.size()];
	size_t i = 0;
	foreach_const (ValueList, pValue, valList) {
		buff[i++] = wxString::FromUTF8(pValue->GetString());
	}
	return buff;
}

wxDash *CreateListOfDash(const ValueList &valList)
{
	wxDash *buff = new wxDash [valList.size()];
	size_t i = 0;
	foreach_const (ValueList, pValue, valList) {
		buff[i++] = static_cast<wxDash>(pValue->GetInt());
	}
	return buff;
}

wxPoint *CreateListOfPoint(const ValueList &valList)
{
	wxPoint *buff = new wxPoint [valList.size()];
	size_t i = 0;
	foreach_const (ValueList, pValue, valList) {
		buff[i++] = *Object_wx_Point::GetObject(*pValue)->GetEntity();
	}
	return buff;
}

wxArrayString *CreateArrayString(const ValueList &valList)
{
	wxArrayString *pArray = new wxArrayString();
	AddToArrayString(*pArray, valList);
	return pArray;
}

wxArrayInt *CreateArrayInt(const ValueList &valList)
{
	wxArrayInt *pArray = new wxArrayInt();
	AddToArrayInt(*pArray, valList);
	return pArray;
}

Value ArrayIntToValue(Environment &env, const wxArrayInt &array)
{
	Value rtn;
	ValueList &valList = rtn.InitAsList(env);
	valList.reserve(array.GetCount());
	for (size_t i = 0; i < array.GetCount(); i++) {
		valList.push_back(Value(array.Item(i)));
	}
	return rtn;
}

Value ArrayStringToValue(Environment &env, const wxArrayString &array)
{
	Value rtn;
	ValueList &valList = rtn.InitAsList(env);
	valList.reserve(array.GetCount());
	for (size_t i = 0; i < array.GetCount(); i++) {
		valList.push_back(Value(env, array.Item(i).ToUTF8()));
	}
	return rtn;
}

Value ArrayStringToValue(Environment &env, const wxString *array, int n)
{
	Value rtn;
	ValueList &valList = rtn.InitAsList(env);
	valList.reserve(n);
	for (int i = 0; i < n; i++) {
		valList.push_back(Value(env, array[i].ToUTF8()));
	}
	return rtn;
}

void AddToArrayString(wxArrayString &array, const ValueList &valList)
{
	foreach_const (ValueList, pValue, valList) {
		array.Add(wxString::FromUTF8(pValue->GetString()));
	}
}

void AddToArrayInt(wxArrayInt &array, const ValueList &valList)
{
	foreach_const (ValueList, pValue, valList) {
		array.Add(pValue->GetInt());
	}
}

Gura_EndModule(wx, wx)

Gura_RegisterModule(wx)
