#pragma once
#include <math.h>
#include "GVONavish.h"




// ȈՓ񎟌xNg
class GVOVector {
private:
	double m_x;
	double m_y;
	double m_length;

public:
	GVOVector() :
		m_x(),
		m_y(),
		m_length()
	{
	}
	GVOVector( const double x, const double y ) :
		m_x( x ),
		m_y( y ),
		m_length( calcLength( x, y ) )
	{
	}

	// EW2_xNgZoB
	// XE̔ȏ㗣ĂƋtŃxNgB
	// i~̋߂̗̋pj
	GVOVector( const POINT& p1, const POINT& p2 ) :
		m_x(),
		m_y(),
		m_length()
	{
		const LONG k_threshold = k_worldWidth / 2;
		LONG dx = p2.x - p1.x;

		if ( k_threshold < dx ) {
			dx -= k_worldWidth;
		}
		else if ( dx < -k_threshold ) {
			dx += k_worldWidth;
		}
		m_x = dx;
		m_y = p2.y - p1.y;
		m_length = calcLength( m_x, m_y );
	}

	// xNgx
	inline double x() const
	{
		return m_x;
	}

	// xNgy
	inline double y() const
	{
		return m_y;
	}

	// xNg
	inline double length() const
	{
		return m_length;
	}

	// PʃxNgԂ
	inline GVOVector normalizedVector() const
	{
		return normalizedVector( length() );
	}

	// Cӂ̒ŃxNg𐳋K
	inline GVOVector normalizedVector( const double norm ) const
	{
		GVOVector v( m_x, m_y );
		const double length = v.length();
		v.m_x = (v.m_x / length) * norm;
		v.m_y = (v.m_y / length) * norm;
		v.m_length = norm;
		return v;
	}

	// Q̃xNg̊px
	inline double angleTo( const GVOVector& other )const
	{
		return ::atan2( other.m_x * m_y - m_x * other.m_y, m_x * other.m_x + m_y * other.m_y );
	}

	// xNg
	inline void composite( const GVOVector& other )
	{
		m_x += other.m_x;
		m_y += other.m_y;
		m_length = calcLength( m_x, m_y );
	}

	//!@brief _ƃxNgw肵čW𓾂
	POINT pointFromOriginWithLength( const POINT& origin, const LONG length ) const
	{
		GVOVector v = normalizedVector();
		const POINT p = {
			origin.x + LONG( v.x() * length ),
			origin.y + LONG( v.y() * length )
		};
		return p;
	}
private:
	// xNgvZ
	static inline double calcLength(const double x, const double y)
	{
		return ::pow( x * x + y * y, 0.5 );
	}

};
